// export by github.com/goplus/igop/cmd/qexp

//go:build go1.20
// +build go1.20

package os

import (
	q "os"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "os",
		Path: "os",
		Deps: map[string]string{
			"errors":                   "errors",
			"internal/itoa":            "itoa",
			"internal/poll":            "poll",
			"internal/safefilepath":    "safefilepath",
			"internal/syscall/execenv": "execenv",
			"internal/syscall/unix":    "unix",
			"internal/testlog":         "testlog",
			"io":                       "io",
			"io/fs":                    "fs",
			"runtime":                  "runtime",
			"sort":                     "sort",
			"sync":                     "sync",
			"sync/atomic":              "atomic",
			"syscall":                  "syscall",
			"time":                     "time",
			"unsafe":                   "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Signal": reflect.TypeOf((*q.Signal)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"File":         reflect.TypeOf((*q.File)(nil)).Elem(),
			"LinkError":    reflect.TypeOf((*q.LinkError)(nil)).Elem(),
			"ProcAttr":     reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"Process":      reflect.TypeOf((*q.Process)(nil)).Elem(),
			"ProcessState": reflect.TypeOf((*q.ProcessState)(nil)).Elem(),
			"SyscallError": reflect.TypeOf((*q.SyscallError)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{
			"DirEntry":  reflect.TypeOf((*q.DirEntry)(nil)).Elem(),
			"FileInfo":  reflect.TypeOf((*q.FileInfo)(nil)).Elem(),
			"FileMode":  reflect.TypeOf((*q.FileMode)(nil)).Elem(),
			"PathError": reflect.TypeOf((*q.PathError)(nil)).Elem(),
		},
		Vars: map[string]reflect.Value{
			"Args":                reflect.ValueOf(&q.Args),
			"ErrClosed":           reflect.ValueOf(&q.ErrClosed),
			"ErrDeadlineExceeded": reflect.ValueOf(&q.ErrDeadlineExceeded),
			"ErrExist":            reflect.ValueOf(&q.ErrExist),
			"ErrInvalid":          reflect.ValueOf(&q.ErrInvalid),
			"ErrNoDeadline":       reflect.ValueOf(&q.ErrNoDeadline),
			"ErrNotExist":         reflect.ValueOf(&q.ErrNotExist),
			"ErrPermission":       reflect.ValueOf(&q.ErrPermission),
			"ErrProcessDone":      reflect.ValueOf(&q.ErrProcessDone),
			"Interrupt":           reflect.ValueOf(&q.Interrupt),
			"Kill":                reflect.ValueOf(&q.Kill),
			"Stderr":              reflect.ValueOf(&q.Stderr),
			"Stdin":               reflect.ValueOf(&q.Stdin),
			"Stdout":              reflect.ValueOf(&q.Stdout),
		},
		Funcs: map[string]reflect.Value{
			"Chdir":           reflect.ValueOf(q.Chdir),
			"Chmod":           reflect.ValueOf(q.Chmod),
			"Chown":           reflect.ValueOf(q.Chown),
			"Chtimes":         reflect.ValueOf(q.Chtimes),
			"Clearenv":        reflect.ValueOf(q.Clearenv),
			"Create":          reflect.ValueOf(q.Create),
			"CreateTemp":      reflect.ValueOf(q.CreateTemp),
			"DirFS":           reflect.ValueOf(q.DirFS),
			"Environ":         reflect.ValueOf(q.Environ),
			"Executable":      reflect.ValueOf(q.Executable),
			"Exit":            reflect.ValueOf(q.Exit),
			"Expand":          reflect.ValueOf(q.Expand),
			"ExpandEnv":       reflect.ValueOf(q.ExpandEnv),
			"FindProcess":     reflect.ValueOf(q.FindProcess),
			"Getegid":         reflect.ValueOf(q.Getegid),
			"Getenv":          reflect.ValueOf(q.Getenv),
			"Geteuid":         reflect.ValueOf(q.Geteuid),
			"Getgid":          reflect.ValueOf(q.Getgid),
			"Getgroups":       reflect.ValueOf(q.Getgroups),
			"Getpagesize":     reflect.ValueOf(q.Getpagesize),
			"Getpid":          reflect.ValueOf(q.Getpid),
			"Getppid":         reflect.ValueOf(q.Getppid),
			"Getuid":          reflect.ValueOf(q.Getuid),
			"Getwd":           reflect.ValueOf(q.Getwd),
			"Hostname":        reflect.ValueOf(q.Hostname),
			"IsExist":         reflect.ValueOf(q.IsExist),
			"IsNotExist":      reflect.ValueOf(q.IsNotExist),
			"IsPathSeparator": reflect.ValueOf(q.IsPathSeparator),
			"IsPermission":    reflect.ValueOf(q.IsPermission),
			"IsTimeout":       reflect.ValueOf(q.IsTimeout),
			"Lchown":          reflect.ValueOf(q.Lchown),
			"Link":            reflect.ValueOf(q.Link),
			"LookupEnv":       reflect.ValueOf(q.LookupEnv),
			"Lstat":           reflect.ValueOf(q.Lstat),
			"Mkdir":           reflect.ValueOf(q.Mkdir),
			"MkdirAll":        reflect.ValueOf(q.MkdirAll),
			"MkdirTemp":       reflect.ValueOf(q.MkdirTemp),
			"NewFile":         reflect.ValueOf(q.NewFile),
			"NewSyscallError": reflect.ValueOf(q.NewSyscallError),
			"Open":            reflect.ValueOf(q.Open),
			"OpenFile":        reflect.ValueOf(q.OpenFile),
			"Pipe":            reflect.ValueOf(q.Pipe),
			"ReadDir":         reflect.ValueOf(q.ReadDir),
			"ReadFile":        reflect.ValueOf(q.ReadFile),
			"Readlink":        reflect.ValueOf(q.Readlink),
			"Remove":          reflect.ValueOf(q.Remove),
			"RemoveAll":       reflect.ValueOf(q.RemoveAll),
			"Rename":          reflect.ValueOf(q.Rename),
			"SameFile":        reflect.ValueOf(q.SameFile),
			"Setenv":          reflect.ValueOf(q.Setenv),
			"StartProcess":    reflect.ValueOf(q.StartProcess),
			"Stat":            reflect.ValueOf(q.Stat),
			"Symlink":         reflect.ValueOf(q.Symlink),
			"TempDir":         reflect.ValueOf(q.TempDir),
			"Truncate":        reflect.ValueOf(q.Truncate),
			"Unsetenv":        reflect.ValueOf(q.Unsetenv),
			"UserCacheDir":    reflect.ValueOf(q.UserCacheDir),
			"UserConfigDir":   reflect.ValueOf(q.UserConfigDir),
			"UserHomeDir":     reflect.ValueOf(q.UserHomeDir),
			"WriteFile":       reflect.ValueOf(q.WriteFile),
		},
		TypedConsts: map[string]igop.TypedConst{
			"ModeAppend":     {reflect.TypeOf(q.ModeAppend), constant.MakeInt64(int64(q.ModeAppend))},
			"ModeCharDevice": {reflect.TypeOf(q.ModeCharDevice), constant.MakeInt64(int64(q.ModeCharDevice))},
			"ModeDevice":     {reflect.TypeOf(q.ModeDevice), constant.MakeInt64(int64(q.ModeDevice))},
			"ModeDir":        {reflect.TypeOf(q.ModeDir), constant.MakeInt64(int64(q.ModeDir))},
			"ModeExclusive":  {reflect.TypeOf(q.ModeExclusive), constant.MakeInt64(int64(q.ModeExclusive))},
			"ModeIrregular":  {reflect.TypeOf(q.ModeIrregular), constant.MakeInt64(int64(q.ModeIrregular))},
			"ModeNamedPipe":  {reflect.TypeOf(q.ModeNamedPipe), constant.MakeInt64(int64(q.ModeNamedPipe))},
			"ModePerm":       {reflect.TypeOf(q.ModePerm), constant.MakeInt64(int64(q.ModePerm))},
			"ModeSetgid":     {reflect.TypeOf(q.ModeSetgid), constant.MakeInt64(int64(q.ModeSetgid))},
			"ModeSetuid":     {reflect.TypeOf(q.ModeSetuid), constant.MakeInt64(int64(q.ModeSetuid))},
			"ModeSocket":     {reflect.TypeOf(q.ModeSocket), constant.MakeInt64(int64(q.ModeSocket))},
			"ModeSticky":     {reflect.TypeOf(q.ModeSticky), constant.MakeInt64(int64(q.ModeSticky))},
			"ModeSymlink":    {reflect.TypeOf(q.ModeSymlink), constant.MakeInt64(int64(q.ModeSymlink))},
			"ModeTemporary":  {reflect.TypeOf(q.ModeTemporary), constant.MakeInt64(int64(q.ModeTemporary))},
			"ModeType":       {reflect.TypeOf(q.ModeType), constant.MakeInt64(int64(q.ModeType))},
			"O_APPEND":       {reflect.TypeOf(q.O_APPEND), constant.MakeInt64(int64(q.O_APPEND))},
			"O_CREATE":       {reflect.TypeOf(q.O_CREATE), constant.MakeInt64(int64(q.O_CREATE))},
			"O_EXCL":         {reflect.TypeOf(q.O_EXCL), constant.MakeInt64(int64(q.O_EXCL))},
			"O_RDONLY":       {reflect.TypeOf(q.O_RDONLY), constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":         {reflect.TypeOf(q.O_RDWR), constant.MakeInt64(int64(q.O_RDWR))},
			"O_SYNC":         {reflect.TypeOf(q.O_SYNC), constant.MakeInt64(int64(q.O_SYNC))},
			"O_TRUNC":        {reflect.TypeOf(q.O_TRUNC), constant.MakeInt64(int64(q.O_TRUNC))},
			"O_WRONLY":       {reflect.TypeOf(q.O_WRONLY), constant.MakeInt64(int64(q.O_WRONLY))},
			"SEEK_CUR":       {reflect.TypeOf(q.SEEK_CUR), constant.MakeInt64(int64(q.SEEK_CUR))},
			"SEEK_END":       {reflect.TypeOf(q.SEEK_END), constant.MakeInt64(int64(q.SEEK_END))},
			"SEEK_SET":       {reflect.TypeOf(q.SEEK_SET), constant.MakeInt64(int64(q.SEEK_SET))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"DevNull":           {"untyped string", constant.MakeString(string(q.DevNull))},
			"PathListSeparator": {"untyped rune", constant.MakeInt64(int64(q.PathListSeparator))},
			"PathSeparator":     {"untyped rune", constant.MakeInt64(int64(q.PathSeparator))},
		},
	})
}
