// export by github.com/goplus/igop/cmd/qexp

//go:build go1.15 && !go1.16
// +build go1.15,!go1.16

package syscall

import (
	q "syscall"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "syscall",
		Path: "syscall",
		Deps: map[string]string{
			"errors":                "errors",
			"internal/bytealg":      "bytealg",
			"internal/oserror":      "oserror",
			"internal/race":         "race",
			"internal/unsafeheader": "unsafeheader",
			"runtime":               "runtime",
			"sync":                  "sync",
			"unsafe":                "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Conn":     reflect.TypeOf((*q.Conn)(nil)).Elem(),
			"RawConn":  reflect.TypeOf((*q.RawConn)(nil)).Elem(),
			"Sockaddr": reflect.TypeOf((*q.Sockaddr)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"Cmsghdr":              reflect.TypeOf((*q.Cmsghdr)(nil)).Elem(),
			"Credential":           reflect.TypeOf((*q.Credential)(nil)).Elem(),
			"Dirent":               reflect.TypeOf((*q.Dirent)(nil)).Elem(),
			"EpollEvent":           reflect.TypeOf((*q.EpollEvent)(nil)).Elem(),
			"Errno":                reflect.TypeOf((*q.Errno)(nil)).Elem(),
			"FdSet":                reflect.TypeOf((*q.FdSet)(nil)).Elem(),
			"Flock_t":              reflect.TypeOf((*q.Flock_t)(nil)).Elem(),
			"Fsid":                 reflect.TypeOf((*q.Fsid)(nil)).Elem(),
			"ICMPv6Filter":         reflect.TypeOf((*q.ICMPv6Filter)(nil)).Elem(),
			"IPMreq":               reflect.TypeOf((*q.IPMreq)(nil)).Elem(),
			"IPMreqn":              reflect.TypeOf((*q.IPMreqn)(nil)).Elem(),
			"IPv6MTUInfo":          reflect.TypeOf((*q.IPv6MTUInfo)(nil)).Elem(),
			"IPv6Mreq":             reflect.TypeOf((*q.IPv6Mreq)(nil)).Elem(),
			"IfAddrmsg":            reflect.TypeOf((*q.IfAddrmsg)(nil)).Elem(),
			"IfInfomsg":            reflect.TypeOf((*q.IfInfomsg)(nil)).Elem(),
			"Inet4Pktinfo":         reflect.TypeOf((*q.Inet4Pktinfo)(nil)).Elem(),
			"Inet6Pktinfo":         reflect.TypeOf((*q.Inet6Pktinfo)(nil)).Elem(),
			"InotifyEvent":         reflect.TypeOf((*q.InotifyEvent)(nil)).Elem(),
			"Iovec":                reflect.TypeOf((*q.Iovec)(nil)).Elem(),
			"Linger":               reflect.TypeOf((*q.Linger)(nil)).Elem(),
			"Msghdr":               reflect.TypeOf((*q.Msghdr)(nil)).Elem(),
			"NetlinkMessage":       reflect.TypeOf((*q.NetlinkMessage)(nil)).Elem(),
			"NetlinkRouteAttr":     reflect.TypeOf((*q.NetlinkRouteAttr)(nil)).Elem(),
			"NetlinkRouteRequest":  reflect.TypeOf((*q.NetlinkRouteRequest)(nil)).Elem(),
			"NlAttr":               reflect.TypeOf((*q.NlAttr)(nil)).Elem(),
			"NlMsgerr":             reflect.TypeOf((*q.NlMsgerr)(nil)).Elem(),
			"NlMsghdr":             reflect.TypeOf((*q.NlMsghdr)(nil)).Elem(),
			"ProcAttr":             reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"PtraceFpregs":         reflect.TypeOf((*q.PtraceFpregs)(nil)).Elem(),
			"PtracePer":            reflect.TypeOf((*q.PtracePer)(nil)).Elem(),
			"PtracePsw":            reflect.TypeOf((*q.PtracePsw)(nil)).Elem(),
			"PtraceRegs":           reflect.TypeOf((*q.PtraceRegs)(nil)).Elem(),
			"RawSockaddr":          reflect.TypeOf((*q.RawSockaddr)(nil)).Elem(),
			"RawSockaddrAny":       reflect.TypeOf((*q.RawSockaddrAny)(nil)).Elem(),
			"RawSockaddrInet4":     reflect.TypeOf((*q.RawSockaddrInet4)(nil)).Elem(),
			"RawSockaddrInet6":     reflect.TypeOf((*q.RawSockaddrInet6)(nil)).Elem(),
			"RawSockaddrLinklayer": reflect.TypeOf((*q.RawSockaddrLinklayer)(nil)).Elem(),
			"RawSockaddrNetlink":   reflect.TypeOf((*q.RawSockaddrNetlink)(nil)).Elem(),
			"RawSockaddrUnix":      reflect.TypeOf((*q.RawSockaddrUnix)(nil)).Elem(),
			"Rlimit":               reflect.TypeOf((*q.Rlimit)(nil)).Elem(),
			"RtAttr":               reflect.TypeOf((*q.RtAttr)(nil)).Elem(),
			"RtGenmsg":             reflect.TypeOf((*q.RtGenmsg)(nil)).Elem(),
			"RtMsg":                reflect.TypeOf((*q.RtMsg)(nil)).Elem(),
			"RtNexthop":            reflect.TypeOf((*q.RtNexthop)(nil)).Elem(),
			"Rusage":               reflect.TypeOf((*q.Rusage)(nil)).Elem(),
			"Signal":               reflect.TypeOf((*q.Signal)(nil)).Elem(),
			"SockFilter":           reflect.TypeOf((*q.SockFilter)(nil)).Elem(),
			"SockFprog":            reflect.TypeOf((*q.SockFprog)(nil)).Elem(),
			"SockaddrInet4":        reflect.TypeOf((*q.SockaddrInet4)(nil)).Elem(),
			"SockaddrInet6":        reflect.TypeOf((*q.SockaddrInet6)(nil)).Elem(),
			"SockaddrLinklayer":    reflect.TypeOf((*q.SockaddrLinklayer)(nil)).Elem(),
			"SockaddrNetlink":      reflect.TypeOf((*q.SockaddrNetlink)(nil)).Elem(),
			"SockaddrUnix":         reflect.TypeOf((*q.SockaddrUnix)(nil)).Elem(),
			"SocketControlMessage": reflect.TypeOf((*q.SocketControlMessage)(nil)).Elem(),
			"Stat_t":               reflect.TypeOf((*q.Stat_t)(nil)).Elem(),
			"Statfs_t":             reflect.TypeOf((*q.Statfs_t)(nil)).Elem(),
			"SysProcAttr":          reflect.TypeOf((*q.SysProcAttr)(nil)).Elem(),
			"SysProcIDMap":         reflect.TypeOf((*q.SysProcIDMap)(nil)).Elem(),
			"Sysinfo_t":            reflect.TypeOf((*q.Sysinfo_t)(nil)).Elem(),
			"TCPInfo":              reflect.TypeOf((*q.TCPInfo)(nil)).Elem(),
			"Termios":              reflect.TypeOf((*q.Termios)(nil)).Elem(),
			"Time_t":               reflect.TypeOf((*q.Time_t)(nil)).Elem(),
			"Timespec":             reflect.TypeOf((*q.Timespec)(nil)).Elem(),
			"Timeval":              reflect.TypeOf((*q.Timeval)(nil)).Elem(),
			"Timex":                reflect.TypeOf((*q.Timex)(nil)).Elem(),
			"Tms":                  reflect.TypeOf((*q.Tms)(nil)).Elem(),
			"Ucred":                reflect.TypeOf((*q.Ucred)(nil)).Elem(),
			"Ustat_t":              reflect.TypeOf((*q.Ustat_t)(nil)).Elem(),
			"Utimbuf":              reflect.TypeOf((*q.Utimbuf)(nil)).Elem(),
			"Utsname":              reflect.TypeOf((*q.Utsname)(nil)).Elem(),
			"WaitStatus":           reflect.TypeOf((*q.WaitStatus)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ForkLock":          reflect.ValueOf(&q.ForkLock),
			"SocketDisableIPv6": reflect.ValueOf(&q.SocketDisableIPv6),
			"Stderr":            reflect.ValueOf(&q.Stderr),
			"Stdin":             reflect.ValueOf(&q.Stdin),
			"Stdout":            reflect.ValueOf(&q.Stdout),
		},
		Funcs: map[string]reflect.Value{
			"Accept":                    reflect.ValueOf(q.Accept),
			"Accept4":                   reflect.ValueOf(q.Accept4),
			"Access":                    reflect.ValueOf(q.Access),
			"Acct":                      reflect.ValueOf(q.Acct),
			"Adjtimex":                  reflect.ValueOf(q.Adjtimex),
			"AttachLsf":                 reflect.ValueOf(q.AttachLsf),
			"Bind":                      reflect.ValueOf(q.Bind),
			"BindToDevice":              reflect.ValueOf(q.BindToDevice),
			"BytePtrFromString":         reflect.ValueOf(q.BytePtrFromString),
			"ByteSliceFromString":       reflect.ValueOf(q.ByteSliceFromString),
			"Chdir":                     reflect.ValueOf(q.Chdir),
			"Chmod":                     reflect.ValueOf(q.Chmod),
			"Chown":                     reflect.ValueOf(q.Chown),
			"Chroot":                    reflect.ValueOf(q.Chroot),
			"Clearenv":                  reflect.ValueOf(q.Clearenv),
			"Close":                     reflect.ValueOf(q.Close),
			"CloseOnExec":               reflect.ValueOf(q.CloseOnExec),
			"CmsgLen":                   reflect.ValueOf(q.CmsgLen),
			"CmsgSpace":                 reflect.ValueOf(q.CmsgSpace),
			"Connect":                   reflect.ValueOf(q.Connect),
			"Creat":                     reflect.ValueOf(q.Creat),
			"DetachLsf":                 reflect.ValueOf(q.DetachLsf),
			"Dup":                       reflect.ValueOf(q.Dup),
			"Dup2":                      reflect.ValueOf(q.Dup2),
			"Dup3":                      reflect.ValueOf(q.Dup3),
			"Environ":                   reflect.ValueOf(q.Environ),
			"EpollCreate":               reflect.ValueOf(q.EpollCreate),
			"EpollCreate1":              reflect.ValueOf(q.EpollCreate1),
			"EpollCtl":                  reflect.ValueOf(q.EpollCtl),
			"EpollWait":                 reflect.ValueOf(q.EpollWait),
			"Exec":                      reflect.ValueOf(q.Exec),
			"Exit":                      reflect.ValueOf(q.Exit),
			"Faccessat":                 reflect.ValueOf(q.Faccessat),
			"Fallocate":                 reflect.ValueOf(q.Fallocate),
			"Fchdir":                    reflect.ValueOf(q.Fchdir),
			"Fchmod":                    reflect.ValueOf(q.Fchmod),
			"Fchmodat":                  reflect.ValueOf(q.Fchmodat),
			"Fchown":                    reflect.ValueOf(q.Fchown),
			"Fchownat":                  reflect.ValueOf(q.Fchownat),
			"FcntlFlock":                reflect.ValueOf(q.FcntlFlock),
			"Fdatasync":                 reflect.ValueOf(q.Fdatasync),
			"Flock":                     reflect.ValueOf(q.Flock),
			"ForkExec":                  reflect.ValueOf(q.ForkExec),
			"Fstat":                     reflect.ValueOf(q.Fstat),
			"Fstatfs":                   reflect.ValueOf(q.Fstatfs),
			"Fsync":                     reflect.ValueOf(q.Fsync),
			"Ftruncate":                 reflect.ValueOf(q.Ftruncate),
			"Futimes":                   reflect.ValueOf(q.Futimes),
			"Futimesat":                 reflect.ValueOf(q.Futimesat),
			"Getcwd":                    reflect.ValueOf(q.Getcwd),
			"Getdents":                  reflect.ValueOf(q.Getdents),
			"Getegid":                   reflect.ValueOf(q.Getegid),
			"Getenv":                    reflect.ValueOf(q.Getenv),
			"Geteuid":                   reflect.ValueOf(q.Geteuid),
			"Getgid":                    reflect.ValueOf(q.Getgid),
			"Getgroups":                 reflect.ValueOf(q.Getgroups),
			"Getpagesize":               reflect.ValueOf(q.Getpagesize),
			"Getpeername":               reflect.ValueOf(q.Getpeername),
			"Getpgid":                   reflect.ValueOf(q.Getpgid),
			"Getpgrp":                   reflect.ValueOf(q.Getpgrp),
			"Getpid":                    reflect.ValueOf(q.Getpid),
			"Getppid":                   reflect.ValueOf(q.Getppid),
			"Getpriority":               reflect.ValueOf(q.Getpriority),
			"Getrlimit":                 reflect.ValueOf(q.Getrlimit),
			"Getrusage":                 reflect.ValueOf(q.Getrusage),
			"Getsockname":               reflect.ValueOf(q.Getsockname),
			"GetsockoptICMPv6Filter":    reflect.ValueOf(q.GetsockoptICMPv6Filter),
			"GetsockoptIPMreq":          reflect.ValueOf(q.GetsockoptIPMreq),
			"GetsockoptIPMreqn":         reflect.ValueOf(q.GetsockoptIPMreqn),
			"GetsockoptIPv6MTUInfo":     reflect.ValueOf(q.GetsockoptIPv6MTUInfo),
			"GetsockoptIPv6Mreq":        reflect.ValueOf(q.GetsockoptIPv6Mreq),
			"GetsockoptInet4Addr":       reflect.ValueOf(q.GetsockoptInet4Addr),
			"GetsockoptInt":             reflect.ValueOf(q.GetsockoptInt),
			"GetsockoptUcred":           reflect.ValueOf(q.GetsockoptUcred),
			"Gettid":                    reflect.ValueOf(q.Gettid),
			"Gettimeofday":              reflect.ValueOf(q.Gettimeofday),
			"Getuid":                    reflect.ValueOf(q.Getuid),
			"Getwd":                     reflect.ValueOf(q.Getwd),
			"Getxattr":                  reflect.ValueOf(q.Getxattr),
			"InotifyAddWatch":           reflect.ValueOf(q.InotifyAddWatch),
			"InotifyInit":               reflect.ValueOf(q.InotifyInit),
			"InotifyInit1":              reflect.ValueOf(q.InotifyInit1),
			"InotifyRmWatch":            reflect.ValueOf(q.InotifyRmWatch),
			"Kill":                      reflect.ValueOf(q.Kill),
			"Klogctl":                   reflect.ValueOf(q.Klogctl),
			"Lchown":                    reflect.ValueOf(q.Lchown),
			"Link":                      reflect.ValueOf(q.Link),
			"Listen":                    reflect.ValueOf(q.Listen),
			"Listxattr":                 reflect.ValueOf(q.Listxattr),
			"LsfJump":                   reflect.ValueOf(q.LsfJump),
			"LsfSocket":                 reflect.ValueOf(q.LsfSocket),
			"LsfStmt":                   reflect.ValueOf(q.LsfStmt),
			"Lstat":                     reflect.ValueOf(q.Lstat),
			"Madvise":                   reflect.ValueOf(q.Madvise),
			"Mkdir":                     reflect.ValueOf(q.Mkdir),
			"Mkdirat":                   reflect.ValueOf(q.Mkdirat),
			"Mkfifo":                    reflect.ValueOf(q.Mkfifo),
			"Mknod":                     reflect.ValueOf(q.Mknod),
			"Mknodat":                   reflect.ValueOf(q.Mknodat),
			"Mlock":                     reflect.ValueOf(q.Mlock),
			"Mlockall":                  reflect.ValueOf(q.Mlockall),
			"Mmap":                      reflect.ValueOf(q.Mmap),
			"Mount":                     reflect.ValueOf(q.Mount),
			"Mprotect":                  reflect.ValueOf(q.Mprotect),
			"Munlock":                   reflect.ValueOf(q.Munlock),
			"Munlockall":                reflect.ValueOf(q.Munlockall),
			"Munmap":                    reflect.ValueOf(q.Munmap),
			"Nanosleep":                 reflect.ValueOf(q.Nanosleep),
			"NetlinkRIB":                reflect.ValueOf(q.NetlinkRIB),
			"NsecToTimespec":            reflect.ValueOf(q.NsecToTimespec),
			"NsecToTimeval":             reflect.ValueOf(q.NsecToTimeval),
			"Open":                      reflect.ValueOf(q.Open),
			"Openat":                    reflect.ValueOf(q.Openat),
			"ParseDirent":               reflect.ValueOf(q.ParseDirent),
			"ParseNetlinkMessage":       reflect.ValueOf(q.ParseNetlinkMessage),
			"ParseNetlinkRouteAttr":     reflect.ValueOf(q.ParseNetlinkRouteAttr),
			"ParseSocketControlMessage": reflect.ValueOf(q.ParseSocketControlMessage),
			"ParseUnixCredentials":      reflect.ValueOf(q.ParseUnixCredentials),
			"ParseUnixRights":           reflect.ValueOf(q.ParseUnixRights),
			"Pause":                     reflect.ValueOf(q.Pause),
			"Pipe":                      reflect.ValueOf(q.Pipe),
			"Pipe2":                     reflect.ValueOf(q.Pipe2),
			"PivotRoot":                 reflect.ValueOf(q.PivotRoot),
			"Pread":                     reflect.ValueOf(q.Pread),
			"PtraceAttach":              reflect.ValueOf(q.PtraceAttach),
			"PtraceCont":                reflect.ValueOf(q.PtraceCont),
			"PtraceDetach":              reflect.ValueOf(q.PtraceDetach),
			"PtraceGetEventMsg":         reflect.ValueOf(q.PtraceGetEventMsg),
			"PtraceGetRegs":             reflect.ValueOf(q.PtraceGetRegs),
			"PtracePeekData":            reflect.ValueOf(q.PtracePeekData),
			"PtracePeekText":            reflect.ValueOf(q.PtracePeekText),
			"PtracePokeData":            reflect.ValueOf(q.PtracePokeData),
			"PtracePokeText":            reflect.ValueOf(q.PtracePokeText),
			"PtraceSetOptions":          reflect.ValueOf(q.PtraceSetOptions),
			"PtraceSetRegs":             reflect.ValueOf(q.PtraceSetRegs),
			"PtraceSingleStep":          reflect.ValueOf(q.PtraceSingleStep),
			"PtraceSyscall":             reflect.ValueOf(q.PtraceSyscall),
			"Pwrite":                    reflect.ValueOf(q.Pwrite),
			"RawSyscall":                reflect.ValueOf(q.RawSyscall),
			"RawSyscall6":               reflect.ValueOf(q.RawSyscall6),
			"Read":                      reflect.ValueOf(q.Read),
			"ReadDirent":                reflect.ValueOf(q.ReadDirent),
			"Readlink":                  reflect.ValueOf(q.Readlink),
			"Reboot":                    reflect.ValueOf(q.Reboot),
			"Recvfrom":                  reflect.ValueOf(q.Recvfrom),
			"Recvmsg":                   reflect.ValueOf(q.Recvmsg),
			"Removexattr":               reflect.ValueOf(q.Removexattr),
			"Rename":                    reflect.ValueOf(q.Rename),
			"Renameat":                  reflect.ValueOf(q.Renameat),
			"Rmdir":                     reflect.ValueOf(q.Rmdir),
			"Seek":                      reflect.ValueOf(q.Seek),
			"Select":                    reflect.ValueOf(q.Select),
			"Sendfile":                  reflect.ValueOf(q.Sendfile),
			"Sendmsg":                   reflect.ValueOf(q.Sendmsg),
			"SendmsgN":                  reflect.ValueOf(q.SendmsgN),
			"Sendto":                    reflect.ValueOf(q.Sendto),
			"SetLsfPromisc":             reflect.ValueOf(q.SetLsfPromisc),
			"SetNonblock":               reflect.ValueOf(q.SetNonblock),
			"Setdomainname":             reflect.ValueOf(q.Setdomainname),
			"Setenv":                    reflect.ValueOf(q.Setenv),
			"Setfsgid":                  reflect.ValueOf(q.Setfsgid),
			"Setfsuid":                  reflect.ValueOf(q.Setfsuid),
			"Setgid":                    reflect.ValueOf(q.Setgid),
			"Setgroups":                 reflect.ValueOf(q.Setgroups),
			"Sethostname":               reflect.ValueOf(q.Sethostname),
			"Setpgid":                   reflect.ValueOf(q.Setpgid),
			"Setpriority":               reflect.ValueOf(q.Setpriority),
			"Setregid":                  reflect.ValueOf(q.Setregid),
			"Setresgid":                 reflect.ValueOf(q.Setresgid),
			"Setresuid":                 reflect.ValueOf(q.Setresuid),
			"Setreuid":                  reflect.ValueOf(q.Setreuid),
			"Setrlimit":                 reflect.ValueOf(q.Setrlimit),
			"Setsid":                    reflect.ValueOf(q.Setsid),
			"SetsockoptByte":            reflect.ValueOf(q.SetsockoptByte),
			"SetsockoptICMPv6Filter":    reflect.ValueOf(q.SetsockoptICMPv6Filter),
			"SetsockoptIPMreq":          reflect.ValueOf(q.SetsockoptIPMreq),
			"SetsockoptIPMreqn":         reflect.ValueOf(q.SetsockoptIPMreqn),
			"SetsockoptIPv6Mreq":        reflect.ValueOf(q.SetsockoptIPv6Mreq),
			"SetsockoptInet4Addr":       reflect.ValueOf(q.SetsockoptInet4Addr),
			"SetsockoptInt":             reflect.ValueOf(q.SetsockoptInt),
			"SetsockoptLinger":          reflect.ValueOf(q.SetsockoptLinger),
			"SetsockoptString":          reflect.ValueOf(q.SetsockoptString),
			"SetsockoptTimeval":         reflect.ValueOf(q.SetsockoptTimeval),
			"Settimeofday":              reflect.ValueOf(q.Settimeofday),
			"Setuid":                    reflect.ValueOf(q.Setuid),
			"Setxattr":                  reflect.ValueOf(q.Setxattr),
			"Shutdown":                  reflect.ValueOf(q.Shutdown),
			"SlicePtrFromStrings":       reflect.ValueOf(q.SlicePtrFromStrings),
			"Socket":                    reflect.ValueOf(q.Socket),
			"Socketpair":                reflect.ValueOf(q.Socketpair),
			"Splice":                    reflect.ValueOf(q.Splice),
			"StartProcess":              reflect.ValueOf(q.StartProcess),
			"Stat":                      reflect.ValueOf(q.Stat),
			"Statfs":                    reflect.ValueOf(q.Statfs),
			"StringBytePtr":             reflect.ValueOf(q.StringBytePtr),
			"StringByteSlice":           reflect.ValueOf(q.StringByteSlice),
			"StringSlicePtr":            reflect.ValueOf(q.StringSlicePtr),
			"Symlink":                   reflect.ValueOf(q.Symlink),
			"Sync":                      reflect.ValueOf(q.Sync),
			"SyncFileRange":             reflect.ValueOf(q.SyncFileRange),
			"Syscall":                   reflect.ValueOf(q.Syscall),
			"Syscall6":                  reflect.ValueOf(q.Syscall6),
			"Sysinfo":                   reflect.ValueOf(q.Sysinfo),
			"Tee":                       reflect.ValueOf(q.Tee),
			"Tgkill":                    reflect.ValueOf(q.Tgkill),
			"Time":                      reflect.ValueOf(q.Time),
			"Times":                     reflect.ValueOf(q.Times),
			"TimespecToNsec":            reflect.ValueOf(q.TimespecToNsec),
			"TimevalToNsec":             reflect.ValueOf(q.TimevalToNsec),
			"Truncate":                  reflect.ValueOf(q.Truncate),
			"Umask":                     reflect.ValueOf(q.Umask),
			"Uname":                     reflect.ValueOf(q.Uname),
			"UnixCredentials":           reflect.ValueOf(q.UnixCredentials),
			"UnixRights":                reflect.ValueOf(q.UnixRights),
			"Unlink":                    reflect.ValueOf(q.Unlink),
			"Unlinkat":                  reflect.ValueOf(q.Unlinkat),
			"Unmount":                   reflect.ValueOf(q.Unmount),
			"Unsetenv":                  reflect.ValueOf(q.Unsetenv),
			"Unshare":                   reflect.ValueOf(q.Unshare),
			"Ustat":                     reflect.ValueOf(q.Ustat),
			"Utime":                     reflect.ValueOf(q.Utime),
			"Utimes":                    reflect.ValueOf(q.Utimes),
			"UtimesNano":                reflect.ValueOf(q.UtimesNano),
			"Wait4":                     reflect.ValueOf(q.Wait4),
			"Write":                     reflect.ValueOf(q.Write),
		},
		TypedConsts: map[string]igop.TypedConst{
			"E2BIG":           {reflect.TypeOf(q.E2BIG), constant.MakeInt64(int64(q.E2BIG))},
			"EACCES":          {reflect.TypeOf(q.EACCES), constant.MakeInt64(int64(q.EACCES))},
			"EADDRINUSE":      {reflect.TypeOf(q.EADDRINUSE), constant.MakeInt64(int64(q.EADDRINUSE))},
			"EADDRNOTAVAIL":   {reflect.TypeOf(q.EADDRNOTAVAIL), constant.MakeInt64(int64(q.EADDRNOTAVAIL))},
			"EADV":            {reflect.TypeOf(q.EADV), constant.MakeInt64(int64(q.EADV))},
			"EAFNOSUPPORT":    {reflect.TypeOf(q.EAFNOSUPPORT), constant.MakeInt64(int64(q.EAFNOSUPPORT))},
			"EAGAIN":          {reflect.TypeOf(q.EAGAIN), constant.MakeInt64(int64(q.EAGAIN))},
			"EALREADY":        {reflect.TypeOf(q.EALREADY), constant.MakeInt64(int64(q.EALREADY))},
			"EBADE":           {reflect.TypeOf(q.EBADE), constant.MakeInt64(int64(q.EBADE))},
			"EBADF":           {reflect.TypeOf(q.EBADF), constant.MakeInt64(int64(q.EBADF))},
			"EBADFD":          {reflect.TypeOf(q.EBADFD), constant.MakeInt64(int64(q.EBADFD))},
			"EBADMSG":         {reflect.TypeOf(q.EBADMSG), constant.MakeInt64(int64(q.EBADMSG))},
			"EBADR":           {reflect.TypeOf(q.EBADR), constant.MakeInt64(int64(q.EBADR))},
			"EBADRQC":         {reflect.TypeOf(q.EBADRQC), constant.MakeInt64(int64(q.EBADRQC))},
			"EBADSLT":         {reflect.TypeOf(q.EBADSLT), constant.MakeInt64(int64(q.EBADSLT))},
			"EBFONT":          {reflect.TypeOf(q.EBFONT), constant.MakeInt64(int64(q.EBFONT))},
			"EBUSY":           {reflect.TypeOf(q.EBUSY), constant.MakeInt64(int64(q.EBUSY))},
			"ECANCELED":       {reflect.TypeOf(q.ECANCELED), constant.MakeInt64(int64(q.ECANCELED))},
			"ECHILD":          {reflect.TypeOf(q.ECHILD), constant.MakeInt64(int64(q.ECHILD))},
			"ECHRNG":          {reflect.TypeOf(q.ECHRNG), constant.MakeInt64(int64(q.ECHRNG))},
			"ECOMM":           {reflect.TypeOf(q.ECOMM), constant.MakeInt64(int64(q.ECOMM))},
			"ECONNABORTED":    {reflect.TypeOf(q.ECONNABORTED), constant.MakeInt64(int64(q.ECONNABORTED))},
			"ECONNREFUSED":    {reflect.TypeOf(q.ECONNREFUSED), constant.MakeInt64(int64(q.ECONNREFUSED))},
			"ECONNRESET":      {reflect.TypeOf(q.ECONNRESET), constant.MakeInt64(int64(q.ECONNRESET))},
			"EDEADLK":         {reflect.TypeOf(q.EDEADLK), constant.MakeInt64(int64(q.EDEADLK))},
			"EDEADLOCK":       {reflect.TypeOf(q.EDEADLOCK), constant.MakeInt64(int64(q.EDEADLOCK))},
			"EDESTADDRREQ":    {reflect.TypeOf(q.EDESTADDRREQ), constant.MakeInt64(int64(q.EDESTADDRREQ))},
			"EDOM":            {reflect.TypeOf(q.EDOM), constant.MakeInt64(int64(q.EDOM))},
			"EDOTDOT":         {reflect.TypeOf(q.EDOTDOT), constant.MakeInt64(int64(q.EDOTDOT))},
			"EDQUOT":          {reflect.TypeOf(q.EDQUOT), constant.MakeInt64(int64(q.EDQUOT))},
			"EEXIST":          {reflect.TypeOf(q.EEXIST), constant.MakeInt64(int64(q.EEXIST))},
			"EFAULT":          {reflect.TypeOf(q.EFAULT), constant.MakeInt64(int64(q.EFAULT))},
			"EFBIG":           {reflect.TypeOf(q.EFBIG), constant.MakeInt64(int64(q.EFBIG))},
			"EHOSTDOWN":       {reflect.TypeOf(q.EHOSTDOWN), constant.MakeInt64(int64(q.EHOSTDOWN))},
			"EHOSTUNREACH":    {reflect.TypeOf(q.EHOSTUNREACH), constant.MakeInt64(int64(q.EHOSTUNREACH))},
			"EHWPOISON":       {reflect.TypeOf(q.EHWPOISON), constant.MakeInt64(int64(q.EHWPOISON))},
			"EIDRM":           {reflect.TypeOf(q.EIDRM), constant.MakeInt64(int64(q.EIDRM))},
			"EILSEQ":          {reflect.TypeOf(q.EILSEQ), constant.MakeInt64(int64(q.EILSEQ))},
			"EINPROGRESS":     {reflect.TypeOf(q.EINPROGRESS), constant.MakeInt64(int64(q.EINPROGRESS))},
			"EINTR":           {reflect.TypeOf(q.EINTR), constant.MakeInt64(int64(q.EINTR))},
			"EINVAL":          {reflect.TypeOf(q.EINVAL), constant.MakeInt64(int64(q.EINVAL))},
			"EIO":             {reflect.TypeOf(q.EIO), constant.MakeInt64(int64(q.EIO))},
			"EISCONN":         {reflect.TypeOf(q.EISCONN), constant.MakeInt64(int64(q.EISCONN))},
			"EISDIR":          {reflect.TypeOf(q.EISDIR), constant.MakeInt64(int64(q.EISDIR))},
			"EISNAM":          {reflect.TypeOf(q.EISNAM), constant.MakeInt64(int64(q.EISNAM))},
			"EKEYEXPIRED":     {reflect.TypeOf(q.EKEYEXPIRED), constant.MakeInt64(int64(q.EKEYEXPIRED))},
			"EKEYREJECTED":    {reflect.TypeOf(q.EKEYREJECTED), constant.MakeInt64(int64(q.EKEYREJECTED))},
			"EKEYREVOKED":     {reflect.TypeOf(q.EKEYREVOKED), constant.MakeInt64(int64(q.EKEYREVOKED))},
			"EL2HLT":          {reflect.TypeOf(q.EL2HLT), constant.MakeInt64(int64(q.EL2HLT))},
			"EL2NSYNC":        {reflect.TypeOf(q.EL2NSYNC), constant.MakeInt64(int64(q.EL2NSYNC))},
			"EL3HLT":          {reflect.TypeOf(q.EL3HLT), constant.MakeInt64(int64(q.EL3HLT))},
			"EL3RST":          {reflect.TypeOf(q.EL3RST), constant.MakeInt64(int64(q.EL3RST))},
			"ELIBACC":         {reflect.TypeOf(q.ELIBACC), constant.MakeInt64(int64(q.ELIBACC))},
			"ELIBBAD":         {reflect.TypeOf(q.ELIBBAD), constant.MakeInt64(int64(q.ELIBBAD))},
			"ELIBEXEC":        {reflect.TypeOf(q.ELIBEXEC), constant.MakeInt64(int64(q.ELIBEXEC))},
			"ELIBMAX":         {reflect.TypeOf(q.ELIBMAX), constant.MakeInt64(int64(q.ELIBMAX))},
			"ELIBSCN":         {reflect.TypeOf(q.ELIBSCN), constant.MakeInt64(int64(q.ELIBSCN))},
			"ELNRNG":          {reflect.TypeOf(q.ELNRNG), constant.MakeInt64(int64(q.ELNRNG))},
			"ELOOP":           {reflect.TypeOf(q.ELOOP), constant.MakeInt64(int64(q.ELOOP))},
			"EMEDIUMTYPE":     {reflect.TypeOf(q.EMEDIUMTYPE), constant.MakeInt64(int64(q.EMEDIUMTYPE))},
			"EMFILE":          {reflect.TypeOf(q.EMFILE), constant.MakeInt64(int64(q.EMFILE))},
			"EMLINK":          {reflect.TypeOf(q.EMLINK), constant.MakeInt64(int64(q.EMLINK))},
			"EMSGSIZE":        {reflect.TypeOf(q.EMSGSIZE), constant.MakeInt64(int64(q.EMSGSIZE))},
			"EMULTIHOP":       {reflect.TypeOf(q.EMULTIHOP), constant.MakeInt64(int64(q.EMULTIHOP))},
			"ENAMETOOLONG":    {reflect.TypeOf(q.ENAMETOOLONG), constant.MakeInt64(int64(q.ENAMETOOLONG))},
			"ENAVAIL":         {reflect.TypeOf(q.ENAVAIL), constant.MakeInt64(int64(q.ENAVAIL))},
			"ENETDOWN":        {reflect.TypeOf(q.ENETDOWN), constant.MakeInt64(int64(q.ENETDOWN))},
			"ENETRESET":       {reflect.TypeOf(q.ENETRESET), constant.MakeInt64(int64(q.ENETRESET))},
			"ENETUNREACH":     {reflect.TypeOf(q.ENETUNREACH), constant.MakeInt64(int64(q.ENETUNREACH))},
			"ENFILE":          {reflect.TypeOf(q.ENFILE), constant.MakeInt64(int64(q.ENFILE))},
			"ENOANO":          {reflect.TypeOf(q.ENOANO), constant.MakeInt64(int64(q.ENOANO))},
			"ENOBUFS":         {reflect.TypeOf(q.ENOBUFS), constant.MakeInt64(int64(q.ENOBUFS))},
			"ENOCSI":          {reflect.TypeOf(q.ENOCSI), constant.MakeInt64(int64(q.ENOCSI))},
			"ENODATA":         {reflect.TypeOf(q.ENODATA), constant.MakeInt64(int64(q.ENODATA))},
			"ENODEV":          {reflect.TypeOf(q.ENODEV), constant.MakeInt64(int64(q.ENODEV))},
			"ENOENT":          {reflect.TypeOf(q.ENOENT), constant.MakeInt64(int64(q.ENOENT))},
			"ENOEXEC":         {reflect.TypeOf(q.ENOEXEC), constant.MakeInt64(int64(q.ENOEXEC))},
			"ENOKEY":          {reflect.TypeOf(q.ENOKEY), constant.MakeInt64(int64(q.ENOKEY))},
			"ENOLCK":          {reflect.TypeOf(q.ENOLCK), constant.MakeInt64(int64(q.ENOLCK))},
			"ENOLINK":         {reflect.TypeOf(q.ENOLINK), constant.MakeInt64(int64(q.ENOLINK))},
			"ENOMEDIUM":       {reflect.TypeOf(q.ENOMEDIUM), constant.MakeInt64(int64(q.ENOMEDIUM))},
			"ENOMEM":          {reflect.TypeOf(q.ENOMEM), constant.MakeInt64(int64(q.ENOMEM))},
			"ENOMSG":          {reflect.TypeOf(q.ENOMSG), constant.MakeInt64(int64(q.ENOMSG))},
			"ENONET":          {reflect.TypeOf(q.ENONET), constant.MakeInt64(int64(q.ENONET))},
			"ENOPKG":          {reflect.TypeOf(q.ENOPKG), constant.MakeInt64(int64(q.ENOPKG))},
			"ENOPROTOOPT":     {reflect.TypeOf(q.ENOPROTOOPT), constant.MakeInt64(int64(q.ENOPROTOOPT))},
			"ENOSPC":          {reflect.TypeOf(q.ENOSPC), constant.MakeInt64(int64(q.ENOSPC))},
			"ENOSR":           {reflect.TypeOf(q.ENOSR), constant.MakeInt64(int64(q.ENOSR))},
			"ENOSTR":          {reflect.TypeOf(q.ENOSTR), constant.MakeInt64(int64(q.ENOSTR))},
			"ENOSYS":          {reflect.TypeOf(q.ENOSYS), constant.MakeInt64(int64(q.ENOSYS))},
			"ENOTBLK":         {reflect.TypeOf(q.ENOTBLK), constant.MakeInt64(int64(q.ENOTBLK))},
			"ENOTCONN":        {reflect.TypeOf(q.ENOTCONN), constant.MakeInt64(int64(q.ENOTCONN))},
			"ENOTDIR":         {reflect.TypeOf(q.ENOTDIR), constant.MakeInt64(int64(q.ENOTDIR))},
			"ENOTEMPTY":       {reflect.TypeOf(q.ENOTEMPTY), constant.MakeInt64(int64(q.ENOTEMPTY))},
			"ENOTNAM":         {reflect.TypeOf(q.ENOTNAM), constant.MakeInt64(int64(q.ENOTNAM))},
			"ENOTRECOVERABLE": {reflect.TypeOf(q.ENOTRECOVERABLE), constant.MakeInt64(int64(q.ENOTRECOVERABLE))},
			"ENOTSOCK":        {reflect.TypeOf(q.ENOTSOCK), constant.MakeInt64(int64(q.ENOTSOCK))},
			"ENOTSUP":         {reflect.TypeOf(q.ENOTSUP), constant.MakeInt64(int64(q.ENOTSUP))},
			"ENOTTY":          {reflect.TypeOf(q.ENOTTY), constant.MakeInt64(int64(q.ENOTTY))},
			"ENOTUNIQ":        {reflect.TypeOf(q.ENOTUNIQ), constant.MakeInt64(int64(q.ENOTUNIQ))},
			"ENXIO":           {reflect.TypeOf(q.ENXIO), constant.MakeInt64(int64(q.ENXIO))},
			"EOPNOTSUPP":      {reflect.TypeOf(q.EOPNOTSUPP), constant.MakeInt64(int64(q.EOPNOTSUPP))},
			"EOVERFLOW":       {reflect.TypeOf(q.EOVERFLOW), constant.MakeInt64(int64(q.EOVERFLOW))},
			"EOWNERDEAD":      {reflect.TypeOf(q.EOWNERDEAD), constant.MakeInt64(int64(q.EOWNERDEAD))},
			"EPERM":           {reflect.TypeOf(q.EPERM), constant.MakeInt64(int64(q.EPERM))},
			"EPFNOSUPPORT":    {reflect.TypeOf(q.EPFNOSUPPORT), constant.MakeInt64(int64(q.EPFNOSUPPORT))},
			"EPIPE":           {reflect.TypeOf(q.EPIPE), constant.MakeInt64(int64(q.EPIPE))},
			"EPROTO":          {reflect.TypeOf(q.EPROTO), constant.MakeInt64(int64(q.EPROTO))},
			"EPROTONOSUPPORT": {reflect.TypeOf(q.EPROTONOSUPPORT), constant.MakeInt64(int64(q.EPROTONOSUPPORT))},
			"EPROTOTYPE":      {reflect.TypeOf(q.EPROTOTYPE), constant.MakeInt64(int64(q.EPROTOTYPE))},
			"ERANGE":          {reflect.TypeOf(q.ERANGE), constant.MakeInt64(int64(q.ERANGE))},
			"EREMCHG":         {reflect.TypeOf(q.EREMCHG), constant.MakeInt64(int64(q.EREMCHG))},
			"EREMOTE":         {reflect.TypeOf(q.EREMOTE), constant.MakeInt64(int64(q.EREMOTE))},
			"EREMOTEIO":       {reflect.TypeOf(q.EREMOTEIO), constant.MakeInt64(int64(q.EREMOTEIO))},
			"ERESTART":        {reflect.TypeOf(q.ERESTART), constant.MakeInt64(int64(q.ERESTART))},
			"ERFKILL":         {reflect.TypeOf(q.ERFKILL), constant.MakeInt64(int64(q.ERFKILL))},
			"EROFS":           {reflect.TypeOf(q.EROFS), constant.MakeInt64(int64(q.EROFS))},
			"ESHUTDOWN":       {reflect.TypeOf(q.ESHUTDOWN), constant.MakeInt64(int64(q.ESHUTDOWN))},
			"ESOCKTNOSUPPORT": {reflect.TypeOf(q.ESOCKTNOSUPPORT), constant.MakeInt64(int64(q.ESOCKTNOSUPPORT))},
			"ESPIPE":          {reflect.TypeOf(q.ESPIPE), constant.MakeInt64(int64(q.ESPIPE))},
			"ESRCH":           {reflect.TypeOf(q.ESRCH), constant.MakeInt64(int64(q.ESRCH))},
			"ESRMNT":          {reflect.TypeOf(q.ESRMNT), constant.MakeInt64(int64(q.ESRMNT))},
			"ESTALE":          {reflect.TypeOf(q.ESTALE), constant.MakeInt64(int64(q.ESTALE))},
			"ESTRPIPE":        {reflect.TypeOf(q.ESTRPIPE), constant.MakeInt64(int64(q.ESTRPIPE))},
			"ETIME":           {reflect.TypeOf(q.ETIME), constant.MakeInt64(int64(q.ETIME))},
			"ETIMEDOUT":       {reflect.TypeOf(q.ETIMEDOUT), constant.MakeInt64(int64(q.ETIMEDOUT))},
			"ETOOMANYREFS":    {reflect.TypeOf(q.ETOOMANYREFS), constant.MakeInt64(int64(q.ETOOMANYREFS))},
			"ETXTBSY":         {reflect.TypeOf(q.ETXTBSY), constant.MakeInt64(int64(q.ETXTBSY))},
			"EUCLEAN":         {reflect.TypeOf(q.EUCLEAN), constant.MakeInt64(int64(q.EUCLEAN))},
			"EUNATCH":         {reflect.TypeOf(q.EUNATCH), constant.MakeInt64(int64(q.EUNATCH))},
			"EUSERS":          {reflect.TypeOf(q.EUSERS), constant.MakeInt64(int64(q.EUSERS))},
			"EWOULDBLOCK":     {reflect.TypeOf(q.EWOULDBLOCK), constant.MakeInt64(int64(q.EWOULDBLOCK))},
			"EXDEV":           {reflect.TypeOf(q.EXDEV), constant.MakeInt64(int64(q.EXDEV))},
			"EXFULL":          {reflect.TypeOf(q.EXFULL), constant.MakeInt64(int64(q.EXFULL))},
			"SIGABRT":         {reflect.TypeOf(q.SIGABRT), constant.MakeInt64(int64(q.SIGABRT))},
			"SIGALRM":         {reflect.TypeOf(q.SIGALRM), constant.MakeInt64(int64(q.SIGALRM))},
			"SIGBUS":          {reflect.TypeOf(q.SIGBUS), constant.MakeInt64(int64(q.SIGBUS))},
			"SIGCHLD":         {reflect.TypeOf(q.SIGCHLD), constant.MakeInt64(int64(q.SIGCHLD))},
			"SIGCLD":          {reflect.TypeOf(q.SIGCLD), constant.MakeInt64(int64(q.SIGCLD))},
			"SIGCONT":         {reflect.TypeOf(q.SIGCONT), constant.MakeInt64(int64(q.SIGCONT))},
			"SIGFPE":          {reflect.TypeOf(q.SIGFPE), constant.MakeInt64(int64(q.SIGFPE))},
			"SIGHUP":          {reflect.TypeOf(q.SIGHUP), constant.MakeInt64(int64(q.SIGHUP))},
			"SIGILL":          {reflect.TypeOf(q.SIGILL), constant.MakeInt64(int64(q.SIGILL))},
			"SIGINT":          {reflect.TypeOf(q.SIGINT), constant.MakeInt64(int64(q.SIGINT))},
			"SIGIO":           {reflect.TypeOf(q.SIGIO), constant.MakeInt64(int64(q.SIGIO))},
			"SIGIOT":          {reflect.TypeOf(q.SIGIOT), constant.MakeInt64(int64(q.SIGIOT))},
			"SIGKILL":         {reflect.TypeOf(q.SIGKILL), constant.MakeInt64(int64(q.SIGKILL))},
			"SIGPIPE":         {reflect.TypeOf(q.SIGPIPE), constant.MakeInt64(int64(q.SIGPIPE))},
			"SIGPOLL":         {reflect.TypeOf(q.SIGPOLL), constant.MakeInt64(int64(q.SIGPOLL))},
			"SIGPROF":         {reflect.TypeOf(q.SIGPROF), constant.MakeInt64(int64(q.SIGPROF))},
			"SIGPWR":          {reflect.TypeOf(q.SIGPWR), constant.MakeInt64(int64(q.SIGPWR))},
			"SIGQUIT":         {reflect.TypeOf(q.SIGQUIT), constant.MakeInt64(int64(q.SIGQUIT))},
			"SIGSEGV":         {reflect.TypeOf(q.SIGSEGV), constant.MakeInt64(int64(q.SIGSEGV))},
			"SIGSTKFLT":       {reflect.TypeOf(q.SIGSTKFLT), constant.MakeInt64(int64(q.SIGSTKFLT))},
			"SIGSTOP":         {reflect.TypeOf(q.SIGSTOP), constant.MakeInt64(int64(q.SIGSTOP))},
			"SIGSYS":          {reflect.TypeOf(q.SIGSYS), constant.MakeInt64(int64(q.SIGSYS))},
			"SIGTERM":         {reflect.TypeOf(q.SIGTERM), constant.MakeInt64(int64(q.SIGTERM))},
			"SIGTRAP":         {reflect.TypeOf(q.SIGTRAP), constant.MakeInt64(int64(q.SIGTRAP))},
			"SIGTSTP":         {reflect.TypeOf(q.SIGTSTP), constant.MakeInt64(int64(q.SIGTSTP))},
			"SIGTTIN":         {reflect.TypeOf(q.SIGTTIN), constant.MakeInt64(int64(q.SIGTTIN))},
			"SIGTTOU":         {reflect.TypeOf(q.SIGTTOU), constant.MakeInt64(int64(q.SIGTTOU))},
			"SIGUNUSED":       {reflect.TypeOf(q.SIGUNUSED), constant.MakeInt64(int64(q.SIGUNUSED))},
			"SIGURG":          {reflect.TypeOf(q.SIGURG), constant.MakeInt64(int64(q.SIGURG))},
			"SIGUSR1":         {reflect.TypeOf(q.SIGUSR1), constant.MakeInt64(int64(q.SIGUSR1))},
			"SIGUSR2":         {reflect.TypeOf(q.SIGUSR2), constant.MakeInt64(int64(q.SIGUSR2))},
			"SIGVTALRM":       {reflect.TypeOf(q.SIGVTALRM), constant.MakeInt64(int64(q.SIGVTALRM))},
			"SIGWINCH":        {reflect.TypeOf(q.SIGWINCH), constant.MakeInt64(int64(q.SIGWINCH))},
			"SIGXCPU":         {reflect.TypeOf(q.SIGXCPU), constant.MakeInt64(int64(q.SIGXCPU))},
			"SIGXFSZ":         {reflect.TypeOf(q.SIGXFSZ), constant.MakeInt64(int64(q.SIGXFSZ))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"AF_ALG":                           {"untyped int", constant.MakeInt64(int64(q.AF_ALG))},
			"AF_APPLETALK":                     {"untyped int", constant.MakeInt64(int64(q.AF_APPLETALK))},
			"AF_ASH":                           {"untyped int", constant.MakeInt64(int64(q.AF_ASH))},
			"AF_ATMPVC":                        {"untyped int", constant.MakeInt64(int64(q.AF_ATMPVC))},
			"AF_ATMSVC":                        {"untyped int", constant.MakeInt64(int64(q.AF_ATMSVC))},
			"AF_AX25":                          {"untyped int", constant.MakeInt64(int64(q.AF_AX25))},
			"AF_BLUETOOTH":                     {"untyped int", constant.MakeInt64(int64(q.AF_BLUETOOTH))},
			"AF_BRIDGE":                        {"untyped int", constant.MakeInt64(int64(q.AF_BRIDGE))},
			"AF_CAIF":                          {"untyped int", constant.MakeInt64(int64(q.AF_CAIF))},
			"AF_CAN":                           {"untyped int", constant.MakeInt64(int64(q.AF_CAN))},
			"AF_DECnet":                        {"untyped int", constant.MakeInt64(int64(q.AF_DECnet))},
			"AF_ECONET":                        {"untyped int", constant.MakeInt64(int64(q.AF_ECONET))},
			"AF_FILE":                          {"untyped int", constant.MakeInt64(int64(q.AF_FILE))},
			"AF_IEEE802154":                    {"untyped int", constant.MakeInt64(int64(q.AF_IEEE802154))},
			"AF_INET":                          {"untyped int", constant.MakeInt64(int64(q.AF_INET))},
			"AF_INET6":                         {"untyped int", constant.MakeInt64(int64(q.AF_INET6))},
			"AF_IPX":                           {"untyped int", constant.MakeInt64(int64(q.AF_IPX))},
			"AF_IRDA":                          {"untyped int", constant.MakeInt64(int64(q.AF_IRDA))},
			"AF_ISDN":                          {"untyped int", constant.MakeInt64(int64(q.AF_ISDN))},
			"AF_IUCV":                          {"untyped int", constant.MakeInt64(int64(q.AF_IUCV))},
			"AF_KEY":                           {"untyped int", constant.MakeInt64(int64(q.AF_KEY))},
			"AF_LLC":                           {"untyped int", constant.MakeInt64(int64(q.AF_LLC))},
			"AF_LOCAL":                         {"untyped int", constant.MakeInt64(int64(q.AF_LOCAL))},
			"AF_MAX":                           {"untyped int", constant.MakeInt64(int64(q.AF_MAX))},
			"AF_NETBEUI":                       {"untyped int", constant.MakeInt64(int64(q.AF_NETBEUI))},
			"AF_NETLINK":                       {"untyped int", constant.MakeInt64(int64(q.AF_NETLINK))},
			"AF_NETROM":                        {"untyped int", constant.MakeInt64(int64(q.AF_NETROM))},
			"AF_NFC":                           {"untyped int", constant.MakeInt64(int64(q.AF_NFC))},
			"AF_PACKET":                        {"untyped int", constant.MakeInt64(int64(q.AF_PACKET))},
			"AF_PHONET":                        {"untyped int", constant.MakeInt64(int64(q.AF_PHONET))},
			"AF_PPPOX":                         {"untyped int", constant.MakeInt64(int64(q.AF_PPPOX))},
			"AF_RDS":                           {"untyped int", constant.MakeInt64(int64(q.AF_RDS))},
			"AF_ROSE":                          {"untyped int", constant.MakeInt64(int64(q.AF_ROSE))},
			"AF_ROUTE":                         {"untyped int", constant.MakeInt64(int64(q.AF_ROUTE))},
			"AF_RXRPC":                         {"untyped int", constant.MakeInt64(int64(q.AF_RXRPC))},
			"AF_SECURITY":                      {"untyped int", constant.MakeInt64(int64(q.AF_SECURITY))},
			"AF_SNA":                           {"untyped int", constant.MakeInt64(int64(q.AF_SNA))},
			"AF_TIPC":                          {"untyped int", constant.MakeInt64(int64(q.AF_TIPC))},
			"AF_UNIX":                          {"untyped int", constant.MakeInt64(int64(q.AF_UNIX))},
			"AF_UNSPEC":                        {"untyped int", constant.MakeInt64(int64(q.AF_UNSPEC))},
			"AF_VSOCK":                         {"untyped int", constant.MakeInt64(int64(q.AF_VSOCK))},
			"AF_WANPIPE":                       {"untyped int", constant.MakeInt64(int64(q.AF_WANPIPE))},
			"AF_X25":                           {"untyped int", constant.MakeInt64(int64(q.AF_X25))},
			"ARPHRD_6LOWPAN":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_6LOWPAN))},
			"ARPHRD_ADAPT":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ADAPT))},
			"ARPHRD_APPLETLK":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_APPLETLK))},
			"ARPHRD_ARCNET":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ARCNET))},
			"ARPHRD_ASH":                       {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ASH))},
			"ARPHRD_ATM":                       {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ATM))},
			"ARPHRD_AX25":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_AX25))},
			"ARPHRD_BIF":                       {"untyped int", constant.MakeInt64(int64(q.ARPHRD_BIF))},
			"ARPHRD_CAIF":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_CAIF))},
			"ARPHRD_CAN":                       {"untyped int", constant.MakeInt64(int64(q.ARPHRD_CAN))},
			"ARPHRD_CHAOS":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_CHAOS))},
			"ARPHRD_CISCO":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_CISCO))},
			"ARPHRD_CSLIP":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_CSLIP))},
			"ARPHRD_CSLIP6":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_CSLIP6))},
			"ARPHRD_DDCMP":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_DDCMP))},
			"ARPHRD_DLCI":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_DLCI))},
			"ARPHRD_ECONET":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ECONET))},
			"ARPHRD_EETHER":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_EETHER))},
			"ARPHRD_ETHER":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ETHER))},
			"ARPHRD_EUI64":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_EUI64))},
			"ARPHRD_FCAL":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FCAL))},
			"ARPHRD_FCFABRIC":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FCFABRIC))},
			"ARPHRD_FCPL":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FCPL))},
			"ARPHRD_FCPP":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FCPP))},
			"ARPHRD_FDDI":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FDDI))},
			"ARPHRD_FRAD":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FRAD))},
			"ARPHRD_HDLC":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_HDLC))},
			"ARPHRD_HIPPI":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_HIPPI))},
			"ARPHRD_HWX25":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_HWX25))},
			"ARPHRD_IEEE1394":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE1394))},
			"ARPHRD_IEEE802":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE802))},
			"ARPHRD_IEEE80211":                 {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE80211))},
			"ARPHRD_IEEE80211_PRISM":           {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE80211_PRISM))},
			"ARPHRD_IEEE80211_RADIOTAP":        {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE80211_RADIOTAP))},
			"ARPHRD_IEEE802154":                {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE802154))},
			"ARPHRD_IEEE802154_MONITOR":        {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE802154_MONITOR))},
			"ARPHRD_IEEE802_TR":                {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE802_TR))},
			"ARPHRD_INFINIBAND":                {"untyped int", constant.MakeInt64(int64(q.ARPHRD_INFINIBAND))},
			"ARPHRD_IP6GRE":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IP6GRE))},
			"ARPHRD_IPDDP":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IPDDP))},
			"ARPHRD_IPGRE":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IPGRE))},
			"ARPHRD_IRDA":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IRDA))},
			"ARPHRD_LAPB":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_LAPB))},
			"ARPHRD_LOCALTLK":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_LOCALTLK))},
			"ARPHRD_LOOPBACK":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_LOOPBACK))},
			"ARPHRD_METRICOM":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_METRICOM))},
			"ARPHRD_NETLINK":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_NETLINK))},
			"ARPHRD_NETROM":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_NETROM))},
			"ARPHRD_NONE":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_NONE))},
			"ARPHRD_PHONET":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_PHONET))},
			"ARPHRD_PHONET_PIPE":               {"untyped int", constant.MakeInt64(int64(q.ARPHRD_PHONET_PIPE))},
			"ARPHRD_PIMREG":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_PIMREG))},
			"ARPHRD_PPP":                       {"untyped int", constant.MakeInt64(int64(q.ARPHRD_PPP))},
			"ARPHRD_PRONET":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_PRONET))},
			"ARPHRD_RAWHDLC":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_RAWHDLC))},
			"ARPHRD_ROSE":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ROSE))},
			"ARPHRD_RSRVD":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_RSRVD))},
			"ARPHRD_SIT":                       {"untyped int", constant.MakeInt64(int64(q.ARPHRD_SIT))},
			"ARPHRD_SKIP":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_SKIP))},
			"ARPHRD_SLIP":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_SLIP))},
			"ARPHRD_SLIP6":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_SLIP6))},
			"ARPHRD_TUNNEL":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_TUNNEL))},
			"ARPHRD_TUNNEL6":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_TUNNEL6))},
			"ARPHRD_VOID":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_VOID))},
			"ARPHRD_X25":                       {"untyped int", constant.MakeInt64(int64(q.ARPHRD_X25))},
			"B0":                               {"untyped int", constant.MakeInt64(int64(q.B0))},
			"B1000000":                         {"untyped int", constant.MakeInt64(int64(q.B1000000))},
			"B110":                             {"untyped int", constant.MakeInt64(int64(q.B110))},
			"B115200":                          {"untyped int", constant.MakeInt64(int64(q.B115200))},
			"B1152000":                         {"untyped int", constant.MakeInt64(int64(q.B1152000))},
			"B1200":                            {"untyped int", constant.MakeInt64(int64(q.B1200))},
			"B134":                             {"untyped int", constant.MakeInt64(int64(q.B134))},
			"B150":                             {"untyped int", constant.MakeInt64(int64(q.B150))},
			"B1500000":                         {"untyped int", constant.MakeInt64(int64(q.B1500000))},
			"B1800":                            {"untyped int", constant.MakeInt64(int64(q.B1800))},
			"B19200":                           {"untyped int", constant.MakeInt64(int64(q.B19200))},
			"B200":                             {"untyped int", constant.MakeInt64(int64(q.B200))},
			"B2000000":                         {"untyped int", constant.MakeInt64(int64(q.B2000000))},
			"B230400":                          {"untyped int", constant.MakeInt64(int64(q.B230400))},
			"B2400":                            {"untyped int", constant.MakeInt64(int64(q.B2400))},
			"B2500000":                         {"untyped int", constant.MakeInt64(int64(q.B2500000))},
			"B300":                             {"untyped int", constant.MakeInt64(int64(q.B300))},
			"B3000000":                         {"untyped int", constant.MakeInt64(int64(q.B3000000))},
			"B3500000":                         {"untyped int", constant.MakeInt64(int64(q.B3500000))},
			"B38400":                           {"untyped int", constant.MakeInt64(int64(q.B38400))},
			"B4000000":                         {"untyped int", constant.MakeInt64(int64(q.B4000000))},
			"B460800":                          {"untyped int", constant.MakeInt64(int64(q.B460800))},
			"B4800":                            {"untyped int", constant.MakeInt64(int64(q.B4800))},
			"B50":                              {"untyped int", constant.MakeInt64(int64(q.B50))},
			"B500000":                          {"untyped int", constant.MakeInt64(int64(q.B500000))},
			"B57600":                           {"untyped int", constant.MakeInt64(int64(q.B57600))},
			"B576000":                          {"untyped int", constant.MakeInt64(int64(q.B576000))},
			"B600":                             {"untyped int", constant.MakeInt64(int64(q.B600))},
			"B75":                              {"untyped int", constant.MakeInt64(int64(q.B75))},
			"B921600":                          {"untyped int", constant.MakeInt64(int64(q.B921600))},
			"B9600":                            {"untyped int", constant.MakeInt64(int64(q.B9600))},
			"BPF_A":                            {"untyped int", constant.MakeInt64(int64(q.BPF_A))},
			"BPF_ABS":                          {"untyped int", constant.MakeInt64(int64(q.BPF_ABS))},
			"BPF_ADD":                          {"untyped int", constant.MakeInt64(int64(q.BPF_ADD))},
			"BPF_ALU":                          {"untyped int", constant.MakeInt64(int64(q.BPF_ALU))},
			"BPF_AND":                          {"untyped int", constant.MakeInt64(int64(q.BPF_AND))},
			"BPF_B":                            {"untyped int", constant.MakeInt64(int64(q.BPF_B))},
			"BPF_DIV":                          {"untyped int", constant.MakeInt64(int64(q.BPF_DIV))},
			"BPF_H":                            {"untyped int", constant.MakeInt64(int64(q.BPF_H))},
			"BPF_IMM":                          {"untyped int", constant.MakeInt64(int64(q.BPF_IMM))},
			"BPF_IND":                          {"untyped int", constant.MakeInt64(int64(q.BPF_IND))},
			"BPF_JA":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JA))},
			"BPF_JEQ":                          {"untyped int", constant.MakeInt64(int64(q.BPF_JEQ))},
			"BPF_JGE":                          {"untyped int", constant.MakeInt64(int64(q.BPF_JGE))},
			"BPF_JGT":                          {"untyped int", constant.MakeInt64(int64(q.BPF_JGT))},
			"BPF_JMP":                          {"untyped int", constant.MakeInt64(int64(q.BPF_JMP))},
			"BPF_JSET":                         {"untyped int", constant.MakeInt64(int64(q.BPF_JSET))},
			"BPF_K":                            {"untyped int", constant.MakeInt64(int64(q.BPF_K))},
			"BPF_LD":                           {"untyped int", constant.MakeInt64(int64(q.BPF_LD))},
			"BPF_LDX":                          {"untyped int", constant.MakeInt64(int64(q.BPF_LDX))},
			"BPF_LEN":                          {"untyped int", constant.MakeInt64(int64(q.BPF_LEN))},
			"BPF_LL_OFF":                       {"untyped int", constant.MakeInt64(int64(q.BPF_LL_OFF))},
			"BPF_LSH":                          {"untyped int", constant.MakeInt64(int64(q.BPF_LSH))},
			"BPF_MAJOR_VERSION":                {"untyped int", constant.MakeInt64(int64(q.BPF_MAJOR_VERSION))},
			"BPF_MAXINSNS":                     {"untyped int", constant.MakeInt64(int64(q.BPF_MAXINSNS))},
			"BPF_MEM":                          {"untyped int", constant.MakeInt64(int64(q.BPF_MEM))},
			"BPF_MEMWORDS":                     {"untyped int", constant.MakeInt64(int64(q.BPF_MEMWORDS))},
			"BPF_MINOR_VERSION":                {"untyped int", constant.MakeInt64(int64(q.BPF_MINOR_VERSION))},
			"BPF_MISC":                         {"untyped int", constant.MakeInt64(int64(q.BPF_MISC))},
			"BPF_MOD":                          {"untyped int", constant.MakeInt64(int64(q.BPF_MOD))},
			"BPF_MSH":                          {"untyped int", constant.MakeInt64(int64(q.BPF_MSH))},
			"BPF_MUL":                          {"untyped int", constant.MakeInt64(int64(q.BPF_MUL))},
			"BPF_NEG":                          {"untyped int", constant.MakeInt64(int64(q.BPF_NEG))},
			"BPF_NET_OFF":                      {"untyped int", constant.MakeInt64(int64(q.BPF_NET_OFF))},
			"BPF_OR":                           {"untyped int", constant.MakeInt64(int64(q.BPF_OR))},
			"BPF_RET":                          {"untyped int", constant.MakeInt64(int64(q.BPF_RET))},
			"BPF_RSH":                          {"untyped int", constant.MakeInt64(int64(q.BPF_RSH))},
			"BPF_ST":                           {"untyped int", constant.MakeInt64(int64(q.BPF_ST))},
			"BPF_STX":                          {"untyped int", constant.MakeInt64(int64(q.BPF_STX))},
			"BPF_SUB":                          {"untyped int", constant.MakeInt64(int64(q.BPF_SUB))},
			"BPF_TAX":                          {"untyped int", constant.MakeInt64(int64(q.BPF_TAX))},
			"BPF_TXA":                          {"untyped int", constant.MakeInt64(int64(q.BPF_TXA))},
			"BPF_W":                            {"untyped int", constant.MakeInt64(int64(q.BPF_W))},
			"BPF_X":                            {"untyped int", constant.MakeInt64(int64(q.BPF_X))},
			"BPF_XOR":                          {"untyped int", constant.MakeInt64(int64(q.BPF_XOR))},
			"BRKINT":                           {"untyped int", constant.MakeInt64(int64(q.BRKINT))},
			"CFLUSH":                           {"untyped int", constant.MakeInt64(int64(q.CFLUSH))},
			"CLOCAL":                           {"untyped int", constant.MakeInt64(int64(q.CLOCAL))},
			"CLONE_CHILD_CLEARTID":             {"untyped int", constant.MakeInt64(int64(q.CLONE_CHILD_CLEARTID))},
			"CLONE_CHILD_SETTID":               {"untyped int", constant.MakeInt64(int64(q.CLONE_CHILD_SETTID))},
			"CLONE_DETACHED":                   {"untyped int", constant.MakeInt64(int64(q.CLONE_DETACHED))},
			"CLONE_FILES":                      {"untyped int", constant.MakeInt64(int64(q.CLONE_FILES))},
			"CLONE_FS":                         {"untyped int", constant.MakeInt64(int64(q.CLONE_FS))},
			"CLONE_IO":                         {"untyped int", constant.MakeInt64(int64(q.CLONE_IO))},
			"CLONE_NEWCGROUP":                  {"untyped int", constant.MakeInt64(int64(q.CLONE_NEWCGROUP))},
			"CLONE_NEWIPC":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_NEWIPC))},
			"CLONE_NEWNET":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_NEWNET))},
			"CLONE_NEWNS":                      {"untyped int", constant.MakeInt64(int64(q.CLONE_NEWNS))},
			"CLONE_NEWPID":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_NEWPID))},
			"CLONE_NEWUSER":                    {"untyped int", constant.MakeInt64(int64(q.CLONE_NEWUSER))},
			"CLONE_NEWUTS":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_NEWUTS))},
			"CLONE_PARENT":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_PARENT))},
			"CLONE_PARENT_SETTID":              {"untyped int", constant.MakeInt64(int64(q.CLONE_PARENT_SETTID))},
			"CLONE_PTRACE":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_PTRACE))},
			"CLONE_SETTLS":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_SETTLS))},
			"CLONE_SIGHAND":                    {"untyped int", constant.MakeInt64(int64(q.CLONE_SIGHAND))},
			"CLONE_SYSVSEM":                    {"untyped int", constant.MakeInt64(int64(q.CLONE_SYSVSEM))},
			"CLONE_THREAD":                     {"untyped int", constant.MakeInt64(int64(q.CLONE_THREAD))},
			"CLONE_UNTRACED":                   {"untyped int", constant.MakeInt64(int64(q.CLONE_UNTRACED))},
			"CLONE_VFORK":                      {"untyped int", constant.MakeInt64(int64(q.CLONE_VFORK))},
			"CLONE_VM":                         {"untyped int", constant.MakeInt64(int64(q.CLONE_VM))},
			"CREAD":                            {"untyped int", constant.MakeInt64(int64(q.CREAD))},
			"CS5":                              {"untyped int", constant.MakeInt64(int64(q.CS5))},
			"CS6":                              {"untyped int", constant.MakeInt64(int64(q.CS6))},
			"CS7":                              {"untyped int", constant.MakeInt64(int64(q.CS7))},
			"CS8":                              {"untyped int", constant.MakeInt64(int64(q.CS8))},
			"CSIGNAL":                          {"untyped int", constant.MakeInt64(int64(q.CSIGNAL))},
			"CSIZE":                            {"untyped int", constant.MakeInt64(int64(q.CSIZE))},
			"CSTART":                           {"untyped int", constant.MakeInt64(int64(q.CSTART))},
			"CSTATUS":                          {"untyped int", constant.MakeInt64(int64(q.CSTATUS))},
			"CSTOP":                            {"untyped int", constant.MakeInt64(int64(q.CSTOP))},
			"CSTOPB":                           {"untyped int", constant.MakeInt64(int64(q.CSTOPB))},
			"CSUSP":                            {"untyped int", constant.MakeInt64(int64(q.CSUSP))},
			"DT_BLK":                           {"untyped int", constant.MakeInt64(int64(q.DT_BLK))},
			"DT_CHR":                           {"untyped int", constant.MakeInt64(int64(q.DT_CHR))},
			"DT_DIR":                           {"untyped int", constant.MakeInt64(int64(q.DT_DIR))},
			"DT_FIFO":                          {"untyped int", constant.MakeInt64(int64(q.DT_FIFO))},
			"DT_LNK":                           {"untyped int", constant.MakeInt64(int64(q.DT_LNK))},
			"DT_REG":                           {"untyped int", constant.MakeInt64(int64(q.DT_REG))},
			"DT_SOCK":                          {"untyped int", constant.MakeInt64(int64(q.DT_SOCK))},
			"DT_UNKNOWN":                       {"untyped int", constant.MakeInt64(int64(q.DT_UNKNOWN))},
			"DT_WHT":                           {"untyped int", constant.MakeInt64(int64(q.DT_WHT))},
			"ECHO":                             {"untyped int", constant.MakeInt64(int64(q.ECHO))},
			"ECHOCTL":                          {"untyped int", constant.MakeInt64(int64(q.ECHOCTL))},
			"ECHOE":                            {"untyped int", constant.MakeInt64(int64(q.ECHOE))},
			"ECHOK":                            {"untyped int", constant.MakeInt64(int64(q.ECHOK))},
			"ECHOKE":                           {"untyped int", constant.MakeInt64(int64(q.ECHOKE))},
			"ECHONL":                           {"untyped int", constant.MakeInt64(int64(q.ECHONL))},
			"ECHOPRT":                          {"untyped int", constant.MakeInt64(int64(q.ECHOPRT))},
			"ENCODING_DEFAULT":                 {"untyped int", constant.MakeInt64(int64(q.ENCODING_DEFAULT))},
			"ENCODING_FM_MARK":                 {"untyped int", constant.MakeInt64(int64(q.ENCODING_FM_MARK))},
			"ENCODING_FM_SPACE":                {"untyped int", constant.MakeInt64(int64(q.ENCODING_FM_SPACE))},
			"ENCODING_MANCHESTER":              {"untyped int", constant.MakeInt64(int64(q.ENCODING_MANCHESTER))},
			"ENCODING_NRZ":                     {"untyped int", constant.MakeInt64(int64(q.ENCODING_NRZ))},
			"ENCODING_NRZI":                    {"untyped int", constant.MakeInt64(int64(q.ENCODING_NRZI))},
			"EPOLLERR":                         {"untyped int", constant.MakeInt64(int64(q.EPOLLERR))},
			"EPOLLET":                          {"untyped int", constant.MakeInt64(int64(q.EPOLLET))},
			"EPOLLHUP":                         {"untyped int", constant.MakeInt64(int64(q.EPOLLHUP))},
			"EPOLLIN":                          {"untyped int", constant.MakeInt64(int64(q.EPOLLIN))},
			"EPOLLMSG":                         {"untyped int", constant.MakeInt64(int64(q.EPOLLMSG))},
			"EPOLLONESHOT":                     {"untyped int", constant.MakeInt64(int64(q.EPOLLONESHOT))},
			"EPOLLOUT":                         {"untyped int", constant.MakeInt64(int64(q.EPOLLOUT))},
			"EPOLLPRI":                         {"untyped int", constant.MakeInt64(int64(q.EPOLLPRI))},
			"EPOLLRDBAND":                      {"untyped int", constant.MakeInt64(int64(q.EPOLLRDBAND))},
			"EPOLLRDHUP":                       {"untyped int", constant.MakeInt64(int64(q.EPOLLRDHUP))},
			"EPOLLRDNORM":                      {"untyped int", constant.MakeInt64(int64(q.EPOLLRDNORM))},
			"EPOLLWAKEUP":                      {"untyped int", constant.MakeInt64(int64(q.EPOLLWAKEUP))},
			"EPOLLWRBAND":                      {"untyped int", constant.MakeInt64(int64(q.EPOLLWRBAND))},
			"EPOLLWRNORM":                      {"untyped int", constant.MakeInt64(int64(q.EPOLLWRNORM))},
			"EPOLL_CLOEXEC":                    {"untyped int", constant.MakeInt64(int64(q.EPOLL_CLOEXEC))},
			"EPOLL_CTL_ADD":                    {"untyped int", constant.MakeInt64(int64(q.EPOLL_CTL_ADD))},
			"EPOLL_CTL_DEL":                    {"untyped int", constant.MakeInt64(int64(q.EPOLL_CTL_DEL))},
			"EPOLL_CTL_MOD":                    {"untyped int", constant.MakeInt64(int64(q.EPOLL_CTL_MOD))},
			"ETH_P_1588":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_1588))},
			"ETH_P_8021AD":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_8021AD))},
			"ETH_P_8021AH":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_8021AH))},
			"ETH_P_8021Q":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_8021Q))},
			"ETH_P_80221":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_80221))},
			"ETH_P_802_2":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_802_2))},
			"ETH_P_802_3":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_802_3))},
			"ETH_P_802_3_MIN":                  {"untyped int", constant.MakeInt64(int64(q.ETH_P_802_3_MIN))},
			"ETH_P_802_EX1":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_802_EX1))},
			"ETH_P_AARP":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_AARP))},
			"ETH_P_AF_IUCV":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_AF_IUCV))},
			"ETH_P_ALL":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_ALL))},
			"ETH_P_AOE":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_AOE))},
			"ETH_P_ARCNET":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_ARCNET))},
			"ETH_P_ARP":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_ARP))},
			"ETH_P_ATALK":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_ATALK))},
			"ETH_P_ATMFATE":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_ATMFATE))},
			"ETH_P_ATMMPOA":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_ATMMPOA))},
			"ETH_P_AX25":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_AX25))},
			"ETH_P_BATMAN":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_BATMAN))},
			"ETH_P_BPQ":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_BPQ))},
			"ETH_P_CAIF":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_CAIF))},
			"ETH_P_CAN":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_CAN))},
			"ETH_P_CANFD":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_CANFD))},
			"ETH_P_CONTROL":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_CONTROL))},
			"ETH_P_CUST":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_CUST))},
			"ETH_P_DDCMP":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_DDCMP))},
			"ETH_P_DEC":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_DEC))},
			"ETH_P_DIAG":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_DIAG))},
			"ETH_P_DNA_DL":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_DNA_DL))},
			"ETH_P_DNA_RC":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_DNA_RC))},
			"ETH_P_DNA_RT":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_DNA_RT))},
			"ETH_P_DSA":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_DSA))},
			"ETH_P_ECONET":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_ECONET))},
			"ETH_P_EDSA":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_EDSA))},
			"ETH_P_FCOE":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_FCOE))},
			"ETH_P_FIP":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_FIP))},
			"ETH_P_HDLC":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_HDLC))},
			"ETH_P_IEEE802154":                 {"untyped int", constant.MakeInt64(int64(q.ETH_P_IEEE802154))},
			"ETH_P_IEEEPUP":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_IEEEPUP))},
			"ETH_P_IEEEPUPAT":                  {"untyped int", constant.MakeInt64(int64(q.ETH_P_IEEEPUPAT))},
			"ETH_P_IP":                         {"untyped int", constant.MakeInt64(int64(q.ETH_P_IP))},
			"ETH_P_IPV6":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_IPV6))},
			"ETH_P_IPX":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_IPX))},
			"ETH_P_IRDA":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_IRDA))},
			"ETH_P_LAT":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_LAT))},
			"ETH_P_LINK_CTL":                   {"untyped int", constant.MakeInt64(int64(q.ETH_P_LINK_CTL))},
			"ETH_P_LOCALTALK":                  {"untyped int", constant.MakeInt64(int64(q.ETH_P_LOCALTALK))},
			"ETH_P_LOOP":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_LOOP))},
			"ETH_P_LOOPBACK":                   {"untyped int", constant.MakeInt64(int64(q.ETH_P_LOOPBACK))},
			"ETH_P_MOBITEX":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_MOBITEX))},
			"ETH_P_MPLS_MC":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_MPLS_MC))},
			"ETH_P_MPLS_UC":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_MPLS_UC))},
			"ETH_P_MVRP":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_MVRP))},
			"ETH_P_PAE":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_PAE))},
			"ETH_P_PAUSE":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_PAUSE))},
			"ETH_P_PHONET":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_PHONET))},
			"ETH_P_PPPTALK":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_PPPTALK))},
			"ETH_P_PPP_DISC":                   {"untyped int", constant.MakeInt64(int64(q.ETH_P_PPP_DISC))},
			"ETH_P_PPP_MP":                     {"untyped int", constant.MakeInt64(int64(q.ETH_P_PPP_MP))},
			"ETH_P_PPP_SES":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_PPP_SES))},
			"ETH_P_PRP":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_PRP))},
			"ETH_P_PUP":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_PUP))},
			"ETH_P_PUPAT":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_PUPAT))},
			"ETH_P_QINQ1":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_QINQ1))},
			"ETH_P_QINQ2":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_QINQ2))},
			"ETH_P_QINQ3":                      {"untyped int", constant.MakeInt64(int64(q.ETH_P_QINQ3))},
			"ETH_P_RARP":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_RARP))},
			"ETH_P_SCA":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_SCA))},
			"ETH_P_SLOW":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_SLOW))},
			"ETH_P_SNAP":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_SNAP))},
			"ETH_P_TDLS":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_TDLS))},
			"ETH_P_TEB":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_TEB))},
			"ETH_P_TIPC":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_TIPC))},
			"ETH_P_TRAILER":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_TRAILER))},
			"ETH_P_TR_802_2":                   {"untyped int", constant.MakeInt64(int64(q.ETH_P_TR_802_2))},
			"ETH_P_TSN":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_TSN))},
			"ETH_P_WAN_PPP":                    {"untyped int", constant.MakeInt64(int64(q.ETH_P_WAN_PPP))},
			"ETH_P_WCCP":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_WCCP))},
			"ETH_P_X25":                        {"untyped int", constant.MakeInt64(int64(q.ETH_P_X25))},
			"ETH_P_XDSA":                       {"untyped int", constant.MakeInt64(int64(q.ETH_P_XDSA))},
			"EXTA":                             {"untyped int", constant.MakeInt64(int64(q.EXTA))},
			"EXTB":                             {"untyped int", constant.MakeInt64(int64(q.EXTB))},
			"EXTPROC":                          {"untyped int", constant.MakeInt64(int64(q.EXTPROC))},
			"FD_CLOEXEC":                       {"untyped int", constant.MakeInt64(int64(q.FD_CLOEXEC))},
			"FD_SETSIZE":                       {"untyped int", constant.MakeInt64(int64(q.FD_SETSIZE))},
			"FLUSHO":                           {"untyped int", constant.MakeInt64(int64(q.FLUSHO))},
			"F_DUPFD":                          {"untyped int", constant.MakeInt64(int64(q.F_DUPFD))},
			"F_DUPFD_CLOEXEC":                  {"untyped int", constant.MakeInt64(int64(q.F_DUPFD_CLOEXEC))},
			"F_EXLCK":                          {"untyped int", constant.MakeInt64(int64(q.F_EXLCK))},
			"F_GETFD":                          {"untyped int", constant.MakeInt64(int64(q.F_GETFD))},
			"F_GETFL":                          {"untyped int", constant.MakeInt64(int64(q.F_GETFL))},
			"F_GETLEASE":                       {"untyped int", constant.MakeInt64(int64(q.F_GETLEASE))},
			"F_GETLK":                          {"untyped int", constant.MakeInt64(int64(q.F_GETLK))},
			"F_GETLK64":                        {"untyped int", constant.MakeInt64(int64(q.F_GETLK64))},
			"F_GETOWN":                         {"untyped int", constant.MakeInt64(int64(q.F_GETOWN))},
			"F_GETOWN_EX":                      {"untyped int", constant.MakeInt64(int64(q.F_GETOWN_EX))},
			"F_GETPIPE_SZ":                     {"untyped int", constant.MakeInt64(int64(q.F_GETPIPE_SZ))},
			"F_GETSIG":                         {"untyped int", constant.MakeInt64(int64(q.F_GETSIG))},
			"F_LOCK":                           {"untyped int", constant.MakeInt64(int64(q.F_LOCK))},
			"F_NOTIFY":                         {"untyped int", constant.MakeInt64(int64(q.F_NOTIFY))},
			"F_OFD_GETLK":                      {"untyped int", constant.MakeInt64(int64(q.F_OFD_GETLK))},
			"F_OFD_SETLK":                      {"untyped int", constant.MakeInt64(int64(q.F_OFD_SETLK))},
			"F_OFD_SETLKW":                     {"untyped int", constant.MakeInt64(int64(q.F_OFD_SETLKW))},
			"F_OK":                             {"untyped int", constant.MakeInt64(int64(q.F_OK))},
			"F_RDLCK":                          {"untyped int", constant.MakeInt64(int64(q.F_RDLCK))},
			"F_SETFD":                          {"untyped int", constant.MakeInt64(int64(q.F_SETFD))},
			"F_SETFL":                          {"untyped int", constant.MakeInt64(int64(q.F_SETFL))},
			"F_SETLEASE":                       {"untyped int", constant.MakeInt64(int64(q.F_SETLEASE))},
			"F_SETLK":                          {"untyped int", constant.MakeInt64(int64(q.F_SETLK))},
			"F_SETLK64":                        {"untyped int", constant.MakeInt64(int64(q.F_SETLK64))},
			"F_SETLKW":                         {"untyped int", constant.MakeInt64(int64(q.F_SETLKW))},
			"F_SETLKW64":                       {"untyped int", constant.MakeInt64(int64(q.F_SETLKW64))},
			"F_SETOWN":                         {"untyped int", constant.MakeInt64(int64(q.F_SETOWN))},
			"F_SETOWN_EX":                      {"untyped int", constant.MakeInt64(int64(q.F_SETOWN_EX))},
			"F_SETPIPE_SZ":                     {"untyped int", constant.MakeInt64(int64(q.F_SETPIPE_SZ))},
			"F_SETSIG":                         {"untyped int", constant.MakeInt64(int64(q.F_SETSIG))},
			"F_SHLCK":                          {"untyped int", constant.MakeInt64(int64(q.F_SHLCK))},
			"F_TEST":                           {"untyped int", constant.MakeInt64(int64(q.F_TEST))},
			"F_TLOCK":                          {"untyped int", constant.MakeInt64(int64(q.F_TLOCK))},
			"F_ULOCK":                          {"untyped int", constant.MakeInt64(int64(q.F_ULOCK))},
			"F_UNLCK":                          {"untyped int", constant.MakeInt64(int64(q.F_UNLCK))},
			"F_WRLCK":                          {"untyped int", constant.MakeInt64(int64(q.F_WRLCK))},
			"HUPCL":                            {"untyped int", constant.MakeInt64(int64(q.HUPCL))},
			"ICANON":                           {"untyped int", constant.MakeInt64(int64(q.ICANON))},
			"ICMPV6_FILTER":                    {"untyped int", constant.MakeInt64(int64(q.ICMPV6_FILTER))},
			"ICRNL":                            {"untyped int", constant.MakeInt64(int64(q.ICRNL))},
			"IEXTEN":                           {"untyped int", constant.MakeInt64(int64(q.IEXTEN))},
			"IFA_ADDRESS":                      {"untyped int", constant.MakeInt64(int64(q.IFA_ADDRESS))},
			"IFA_ANYCAST":                      {"untyped int", constant.MakeInt64(int64(q.IFA_ANYCAST))},
			"IFA_BROADCAST":                    {"untyped int", constant.MakeInt64(int64(q.IFA_BROADCAST))},
			"IFA_CACHEINFO":                    {"untyped int", constant.MakeInt64(int64(q.IFA_CACHEINFO))},
			"IFA_F_DADFAILED":                  {"untyped int", constant.MakeInt64(int64(q.IFA_F_DADFAILED))},
			"IFA_F_DEPRECATED":                 {"untyped int", constant.MakeInt64(int64(q.IFA_F_DEPRECATED))},
			"IFA_F_HOMEADDRESS":                {"untyped int", constant.MakeInt64(int64(q.IFA_F_HOMEADDRESS))},
			"IFA_F_MANAGETEMPADDR":             {"untyped int", constant.MakeInt64(int64(q.IFA_F_MANAGETEMPADDR))},
			"IFA_F_MCAUTOJOIN":                 {"untyped int", constant.MakeInt64(int64(q.IFA_F_MCAUTOJOIN))},
			"IFA_F_NODAD":                      {"untyped int", constant.MakeInt64(int64(q.IFA_F_NODAD))},
			"IFA_F_NOPREFIXROUTE":              {"untyped int", constant.MakeInt64(int64(q.IFA_F_NOPREFIXROUTE))},
			"IFA_F_OPTIMISTIC":                 {"untyped int", constant.MakeInt64(int64(q.IFA_F_OPTIMISTIC))},
			"IFA_F_PERMANENT":                  {"untyped int", constant.MakeInt64(int64(q.IFA_F_PERMANENT))},
			"IFA_F_SECONDARY":                  {"untyped int", constant.MakeInt64(int64(q.IFA_F_SECONDARY))},
			"IFA_F_STABLE_PRIVACY":             {"untyped int", constant.MakeInt64(int64(q.IFA_F_STABLE_PRIVACY))},
			"IFA_F_TEMPORARY":                  {"untyped int", constant.MakeInt64(int64(q.IFA_F_TEMPORARY))},
			"IFA_F_TENTATIVE":                  {"untyped int", constant.MakeInt64(int64(q.IFA_F_TENTATIVE))},
			"IFA_LABEL":                        {"untyped int", constant.MakeInt64(int64(q.IFA_LABEL))},
			"IFA_LOCAL":                        {"untyped int", constant.MakeInt64(int64(q.IFA_LOCAL))},
			"IFA_MAX":                          {"untyped int", constant.MakeInt64(int64(q.IFA_MAX))},
			"IFA_MULTICAST":                    {"untyped int", constant.MakeInt64(int64(q.IFA_MULTICAST))},
			"IFA_UNSPEC":                       {"untyped int", constant.MakeInt64(int64(q.IFA_UNSPEC))},
			"IFF_ALLMULTI":                     {"untyped int", constant.MakeInt64(int64(q.IFF_ALLMULTI))},
			"IFF_ATTACH_QUEUE":                 {"untyped int", constant.MakeInt64(int64(q.IFF_ATTACH_QUEUE))},
			"IFF_AUTOMEDIA":                    {"untyped int", constant.MakeInt64(int64(q.IFF_AUTOMEDIA))},
			"IFF_BROADCAST":                    {"untyped int", constant.MakeInt64(int64(q.IFF_BROADCAST))},
			"IFF_DEBUG":                        {"untyped int", constant.MakeInt64(int64(q.IFF_DEBUG))},
			"IFF_DETACH_QUEUE":                 {"untyped int", constant.MakeInt64(int64(q.IFF_DETACH_QUEUE))},
			"IFF_DORMANT":                      {"untyped int", constant.MakeInt64(int64(q.IFF_DORMANT))},
			"IFF_DYNAMIC":                      {"untyped int", constant.MakeInt64(int64(q.IFF_DYNAMIC))},
			"IFF_ECHO":                         {"untyped int", constant.MakeInt64(int64(q.IFF_ECHO))},
			"IFF_LOOPBACK":                     {"untyped int", constant.MakeInt64(int64(q.IFF_LOOPBACK))},
			"IFF_LOWER_UP":                     {"untyped int", constant.MakeInt64(int64(q.IFF_LOWER_UP))},
			"IFF_MASTER":                       {"untyped int", constant.MakeInt64(int64(q.IFF_MASTER))},
			"IFF_MULTICAST":                    {"untyped int", constant.MakeInt64(int64(q.IFF_MULTICAST))},
			"IFF_MULTI_QUEUE":                  {"untyped int", constant.MakeInt64(int64(q.IFF_MULTI_QUEUE))},
			"IFF_NOARP":                        {"untyped int", constant.MakeInt64(int64(q.IFF_NOARP))},
			"IFF_NOFILTER":                     {"untyped int", constant.MakeInt64(int64(q.IFF_NOFILTER))},
			"IFF_NOTRAILERS":                   {"untyped int", constant.MakeInt64(int64(q.IFF_NOTRAILERS))},
			"IFF_NO_PI":                        {"untyped int", constant.MakeInt64(int64(q.IFF_NO_PI))},
			"IFF_ONE_QUEUE":                    {"untyped int", constant.MakeInt64(int64(q.IFF_ONE_QUEUE))},
			"IFF_PERSIST":                      {"untyped int", constant.MakeInt64(int64(q.IFF_PERSIST))},
			"IFF_POINTOPOINT":                  {"untyped int", constant.MakeInt64(int64(q.IFF_POINTOPOINT))},
			"IFF_PORTSEL":                      {"untyped int", constant.MakeInt64(int64(q.IFF_PORTSEL))},
			"IFF_PROMISC":                      {"untyped int", constant.MakeInt64(int64(q.IFF_PROMISC))},
			"IFF_RUNNING":                      {"untyped int", constant.MakeInt64(int64(q.IFF_RUNNING))},
			"IFF_SLAVE":                        {"untyped int", constant.MakeInt64(int64(q.IFF_SLAVE))},
			"IFF_TAP":                          {"untyped int", constant.MakeInt64(int64(q.IFF_TAP))},
			"IFF_TUN":                          {"untyped int", constant.MakeInt64(int64(q.IFF_TUN))},
			"IFF_TUN_EXCL":                     {"untyped int", constant.MakeInt64(int64(q.IFF_TUN_EXCL))},
			"IFF_UP":                           {"untyped int", constant.MakeInt64(int64(q.IFF_UP))},
			"IFF_VNET_HDR":                     {"untyped int", constant.MakeInt64(int64(q.IFF_VNET_HDR))},
			"IFF_VOLATILE":                     {"untyped int", constant.MakeInt64(int64(q.IFF_VOLATILE))},
			"IFLA_ADDRESS":                     {"untyped int", constant.MakeInt64(int64(q.IFLA_ADDRESS))},
			"IFLA_BROADCAST":                   {"untyped int", constant.MakeInt64(int64(q.IFLA_BROADCAST))},
			"IFLA_COST":                        {"untyped int", constant.MakeInt64(int64(q.IFLA_COST))},
			"IFLA_IFALIAS":                     {"untyped int", constant.MakeInt64(int64(q.IFLA_IFALIAS))},
			"IFLA_IFNAME":                      {"untyped int", constant.MakeInt64(int64(q.IFLA_IFNAME))},
			"IFLA_LINK":                        {"untyped int", constant.MakeInt64(int64(q.IFLA_LINK))},
			"IFLA_LINKINFO":                    {"untyped int", constant.MakeInt64(int64(q.IFLA_LINKINFO))},
			"IFLA_LINKMODE":                    {"untyped int", constant.MakeInt64(int64(q.IFLA_LINKMODE))},
			"IFLA_MAP":                         {"untyped int", constant.MakeInt64(int64(q.IFLA_MAP))},
			"IFLA_MASTER":                      {"untyped int", constant.MakeInt64(int64(q.IFLA_MASTER))},
			"IFLA_MAX":                         {"untyped int", constant.MakeInt64(int64(q.IFLA_MAX))},
			"IFLA_MTU":                         {"untyped int", constant.MakeInt64(int64(q.IFLA_MTU))},
			"IFLA_NET_NS_PID":                  {"untyped int", constant.MakeInt64(int64(q.IFLA_NET_NS_PID))},
			"IFLA_OPERSTATE":                   {"untyped int", constant.MakeInt64(int64(q.IFLA_OPERSTATE))},
			"IFLA_PRIORITY":                    {"untyped int", constant.MakeInt64(int64(q.IFLA_PRIORITY))},
			"IFLA_PROTINFO":                    {"untyped int", constant.MakeInt64(int64(q.IFLA_PROTINFO))},
			"IFLA_QDISC":                       {"untyped int", constant.MakeInt64(int64(q.IFLA_QDISC))},
			"IFLA_STATS":                       {"untyped int", constant.MakeInt64(int64(q.IFLA_STATS))},
			"IFLA_TXQLEN":                      {"untyped int", constant.MakeInt64(int64(q.IFLA_TXQLEN))},
			"IFLA_UNSPEC":                      {"untyped int", constant.MakeInt64(int64(q.IFLA_UNSPEC))},
			"IFLA_WEIGHT":                      {"untyped int", constant.MakeInt64(int64(q.IFLA_WEIGHT))},
			"IFLA_WIRELESS":                    {"untyped int", constant.MakeInt64(int64(q.IFLA_WIRELESS))},
			"IFNAMSIZ":                         {"untyped int", constant.MakeInt64(int64(q.IFNAMSIZ))},
			"IGNBRK":                           {"untyped int", constant.MakeInt64(int64(q.IGNBRK))},
			"IGNCR":                            {"untyped int", constant.MakeInt64(int64(q.IGNCR))},
			"IGNPAR":                           {"untyped int", constant.MakeInt64(int64(q.IGNPAR))},
			"IMAXBEL":                          {"untyped int", constant.MakeInt64(int64(q.IMAXBEL))},
			"INLCR":                            {"untyped int", constant.MakeInt64(int64(q.INLCR))},
			"INPCK":                            {"untyped int", constant.MakeInt64(int64(q.INPCK))},
			"IN_ACCESS":                        {"untyped int", constant.MakeInt64(int64(q.IN_ACCESS))},
			"IN_ALL_EVENTS":                    {"untyped int", constant.MakeInt64(int64(q.IN_ALL_EVENTS))},
			"IN_ATTRIB":                        {"untyped int", constant.MakeInt64(int64(q.IN_ATTRIB))},
			"IN_CLASSA_HOST":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_HOST))},
			"IN_CLASSA_MAX":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_MAX))},
			"IN_CLASSA_NET":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NET))},
			"IN_CLASSA_NSHIFT":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NSHIFT))},
			"IN_CLASSB_HOST":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_HOST))},
			"IN_CLASSB_MAX":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_MAX))},
			"IN_CLASSB_NET":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NET))},
			"IN_CLASSB_NSHIFT":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NSHIFT))},
			"IN_CLASSC_HOST":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_HOST))},
			"IN_CLASSC_NET":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NET))},
			"IN_CLASSC_NSHIFT":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NSHIFT))},
			"IN_CLOEXEC":                       {"untyped int", constant.MakeInt64(int64(q.IN_CLOEXEC))},
			"IN_CLOSE":                         {"untyped int", constant.MakeInt64(int64(q.IN_CLOSE))},
			"IN_CLOSE_NOWRITE":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLOSE_NOWRITE))},
			"IN_CLOSE_WRITE":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLOSE_WRITE))},
			"IN_CREATE":                        {"untyped int", constant.MakeInt64(int64(q.IN_CREATE))},
			"IN_DELETE":                        {"untyped int", constant.MakeInt64(int64(q.IN_DELETE))},
			"IN_DELETE_SELF":                   {"untyped int", constant.MakeInt64(int64(q.IN_DELETE_SELF))},
			"IN_DONT_FOLLOW":                   {"untyped int", constant.MakeInt64(int64(q.IN_DONT_FOLLOW))},
			"IN_EXCL_UNLINK":                   {"untyped int", constant.MakeInt64(int64(q.IN_EXCL_UNLINK))},
			"IN_IGNORED":                       {"untyped int", constant.MakeInt64(int64(q.IN_IGNORED))},
			"IN_ISDIR":                         {"untyped int", constant.MakeInt64(int64(q.IN_ISDIR))},
			"IN_LOOPBACKNET":                   {"untyped int", constant.MakeInt64(int64(q.IN_LOOPBACKNET))},
			"IN_MASK_ADD":                      {"untyped int", constant.MakeInt64(int64(q.IN_MASK_ADD))},
			"IN_MODIFY":                        {"untyped int", constant.MakeInt64(int64(q.IN_MODIFY))},
			"IN_MOVE":                          {"untyped int", constant.MakeInt64(int64(q.IN_MOVE))},
			"IN_MOVED_FROM":                    {"untyped int", constant.MakeInt64(int64(q.IN_MOVED_FROM))},
			"IN_MOVED_TO":                      {"untyped int", constant.MakeInt64(int64(q.IN_MOVED_TO))},
			"IN_MOVE_SELF":                     {"untyped int", constant.MakeInt64(int64(q.IN_MOVE_SELF))},
			"IN_NONBLOCK":                      {"untyped int", constant.MakeInt64(int64(q.IN_NONBLOCK))},
			"IN_ONESHOT":                       {"untyped int", constant.MakeInt64(int64(q.IN_ONESHOT))},
			"IN_ONLYDIR":                       {"untyped int", constant.MakeInt64(int64(q.IN_ONLYDIR))},
			"IN_OPEN":                          {"untyped int", constant.MakeInt64(int64(q.IN_OPEN))},
			"IN_Q_OVERFLOW":                    {"untyped int", constant.MakeInt64(int64(q.IN_Q_OVERFLOW))},
			"IN_UNMOUNT":                       {"untyped int", constant.MakeInt64(int64(q.IN_UNMOUNT))},
			"IPPROTO_AH":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AH))},
			"IPPROTO_BEETPH":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BEETPH))},
			"IPPROTO_COMP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_COMP))},
			"IPPROTO_DCCP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DCCP))},
			"IPPROTO_DSTOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DSTOPTS))},
			"IPPROTO_EGP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EGP))},
			"IPPROTO_ENCAP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ENCAP))},
			"IPPROTO_ESP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ESP))},
			"IPPROTO_FRAGMENT":                 {"untyped int", constant.MakeInt64(int64(q.IPPROTO_FRAGMENT))},
			"IPPROTO_GRE":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GRE))},
			"IPPROTO_HOPOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HOPOPTS))},
			"IPPROTO_ICMP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMP))},
			"IPPROTO_ICMPV6":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMPV6))},
			"IPPROTO_IDP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDP))},
			"IPPROTO_IGMP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGMP))},
			"IPPROTO_IP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IP))},
			"IPPROTO_IPIP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPIP))},
			"IPPROTO_IPV6":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV6))},
			"IPPROTO_MH":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MH))},
			"IPPROTO_MTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MTP))},
			"IPPROTO_NONE":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NONE))},
			"IPPROTO_PIM":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PIM))},
			"IPPROTO_PUP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PUP))},
			"IPPROTO_RAW":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RAW))},
			"IPPROTO_ROUTING":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ROUTING))},
			"IPPROTO_RSVP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RSVP))},
			"IPPROTO_SCTP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SCTP))},
			"IPPROTO_TCP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCP))},
			"IPPROTO_TP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TP))},
			"IPPROTO_UDP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDP))},
			"IPPROTO_UDPLITE":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDPLITE))},
			"IPV6_2292DSTOPTS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_2292DSTOPTS))},
			"IPV6_2292HOPLIMIT":                {"untyped int", constant.MakeInt64(int64(q.IPV6_2292HOPLIMIT))},
			"IPV6_2292HOPOPTS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_2292HOPOPTS))},
			"IPV6_2292PKTINFO":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_2292PKTINFO))},
			"IPV6_2292PKTOPTIONS":              {"untyped int", constant.MakeInt64(int64(q.IPV6_2292PKTOPTIONS))},
			"IPV6_2292RTHDR":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_2292RTHDR))},
			"IPV6_ADDRFORM":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_ADDRFORM))},
			"IPV6_ADD_MEMBERSHIP":              {"untyped int", constant.MakeInt64(int64(q.IPV6_ADD_MEMBERSHIP))},
			"IPV6_AUTHHDR":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_AUTHHDR))},
			"IPV6_CHECKSUM":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_CHECKSUM))},
			"IPV6_DROP_MEMBERSHIP":             {"untyped int", constant.MakeInt64(int64(q.IPV6_DROP_MEMBERSHIP))},
			"IPV6_DSTOPTS":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_DSTOPTS))},
			"IPV6_HOPLIMIT":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPLIMIT))},
			"IPV6_HOPOPTS":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPOPTS))},
			"IPV6_IPSEC_POLICY":                {"untyped int", constant.MakeInt64(int64(q.IPV6_IPSEC_POLICY))},
			"IPV6_JOIN_ANYCAST":                {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_ANYCAST))},
			"IPV6_JOIN_GROUP":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_GROUP))},
			"IPV6_LEAVE_ANYCAST":               {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_ANYCAST))},
			"IPV6_LEAVE_GROUP":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_GROUP))},
			"IPV6_MTU":                         {"untyped int", constant.MakeInt64(int64(q.IPV6_MTU))},
			"IPV6_MTU_DISCOVER":                {"untyped int", constant.MakeInt64(int64(q.IPV6_MTU_DISCOVER))},
			"IPV6_MULTICAST_HOPS":              {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_HOPS))},
			"IPV6_MULTICAST_IF":                {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_IF))},
			"IPV6_MULTICAST_LOOP":              {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_LOOP))},
			"IPV6_NEXTHOP":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_NEXTHOP))},
			"IPV6_PKTINFO":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_PKTINFO))},
			"IPV6_PMTUDISC_DO":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_PMTUDISC_DO))},
			"IPV6_PMTUDISC_DONT":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PMTUDISC_DONT))},
			"IPV6_PMTUDISC_INTERFACE":          {"untyped int", constant.MakeInt64(int64(q.IPV6_PMTUDISC_INTERFACE))},
			"IPV6_PMTUDISC_OMIT":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PMTUDISC_OMIT))},
			"IPV6_PMTUDISC_PROBE":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PMTUDISC_PROBE))},
			"IPV6_PMTUDISC_WANT":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PMTUDISC_WANT))},
			"IPV6_RECVDSTOPTS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVDSTOPTS))},
			"IPV6_RECVERR":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVERR))},
			"IPV6_RECVHOPLIMIT":                {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPLIMIT))},
			"IPV6_RECVHOPOPTS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPOPTS))},
			"IPV6_RECVPKTINFO":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPKTINFO))},
			"IPV6_RECVRTHDR":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVRTHDR))},
			"IPV6_RECVTCLASS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVTCLASS))},
			"IPV6_ROUTER_ALERT":                {"untyped int", constant.MakeInt64(int64(q.IPV6_ROUTER_ALERT))},
			"IPV6_RTHDR":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR))},
			"IPV6_RTHDRDSTOPTS":                {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDRDSTOPTS))},
			"IPV6_RTHDR_LOOSE":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_LOOSE))},
			"IPV6_RTHDR_STRICT":                {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_STRICT))},
			"IPV6_RTHDR_TYPE_0":                {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_TYPE_0))},
			"IPV6_RXDSTOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_RXDSTOPTS))},
			"IPV6_RXHOPOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_RXHOPOPTS))},
			"IPV6_TCLASS":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_TCLASS))},
			"IPV6_UNICAST_HOPS":                {"untyped int", constant.MakeInt64(int64(q.IPV6_UNICAST_HOPS))},
			"IPV6_V6ONLY":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_V6ONLY))},
			"IPV6_XFRM_POLICY":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_XFRM_POLICY))},
			"IP_ADD_MEMBERSHIP":                {"untyped int", constant.MakeInt64(int64(q.IP_ADD_MEMBERSHIP))},
			"IP_ADD_SOURCE_MEMBERSHIP":         {"untyped int", constant.MakeInt64(int64(q.IP_ADD_SOURCE_MEMBERSHIP))},
			"IP_BLOCK_SOURCE":                  {"untyped int", constant.MakeInt64(int64(q.IP_BLOCK_SOURCE))},
			"IP_DEFAULT_MULTICAST_LOOP":        {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_LOOP))},
			"IP_DEFAULT_MULTICAST_TTL":         {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_TTL))},
			"IP_DF":                            {"untyped int", constant.MakeInt64(int64(q.IP_DF))},
			"IP_DROP_MEMBERSHIP":               {"untyped int", constant.MakeInt64(int64(q.IP_DROP_MEMBERSHIP))},
			"IP_DROP_SOURCE_MEMBERSHIP":        {"untyped int", constant.MakeInt64(int64(q.IP_DROP_SOURCE_MEMBERSHIP))},
			"IP_FREEBIND":                      {"untyped int", constant.MakeInt64(int64(q.IP_FREEBIND))},
			"IP_HDRINCL":                       {"untyped int", constant.MakeInt64(int64(q.IP_HDRINCL))},
			"IP_IPSEC_POLICY":                  {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_POLICY))},
			"IP_MAXPACKET":                     {"untyped int", constant.MakeInt64(int64(q.IP_MAXPACKET))},
			"IP_MAX_MEMBERSHIPS":               {"untyped int", constant.MakeInt64(int64(q.IP_MAX_MEMBERSHIPS))},
			"IP_MF":                            {"untyped int", constant.MakeInt64(int64(q.IP_MF))},
			"IP_MINTTL":                        {"untyped int", constant.MakeInt64(int64(q.IP_MINTTL))},
			"IP_MSFILTER":                      {"untyped int", constant.MakeInt64(int64(q.IP_MSFILTER))},
			"IP_MSS":                           {"untyped int", constant.MakeInt64(int64(q.IP_MSS))},
			"IP_MTU":                           {"untyped int", constant.MakeInt64(int64(q.IP_MTU))},
			"IP_MTU_DISCOVER":                  {"untyped int", constant.MakeInt64(int64(q.IP_MTU_DISCOVER))},
			"IP_MULTICAST_ALL":                 {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_ALL))},
			"IP_MULTICAST_IF":                  {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IF))},
			"IP_MULTICAST_LOOP":                {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_LOOP))},
			"IP_MULTICAST_TTL":                 {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_TTL))},
			"IP_NODEFRAG":                      {"untyped int", constant.MakeInt64(int64(q.IP_NODEFRAG))},
			"IP_OFFMASK":                       {"untyped int", constant.MakeInt64(int64(q.IP_OFFMASK))},
			"IP_OPTIONS":                       {"untyped int", constant.MakeInt64(int64(q.IP_OPTIONS))},
			"IP_ORIGDSTADDR":                   {"untyped int", constant.MakeInt64(int64(q.IP_ORIGDSTADDR))},
			"IP_PASSSEC":                       {"untyped int", constant.MakeInt64(int64(q.IP_PASSSEC))},
			"IP_PKTINFO":                       {"untyped int", constant.MakeInt64(int64(q.IP_PKTINFO))},
			"IP_PKTOPTIONS":                    {"untyped int", constant.MakeInt64(int64(q.IP_PKTOPTIONS))},
			"IP_PMTUDISC":                      {"untyped int", constant.MakeInt64(int64(q.IP_PMTUDISC))},
			"IP_PMTUDISC_DO":                   {"untyped int", constant.MakeInt64(int64(q.IP_PMTUDISC_DO))},
			"IP_PMTUDISC_DONT":                 {"untyped int", constant.MakeInt64(int64(q.IP_PMTUDISC_DONT))},
			"IP_PMTUDISC_INTERFACE":            {"untyped int", constant.MakeInt64(int64(q.IP_PMTUDISC_INTERFACE))},
			"IP_PMTUDISC_OMIT":                 {"untyped int", constant.MakeInt64(int64(q.IP_PMTUDISC_OMIT))},
			"IP_PMTUDISC_PROBE":                {"untyped int", constant.MakeInt64(int64(q.IP_PMTUDISC_PROBE))},
			"IP_PMTUDISC_WANT":                 {"untyped int", constant.MakeInt64(int64(q.IP_PMTUDISC_WANT))},
			"IP_RECVERR":                       {"untyped int", constant.MakeInt64(int64(q.IP_RECVERR))},
			"IP_RECVOPTS":                      {"untyped int", constant.MakeInt64(int64(q.IP_RECVOPTS))},
			"IP_RECVORIGDSTADDR":               {"untyped int", constant.MakeInt64(int64(q.IP_RECVORIGDSTADDR))},
			"IP_RECVRETOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IP_RECVRETOPTS))},
			"IP_RECVTOS":                       {"untyped int", constant.MakeInt64(int64(q.IP_RECVTOS))},
			"IP_RECVTTL":                       {"untyped int", constant.MakeInt64(int64(q.IP_RECVTTL))},
			"IP_RETOPTS":                       {"untyped int", constant.MakeInt64(int64(q.IP_RETOPTS))},
			"IP_RF":                            {"untyped int", constant.MakeInt64(int64(q.IP_RF))},
			"IP_ROUTER_ALERT":                  {"untyped int", constant.MakeInt64(int64(q.IP_ROUTER_ALERT))},
			"IP_TOS":                           {"untyped int", constant.MakeInt64(int64(q.IP_TOS))},
			"IP_TRANSPARENT":                   {"untyped int", constant.MakeInt64(int64(q.IP_TRANSPARENT))},
			"IP_TTL":                           {"untyped int", constant.MakeInt64(int64(q.IP_TTL))},
			"IP_UNBLOCK_SOURCE":                {"untyped int", constant.MakeInt64(int64(q.IP_UNBLOCK_SOURCE))},
			"IP_UNICAST_IF":                    {"untyped int", constant.MakeInt64(int64(q.IP_UNICAST_IF))},
			"IP_XFRM_POLICY":                   {"untyped int", constant.MakeInt64(int64(q.IP_XFRM_POLICY))},
			"ISIG":                             {"untyped int", constant.MakeInt64(int64(q.ISIG))},
			"ISTRIP":                           {"untyped int", constant.MakeInt64(int64(q.ISTRIP))},
			"IUCLC":                            {"untyped int", constant.MakeInt64(int64(q.IUCLC))},
			"IUTF8":                            {"untyped int", constant.MakeInt64(int64(q.IUTF8))},
			"IXANY":                            {"untyped int", constant.MakeInt64(int64(q.IXANY))},
			"IXOFF":                            {"untyped int", constant.MakeInt64(int64(q.IXOFF))},
			"IXON":                             {"untyped int", constant.MakeInt64(int64(q.IXON))},
			"ImplementsGetwd":                  {"untyped bool", constant.MakeBool(bool(q.ImplementsGetwd))},
			"LINUX_REBOOT_CMD_CAD_OFF":         {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_CAD_OFF))},
			"LINUX_REBOOT_CMD_CAD_ON":          {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_CAD_ON))},
			"LINUX_REBOOT_CMD_HALT":            {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_HALT))},
			"LINUX_REBOOT_CMD_KEXEC":           {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_KEXEC))},
			"LINUX_REBOOT_CMD_POWER_OFF":       {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_POWER_OFF))},
			"LINUX_REBOOT_CMD_RESTART":         {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_RESTART))},
			"LINUX_REBOOT_CMD_RESTART2":        {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_RESTART2))},
			"LINUX_REBOOT_CMD_SW_SUSPEND":      {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_CMD_SW_SUSPEND))},
			"LINUX_REBOOT_MAGIC1":              {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_MAGIC1))},
			"LINUX_REBOOT_MAGIC2":              {"untyped int", constant.MakeInt64(int64(q.LINUX_REBOOT_MAGIC2))},
			"LOCK_EX":                          {"untyped int", constant.MakeInt64(int64(q.LOCK_EX))},
			"LOCK_NB":                          {"untyped int", constant.MakeInt64(int64(q.LOCK_NB))},
			"LOCK_SH":                          {"untyped int", constant.MakeInt64(int64(q.LOCK_SH))},
			"LOCK_UN":                          {"untyped int", constant.MakeInt64(int64(q.LOCK_UN))},
			"MADV_DODUMP":                      {"untyped int", constant.MakeInt64(int64(q.MADV_DODUMP))},
			"MADV_DOFORK":                      {"untyped int", constant.MakeInt64(int64(q.MADV_DOFORK))},
			"MADV_DONTDUMP":                    {"untyped int", constant.MakeInt64(int64(q.MADV_DONTDUMP))},
			"MADV_DONTFORK":                    {"untyped int", constant.MakeInt64(int64(q.MADV_DONTFORK))},
			"MADV_DONTNEED":                    {"untyped int", constant.MakeInt64(int64(q.MADV_DONTNEED))},
			"MADV_HUGEPAGE":                    {"untyped int", constant.MakeInt64(int64(q.MADV_HUGEPAGE))},
			"MADV_HWPOISON":                    {"untyped int", constant.MakeInt64(int64(q.MADV_HWPOISON))},
			"MADV_MERGEABLE":                   {"untyped int", constant.MakeInt64(int64(q.MADV_MERGEABLE))},
			"MADV_NOHUGEPAGE":                  {"untyped int", constant.MakeInt64(int64(q.MADV_NOHUGEPAGE))},
			"MADV_NORMAL":                      {"untyped int", constant.MakeInt64(int64(q.MADV_NORMAL))},
			"MADV_RANDOM":                      {"untyped int", constant.MakeInt64(int64(q.MADV_RANDOM))},
			"MADV_REMOVE":                      {"untyped int", constant.MakeInt64(int64(q.MADV_REMOVE))},
			"MADV_SEQUENTIAL":                  {"untyped int", constant.MakeInt64(int64(q.MADV_SEQUENTIAL))},
			"MADV_UNMERGEABLE":                 {"untyped int", constant.MakeInt64(int64(q.MADV_UNMERGEABLE))},
			"MADV_WILLNEED":                    {"untyped int", constant.MakeInt64(int64(q.MADV_WILLNEED))},
			"MAP_ANON":                         {"untyped int", constant.MakeInt64(int64(q.MAP_ANON))},
			"MAP_ANONYMOUS":                    {"untyped int", constant.MakeInt64(int64(q.MAP_ANONYMOUS))},
			"MAP_DENYWRITE":                    {"untyped int", constant.MakeInt64(int64(q.MAP_DENYWRITE))},
			"MAP_EXECUTABLE":                   {"untyped int", constant.MakeInt64(int64(q.MAP_EXECUTABLE))},
			"MAP_FILE":                         {"untyped int", constant.MakeInt64(int64(q.MAP_FILE))},
			"MAP_FIXED":                        {"untyped int", constant.MakeInt64(int64(q.MAP_FIXED))},
			"MAP_GROWSDOWN":                    {"untyped int", constant.MakeInt64(int64(q.MAP_GROWSDOWN))},
			"MAP_HUGETLB":                      {"untyped int", constant.MakeInt64(int64(q.MAP_HUGETLB))},
			"MAP_HUGE_MASK":                    {"untyped int", constant.MakeInt64(int64(q.MAP_HUGE_MASK))},
			"MAP_HUGE_SHIFT":                   {"untyped int", constant.MakeInt64(int64(q.MAP_HUGE_SHIFT))},
			"MAP_LOCKED":                       {"untyped int", constant.MakeInt64(int64(q.MAP_LOCKED))},
			"MAP_NONBLOCK":                     {"untyped int", constant.MakeInt64(int64(q.MAP_NONBLOCK))},
			"MAP_NORESERVE":                    {"untyped int", constant.MakeInt64(int64(q.MAP_NORESERVE))},
			"MAP_POPULATE":                     {"untyped int", constant.MakeInt64(int64(q.MAP_POPULATE))},
			"MAP_PRIVATE":                      {"untyped int", constant.MakeInt64(int64(q.MAP_PRIVATE))},
			"MAP_SHARED":                       {"untyped int", constant.MakeInt64(int64(q.MAP_SHARED))},
			"MAP_STACK":                        {"untyped int", constant.MakeInt64(int64(q.MAP_STACK))},
			"MAP_TYPE":                         {"untyped int", constant.MakeInt64(int64(q.MAP_TYPE))},
			"MCL_CURRENT":                      {"untyped int", constant.MakeInt64(int64(q.MCL_CURRENT))},
			"MCL_FUTURE":                       {"untyped int", constant.MakeInt64(int64(q.MCL_FUTURE))},
			"MNT_DETACH":                       {"untyped int", constant.MakeInt64(int64(q.MNT_DETACH))},
			"MNT_EXPIRE":                       {"untyped int", constant.MakeInt64(int64(q.MNT_EXPIRE))},
			"MNT_FORCE":                        {"untyped int", constant.MakeInt64(int64(q.MNT_FORCE))},
			"MSG_CMSG_CLOEXEC":                 {"untyped int", constant.MakeInt64(int64(q.MSG_CMSG_CLOEXEC))},
			"MSG_CONFIRM":                      {"untyped int", constant.MakeInt64(int64(q.MSG_CONFIRM))},
			"MSG_CTRUNC":                       {"untyped int", constant.MakeInt64(int64(q.MSG_CTRUNC))},
			"MSG_DONTROUTE":                    {"untyped int", constant.MakeInt64(int64(q.MSG_DONTROUTE))},
			"MSG_DONTWAIT":                     {"untyped int", constant.MakeInt64(int64(q.MSG_DONTWAIT))},
			"MSG_EOR":                          {"untyped int", constant.MakeInt64(int64(q.MSG_EOR))},
			"MSG_ERRQUEUE":                     {"untyped int", constant.MakeInt64(int64(q.MSG_ERRQUEUE))},
			"MSG_FASTOPEN":                     {"untyped int", constant.MakeInt64(int64(q.MSG_FASTOPEN))},
			"MSG_FIN":                          {"untyped int", constant.MakeInt64(int64(q.MSG_FIN))},
			"MSG_MORE":                         {"untyped int", constant.MakeInt64(int64(q.MSG_MORE))},
			"MSG_NOSIGNAL":                     {"untyped int", constant.MakeInt64(int64(q.MSG_NOSIGNAL))},
			"MSG_OOB":                          {"untyped int", constant.MakeInt64(int64(q.MSG_OOB))},
			"MSG_PEEK":                         {"untyped int", constant.MakeInt64(int64(q.MSG_PEEK))},
			"MSG_PROXY":                        {"untyped int", constant.MakeInt64(int64(q.MSG_PROXY))},
			"MSG_RST":                          {"untyped int", constant.MakeInt64(int64(q.MSG_RST))},
			"MSG_SYN":                          {"untyped int", constant.MakeInt64(int64(q.MSG_SYN))},
			"MSG_TRUNC":                        {"untyped int", constant.MakeInt64(int64(q.MSG_TRUNC))},
			"MSG_TRYHARD":                      {"untyped int", constant.MakeInt64(int64(q.MSG_TRYHARD))},
			"MSG_WAITALL":                      {"untyped int", constant.MakeInt64(int64(q.MSG_WAITALL))},
			"MSG_WAITFORONE":                   {"untyped int", constant.MakeInt64(int64(q.MSG_WAITFORONE))},
			"MS_ACTIVE":                        {"untyped int", constant.MakeInt64(int64(q.MS_ACTIVE))},
			"MS_ASYNC":                         {"untyped int", constant.MakeInt64(int64(q.MS_ASYNC))},
			"MS_BIND":                          {"untyped int", constant.MakeInt64(int64(q.MS_BIND))},
			"MS_DIRSYNC":                       {"untyped int", constant.MakeInt64(int64(q.MS_DIRSYNC))},
			"MS_INVALIDATE":                    {"untyped int", constant.MakeInt64(int64(q.MS_INVALIDATE))},
			"MS_I_VERSION":                     {"untyped int", constant.MakeInt64(int64(q.MS_I_VERSION))},
			"MS_KERNMOUNT":                     {"untyped int", constant.MakeInt64(int64(q.MS_KERNMOUNT))},
			"MS_MANDLOCK":                      {"untyped int", constant.MakeInt64(int64(q.MS_MANDLOCK))},
			"MS_MGC_MSK":                       {"untyped int", constant.MakeInt64(int64(q.MS_MGC_MSK))},
			"MS_MGC_VAL":                       {"untyped int", constant.MakeInt64(int64(q.MS_MGC_VAL))},
			"MS_MOVE":                          {"untyped int", constant.MakeInt64(int64(q.MS_MOVE))},
			"MS_NOATIME":                       {"untyped int", constant.MakeInt64(int64(q.MS_NOATIME))},
			"MS_NODEV":                         {"untyped int", constant.MakeInt64(int64(q.MS_NODEV))},
			"MS_NODIRATIME":                    {"untyped int", constant.MakeInt64(int64(q.MS_NODIRATIME))},
			"MS_NOEXEC":                        {"untyped int", constant.MakeInt64(int64(q.MS_NOEXEC))},
			"MS_NOSUID":                        {"untyped int", constant.MakeInt64(int64(q.MS_NOSUID))},
			"MS_NOUSER":                        {"untyped int", constant.MakeInt64(int64(q.MS_NOUSER))},
			"MS_POSIXACL":                      {"untyped int", constant.MakeInt64(int64(q.MS_POSIXACL))},
			"MS_PRIVATE":                       {"untyped int", constant.MakeInt64(int64(q.MS_PRIVATE))},
			"MS_RDONLY":                        {"untyped int", constant.MakeInt64(int64(q.MS_RDONLY))},
			"MS_REC":                           {"untyped int", constant.MakeInt64(int64(q.MS_REC))},
			"MS_RELATIME":                      {"untyped int", constant.MakeInt64(int64(q.MS_RELATIME))},
			"MS_REMOUNT":                       {"untyped int", constant.MakeInt64(int64(q.MS_REMOUNT))},
			"MS_RMT_MASK":                      {"untyped int", constant.MakeInt64(int64(q.MS_RMT_MASK))},
			"MS_SHARED":                        {"untyped int", constant.MakeInt64(int64(q.MS_SHARED))},
			"MS_SILENT":                        {"untyped int", constant.MakeInt64(int64(q.MS_SILENT))},
			"MS_SLAVE":                         {"untyped int", constant.MakeInt64(int64(q.MS_SLAVE))},
			"MS_STRICTATIME":                   {"untyped int", constant.MakeInt64(int64(q.MS_STRICTATIME))},
			"MS_SYNC":                          {"untyped int", constant.MakeInt64(int64(q.MS_SYNC))},
			"MS_SYNCHRONOUS":                   {"untyped int", constant.MakeInt64(int64(q.MS_SYNCHRONOUS))},
			"MS_UNBINDABLE":                    {"untyped int", constant.MakeInt64(int64(q.MS_UNBINDABLE))},
			"NAME_MAX":                         {"untyped int", constant.MakeInt64(int64(q.NAME_MAX))},
			"NETLINK_ADD_MEMBERSHIP":           {"untyped int", constant.MakeInt64(int64(q.NETLINK_ADD_MEMBERSHIP))},
			"NETLINK_AUDIT":                    {"untyped int", constant.MakeInt64(int64(q.NETLINK_AUDIT))},
			"NETLINK_BROADCAST_ERROR":          {"untyped int", constant.MakeInt64(int64(q.NETLINK_BROADCAST_ERROR))},
			"NETLINK_CAP_ACK":                  {"untyped int", constant.MakeInt64(int64(q.NETLINK_CAP_ACK))},
			"NETLINK_CONNECTOR":                {"untyped int", constant.MakeInt64(int64(q.NETLINK_CONNECTOR))},
			"NETLINK_CRYPTO":                   {"untyped int", constant.MakeInt64(int64(q.NETLINK_CRYPTO))},
			"NETLINK_DNRTMSG":                  {"untyped int", constant.MakeInt64(int64(q.NETLINK_DNRTMSG))},
			"NETLINK_DROP_MEMBERSHIP":          {"untyped int", constant.MakeInt64(int64(q.NETLINK_DROP_MEMBERSHIP))},
			"NETLINK_ECRYPTFS":                 {"untyped int", constant.MakeInt64(int64(q.NETLINK_ECRYPTFS))},
			"NETLINK_FIB_LOOKUP":               {"untyped int", constant.MakeInt64(int64(q.NETLINK_FIB_LOOKUP))},
			"NETLINK_FIREWALL":                 {"untyped int", constant.MakeInt64(int64(q.NETLINK_FIREWALL))},
			"NETLINK_GENERIC":                  {"untyped int", constant.MakeInt64(int64(q.NETLINK_GENERIC))},
			"NETLINK_INET_DIAG":                {"untyped int", constant.MakeInt64(int64(q.NETLINK_INET_DIAG))},
			"NETLINK_IP6_FW":                   {"untyped int", constant.MakeInt64(int64(q.NETLINK_IP6_FW))},
			"NETLINK_ISCSI":                    {"untyped int", constant.MakeInt64(int64(q.NETLINK_ISCSI))},
			"NETLINK_KOBJECT_UEVENT":           {"untyped int", constant.MakeInt64(int64(q.NETLINK_KOBJECT_UEVENT))},
			"NETLINK_LISTEN_ALL_NSID":          {"untyped int", constant.MakeInt64(int64(q.NETLINK_LISTEN_ALL_NSID))},
			"NETLINK_LIST_MEMBERSHIPS":         {"untyped int", constant.MakeInt64(int64(q.NETLINK_LIST_MEMBERSHIPS))},
			"NETLINK_NETFILTER":                {"untyped int", constant.MakeInt64(int64(q.NETLINK_NETFILTER))},
			"NETLINK_NFLOG":                    {"untyped int", constant.MakeInt64(int64(q.NETLINK_NFLOG))},
			"NETLINK_NO_ENOBUFS":               {"untyped int", constant.MakeInt64(int64(q.NETLINK_NO_ENOBUFS))},
			"NETLINK_PKTINFO":                  {"untyped int", constant.MakeInt64(int64(q.NETLINK_PKTINFO))},
			"NETLINK_RDMA":                     {"untyped int", constant.MakeInt64(int64(q.NETLINK_RDMA))},
			"NETLINK_ROUTE":                    {"untyped int", constant.MakeInt64(int64(q.NETLINK_ROUTE))},
			"NETLINK_RX_RING":                  {"untyped int", constant.MakeInt64(int64(q.NETLINK_RX_RING))},
			"NETLINK_SCSITRANSPORT":            {"untyped int", constant.MakeInt64(int64(q.NETLINK_SCSITRANSPORT))},
			"NETLINK_SELINUX":                  {"untyped int", constant.MakeInt64(int64(q.NETLINK_SELINUX))},
			"NETLINK_SOCK_DIAG":                {"untyped int", constant.MakeInt64(int64(q.NETLINK_SOCK_DIAG))},
			"NETLINK_TX_RING":                  {"untyped int", constant.MakeInt64(int64(q.NETLINK_TX_RING))},
			"NETLINK_UNUSED":                   {"untyped int", constant.MakeInt64(int64(q.NETLINK_UNUSED))},
			"NETLINK_USERSOCK":                 {"untyped int", constant.MakeInt64(int64(q.NETLINK_USERSOCK))},
			"NETLINK_XFRM":                     {"untyped int", constant.MakeInt64(int64(q.NETLINK_XFRM))},
			"NLA_ALIGNTO":                      {"untyped int", constant.MakeInt64(int64(q.NLA_ALIGNTO))},
			"NLA_F_NESTED":                     {"untyped int", constant.MakeInt64(int64(q.NLA_F_NESTED))},
			"NLA_F_NET_BYTEORDER":              {"untyped int", constant.MakeInt64(int64(q.NLA_F_NET_BYTEORDER))},
			"NLA_HDRLEN":                       {"untyped int", constant.MakeInt64(int64(q.NLA_HDRLEN))},
			"NLMSG_ALIGNTO":                    {"untyped int", constant.MakeInt64(int64(q.NLMSG_ALIGNTO))},
			"NLMSG_DONE":                       {"untyped int", constant.MakeInt64(int64(q.NLMSG_DONE))},
			"NLMSG_ERROR":                      {"untyped int", constant.MakeInt64(int64(q.NLMSG_ERROR))},
			"NLMSG_HDRLEN":                     {"untyped int", constant.MakeInt64(int64(q.NLMSG_HDRLEN))},
			"NLMSG_MIN_TYPE":                   {"untyped int", constant.MakeInt64(int64(q.NLMSG_MIN_TYPE))},
			"NLMSG_NOOP":                       {"untyped int", constant.MakeInt64(int64(q.NLMSG_NOOP))},
			"NLMSG_OVERRUN":                    {"untyped int", constant.MakeInt64(int64(q.NLMSG_OVERRUN))},
			"NLM_F_ACK":                        {"untyped int", constant.MakeInt64(int64(q.NLM_F_ACK))},
			"NLM_F_APPEND":                     {"untyped int", constant.MakeInt64(int64(q.NLM_F_APPEND))},
			"NLM_F_ATOMIC":                     {"untyped int", constant.MakeInt64(int64(q.NLM_F_ATOMIC))},
			"NLM_F_CREATE":                     {"untyped int", constant.MakeInt64(int64(q.NLM_F_CREATE))},
			"NLM_F_DUMP":                       {"untyped int", constant.MakeInt64(int64(q.NLM_F_DUMP))},
			"NLM_F_DUMP_FILTERED":              {"untyped int", constant.MakeInt64(int64(q.NLM_F_DUMP_FILTERED))},
			"NLM_F_DUMP_INTR":                  {"untyped int", constant.MakeInt64(int64(q.NLM_F_DUMP_INTR))},
			"NLM_F_ECHO":                       {"untyped int", constant.MakeInt64(int64(q.NLM_F_ECHO))},
			"NLM_F_EXCL":                       {"untyped int", constant.MakeInt64(int64(q.NLM_F_EXCL))},
			"NLM_F_MATCH":                      {"untyped int", constant.MakeInt64(int64(q.NLM_F_MATCH))},
			"NLM_F_MULTI":                      {"untyped int", constant.MakeInt64(int64(q.NLM_F_MULTI))},
			"NLM_F_REPLACE":                    {"untyped int", constant.MakeInt64(int64(q.NLM_F_REPLACE))},
			"NLM_F_REQUEST":                    {"untyped int", constant.MakeInt64(int64(q.NLM_F_REQUEST))},
			"NLM_F_ROOT":                       {"untyped int", constant.MakeInt64(int64(q.NLM_F_ROOT))},
			"NOFLSH":                           {"untyped int", constant.MakeInt64(int64(q.NOFLSH))},
			"OCRNL":                            {"untyped int", constant.MakeInt64(int64(q.OCRNL))},
			"OFDEL":                            {"untyped int", constant.MakeInt64(int64(q.OFDEL))},
			"OFILL":                            {"untyped int", constant.MakeInt64(int64(q.OFILL))},
			"OLCUC":                            {"untyped int", constant.MakeInt64(int64(q.OLCUC))},
			"ONLCR":                            {"untyped int", constant.MakeInt64(int64(q.ONLCR))},
			"ONLRET":                           {"untyped int", constant.MakeInt64(int64(q.ONLRET))},
			"ONOCR":                            {"untyped int", constant.MakeInt64(int64(q.ONOCR))},
			"OPOST":                            {"untyped int", constant.MakeInt64(int64(q.OPOST))},
			"O_ACCMODE":                        {"untyped int", constant.MakeInt64(int64(q.O_ACCMODE))},
			"O_APPEND":                         {"untyped int", constant.MakeInt64(int64(q.O_APPEND))},
			"O_ASYNC":                          {"untyped int", constant.MakeInt64(int64(q.O_ASYNC))},
			"O_CLOEXEC":                        {"untyped int", constant.MakeInt64(int64(q.O_CLOEXEC))},
			"O_CREAT":                          {"untyped int", constant.MakeInt64(int64(q.O_CREAT))},
			"O_DIRECT":                         {"untyped int", constant.MakeInt64(int64(q.O_DIRECT))},
			"O_DIRECTORY":                      {"untyped int", constant.MakeInt64(int64(q.O_DIRECTORY))},
			"O_DSYNC":                          {"untyped int", constant.MakeInt64(int64(q.O_DSYNC))},
			"O_EXCL":                           {"untyped int", constant.MakeInt64(int64(q.O_EXCL))},
			"O_FSYNC":                          {"untyped int", constant.MakeInt64(int64(q.O_FSYNC))},
			"O_LARGEFILE":                      {"untyped int", constant.MakeInt64(int64(q.O_LARGEFILE))},
			"O_NDELAY":                         {"untyped int", constant.MakeInt64(int64(q.O_NDELAY))},
			"O_NOATIME":                        {"untyped int", constant.MakeInt64(int64(q.O_NOATIME))},
			"O_NOCTTY":                         {"untyped int", constant.MakeInt64(int64(q.O_NOCTTY))},
			"O_NOFOLLOW":                       {"untyped int", constant.MakeInt64(int64(q.O_NOFOLLOW))},
			"O_NONBLOCK":                       {"untyped int", constant.MakeInt64(int64(q.O_NONBLOCK))},
			"O_PATH":                           {"untyped int", constant.MakeInt64(int64(q.O_PATH))},
			"O_RDONLY":                         {"untyped int", constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":                           {"untyped int", constant.MakeInt64(int64(q.O_RDWR))},
			"O_RSYNC":                          {"untyped int", constant.MakeInt64(int64(q.O_RSYNC))},
			"O_SYNC":                           {"untyped int", constant.MakeInt64(int64(q.O_SYNC))},
			"O_TMPFILE":                        {"untyped int", constant.MakeInt64(int64(q.O_TMPFILE))},
			"O_TRUNC":                          {"untyped int", constant.MakeInt64(int64(q.O_TRUNC))},
			"O_WRONLY":                         {"untyped int", constant.MakeInt64(int64(q.O_WRONLY))},
			"PACKET_ADD_MEMBERSHIP":            {"untyped int", constant.MakeInt64(int64(q.PACKET_ADD_MEMBERSHIP))},
			"PACKET_AUXDATA":                   {"untyped int", constant.MakeInt64(int64(q.PACKET_AUXDATA))},
			"PACKET_BROADCAST":                 {"untyped int", constant.MakeInt64(int64(q.PACKET_BROADCAST))},
			"PACKET_COPY_THRESH":               {"untyped int", constant.MakeInt64(int64(q.PACKET_COPY_THRESH))},
			"PACKET_DROP_MEMBERSHIP":           {"untyped int", constant.MakeInt64(int64(q.PACKET_DROP_MEMBERSHIP))},
			"PACKET_FANOUT":                    {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT))},
			"PACKET_FANOUT_CBPF":               {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_CBPF))},
			"PACKET_FANOUT_CPU":                {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_CPU))},
			"PACKET_FANOUT_DATA":               {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_DATA))},
			"PACKET_FANOUT_EBPF":               {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_EBPF))},
			"PACKET_FANOUT_FLAG_DEFRAG":        {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_FLAG_DEFRAG))},
			"PACKET_FANOUT_FLAG_ROLLOVER":      {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_FLAG_ROLLOVER))},
			"PACKET_FANOUT_HASH":               {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_HASH))},
			"PACKET_FANOUT_LB":                 {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_LB))},
			"PACKET_FANOUT_QM":                 {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_QM))},
			"PACKET_FANOUT_RND":                {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_RND))},
			"PACKET_FANOUT_ROLLOVER":           {"untyped int", constant.MakeInt64(int64(q.PACKET_FANOUT_ROLLOVER))},
			"PACKET_FASTROUTE":                 {"untyped int", constant.MakeInt64(int64(q.PACKET_FASTROUTE))},
			"PACKET_HDRLEN":                    {"untyped int", constant.MakeInt64(int64(q.PACKET_HDRLEN))},
			"PACKET_HOST":                      {"untyped int", constant.MakeInt64(int64(q.PACKET_HOST))},
			"PACKET_KERNEL":                    {"untyped int", constant.MakeInt64(int64(q.PACKET_KERNEL))},
			"PACKET_LOOPBACK":                  {"untyped int", constant.MakeInt64(int64(q.PACKET_LOOPBACK))},
			"PACKET_LOSS":                      {"untyped int", constant.MakeInt64(int64(q.PACKET_LOSS))},
			"PACKET_MR_ALLMULTI":               {"untyped int", constant.MakeInt64(int64(q.PACKET_MR_ALLMULTI))},
			"PACKET_MR_MULTICAST":              {"untyped int", constant.MakeInt64(int64(q.PACKET_MR_MULTICAST))},
			"PACKET_MR_PROMISC":                {"untyped int", constant.MakeInt64(int64(q.PACKET_MR_PROMISC))},
			"PACKET_MR_UNICAST":                {"untyped int", constant.MakeInt64(int64(q.PACKET_MR_UNICAST))},
			"PACKET_MULTICAST":                 {"untyped int", constant.MakeInt64(int64(q.PACKET_MULTICAST))},
			"PACKET_ORIGDEV":                   {"untyped int", constant.MakeInt64(int64(q.PACKET_ORIGDEV))},
			"PACKET_OTHERHOST":                 {"untyped int", constant.MakeInt64(int64(q.PACKET_OTHERHOST))},
			"PACKET_OUTGOING":                  {"untyped int", constant.MakeInt64(int64(q.PACKET_OUTGOING))},
			"PACKET_QDISC_BYPASS":              {"untyped int", constant.MakeInt64(int64(q.PACKET_QDISC_BYPASS))},
			"PACKET_RECV_OUTPUT":               {"untyped int", constant.MakeInt64(int64(q.PACKET_RECV_OUTPUT))},
			"PACKET_RESERVE":                   {"untyped int", constant.MakeInt64(int64(q.PACKET_RESERVE))},
			"PACKET_ROLLOVER_STATS":            {"untyped int", constant.MakeInt64(int64(q.PACKET_ROLLOVER_STATS))},
			"PACKET_RX_RING":                   {"untyped int", constant.MakeInt64(int64(q.PACKET_RX_RING))},
			"PACKET_STATISTICS":                {"untyped int", constant.MakeInt64(int64(q.PACKET_STATISTICS))},
			"PACKET_TIMESTAMP":                 {"untyped int", constant.MakeInt64(int64(q.PACKET_TIMESTAMP))},
			"PACKET_TX_HAS_OFF":                {"untyped int", constant.MakeInt64(int64(q.PACKET_TX_HAS_OFF))},
			"PACKET_TX_RING":                   {"untyped int", constant.MakeInt64(int64(q.PACKET_TX_RING))},
			"PACKET_TX_TIMESTAMP":              {"untyped int", constant.MakeInt64(int64(q.PACKET_TX_TIMESTAMP))},
			"PACKET_USER":                      {"untyped int", constant.MakeInt64(int64(q.PACKET_USER))},
			"PACKET_VERSION":                   {"untyped int", constant.MakeInt64(int64(q.PACKET_VERSION))},
			"PACKET_VNET_HDR":                  {"untyped int", constant.MakeInt64(int64(q.PACKET_VNET_HDR))},
			"PARENB":                           {"untyped int", constant.MakeInt64(int64(q.PARENB))},
			"PARITY_CRC16_PR0":                 {"untyped int", constant.MakeInt64(int64(q.PARITY_CRC16_PR0))},
			"PARITY_CRC16_PR0_CCITT":           {"untyped int", constant.MakeInt64(int64(q.PARITY_CRC16_PR0_CCITT))},
			"PARITY_CRC16_PR1":                 {"untyped int", constant.MakeInt64(int64(q.PARITY_CRC16_PR1))},
			"PARITY_CRC16_PR1_CCITT":           {"untyped int", constant.MakeInt64(int64(q.PARITY_CRC16_PR1_CCITT))},
			"PARITY_CRC32_PR0_CCITT":           {"untyped int", constant.MakeInt64(int64(q.PARITY_CRC32_PR0_CCITT))},
			"PARITY_CRC32_PR1_CCITT":           {"untyped int", constant.MakeInt64(int64(q.PARITY_CRC32_PR1_CCITT))},
			"PARITY_DEFAULT":                   {"untyped int", constant.MakeInt64(int64(q.PARITY_DEFAULT))},
			"PARITY_NONE":                      {"untyped int", constant.MakeInt64(int64(q.PARITY_NONE))},
			"PARMRK":                           {"untyped int", constant.MakeInt64(int64(q.PARMRK))},
			"PARODD":                           {"untyped int", constant.MakeInt64(int64(q.PARODD))},
			"PENDIN":                           {"untyped int", constant.MakeInt64(int64(q.PENDIN))},
			"PRIO_PGRP":                        {"untyped int", constant.MakeInt64(int64(q.PRIO_PGRP))},
			"PRIO_PROCESS":                     {"untyped int", constant.MakeInt64(int64(q.PRIO_PROCESS))},
			"PRIO_USER":                        {"untyped int", constant.MakeInt64(int64(q.PRIO_USER))},
			"PROT_EXEC":                        {"untyped int", constant.MakeInt64(int64(q.PROT_EXEC))},
			"PROT_GROWSDOWN":                   {"untyped int", constant.MakeInt64(int64(q.PROT_GROWSDOWN))},
			"PROT_GROWSUP":                     {"untyped int", constant.MakeInt64(int64(q.PROT_GROWSUP))},
			"PROT_NONE":                        {"untyped int", constant.MakeInt64(int64(q.PROT_NONE))},
			"PROT_READ":                        {"untyped int", constant.MakeInt64(int64(q.PROT_READ))},
			"PROT_WRITE":                       {"untyped int", constant.MakeInt64(int64(q.PROT_WRITE))},
			"PR_CAPBSET_DROP":                  {"untyped int", constant.MakeInt64(int64(q.PR_CAPBSET_DROP))},
			"PR_CAPBSET_READ":                  {"untyped int", constant.MakeInt64(int64(q.PR_CAPBSET_READ))},
			"PR_CAP_AMBIENT":                   {"untyped int", constant.MakeInt64(int64(q.PR_CAP_AMBIENT))},
			"PR_CAP_AMBIENT_CLEAR_ALL":         {"untyped int", constant.MakeInt64(int64(q.PR_CAP_AMBIENT_CLEAR_ALL))},
			"PR_CAP_AMBIENT_IS_SET":            {"untyped int", constant.MakeInt64(int64(q.PR_CAP_AMBIENT_IS_SET))},
			"PR_CAP_AMBIENT_LOWER":             {"untyped int", constant.MakeInt64(int64(q.PR_CAP_AMBIENT_LOWER))},
			"PR_CAP_AMBIENT_RAISE":             {"untyped int", constant.MakeInt64(int64(q.PR_CAP_AMBIENT_RAISE))},
			"PR_ENDIAN_BIG":                    {"untyped int", constant.MakeInt64(int64(q.PR_ENDIAN_BIG))},
			"PR_ENDIAN_LITTLE":                 {"untyped int", constant.MakeInt64(int64(q.PR_ENDIAN_LITTLE))},
			"PR_ENDIAN_PPC_LITTLE":             {"untyped int", constant.MakeInt64(int64(q.PR_ENDIAN_PPC_LITTLE))},
			"PR_FPEMU_NOPRINT":                 {"untyped int", constant.MakeInt64(int64(q.PR_FPEMU_NOPRINT))},
			"PR_FPEMU_SIGFPE":                  {"untyped int", constant.MakeInt64(int64(q.PR_FPEMU_SIGFPE))},
			"PR_FP_EXC_ASYNC":                  {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_ASYNC))},
			"PR_FP_EXC_DISABLED":               {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_DISABLED))},
			"PR_FP_EXC_DIV":                    {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_DIV))},
			"PR_FP_EXC_INV":                    {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_INV))},
			"PR_FP_EXC_NONRECOV":               {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_NONRECOV))},
			"PR_FP_EXC_OVF":                    {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_OVF))},
			"PR_FP_EXC_PRECISE":                {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_PRECISE))},
			"PR_FP_EXC_RES":                    {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_RES))},
			"PR_FP_EXC_SW_ENABLE":              {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_SW_ENABLE))},
			"PR_FP_EXC_UND":                    {"untyped int", constant.MakeInt64(int64(q.PR_FP_EXC_UND))},
			"PR_FP_MODE_FR":                    {"untyped int", constant.MakeInt64(int64(q.PR_FP_MODE_FR))},
			"PR_FP_MODE_FRE":                   {"untyped int", constant.MakeInt64(int64(q.PR_FP_MODE_FRE))},
			"PR_GET_CHILD_SUBREAPER":           {"untyped int", constant.MakeInt64(int64(q.PR_GET_CHILD_SUBREAPER))},
			"PR_GET_DUMPABLE":                  {"untyped int", constant.MakeInt64(int64(q.PR_GET_DUMPABLE))},
			"PR_GET_ENDIAN":                    {"untyped int", constant.MakeInt64(int64(q.PR_GET_ENDIAN))},
			"PR_GET_FPEMU":                     {"untyped int", constant.MakeInt64(int64(q.PR_GET_FPEMU))},
			"PR_GET_FPEXC":                     {"untyped int", constant.MakeInt64(int64(q.PR_GET_FPEXC))},
			"PR_GET_FP_MODE":                   {"untyped int", constant.MakeInt64(int64(q.PR_GET_FP_MODE))},
			"PR_GET_KEEPCAPS":                  {"untyped int", constant.MakeInt64(int64(q.PR_GET_KEEPCAPS))},
			"PR_GET_NAME":                      {"untyped int", constant.MakeInt64(int64(q.PR_GET_NAME))},
			"PR_GET_NO_NEW_PRIVS":              {"untyped int", constant.MakeInt64(int64(q.PR_GET_NO_NEW_PRIVS))},
			"PR_GET_PDEATHSIG":                 {"untyped int", constant.MakeInt64(int64(q.PR_GET_PDEATHSIG))},
			"PR_GET_SECCOMP":                   {"untyped int", constant.MakeInt64(int64(q.PR_GET_SECCOMP))},
			"PR_GET_SECUREBITS":                {"untyped int", constant.MakeInt64(int64(q.PR_GET_SECUREBITS))},
			"PR_GET_THP_DISABLE":               {"untyped int", constant.MakeInt64(int64(q.PR_GET_THP_DISABLE))},
			"PR_GET_TID_ADDRESS":               {"untyped int", constant.MakeInt64(int64(q.PR_GET_TID_ADDRESS))},
			"PR_GET_TIMERSLACK":                {"untyped int", constant.MakeInt64(int64(q.PR_GET_TIMERSLACK))},
			"PR_GET_TIMING":                    {"untyped int", constant.MakeInt64(int64(q.PR_GET_TIMING))},
			"PR_GET_TSC":                       {"untyped int", constant.MakeInt64(int64(q.PR_GET_TSC))},
			"PR_GET_UNALIGN":                   {"untyped int", constant.MakeInt64(int64(q.PR_GET_UNALIGN))},
			"PR_MCE_KILL":                      {"untyped int", constant.MakeInt64(int64(q.PR_MCE_KILL))},
			"PR_MCE_KILL_CLEAR":                {"untyped int", constant.MakeInt64(int64(q.PR_MCE_KILL_CLEAR))},
			"PR_MCE_KILL_DEFAULT":              {"untyped int", constant.MakeInt64(int64(q.PR_MCE_KILL_DEFAULT))},
			"PR_MCE_KILL_EARLY":                {"untyped int", constant.MakeInt64(int64(q.PR_MCE_KILL_EARLY))},
			"PR_MCE_KILL_GET":                  {"untyped int", constant.MakeInt64(int64(q.PR_MCE_KILL_GET))},
			"PR_MCE_KILL_LATE":                 {"untyped int", constant.MakeInt64(int64(q.PR_MCE_KILL_LATE))},
			"PR_MCE_KILL_SET":                  {"untyped int", constant.MakeInt64(int64(q.PR_MCE_KILL_SET))},
			"PR_MPX_DISABLE_MANAGEMENT":        {"untyped int", constant.MakeInt64(int64(q.PR_MPX_DISABLE_MANAGEMENT))},
			"PR_MPX_ENABLE_MANAGEMENT":         {"untyped int", constant.MakeInt64(int64(q.PR_MPX_ENABLE_MANAGEMENT))},
			"PR_SET_CHILD_SUBREAPER":           {"untyped int", constant.MakeInt64(int64(q.PR_SET_CHILD_SUBREAPER))},
			"PR_SET_DUMPABLE":                  {"untyped int", constant.MakeInt64(int64(q.PR_SET_DUMPABLE))},
			"PR_SET_ENDIAN":                    {"untyped int", constant.MakeInt64(int64(q.PR_SET_ENDIAN))},
			"PR_SET_FPEMU":                     {"untyped int", constant.MakeInt64(int64(q.PR_SET_FPEMU))},
			"PR_SET_FPEXC":                     {"untyped int", constant.MakeInt64(int64(q.PR_SET_FPEXC))},
			"PR_SET_FP_MODE":                   {"untyped int", constant.MakeInt64(int64(q.PR_SET_FP_MODE))},
			"PR_SET_KEEPCAPS":                  {"untyped int", constant.MakeInt64(int64(q.PR_SET_KEEPCAPS))},
			"PR_SET_MM":                        {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM))},
			"PR_SET_MM_ARG_END":                {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_ARG_END))},
			"PR_SET_MM_ARG_START":              {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_ARG_START))},
			"PR_SET_MM_AUXV":                   {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_AUXV))},
			"PR_SET_MM_BRK":                    {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_BRK))},
			"PR_SET_MM_END_CODE":               {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_END_CODE))},
			"PR_SET_MM_END_DATA":               {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_END_DATA))},
			"PR_SET_MM_ENV_END":                {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_ENV_END))},
			"PR_SET_MM_ENV_START":              {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_ENV_START))},
			"PR_SET_MM_EXE_FILE":               {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_EXE_FILE))},
			"PR_SET_MM_MAP":                    {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_MAP))},
			"PR_SET_MM_MAP_SIZE":               {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_MAP_SIZE))},
			"PR_SET_MM_START_BRK":              {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_START_BRK))},
			"PR_SET_MM_START_CODE":             {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_START_CODE))},
			"PR_SET_MM_START_DATA":             {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_START_DATA))},
			"PR_SET_MM_START_STACK":            {"untyped int", constant.MakeInt64(int64(q.PR_SET_MM_START_STACK))},
			"PR_SET_NAME":                      {"untyped int", constant.MakeInt64(int64(q.PR_SET_NAME))},
			"PR_SET_NO_NEW_PRIVS":              {"untyped int", constant.MakeInt64(int64(q.PR_SET_NO_NEW_PRIVS))},
			"PR_SET_PDEATHSIG":                 {"untyped int", constant.MakeInt64(int64(q.PR_SET_PDEATHSIG))},
			"PR_SET_PTRACER":                   {"untyped int", constant.MakeInt64(int64(q.PR_SET_PTRACER))},
			"PR_SET_PTRACER_ANY":               {"untyped int", constant.MakeInt64(int64(q.PR_SET_PTRACER_ANY))},
			"PR_SET_SECCOMP":                   {"untyped int", constant.MakeInt64(int64(q.PR_SET_SECCOMP))},
			"PR_SET_SECUREBITS":                {"untyped int", constant.MakeInt64(int64(q.PR_SET_SECUREBITS))},
			"PR_SET_THP_DISABLE":               {"untyped int", constant.MakeInt64(int64(q.PR_SET_THP_DISABLE))},
			"PR_SET_TIMERSLACK":                {"untyped int", constant.MakeInt64(int64(q.PR_SET_TIMERSLACK))},
			"PR_SET_TIMING":                    {"untyped int", constant.MakeInt64(int64(q.PR_SET_TIMING))},
			"PR_SET_TSC":                       {"untyped int", constant.MakeInt64(int64(q.PR_SET_TSC))},
			"PR_SET_UNALIGN":                   {"untyped int", constant.MakeInt64(int64(q.PR_SET_UNALIGN))},
			"PR_TASK_PERF_EVENTS_DISABLE":      {"untyped int", constant.MakeInt64(int64(q.PR_TASK_PERF_EVENTS_DISABLE))},
			"PR_TASK_PERF_EVENTS_ENABLE":       {"untyped int", constant.MakeInt64(int64(q.PR_TASK_PERF_EVENTS_ENABLE))},
			"PR_TIMING_STATISTICAL":            {"untyped int", constant.MakeInt64(int64(q.PR_TIMING_STATISTICAL))},
			"PR_TIMING_TIMESTAMP":              {"untyped int", constant.MakeInt64(int64(q.PR_TIMING_TIMESTAMP))},
			"PR_TSC_ENABLE":                    {"untyped int", constant.MakeInt64(int64(q.PR_TSC_ENABLE))},
			"PR_TSC_SIGSEGV":                   {"untyped int", constant.MakeInt64(int64(q.PR_TSC_SIGSEGV))},
			"PR_UNALIGN_NOPRINT":               {"untyped int", constant.MakeInt64(int64(q.PR_UNALIGN_NOPRINT))},
			"PR_UNALIGN_SIGBUS":                {"untyped int", constant.MakeInt64(int64(q.PR_UNALIGN_SIGBUS))},
			"PTRACE_ATTACH":                    {"untyped int", constant.MakeInt64(int64(q.PTRACE_ATTACH))},
			"PTRACE_CONT":                      {"untyped int", constant.MakeInt64(int64(q.PTRACE_CONT))},
			"PTRACE_DETACH":                    {"untyped int", constant.MakeInt64(int64(q.PTRACE_DETACH))},
			"PTRACE_DISABLE_TE":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_DISABLE_TE))},
			"PTRACE_ENABLE_TE":                 {"untyped int", constant.MakeInt64(int64(q.PTRACE_ENABLE_TE))},
			"PTRACE_EVENT_CLONE":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_CLONE))},
			"PTRACE_EVENT_EXEC":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_EXEC))},
			"PTRACE_EVENT_EXIT":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_EXIT))},
			"PTRACE_EVENT_FORK":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_FORK))},
			"PTRACE_EVENT_SECCOMP":             {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_SECCOMP))},
			"PTRACE_EVENT_STOP":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_STOP))},
			"PTRACE_EVENT_VFORK":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_VFORK))},
			"PTRACE_EVENT_VFORK_DONE":          {"untyped int", constant.MakeInt64(int64(q.PTRACE_EVENT_VFORK_DONE))},
			"PTRACE_GETEVENTMSG":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_GETEVENTMSG))},
			"PTRACE_GETREGS":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_GETREGS))},
			"PTRACE_GETREGSET":                 {"untyped int", constant.MakeInt64(int64(q.PTRACE_GETREGSET))},
			"PTRACE_GETSIGINFO":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_GETSIGINFO))},
			"PTRACE_GETSIGMASK":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_GETSIGMASK))},
			"PTRACE_GET_LAST_BREAK":            {"untyped int", constant.MakeInt64(int64(q.PTRACE_GET_LAST_BREAK))},
			"PTRACE_INTERRUPT":                 {"untyped int", constant.MakeInt64(int64(q.PTRACE_INTERRUPT))},
			"PTRACE_KILL":                      {"untyped int", constant.MakeInt64(int64(q.PTRACE_KILL))},
			"PTRACE_LISTEN":                    {"untyped int", constant.MakeInt64(int64(q.PTRACE_LISTEN))},
			"PTRACE_OLDSETOPTIONS":             {"untyped int", constant.MakeInt64(int64(q.PTRACE_OLDSETOPTIONS))},
			"PTRACE_O_EXITKILL":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_EXITKILL))},
			"PTRACE_O_MASK":                    {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_MASK))},
			"PTRACE_O_SUSPEND_SECCOMP":         {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_SUSPEND_SECCOMP))},
			"PTRACE_O_TRACECLONE":              {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACECLONE))},
			"PTRACE_O_TRACEEXEC":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACEEXEC))},
			"PTRACE_O_TRACEEXIT":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACEEXIT))},
			"PTRACE_O_TRACEFORK":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACEFORK))},
			"PTRACE_O_TRACESECCOMP":            {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACESECCOMP))},
			"PTRACE_O_TRACESYSGOOD":            {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACESYSGOOD))},
			"PTRACE_O_TRACEVFORK":              {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACEVFORK))},
			"PTRACE_O_TRACEVFORKDONE":          {"untyped int", constant.MakeInt64(int64(q.PTRACE_O_TRACEVFORKDONE))},
			"PTRACE_PEEKDATA":                  {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKDATA))},
			"PTRACE_PEEKDATA_AREA":             {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKDATA_AREA))},
			"PTRACE_PEEKSIGINFO":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKSIGINFO))},
			"PTRACE_PEEKSIGINFO_SHARED":        {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKSIGINFO_SHARED))},
			"PTRACE_PEEKTEXT":                  {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKTEXT))},
			"PTRACE_PEEKTEXT_AREA":             {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKTEXT_AREA))},
			"PTRACE_PEEKUSR":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKUSR))},
			"PTRACE_PEEKUSR_AREA":              {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEKUSR_AREA))},
			"PTRACE_PEEK_SYSTEM_CALL":          {"untyped int", constant.MakeInt64(int64(q.PTRACE_PEEK_SYSTEM_CALL))},
			"PTRACE_POKEDATA":                  {"untyped int", constant.MakeInt64(int64(q.PTRACE_POKEDATA))},
			"PTRACE_POKEDATA_AREA":             {"untyped int", constant.MakeInt64(int64(q.PTRACE_POKEDATA_AREA))},
			"PTRACE_POKETEXT":                  {"untyped int", constant.MakeInt64(int64(q.PTRACE_POKETEXT))},
			"PTRACE_POKETEXT_AREA":             {"untyped int", constant.MakeInt64(int64(q.PTRACE_POKETEXT_AREA))},
			"PTRACE_POKEUSR":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_POKEUSR))},
			"PTRACE_POKEUSR_AREA":              {"untyped int", constant.MakeInt64(int64(q.PTRACE_POKEUSR_AREA))},
			"PTRACE_POKE_SYSTEM_CALL":          {"untyped int", constant.MakeInt64(int64(q.PTRACE_POKE_SYSTEM_CALL))},
			"PTRACE_PROT":                      {"untyped int", constant.MakeInt64(int64(q.PTRACE_PROT))},
			"PTRACE_SECCOMP_GET_FILTER":        {"untyped int", constant.MakeInt64(int64(q.PTRACE_SECCOMP_GET_FILTER))},
			"PTRACE_SEIZE":                     {"untyped int", constant.MakeInt64(int64(q.PTRACE_SEIZE))},
			"PTRACE_SETOPTIONS":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_SETOPTIONS))},
			"PTRACE_SETREGS":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_SETREGS))},
			"PTRACE_SETREGSET":                 {"untyped int", constant.MakeInt64(int64(q.PTRACE_SETREGSET))},
			"PTRACE_SETSIGINFO":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_SETSIGINFO))},
			"PTRACE_SETSIGMASK":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_SETSIGMASK))},
			"PTRACE_SINGLEBLOCK":               {"untyped int", constant.MakeInt64(int64(q.PTRACE_SINGLEBLOCK))},
			"PTRACE_SINGLESTEP":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_SINGLESTEP))},
			"PTRACE_SYSCALL":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_SYSCALL))},
			"PTRACE_TE_ABORT_RAND":             {"untyped int", constant.MakeInt64(int64(q.PTRACE_TE_ABORT_RAND))},
			"PTRACE_TRACEME":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_TRACEME))},
			"PT_ACR0":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR0))},
			"PT_ACR1":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR1))},
			"PT_ACR10":                         {"untyped int", constant.MakeInt64(int64(q.PT_ACR10))},
			"PT_ACR11":                         {"untyped int", constant.MakeInt64(int64(q.PT_ACR11))},
			"PT_ACR12":                         {"untyped int", constant.MakeInt64(int64(q.PT_ACR12))},
			"PT_ACR13":                         {"untyped int", constant.MakeInt64(int64(q.PT_ACR13))},
			"PT_ACR14":                         {"untyped int", constant.MakeInt64(int64(q.PT_ACR14))},
			"PT_ACR15":                         {"untyped int", constant.MakeInt64(int64(q.PT_ACR15))},
			"PT_ACR2":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR2))},
			"PT_ACR3":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR3))},
			"PT_ACR4":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR4))},
			"PT_ACR5":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR5))},
			"PT_ACR6":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR6))},
			"PT_ACR7":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR7))},
			"PT_ACR8":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR8))},
			"PT_ACR9":                          {"untyped int", constant.MakeInt64(int64(q.PT_ACR9))},
			"PT_CR_10":                         {"untyped int", constant.MakeInt64(int64(q.PT_CR_10))},
			"PT_CR_11":                         {"untyped int", constant.MakeInt64(int64(q.PT_CR_11))},
			"PT_CR_9":                          {"untyped int", constant.MakeInt64(int64(q.PT_CR_9))},
			"PT_ENDREGS":                       {"untyped int", constant.MakeInt64(int64(q.PT_ENDREGS))},
			"PT_FPC":                           {"untyped int", constant.MakeInt64(int64(q.PT_FPC))},
			"PT_FPR0":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR0))},
			"PT_FPR1":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR1))},
			"PT_FPR10":                         {"untyped int", constant.MakeInt64(int64(q.PT_FPR10))},
			"PT_FPR11":                         {"untyped int", constant.MakeInt64(int64(q.PT_FPR11))},
			"PT_FPR12":                         {"untyped int", constant.MakeInt64(int64(q.PT_FPR12))},
			"PT_FPR13":                         {"untyped int", constant.MakeInt64(int64(q.PT_FPR13))},
			"PT_FPR14":                         {"untyped int", constant.MakeInt64(int64(q.PT_FPR14))},
			"PT_FPR15":                         {"untyped int", constant.MakeInt64(int64(q.PT_FPR15))},
			"PT_FPR2":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR2))},
			"PT_FPR3":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR3))},
			"PT_FPR4":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR4))},
			"PT_FPR5":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR5))},
			"PT_FPR6":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR6))},
			"PT_FPR7":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR7))},
			"PT_FPR8":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR8))},
			"PT_FPR9":                          {"untyped int", constant.MakeInt64(int64(q.PT_FPR9))},
			"PT_GPR0":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR0))},
			"PT_GPR1":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR1))},
			"PT_GPR10":                         {"untyped int", constant.MakeInt64(int64(q.PT_GPR10))},
			"PT_GPR11":                         {"untyped int", constant.MakeInt64(int64(q.PT_GPR11))},
			"PT_GPR12":                         {"untyped int", constant.MakeInt64(int64(q.PT_GPR12))},
			"PT_GPR13":                         {"untyped int", constant.MakeInt64(int64(q.PT_GPR13))},
			"PT_GPR14":                         {"untyped int", constant.MakeInt64(int64(q.PT_GPR14))},
			"PT_GPR15":                         {"untyped int", constant.MakeInt64(int64(q.PT_GPR15))},
			"PT_GPR2":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR2))},
			"PT_GPR3":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR3))},
			"PT_GPR4":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR4))},
			"PT_GPR5":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR5))},
			"PT_GPR6":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR6))},
			"PT_GPR7":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR7))},
			"PT_GPR8":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR8))},
			"PT_GPR9":                          {"untyped int", constant.MakeInt64(int64(q.PT_GPR9))},
			"PT_IEEE_IP":                       {"untyped int", constant.MakeInt64(int64(q.PT_IEEE_IP))},
			"PT_LASTOFF":                       {"untyped int", constant.MakeInt64(int64(q.PT_LASTOFF))},
			"PT_ORIGGPR2":                      {"untyped int", constant.MakeInt64(int64(q.PT_ORIGGPR2))},
			"PT_PSWADDR":                       {"untyped int", constant.MakeInt64(int64(q.PT_PSWADDR))},
			"PT_PSWMASK":                       {"untyped int", constant.MakeInt64(int64(q.PT_PSWMASK))},
			"PathMax":                          {"untyped int", constant.MakeInt64(int64(q.PathMax))},
			"RLIMIT_AS":                        {"untyped int", constant.MakeInt64(int64(q.RLIMIT_AS))},
			"RLIMIT_CORE":                      {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CORE))},
			"RLIMIT_CPU":                       {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CPU))},
			"RLIMIT_DATA":                      {"untyped int", constant.MakeInt64(int64(q.RLIMIT_DATA))},
			"RLIMIT_FSIZE":                     {"untyped int", constant.MakeInt64(int64(q.RLIMIT_FSIZE))},
			"RLIMIT_NOFILE":                    {"untyped int", constant.MakeInt64(int64(q.RLIMIT_NOFILE))},
			"RLIMIT_STACK":                     {"untyped int", constant.MakeInt64(int64(q.RLIMIT_STACK))},
			"RLIM_INFINITY":                    {"untyped int", constant.MakeInt64(int64(q.RLIM_INFINITY))},
			"RTAX_ADVMSS":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_ADVMSS))},
			"RTAX_CC_ALGO":                     {"untyped int", constant.MakeInt64(int64(q.RTAX_CC_ALGO))},
			"RTAX_CWND":                        {"untyped int", constant.MakeInt64(int64(q.RTAX_CWND))},
			"RTAX_FEATURES":                    {"untyped int", constant.MakeInt64(int64(q.RTAX_FEATURES))},
			"RTAX_FEATURE_ALLFRAG":             {"untyped int", constant.MakeInt64(int64(q.RTAX_FEATURE_ALLFRAG))},
			"RTAX_FEATURE_ECN":                 {"untyped int", constant.MakeInt64(int64(q.RTAX_FEATURE_ECN))},
			"RTAX_FEATURE_MASK":                {"untyped int", constant.MakeInt64(int64(q.RTAX_FEATURE_MASK))},
			"RTAX_FEATURE_SACK":                {"untyped int", constant.MakeInt64(int64(q.RTAX_FEATURE_SACK))},
			"RTAX_FEATURE_TIMESTAMP":           {"untyped int", constant.MakeInt64(int64(q.RTAX_FEATURE_TIMESTAMP))},
			"RTAX_HOPLIMIT":                    {"untyped int", constant.MakeInt64(int64(q.RTAX_HOPLIMIT))},
			"RTAX_INITCWND":                    {"untyped int", constant.MakeInt64(int64(q.RTAX_INITCWND))},
			"RTAX_INITRWND":                    {"untyped int", constant.MakeInt64(int64(q.RTAX_INITRWND))},
			"RTAX_LOCK":                        {"untyped int", constant.MakeInt64(int64(q.RTAX_LOCK))},
			"RTAX_MAX":                         {"untyped int", constant.MakeInt64(int64(q.RTAX_MAX))},
			"RTAX_MTU":                         {"untyped int", constant.MakeInt64(int64(q.RTAX_MTU))},
			"RTAX_QUICKACK":                    {"untyped int", constant.MakeInt64(int64(q.RTAX_QUICKACK))},
			"RTAX_REORDERING":                  {"untyped int", constant.MakeInt64(int64(q.RTAX_REORDERING))},
			"RTAX_RTO_MIN":                     {"untyped int", constant.MakeInt64(int64(q.RTAX_RTO_MIN))},
			"RTAX_RTT":                         {"untyped int", constant.MakeInt64(int64(q.RTAX_RTT))},
			"RTAX_RTTVAR":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_RTTVAR))},
			"RTAX_SSTHRESH":                    {"untyped int", constant.MakeInt64(int64(q.RTAX_SSTHRESH))},
			"RTAX_UNSPEC":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_UNSPEC))},
			"RTAX_WINDOW":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_WINDOW))},
			"RTA_ALIGNTO":                      {"untyped int", constant.MakeInt64(int64(q.RTA_ALIGNTO))},
			"RTA_CACHEINFO":                    {"untyped int", constant.MakeInt64(int64(q.RTA_CACHEINFO))},
			"RTA_DST":                          {"untyped int", constant.MakeInt64(int64(q.RTA_DST))},
			"RTA_FLOW":                         {"untyped int", constant.MakeInt64(int64(q.RTA_FLOW))},
			"RTA_GATEWAY":                      {"untyped int", constant.MakeInt64(int64(q.RTA_GATEWAY))},
			"RTA_IIF":                          {"untyped int", constant.MakeInt64(int64(q.RTA_IIF))},
			"RTA_MAX":                          {"untyped int", constant.MakeInt64(int64(q.RTA_MAX))},
			"RTA_METRICS":                      {"untyped int", constant.MakeInt64(int64(q.RTA_METRICS))},
			"RTA_MULTIPATH":                    {"untyped int", constant.MakeInt64(int64(q.RTA_MULTIPATH))},
			"RTA_OIF":                          {"untyped int", constant.MakeInt64(int64(q.RTA_OIF))},
			"RTA_PREFSRC":                      {"untyped int", constant.MakeInt64(int64(q.RTA_PREFSRC))},
			"RTA_PRIORITY":                     {"untyped int", constant.MakeInt64(int64(q.RTA_PRIORITY))},
			"RTA_SRC":                          {"untyped int", constant.MakeInt64(int64(q.RTA_SRC))},
			"RTA_TABLE":                        {"untyped int", constant.MakeInt64(int64(q.RTA_TABLE))},
			"RTA_UNSPEC":                       {"untyped int", constant.MakeInt64(int64(q.RTA_UNSPEC))},
			"RTCF_DIRECTSRC":                   {"untyped int", constant.MakeInt64(int64(q.RTCF_DIRECTSRC))},
			"RTCF_DOREDIRECT":                  {"untyped int", constant.MakeInt64(int64(q.RTCF_DOREDIRECT))},
			"RTCF_LOG":                         {"untyped int", constant.MakeInt64(int64(q.RTCF_LOG))},
			"RTCF_MASQ":                        {"untyped int", constant.MakeInt64(int64(q.RTCF_MASQ))},
			"RTCF_NAT":                         {"untyped int", constant.MakeInt64(int64(q.RTCF_NAT))},
			"RTCF_VALVE":                       {"untyped int", constant.MakeInt64(int64(q.RTCF_VALVE))},
			"RTF_ADDRCLASSMASK":                {"untyped int", constant.MakeInt64(int64(q.RTF_ADDRCLASSMASK))},
			"RTF_ADDRCONF":                     {"untyped int", constant.MakeInt64(int64(q.RTF_ADDRCONF))},
			"RTF_ALLONLINK":                    {"untyped int", constant.MakeInt64(int64(q.RTF_ALLONLINK))},
			"RTF_BROADCAST":                    {"untyped int", constant.MakeInt64(int64(q.RTF_BROADCAST))},
			"RTF_CACHE":                        {"untyped int", constant.MakeInt64(int64(q.RTF_CACHE))},
			"RTF_DEFAULT":                      {"untyped int", constant.MakeInt64(int64(q.RTF_DEFAULT))},
			"RTF_DYNAMIC":                      {"untyped int", constant.MakeInt64(int64(q.RTF_DYNAMIC))},
			"RTF_FLOW":                         {"untyped int", constant.MakeInt64(int64(q.RTF_FLOW))},
			"RTF_GATEWAY":                      {"untyped int", constant.MakeInt64(int64(q.RTF_GATEWAY))},
			"RTF_HOST":                         {"untyped int", constant.MakeInt64(int64(q.RTF_HOST))},
			"RTF_INTERFACE":                    {"untyped int", constant.MakeInt64(int64(q.RTF_INTERFACE))},
			"RTF_IRTT":                         {"untyped int", constant.MakeInt64(int64(q.RTF_IRTT))},
			"RTF_LINKRT":                       {"untyped int", constant.MakeInt64(int64(q.RTF_LINKRT))},
			"RTF_LOCAL":                        {"untyped int", constant.MakeInt64(int64(q.RTF_LOCAL))},
			"RTF_MODIFIED":                     {"untyped int", constant.MakeInt64(int64(q.RTF_MODIFIED))},
			"RTF_MSS":                          {"untyped int", constant.MakeInt64(int64(q.RTF_MSS))},
			"RTF_MTU":                          {"untyped int", constant.MakeInt64(int64(q.RTF_MTU))},
			"RTF_MULTICAST":                    {"untyped int", constant.MakeInt64(int64(q.RTF_MULTICAST))},
			"RTF_NAT":                          {"untyped int", constant.MakeInt64(int64(q.RTF_NAT))},
			"RTF_NOFORWARD":                    {"untyped int", constant.MakeInt64(int64(q.RTF_NOFORWARD))},
			"RTF_NONEXTHOP":                    {"untyped int", constant.MakeInt64(int64(q.RTF_NONEXTHOP))},
			"RTF_NOPMTUDISC":                   {"untyped int", constant.MakeInt64(int64(q.RTF_NOPMTUDISC))},
			"RTF_POLICY":                       {"untyped int", constant.MakeInt64(int64(q.RTF_POLICY))},
			"RTF_REINSTATE":                    {"untyped int", constant.MakeInt64(int64(q.RTF_REINSTATE))},
			"RTF_REJECT":                       {"untyped int", constant.MakeInt64(int64(q.RTF_REJECT))},
			"RTF_STATIC":                       {"untyped int", constant.MakeInt64(int64(q.RTF_STATIC))},
			"RTF_THROW":                        {"untyped int", constant.MakeInt64(int64(q.RTF_THROW))},
			"RTF_UP":                           {"untyped int", constant.MakeInt64(int64(q.RTF_UP))},
			"RTF_WINDOW":                       {"untyped int", constant.MakeInt64(int64(q.RTF_WINDOW))},
			"RTF_XRESOLVE":                     {"untyped int", constant.MakeInt64(int64(q.RTF_XRESOLVE))},
			"RTM_BASE":                         {"untyped int", constant.MakeInt64(int64(q.RTM_BASE))},
			"RTM_DELACTION":                    {"untyped int", constant.MakeInt64(int64(q.RTM_DELACTION))},
			"RTM_DELADDR":                      {"untyped int", constant.MakeInt64(int64(q.RTM_DELADDR))},
			"RTM_DELADDRLABEL":                 {"untyped int", constant.MakeInt64(int64(q.RTM_DELADDRLABEL))},
			"RTM_DELLINK":                      {"untyped int", constant.MakeInt64(int64(q.RTM_DELLINK))},
			"RTM_DELMDB":                       {"untyped int", constant.MakeInt64(int64(q.RTM_DELMDB))},
			"RTM_DELNEIGH":                     {"untyped int", constant.MakeInt64(int64(q.RTM_DELNEIGH))},
			"RTM_DELNSID":                      {"untyped int", constant.MakeInt64(int64(q.RTM_DELNSID))},
			"RTM_DELQDISC":                     {"untyped int", constant.MakeInt64(int64(q.RTM_DELQDISC))},
			"RTM_DELROUTE":                     {"untyped int", constant.MakeInt64(int64(q.RTM_DELROUTE))},
			"RTM_DELRULE":                      {"untyped int", constant.MakeInt64(int64(q.RTM_DELRULE))},
			"RTM_DELTCLASS":                    {"untyped int", constant.MakeInt64(int64(q.RTM_DELTCLASS))},
			"RTM_DELTFILTER":                   {"untyped int", constant.MakeInt64(int64(q.RTM_DELTFILTER))},
			"RTM_F_CLONED":                     {"untyped int", constant.MakeInt64(int64(q.RTM_F_CLONED))},
			"RTM_F_EQUALIZE":                   {"untyped int", constant.MakeInt64(int64(q.RTM_F_EQUALIZE))},
			"RTM_F_LOOKUP_TABLE":               {"untyped int", constant.MakeInt64(int64(q.RTM_F_LOOKUP_TABLE))},
			"RTM_F_NOTIFY":                     {"untyped int", constant.MakeInt64(int64(q.RTM_F_NOTIFY))},
			"RTM_F_PREFIX":                     {"untyped int", constant.MakeInt64(int64(q.RTM_F_PREFIX))},
			"RTM_GETACTION":                    {"untyped int", constant.MakeInt64(int64(q.RTM_GETACTION))},
			"RTM_GETADDR":                      {"untyped int", constant.MakeInt64(int64(q.RTM_GETADDR))},
			"RTM_GETADDRLABEL":                 {"untyped int", constant.MakeInt64(int64(q.RTM_GETADDRLABEL))},
			"RTM_GETANYCAST":                   {"untyped int", constant.MakeInt64(int64(q.RTM_GETANYCAST))},
			"RTM_GETDCB":                       {"untyped int", constant.MakeInt64(int64(q.RTM_GETDCB))},
			"RTM_GETLINK":                      {"untyped int", constant.MakeInt64(int64(q.RTM_GETLINK))},
			"RTM_GETMDB":                       {"untyped int", constant.MakeInt64(int64(q.RTM_GETMDB))},
			"RTM_GETMULTICAST":                 {"untyped int", constant.MakeInt64(int64(q.RTM_GETMULTICAST))},
			"RTM_GETNEIGH":                     {"untyped int", constant.MakeInt64(int64(q.RTM_GETNEIGH))},
			"RTM_GETNEIGHTBL":                  {"untyped int", constant.MakeInt64(int64(q.RTM_GETNEIGHTBL))},
			"RTM_GETNETCONF":                   {"untyped int", constant.MakeInt64(int64(q.RTM_GETNETCONF))},
			"RTM_GETNSID":                      {"untyped int", constant.MakeInt64(int64(q.RTM_GETNSID))},
			"RTM_GETQDISC":                     {"untyped int", constant.MakeInt64(int64(q.RTM_GETQDISC))},
			"RTM_GETROUTE":                     {"untyped int", constant.MakeInt64(int64(q.RTM_GETROUTE))},
			"RTM_GETRULE":                      {"untyped int", constant.MakeInt64(int64(q.RTM_GETRULE))},
			"RTM_GETTCLASS":                    {"untyped int", constant.MakeInt64(int64(q.RTM_GETTCLASS))},
			"RTM_GETTFILTER":                   {"untyped int", constant.MakeInt64(int64(q.RTM_GETTFILTER))},
			"RTM_MAX":                          {"untyped int", constant.MakeInt64(int64(q.RTM_MAX))},
			"RTM_NEWACTION":                    {"untyped int", constant.MakeInt64(int64(q.RTM_NEWACTION))},
			"RTM_NEWADDR":                      {"untyped int", constant.MakeInt64(int64(q.RTM_NEWADDR))},
			"RTM_NEWADDRLABEL":                 {"untyped int", constant.MakeInt64(int64(q.RTM_NEWADDRLABEL))},
			"RTM_NEWLINK":                      {"untyped int", constant.MakeInt64(int64(q.RTM_NEWLINK))},
			"RTM_NEWMDB":                       {"untyped int", constant.MakeInt64(int64(q.RTM_NEWMDB))},
			"RTM_NEWNDUSEROPT":                 {"untyped int", constant.MakeInt64(int64(q.RTM_NEWNDUSEROPT))},
			"RTM_NEWNEIGH":                     {"untyped int", constant.MakeInt64(int64(q.RTM_NEWNEIGH))},
			"RTM_NEWNEIGHTBL":                  {"untyped int", constant.MakeInt64(int64(q.RTM_NEWNEIGHTBL))},
			"RTM_NEWNETCONF":                   {"untyped int", constant.MakeInt64(int64(q.RTM_NEWNETCONF))},
			"RTM_NEWNSID":                      {"untyped int", constant.MakeInt64(int64(q.RTM_NEWNSID))},
			"RTM_NEWPREFIX":                    {"untyped int", constant.MakeInt64(int64(q.RTM_NEWPREFIX))},
			"RTM_NEWQDISC":                     {"untyped int", constant.MakeInt64(int64(q.RTM_NEWQDISC))},
			"RTM_NEWROUTE":                     {"untyped int", constant.MakeInt64(int64(q.RTM_NEWROUTE))},
			"RTM_NEWRULE":                      {"untyped int", constant.MakeInt64(int64(q.RTM_NEWRULE))},
			"RTM_NEWTCLASS":                    {"untyped int", constant.MakeInt64(int64(q.RTM_NEWTCLASS))},
			"RTM_NEWTFILTER":                   {"untyped int", constant.MakeInt64(int64(q.RTM_NEWTFILTER))},
			"RTM_NR_FAMILIES":                  {"untyped int", constant.MakeInt64(int64(q.RTM_NR_FAMILIES))},
			"RTM_NR_MSGTYPES":                  {"untyped int", constant.MakeInt64(int64(q.RTM_NR_MSGTYPES))},
			"RTM_SETDCB":                       {"untyped int", constant.MakeInt64(int64(q.RTM_SETDCB))},
			"RTM_SETLINK":                      {"untyped int", constant.MakeInt64(int64(q.RTM_SETLINK))},
			"RTM_SETNEIGHTBL":                  {"untyped int", constant.MakeInt64(int64(q.RTM_SETNEIGHTBL))},
			"RTNH_ALIGNTO":                     {"untyped int", constant.MakeInt64(int64(q.RTNH_ALIGNTO))},
			"RTNH_COMPARE_MASK":                {"untyped int", constant.MakeInt64(int64(q.RTNH_COMPARE_MASK))},
			"RTNH_F_DEAD":                      {"untyped int", constant.MakeInt64(int64(q.RTNH_F_DEAD))},
			"RTNH_F_LINKDOWN":                  {"untyped int", constant.MakeInt64(int64(q.RTNH_F_LINKDOWN))},
			"RTNH_F_OFFLOAD":                   {"untyped int", constant.MakeInt64(int64(q.RTNH_F_OFFLOAD))},
			"RTNH_F_ONLINK":                    {"untyped int", constant.MakeInt64(int64(q.RTNH_F_ONLINK))},
			"RTNH_F_PERVASIVE":                 {"untyped int", constant.MakeInt64(int64(q.RTNH_F_PERVASIVE))},
			"RTNLGRP_IPV4_IFADDR":              {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV4_IFADDR))},
			"RTNLGRP_IPV4_MROUTE":              {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV4_MROUTE))},
			"RTNLGRP_IPV4_ROUTE":               {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV4_ROUTE))},
			"RTNLGRP_IPV4_RULE":                {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV4_RULE))},
			"RTNLGRP_IPV6_IFADDR":              {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV6_IFADDR))},
			"RTNLGRP_IPV6_IFINFO":              {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV6_IFINFO))},
			"RTNLGRP_IPV6_MROUTE":              {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV6_MROUTE))},
			"RTNLGRP_IPV6_PREFIX":              {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV6_PREFIX))},
			"RTNLGRP_IPV6_ROUTE":               {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV6_ROUTE))},
			"RTNLGRP_IPV6_RULE":                {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_IPV6_RULE))},
			"RTNLGRP_LINK":                     {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_LINK))},
			"RTNLGRP_ND_USEROPT":               {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_ND_USEROPT))},
			"RTNLGRP_NEIGH":                    {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_NEIGH))},
			"RTNLGRP_NONE":                     {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_NONE))},
			"RTNLGRP_NOTIFY":                   {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_NOTIFY))},
			"RTNLGRP_TC":                       {"untyped int", constant.MakeInt64(int64(q.RTNLGRP_TC))},
			"RTN_ANYCAST":                      {"untyped int", constant.MakeInt64(int64(q.RTN_ANYCAST))},
			"RTN_BLACKHOLE":                    {"untyped int", constant.MakeInt64(int64(q.RTN_BLACKHOLE))},
			"RTN_BROADCAST":                    {"untyped int", constant.MakeInt64(int64(q.RTN_BROADCAST))},
			"RTN_LOCAL":                        {"untyped int", constant.MakeInt64(int64(q.RTN_LOCAL))},
			"RTN_MAX":                          {"untyped int", constant.MakeInt64(int64(q.RTN_MAX))},
			"RTN_MULTICAST":                    {"untyped int", constant.MakeInt64(int64(q.RTN_MULTICAST))},
			"RTN_NAT":                          {"untyped int", constant.MakeInt64(int64(q.RTN_NAT))},
			"RTN_PROHIBIT":                     {"untyped int", constant.MakeInt64(int64(q.RTN_PROHIBIT))},
			"RTN_THROW":                        {"untyped int", constant.MakeInt64(int64(q.RTN_THROW))},
			"RTN_UNICAST":                      {"untyped int", constant.MakeInt64(int64(q.RTN_UNICAST))},
			"RTN_UNREACHABLE":                  {"untyped int", constant.MakeInt64(int64(q.RTN_UNREACHABLE))},
			"RTN_UNSPEC":                       {"untyped int", constant.MakeInt64(int64(q.RTN_UNSPEC))},
			"RTN_XRESOLVE":                     {"untyped int", constant.MakeInt64(int64(q.RTN_XRESOLVE))},
			"RTPROT_BABEL":                     {"untyped int", constant.MakeInt64(int64(q.RTPROT_BABEL))},
			"RTPROT_BIRD":                      {"untyped int", constant.MakeInt64(int64(q.RTPROT_BIRD))},
			"RTPROT_BOOT":                      {"untyped int", constant.MakeInt64(int64(q.RTPROT_BOOT))},
			"RTPROT_DHCP":                      {"untyped int", constant.MakeInt64(int64(q.RTPROT_DHCP))},
			"RTPROT_DNROUTED":                  {"untyped int", constant.MakeInt64(int64(q.RTPROT_DNROUTED))},
			"RTPROT_GATED":                     {"untyped int", constant.MakeInt64(int64(q.RTPROT_GATED))},
			"RTPROT_KERNEL":                    {"untyped int", constant.MakeInt64(int64(q.RTPROT_KERNEL))},
			"RTPROT_MROUTED":                   {"untyped int", constant.MakeInt64(int64(q.RTPROT_MROUTED))},
			"RTPROT_MRT":                       {"untyped int", constant.MakeInt64(int64(q.RTPROT_MRT))},
			"RTPROT_NTK":                       {"untyped int", constant.MakeInt64(int64(q.RTPROT_NTK))},
			"RTPROT_RA":                        {"untyped int", constant.MakeInt64(int64(q.RTPROT_RA))},
			"RTPROT_REDIRECT":                  {"untyped int", constant.MakeInt64(int64(q.RTPROT_REDIRECT))},
			"RTPROT_STATIC":                    {"untyped int", constant.MakeInt64(int64(q.RTPROT_STATIC))},
			"RTPROT_UNSPEC":                    {"untyped int", constant.MakeInt64(int64(q.RTPROT_UNSPEC))},
			"RTPROT_XORP":                      {"untyped int", constant.MakeInt64(int64(q.RTPROT_XORP))},
			"RTPROT_ZEBRA":                     {"untyped int", constant.MakeInt64(int64(q.RTPROT_ZEBRA))},
			"RT_CLASS_DEFAULT":                 {"untyped int", constant.MakeInt64(int64(q.RT_CLASS_DEFAULT))},
			"RT_CLASS_LOCAL":                   {"untyped int", constant.MakeInt64(int64(q.RT_CLASS_LOCAL))},
			"RT_CLASS_MAIN":                    {"untyped int", constant.MakeInt64(int64(q.RT_CLASS_MAIN))},
			"RT_CLASS_MAX":                     {"untyped int", constant.MakeInt64(int64(q.RT_CLASS_MAX))},
			"RT_CLASS_UNSPEC":                  {"untyped int", constant.MakeInt64(int64(q.RT_CLASS_UNSPEC))},
			"RT_SCOPE_HOST":                    {"untyped int", constant.MakeInt64(int64(q.RT_SCOPE_HOST))},
			"RT_SCOPE_LINK":                    {"untyped int", constant.MakeInt64(int64(q.RT_SCOPE_LINK))},
			"RT_SCOPE_NOWHERE":                 {"untyped int", constant.MakeInt64(int64(q.RT_SCOPE_NOWHERE))},
			"RT_SCOPE_SITE":                    {"untyped int", constant.MakeInt64(int64(q.RT_SCOPE_SITE))},
			"RT_SCOPE_UNIVERSE":                {"untyped int", constant.MakeInt64(int64(q.RT_SCOPE_UNIVERSE))},
			"RT_TABLE_COMPAT":                  {"untyped int", constant.MakeInt64(int64(q.RT_TABLE_COMPAT))},
			"RT_TABLE_DEFAULT":                 {"untyped int", constant.MakeInt64(int64(q.RT_TABLE_DEFAULT))},
			"RT_TABLE_LOCAL":                   {"untyped int", constant.MakeInt64(int64(q.RT_TABLE_LOCAL))},
			"RT_TABLE_MAIN":                    {"untyped int", constant.MakeInt64(int64(q.RT_TABLE_MAIN))},
			"RT_TABLE_MAX":                     {"untyped int", constant.MakeInt64(int64(q.RT_TABLE_MAX))},
			"RT_TABLE_UNSPEC":                  {"untyped int", constant.MakeInt64(int64(q.RT_TABLE_UNSPEC))},
			"RUSAGE_CHILDREN":                  {"untyped int", constant.MakeInt64(int64(q.RUSAGE_CHILDREN))},
			"RUSAGE_SELF":                      {"untyped int", constant.MakeInt64(int64(q.RUSAGE_SELF))},
			"RUSAGE_THREAD":                    {"untyped int", constant.MakeInt64(int64(q.RUSAGE_THREAD))},
			"SCM_CREDENTIALS":                  {"untyped int", constant.MakeInt64(int64(q.SCM_CREDENTIALS))},
			"SCM_RIGHTS":                       {"untyped int", constant.MakeInt64(int64(q.SCM_RIGHTS))},
			"SCM_TIMESTAMP":                    {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMP))},
			"SCM_TIMESTAMPING":                 {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMPING))},
			"SCM_TIMESTAMPNS":                  {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMPNS))},
			"SCM_WIFI_STATUS":                  {"untyped int", constant.MakeInt64(int64(q.SCM_WIFI_STATUS))},
			"SHUT_RD":                          {"untyped int", constant.MakeInt64(int64(q.SHUT_RD))},
			"SHUT_RDWR":                        {"untyped int", constant.MakeInt64(int64(q.SHUT_RDWR))},
			"SHUT_WR":                          {"untyped int", constant.MakeInt64(int64(q.SHUT_WR))},
			"SIOCADDDLCI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCADDDLCI))},
			"SIOCADDMULTI":                     {"untyped int", constant.MakeInt64(int64(q.SIOCADDMULTI))},
			"SIOCADDRT":                        {"untyped int", constant.MakeInt64(int64(q.SIOCADDRT))},
			"SIOCATMARK":                       {"untyped int", constant.MakeInt64(int64(q.SIOCATMARK))},
			"SIOCDARP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCDARP))},
			"SIOCDELDLCI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDELDLCI))},
			"SIOCDELMULTI":                     {"untyped int", constant.MakeInt64(int64(q.SIOCDELMULTI))},
			"SIOCDELRT":                        {"untyped int", constant.MakeInt64(int64(q.SIOCDELRT))},
			"SIOCDEVPRIVATE":                   {"untyped int", constant.MakeInt64(int64(q.SIOCDEVPRIVATE))},
			"SIOCDIFADDR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDIFADDR))},
			"SIOCDRARP":                        {"untyped int", constant.MakeInt64(int64(q.SIOCDRARP))},
			"SIOCGARP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGARP))},
			"SIOCGIFADDR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFADDR))},
			"SIOCGIFBR":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBR))},
			"SIOCGIFBRDADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBRDADDR))},
			"SIOCGIFCONF":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCONF))},
			"SIOCGIFCOUNT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCOUNT))},
			"SIOCGIFDSTADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDSTADDR))},
			"SIOCGIFENCAP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFENCAP))},
			"SIOCGIFFLAGS":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFFLAGS))},
			"SIOCGIFHWADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFHWADDR))},
			"SIOCGIFINDEX":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFINDEX))},
			"SIOCGIFMAP":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMAP))},
			"SIOCGIFMEM":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMEM))},
			"SIOCGIFMETRIC":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMETRIC))},
			"SIOCGIFMTU":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMTU))},
			"SIOCGIFNAME":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNAME))},
			"SIOCGIFNETMASK":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNETMASK))},
			"SIOCGIFPFLAGS":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPFLAGS))},
			"SIOCGIFSLAVE":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFSLAVE))},
			"SIOCGIFTXQLEN":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFTXQLEN))},
			"SIOCGPGRP":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGPGRP))},
			"SIOCGRARP":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGRARP))},
			"SIOCGSTAMP":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGSTAMP))},
			"SIOCGSTAMPNS":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGSTAMPNS))},
			"SIOCPROTOPRIVATE":                 {"untyped int", constant.MakeInt64(int64(q.SIOCPROTOPRIVATE))},
			"SIOCRTMSG":                        {"untyped int", constant.MakeInt64(int64(q.SIOCRTMSG))},
			"SIOCSARP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSARP))},
			"SIOCSIFADDR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFADDR))},
			"SIOCSIFBR":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBR))},
			"SIOCSIFBRDADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBRDADDR))},
			"SIOCSIFDSTADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSIFDSTADDR))},
			"SIOCSIFENCAP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFENCAP))},
			"SIOCSIFFLAGS":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFFLAGS))},
			"SIOCSIFHWADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFHWADDR))},
			"SIOCSIFHWBROADCAST":               {"untyped int", constant.MakeInt64(int64(q.SIOCSIFHWBROADCAST))},
			"SIOCSIFLINK":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFLINK))},
			"SIOCSIFMAP":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMAP))},
			"SIOCSIFMEM":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMEM))},
			"SIOCSIFMETRIC":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMETRIC))},
			"SIOCSIFMTU":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMTU))},
			"SIOCSIFNAME":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNAME))},
			"SIOCSIFNETMASK":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNETMASK))},
			"SIOCSIFPFLAGS":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPFLAGS))},
			"SIOCSIFSLAVE":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFSLAVE))},
			"SIOCSIFTXQLEN":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFTXQLEN))},
			"SIOCSPGRP":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSPGRP))},
			"SIOCSRARP":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSRARP))},
			"SOCK_CLOEXEC":                     {"untyped int", constant.MakeInt64(int64(q.SOCK_CLOEXEC))},
			"SOCK_DCCP":                        {"untyped int", constant.MakeInt64(int64(q.SOCK_DCCP))},
			"SOCK_DGRAM":                       {"untyped int", constant.MakeInt64(int64(q.SOCK_DGRAM))},
			"SOCK_NONBLOCK":                    {"untyped int", constant.MakeInt64(int64(q.SOCK_NONBLOCK))},
			"SOCK_PACKET":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_PACKET))},
			"SOCK_RAW":                         {"untyped int", constant.MakeInt64(int64(q.SOCK_RAW))},
			"SOCK_RDM":                         {"untyped int", constant.MakeInt64(int64(q.SOCK_RDM))},
			"SOCK_SEQPACKET":                   {"untyped int", constant.MakeInt64(int64(q.SOCK_SEQPACKET))},
			"SOCK_STREAM":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_STREAM))},
			"SOL_AAL":                          {"untyped int", constant.MakeInt64(int64(q.SOL_AAL))},
			"SOL_ATM":                          {"untyped int", constant.MakeInt64(int64(q.SOL_ATM))},
			"SOL_DECNET":                       {"untyped int", constant.MakeInt64(int64(q.SOL_DECNET))},
			"SOL_ICMPV6":                       {"untyped int", constant.MakeInt64(int64(q.SOL_ICMPV6))},
			"SOL_IP":                           {"untyped int", constant.MakeInt64(int64(q.SOL_IP))},
			"SOL_IPV6":                         {"untyped int", constant.MakeInt64(int64(q.SOL_IPV6))},
			"SOL_IRDA":                         {"untyped int", constant.MakeInt64(int64(q.SOL_IRDA))},
			"SOL_PACKET":                       {"untyped int", constant.MakeInt64(int64(q.SOL_PACKET))},
			"SOL_RAW":                          {"untyped int", constant.MakeInt64(int64(q.SOL_RAW))},
			"SOL_SOCKET":                       {"untyped int", constant.MakeInt64(int64(q.SOL_SOCKET))},
			"SOL_TCP":                          {"untyped int", constant.MakeInt64(int64(q.SOL_TCP))},
			"SOL_X25":                          {"untyped int", constant.MakeInt64(int64(q.SOL_X25))},
			"SOMAXCONN":                        {"untyped int", constant.MakeInt64(int64(q.SOMAXCONN))},
			"SO_ACCEPTCONN":                    {"untyped int", constant.MakeInt64(int64(q.SO_ACCEPTCONN))},
			"SO_ATTACH_BPF":                    {"untyped int", constant.MakeInt64(int64(q.SO_ATTACH_BPF))},
			"SO_ATTACH_FILTER":                 {"untyped int", constant.MakeInt64(int64(q.SO_ATTACH_FILTER))},
			"SO_BINDTODEVICE":                  {"untyped int", constant.MakeInt64(int64(q.SO_BINDTODEVICE))},
			"SO_BPF_EXTENSIONS":                {"untyped int", constant.MakeInt64(int64(q.SO_BPF_EXTENSIONS))},
			"SO_BROADCAST":                     {"untyped int", constant.MakeInt64(int64(q.SO_BROADCAST))},
			"SO_BSDCOMPAT":                     {"untyped int", constant.MakeInt64(int64(q.SO_BSDCOMPAT))},
			"SO_BUSY_POLL":                     {"untyped int", constant.MakeInt64(int64(q.SO_BUSY_POLL))},
			"SO_DEBUG":                         {"untyped int", constant.MakeInt64(int64(q.SO_DEBUG))},
			"SO_DETACH_BPF":                    {"untyped int", constant.MakeInt64(int64(q.SO_DETACH_BPF))},
			"SO_DETACH_FILTER":                 {"untyped int", constant.MakeInt64(int64(q.SO_DETACH_FILTER))},
			"SO_DOMAIN":                        {"untyped int", constant.MakeInt64(int64(q.SO_DOMAIN))},
			"SO_DONTROUTE":                     {"untyped int", constant.MakeInt64(int64(q.SO_DONTROUTE))},
			"SO_ERROR":                         {"untyped int", constant.MakeInt64(int64(q.SO_ERROR))},
			"SO_GET_FILTER":                    {"untyped int", constant.MakeInt64(int64(q.SO_GET_FILTER))},
			"SO_INCOMING_CPU":                  {"untyped int", constant.MakeInt64(int64(q.SO_INCOMING_CPU))},
			"SO_KEEPALIVE":                     {"untyped int", constant.MakeInt64(int64(q.SO_KEEPALIVE))},
			"SO_LINGER":                        {"untyped int", constant.MakeInt64(int64(q.SO_LINGER))},
			"SO_LOCK_FILTER":                   {"untyped int", constant.MakeInt64(int64(q.SO_LOCK_FILTER))},
			"SO_MARK":                          {"untyped int", constant.MakeInt64(int64(q.SO_MARK))},
			"SO_MAX_PACING_RATE":               {"untyped int", constant.MakeInt64(int64(q.SO_MAX_PACING_RATE))},
			"SO_NOFCS":                         {"untyped int", constant.MakeInt64(int64(q.SO_NOFCS))},
			"SO_NO_CHECK":                      {"untyped int", constant.MakeInt64(int64(q.SO_NO_CHECK))},
			"SO_OOBINLINE":                     {"untyped int", constant.MakeInt64(int64(q.SO_OOBINLINE))},
			"SO_PASSCRED":                      {"untyped int", constant.MakeInt64(int64(q.SO_PASSCRED))},
			"SO_PASSSEC":                       {"untyped int", constant.MakeInt64(int64(q.SO_PASSSEC))},
			"SO_PEEK_OFF":                      {"untyped int", constant.MakeInt64(int64(q.SO_PEEK_OFF))},
			"SO_PEERCRED":                      {"untyped int", constant.MakeInt64(int64(q.SO_PEERCRED))},
			"SO_PEERNAME":                      {"untyped int", constant.MakeInt64(int64(q.SO_PEERNAME))},
			"SO_PEERSEC":                       {"untyped int", constant.MakeInt64(int64(q.SO_PEERSEC))},
			"SO_PRIORITY":                      {"untyped int", constant.MakeInt64(int64(q.SO_PRIORITY))},
			"SO_PROTOCOL":                      {"untyped int", constant.MakeInt64(int64(q.SO_PROTOCOL))},
			"SO_RCVBUF":                        {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUF))},
			"SO_RCVBUFFORCE":                   {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUFFORCE))},
			"SO_RCVLOWAT":                      {"untyped int", constant.MakeInt64(int64(q.SO_RCVLOWAT))},
			"SO_RCVTIMEO":                      {"untyped int", constant.MakeInt64(int64(q.SO_RCVTIMEO))},
			"SO_REUSEADDR":                     {"untyped int", constant.MakeInt64(int64(q.SO_REUSEADDR))},
			"SO_REUSEPORT":                     {"untyped int", constant.MakeInt64(int64(q.SO_REUSEPORT))},
			"SO_RXQ_OVFL":                      {"untyped int", constant.MakeInt64(int64(q.SO_RXQ_OVFL))},
			"SO_SECURITY_AUTHENTICATION":       {"untyped int", constant.MakeInt64(int64(q.SO_SECURITY_AUTHENTICATION))},
			"SO_SECURITY_ENCRYPTION_NETWORK":   {"untyped int", constant.MakeInt64(int64(q.SO_SECURITY_ENCRYPTION_NETWORK))},
			"SO_SECURITY_ENCRYPTION_TRANSPORT": {"untyped int", constant.MakeInt64(int64(q.SO_SECURITY_ENCRYPTION_TRANSPORT))},
			"SO_SELECT_ERR_QUEUE":              {"untyped int", constant.MakeInt64(int64(q.SO_SELECT_ERR_QUEUE))},
			"SO_SNDBUF":                        {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUF))},
			"SO_SNDBUFFORCE":                   {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUFFORCE))},
			"SO_SNDLOWAT":                      {"untyped int", constant.MakeInt64(int64(q.SO_SNDLOWAT))},
			"SO_SNDTIMEO":                      {"untyped int", constant.MakeInt64(int64(q.SO_SNDTIMEO))},
			"SO_TIMESTAMP":                     {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMP))},
			"SO_TIMESTAMPING":                  {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMPING))},
			"SO_TIMESTAMPNS":                   {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMPNS))},
			"SO_TYPE":                          {"untyped int", constant.MakeInt64(int64(q.SO_TYPE))},
			"SO_WIFI_STATUS":                   {"untyped int", constant.MakeInt64(int64(q.SO_WIFI_STATUS))},
			"SYS_ACCEPT4":                      {"untyped int", constant.MakeInt64(int64(q.SYS_ACCEPT4))},
			"SYS_ACCESS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ACCESS))},
			"SYS_ACCT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_ACCT))},
			"SYS_ADD_KEY":                      {"untyped int", constant.MakeInt64(int64(q.SYS_ADD_KEY))},
			"SYS_ADJTIMEX":                     {"untyped int", constant.MakeInt64(int64(q.SYS_ADJTIMEX))},
			"SYS_AFS_SYSCALL":                  {"untyped int", constant.MakeInt64(int64(q.SYS_AFS_SYSCALL))},
			"SYS_ALARM":                        {"untyped int", constant.MakeInt64(int64(q.SYS_ALARM))},
			"SYS_BDFLUSH":                      {"untyped int", constant.MakeInt64(int64(q.SYS_BDFLUSH))},
			"SYS_BIND":                         {"untyped int", constant.MakeInt64(int64(q.SYS_BIND))},
			"SYS_BPF":                          {"untyped int", constant.MakeInt64(int64(q.SYS_BPF))},
			"SYS_BRK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_BRK))},
			"SYS_CAPGET":                       {"untyped int", constant.MakeInt64(int64(q.SYS_CAPGET))},
			"SYS_CAPSET":                       {"untyped int", constant.MakeInt64(int64(q.SYS_CAPSET))},
			"SYS_CHDIR":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CHDIR))},
			"SYS_CHMOD":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CHMOD))},
			"SYS_CHOWN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CHOWN))},
			"SYS_CHROOT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_CHROOT))},
			"SYS_CLOCK_ADJTIME":                {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_ADJTIME))},
			"SYS_CLOCK_GETRES":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_GETRES))},
			"SYS_CLOCK_GETTIME":                {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_GETTIME))},
			"SYS_CLOCK_NANOSLEEP":              {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_NANOSLEEP))},
			"SYS_CLOCK_SETTIME":                {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_SETTIME))},
			"SYS_CLONE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CLONE))},
			"SYS_CLOSE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CLOSE))},
			"SYS_CONNECT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_CONNECT))},
			"SYS_CREAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CREAT))},
			"SYS_CREATE_MODULE":                {"untyped int", constant.MakeInt64(int64(q.SYS_CREATE_MODULE))},
			"SYS_DELETE_MODULE":                {"untyped int", constant.MakeInt64(int64(q.SYS_DELETE_MODULE))},
			"SYS_DUP":                          {"untyped int", constant.MakeInt64(int64(q.SYS_DUP))},
			"SYS_DUP2":                         {"untyped int", constant.MakeInt64(int64(q.SYS_DUP2))},
			"SYS_DUP3":                         {"untyped int", constant.MakeInt64(int64(q.SYS_DUP3))},
			"SYS_EPOLL_CREATE":                 {"untyped int", constant.MakeInt64(int64(q.SYS_EPOLL_CREATE))},
			"SYS_EPOLL_CREATE1":                {"untyped int", constant.MakeInt64(int64(q.SYS_EPOLL_CREATE1))},
			"SYS_EPOLL_CTL":                    {"untyped int", constant.MakeInt64(int64(q.SYS_EPOLL_CTL))},
			"SYS_EPOLL_PWAIT":                  {"untyped int", constant.MakeInt64(int64(q.SYS_EPOLL_PWAIT))},
			"SYS_EPOLL_WAIT":                   {"untyped int", constant.MakeInt64(int64(q.SYS_EPOLL_WAIT))},
			"SYS_EVENTFD":                      {"untyped int", constant.MakeInt64(int64(q.SYS_EVENTFD))},
			"SYS_EVENTFD2":                     {"untyped int", constant.MakeInt64(int64(q.SYS_EVENTFD2))},
			"SYS_EXECVE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_EXECVE))},
			"SYS_EXECVEAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_EXECVEAT))},
			"SYS_EXIT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_EXIT))},
			"SYS_EXIT_GROUP":                   {"untyped int", constant.MakeInt64(int64(q.SYS_EXIT_GROUP))},
			"SYS_FACCESSAT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FACCESSAT))},
			"SYS_FADVISE64":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FADVISE64))},
			"SYS_FALLOCATE":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FALLOCATE))},
			"SYS_FANOTIFY_INIT":                {"untyped int", constant.MakeInt64(int64(q.SYS_FANOTIFY_INIT))},
			"SYS_FANOTIFY_MARK":                {"untyped int", constant.MakeInt64(int64(q.SYS_FANOTIFY_MARK))},
			"SYS_FCHDIR":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FCHDIR))},
			"SYS_FCHMOD":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMOD))},
			"SYS_FCHMODAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMODAT))},
			"SYS_FCHOWN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FCHOWN))},
			"SYS_FCHOWNAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FCHOWNAT))},
			"SYS_FCNTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FCNTL))},
			"SYS_FDATASYNC":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FDATASYNC))},
			"SYS_FGETXATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FGETXATTR))},
			"SYS_FINIT_MODULE":                 {"untyped int", constant.MakeInt64(int64(q.SYS_FINIT_MODULE))},
			"SYS_FLISTXATTR":                   {"untyped int", constant.MakeInt64(int64(q.SYS_FLISTXATTR))},
			"SYS_FLOCK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FLOCK))},
			"SYS_FORK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FORK))},
			"SYS_FREMOVEXATTR":                 {"untyped int", constant.MakeInt64(int64(q.SYS_FREMOVEXATTR))},
			"SYS_FSETXATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FSETXATTR))},
			"SYS_FSTAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FSTAT))},
			"SYS_FSTATFS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATFS))},
			"SYS_FSTATFS64":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATFS64))},
			"SYS_FSYNC":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FSYNC))},
			"SYS_FTRUNCATE":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FTRUNCATE))},
			"SYS_FUTEX":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FUTEX))},
			"SYS_FUTIMESAT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_FUTIMESAT))},
			"SYS_GETCPU":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETCPU))},
			"SYS_GETCWD":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETCWD))},
			"SYS_GETDENTS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETDENTS))},
			"SYS_GETDENTS64":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETDENTS64))},
			"SYS_GETEGID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETEGID))},
			"SYS_GETEUID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETEUID))},
			"SYS_GETGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETGID))},
			"SYS_GETGROUPS":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETGROUPS))},
			"SYS_GETITIMER":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETITIMER))},
			"SYS_GETPEERNAME":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETPEERNAME))},
			"SYS_GETPGID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGID))},
			"SYS_GETPGRP":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGRP))},
			"SYS_GETPID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETPID))},
			"SYS_GETPMSG":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETPMSG))},
			"SYS_GETPPID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETPPID))},
			"SYS_GETPRIORITY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETPRIORITY))},
			"SYS_GETRANDOM":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETRANDOM))},
			"SYS_GETRESGID":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETRESGID))},
			"SYS_GETRESUID":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETRESUID))},
			"SYS_GETRLIMIT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETRLIMIT))},
			"SYS_GETRUSAGE":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETRUSAGE))},
			"SYS_GETSID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETSID))},
			"SYS_GETSOCKNAME":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKNAME))},
			"SYS_GETSOCKOPT":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKOPT))},
			"SYS_GETTID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETTID))},
			"SYS_GETTIMEOFDAY":                 {"untyped int", constant.MakeInt64(int64(q.SYS_GETTIMEOFDAY))},
			"SYS_GETUID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETUID))},
			"SYS_GETXATTR":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETXATTR))},
			"SYS_GET_KERNEL_SYMS":              {"untyped int", constant.MakeInt64(int64(q.SYS_GET_KERNEL_SYMS))},
			"SYS_GET_MEMPOLICY":                {"untyped int", constant.MakeInt64(int64(q.SYS_GET_MEMPOLICY))},
			"SYS_GET_ROBUST_LIST":              {"untyped int", constant.MakeInt64(int64(q.SYS_GET_ROBUST_LIST))},
			"SYS_IDLE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_IDLE))},
			"SYS_INIT_MODULE":                  {"untyped int", constant.MakeInt64(int64(q.SYS_INIT_MODULE))},
			"SYS_INOTIFY_ADD_WATCH":            {"untyped int", constant.MakeInt64(int64(q.SYS_INOTIFY_ADD_WATCH))},
			"SYS_INOTIFY_INIT":                 {"untyped int", constant.MakeInt64(int64(q.SYS_INOTIFY_INIT))},
			"SYS_INOTIFY_INIT1":                {"untyped int", constant.MakeInt64(int64(q.SYS_INOTIFY_INIT1))},
			"SYS_INOTIFY_RM_WATCH":             {"untyped int", constant.MakeInt64(int64(q.SYS_INOTIFY_RM_WATCH))},
			"SYS_IOCTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_IOCTL))},
			"SYS_IOPRIO_GET":                   {"untyped int", constant.MakeInt64(int64(q.SYS_IOPRIO_GET))},
			"SYS_IOPRIO_SET":                   {"untyped int", constant.MakeInt64(int64(q.SYS_IOPRIO_SET))},
			"SYS_IO_CANCEL":                    {"untyped int", constant.MakeInt64(int64(q.SYS_IO_CANCEL))},
			"SYS_IO_DESTROY":                   {"untyped int", constant.MakeInt64(int64(q.SYS_IO_DESTROY))},
			"SYS_IO_GETEVENTS":                 {"untyped int", constant.MakeInt64(int64(q.SYS_IO_GETEVENTS))},
			"SYS_IO_SETUP":                     {"untyped int", constant.MakeInt64(int64(q.SYS_IO_SETUP))},
			"SYS_IO_SUBMIT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_IO_SUBMIT))},
			"SYS_IPC":                          {"untyped int", constant.MakeInt64(int64(q.SYS_IPC))},
			"SYS_KCMP":                         {"untyped int", constant.MakeInt64(int64(q.SYS_KCMP))},
			"SYS_KEXEC_LOAD":                   {"untyped int", constant.MakeInt64(int64(q.SYS_KEXEC_LOAD))},
			"SYS_KEYCTL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_KEYCTL))},
			"SYS_KILL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_KILL))},
			"SYS_LCHOWN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_LCHOWN))},
			"SYS_LGETXATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_LGETXATTR))},
			"SYS_LINK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LINK))},
			"SYS_LINKAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_LINKAT))},
			"SYS_LISTEN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_LISTEN))},
			"SYS_LISTXATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_LISTXATTR))},
			"SYS_LLISTXATTR":                   {"untyped int", constant.MakeInt64(int64(q.SYS_LLISTXATTR))},
			"SYS_LOOKUP_DCOOKIE":               {"untyped int", constant.MakeInt64(int64(q.SYS_LOOKUP_DCOOKIE))},
			"SYS_LREMOVEXATTR":                 {"untyped int", constant.MakeInt64(int64(q.SYS_LREMOVEXATTR))},
			"SYS_LSEEK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LSEEK))},
			"SYS_LSETXATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_LSETXATTR))},
			"SYS_LSTAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LSTAT))},
			"SYS_MADVISE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MADVISE))},
			"SYS_MBIND":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MBIND))},
			"SYS_MEMBARRIER":                   {"untyped int", constant.MakeInt64(int64(q.SYS_MEMBARRIER))},
			"SYS_MEMFD_CREATE":                 {"untyped int", constant.MakeInt64(int64(q.SYS_MEMFD_CREATE))},
			"SYS_MIGRATE_PAGES":                {"untyped int", constant.MakeInt64(int64(q.SYS_MIGRATE_PAGES))},
			"SYS_MINCORE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MINCORE))},
			"SYS_MKDIR":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIR))},
			"SYS_MKDIRAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIRAT))},
			"SYS_MKNOD":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MKNOD))},
			"SYS_MKNODAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MKNODAT))},
			"SYS_MLOCK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCK))},
			"SYS_MLOCK2":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCK2))},
			"SYS_MLOCKALL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCKALL))},
			"SYS_MMAP":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MMAP))},
			"SYS_MOUNT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MOUNT))},
			"SYS_MOVE_PAGES":                   {"untyped int", constant.MakeInt64(int64(q.SYS_MOVE_PAGES))},
			"SYS_MPROTECT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_MPROTECT))},
			"SYS_MQ_GETSETATTR":                {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_GETSETATTR))},
			"SYS_MQ_NOTIFY":                    {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_NOTIFY))},
			"SYS_MQ_OPEN":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_OPEN))},
			"SYS_MQ_TIMEDRECEIVE":              {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_TIMEDRECEIVE))},
			"SYS_MQ_TIMEDSEND":                 {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_TIMEDSEND))},
			"SYS_MQ_UNLINK":                    {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_UNLINK))},
			"SYS_MREMAP":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MREMAP))},
			"SYS_MSYNC":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSYNC))},
			"SYS_MUNLOCK":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCK))},
			"SYS_MUNLOCKALL":                   {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCKALL))},
			"SYS_MUNMAP":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MUNMAP))},
			"SYS_NAME_TO_HANDLE_AT":            {"untyped int", constant.MakeInt64(int64(q.SYS_NAME_TO_HANDLE_AT))},
			"SYS_NANOSLEEP":                    {"untyped int", constant.MakeInt64(int64(q.SYS_NANOSLEEP))},
			"SYS_NEWFSTATAT":                   {"untyped int", constant.MakeInt64(int64(q.SYS_NEWFSTATAT))},
			"SYS_NFSSERVCTL":                   {"untyped int", constant.MakeInt64(int64(q.SYS_NFSSERVCTL))},
			"SYS_NICE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_NICE))},
			"SYS_OPEN":                         {"untyped int", constant.MakeInt64(int64(q.SYS_OPEN))},
			"SYS_OPENAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_OPENAT))},
			"SYS_OPEN_BY_HANDLE_AT":            {"untyped int", constant.MakeInt64(int64(q.SYS_OPEN_BY_HANDLE_AT))},
			"SYS_PAUSE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PAUSE))},
			"SYS_PERF_EVENT_OPEN":              {"untyped int", constant.MakeInt64(int64(q.SYS_PERF_EVENT_OPEN))},
			"SYS_PERSONALITY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_PERSONALITY))},
			"SYS_PIPE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PIPE))},
			"SYS_PIPE2":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PIPE2))},
			"SYS_PIVOT_ROOT":                   {"untyped int", constant.MakeInt64(int64(q.SYS_PIVOT_ROOT))},
			"SYS_POLL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_POLL))},
			"SYS_PPOLL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PPOLL))},
			"SYS_PRCTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PRCTL))},
			"SYS_PREAD64":                      {"untyped int", constant.MakeInt64(int64(q.SYS_PREAD64))},
			"SYS_PREADV":                       {"untyped int", constant.MakeInt64(int64(q.SYS_PREADV))},
			"SYS_PRLIMIT64":                    {"untyped int", constant.MakeInt64(int64(q.SYS_PRLIMIT64))},
			"SYS_PROCESS_VM_READV":             {"untyped int", constant.MakeInt64(int64(q.SYS_PROCESS_VM_READV))},
			"SYS_PROCESS_VM_WRITEV":            {"untyped int", constant.MakeInt64(int64(q.SYS_PROCESS_VM_WRITEV))},
			"SYS_PSELECT6":                     {"untyped int", constant.MakeInt64(int64(q.SYS_PSELECT6))},
			"SYS_PTRACE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_PTRACE))},
			"SYS_PUTPMSG":                      {"untyped int", constant.MakeInt64(int64(q.SYS_PUTPMSG))},
			"SYS_PWRITE64":                     {"untyped int", constant.MakeInt64(int64(q.SYS_PWRITE64))},
			"SYS_PWRITEV":                      {"untyped int", constant.MakeInt64(int64(q.SYS_PWRITEV))},
			"SYS_QUERY_MODULE":                 {"untyped int", constant.MakeInt64(int64(q.SYS_QUERY_MODULE))},
			"SYS_QUOTACTL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_QUOTACTL))},
			"SYS_READ":                         {"untyped int", constant.MakeInt64(int64(q.SYS_READ))},
			"SYS_READAHEAD":                    {"untyped int", constant.MakeInt64(int64(q.SYS_READAHEAD))},
			"SYS_READDIR":                      {"untyped int", constant.MakeInt64(int64(q.SYS_READDIR))},
			"SYS_READLINK":                     {"untyped int", constant.MakeInt64(int64(q.SYS_READLINK))},
			"SYS_READLINKAT":                   {"untyped int", constant.MakeInt64(int64(q.SYS_READLINKAT))},
			"SYS_READV":                        {"untyped int", constant.MakeInt64(int64(q.SYS_READV))},
			"SYS_REBOOT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_REBOOT))},
			"SYS_RECVFROM":                     {"untyped int", constant.MakeInt64(int64(q.SYS_RECVFROM))},
			"SYS_RECVMMSG":                     {"untyped int", constant.MakeInt64(int64(q.SYS_RECVMMSG))},
			"SYS_RECVMSG":                      {"untyped int", constant.MakeInt64(int64(q.SYS_RECVMSG))},
			"SYS_REMAP_FILE_PAGES":             {"untyped int", constant.MakeInt64(int64(q.SYS_REMAP_FILE_PAGES))},
			"SYS_REMOVEXATTR":                  {"untyped int", constant.MakeInt64(int64(q.SYS_REMOVEXATTR))},
			"SYS_RENAME":                       {"untyped int", constant.MakeInt64(int64(q.SYS_RENAME))},
			"SYS_RENAMEAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_RENAMEAT))},
			"SYS_RENAMEAT2":                    {"untyped int", constant.MakeInt64(int64(q.SYS_RENAMEAT2))},
			"SYS_REQUEST_KEY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_REQUEST_KEY))},
			"SYS_RESTART_SYSCALL":              {"untyped int", constant.MakeInt64(int64(q.SYS_RESTART_SYSCALL))},
			"SYS_RMDIR":                        {"untyped int", constant.MakeInt64(int64(q.SYS_RMDIR))},
			"SYS_RT_SIGACTION":                 {"untyped int", constant.MakeInt64(int64(q.SYS_RT_SIGACTION))},
			"SYS_RT_SIGPENDING":                {"untyped int", constant.MakeInt64(int64(q.SYS_RT_SIGPENDING))},
			"SYS_RT_SIGPROCMASK":               {"untyped int", constant.MakeInt64(int64(q.SYS_RT_SIGPROCMASK))},
			"SYS_RT_SIGQUEUEINFO":              {"untyped int", constant.MakeInt64(int64(q.SYS_RT_SIGQUEUEINFO))},
			"SYS_RT_SIGRETURN":                 {"untyped int", constant.MakeInt64(int64(q.SYS_RT_SIGRETURN))},
			"SYS_RT_SIGSUSPEND":                {"untyped int", constant.MakeInt64(int64(q.SYS_RT_SIGSUSPEND))},
			"SYS_RT_SIGTIMEDWAIT":              {"untyped int", constant.MakeInt64(int64(q.SYS_RT_SIGTIMEDWAIT))},
			"SYS_RT_TGSIGQUEUEINFO":            {"untyped int", constant.MakeInt64(int64(q.SYS_RT_TGSIGQUEUEINFO))},
			"SYS_S390_PCI_MMIO_READ":           {"untyped int", constant.MakeInt64(int64(q.SYS_S390_PCI_MMIO_READ))},
			"SYS_S390_PCI_MMIO_WRITE":          {"untyped int", constant.MakeInt64(int64(q.SYS_S390_PCI_MMIO_WRITE))},
			"SYS_S390_RUNTIME_INSTR":           {"untyped int", constant.MakeInt64(int64(q.SYS_S390_RUNTIME_INSTR))},
			"SYS_SCHED_GETAFFINITY":            {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GETAFFINITY))},
			"SYS_SCHED_GETATTR":                {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GETATTR))},
			"SYS_SCHED_GETPARAM":               {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GETPARAM))},
			"SYS_SCHED_GETSCHEDULER":           {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GETSCHEDULER))},
			"SYS_SCHED_GET_PRIORITY_MAX":       {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GET_PRIORITY_MAX))},
			"SYS_SCHED_GET_PRIORITY_MIN":       {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GET_PRIORITY_MIN))},
			"SYS_SCHED_RR_GET_INTERVAL":        {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_RR_GET_INTERVAL))},
			"SYS_SCHED_SETAFFINITY":            {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_SETAFFINITY))},
			"SYS_SCHED_SETATTR":                {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_SETATTR))},
			"SYS_SCHED_SETPARAM":               {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_SETPARAM))},
			"SYS_SCHED_SETSCHEDULER":           {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_SETSCHEDULER))},
			"SYS_SCHED_YIELD":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_YIELD))},
			"SYS_SECCOMP":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SECCOMP))},
			"SYS_SELECT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SELECT))},
			"SYS_SENDFILE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SENDFILE))},
			"SYS_SENDMMSG":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SENDMMSG))},
			"SYS_SENDMSG":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SENDMSG))},
			"SYS_SENDTO":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SENDTO))},
			"SYS_SETDOMAINNAME":                {"untyped int", constant.MakeInt64(int64(q.SYS_SETDOMAINNAME))},
			"SYS_SETFSGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETFSGID))},
			"SYS_SETFSUID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETFSUID))},
			"SYS_SETGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETGID))},
			"SYS_SETGROUPS":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETGROUPS))},
			"SYS_SETHOSTNAME":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SETHOSTNAME))},
			"SYS_SETITIMER":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETITIMER))},
			"SYS_SETNS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETNS))},
			"SYS_SETPGID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETPGID))},
			"SYS_SETPRIORITY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SETPRIORITY))},
			"SYS_SETREGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETREGID))},
			"SYS_SETRESGID":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETRESGID))},
			"SYS_SETRESUID":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETRESUID))},
			"SYS_SETREUID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETREUID))},
			"SYS_SETRLIMIT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETRLIMIT))},
			"SYS_SETSID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETSID))},
			"SYS_SETSOCKOPT":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SETSOCKOPT))},
			"SYS_SETTIMEOFDAY":                 {"untyped int", constant.MakeInt64(int64(q.SYS_SETTIMEOFDAY))},
			"SYS_SETUID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETUID))},
			"SYS_SETXATTR":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETXATTR))},
			"SYS_SET_MEMPOLICY":                {"untyped int", constant.MakeInt64(int64(q.SYS_SET_MEMPOLICY))},
			"SYS_SET_ROBUST_LIST":              {"untyped int", constant.MakeInt64(int64(q.SYS_SET_ROBUST_LIST))},
			"SYS_SET_TID_ADDRESS":              {"untyped int", constant.MakeInt64(int64(q.SYS_SET_TID_ADDRESS))},
			"SYS_SHUTDOWN":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SHUTDOWN))},
			"SYS_SIGACTION":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGACTION))},
			"SYS_SIGALTSTACK":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SIGALTSTACK))},
			"SYS_SIGNAL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SIGNAL))},
			"SYS_SIGNALFD":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SIGNALFD))},
			"SYS_SIGNALFD4":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGNALFD4))},
			"SYS_SIGPENDING":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPENDING))},
			"SYS_SIGPROCMASK":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPROCMASK))},
			"SYS_SIGRETURN":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGRETURN))},
			"SYS_SIGSUSPEND":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SIGSUSPEND))},
			"SYS_SOCKET":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKET))},
			"SYS_SOCKETCALL":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKETCALL))},
			"SYS_SOCKETPAIR":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKETPAIR))},
			"SYS_SPLICE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SPLICE))},
			"SYS_STAT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_STAT))},
			"SYS_STATFS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_STATFS))},
			"SYS_STATFS64":                     {"untyped int", constant.MakeInt64(int64(q.SYS_STATFS64))},
			"SYS_SWAPOFF":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SWAPOFF))},
			"SYS_SWAPON":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SWAPON))},
			"SYS_SYMLINK":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SYMLINK))},
			"SYS_SYMLINKAT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SYMLINKAT))},
			"SYS_SYNC":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SYNC))},
			"SYS_SYNCFS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SYNCFS))},
			"SYS_SYNC_FILE_RANGE":              {"untyped int", constant.MakeInt64(int64(q.SYS_SYNC_FILE_RANGE))},
			"SYS_SYSFS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SYSFS))},
			"SYS_SYSINFO":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SYSINFO))},
			"SYS_SYSLOG":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SYSLOG))},
			"SYS_TEE":                          {"untyped int", constant.MakeInt64(int64(q.SYS_TEE))},
			"SYS_TGKILL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_TGKILL))},
			"SYS_TIMERFD":                      {"untyped int", constant.MakeInt64(int64(q.SYS_TIMERFD))},
			"SYS_TIMERFD_CREATE":               {"untyped int", constant.MakeInt64(int64(q.SYS_TIMERFD_CREATE))},
			"SYS_TIMERFD_GETTIME":              {"untyped int", constant.MakeInt64(int64(q.SYS_TIMERFD_GETTIME))},
			"SYS_TIMERFD_SETTIME":              {"untyped int", constant.MakeInt64(int64(q.SYS_TIMERFD_SETTIME))},
			"SYS_TIMER_CREATE":                 {"untyped int", constant.MakeInt64(int64(q.SYS_TIMER_CREATE))},
			"SYS_TIMER_DELETE":                 {"untyped int", constant.MakeInt64(int64(q.SYS_TIMER_DELETE))},
			"SYS_TIMER_GETOVERRUN":             {"untyped int", constant.MakeInt64(int64(q.SYS_TIMER_GETOVERRUN))},
			"SYS_TIMER_GETTIME":                {"untyped int", constant.MakeInt64(int64(q.SYS_TIMER_GETTIME))},
			"SYS_TIMER_SETTIME":                {"untyped int", constant.MakeInt64(int64(q.SYS_TIMER_SETTIME))},
			"SYS_TIMES":                        {"untyped int", constant.MakeInt64(int64(q.SYS_TIMES))},
			"SYS_TKILL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_TKILL))},
			"SYS_TRUNCATE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_TRUNCATE))},
			"SYS_UMASK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UMASK))},
			"SYS_UMOUNT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_UMOUNT))},
			"SYS_UMOUNT2":                      {"untyped int", constant.MakeInt64(int64(q.SYS_UMOUNT2))},
			"SYS_UNAME":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UNAME))},
			"SYS_UNLINK":                       {"untyped int", constant.MakeInt64(int64(q.SYS_UNLINK))},
			"SYS_UNLINKAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_UNLINKAT))},
			"SYS_UNSHARE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_UNSHARE))},
			"SYS_USELIB":                       {"untyped int", constant.MakeInt64(int64(q.SYS_USELIB))},
			"SYS_USERFAULTFD":                  {"untyped int", constant.MakeInt64(int64(q.SYS_USERFAULTFD))},
			"SYS_USTAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_USTAT))},
			"SYS_UTIME":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UTIME))},
			"SYS_UTIMENSAT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_UTIMENSAT))},
			"SYS_UTIMES":                       {"untyped int", constant.MakeInt64(int64(q.SYS_UTIMES))},
			"SYS_VFORK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_VFORK))},
			"SYS_VHANGUP":                      {"untyped int", constant.MakeInt64(int64(q.SYS_VHANGUP))},
			"SYS_VMSPLICE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPLICE))},
			"SYS_WAIT4":                        {"untyped int", constant.MakeInt64(int64(q.SYS_WAIT4))},
			"SYS_WAITID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_WAITID))},
			"SYS_WRITE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_WRITE))},
			"SYS_WRITEV":                       {"untyped int", constant.MakeInt64(int64(q.SYS_WRITEV))},
			"SYS__SYSCTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS__SYSCTL))},
			"S_BLKSIZE":                        {"untyped int", constant.MakeInt64(int64(q.S_BLKSIZE))},
			"S_IEXEC":                          {"untyped int", constant.MakeInt64(int64(q.S_IEXEC))},
			"S_IFBLK":                          {"untyped int", constant.MakeInt64(int64(q.S_IFBLK))},
			"S_IFCHR":                          {"untyped int", constant.MakeInt64(int64(q.S_IFCHR))},
			"S_IFDIR":                          {"untyped int", constant.MakeInt64(int64(q.S_IFDIR))},
			"S_IFIFO":                          {"untyped int", constant.MakeInt64(int64(q.S_IFIFO))},
			"S_IFLNK":                          {"untyped int", constant.MakeInt64(int64(q.S_IFLNK))},
			"S_IFMT":                           {"untyped int", constant.MakeInt64(int64(q.S_IFMT))},
			"S_IFREG":                          {"untyped int", constant.MakeInt64(int64(q.S_IFREG))},
			"S_IFSOCK":                         {"untyped int", constant.MakeInt64(int64(q.S_IFSOCK))},
			"S_IREAD":                          {"untyped int", constant.MakeInt64(int64(q.S_IREAD))},
			"S_IRGRP":                          {"untyped int", constant.MakeInt64(int64(q.S_IRGRP))},
			"S_IROTH":                          {"untyped int", constant.MakeInt64(int64(q.S_IROTH))},
			"S_IRUSR":                          {"untyped int", constant.MakeInt64(int64(q.S_IRUSR))},
			"S_IRWXG":                          {"untyped int", constant.MakeInt64(int64(q.S_IRWXG))},
			"S_IRWXO":                          {"untyped int", constant.MakeInt64(int64(q.S_IRWXO))},
			"S_IRWXU":                          {"untyped int", constant.MakeInt64(int64(q.S_IRWXU))},
			"S_ISGID":                          {"untyped int", constant.MakeInt64(int64(q.S_ISGID))},
			"S_ISUID":                          {"untyped int", constant.MakeInt64(int64(q.S_ISUID))},
			"S_ISVTX":                          {"untyped int", constant.MakeInt64(int64(q.S_ISVTX))},
			"S_IWGRP":                          {"untyped int", constant.MakeInt64(int64(q.S_IWGRP))},
			"S_IWOTH":                          {"untyped int", constant.MakeInt64(int64(q.S_IWOTH))},
			"S_IWRITE":                         {"untyped int", constant.MakeInt64(int64(q.S_IWRITE))},
			"S_IWUSR":                          {"untyped int", constant.MakeInt64(int64(q.S_IWUSR))},
			"S_IXGRP":                          {"untyped int", constant.MakeInt64(int64(q.S_IXGRP))},
			"S_IXOTH":                          {"untyped int", constant.MakeInt64(int64(q.S_IXOTH))},
			"S_IXUSR":                          {"untyped int", constant.MakeInt64(int64(q.S_IXUSR))},
			"SizeofCmsghdr":                    {"untyped int", constant.MakeInt64(int64(q.SizeofCmsghdr))},
			"SizeofICMPv6Filter":               {"untyped int", constant.MakeInt64(int64(q.SizeofICMPv6Filter))},
			"SizeofIPMreq":                     {"untyped int", constant.MakeInt64(int64(q.SizeofIPMreq))},
			"SizeofIPMreqn":                    {"untyped int", constant.MakeInt64(int64(q.SizeofIPMreqn))},
			"SizeofIPv6MTUInfo":                {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6MTUInfo))},
			"SizeofIPv6Mreq":                   {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6Mreq))},
			"SizeofIfAddrmsg":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIfAddrmsg))},
			"SizeofIfInfomsg":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIfInfomsg))},
			"SizeofInet4Pktinfo":               {"untyped int", constant.MakeInt64(int64(q.SizeofInet4Pktinfo))},
			"SizeofInet6Pktinfo":               {"untyped int", constant.MakeInt64(int64(q.SizeofInet6Pktinfo))},
			"SizeofInotifyEvent":               {"untyped int", constant.MakeInt64(int64(q.SizeofInotifyEvent))},
			"SizeofLinger":                     {"untyped int", constant.MakeInt64(int64(q.SizeofLinger))},
			"SizeofMsghdr":                     {"untyped int", constant.MakeInt64(int64(q.SizeofMsghdr))},
			"SizeofNlAttr":                     {"untyped int", constant.MakeInt64(int64(q.SizeofNlAttr))},
			"SizeofNlMsgerr":                   {"untyped int", constant.MakeInt64(int64(q.SizeofNlMsgerr))},
			"SizeofNlMsghdr":                   {"untyped int", constant.MakeInt64(int64(q.SizeofNlMsghdr))},
			"SizeofRtAttr":                     {"untyped int", constant.MakeInt64(int64(q.SizeofRtAttr))},
			"SizeofRtGenmsg":                   {"untyped int", constant.MakeInt64(int64(q.SizeofRtGenmsg))},
			"SizeofRtMsg":                      {"untyped int", constant.MakeInt64(int64(q.SizeofRtMsg))},
			"SizeofRtNexthop":                  {"untyped int", constant.MakeInt64(int64(q.SizeofRtNexthop))},
			"SizeofSockFilter":                 {"untyped int", constant.MakeInt64(int64(q.SizeofSockFilter))},
			"SizeofSockFprog":                  {"untyped int", constant.MakeInt64(int64(q.SizeofSockFprog))},
			"SizeofSockaddrAny":                {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrAny))},
			"SizeofSockaddrInet4":              {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet4))},
			"SizeofSockaddrInet6":              {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet6))},
			"SizeofSockaddrLinklayer":          {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrLinklayer))},
			"SizeofSockaddrNetlink":            {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrNetlink))},
			"SizeofSockaddrUnix":               {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrUnix))},
			"SizeofTCPInfo":                    {"untyped int", constant.MakeInt64(int64(q.SizeofTCPInfo))},
			"SizeofUcred":                      {"untyped int", constant.MakeInt64(int64(q.SizeofUcred))},
			"TCFLSH":                           {"untyped int", constant.MakeInt64(int64(q.TCFLSH))},
			"TCGETS":                           {"untyped int", constant.MakeInt64(int64(q.TCGETS))},
			"TCIFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TCIFLUSH))},
			"TCIOFLUSH":                        {"untyped int", constant.MakeInt64(int64(q.TCIOFLUSH))},
			"TCOFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TCOFLUSH))},
			"TCP_CONGESTION":                   {"untyped int", constant.MakeInt64(int64(q.TCP_CONGESTION))},
			"TCP_COOKIE_IN_ALWAYS":             {"untyped int", constant.MakeInt64(int64(q.TCP_COOKIE_IN_ALWAYS))},
			"TCP_COOKIE_MAX":                   {"untyped int", constant.MakeInt64(int64(q.TCP_COOKIE_MAX))},
			"TCP_COOKIE_MIN":                   {"untyped int", constant.MakeInt64(int64(q.TCP_COOKIE_MIN))},
			"TCP_COOKIE_OUT_NEVER":             {"untyped int", constant.MakeInt64(int64(q.TCP_COOKIE_OUT_NEVER))},
			"TCP_COOKIE_PAIR_SIZE":             {"untyped int", constant.MakeInt64(int64(q.TCP_COOKIE_PAIR_SIZE))},
			"TCP_COOKIE_TRANSACTIONS":          {"untyped int", constant.MakeInt64(int64(q.TCP_COOKIE_TRANSACTIONS))},
			"TCP_CORK":                         {"untyped int", constant.MakeInt64(int64(q.TCP_CORK))},
			"TCP_DEFER_ACCEPT":                 {"untyped int", constant.MakeInt64(int64(q.TCP_DEFER_ACCEPT))},
			"TCP_FASTOPEN":                     {"untyped int", constant.MakeInt64(int64(q.TCP_FASTOPEN))},
			"TCP_INFO":                         {"untyped int", constant.MakeInt64(int64(q.TCP_INFO))},
			"TCP_KEEPCNT":                      {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPCNT))},
			"TCP_KEEPIDLE":                     {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPIDLE))},
			"TCP_KEEPINTVL":                    {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPINTVL))},
			"TCP_LINGER2":                      {"untyped int", constant.MakeInt64(int64(q.TCP_LINGER2))},
			"TCP_MAXSEG":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MAXSEG))},
			"TCP_MAXWIN":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MAXWIN))},
			"TCP_MAX_WINSHIFT":                 {"untyped int", constant.MakeInt64(int64(q.TCP_MAX_WINSHIFT))},
			"TCP_MD5SIG":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MD5SIG))},
			"TCP_MD5SIG_MAXKEYLEN":             {"untyped int", constant.MakeInt64(int64(q.TCP_MD5SIG_MAXKEYLEN))},
			"TCP_MSS":                          {"untyped int", constant.MakeInt64(int64(q.TCP_MSS))},
			"TCP_MSS_DEFAULT":                  {"untyped int", constant.MakeInt64(int64(q.TCP_MSS_DEFAULT))},
			"TCP_MSS_DESIRED":                  {"untyped int", constant.MakeInt64(int64(q.TCP_MSS_DESIRED))},
			"TCP_NODELAY":                      {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAY))},
			"TCP_QUEUE_SEQ":                    {"untyped int", constant.MakeInt64(int64(q.TCP_QUEUE_SEQ))},
			"TCP_QUICKACK":                     {"untyped int", constant.MakeInt64(int64(q.TCP_QUICKACK))},
			"TCP_REPAIR":                       {"untyped int", constant.MakeInt64(int64(q.TCP_REPAIR))},
			"TCP_REPAIR_OPTIONS":               {"untyped int", constant.MakeInt64(int64(q.TCP_REPAIR_OPTIONS))},
			"TCP_REPAIR_QUEUE":                 {"untyped int", constant.MakeInt64(int64(q.TCP_REPAIR_QUEUE))},
			"TCP_SYNCNT":                       {"untyped int", constant.MakeInt64(int64(q.TCP_SYNCNT))},
			"TCP_S_DATA_IN":                    {"untyped int", constant.MakeInt64(int64(q.TCP_S_DATA_IN))},
			"TCP_S_DATA_OUT":                   {"untyped int", constant.MakeInt64(int64(q.TCP_S_DATA_OUT))},
			"TCP_THIN_DUPACK":                  {"untyped int", constant.MakeInt64(int64(q.TCP_THIN_DUPACK))},
			"TCP_THIN_LINEAR_TIMEOUTS":         {"untyped int", constant.MakeInt64(int64(q.TCP_THIN_LINEAR_TIMEOUTS))},
			"TCP_TIMESTAMP":                    {"untyped int", constant.MakeInt64(int64(q.TCP_TIMESTAMP))},
			"TCP_USER_TIMEOUT":                 {"untyped int", constant.MakeInt64(int64(q.TCP_USER_TIMEOUT))},
			"TCP_WINDOW_CLAMP":                 {"untyped int", constant.MakeInt64(int64(q.TCP_WINDOW_CLAMP))},
			"TCSAFLUSH":                        {"untyped int", constant.MakeInt64(int64(q.TCSAFLUSH))},
			"TCSETS":                           {"untyped int", constant.MakeInt64(int64(q.TCSETS))},
			"TIOCCBRK":                         {"untyped int", constant.MakeInt64(int64(q.TIOCCBRK))},
			"TIOCCONS":                         {"untyped int", constant.MakeInt64(int64(q.TIOCCONS))},
			"TIOCEXCL":                         {"untyped int", constant.MakeInt64(int64(q.TIOCEXCL))},
			"TIOCGDEV":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGDEV))},
			"TIOCGETD":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGETD))},
			"TIOCGEXCL":                        {"untyped int", constant.MakeInt64(int64(q.TIOCGEXCL))},
			"TIOCGICOUNT":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGICOUNT))},
			"TIOCGLCKTRMIOS":                   {"untyped int", constant.MakeInt64(int64(q.TIOCGLCKTRMIOS))},
			"TIOCGPGRP":                        {"untyped int", constant.MakeInt64(int64(q.TIOCGPGRP))},
			"TIOCGPKT":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGPKT))},
			"TIOCGPTLCK":                       {"untyped int", constant.MakeInt64(int64(q.TIOCGPTLCK))},
			"TIOCGPTN":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGPTN))},
			"TIOCGRS485":                       {"untyped int", constant.MakeInt64(int64(q.TIOCGRS485))},
			"TIOCGSERIAL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGSERIAL))},
			"TIOCGSID":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGSID))},
			"TIOCGSOFTCAR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCGSOFTCAR))},
			"TIOCGWINSZ":                       {"untyped int", constant.MakeInt64(int64(q.TIOCGWINSZ))},
			"TIOCINQ":                          {"untyped int", constant.MakeInt64(int64(q.TIOCINQ))},
			"TIOCLINUX":                        {"untyped int", constant.MakeInt64(int64(q.TIOCLINUX))},
			"TIOCMBIC":                         {"untyped int", constant.MakeInt64(int64(q.TIOCMBIC))},
			"TIOCMBIS":                         {"untyped int", constant.MakeInt64(int64(q.TIOCMBIS))},
			"TIOCMGET":                         {"untyped int", constant.MakeInt64(int64(q.TIOCMGET))},
			"TIOCMIWAIT":                       {"untyped int", constant.MakeInt64(int64(q.TIOCMIWAIT))},
			"TIOCMSET":                         {"untyped int", constant.MakeInt64(int64(q.TIOCMSET))},
			"TIOCM_CAR":                        {"untyped int", constant.MakeInt64(int64(q.TIOCM_CAR))},
			"TIOCM_CD":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_CD))},
			"TIOCM_CTS":                        {"untyped int", constant.MakeInt64(int64(q.TIOCM_CTS))},
			"TIOCM_DSR":                        {"untyped int", constant.MakeInt64(int64(q.TIOCM_DSR))},
			"TIOCM_DTR":                        {"untyped int", constant.MakeInt64(int64(q.TIOCM_DTR))},
			"TIOCM_LE":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_LE))},
			"TIOCM_RI":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_RI))},
			"TIOCM_RNG":                        {"untyped int", constant.MakeInt64(int64(q.TIOCM_RNG))},
			"TIOCM_RTS":                        {"untyped int", constant.MakeInt64(int64(q.TIOCM_RTS))},
			"TIOCM_SR":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_SR))},
			"TIOCM_ST":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_ST))},
			"TIOCNOTTY":                        {"untyped int", constant.MakeInt64(int64(q.TIOCNOTTY))},
			"TIOCNXCL":                         {"untyped int", constant.MakeInt64(int64(q.TIOCNXCL))},
			"TIOCOUTQ":                         {"untyped int", constant.MakeInt64(int64(q.TIOCOUTQ))},
			"TIOCPKT":                          {"untyped int", constant.MakeInt64(int64(q.TIOCPKT))},
			"TIOCPKT_DATA":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DATA))},
			"TIOCPKT_DOSTOP":                   {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DOSTOP))},
			"TIOCPKT_FLUSHREAD":                {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHREAD))},
			"TIOCPKT_FLUSHWRITE":               {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHWRITE))},
			"TIOCPKT_IOCTL":                    {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_IOCTL))},
			"TIOCPKT_NOSTOP":                   {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_NOSTOP))},
			"TIOCPKT_START":                    {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_START))},
			"TIOCPKT_STOP":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_STOP))},
			"TIOCSBRK":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSBRK))},
			"TIOCSCTTY":                        {"untyped int", constant.MakeInt64(int64(q.TIOCSCTTY))},
			"TIOCSERCONFIG":                    {"untyped int", constant.MakeInt64(int64(q.TIOCSERCONFIG))},
			"TIOCSERGETLSR":                    {"untyped int", constant.MakeInt64(int64(q.TIOCSERGETLSR))},
			"TIOCSERGETMULTI":                  {"untyped int", constant.MakeInt64(int64(q.TIOCSERGETMULTI))},
			"TIOCSERGSTRUCT":                   {"untyped int", constant.MakeInt64(int64(q.TIOCSERGSTRUCT))},
			"TIOCSERGWILD":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSERGWILD))},
			"TIOCSERSETMULTI":                  {"untyped int", constant.MakeInt64(int64(q.TIOCSERSETMULTI))},
			"TIOCSERSWILD":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSERSWILD))},
			"TIOCSER_TEMT":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSER_TEMT))},
			"TIOCSETD":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSETD))},
			"TIOCSIG":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSIG))},
			"TIOCSLCKTRMIOS":                   {"untyped int", constant.MakeInt64(int64(q.TIOCSLCKTRMIOS))},
			"TIOCSPGRP":                        {"untyped int", constant.MakeInt64(int64(q.TIOCSPGRP))},
			"TIOCSPTLCK":                       {"untyped int", constant.MakeInt64(int64(q.TIOCSPTLCK))},
			"TIOCSRS485":                       {"untyped int", constant.MakeInt64(int64(q.TIOCSRS485))},
			"TIOCSSERIAL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSSERIAL))},
			"TIOCSSOFTCAR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSSOFTCAR))},
			"TIOCSTI":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSTI))},
			"TIOCSWINSZ":                       {"untyped int", constant.MakeInt64(int64(q.TIOCSWINSZ))},
			"TIOCVHANGUP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCVHANGUP))},
			"TOSTOP":                           {"untyped int", constant.MakeInt64(int64(q.TOSTOP))},
			"TUNATTACHFILTER":                  {"untyped int", constant.MakeInt64(int64(q.TUNATTACHFILTER))},
			"TUNDETACHFILTER":                  {"untyped int", constant.MakeInt64(int64(q.TUNDETACHFILTER))},
			"TUNGETFEATURES":                   {"untyped int", constant.MakeInt64(int64(q.TUNGETFEATURES))},
			"TUNGETFILTER":                     {"untyped int", constant.MakeInt64(int64(q.TUNGETFILTER))},
			"TUNGETIFF":                        {"untyped int", constant.MakeInt64(int64(q.TUNGETIFF))},
			"TUNGETSNDBUF":                     {"untyped int", constant.MakeInt64(int64(q.TUNGETSNDBUF))},
			"TUNGETVNETBE":                     {"untyped int", constant.MakeInt64(int64(q.TUNGETVNETBE))},
			"TUNGETVNETHDRSZ":                  {"untyped int", constant.MakeInt64(int64(q.TUNGETVNETHDRSZ))},
			"TUNGETVNETLE":                     {"untyped int", constant.MakeInt64(int64(q.TUNGETVNETLE))},
			"TUNSETDEBUG":                      {"untyped int", constant.MakeInt64(int64(q.TUNSETDEBUG))},
			"TUNSETGROUP":                      {"untyped int", constant.MakeInt64(int64(q.TUNSETGROUP))},
			"TUNSETIFF":                        {"untyped int", constant.MakeInt64(int64(q.TUNSETIFF))},
			"TUNSETIFINDEX":                    {"untyped int", constant.MakeInt64(int64(q.TUNSETIFINDEX))},
			"TUNSETLINK":                       {"untyped int", constant.MakeInt64(int64(q.TUNSETLINK))},
			"TUNSETNOCSUM":                     {"untyped int", constant.MakeInt64(int64(q.TUNSETNOCSUM))},
			"TUNSETOFFLOAD":                    {"untyped int", constant.MakeInt64(int64(q.TUNSETOFFLOAD))},
			"TUNSETOWNER":                      {"untyped int", constant.MakeInt64(int64(q.TUNSETOWNER))},
			"TUNSETPERSIST":                    {"untyped int", constant.MakeInt64(int64(q.TUNSETPERSIST))},
			"TUNSETQUEUE":                      {"untyped int", constant.MakeInt64(int64(q.TUNSETQUEUE))},
			"TUNSETSNDBUF":                     {"untyped int", constant.MakeInt64(int64(q.TUNSETSNDBUF))},
			"TUNSETTXFILTER":                   {"untyped int", constant.MakeInt64(int64(q.TUNSETTXFILTER))},
			"TUNSETVNETBE":                     {"untyped int", constant.MakeInt64(int64(q.TUNSETVNETBE))},
			"TUNSETVNETHDRSZ":                  {"untyped int", constant.MakeInt64(int64(q.TUNSETVNETHDRSZ))},
			"TUNSETVNETLE":                     {"untyped int", constant.MakeInt64(int64(q.TUNSETVNETLE))},
			"VDISCARD":                         {"untyped int", constant.MakeInt64(int64(q.VDISCARD))},
			"VEOF":                             {"untyped int", constant.MakeInt64(int64(q.VEOF))},
			"VEOL":                             {"untyped int", constant.MakeInt64(int64(q.VEOL))},
			"VEOL2":                            {"untyped int", constant.MakeInt64(int64(q.VEOL2))},
			"VERASE":                           {"untyped int", constant.MakeInt64(int64(q.VERASE))},
			"VINTR":                            {"untyped int", constant.MakeInt64(int64(q.VINTR))},
			"VKILL":                            {"untyped int", constant.MakeInt64(int64(q.VKILL))},
			"VLNEXT":                           {"untyped int", constant.MakeInt64(int64(q.VLNEXT))},
			"VMIN":                             {"untyped int", constant.MakeInt64(int64(q.VMIN))},
			"VQUIT":                            {"untyped int", constant.MakeInt64(int64(q.VQUIT))},
			"VREPRINT":                         {"untyped int", constant.MakeInt64(int64(q.VREPRINT))},
			"VSTART":                           {"untyped int", constant.MakeInt64(int64(q.VSTART))},
			"VSTOP":                            {"untyped int", constant.MakeInt64(int64(q.VSTOP))},
			"VSUSP":                            {"untyped int", constant.MakeInt64(int64(q.VSUSP))},
			"VSWTC":                            {"untyped int", constant.MakeInt64(int64(q.VSWTC))},
			"VT0":                              {"untyped int", constant.MakeInt64(int64(q.VT0))},
			"VT1":                              {"untyped int", constant.MakeInt64(int64(q.VT1))},
			"VTDLY":                            {"untyped int", constant.MakeInt64(int64(q.VTDLY))},
			"VTIME":                            {"untyped int", constant.MakeInt64(int64(q.VTIME))},
			"VWERASE":                          {"untyped int", constant.MakeInt64(int64(q.VWERASE))},
			"WALL":                             {"untyped int", constant.MakeInt64(int64(q.WALL))},
			"WCLONE":                           {"untyped int", constant.MakeInt64(int64(q.WCLONE))},
			"WCONTINUED":                       {"untyped int", constant.MakeInt64(int64(q.WCONTINUED))},
			"WEXITED":                          {"untyped int", constant.MakeInt64(int64(q.WEXITED))},
			"WNOHANG":                          {"untyped int", constant.MakeInt64(int64(q.WNOHANG))},
			"WNOTHREAD":                        {"untyped int", constant.MakeInt64(int64(q.WNOTHREAD))},
			"WNOWAIT":                          {"untyped int", constant.MakeInt64(int64(q.WNOWAIT))},
			"WORDSIZE":                         {"untyped int", constant.MakeInt64(int64(q.WORDSIZE))},
			"WSTOPPED":                         {"untyped int", constant.MakeInt64(int64(q.WSTOPPED))},
			"WUNTRACED":                        {"untyped int", constant.MakeInt64(int64(q.WUNTRACED))},
			"XCASE":                            {"untyped int", constant.MakeInt64(int64(q.XCASE))},
		},
	})
}
