// export by github.com/goplus/igop/cmd/qexp

//go:build go1.16 && !go1.17
// +build go1.16,!go1.17

package syscall

import (
	q "syscall"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "syscall",
		Path: "syscall",
		Deps: map[string]string{
			"errors":                "errors",
			"internal/bytealg":      "bytealg",
			"internal/oserror":      "oserror",
			"internal/race":         "race",
			"internal/unsafeheader": "unsafeheader",
			"runtime":               "runtime",
			"sync":                  "sync",
			"unsafe":                "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Conn":           reflect.TypeOf((*q.Conn)(nil)).Elem(),
			"RawConn":        reflect.TypeOf((*q.RawConn)(nil)).Elem(),
			"RoutingMessage": reflect.TypeOf((*q.RoutingMessage)(nil)).Elem(),
			"Sockaddr":       reflect.TypeOf((*q.Sockaddr)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"BpfHdr":                        reflect.TypeOf((*q.BpfHdr)(nil)).Elem(),
			"BpfInsn":                       reflect.TypeOf((*q.BpfInsn)(nil)).Elem(),
			"BpfProgram":                    reflect.TypeOf((*q.BpfProgram)(nil)).Elem(),
			"BpfStat":                       reflect.TypeOf((*q.BpfStat)(nil)).Elem(),
			"BpfVersion":                    reflect.TypeOf((*q.BpfVersion)(nil)).Elem(),
			"Cmsghdr":                       reflect.TypeOf((*q.Cmsghdr)(nil)).Elem(),
			"Credential":                    reflect.TypeOf((*q.Credential)(nil)).Elem(),
			"Dirent":                        reflect.TypeOf((*q.Dirent)(nil)).Elem(),
			"Errno":                         reflect.TypeOf((*q.Errno)(nil)).Elem(),
			"Fbootstraptransfer_t":          reflect.TypeOf((*q.Fbootstraptransfer_t)(nil)).Elem(),
			"FdSet":                         reflect.TypeOf((*q.FdSet)(nil)).Elem(),
			"Flock_t":                       reflect.TypeOf((*q.Flock_t)(nil)).Elem(),
			"Fsid":                          reflect.TypeOf((*q.Fsid)(nil)).Elem(),
			"Fstore_t":                      reflect.TypeOf((*q.Fstore_t)(nil)).Elem(),
			"ICMPv6Filter":                  reflect.TypeOf((*q.ICMPv6Filter)(nil)).Elem(),
			"IPMreq":                        reflect.TypeOf((*q.IPMreq)(nil)).Elem(),
			"IPv6MTUInfo":                   reflect.TypeOf((*q.IPv6MTUInfo)(nil)).Elem(),
			"IPv6Mreq":                      reflect.TypeOf((*q.IPv6Mreq)(nil)).Elem(),
			"IfData":                        reflect.TypeOf((*q.IfData)(nil)).Elem(),
			"IfMsghdr":                      reflect.TypeOf((*q.IfMsghdr)(nil)).Elem(),
			"IfaMsghdr":                     reflect.TypeOf((*q.IfaMsghdr)(nil)).Elem(),
			"IfmaMsghdr":                    reflect.TypeOf((*q.IfmaMsghdr)(nil)).Elem(),
			"IfmaMsghdr2":                   reflect.TypeOf((*q.IfmaMsghdr2)(nil)).Elem(),
			"Inet4Pktinfo":                  reflect.TypeOf((*q.Inet4Pktinfo)(nil)).Elem(),
			"Inet6Pktinfo":                  reflect.TypeOf((*q.Inet6Pktinfo)(nil)).Elem(),
			"InterfaceAddrMessage":          reflect.TypeOf((*q.InterfaceAddrMessage)(nil)).Elem(),
			"InterfaceMessage":              reflect.TypeOf((*q.InterfaceMessage)(nil)).Elem(),
			"InterfaceMulticastAddrMessage": reflect.TypeOf((*q.InterfaceMulticastAddrMessage)(nil)).Elem(),
			"Iovec":                         reflect.TypeOf((*q.Iovec)(nil)).Elem(),
			"Kevent_t":                      reflect.TypeOf((*q.Kevent_t)(nil)).Elem(),
			"Linger":                        reflect.TypeOf((*q.Linger)(nil)).Elem(),
			"Log2phys_t":                    reflect.TypeOf((*q.Log2phys_t)(nil)).Elem(),
			"Msghdr":                        reflect.TypeOf((*q.Msghdr)(nil)).Elem(),
			"ProcAttr":                      reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"Radvisory_t":                   reflect.TypeOf((*q.Radvisory_t)(nil)).Elem(),
			"RawSockaddr":                   reflect.TypeOf((*q.RawSockaddr)(nil)).Elem(),
			"RawSockaddrAny":                reflect.TypeOf((*q.RawSockaddrAny)(nil)).Elem(),
			"RawSockaddrDatalink":           reflect.TypeOf((*q.RawSockaddrDatalink)(nil)).Elem(),
			"RawSockaddrInet4":              reflect.TypeOf((*q.RawSockaddrInet4)(nil)).Elem(),
			"RawSockaddrInet6":              reflect.TypeOf((*q.RawSockaddrInet6)(nil)).Elem(),
			"RawSockaddrUnix":               reflect.TypeOf((*q.RawSockaddrUnix)(nil)).Elem(),
			"Rlimit":                        reflect.TypeOf((*q.Rlimit)(nil)).Elem(),
			"RouteMessage":                  reflect.TypeOf((*q.RouteMessage)(nil)).Elem(),
			"RtMetrics":                     reflect.TypeOf((*q.RtMetrics)(nil)).Elem(),
			"RtMsghdr":                      reflect.TypeOf((*q.RtMsghdr)(nil)).Elem(),
			"Rusage":                        reflect.TypeOf((*q.Rusage)(nil)).Elem(),
			"Signal":                        reflect.TypeOf((*q.Signal)(nil)).Elem(),
			"SockaddrDatalink":              reflect.TypeOf((*q.SockaddrDatalink)(nil)).Elem(),
			"SockaddrInet4":                 reflect.TypeOf((*q.SockaddrInet4)(nil)).Elem(),
			"SockaddrInet6":                 reflect.TypeOf((*q.SockaddrInet6)(nil)).Elem(),
			"SockaddrUnix":                  reflect.TypeOf((*q.SockaddrUnix)(nil)).Elem(),
			"SocketControlMessage":          reflect.TypeOf((*q.SocketControlMessage)(nil)).Elem(),
			"Stat_t":                        reflect.TypeOf((*q.Stat_t)(nil)).Elem(),
			"Statfs_t":                      reflect.TypeOf((*q.Statfs_t)(nil)).Elem(),
			"SysProcAttr":                   reflect.TypeOf((*q.SysProcAttr)(nil)).Elem(),
			"Termios":                       reflect.TypeOf((*q.Termios)(nil)).Elem(),
			"Timespec":                      reflect.TypeOf((*q.Timespec)(nil)).Elem(),
			"Timeval":                       reflect.TypeOf((*q.Timeval)(nil)).Elem(),
			"Timeval32":                     reflect.TypeOf((*q.Timeval32)(nil)).Elem(),
			"WaitStatus":                    reflect.TypeOf((*q.WaitStatus)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ForkLock":          reflect.ValueOf(&q.ForkLock),
			"SocketDisableIPv6": reflect.ValueOf(&q.SocketDisableIPv6),
			"Stderr":            reflect.ValueOf(&q.Stderr),
			"Stdin":             reflect.ValueOf(&q.Stdin),
			"Stdout":            reflect.ValueOf(&q.Stdout),
		},
		Funcs: map[string]reflect.Value{
			"Accept":                    reflect.ValueOf(q.Accept),
			"Access":                    reflect.ValueOf(q.Access),
			"Adjtime":                   reflect.ValueOf(q.Adjtime),
			"Bind":                      reflect.ValueOf(q.Bind),
			"BpfBuflen":                 reflect.ValueOf(q.BpfBuflen),
			"BpfDatalink":               reflect.ValueOf(q.BpfDatalink),
			"BpfHeadercmpl":             reflect.ValueOf(q.BpfHeadercmpl),
			"BpfInterface":              reflect.ValueOf(q.BpfInterface),
			"BpfJump":                   reflect.ValueOf(q.BpfJump),
			"BpfStats":                  reflect.ValueOf(q.BpfStats),
			"BpfStmt":                   reflect.ValueOf(q.BpfStmt),
			"BpfTimeout":                reflect.ValueOf(q.BpfTimeout),
			"BytePtrFromString":         reflect.ValueOf(q.BytePtrFromString),
			"ByteSliceFromString":       reflect.ValueOf(q.ByteSliceFromString),
			"Chdir":                     reflect.ValueOf(q.Chdir),
			"CheckBpfVersion":           reflect.ValueOf(q.CheckBpfVersion),
			"Chflags":                   reflect.ValueOf(q.Chflags),
			"Chmod":                     reflect.ValueOf(q.Chmod),
			"Chown":                     reflect.ValueOf(q.Chown),
			"Chroot":                    reflect.ValueOf(q.Chroot),
			"Clearenv":                  reflect.ValueOf(q.Clearenv),
			"Close":                     reflect.ValueOf(q.Close),
			"CloseOnExec":               reflect.ValueOf(q.CloseOnExec),
			"CmsgLen":                   reflect.ValueOf(q.CmsgLen),
			"CmsgSpace":                 reflect.ValueOf(q.CmsgSpace),
			"Connect":                   reflect.ValueOf(q.Connect),
			"Dup":                       reflect.ValueOf(q.Dup),
			"Dup2":                      reflect.ValueOf(q.Dup2),
			"Environ":                   reflect.ValueOf(q.Environ),
			"Exchangedata":              reflect.ValueOf(q.Exchangedata),
			"Exec":                      reflect.ValueOf(q.Exec),
			"Exit":                      reflect.ValueOf(q.Exit),
			"Fchdir":                    reflect.ValueOf(q.Fchdir),
			"Fchflags":                  reflect.ValueOf(q.Fchflags),
			"Fchmod":                    reflect.ValueOf(q.Fchmod),
			"Fchown":                    reflect.ValueOf(q.Fchown),
			"FcntlFlock":                reflect.ValueOf(q.FcntlFlock),
			"Flock":                     reflect.ValueOf(q.Flock),
			"FlushBpf":                  reflect.ValueOf(q.FlushBpf),
			"ForkExec":                  reflect.ValueOf(q.ForkExec),
			"Fpathconf":                 reflect.ValueOf(q.Fpathconf),
			"Fstat":                     reflect.ValueOf(q.Fstat),
			"Fstatfs":                   reflect.ValueOf(q.Fstatfs),
			"Fsync":                     reflect.ValueOf(q.Fsync),
			"Ftruncate":                 reflect.ValueOf(q.Ftruncate),
			"Futimes":                   reflect.ValueOf(q.Futimes),
			"Getdirentries":             reflect.ValueOf(q.Getdirentries),
			"Getdtablesize":             reflect.ValueOf(q.Getdtablesize),
			"Getegid":                   reflect.ValueOf(q.Getegid),
			"Getenv":                    reflect.ValueOf(q.Getenv),
			"Geteuid":                   reflect.ValueOf(q.Geteuid),
			"Getfsstat":                 reflect.ValueOf(q.Getfsstat),
			"Getgid":                    reflect.ValueOf(q.Getgid),
			"Getgroups":                 reflect.ValueOf(q.Getgroups),
			"Getpagesize":               reflect.ValueOf(q.Getpagesize),
			"Getpeername":               reflect.ValueOf(q.Getpeername),
			"Getpgid":                   reflect.ValueOf(q.Getpgid),
			"Getpgrp":                   reflect.ValueOf(q.Getpgrp),
			"Getpid":                    reflect.ValueOf(q.Getpid),
			"Getppid":                   reflect.ValueOf(q.Getppid),
			"Getpriority":               reflect.ValueOf(q.Getpriority),
			"Getrlimit":                 reflect.ValueOf(q.Getrlimit),
			"Getrusage":                 reflect.ValueOf(q.Getrusage),
			"Getsid":                    reflect.ValueOf(q.Getsid),
			"Getsockname":               reflect.ValueOf(q.Getsockname),
			"GetsockoptByte":            reflect.ValueOf(q.GetsockoptByte),
			"GetsockoptICMPv6Filter":    reflect.ValueOf(q.GetsockoptICMPv6Filter),
			"GetsockoptIPMreq":          reflect.ValueOf(q.GetsockoptIPMreq),
			"GetsockoptIPv6MTUInfo":     reflect.ValueOf(q.GetsockoptIPv6MTUInfo),
			"GetsockoptIPv6Mreq":        reflect.ValueOf(q.GetsockoptIPv6Mreq),
			"GetsockoptInet4Addr":       reflect.ValueOf(q.GetsockoptInet4Addr),
			"GetsockoptInt":             reflect.ValueOf(q.GetsockoptInt),
			"Gettimeofday":              reflect.ValueOf(q.Gettimeofday),
			"Getuid":                    reflect.ValueOf(q.Getuid),
			"Getwd":                     reflect.ValueOf(q.Getwd),
			"Issetugid":                 reflect.ValueOf(q.Issetugid),
			"Kevent":                    reflect.ValueOf(q.Kevent),
			"Kill":                      reflect.ValueOf(q.Kill),
			"Kqueue":                    reflect.ValueOf(q.Kqueue),
			"Lchown":                    reflect.ValueOf(q.Lchown),
			"Link":                      reflect.ValueOf(q.Link),
			"Listen":                    reflect.ValueOf(q.Listen),
			"Lstat":                     reflect.ValueOf(q.Lstat),
			"Mkdir":                     reflect.ValueOf(q.Mkdir),
			"Mkfifo":                    reflect.ValueOf(q.Mkfifo),
			"Mknod":                     reflect.ValueOf(q.Mknod),
			"Mlock":                     reflect.ValueOf(q.Mlock),
			"Mlockall":                  reflect.ValueOf(q.Mlockall),
			"Mmap":                      reflect.ValueOf(q.Mmap),
			"Mprotect":                  reflect.ValueOf(q.Mprotect),
			"Munlock":                   reflect.ValueOf(q.Munlock),
			"Munlockall":                reflect.ValueOf(q.Munlockall),
			"Munmap":                    reflect.ValueOf(q.Munmap),
			"NsecToTimespec":            reflect.ValueOf(q.NsecToTimespec),
			"NsecToTimeval":             reflect.ValueOf(q.NsecToTimeval),
			"Open":                      reflect.ValueOf(q.Open),
			"ParseDirent":               reflect.ValueOf(q.ParseDirent),
			"ParseRoutingMessage":       reflect.ValueOf(q.ParseRoutingMessage),
			"ParseRoutingSockaddr":      reflect.ValueOf(q.ParseRoutingSockaddr),
			"ParseSocketControlMessage": reflect.ValueOf(q.ParseSocketControlMessage),
			"ParseUnixRights":           reflect.ValueOf(q.ParseUnixRights),
			"Pathconf":                  reflect.ValueOf(q.Pathconf),
			"Pipe":                      reflect.ValueOf(q.Pipe),
			"Pread":                     reflect.ValueOf(q.Pread),
			"PtraceAttach":              reflect.ValueOf(q.PtraceAttach),
			"PtraceDetach":              reflect.ValueOf(q.PtraceDetach),
			"Pwrite":                    reflect.ValueOf(q.Pwrite),
			"RawSyscall":                reflect.ValueOf(q.RawSyscall),
			"RawSyscall6":               reflect.ValueOf(q.RawSyscall6),
			"Read":                      reflect.ValueOf(q.Read),
			"ReadDirent":                reflect.ValueOf(q.ReadDirent),
			"Readlink":                  reflect.ValueOf(q.Readlink),
			"Recvfrom":                  reflect.ValueOf(q.Recvfrom),
			"Recvmsg":                   reflect.ValueOf(q.Recvmsg),
			"Rename":                    reflect.ValueOf(q.Rename),
			"Revoke":                    reflect.ValueOf(q.Revoke),
			"Rmdir":                     reflect.ValueOf(q.Rmdir),
			"RouteRIB":                  reflect.ValueOf(q.RouteRIB),
			"Seek":                      reflect.ValueOf(q.Seek),
			"Select":                    reflect.ValueOf(q.Select),
			"Sendfile":                  reflect.ValueOf(q.Sendfile),
			"Sendmsg":                   reflect.ValueOf(q.Sendmsg),
			"SendmsgN":                  reflect.ValueOf(q.SendmsgN),
			"Sendto":                    reflect.ValueOf(q.Sendto),
			"SetBpf":                    reflect.ValueOf(q.SetBpf),
			"SetBpfBuflen":              reflect.ValueOf(q.SetBpfBuflen),
			"SetBpfDatalink":            reflect.ValueOf(q.SetBpfDatalink),
			"SetBpfHeadercmpl":          reflect.ValueOf(q.SetBpfHeadercmpl),
			"SetBpfImmediate":           reflect.ValueOf(q.SetBpfImmediate),
			"SetBpfInterface":           reflect.ValueOf(q.SetBpfInterface),
			"SetBpfPromisc":             reflect.ValueOf(q.SetBpfPromisc),
			"SetBpfTimeout":             reflect.ValueOf(q.SetBpfTimeout),
			"SetKevent":                 reflect.ValueOf(q.SetKevent),
			"SetNonblock":               reflect.ValueOf(q.SetNonblock),
			"Setegid":                   reflect.ValueOf(q.Setegid),
			"Setenv":                    reflect.ValueOf(q.Setenv),
			"Seteuid":                   reflect.ValueOf(q.Seteuid),
			"Setgid":                    reflect.ValueOf(q.Setgid),
			"Setgroups":                 reflect.ValueOf(q.Setgroups),
			"Setlogin":                  reflect.ValueOf(q.Setlogin),
			"Setpgid":                   reflect.ValueOf(q.Setpgid),
			"Setpriority":               reflect.ValueOf(q.Setpriority),
			"Setprivexec":               reflect.ValueOf(q.Setprivexec),
			"Setregid":                  reflect.ValueOf(q.Setregid),
			"Setreuid":                  reflect.ValueOf(q.Setreuid),
			"Setrlimit":                 reflect.ValueOf(q.Setrlimit),
			"Setsid":                    reflect.ValueOf(q.Setsid),
			"SetsockoptByte":            reflect.ValueOf(q.SetsockoptByte),
			"SetsockoptICMPv6Filter":    reflect.ValueOf(q.SetsockoptICMPv6Filter),
			"SetsockoptIPMreq":          reflect.ValueOf(q.SetsockoptIPMreq),
			"SetsockoptIPv6Mreq":        reflect.ValueOf(q.SetsockoptIPv6Mreq),
			"SetsockoptInet4Addr":       reflect.ValueOf(q.SetsockoptInet4Addr),
			"SetsockoptInt":             reflect.ValueOf(q.SetsockoptInt),
			"SetsockoptLinger":          reflect.ValueOf(q.SetsockoptLinger),
			"SetsockoptString":          reflect.ValueOf(q.SetsockoptString),
			"SetsockoptTimeval":         reflect.ValueOf(q.SetsockoptTimeval),
			"Settimeofday":              reflect.ValueOf(q.Settimeofday),
			"Setuid":                    reflect.ValueOf(q.Setuid),
			"Shutdown":                  reflect.ValueOf(q.Shutdown),
			"SlicePtrFromStrings":       reflect.ValueOf(q.SlicePtrFromStrings),
			"Socket":                    reflect.ValueOf(q.Socket),
			"Socketpair":                reflect.ValueOf(q.Socketpair),
			"StartProcess":              reflect.ValueOf(q.StartProcess),
			"Stat":                      reflect.ValueOf(q.Stat),
			"Statfs":                    reflect.ValueOf(q.Statfs),
			"StringBytePtr":             reflect.ValueOf(q.StringBytePtr),
			"StringByteSlice":           reflect.ValueOf(q.StringByteSlice),
			"StringSlicePtr":            reflect.ValueOf(q.StringSlicePtr),
			"Symlink":                   reflect.ValueOf(q.Symlink),
			"Sync":                      reflect.ValueOf(q.Sync),
			"Syscall":                   reflect.ValueOf(q.Syscall),
			"Syscall6":                  reflect.ValueOf(q.Syscall6),
			"Syscall9":                  reflect.ValueOf(q.Syscall9),
			"Sysctl":                    reflect.ValueOf(q.Sysctl),
			"SysctlUint32":              reflect.ValueOf(q.SysctlUint32),
			"TimespecToNsec":            reflect.ValueOf(q.TimespecToNsec),
			"TimevalToNsec":             reflect.ValueOf(q.TimevalToNsec),
			"Truncate":                  reflect.ValueOf(q.Truncate),
			"Umask":                     reflect.ValueOf(q.Umask),
			"Undelete":                  reflect.ValueOf(q.Undelete),
			"UnixRights":                reflect.ValueOf(q.UnixRights),
			"Unlink":                    reflect.ValueOf(q.Unlink),
			"Unmount":                   reflect.ValueOf(q.Unmount),
			"Unsetenv":                  reflect.ValueOf(q.Unsetenv),
			"Utimes":                    reflect.ValueOf(q.Utimes),
			"UtimesNano":                reflect.ValueOf(q.UtimesNano),
			"Wait4":                     reflect.ValueOf(q.Wait4),
			"Write":                     reflect.ValueOf(q.Write),
		},
		TypedConsts: map[string]igop.TypedConst{
			"E2BIG":           {reflect.TypeOf(q.E2BIG), constant.MakeInt64(int64(q.E2BIG))},
			"EACCES":          {reflect.TypeOf(q.EACCES), constant.MakeInt64(int64(q.EACCES))},
			"EADDRINUSE":      {reflect.TypeOf(q.EADDRINUSE), constant.MakeInt64(int64(q.EADDRINUSE))},
			"EADDRNOTAVAIL":   {reflect.TypeOf(q.EADDRNOTAVAIL), constant.MakeInt64(int64(q.EADDRNOTAVAIL))},
			"EAFNOSUPPORT":    {reflect.TypeOf(q.EAFNOSUPPORT), constant.MakeInt64(int64(q.EAFNOSUPPORT))},
			"EAGAIN":          {reflect.TypeOf(q.EAGAIN), constant.MakeInt64(int64(q.EAGAIN))},
			"EALREADY":        {reflect.TypeOf(q.EALREADY), constant.MakeInt64(int64(q.EALREADY))},
			"EAUTH":           {reflect.TypeOf(q.EAUTH), constant.MakeInt64(int64(q.EAUTH))},
			"EBADARCH":        {reflect.TypeOf(q.EBADARCH), constant.MakeInt64(int64(q.EBADARCH))},
			"EBADEXEC":        {reflect.TypeOf(q.EBADEXEC), constant.MakeInt64(int64(q.EBADEXEC))},
			"EBADF":           {reflect.TypeOf(q.EBADF), constant.MakeInt64(int64(q.EBADF))},
			"EBADMACHO":       {reflect.TypeOf(q.EBADMACHO), constant.MakeInt64(int64(q.EBADMACHO))},
			"EBADMSG":         {reflect.TypeOf(q.EBADMSG), constant.MakeInt64(int64(q.EBADMSG))},
			"EBADRPC":         {reflect.TypeOf(q.EBADRPC), constant.MakeInt64(int64(q.EBADRPC))},
			"EBUSY":           {reflect.TypeOf(q.EBUSY), constant.MakeInt64(int64(q.EBUSY))},
			"ECANCELED":       {reflect.TypeOf(q.ECANCELED), constant.MakeInt64(int64(q.ECANCELED))},
			"ECHILD":          {reflect.TypeOf(q.ECHILD), constant.MakeInt64(int64(q.ECHILD))},
			"ECONNABORTED":    {reflect.TypeOf(q.ECONNABORTED), constant.MakeInt64(int64(q.ECONNABORTED))},
			"ECONNREFUSED":    {reflect.TypeOf(q.ECONNREFUSED), constant.MakeInt64(int64(q.ECONNREFUSED))},
			"ECONNRESET":      {reflect.TypeOf(q.ECONNRESET), constant.MakeInt64(int64(q.ECONNRESET))},
			"EDEADLK":         {reflect.TypeOf(q.EDEADLK), constant.MakeInt64(int64(q.EDEADLK))},
			"EDESTADDRREQ":    {reflect.TypeOf(q.EDESTADDRREQ), constant.MakeInt64(int64(q.EDESTADDRREQ))},
			"EDEVERR":         {reflect.TypeOf(q.EDEVERR), constant.MakeInt64(int64(q.EDEVERR))},
			"EDOM":            {reflect.TypeOf(q.EDOM), constant.MakeInt64(int64(q.EDOM))},
			"EDQUOT":          {reflect.TypeOf(q.EDQUOT), constant.MakeInt64(int64(q.EDQUOT))},
			"EEXIST":          {reflect.TypeOf(q.EEXIST), constant.MakeInt64(int64(q.EEXIST))},
			"EFAULT":          {reflect.TypeOf(q.EFAULT), constant.MakeInt64(int64(q.EFAULT))},
			"EFBIG":           {reflect.TypeOf(q.EFBIG), constant.MakeInt64(int64(q.EFBIG))},
			"EFTYPE":          {reflect.TypeOf(q.EFTYPE), constant.MakeInt64(int64(q.EFTYPE))},
			"EHOSTDOWN":       {reflect.TypeOf(q.EHOSTDOWN), constant.MakeInt64(int64(q.EHOSTDOWN))},
			"EHOSTUNREACH":    {reflect.TypeOf(q.EHOSTUNREACH), constant.MakeInt64(int64(q.EHOSTUNREACH))},
			"EIDRM":           {reflect.TypeOf(q.EIDRM), constant.MakeInt64(int64(q.EIDRM))},
			"EILSEQ":          {reflect.TypeOf(q.EILSEQ), constant.MakeInt64(int64(q.EILSEQ))},
			"EINPROGRESS":     {reflect.TypeOf(q.EINPROGRESS), constant.MakeInt64(int64(q.EINPROGRESS))},
			"EINTR":           {reflect.TypeOf(q.EINTR), constant.MakeInt64(int64(q.EINTR))},
			"EINVAL":          {reflect.TypeOf(q.EINVAL), constant.MakeInt64(int64(q.EINVAL))},
			"EIO":             {reflect.TypeOf(q.EIO), constant.MakeInt64(int64(q.EIO))},
			"EISCONN":         {reflect.TypeOf(q.EISCONN), constant.MakeInt64(int64(q.EISCONN))},
			"EISDIR":          {reflect.TypeOf(q.EISDIR), constant.MakeInt64(int64(q.EISDIR))},
			"ELAST":           {reflect.TypeOf(q.ELAST), constant.MakeInt64(int64(q.ELAST))},
			"ELOOP":           {reflect.TypeOf(q.ELOOP), constant.MakeInt64(int64(q.ELOOP))},
			"EMFILE":          {reflect.TypeOf(q.EMFILE), constant.MakeInt64(int64(q.EMFILE))},
			"EMLINK":          {reflect.TypeOf(q.EMLINK), constant.MakeInt64(int64(q.EMLINK))},
			"EMSGSIZE":        {reflect.TypeOf(q.EMSGSIZE), constant.MakeInt64(int64(q.EMSGSIZE))},
			"EMULTIHOP":       {reflect.TypeOf(q.EMULTIHOP), constant.MakeInt64(int64(q.EMULTIHOP))},
			"ENAMETOOLONG":    {reflect.TypeOf(q.ENAMETOOLONG), constant.MakeInt64(int64(q.ENAMETOOLONG))},
			"ENEEDAUTH":       {reflect.TypeOf(q.ENEEDAUTH), constant.MakeInt64(int64(q.ENEEDAUTH))},
			"ENETDOWN":        {reflect.TypeOf(q.ENETDOWN), constant.MakeInt64(int64(q.ENETDOWN))},
			"ENETRESET":       {reflect.TypeOf(q.ENETRESET), constant.MakeInt64(int64(q.ENETRESET))},
			"ENETUNREACH":     {reflect.TypeOf(q.ENETUNREACH), constant.MakeInt64(int64(q.ENETUNREACH))},
			"ENFILE":          {reflect.TypeOf(q.ENFILE), constant.MakeInt64(int64(q.ENFILE))},
			"ENOATTR":         {reflect.TypeOf(q.ENOATTR), constant.MakeInt64(int64(q.ENOATTR))},
			"ENOBUFS":         {reflect.TypeOf(q.ENOBUFS), constant.MakeInt64(int64(q.ENOBUFS))},
			"ENODATA":         {reflect.TypeOf(q.ENODATA), constant.MakeInt64(int64(q.ENODATA))},
			"ENODEV":          {reflect.TypeOf(q.ENODEV), constant.MakeInt64(int64(q.ENODEV))},
			"ENOENT":          {reflect.TypeOf(q.ENOENT), constant.MakeInt64(int64(q.ENOENT))},
			"ENOEXEC":         {reflect.TypeOf(q.ENOEXEC), constant.MakeInt64(int64(q.ENOEXEC))},
			"ENOLCK":          {reflect.TypeOf(q.ENOLCK), constant.MakeInt64(int64(q.ENOLCK))},
			"ENOLINK":         {reflect.TypeOf(q.ENOLINK), constant.MakeInt64(int64(q.ENOLINK))},
			"ENOMEM":          {reflect.TypeOf(q.ENOMEM), constant.MakeInt64(int64(q.ENOMEM))},
			"ENOMSG":          {reflect.TypeOf(q.ENOMSG), constant.MakeInt64(int64(q.ENOMSG))},
			"ENOPOLICY":       {reflect.TypeOf(q.ENOPOLICY), constant.MakeInt64(int64(q.ENOPOLICY))},
			"ENOPROTOOPT":     {reflect.TypeOf(q.ENOPROTOOPT), constant.MakeInt64(int64(q.ENOPROTOOPT))},
			"ENOSPC":          {reflect.TypeOf(q.ENOSPC), constant.MakeInt64(int64(q.ENOSPC))},
			"ENOSR":           {reflect.TypeOf(q.ENOSR), constant.MakeInt64(int64(q.ENOSR))},
			"ENOSTR":          {reflect.TypeOf(q.ENOSTR), constant.MakeInt64(int64(q.ENOSTR))},
			"ENOSYS":          {reflect.TypeOf(q.ENOSYS), constant.MakeInt64(int64(q.ENOSYS))},
			"ENOTBLK":         {reflect.TypeOf(q.ENOTBLK), constant.MakeInt64(int64(q.ENOTBLK))},
			"ENOTCONN":        {reflect.TypeOf(q.ENOTCONN), constant.MakeInt64(int64(q.ENOTCONN))},
			"ENOTDIR":         {reflect.TypeOf(q.ENOTDIR), constant.MakeInt64(int64(q.ENOTDIR))},
			"ENOTEMPTY":       {reflect.TypeOf(q.ENOTEMPTY), constant.MakeInt64(int64(q.ENOTEMPTY))},
			"ENOTRECOVERABLE": {reflect.TypeOf(q.ENOTRECOVERABLE), constant.MakeInt64(int64(q.ENOTRECOVERABLE))},
			"ENOTSOCK":        {reflect.TypeOf(q.ENOTSOCK), constant.MakeInt64(int64(q.ENOTSOCK))},
			"ENOTSUP":         {reflect.TypeOf(q.ENOTSUP), constant.MakeInt64(int64(q.ENOTSUP))},
			"ENOTTY":          {reflect.TypeOf(q.ENOTTY), constant.MakeInt64(int64(q.ENOTTY))},
			"ENXIO":           {reflect.TypeOf(q.ENXIO), constant.MakeInt64(int64(q.ENXIO))},
			"EOPNOTSUPP":      {reflect.TypeOf(q.EOPNOTSUPP), constant.MakeInt64(int64(q.EOPNOTSUPP))},
			"EOVERFLOW":       {reflect.TypeOf(q.EOVERFLOW), constant.MakeInt64(int64(q.EOVERFLOW))},
			"EOWNERDEAD":      {reflect.TypeOf(q.EOWNERDEAD), constant.MakeInt64(int64(q.EOWNERDEAD))},
			"EPERM":           {reflect.TypeOf(q.EPERM), constant.MakeInt64(int64(q.EPERM))},
			"EPFNOSUPPORT":    {reflect.TypeOf(q.EPFNOSUPPORT), constant.MakeInt64(int64(q.EPFNOSUPPORT))},
			"EPIPE":           {reflect.TypeOf(q.EPIPE), constant.MakeInt64(int64(q.EPIPE))},
			"EPROCLIM":        {reflect.TypeOf(q.EPROCLIM), constant.MakeInt64(int64(q.EPROCLIM))},
			"EPROCUNAVAIL":    {reflect.TypeOf(q.EPROCUNAVAIL), constant.MakeInt64(int64(q.EPROCUNAVAIL))},
			"EPROGMISMATCH":   {reflect.TypeOf(q.EPROGMISMATCH), constant.MakeInt64(int64(q.EPROGMISMATCH))},
			"EPROGUNAVAIL":    {reflect.TypeOf(q.EPROGUNAVAIL), constant.MakeInt64(int64(q.EPROGUNAVAIL))},
			"EPROTO":          {reflect.TypeOf(q.EPROTO), constant.MakeInt64(int64(q.EPROTO))},
			"EPROTONOSUPPORT": {reflect.TypeOf(q.EPROTONOSUPPORT), constant.MakeInt64(int64(q.EPROTONOSUPPORT))},
			"EPROTOTYPE":      {reflect.TypeOf(q.EPROTOTYPE), constant.MakeInt64(int64(q.EPROTOTYPE))},
			"EPWROFF":         {reflect.TypeOf(q.EPWROFF), constant.MakeInt64(int64(q.EPWROFF))},
			"ERANGE":          {reflect.TypeOf(q.ERANGE), constant.MakeInt64(int64(q.ERANGE))},
			"EREMOTE":         {reflect.TypeOf(q.EREMOTE), constant.MakeInt64(int64(q.EREMOTE))},
			"EROFS":           {reflect.TypeOf(q.EROFS), constant.MakeInt64(int64(q.EROFS))},
			"ERPCMISMATCH":    {reflect.TypeOf(q.ERPCMISMATCH), constant.MakeInt64(int64(q.ERPCMISMATCH))},
			"ESHLIBVERS":      {reflect.TypeOf(q.ESHLIBVERS), constant.MakeInt64(int64(q.ESHLIBVERS))},
			"ESHUTDOWN":       {reflect.TypeOf(q.ESHUTDOWN), constant.MakeInt64(int64(q.ESHUTDOWN))},
			"ESOCKTNOSUPPORT": {reflect.TypeOf(q.ESOCKTNOSUPPORT), constant.MakeInt64(int64(q.ESOCKTNOSUPPORT))},
			"ESPIPE":          {reflect.TypeOf(q.ESPIPE), constant.MakeInt64(int64(q.ESPIPE))},
			"ESRCH":           {reflect.TypeOf(q.ESRCH), constant.MakeInt64(int64(q.ESRCH))},
			"ESTALE":          {reflect.TypeOf(q.ESTALE), constant.MakeInt64(int64(q.ESTALE))},
			"ETIME":           {reflect.TypeOf(q.ETIME), constant.MakeInt64(int64(q.ETIME))},
			"ETIMEDOUT":       {reflect.TypeOf(q.ETIMEDOUT), constant.MakeInt64(int64(q.ETIMEDOUT))},
			"ETOOMANYREFS":    {reflect.TypeOf(q.ETOOMANYREFS), constant.MakeInt64(int64(q.ETOOMANYREFS))},
			"ETXTBSY":         {reflect.TypeOf(q.ETXTBSY), constant.MakeInt64(int64(q.ETXTBSY))},
			"EUSERS":          {reflect.TypeOf(q.EUSERS), constant.MakeInt64(int64(q.EUSERS))},
			"EWOULDBLOCK":     {reflect.TypeOf(q.EWOULDBLOCK), constant.MakeInt64(int64(q.EWOULDBLOCK))},
			"EXDEV":           {reflect.TypeOf(q.EXDEV), constant.MakeInt64(int64(q.EXDEV))},
			"SIGABRT":         {reflect.TypeOf(q.SIGABRT), constant.MakeInt64(int64(q.SIGABRT))},
			"SIGALRM":         {reflect.TypeOf(q.SIGALRM), constant.MakeInt64(int64(q.SIGALRM))},
			"SIGBUS":          {reflect.TypeOf(q.SIGBUS), constant.MakeInt64(int64(q.SIGBUS))},
			"SIGCHLD":         {reflect.TypeOf(q.SIGCHLD), constant.MakeInt64(int64(q.SIGCHLD))},
			"SIGCONT":         {reflect.TypeOf(q.SIGCONT), constant.MakeInt64(int64(q.SIGCONT))},
			"SIGEMT":          {reflect.TypeOf(q.SIGEMT), constant.MakeInt64(int64(q.SIGEMT))},
			"SIGFPE":          {reflect.TypeOf(q.SIGFPE), constant.MakeInt64(int64(q.SIGFPE))},
			"SIGHUP":          {reflect.TypeOf(q.SIGHUP), constant.MakeInt64(int64(q.SIGHUP))},
			"SIGILL":          {reflect.TypeOf(q.SIGILL), constant.MakeInt64(int64(q.SIGILL))},
			"SIGINFO":         {reflect.TypeOf(q.SIGINFO), constant.MakeInt64(int64(q.SIGINFO))},
			"SIGINT":          {reflect.TypeOf(q.SIGINT), constant.MakeInt64(int64(q.SIGINT))},
			"SIGIO":           {reflect.TypeOf(q.SIGIO), constant.MakeInt64(int64(q.SIGIO))},
			"SIGIOT":          {reflect.TypeOf(q.SIGIOT), constant.MakeInt64(int64(q.SIGIOT))},
			"SIGKILL":         {reflect.TypeOf(q.SIGKILL), constant.MakeInt64(int64(q.SIGKILL))},
			"SIGPIPE":         {reflect.TypeOf(q.SIGPIPE), constant.MakeInt64(int64(q.SIGPIPE))},
			"SIGPROF":         {reflect.TypeOf(q.SIGPROF), constant.MakeInt64(int64(q.SIGPROF))},
			"SIGQUIT":         {reflect.TypeOf(q.SIGQUIT), constant.MakeInt64(int64(q.SIGQUIT))},
			"SIGSEGV":         {reflect.TypeOf(q.SIGSEGV), constant.MakeInt64(int64(q.SIGSEGV))},
			"SIGSTOP":         {reflect.TypeOf(q.SIGSTOP), constant.MakeInt64(int64(q.SIGSTOP))},
			"SIGSYS":          {reflect.TypeOf(q.SIGSYS), constant.MakeInt64(int64(q.SIGSYS))},
			"SIGTERM":         {reflect.TypeOf(q.SIGTERM), constant.MakeInt64(int64(q.SIGTERM))},
			"SIGTRAP":         {reflect.TypeOf(q.SIGTRAP), constant.MakeInt64(int64(q.SIGTRAP))},
			"SIGTSTP":         {reflect.TypeOf(q.SIGTSTP), constant.MakeInt64(int64(q.SIGTSTP))},
			"SIGTTIN":         {reflect.TypeOf(q.SIGTTIN), constant.MakeInt64(int64(q.SIGTTIN))},
			"SIGTTOU":         {reflect.TypeOf(q.SIGTTOU), constant.MakeInt64(int64(q.SIGTTOU))},
			"SIGURG":          {reflect.TypeOf(q.SIGURG), constant.MakeInt64(int64(q.SIGURG))},
			"SIGUSR1":         {reflect.TypeOf(q.SIGUSR1), constant.MakeInt64(int64(q.SIGUSR1))},
			"SIGUSR2":         {reflect.TypeOf(q.SIGUSR2), constant.MakeInt64(int64(q.SIGUSR2))},
			"SIGVTALRM":       {reflect.TypeOf(q.SIGVTALRM), constant.MakeInt64(int64(q.SIGVTALRM))},
			"SIGWINCH":        {reflect.TypeOf(q.SIGWINCH), constant.MakeInt64(int64(q.SIGWINCH))},
			"SIGXCPU":         {reflect.TypeOf(q.SIGXCPU), constant.MakeInt64(int64(q.SIGXCPU))},
			"SIGXFSZ":         {reflect.TypeOf(q.SIGXFSZ), constant.MakeInt64(int64(q.SIGXFSZ))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"AF_APPLETALK":                       {"untyped int", constant.MakeInt64(int64(q.AF_APPLETALK))},
			"AF_CCITT":                           {"untyped int", constant.MakeInt64(int64(q.AF_CCITT))},
			"AF_CHAOS":                           {"untyped int", constant.MakeInt64(int64(q.AF_CHAOS))},
			"AF_CNT":                             {"untyped int", constant.MakeInt64(int64(q.AF_CNT))},
			"AF_COIP":                            {"untyped int", constant.MakeInt64(int64(q.AF_COIP))},
			"AF_DATAKIT":                         {"untyped int", constant.MakeInt64(int64(q.AF_DATAKIT))},
			"AF_DECnet":                          {"untyped int", constant.MakeInt64(int64(q.AF_DECnet))},
			"AF_DLI":                             {"untyped int", constant.MakeInt64(int64(q.AF_DLI))},
			"AF_E164":                            {"untyped int", constant.MakeInt64(int64(q.AF_E164))},
			"AF_ECMA":                            {"untyped int", constant.MakeInt64(int64(q.AF_ECMA))},
			"AF_HYLINK":                          {"untyped int", constant.MakeInt64(int64(q.AF_HYLINK))},
			"AF_IEEE80211":                       {"untyped int", constant.MakeInt64(int64(q.AF_IEEE80211))},
			"AF_IMPLINK":                         {"untyped int", constant.MakeInt64(int64(q.AF_IMPLINK))},
			"AF_INET":                            {"untyped int", constant.MakeInt64(int64(q.AF_INET))},
			"AF_INET6":                           {"untyped int", constant.MakeInt64(int64(q.AF_INET6))},
			"AF_IPX":                             {"untyped int", constant.MakeInt64(int64(q.AF_IPX))},
			"AF_ISDN":                            {"untyped int", constant.MakeInt64(int64(q.AF_ISDN))},
			"AF_ISO":                             {"untyped int", constant.MakeInt64(int64(q.AF_ISO))},
			"AF_LAT":                             {"untyped int", constant.MakeInt64(int64(q.AF_LAT))},
			"AF_LINK":                            {"untyped int", constant.MakeInt64(int64(q.AF_LINK))},
			"AF_LOCAL":                           {"untyped int", constant.MakeInt64(int64(q.AF_LOCAL))},
			"AF_MAX":                             {"untyped int", constant.MakeInt64(int64(q.AF_MAX))},
			"AF_NATM":                            {"untyped int", constant.MakeInt64(int64(q.AF_NATM))},
			"AF_NDRV":                            {"untyped int", constant.MakeInt64(int64(q.AF_NDRV))},
			"AF_NETBIOS":                         {"untyped int", constant.MakeInt64(int64(q.AF_NETBIOS))},
			"AF_NS":                              {"untyped int", constant.MakeInt64(int64(q.AF_NS))},
			"AF_OSI":                             {"untyped int", constant.MakeInt64(int64(q.AF_OSI))},
			"AF_PPP":                             {"untyped int", constant.MakeInt64(int64(q.AF_PPP))},
			"AF_PUP":                             {"untyped int", constant.MakeInt64(int64(q.AF_PUP))},
			"AF_RESERVED_36":                     {"untyped int", constant.MakeInt64(int64(q.AF_RESERVED_36))},
			"AF_ROUTE":                           {"untyped int", constant.MakeInt64(int64(q.AF_ROUTE))},
			"AF_SIP":                             {"untyped int", constant.MakeInt64(int64(q.AF_SIP))},
			"AF_SNA":                             {"untyped int", constant.MakeInt64(int64(q.AF_SNA))},
			"AF_SYSTEM":                          {"untyped int", constant.MakeInt64(int64(q.AF_SYSTEM))},
			"AF_UNIX":                            {"untyped int", constant.MakeInt64(int64(q.AF_UNIX))},
			"AF_UNSPEC":                          {"untyped int", constant.MakeInt64(int64(q.AF_UNSPEC))},
			"B0":                                 {"untyped int", constant.MakeInt64(int64(q.B0))},
			"B110":                               {"untyped int", constant.MakeInt64(int64(q.B110))},
			"B115200":                            {"untyped int", constant.MakeInt64(int64(q.B115200))},
			"B1200":                              {"untyped int", constant.MakeInt64(int64(q.B1200))},
			"B134":                               {"untyped int", constant.MakeInt64(int64(q.B134))},
			"B14400":                             {"untyped int", constant.MakeInt64(int64(q.B14400))},
			"B150":                               {"untyped int", constant.MakeInt64(int64(q.B150))},
			"B1800":                              {"untyped int", constant.MakeInt64(int64(q.B1800))},
			"B19200":                             {"untyped int", constant.MakeInt64(int64(q.B19200))},
			"B200":                               {"untyped int", constant.MakeInt64(int64(q.B200))},
			"B230400":                            {"untyped int", constant.MakeInt64(int64(q.B230400))},
			"B2400":                              {"untyped int", constant.MakeInt64(int64(q.B2400))},
			"B28800":                             {"untyped int", constant.MakeInt64(int64(q.B28800))},
			"B300":                               {"untyped int", constant.MakeInt64(int64(q.B300))},
			"B38400":                             {"untyped int", constant.MakeInt64(int64(q.B38400))},
			"B4800":                              {"untyped int", constant.MakeInt64(int64(q.B4800))},
			"B50":                                {"untyped int", constant.MakeInt64(int64(q.B50))},
			"B57600":                             {"untyped int", constant.MakeInt64(int64(q.B57600))},
			"B600":                               {"untyped int", constant.MakeInt64(int64(q.B600))},
			"B7200":                              {"untyped int", constant.MakeInt64(int64(q.B7200))},
			"B75":                                {"untyped int", constant.MakeInt64(int64(q.B75))},
			"B76800":                             {"untyped int", constant.MakeInt64(int64(q.B76800))},
			"B9600":                              {"untyped int", constant.MakeInt64(int64(q.B9600))},
			"BIOCFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.BIOCFLUSH))},
			"BIOCGBLEN":                          {"untyped int", constant.MakeInt64(int64(q.BIOCGBLEN))},
			"BIOCGDLT":                           {"untyped int", constant.MakeInt64(int64(q.BIOCGDLT))},
			"BIOCGDLTLIST":                       {"untyped int", constant.MakeInt64(int64(q.BIOCGDLTLIST))},
			"BIOCGETIF":                          {"untyped int", constant.MakeInt64(int64(q.BIOCGETIF))},
			"BIOCGHDRCMPLT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGHDRCMPLT))},
			"BIOCGRSIG":                          {"untyped int", constant.MakeInt64(int64(q.BIOCGRSIG))},
			"BIOCGRTIMEOUT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGRTIMEOUT))},
			"BIOCGSEESENT":                       {"untyped int", constant.MakeInt64(int64(q.BIOCGSEESENT))},
			"BIOCGSTATS":                         {"untyped int", constant.MakeInt64(int64(q.BIOCGSTATS))},
			"BIOCIMMEDIATE":                      {"untyped int", constant.MakeInt64(int64(q.BIOCIMMEDIATE))},
			"BIOCPROMISC":                        {"untyped int", constant.MakeInt64(int64(q.BIOCPROMISC))},
			"BIOCSBLEN":                          {"untyped int", constant.MakeInt64(int64(q.BIOCSBLEN))},
			"BIOCSDLT":                           {"untyped int", constant.MakeInt64(int64(q.BIOCSDLT))},
			"BIOCSETF":                           {"untyped int", constant.MakeInt64(int64(q.BIOCSETF))},
			"BIOCSETIF":                          {"untyped int", constant.MakeInt64(int64(q.BIOCSETIF))},
			"BIOCSHDRCMPLT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCSHDRCMPLT))},
			"BIOCSRSIG":                          {"untyped int", constant.MakeInt64(int64(q.BIOCSRSIG))},
			"BIOCSRTIMEOUT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCSRTIMEOUT))},
			"BIOCSSEESENT":                       {"untyped int", constant.MakeInt64(int64(q.BIOCSSEESENT))},
			"BIOCVERSION":                        {"untyped int", constant.MakeInt64(int64(q.BIOCVERSION))},
			"BPF_A":                              {"untyped int", constant.MakeInt64(int64(q.BPF_A))},
			"BPF_ABS":                            {"untyped int", constant.MakeInt64(int64(q.BPF_ABS))},
			"BPF_ADD":                            {"untyped int", constant.MakeInt64(int64(q.BPF_ADD))},
			"BPF_ALIGNMENT":                      {"untyped int", constant.MakeInt64(int64(q.BPF_ALIGNMENT))},
			"BPF_ALU":                            {"untyped int", constant.MakeInt64(int64(q.BPF_ALU))},
			"BPF_AND":                            {"untyped int", constant.MakeInt64(int64(q.BPF_AND))},
			"BPF_B":                              {"untyped int", constant.MakeInt64(int64(q.BPF_B))},
			"BPF_DIV":                            {"untyped int", constant.MakeInt64(int64(q.BPF_DIV))},
			"BPF_H":                              {"untyped int", constant.MakeInt64(int64(q.BPF_H))},
			"BPF_IMM":                            {"untyped int", constant.MakeInt64(int64(q.BPF_IMM))},
			"BPF_IND":                            {"untyped int", constant.MakeInt64(int64(q.BPF_IND))},
			"BPF_JA":                             {"untyped int", constant.MakeInt64(int64(q.BPF_JA))},
			"BPF_JEQ":                            {"untyped int", constant.MakeInt64(int64(q.BPF_JEQ))},
			"BPF_JGE":                            {"untyped int", constant.MakeInt64(int64(q.BPF_JGE))},
			"BPF_JGT":                            {"untyped int", constant.MakeInt64(int64(q.BPF_JGT))},
			"BPF_JMP":                            {"untyped int", constant.MakeInt64(int64(q.BPF_JMP))},
			"BPF_JSET":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JSET))},
			"BPF_K":                              {"untyped int", constant.MakeInt64(int64(q.BPF_K))},
			"BPF_LD":                             {"untyped int", constant.MakeInt64(int64(q.BPF_LD))},
			"BPF_LDX":                            {"untyped int", constant.MakeInt64(int64(q.BPF_LDX))},
			"BPF_LEN":                            {"untyped int", constant.MakeInt64(int64(q.BPF_LEN))},
			"BPF_LSH":                            {"untyped int", constant.MakeInt64(int64(q.BPF_LSH))},
			"BPF_MAJOR_VERSION":                  {"untyped int", constant.MakeInt64(int64(q.BPF_MAJOR_VERSION))},
			"BPF_MAXBUFSIZE":                     {"untyped int", constant.MakeInt64(int64(q.BPF_MAXBUFSIZE))},
			"BPF_MAXINSNS":                       {"untyped int", constant.MakeInt64(int64(q.BPF_MAXINSNS))},
			"BPF_MEM":                            {"untyped int", constant.MakeInt64(int64(q.BPF_MEM))},
			"BPF_MEMWORDS":                       {"untyped int", constant.MakeInt64(int64(q.BPF_MEMWORDS))},
			"BPF_MINBUFSIZE":                     {"untyped int", constant.MakeInt64(int64(q.BPF_MINBUFSIZE))},
			"BPF_MINOR_VERSION":                  {"untyped int", constant.MakeInt64(int64(q.BPF_MINOR_VERSION))},
			"BPF_MISC":                           {"untyped int", constant.MakeInt64(int64(q.BPF_MISC))},
			"BPF_MSH":                            {"untyped int", constant.MakeInt64(int64(q.BPF_MSH))},
			"BPF_MUL":                            {"untyped int", constant.MakeInt64(int64(q.BPF_MUL))},
			"BPF_NEG":                            {"untyped int", constant.MakeInt64(int64(q.BPF_NEG))},
			"BPF_OR":                             {"untyped int", constant.MakeInt64(int64(q.BPF_OR))},
			"BPF_RELEASE":                        {"untyped int", constant.MakeInt64(int64(q.BPF_RELEASE))},
			"BPF_RET":                            {"untyped int", constant.MakeInt64(int64(q.BPF_RET))},
			"BPF_RSH":                            {"untyped int", constant.MakeInt64(int64(q.BPF_RSH))},
			"BPF_ST":                             {"untyped int", constant.MakeInt64(int64(q.BPF_ST))},
			"BPF_STX":                            {"untyped int", constant.MakeInt64(int64(q.BPF_STX))},
			"BPF_SUB":                            {"untyped int", constant.MakeInt64(int64(q.BPF_SUB))},
			"BPF_TAX":                            {"untyped int", constant.MakeInt64(int64(q.BPF_TAX))},
			"BPF_TXA":                            {"untyped int", constant.MakeInt64(int64(q.BPF_TXA))},
			"BPF_W":                              {"untyped int", constant.MakeInt64(int64(q.BPF_W))},
			"BPF_X":                              {"untyped int", constant.MakeInt64(int64(q.BPF_X))},
			"BRKINT":                             {"untyped int", constant.MakeInt64(int64(q.BRKINT))},
			"CFLUSH":                             {"untyped int", constant.MakeInt64(int64(q.CFLUSH))},
			"CLOCAL":                             {"untyped int", constant.MakeInt64(int64(q.CLOCAL))},
			"CREAD":                              {"untyped int", constant.MakeInt64(int64(q.CREAD))},
			"CS5":                                {"untyped int", constant.MakeInt64(int64(q.CS5))},
			"CS6":                                {"untyped int", constant.MakeInt64(int64(q.CS6))},
			"CS7":                                {"untyped int", constant.MakeInt64(int64(q.CS7))},
			"CS8":                                {"untyped int", constant.MakeInt64(int64(q.CS8))},
			"CSIZE":                              {"untyped int", constant.MakeInt64(int64(q.CSIZE))},
			"CSTART":                             {"untyped int", constant.MakeInt64(int64(q.CSTART))},
			"CSTATUS":                            {"untyped int", constant.MakeInt64(int64(q.CSTATUS))},
			"CSTOP":                              {"untyped int", constant.MakeInt64(int64(q.CSTOP))},
			"CSTOPB":                             {"untyped int", constant.MakeInt64(int64(q.CSTOPB))},
			"CSUSP":                              {"untyped int", constant.MakeInt64(int64(q.CSUSP))},
			"CTL_MAXNAME":                        {"untyped int", constant.MakeInt64(int64(q.CTL_MAXNAME))},
			"CTL_NET":                            {"untyped int", constant.MakeInt64(int64(q.CTL_NET))},
			"DLT_APPLE_IP_OVER_IEEE1394":         {"untyped int", constant.MakeInt64(int64(q.DLT_APPLE_IP_OVER_IEEE1394))},
			"DLT_ARCNET":                         {"untyped int", constant.MakeInt64(int64(q.DLT_ARCNET))},
			"DLT_ATM_CLIP":                       {"untyped int", constant.MakeInt64(int64(q.DLT_ATM_CLIP))},
			"DLT_ATM_RFC1483":                    {"untyped int", constant.MakeInt64(int64(q.DLT_ATM_RFC1483))},
			"DLT_AX25":                           {"untyped int", constant.MakeInt64(int64(q.DLT_AX25))},
			"DLT_CHAOS":                          {"untyped int", constant.MakeInt64(int64(q.DLT_CHAOS))},
			"DLT_CHDLC":                          {"untyped int", constant.MakeInt64(int64(q.DLT_CHDLC))},
			"DLT_C_HDLC":                         {"untyped int", constant.MakeInt64(int64(q.DLT_C_HDLC))},
			"DLT_EN10MB":                         {"untyped int", constant.MakeInt64(int64(q.DLT_EN10MB))},
			"DLT_EN3MB":                          {"untyped int", constant.MakeInt64(int64(q.DLT_EN3MB))},
			"DLT_FDDI":                           {"untyped int", constant.MakeInt64(int64(q.DLT_FDDI))},
			"DLT_IEEE802":                        {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802))},
			"DLT_IEEE802_11":                     {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11))},
			"DLT_IEEE802_11_RADIO":               {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11_RADIO))},
			"DLT_IEEE802_11_RADIO_AVS":           {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11_RADIO_AVS))},
			"DLT_LINUX_SLL":                      {"untyped int", constant.MakeInt64(int64(q.DLT_LINUX_SLL))},
			"DLT_LOOP":                           {"untyped int", constant.MakeInt64(int64(q.DLT_LOOP))},
			"DLT_NULL":                           {"untyped int", constant.MakeInt64(int64(q.DLT_NULL))},
			"DLT_PFLOG":                          {"untyped int", constant.MakeInt64(int64(q.DLT_PFLOG))},
			"DLT_PFSYNC":                         {"untyped int", constant.MakeInt64(int64(q.DLT_PFSYNC))},
			"DLT_PPP":                            {"untyped int", constant.MakeInt64(int64(q.DLT_PPP))},
			"DLT_PPP_BSDOS":                      {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_BSDOS))},
			"DLT_PPP_SERIAL":                     {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_SERIAL))},
			"DLT_PRONET":                         {"untyped int", constant.MakeInt64(int64(q.DLT_PRONET))},
			"DLT_RAW":                            {"untyped int", constant.MakeInt64(int64(q.DLT_RAW))},
			"DLT_SLIP":                           {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP))},
			"DLT_SLIP_BSDOS":                     {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP_BSDOS))},
			"DT_BLK":                             {"untyped int", constant.MakeInt64(int64(q.DT_BLK))},
			"DT_CHR":                             {"untyped int", constant.MakeInt64(int64(q.DT_CHR))},
			"DT_DIR":                             {"untyped int", constant.MakeInt64(int64(q.DT_DIR))},
			"DT_FIFO":                            {"untyped int", constant.MakeInt64(int64(q.DT_FIFO))},
			"DT_LNK":                             {"untyped int", constant.MakeInt64(int64(q.DT_LNK))},
			"DT_REG":                             {"untyped int", constant.MakeInt64(int64(q.DT_REG))},
			"DT_SOCK":                            {"untyped int", constant.MakeInt64(int64(q.DT_SOCK))},
			"DT_UNKNOWN":                         {"untyped int", constant.MakeInt64(int64(q.DT_UNKNOWN))},
			"DT_WHT":                             {"untyped int", constant.MakeInt64(int64(q.DT_WHT))},
			"ECHO":                               {"untyped int", constant.MakeInt64(int64(q.ECHO))},
			"ECHOCTL":                            {"untyped int", constant.MakeInt64(int64(q.ECHOCTL))},
			"ECHOE":                              {"untyped int", constant.MakeInt64(int64(q.ECHOE))},
			"ECHOK":                              {"untyped int", constant.MakeInt64(int64(q.ECHOK))},
			"ECHOKE":                             {"untyped int", constant.MakeInt64(int64(q.ECHOKE))},
			"ECHONL":                             {"untyped int", constant.MakeInt64(int64(q.ECHONL))},
			"ECHOPRT":                            {"untyped int", constant.MakeInt64(int64(q.ECHOPRT))},
			"EVFILT_AIO":                         {"untyped int", constant.MakeInt64(int64(q.EVFILT_AIO))},
			"EVFILT_FS":                          {"untyped int", constant.MakeInt64(int64(q.EVFILT_FS))},
			"EVFILT_MACHPORT":                    {"untyped int", constant.MakeInt64(int64(q.EVFILT_MACHPORT))},
			"EVFILT_PROC":                        {"untyped int", constant.MakeInt64(int64(q.EVFILT_PROC))},
			"EVFILT_READ":                        {"untyped int", constant.MakeInt64(int64(q.EVFILT_READ))},
			"EVFILT_SIGNAL":                      {"untyped int", constant.MakeInt64(int64(q.EVFILT_SIGNAL))},
			"EVFILT_SYSCOUNT":                    {"untyped int", constant.MakeInt64(int64(q.EVFILT_SYSCOUNT))},
			"EVFILT_THREADMARKER":                {"untyped int", constant.MakeInt64(int64(q.EVFILT_THREADMARKER))},
			"EVFILT_TIMER":                       {"untyped int", constant.MakeInt64(int64(q.EVFILT_TIMER))},
			"EVFILT_USER":                        {"untyped int", constant.MakeInt64(int64(q.EVFILT_USER))},
			"EVFILT_VM":                          {"untyped int", constant.MakeInt64(int64(q.EVFILT_VM))},
			"EVFILT_VNODE":                       {"untyped int", constant.MakeInt64(int64(q.EVFILT_VNODE))},
			"EVFILT_WRITE":                       {"untyped int", constant.MakeInt64(int64(q.EVFILT_WRITE))},
			"EV_ADD":                             {"untyped int", constant.MakeInt64(int64(q.EV_ADD))},
			"EV_CLEAR":                           {"untyped int", constant.MakeInt64(int64(q.EV_CLEAR))},
			"EV_DELETE":                          {"untyped int", constant.MakeInt64(int64(q.EV_DELETE))},
			"EV_DISABLE":                         {"untyped int", constant.MakeInt64(int64(q.EV_DISABLE))},
			"EV_DISPATCH":                        {"untyped int", constant.MakeInt64(int64(q.EV_DISPATCH))},
			"EV_ENABLE":                          {"untyped int", constant.MakeInt64(int64(q.EV_ENABLE))},
			"EV_EOF":                             {"untyped int", constant.MakeInt64(int64(q.EV_EOF))},
			"EV_ERROR":                           {"untyped int", constant.MakeInt64(int64(q.EV_ERROR))},
			"EV_FLAG0":                           {"untyped int", constant.MakeInt64(int64(q.EV_FLAG0))},
			"EV_FLAG1":                           {"untyped int", constant.MakeInt64(int64(q.EV_FLAG1))},
			"EV_ONESHOT":                         {"untyped int", constant.MakeInt64(int64(q.EV_ONESHOT))},
			"EV_OOBAND":                          {"untyped int", constant.MakeInt64(int64(q.EV_OOBAND))},
			"EV_POLL":                            {"untyped int", constant.MakeInt64(int64(q.EV_POLL))},
			"EV_RECEIPT":                         {"untyped int", constant.MakeInt64(int64(q.EV_RECEIPT))},
			"EV_SYSFLAGS":                        {"untyped int", constant.MakeInt64(int64(q.EV_SYSFLAGS))},
			"EXTA":                               {"untyped int", constant.MakeInt64(int64(q.EXTA))},
			"EXTB":                               {"untyped int", constant.MakeInt64(int64(q.EXTB))},
			"EXTPROC":                            {"untyped int", constant.MakeInt64(int64(q.EXTPROC))},
			"FD_CLOEXEC":                         {"untyped int", constant.MakeInt64(int64(q.FD_CLOEXEC))},
			"FD_SETSIZE":                         {"untyped int", constant.MakeInt64(int64(q.FD_SETSIZE))},
			"FLUSHO":                             {"untyped int", constant.MakeInt64(int64(q.FLUSHO))},
			"F_ADDFILESIGS":                      {"untyped int", constant.MakeInt64(int64(q.F_ADDFILESIGS))},
			"F_ADDSIGS":                          {"untyped int", constant.MakeInt64(int64(q.F_ADDSIGS))},
			"F_ALLOCATEALL":                      {"untyped int", constant.MakeInt64(int64(q.F_ALLOCATEALL))},
			"F_ALLOCATECONTIG":                   {"untyped int", constant.MakeInt64(int64(q.F_ALLOCATECONTIG))},
			"F_CHKCLEAN":                         {"untyped int", constant.MakeInt64(int64(q.F_CHKCLEAN))},
			"F_DUPFD":                            {"untyped int", constant.MakeInt64(int64(q.F_DUPFD))},
			"F_DUPFD_CLOEXEC":                    {"untyped int", constant.MakeInt64(int64(q.F_DUPFD_CLOEXEC))},
			"F_FLUSH_DATA":                       {"untyped int", constant.MakeInt64(int64(q.F_FLUSH_DATA))},
			"F_FREEZE_FS":                        {"untyped int", constant.MakeInt64(int64(q.F_FREEZE_FS))},
			"F_FULLFSYNC":                        {"untyped int", constant.MakeInt64(int64(q.F_FULLFSYNC))},
			"F_GETFD":                            {"untyped int", constant.MakeInt64(int64(q.F_GETFD))},
			"F_GETFL":                            {"untyped int", constant.MakeInt64(int64(q.F_GETFL))},
			"F_GETLK":                            {"untyped int", constant.MakeInt64(int64(q.F_GETLK))},
			"F_GETLKPID":                         {"untyped int", constant.MakeInt64(int64(q.F_GETLKPID))},
			"F_GETNOSIGPIPE":                     {"untyped int", constant.MakeInt64(int64(q.F_GETNOSIGPIPE))},
			"F_GETOWN":                           {"untyped int", constant.MakeInt64(int64(q.F_GETOWN))},
			"F_GETPATH":                          {"untyped int", constant.MakeInt64(int64(q.F_GETPATH))},
			"F_GETPATH_MTMINFO":                  {"untyped int", constant.MakeInt64(int64(q.F_GETPATH_MTMINFO))},
			"F_GETPROTECTIONCLASS":               {"untyped int", constant.MakeInt64(int64(q.F_GETPROTECTIONCLASS))},
			"F_GLOBAL_NOCACHE":                   {"untyped int", constant.MakeInt64(int64(q.F_GLOBAL_NOCACHE))},
			"F_LOG2PHYS":                         {"untyped int", constant.MakeInt64(int64(q.F_LOG2PHYS))},
			"F_LOG2PHYS_EXT":                     {"untyped int", constant.MakeInt64(int64(q.F_LOG2PHYS_EXT))},
			"F_MARKDEPENDENCY":                   {"untyped int", constant.MakeInt64(int64(q.F_MARKDEPENDENCY))},
			"F_NOCACHE":                          {"untyped int", constant.MakeInt64(int64(q.F_NOCACHE))},
			"F_NODIRECT":                         {"untyped int", constant.MakeInt64(int64(q.F_NODIRECT))},
			"F_OK":                               {"untyped int", constant.MakeInt64(int64(q.F_OK))},
			"F_PATHPKG_CHECK":                    {"untyped int", constant.MakeInt64(int64(q.F_PATHPKG_CHECK))},
			"F_PEOFPOSMODE":                      {"untyped int", constant.MakeInt64(int64(q.F_PEOFPOSMODE))},
			"F_PREALLOCATE":                      {"untyped int", constant.MakeInt64(int64(q.F_PREALLOCATE))},
			"F_RDADVISE":                         {"untyped int", constant.MakeInt64(int64(q.F_RDADVISE))},
			"F_RDAHEAD":                          {"untyped int", constant.MakeInt64(int64(q.F_RDAHEAD))},
			"F_RDLCK":                            {"untyped int", constant.MakeInt64(int64(q.F_RDLCK))},
			"F_READBOOTSTRAP":                    {"untyped int", constant.MakeInt64(int64(q.F_READBOOTSTRAP))},
			"F_SETBACKINGSTORE":                  {"untyped int", constant.MakeInt64(int64(q.F_SETBACKINGSTORE))},
			"F_SETFD":                            {"untyped int", constant.MakeInt64(int64(q.F_SETFD))},
			"F_SETFL":                            {"untyped int", constant.MakeInt64(int64(q.F_SETFL))},
			"F_SETLK":                            {"untyped int", constant.MakeInt64(int64(q.F_SETLK))},
			"F_SETLKW":                           {"untyped int", constant.MakeInt64(int64(q.F_SETLKW))},
			"F_SETNOSIGPIPE":                     {"untyped int", constant.MakeInt64(int64(q.F_SETNOSIGPIPE))},
			"F_SETOWN":                           {"untyped int", constant.MakeInt64(int64(q.F_SETOWN))},
			"F_SETPROTECTIONCLASS":               {"untyped int", constant.MakeInt64(int64(q.F_SETPROTECTIONCLASS))},
			"F_SETSIZE":                          {"untyped int", constant.MakeInt64(int64(q.F_SETSIZE))},
			"F_THAW_FS":                          {"untyped int", constant.MakeInt64(int64(q.F_THAW_FS))},
			"F_UNLCK":                            {"untyped int", constant.MakeInt64(int64(q.F_UNLCK))},
			"F_VOLPOSMODE":                       {"untyped int", constant.MakeInt64(int64(q.F_VOLPOSMODE))},
			"F_WRITEBOOTSTRAP":                   {"untyped int", constant.MakeInt64(int64(q.F_WRITEBOOTSTRAP))},
			"F_WRLCK":                            {"untyped int", constant.MakeInt64(int64(q.F_WRLCK))},
			"HUPCL":                              {"untyped int", constant.MakeInt64(int64(q.HUPCL))},
			"ICANON":                             {"untyped int", constant.MakeInt64(int64(q.ICANON))},
			"ICMP6_FILTER":                       {"untyped int", constant.MakeInt64(int64(q.ICMP6_FILTER))},
			"ICRNL":                              {"untyped int", constant.MakeInt64(int64(q.ICRNL))},
			"IEXTEN":                             {"untyped int", constant.MakeInt64(int64(q.IEXTEN))},
			"IFF_ALLMULTI":                       {"untyped int", constant.MakeInt64(int64(q.IFF_ALLMULTI))},
			"IFF_ALTPHYS":                        {"untyped int", constant.MakeInt64(int64(q.IFF_ALTPHYS))},
			"IFF_BROADCAST":                      {"untyped int", constant.MakeInt64(int64(q.IFF_BROADCAST))},
			"IFF_DEBUG":                          {"untyped int", constant.MakeInt64(int64(q.IFF_DEBUG))},
			"IFF_LINK0":                          {"untyped int", constant.MakeInt64(int64(q.IFF_LINK0))},
			"IFF_LINK1":                          {"untyped int", constant.MakeInt64(int64(q.IFF_LINK1))},
			"IFF_LINK2":                          {"untyped int", constant.MakeInt64(int64(q.IFF_LINK2))},
			"IFF_LOOPBACK":                       {"untyped int", constant.MakeInt64(int64(q.IFF_LOOPBACK))},
			"IFF_MULTICAST":                      {"untyped int", constant.MakeInt64(int64(q.IFF_MULTICAST))},
			"IFF_NOARP":                          {"untyped int", constant.MakeInt64(int64(q.IFF_NOARP))},
			"IFF_NOTRAILERS":                     {"untyped int", constant.MakeInt64(int64(q.IFF_NOTRAILERS))},
			"IFF_OACTIVE":                        {"untyped int", constant.MakeInt64(int64(q.IFF_OACTIVE))},
			"IFF_POINTOPOINT":                    {"untyped int", constant.MakeInt64(int64(q.IFF_POINTOPOINT))},
			"IFF_PROMISC":                        {"untyped int", constant.MakeInt64(int64(q.IFF_PROMISC))},
			"IFF_RUNNING":                        {"untyped int", constant.MakeInt64(int64(q.IFF_RUNNING))},
			"IFF_SIMPLEX":                        {"untyped int", constant.MakeInt64(int64(q.IFF_SIMPLEX))},
			"IFF_UP":                             {"untyped int", constant.MakeInt64(int64(q.IFF_UP))},
			"IFNAMSIZ":                           {"untyped int", constant.MakeInt64(int64(q.IFNAMSIZ))},
			"IFT_1822":                           {"untyped int", constant.MakeInt64(int64(q.IFT_1822))},
			"IFT_AAL5":                           {"untyped int", constant.MakeInt64(int64(q.IFT_AAL5))},
			"IFT_ARCNET":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNET))},
			"IFT_ARCNETPLUS":                     {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNETPLUS))},
			"IFT_ATM":                            {"untyped int", constant.MakeInt64(int64(q.IFT_ATM))},
			"IFT_BRIDGE":                         {"untyped int", constant.MakeInt64(int64(q.IFT_BRIDGE))},
			"IFT_CARP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_CARP))},
			"IFT_CELLULAR":                       {"untyped int", constant.MakeInt64(int64(q.IFT_CELLULAR))},
			"IFT_CEPT":                           {"untyped int", constant.MakeInt64(int64(q.IFT_CEPT))},
			"IFT_DS3":                            {"untyped int", constant.MakeInt64(int64(q.IFT_DS3))},
			"IFT_ENC":                            {"untyped int", constant.MakeInt64(int64(q.IFT_ENC))},
			"IFT_EON":                            {"untyped int", constant.MakeInt64(int64(q.IFT_EON))},
			"IFT_ETHER":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ETHER))},
			"IFT_FAITH":                          {"untyped int", constant.MakeInt64(int64(q.IFT_FAITH))},
			"IFT_FDDI":                           {"untyped int", constant.MakeInt64(int64(q.IFT_FDDI))},
			"IFT_FRELAY":                         {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAY))},
			"IFT_FRELAYDCE":                      {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAYDCE))},
			"IFT_GIF":                            {"untyped int", constant.MakeInt64(int64(q.IFT_GIF))},
			"IFT_HDH1822":                        {"untyped int", constant.MakeInt64(int64(q.IFT_HDH1822))},
			"IFT_HIPPI":                          {"untyped int", constant.MakeInt64(int64(q.IFT_HIPPI))},
			"IFT_HSSI":                           {"untyped int", constant.MakeInt64(int64(q.IFT_HSSI))},
			"IFT_HY":                             {"untyped int", constant.MakeInt64(int64(q.IFT_HY))},
			"IFT_IEEE1394":                       {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE1394))},
			"IFT_IEEE8023ADLAG":                  {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE8023ADLAG))},
			"IFT_ISDNBASIC":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNBASIC))},
			"IFT_ISDNPRIMARY":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNPRIMARY))},
			"IFT_ISO88022LLC":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88022LLC))},
			"IFT_ISO88023":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88023))},
			"IFT_ISO88024":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88024))},
			"IFT_ISO88025":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025))},
			"IFT_ISO88026":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88026))},
			"IFT_L2VLAN":                         {"untyped int", constant.MakeInt64(int64(q.IFT_L2VLAN))},
			"IFT_LAPB":                           {"untyped int", constant.MakeInt64(int64(q.IFT_LAPB))},
			"IFT_LOCALTALK":                      {"untyped int", constant.MakeInt64(int64(q.IFT_LOCALTALK))},
			"IFT_LOOP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_LOOP))},
			"IFT_MIOX25":                         {"untyped int", constant.MakeInt64(int64(q.IFT_MIOX25))},
			"IFT_MODEM":                          {"untyped int", constant.MakeInt64(int64(q.IFT_MODEM))},
			"IFT_NSIP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_NSIP))},
			"IFT_OTHER":                          {"untyped int", constant.MakeInt64(int64(q.IFT_OTHER))},
			"IFT_P10":                            {"untyped int", constant.MakeInt64(int64(q.IFT_P10))},
			"IFT_P80":                            {"untyped int", constant.MakeInt64(int64(q.IFT_P80))},
			"IFT_PARA":                           {"untyped int", constant.MakeInt64(int64(q.IFT_PARA))},
			"IFT_PDP":                            {"untyped int", constant.MakeInt64(int64(q.IFT_PDP))},
			"IFT_PFLOG":                          {"untyped int", constant.MakeInt64(int64(q.IFT_PFLOG))},
			"IFT_PFSYNC":                         {"untyped int", constant.MakeInt64(int64(q.IFT_PFSYNC))},
			"IFT_PPP":                            {"untyped int", constant.MakeInt64(int64(q.IFT_PPP))},
			"IFT_PROPMUX":                        {"untyped int", constant.MakeInt64(int64(q.IFT_PROPMUX))},
			"IFT_PROPVIRTUAL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_PROPVIRTUAL))},
			"IFT_PTPSERIAL":                      {"untyped int", constant.MakeInt64(int64(q.IFT_PTPSERIAL))},
			"IFT_RS232":                          {"untyped int", constant.MakeInt64(int64(q.IFT_RS232))},
			"IFT_SDLC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_SDLC))},
			"IFT_SIP":                            {"untyped int", constant.MakeInt64(int64(q.IFT_SIP))},
			"IFT_SLIP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_SLIP))},
			"IFT_SMDSDXI":                        {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSDXI))},
			"IFT_SMDSICIP":                       {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSICIP))},
			"IFT_SONET":                          {"untyped int", constant.MakeInt64(int64(q.IFT_SONET))},
			"IFT_SONETPATH":                      {"untyped int", constant.MakeInt64(int64(q.IFT_SONETPATH))},
			"IFT_SONETVT":                        {"untyped int", constant.MakeInt64(int64(q.IFT_SONETVT))},
			"IFT_STARLAN":                        {"untyped int", constant.MakeInt64(int64(q.IFT_STARLAN))},
			"IFT_STF":                            {"untyped int", constant.MakeInt64(int64(q.IFT_STF))},
			"IFT_T1":                             {"untyped int", constant.MakeInt64(int64(q.IFT_T1))},
			"IFT_ULTRA":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ULTRA))},
			"IFT_V35":                            {"untyped int", constant.MakeInt64(int64(q.IFT_V35))},
			"IFT_X25":                            {"untyped int", constant.MakeInt64(int64(q.IFT_X25))},
			"IFT_X25DDN":                         {"untyped int", constant.MakeInt64(int64(q.IFT_X25DDN))},
			"IFT_X25PLE":                         {"untyped int", constant.MakeInt64(int64(q.IFT_X25PLE))},
			"IFT_XETHER":                         {"untyped int", constant.MakeInt64(int64(q.IFT_XETHER))},
			"IGNBRK":                             {"untyped int", constant.MakeInt64(int64(q.IGNBRK))},
			"IGNCR":                              {"untyped int", constant.MakeInt64(int64(q.IGNCR))},
			"IGNPAR":                             {"untyped int", constant.MakeInt64(int64(q.IGNPAR))},
			"IMAXBEL":                            {"untyped int", constant.MakeInt64(int64(q.IMAXBEL))},
			"INLCR":                              {"untyped int", constant.MakeInt64(int64(q.INLCR))},
			"INPCK":                              {"untyped int", constant.MakeInt64(int64(q.INPCK))},
			"IN_CLASSA_HOST":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_HOST))},
			"IN_CLASSA_MAX":                      {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_MAX))},
			"IN_CLASSA_NET":                      {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NET))},
			"IN_CLASSA_NSHIFT":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NSHIFT))},
			"IN_CLASSB_HOST":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_HOST))},
			"IN_CLASSB_MAX":                      {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_MAX))},
			"IN_CLASSB_NET":                      {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NET))},
			"IN_CLASSB_NSHIFT":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NSHIFT))},
			"IN_CLASSC_HOST":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_HOST))},
			"IN_CLASSC_NET":                      {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NET))},
			"IN_CLASSC_NSHIFT":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NSHIFT))},
			"IN_CLASSD_HOST":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_HOST))},
			"IN_CLASSD_NET":                      {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NET))},
			"IN_CLASSD_NSHIFT":                   {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NSHIFT))},
			"IN_LINKLOCALNETNUM":                 {"untyped int", constant.MakeInt64(int64(q.IN_LINKLOCALNETNUM))},
			"IN_LOOPBACKNET":                     {"untyped int", constant.MakeInt64(int64(q.IN_LOOPBACKNET))},
			"IPPROTO_3PC":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_3PC))},
			"IPPROTO_ADFS":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ADFS))},
			"IPPROTO_AH":                         {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AH))},
			"IPPROTO_AHIP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AHIP))},
			"IPPROTO_APES":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_APES))},
			"IPPROTO_ARGUS":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ARGUS))},
			"IPPROTO_AX25":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AX25))},
			"IPPROTO_BHA":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BHA))},
			"IPPROTO_BLT":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BLT))},
			"IPPROTO_BRSATMON":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BRSATMON))},
			"IPPROTO_CFTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CFTP))},
			"IPPROTO_CHAOS":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CHAOS))},
			"IPPROTO_CMTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CMTP))},
			"IPPROTO_CPHB":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CPHB))},
			"IPPROTO_CPNX":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CPNX))},
			"IPPROTO_DDP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DDP))},
			"IPPROTO_DGP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DGP))},
			"IPPROTO_DIVERT":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DIVERT))},
			"IPPROTO_DONE":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DONE))},
			"IPPROTO_DSTOPTS":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DSTOPTS))},
			"IPPROTO_EGP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EGP))},
			"IPPROTO_EMCON":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EMCON))},
			"IPPROTO_ENCAP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ENCAP))},
			"IPPROTO_EON":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EON))},
			"IPPROTO_ESP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ESP))},
			"IPPROTO_ETHERIP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ETHERIP))},
			"IPPROTO_FRAGMENT":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_FRAGMENT))},
			"IPPROTO_GGP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GGP))},
			"IPPROTO_GMTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GMTP))},
			"IPPROTO_GRE":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GRE))},
			"IPPROTO_HELLO":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HELLO))},
			"IPPROTO_HMP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HMP))},
			"IPPROTO_HOPOPTS":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HOPOPTS))},
			"IPPROTO_ICMP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMP))},
			"IPPROTO_ICMPV6":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMPV6))},
			"IPPROTO_IDP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDP))},
			"IPPROTO_IDPR":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDPR))},
			"IPPROTO_IDRP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDRP))},
			"IPPROTO_IGMP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGMP))},
			"IPPROTO_IGP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGP))},
			"IPPROTO_IGRP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGRP))},
			"IPPROTO_IL":                         {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IL))},
			"IPPROTO_INLSP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_INLSP))},
			"IPPROTO_INP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_INP))},
			"IPPROTO_IP":                         {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IP))},
			"IPPROTO_IPCOMP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPCOMP))},
			"IPPROTO_IPCV":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPCV))},
			"IPPROTO_IPEIP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPEIP))},
			"IPPROTO_IPIP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPIP))},
			"IPPROTO_IPPC":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPPC))},
			"IPPROTO_IPV4":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV4))},
			"IPPROTO_IPV6":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV6))},
			"IPPROTO_IRTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IRTP))},
			"IPPROTO_KRYPTOLAN":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_KRYPTOLAN))},
			"IPPROTO_LARP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_LARP))},
			"IPPROTO_LEAF1":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_LEAF1))},
			"IPPROTO_LEAF2":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_LEAF2))},
			"IPPROTO_MAX":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAX))},
			"IPPROTO_MAXID":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAXID))},
			"IPPROTO_MEAS":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MEAS))},
			"IPPROTO_MHRP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MHRP))},
			"IPPROTO_MICP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MICP))},
			"IPPROTO_MTP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MTP))},
			"IPPROTO_MUX":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MUX))},
			"IPPROTO_ND":                         {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ND))},
			"IPPROTO_NHRP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NHRP))},
			"IPPROTO_NONE":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NONE))},
			"IPPROTO_NSP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NSP))},
			"IPPROTO_NVPII":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NVPII))},
			"IPPROTO_OSPFIGP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_OSPFIGP))},
			"IPPROTO_PGM":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PGM))},
			"IPPROTO_PIGP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PIGP))},
			"IPPROTO_PIM":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PIM))},
			"IPPROTO_PRM":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PRM))},
			"IPPROTO_PUP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PUP))},
			"IPPROTO_PVP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PVP))},
			"IPPROTO_RAW":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RAW))},
			"IPPROTO_RCCMON":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RCCMON))},
			"IPPROTO_RDP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RDP))},
			"IPPROTO_ROUTING":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ROUTING))},
			"IPPROTO_RSVP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RSVP))},
			"IPPROTO_RVD":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RVD))},
			"IPPROTO_SATEXPAK":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SATEXPAK))},
			"IPPROTO_SATMON":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SATMON))},
			"IPPROTO_SCCSP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SCCSP))},
			"IPPROTO_SCTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SCTP))},
			"IPPROTO_SDRP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SDRP))},
			"IPPROTO_SEP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SEP))},
			"IPPROTO_SRPC":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SRPC))},
			"IPPROTO_ST":                         {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ST))},
			"IPPROTO_SVMTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SVMTP))},
			"IPPROTO_SWIPE":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SWIPE))},
			"IPPROTO_TCF":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCF))},
			"IPPROTO_TCP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCP))},
			"IPPROTO_TP":                         {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TP))},
			"IPPROTO_TPXX":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TPXX))},
			"IPPROTO_TRUNK1":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TRUNK1))},
			"IPPROTO_TRUNK2":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TRUNK2))},
			"IPPROTO_TTP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TTP))},
			"IPPROTO_UDP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDP))},
			"IPPROTO_VINES":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_VINES))},
			"IPPROTO_VISA":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_VISA))},
			"IPPROTO_VMTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_VMTP))},
			"IPPROTO_WBEXPAK":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_WBEXPAK))},
			"IPPROTO_WBMON":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_WBMON))},
			"IPPROTO_WSN":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_WSN))},
			"IPPROTO_XNET":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_XNET))},
			"IPPROTO_XTP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_XTP))},
			"IPV6_2292DSTOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_2292DSTOPTS))},
			"IPV6_2292HOPLIMIT":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_2292HOPLIMIT))},
			"IPV6_2292HOPOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_2292HOPOPTS))},
			"IPV6_2292NEXTHOP":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_2292NEXTHOP))},
			"IPV6_2292PKTINFO":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_2292PKTINFO))},
			"IPV6_2292PKTOPTIONS":                {"untyped int", constant.MakeInt64(int64(q.IPV6_2292PKTOPTIONS))},
			"IPV6_2292RTHDR":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_2292RTHDR))},
			"IPV6_BINDV6ONLY":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_BINDV6ONLY))},
			"IPV6_BOUND_IF":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_BOUND_IF))},
			"IPV6_CHECKSUM":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_CHECKSUM))},
			"IPV6_DEFAULT_MULTICAST_HOPS":        {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFAULT_MULTICAST_HOPS))},
			"IPV6_DEFAULT_MULTICAST_LOOP":        {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFAULT_MULTICAST_LOOP))},
			"IPV6_DEFHLIM":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFHLIM))},
			"IPV6_FAITH":                         {"untyped int", constant.MakeInt64(int64(q.IPV6_FAITH))},
			"IPV6_FLOWINFO_MASK":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_MASK))},
			"IPV6_FLOWLABEL_MASK":                {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWLABEL_MASK))},
			"IPV6_FRAGTTL":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_FRAGTTL))},
			"IPV6_FW_ADD":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_ADD))},
			"IPV6_FW_DEL":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_DEL))},
			"IPV6_FW_FLUSH":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_FLUSH))},
			"IPV6_FW_GET":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_GET))},
			"IPV6_FW_ZERO":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_ZERO))},
			"IPV6_HLIMDEC":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_HLIMDEC))},
			"IPV6_IPSEC_POLICY":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_IPSEC_POLICY))},
			"IPV6_JOIN_GROUP":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_GROUP))},
			"IPV6_LEAVE_GROUP":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_GROUP))},
			"IPV6_MAXHLIM":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_MAXHLIM))},
			"IPV6_MAXOPTHDR":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_MAXOPTHDR))},
			"IPV6_MAXPACKET":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_MAXPACKET))},
			"IPV6_MAX_GROUP_SRC_FILTER":          {"untyped int", constant.MakeInt64(int64(q.IPV6_MAX_GROUP_SRC_FILTER))},
			"IPV6_MAX_MEMBERSHIPS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_MAX_MEMBERSHIPS))},
			"IPV6_MAX_SOCK_SRC_FILTER":           {"untyped int", constant.MakeInt64(int64(q.IPV6_MAX_SOCK_SRC_FILTER))},
			"IPV6_MIN_MEMBERSHIPS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_MIN_MEMBERSHIPS))},
			"IPV6_MMTU":                          {"untyped int", constant.MakeInt64(int64(q.IPV6_MMTU))},
			"IPV6_MULTICAST_HOPS":                {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_HOPS))},
			"IPV6_MULTICAST_IF":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_IF))},
			"IPV6_MULTICAST_LOOP":                {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_LOOP))},
			"IPV6_PORTRANGE":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE))},
			"IPV6_PORTRANGE_DEFAULT":             {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_DEFAULT))},
			"IPV6_PORTRANGE_HIGH":                {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_HIGH))},
			"IPV6_PORTRANGE_LOW":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_LOW))},
			"IPV6_RECVTCLASS":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVTCLASS))},
			"IPV6_RTHDR_LOOSE":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_LOOSE))},
			"IPV6_RTHDR_STRICT":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_STRICT))},
			"IPV6_RTHDR_TYPE_0":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_TYPE_0))},
			"IPV6_SOCKOPT_RESERVED1":             {"untyped int", constant.MakeInt64(int64(q.IPV6_SOCKOPT_RESERVED1))},
			"IPV6_TCLASS":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_TCLASS))},
			"IPV6_UNICAST_HOPS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_UNICAST_HOPS))},
			"IPV6_V6ONLY":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_V6ONLY))},
			"IPV6_VERSION":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_VERSION))},
			"IPV6_VERSION_MASK":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_VERSION_MASK))},
			"IP_ADD_MEMBERSHIP":                  {"untyped int", constant.MakeInt64(int64(q.IP_ADD_MEMBERSHIP))},
			"IP_ADD_SOURCE_MEMBERSHIP":           {"untyped int", constant.MakeInt64(int64(q.IP_ADD_SOURCE_MEMBERSHIP))},
			"IP_BLOCK_SOURCE":                    {"untyped int", constant.MakeInt64(int64(q.IP_BLOCK_SOURCE))},
			"IP_BOUND_IF":                        {"untyped int", constant.MakeInt64(int64(q.IP_BOUND_IF))},
			"IP_DEFAULT_MULTICAST_LOOP":          {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_LOOP))},
			"IP_DEFAULT_MULTICAST_TTL":           {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_TTL))},
			"IP_DF":                              {"untyped int", constant.MakeInt64(int64(q.IP_DF))},
			"IP_DROP_MEMBERSHIP":                 {"untyped int", constant.MakeInt64(int64(q.IP_DROP_MEMBERSHIP))},
			"IP_DROP_SOURCE_MEMBERSHIP":          {"untyped int", constant.MakeInt64(int64(q.IP_DROP_SOURCE_MEMBERSHIP))},
			"IP_DUMMYNET_CONFIGURE":              {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_CONFIGURE))},
			"IP_DUMMYNET_DEL":                    {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_DEL))},
			"IP_DUMMYNET_FLUSH":                  {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_FLUSH))},
			"IP_DUMMYNET_GET":                    {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_GET))},
			"IP_FAITH":                           {"untyped int", constant.MakeInt64(int64(q.IP_FAITH))},
			"IP_FW_ADD":                          {"untyped int", constant.MakeInt64(int64(q.IP_FW_ADD))},
			"IP_FW_DEL":                          {"untyped int", constant.MakeInt64(int64(q.IP_FW_DEL))},
			"IP_FW_FLUSH":                        {"untyped int", constant.MakeInt64(int64(q.IP_FW_FLUSH))},
			"IP_FW_GET":                          {"untyped int", constant.MakeInt64(int64(q.IP_FW_GET))},
			"IP_FW_RESETLOG":                     {"untyped int", constant.MakeInt64(int64(q.IP_FW_RESETLOG))},
			"IP_FW_ZERO":                         {"untyped int", constant.MakeInt64(int64(q.IP_FW_ZERO))},
			"IP_HDRINCL":                         {"untyped int", constant.MakeInt64(int64(q.IP_HDRINCL))},
			"IP_IPSEC_POLICY":                    {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_POLICY))},
			"IP_MAXPACKET":                       {"untyped int", constant.MakeInt64(int64(q.IP_MAXPACKET))},
			"IP_MAX_GROUP_SRC_FILTER":            {"untyped int", constant.MakeInt64(int64(q.IP_MAX_GROUP_SRC_FILTER))},
			"IP_MAX_MEMBERSHIPS":                 {"untyped int", constant.MakeInt64(int64(q.IP_MAX_MEMBERSHIPS))},
			"IP_MAX_SOCK_MUTE_FILTER":            {"untyped int", constant.MakeInt64(int64(q.IP_MAX_SOCK_MUTE_FILTER))},
			"IP_MAX_SOCK_SRC_FILTER":             {"untyped int", constant.MakeInt64(int64(q.IP_MAX_SOCK_SRC_FILTER))},
			"IP_MF":                              {"untyped int", constant.MakeInt64(int64(q.IP_MF))},
			"IP_MIN_MEMBERSHIPS":                 {"untyped int", constant.MakeInt64(int64(q.IP_MIN_MEMBERSHIPS))},
			"IP_MSFILTER":                        {"untyped int", constant.MakeInt64(int64(q.IP_MSFILTER))},
			"IP_MSS":                             {"untyped int", constant.MakeInt64(int64(q.IP_MSS))},
			"IP_MULTICAST_IF":                    {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IF))},
			"IP_MULTICAST_IFINDEX":               {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IFINDEX))},
			"IP_MULTICAST_LOOP":                  {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_LOOP))},
			"IP_MULTICAST_TTL":                   {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_TTL))},
			"IP_MULTICAST_VIF":                   {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_VIF))},
			"IP_NAT__XXX":                        {"untyped int", constant.MakeInt64(int64(q.IP_NAT__XXX))},
			"IP_OFFMASK":                         {"untyped int", constant.MakeInt64(int64(q.IP_OFFMASK))},
			"IP_OLD_FW_ADD":                      {"untyped int", constant.MakeInt64(int64(q.IP_OLD_FW_ADD))},
			"IP_OLD_FW_DEL":                      {"untyped int", constant.MakeInt64(int64(q.IP_OLD_FW_DEL))},
			"IP_OLD_FW_FLUSH":                    {"untyped int", constant.MakeInt64(int64(q.IP_OLD_FW_FLUSH))},
			"IP_OLD_FW_GET":                      {"untyped int", constant.MakeInt64(int64(q.IP_OLD_FW_GET))},
			"IP_OLD_FW_RESETLOG":                 {"untyped int", constant.MakeInt64(int64(q.IP_OLD_FW_RESETLOG))},
			"IP_OLD_FW_ZERO":                     {"untyped int", constant.MakeInt64(int64(q.IP_OLD_FW_ZERO))},
			"IP_OPTIONS":                         {"untyped int", constant.MakeInt64(int64(q.IP_OPTIONS))},
			"IP_PKTINFO":                         {"untyped int", constant.MakeInt64(int64(q.IP_PKTINFO))},
			"IP_PORTRANGE":                       {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE))},
			"IP_PORTRANGE_DEFAULT":               {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_DEFAULT))},
			"IP_PORTRANGE_HIGH":                  {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_HIGH))},
			"IP_PORTRANGE_LOW":                   {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_LOW))},
			"IP_RECVDSTADDR":                     {"untyped int", constant.MakeInt64(int64(q.IP_RECVDSTADDR))},
			"IP_RECVIF":                          {"untyped int", constant.MakeInt64(int64(q.IP_RECVIF))},
			"IP_RECVOPTS":                        {"untyped int", constant.MakeInt64(int64(q.IP_RECVOPTS))},
			"IP_RECVPKTINFO":                     {"untyped int", constant.MakeInt64(int64(q.IP_RECVPKTINFO))},
			"IP_RECVRETOPTS":                     {"untyped int", constant.MakeInt64(int64(q.IP_RECVRETOPTS))},
			"IP_RECVTTL":                         {"untyped int", constant.MakeInt64(int64(q.IP_RECVTTL))},
			"IP_RETOPTS":                         {"untyped int", constant.MakeInt64(int64(q.IP_RETOPTS))},
			"IP_RF":                              {"untyped int", constant.MakeInt64(int64(q.IP_RF))},
			"IP_RSVP_OFF":                        {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_OFF))},
			"IP_RSVP_ON":                         {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_ON))},
			"IP_RSVP_VIF_OFF":                    {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_VIF_OFF))},
			"IP_RSVP_VIF_ON":                     {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_VIF_ON))},
			"IP_STRIPHDR":                        {"untyped int", constant.MakeInt64(int64(q.IP_STRIPHDR))},
			"IP_TOS":                             {"untyped int", constant.MakeInt64(int64(q.IP_TOS))},
			"IP_TRAFFIC_MGT_BACKGROUND":          {"untyped int", constant.MakeInt64(int64(q.IP_TRAFFIC_MGT_BACKGROUND))},
			"IP_TTL":                             {"untyped int", constant.MakeInt64(int64(q.IP_TTL))},
			"IP_UNBLOCK_SOURCE":                  {"untyped int", constant.MakeInt64(int64(q.IP_UNBLOCK_SOURCE))},
			"ISIG":                               {"untyped int", constant.MakeInt64(int64(q.ISIG))},
			"ISTRIP":                             {"untyped int", constant.MakeInt64(int64(q.ISTRIP))},
			"IUTF8":                              {"untyped int", constant.MakeInt64(int64(q.IUTF8))},
			"IXANY":                              {"untyped int", constant.MakeInt64(int64(q.IXANY))},
			"IXOFF":                              {"untyped int", constant.MakeInt64(int64(q.IXOFF))},
			"IXON":                               {"untyped int", constant.MakeInt64(int64(q.IXON))},
			"ImplementsGetwd":                    {"untyped bool", constant.MakeBool(bool(q.ImplementsGetwd))},
			"LOCK_EX":                            {"untyped int", constant.MakeInt64(int64(q.LOCK_EX))},
			"LOCK_NB":                            {"untyped int", constant.MakeInt64(int64(q.LOCK_NB))},
			"LOCK_SH":                            {"untyped int", constant.MakeInt64(int64(q.LOCK_SH))},
			"LOCK_UN":                            {"untyped int", constant.MakeInt64(int64(q.LOCK_UN))},
			"MADV_CAN_REUSE":                     {"untyped int", constant.MakeInt64(int64(q.MADV_CAN_REUSE))},
			"MADV_DONTNEED":                      {"untyped int", constant.MakeInt64(int64(q.MADV_DONTNEED))},
			"MADV_FREE":                          {"untyped int", constant.MakeInt64(int64(q.MADV_FREE))},
			"MADV_FREE_REUSABLE":                 {"untyped int", constant.MakeInt64(int64(q.MADV_FREE_REUSABLE))},
			"MADV_FREE_REUSE":                    {"untyped int", constant.MakeInt64(int64(q.MADV_FREE_REUSE))},
			"MADV_NORMAL":                        {"untyped int", constant.MakeInt64(int64(q.MADV_NORMAL))},
			"MADV_RANDOM":                        {"untyped int", constant.MakeInt64(int64(q.MADV_RANDOM))},
			"MADV_SEQUENTIAL":                    {"untyped int", constant.MakeInt64(int64(q.MADV_SEQUENTIAL))},
			"MADV_WILLNEED":                      {"untyped int", constant.MakeInt64(int64(q.MADV_WILLNEED))},
			"MADV_ZERO_WIRED_PAGES":              {"untyped int", constant.MakeInt64(int64(q.MADV_ZERO_WIRED_PAGES))},
			"MAP_ANON":                           {"untyped int", constant.MakeInt64(int64(q.MAP_ANON))},
			"MAP_COPY":                           {"untyped int", constant.MakeInt64(int64(q.MAP_COPY))},
			"MAP_FILE":                           {"untyped int", constant.MakeInt64(int64(q.MAP_FILE))},
			"MAP_FIXED":                          {"untyped int", constant.MakeInt64(int64(q.MAP_FIXED))},
			"MAP_HASSEMAPHORE":                   {"untyped int", constant.MakeInt64(int64(q.MAP_HASSEMAPHORE))},
			"MAP_JIT":                            {"untyped int", constant.MakeInt64(int64(q.MAP_JIT))},
			"MAP_NOCACHE":                        {"untyped int", constant.MakeInt64(int64(q.MAP_NOCACHE))},
			"MAP_NOEXTEND":                       {"untyped int", constant.MakeInt64(int64(q.MAP_NOEXTEND))},
			"MAP_NORESERVE":                      {"untyped int", constant.MakeInt64(int64(q.MAP_NORESERVE))},
			"MAP_PRIVATE":                        {"untyped int", constant.MakeInt64(int64(q.MAP_PRIVATE))},
			"MAP_RENAME":                         {"untyped int", constant.MakeInt64(int64(q.MAP_RENAME))},
			"MAP_RESERVED0080":                   {"untyped int", constant.MakeInt64(int64(q.MAP_RESERVED0080))},
			"MAP_SHARED":                         {"untyped int", constant.MakeInt64(int64(q.MAP_SHARED))},
			"MCL_CURRENT":                        {"untyped int", constant.MakeInt64(int64(q.MCL_CURRENT))},
			"MCL_FUTURE":                         {"untyped int", constant.MakeInt64(int64(q.MCL_FUTURE))},
			"MSG_CTRUNC":                         {"untyped int", constant.MakeInt64(int64(q.MSG_CTRUNC))},
			"MSG_DONTROUTE":                      {"untyped int", constant.MakeInt64(int64(q.MSG_DONTROUTE))},
			"MSG_DONTWAIT":                       {"untyped int", constant.MakeInt64(int64(q.MSG_DONTWAIT))},
			"MSG_EOF":                            {"untyped int", constant.MakeInt64(int64(q.MSG_EOF))},
			"MSG_EOR":                            {"untyped int", constant.MakeInt64(int64(q.MSG_EOR))},
			"MSG_FLUSH":                          {"untyped int", constant.MakeInt64(int64(q.MSG_FLUSH))},
			"MSG_HAVEMORE":                       {"untyped int", constant.MakeInt64(int64(q.MSG_HAVEMORE))},
			"MSG_HOLD":                           {"untyped int", constant.MakeInt64(int64(q.MSG_HOLD))},
			"MSG_NEEDSA":                         {"untyped int", constant.MakeInt64(int64(q.MSG_NEEDSA))},
			"MSG_OOB":                            {"untyped int", constant.MakeInt64(int64(q.MSG_OOB))},
			"MSG_PEEK":                           {"untyped int", constant.MakeInt64(int64(q.MSG_PEEK))},
			"MSG_RCVMORE":                        {"untyped int", constant.MakeInt64(int64(q.MSG_RCVMORE))},
			"MSG_SEND":                           {"untyped int", constant.MakeInt64(int64(q.MSG_SEND))},
			"MSG_TRUNC":                          {"untyped int", constant.MakeInt64(int64(q.MSG_TRUNC))},
			"MSG_WAITALL":                        {"untyped int", constant.MakeInt64(int64(q.MSG_WAITALL))},
			"MSG_WAITSTREAM":                     {"untyped int", constant.MakeInt64(int64(q.MSG_WAITSTREAM))},
			"MS_ASYNC":                           {"untyped int", constant.MakeInt64(int64(q.MS_ASYNC))},
			"MS_DEACTIVATE":                      {"untyped int", constant.MakeInt64(int64(q.MS_DEACTIVATE))},
			"MS_INVALIDATE":                      {"untyped int", constant.MakeInt64(int64(q.MS_INVALIDATE))},
			"MS_KILLPAGES":                       {"untyped int", constant.MakeInt64(int64(q.MS_KILLPAGES))},
			"MS_SYNC":                            {"untyped int", constant.MakeInt64(int64(q.MS_SYNC))},
			"NAME_MAX":                           {"untyped int", constant.MakeInt64(int64(q.NAME_MAX))},
			"NET_RT_DUMP":                        {"untyped int", constant.MakeInt64(int64(q.NET_RT_DUMP))},
			"NET_RT_DUMP2":                       {"untyped int", constant.MakeInt64(int64(q.NET_RT_DUMP2))},
			"NET_RT_FLAGS":                       {"untyped int", constant.MakeInt64(int64(q.NET_RT_FLAGS))},
			"NET_RT_IFLIST":                      {"untyped int", constant.MakeInt64(int64(q.NET_RT_IFLIST))},
			"NET_RT_IFLIST2":                     {"untyped int", constant.MakeInt64(int64(q.NET_RT_IFLIST2))},
			"NET_RT_MAXID":                       {"untyped int", constant.MakeInt64(int64(q.NET_RT_MAXID))},
			"NET_RT_STAT":                        {"untyped int", constant.MakeInt64(int64(q.NET_RT_STAT))},
			"NET_RT_TRASH":                       {"untyped int", constant.MakeInt64(int64(q.NET_RT_TRASH))},
			"NOFLSH":                             {"untyped int", constant.MakeInt64(int64(q.NOFLSH))},
			"NOTE_ABSOLUTE":                      {"untyped int", constant.MakeInt64(int64(q.NOTE_ABSOLUTE))},
			"NOTE_ATTRIB":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_ATTRIB))},
			"NOTE_CHILD":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_CHILD))},
			"NOTE_DELETE":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_DELETE))},
			"NOTE_EXEC":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_EXEC))},
			"NOTE_EXIT":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_EXIT))},
			"NOTE_EXITSTATUS":                    {"untyped int", constant.MakeInt64(int64(q.NOTE_EXITSTATUS))},
			"NOTE_EXTEND":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_EXTEND))},
			"NOTE_FFAND":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_FFAND))},
			"NOTE_FFCOPY":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_FFCOPY))},
			"NOTE_FFCTRLMASK":                    {"untyped int", constant.MakeInt64(int64(q.NOTE_FFCTRLMASK))},
			"NOTE_FFLAGSMASK":                    {"untyped int", constant.MakeInt64(int64(q.NOTE_FFLAGSMASK))},
			"NOTE_FFNOP":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_FFNOP))},
			"NOTE_FFOR":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_FFOR))},
			"NOTE_FORK":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_FORK))},
			"NOTE_LINK":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_LINK))},
			"NOTE_LOWAT":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_LOWAT))},
			"NOTE_NONE":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_NONE))},
			"NOTE_NSECONDS":                      {"untyped int", constant.MakeInt64(int64(q.NOTE_NSECONDS))},
			"NOTE_PCTRLMASK":                     {"untyped int", constant.MakeInt64(int64(q.NOTE_PCTRLMASK))},
			"NOTE_PDATAMASK":                     {"untyped int", constant.MakeInt64(int64(q.NOTE_PDATAMASK))},
			"NOTE_REAP":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_REAP))},
			"NOTE_RENAME":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_RENAME))},
			"NOTE_RESOURCEEND":                   {"untyped int", constant.MakeInt64(int64(q.NOTE_RESOURCEEND))},
			"NOTE_REVOKE":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_REVOKE))},
			"NOTE_SECONDS":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_SECONDS))},
			"NOTE_SIGNAL":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_SIGNAL))},
			"NOTE_TRACK":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_TRACK))},
			"NOTE_TRACKERR":                      {"untyped int", constant.MakeInt64(int64(q.NOTE_TRACKERR))},
			"NOTE_TRIGGER":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_TRIGGER))},
			"NOTE_USECONDS":                      {"untyped int", constant.MakeInt64(int64(q.NOTE_USECONDS))},
			"NOTE_VM_ERROR":                      {"untyped int", constant.MakeInt64(int64(q.NOTE_VM_ERROR))},
			"NOTE_VM_PRESSURE":                   {"untyped int", constant.MakeInt64(int64(q.NOTE_VM_PRESSURE))},
			"NOTE_VM_PRESSURE_SUDDEN_TERMINATE":  {"untyped int", constant.MakeInt64(int64(q.NOTE_VM_PRESSURE_SUDDEN_TERMINATE))},
			"NOTE_VM_PRESSURE_TERMINATE":         {"untyped int", constant.MakeInt64(int64(q.NOTE_VM_PRESSURE_TERMINATE))},
			"NOTE_WRITE":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_WRITE))},
			"OCRNL":                              {"untyped int", constant.MakeInt64(int64(q.OCRNL))},
			"OFDEL":                              {"untyped int", constant.MakeInt64(int64(q.OFDEL))},
			"OFILL":                              {"untyped int", constant.MakeInt64(int64(q.OFILL))},
			"ONLCR":                              {"untyped int", constant.MakeInt64(int64(q.ONLCR))},
			"ONLRET":                             {"untyped int", constant.MakeInt64(int64(q.ONLRET))},
			"ONOCR":                              {"untyped int", constant.MakeInt64(int64(q.ONOCR))},
			"ONOEOT":                             {"untyped int", constant.MakeInt64(int64(q.ONOEOT))},
			"OPOST":                              {"untyped int", constant.MakeInt64(int64(q.OPOST))},
			"O_ACCMODE":                          {"untyped int", constant.MakeInt64(int64(q.O_ACCMODE))},
			"O_ALERT":                            {"untyped int", constant.MakeInt64(int64(q.O_ALERT))},
			"O_APPEND":                           {"untyped int", constant.MakeInt64(int64(q.O_APPEND))},
			"O_ASYNC":                            {"untyped int", constant.MakeInt64(int64(q.O_ASYNC))},
			"O_CLOEXEC":                          {"untyped int", constant.MakeInt64(int64(q.O_CLOEXEC))},
			"O_CREAT":                            {"untyped int", constant.MakeInt64(int64(q.O_CREAT))},
			"O_DIRECTORY":                        {"untyped int", constant.MakeInt64(int64(q.O_DIRECTORY))},
			"O_DSYNC":                            {"untyped int", constant.MakeInt64(int64(q.O_DSYNC))},
			"O_EVTONLY":                          {"untyped int", constant.MakeInt64(int64(q.O_EVTONLY))},
			"O_EXCL":                             {"untyped int", constant.MakeInt64(int64(q.O_EXCL))},
			"O_EXLOCK":                           {"untyped int", constant.MakeInt64(int64(q.O_EXLOCK))},
			"O_FSYNC":                            {"untyped int", constant.MakeInt64(int64(q.O_FSYNC))},
			"O_NDELAY":                           {"untyped int", constant.MakeInt64(int64(q.O_NDELAY))},
			"O_NOCTTY":                           {"untyped int", constant.MakeInt64(int64(q.O_NOCTTY))},
			"O_NOFOLLOW":                         {"untyped int", constant.MakeInt64(int64(q.O_NOFOLLOW))},
			"O_NONBLOCK":                         {"untyped int", constant.MakeInt64(int64(q.O_NONBLOCK))},
			"O_POPUP":                            {"untyped int", constant.MakeInt64(int64(q.O_POPUP))},
			"O_RDONLY":                           {"untyped int", constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":                             {"untyped int", constant.MakeInt64(int64(q.O_RDWR))},
			"O_SHLOCK":                           {"untyped int", constant.MakeInt64(int64(q.O_SHLOCK))},
			"O_SYMLINK":                          {"untyped int", constant.MakeInt64(int64(q.O_SYMLINK))},
			"O_SYNC":                             {"untyped int", constant.MakeInt64(int64(q.O_SYNC))},
			"O_TRUNC":                            {"untyped int", constant.MakeInt64(int64(q.O_TRUNC))},
			"O_WRONLY":                           {"untyped int", constant.MakeInt64(int64(q.O_WRONLY))},
			"PARENB":                             {"untyped int", constant.MakeInt64(int64(q.PARENB))},
			"PARMRK":                             {"untyped int", constant.MakeInt64(int64(q.PARMRK))},
			"PARODD":                             {"untyped int", constant.MakeInt64(int64(q.PARODD))},
			"PENDIN":                             {"untyped int", constant.MakeInt64(int64(q.PENDIN))},
			"PRIO_PGRP":                          {"untyped int", constant.MakeInt64(int64(q.PRIO_PGRP))},
			"PRIO_PROCESS":                       {"untyped int", constant.MakeInt64(int64(q.PRIO_PROCESS))},
			"PRIO_USER":                          {"untyped int", constant.MakeInt64(int64(q.PRIO_USER))},
			"PROT_EXEC":                          {"untyped int", constant.MakeInt64(int64(q.PROT_EXEC))},
			"PROT_NONE":                          {"untyped int", constant.MakeInt64(int64(q.PROT_NONE))},
			"PROT_READ":                          {"untyped int", constant.MakeInt64(int64(q.PROT_READ))},
			"PROT_WRITE":                         {"untyped int", constant.MakeInt64(int64(q.PROT_WRITE))},
			"PTRACE_CONT":                        {"untyped int", constant.MakeInt64(int64(q.PTRACE_CONT))},
			"PTRACE_KILL":                        {"untyped int", constant.MakeInt64(int64(q.PTRACE_KILL))},
			"PTRACE_TRACEME":                     {"untyped int", constant.MakeInt64(int64(q.PTRACE_TRACEME))},
			"PT_ATTACH":                          {"untyped int", constant.MakeInt64(int64(q.PT_ATTACH))},
			"PT_ATTACHEXC":                       {"untyped int", constant.MakeInt64(int64(q.PT_ATTACHEXC))},
			"PT_CONTINUE":                        {"untyped int", constant.MakeInt64(int64(q.PT_CONTINUE))},
			"PT_DENY_ATTACH":                     {"untyped int", constant.MakeInt64(int64(q.PT_DENY_ATTACH))},
			"PT_DETACH":                          {"untyped int", constant.MakeInt64(int64(q.PT_DETACH))},
			"PT_FIRSTMACH":                       {"untyped int", constant.MakeInt64(int64(q.PT_FIRSTMACH))},
			"PT_FORCEQUOTA":                      {"untyped int", constant.MakeInt64(int64(q.PT_FORCEQUOTA))},
			"PT_KILL":                            {"untyped int", constant.MakeInt64(int64(q.PT_KILL))},
			"PT_READ_D":                          {"untyped int", constant.MakeInt64(int64(q.PT_READ_D))},
			"PT_READ_I":                          {"untyped int", constant.MakeInt64(int64(q.PT_READ_I))},
			"PT_READ_U":                          {"untyped int", constant.MakeInt64(int64(q.PT_READ_U))},
			"PT_SIGEXC":                          {"untyped int", constant.MakeInt64(int64(q.PT_SIGEXC))},
			"PT_STEP":                            {"untyped int", constant.MakeInt64(int64(q.PT_STEP))},
			"PT_THUPDATE":                        {"untyped int", constant.MakeInt64(int64(q.PT_THUPDATE))},
			"PT_TRACE_ME":                        {"untyped int", constant.MakeInt64(int64(q.PT_TRACE_ME))},
			"PT_WRITE_D":                         {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_D))},
			"PT_WRITE_I":                         {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_I))},
			"PT_WRITE_U":                         {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_U))},
			"RLIMIT_AS":                          {"untyped int", constant.MakeInt64(int64(q.RLIMIT_AS))},
			"RLIMIT_CORE":                        {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CORE))},
			"RLIMIT_CPU":                         {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CPU))},
			"RLIMIT_DATA":                        {"untyped int", constant.MakeInt64(int64(q.RLIMIT_DATA))},
			"RLIMIT_FSIZE":                       {"untyped int", constant.MakeInt64(int64(q.RLIMIT_FSIZE))},
			"RLIMIT_NOFILE":                      {"untyped int", constant.MakeInt64(int64(q.RLIMIT_NOFILE))},
			"RLIMIT_STACK":                       {"untyped int", constant.MakeInt64(int64(q.RLIMIT_STACK))},
			"RLIM_INFINITY":                      {"untyped int", constant.MakeInt64(int64(q.RLIM_INFINITY))},
			"RTAX_AUTHOR":                        {"untyped int", constant.MakeInt64(int64(q.RTAX_AUTHOR))},
			"RTAX_BRD":                           {"untyped int", constant.MakeInt64(int64(q.RTAX_BRD))},
			"RTAX_DST":                           {"untyped int", constant.MakeInt64(int64(q.RTAX_DST))},
			"RTAX_GATEWAY":                       {"untyped int", constant.MakeInt64(int64(q.RTAX_GATEWAY))},
			"RTAX_GENMASK":                       {"untyped int", constant.MakeInt64(int64(q.RTAX_GENMASK))},
			"RTAX_IFA":                           {"untyped int", constant.MakeInt64(int64(q.RTAX_IFA))},
			"RTAX_IFP":                           {"untyped int", constant.MakeInt64(int64(q.RTAX_IFP))},
			"RTAX_MAX":                           {"untyped int", constant.MakeInt64(int64(q.RTAX_MAX))},
			"RTAX_NETMASK":                       {"untyped int", constant.MakeInt64(int64(q.RTAX_NETMASK))},
			"RTA_AUTHOR":                         {"untyped int", constant.MakeInt64(int64(q.RTA_AUTHOR))},
			"RTA_BRD":                            {"untyped int", constant.MakeInt64(int64(q.RTA_BRD))},
			"RTA_DST":                            {"untyped int", constant.MakeInt64(int64(q.RTA_DST))},
			"RTA_GATEWAY":                        {"untyped int", constant.MakeInt64(int64(q.RTA_GATEWAY))},
			"RTA_GENMASK":                        {"untyped int", constant.MakeInt64(int64(q.RTA_GENMASK))},
			"RTA_IFA":                            {"untyped int", constant.MakeInt64(int64(q.RTA_IFA))},
			"RTA_IFP":                            {"untyped int", constant.MakeInt64(int64(q.RTA_IFP))},
			"RTA_NETMASK":                        {"untyped int", constant.MakeInt64(int64(q.RTA_NETMASK))},
			"RTF_BLACKHOLE":                      {"untyped int", constant.MakeInt64(int64(q.RTF_BLACKHOLE))},
			"RTF_BROADCAST":                      {"untyped int", constant.MakeInt64(int64(q.RTF_BROADCAST))},
			"RTF_CLONING":                        {"untyped int", constant.MakeInt64(int64(q.RTF_CLONING))},
			"RTF_CONDEMNED":                      {"untyped int", constant.MakeInt64(int64(q.RTF_CONDEMNED))},
			"RTF_DELCLONE":                       {"untyped int", constant.MakeInt64(int64(q.RTF_DELCLONE))},
			"RTF_DONE":                           {"untyped int", constant.MakeInt64(int64(q.RTF_DONE))},
			"RTF_DYNAMIC":                        {"untyped int", constant.MakeInt64(int64(q.RTF_DYNAMIC))},
			"RTF_GATEWAY":                        {"untyped int", constant.MakeInt64(int64(q.RTF_GATEWAY))},
			"RTF_HOST":                           {"untyped int", constant.MakeInt64(int64(q.RTF_HOST))},
			"RTF_IFREF":                          {"untyped int", constant.MakeInt64(int64(q.RTF_IFREF))},
			"RTF_IFSCOPE":                        {"untyped int", constant.MakeInt64(int64(q.RTF_IFSCOPE))},
			"RTF_LLINFO":                         {"untyped int", constant.MakeInt64(int64(q.RTF_LLINFO))},
			"RTF_LOCAL":                          {"untyped int", constant.MakeInt64(int64(q.RTF_LOCAL))},
			"RTF_MODIFIED":                       {"untyped int", constant.MakeInt64(int64(q.RTF_MODIFIED))},
			"RTF_MULTICAST":                      {"untyped int", constant.MakeInt64(int64(q.RTF_MULTICAST))},
			"RTF_PINNED":                         {"untyped int", constant.MakeInt64(int64(q.RTF_PINNED))},
			"RTF_PRCLONING":                      {"untyped int", constant.MakeInt64(int64(q.RTF_PRCLONING))},
			"RTF_PROTO1":                         {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO1))},
			"RTF_PROTO2":                         {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO2))},
			"RTF_PROTO3":                         {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO3))},
			"RTF_REJECT":                         {"untyped int", constant.MakeInt64(int64(q.RTF_REJECT))},
			"RTF_STATIC":                         {"untyped int", constant.MakeInt64(int64(q.RTF_STATIC))},
			"RTF_UP":                             {"untyped int", constant.MakeInt64(int64(q.RTF_UP))},
			"RTF_WASCLONED":                      {"untyped int", constant.MakeInt64(int64(q.RTF_WASCLONED))},
			"RTF_XRESOLVE":                       {"untyped int", constant.MakeInt64(int64(q.RTF_XRESOLVE))},
			"RTM_ADD":                            {"untyped int", constant.MakeInt64(int64(q.RTM_ADD))},
			"RTM_CHANGE":                         {"untyped int", constant.MakeInt64(int64(q.RTM_CHANGE))},
			"RTM_DELADDR":                        {"untyped int", constant.MakeInt64(int64(q.RTM_DELADDR))},
			"RTM_DELETE":                         {"untyped int", constant.MakeInt64(int64(q.RTM_DELETE))},
			"RTM_DELMADDR":                       {"untyped int", constant.MakeInt64(int64(q.RTM_DELMADDR))},
			"RTM_GET":                            {"untyped int", constant.MakeInt64(int64(q.RTM_GET))},
			"RTM_GET2":                           {"untyped int", constant.MakeInt64(int64(q.RTM_GET2))},
			"RTM_IFINFO":                         {"untyped int", constant.MakeInt64(int64(q.RTM_IFINFO))},
			"RTM_IFINFO2":                        {"untyped int", constant.MakeInt64(int64(q.RTM_IFINFO2))},
			"RTM_LOCK":                           {"untyped int", constant.MakeInt64(int64(q.RTM_LOCK))},
			"RTM_LOSING":                         {"untyped int", constant.MakeInt64(int64(q.RTM_LOSING))},
			"RTM_MISS":                           {"untyped int", constant.MakeInt64(int64(q.RTM_MISS))},
			"RTM_NEWADDR":                        {"untyped int", constant.MakeInt64(int64(q.RTM_NEWADDR))},
			"RTM_NEWMADDR":                       {"untyped int", constant.MakeInt64(int64(q.RTM_NEWMADDR))},
			"RTM_NEWMADDR2":                      {"untyped int", constant.MakeInt64(int64(q.RTM_NEWMADDR2))},
			"RTM_OLDADD":                         {"untyped int", constant.MakeInt64(int64(q.RTM_OLDADD))},
			"RTM_OLDDEL":                         {"untyped int", constant.MakeInt64(int64(q.RTM_OLDDEL))},
			"RTM_REDIRECT":                       {"untyped int", constant.MakeInt64(int64(q.RTM_REDIRECT))},
			"RTM_RESOLVE":                        {"untyped int", constant.MakeInt64(int64(q.RTM_RESOLVE))},
			"RTM_RTTUNIT":                        {"untyped int", constant.MakeInt64(int64(q.RTM_RTTUNIT))},
			"RTM_VERSION":                        {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION))},
			"RTV_EXPIRE":                         {"untyped int", constant.MakeInt64(int64(q.RTV_EXPIRE))},
			"RTV_HOPCOUNT":                       {"untyped int", constant.MakeInt64(int64(q.RTV_HOPCOUNT))},
			"RTV_MTU":                            {"untyped int", constant.MakeInt64(int64(q.RTV_MTU))},
			"RTV_RPIPE":                          {"untyped int", constant.MakeInt64(int64(q.RTV_RPIPE))},
			"RTV_RTT":                            {"untyped int", constant.MakeInt64(int64(q.RTV_RTT))},
			"RTV_RTTVAR":                         {"untyped int", constant.MakeInt64(int64(q.RTV_RTTVAR))},
			"RTV_SPIPE":                          {"untyped int", constant.MakeInt64(int64(q.RTV_SPIPE))},
			"RTV_SSTHRESH":                       {"untyped int", constant.MakeInt64(int64(q.RTV_SSTHRESH))},
			"RUSAGE_CHILDREN":                    {"untyped int", constant.MakeInt64(int64(q.RUSAGE_CHILDREN))},
			"RUSAGE_SELF":                        {"untyped int", constant.MakeInt64(int64(q.RUSAGE_SELF))},
			"SCM_CREDS":                          {"untyped int", constant.MakeInt64(int64(q.SCM_CREDS))},
			"SCM_RIGHTS":                         {"untyped int", constant.MakeInt64(int64(q.SCM_RIGHTS))},
			"SCM_TIMESTAMP":                      {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMP))},
			"SCM_TIMESTAMP_MONOTONIC":            {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMP_MONOTONIC))},
			"SHUT_RD":                            {"untyped int", constant.MakeInt64(int64(q.SHUT_RD))},
			"SHUT_RDWR":                          {"untyped int", constant.MakeInt64(int64(q.SHUT_RDWR))},
			"SHUT_WR":                            {"untyped int", constant.MakeInt64(int64(q.SHUT_WR))},
			"SIOCADDMULTI":                       {"untyped int", constant.MakeInt64(int64(q.SIOCADDMULTI))},
			"SIOCAIFADDR":                        {"untyped int", constant.MakeInt64(int64(q.SIOCAIFADDR))},
			"SIOCALIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCALIFADDR))},
			"SIOCARPIPLL":                        {"untyped int", constant.MakeInt64(int64(q.SIOCARPIPLL))},
			"SIOCATMARK":                         {"untyped int", constant.MakeInt64(int64(q.SIOCATMARK))},
			"SIOCAUTOADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCAUTOADDR))},
			"SIOCAUTONETMASK":                    {"untyped int", constant.MakeInt64(int64(q.SIOCAUTONETMASK))},
			"SIOCDELMULTI":                       {"untyped int", constant.MakeInt64(int64(q.SIOCDELMULTI))},
			"SIOCDIFADDR":                        {"untyped int", constant.MakeInt64(int64(q.SIOCDIFADDR))},
			"SIOCDIFPHYADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCDIFPHYADDR))},
			"SIOCDLIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCDLIFADDR))},
			"SIOCGDRVSPEC":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGDRVSPEC))},
			"SIOCGETSGCNT":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGETSGCNT))},
			"SIOCGETVIFCNT":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGETVIFCNT))},
			"SIOCGETVLAN":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGETVLAN))},
			"SIOCGHIWAT":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGHIWAT))},
			"SIOCGIFADDR":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFADDR))},
			"SIOCGIFALTMTU":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFALTMTU))},
			"SIOCGIFASYNCMAP":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFASYNCMAP))},
			"SIOCGIFBOND":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBOND))},
			"SIOCGIFBRDADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBRDADDR))},
			"SIOCGIFCAP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCAP))},
			"SIOCGIFCONF":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCONF))},
			"SIOCGIFDEVMTU":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDEVMTU))},
			"SIOCGIFDSTADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDSTADDR))},
			"SIOCGIFFLAGS":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFFLAGS))},
			"SIOCGIFGENERIC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGENERIC))},
			"SIOCGIFKPI":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGIFKPI))},
			"SIOCGIFMAC":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMAC))},
			"SIOCGIFMEDIA":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMEDIA))},
			"SIOCGIFMETRIC":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMETRIC))},
			"SIOCGIFMTU":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMTU))},
			"SIOCGIFNETMASK":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNETMASK))},
			"SIOCGIFPDSTADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPDSTADDR))},
			"SIOCGIFPHYS":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPHYS))},
			"SIOCGIFPSRCADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPSRCADDR))},
			"SIOCGIFSTATUS":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFSTATUS))},
			"SIOCGIFVLAN":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFVLAN))},
			"SIOCGIFWAKEFLAGS":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFWAKEFLAGS))},
			"SIOCGLIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFADDR))},
			"SIOCGLIFPHYADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFPHYADDR))},
			"SIOCGLOWAT":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGLOWAT))},
			"SIOCGPGRP":                          {"untyped int", constant.MakeInt64(int64(q.SIOCGPGRP))},
			"SIOCIFCREATE":                       {"untyped int", constant.MakeInt64(int64(q.SIOCIFCREATE))},
			"SIOCIFCREATE2":                      {"untyped int", constant.MakeInt64(int64(q.SIOCIFCREATE2))},
			"SIOCIFDESTROY":                      {"untyped int", constant.MakeInt64(int64(q.SIOCIFDESTROY))},
			"SIOCRSLVMULTI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCRSLVMULTI))},
			"SIOCSDRVSPEC":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSDRVSPEC))},
			"SIOCSETVLAN":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSETVLAN))},
			"SIOCSHIWAT":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSHIWAT))},
			"SIOCSIFADDR":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFADDR))},
			"SIOCSIFALTMTU":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFALTMTU))},
			"SIOCSIFASYNCMAP":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFASYNCMAP))},
			"SIOCSIFBOND":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBOND))},
			"SIOCSIFBRDADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBRDADDR))},
			"SIOCSIFCAP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSIFCAP))},
			"SIOCSIFDSTADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFDSTADDR))},
			"SIOCSIFFLAGS":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFFLAGS))},
			"SIOCSIFGENERIC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFGENERIC))},
			"SIOCSIFKPI":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSIFKPI))},
			"SIOCSIFLLADDR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFLLADDR))},
			"SIOCSIFMAC":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMAC))},
			"SIOCSIFMEDIA":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMEDIA))},
			"SIOCSIFMETRIC":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMETRIC))},
			"SIOCSIFMTU":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMTU))},
			"SIOCSIFNETMASK":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNETMASK))},
			"SIOCSIFPHYADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPHYADDR))},
			"SIOCSIFPHYS":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPHYS))},
			"SIOCSIFVLAN":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFVLAN))},
			"SIOCSLIFPHYADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPHYADDR))},
			"SIOCSLOWAT":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSLOWAT))},
			"SIOCSPGRP":                          {"untyped int", constant.MakeInt64(int64(q.SIOCSPGRP))},
			"SOCK_DGRAM":                         {"untyped int", constant.MakeInt64(int64(q.SOCK_DGRAM))},
			"SOCK_MAXADDRLEN":                    {"untyped int", constant.MakeInt64(int64(q.SOCK_MAXADDRLEN))},
			"SOCK_RAW":                           {"untyped int", constant.MakeInt64(int64(q.SOCK_RAW))},
			"SOCK_RDM":                           {"untyped int", constant.MakeInt64(int64(q.SOCK_RDM))},
			"SOCK_SEQPACKET":                     {"untyped int", constant.MakeInt64(int64(q.SOCK_SEQPACKET))},
			"SOCK_STREAM":                        {"untyped int", constant.MakeInt64(int64(q.SOCK_STREAM))},
			"SOL_SOCKET":                         {"untyped int", constant.MakeInt64(int64(q.SOL_SOCKET))},
			"SOMAXCONN":                          {"untyped int", constant.MakeInt64(int64(q.SOMAXCONN))},
			"SO_ACCEPTCONN":                      {"untyped int", constant.MakeInt64(int64(q.SO_ACCEPTCONN))},
			"SO_BROADCAST":                       {"untyped int", constant.MakeInt64(int64(q.SO_BROADCAST))},
			"SO_DEBUG":                           {"untyped int", constant.MakeInt64(int64(q.SO_DEBUG))},
			"SO_DONTROUTE":                       {"untyped int", constant.MakeInt64(int64(q.SO_DONTROUTE))},
			"SO_DONTTRUNC":                       {"untyped int", constant.MakeInt64(int64(q.SO_DONTTRUNC))},
			"SO_ERROR":                           {"untyped int", constant.MakeInt64(int64(q.SO_ERROR))},
			"SO_KEEPALIVE":                       {"untyped int", constant.MakeInt64(int64(q.SO_KEEPALIVE))},
			"SO_LABEL":                           {"untyped int", constant.MakeInt64(int64(q.SO_LABEL))},
			"SO_LINGER":                          {"untyped int", constant.MakeInt64(int64(q.SO_LINGER))},
			"SO_LINGER_SEC":                      {"untyped int", constant.MakeInt64(int64(q.SO_LINGER_SEC))},
			"SO_NKE":                             {"untyped int", constant.MakeInt64(int64(q.SO_NKE))},
			"SO_NOADDRERR":                       {"untyped int", constant.MakeInt64(int64(q.SO_NOADDRERR))},
			"SO_NOSIGPIPE":                       {"untyped int", constant.MakeInt64(int64(q.SO_NOSIGPIPE))},
			"SO_NOTIFYCONFLICT":                  {"untyped int", constant.MakeInt64(int64(q.SO_NOTIFYCONFLICT))},
			"SO_NP_EXTENSIONS":                   {"untyped int", constant.MakeInt64(int64(q.SO_NP_EXTENSIONS))},
			"SO_NREAD":                           {"untyped int", constant.MakeInt64(int64(q.SO_NREAD))},
			"SO_NWRITE":                          {"untyped int", constant.MakeInt64(int64(q.SO_NWRITE))},
			"SO_OOBINLINE":                       {"untyped int", constant.MakeInt64(int64(q.SO_OOBINLINE))},
			"SO_PEERLABEL":                       {"untyped int", constant.MakeInt64(int64(q.SO_PEERLABEL))},
			"SO_RANDOMPORT":                      {"untyped int", constant.MakeInt64(int64(q.SO_RANDOMPORT))},
			"SO_RCVBUF":                          {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUF))},
			"SO_RCVLOWAT":                        {"untyped int", constant.MakeInt64(int64(q.SO_RCVLOWAT))},
			"SO_RCVTIMEO":                        {"untyped int", constant.MakeInt64(int64(q.SO_RCVTIMEO))},
			"SO_RESTRICTIONS":                    {"untyped int", constant.MakeInt64(int64(q.SO_RESTRICTIONS))},
			"SO_RESTRICT_DENYIN":                 {"untyped int", constant.MakeInt64(int64(q.SO_RESTRICT_DENYIN))},
			"SO_RESTRICT_DENYOUT":                {"untyped int", constant.MakeInt64(int64(q.SO_RESTRICT_DENYOUT))},
			"SO_RESTRICT_DENYSET":                {"untyped int", constant.MakeInt64(int64(q.SO_RESTRICT_DENYSET))},
			"SO_REUSEADDR":                       {"untyped int", constant.MakeInt64(int64(q.SO_REUSEADDR))},
			"SO_REUSEPORT":                       {"untyped int", constant.MakeInt64(int64(q.SO_REUSEPORT))},
			"SO_REUSESHAREUID":                   {"untyped int", constant.MakeInt64(int64(q.SO_REUSESHAREUID))},
			"SO_SNDBUF":                          {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUF))},
			"SO_SNDLOWAT":                        {"untyped int", constant.MakeInt64(int64(q.SO_SNDLOWAT))},
			"SO_SNDTIMEO":                        {"untyped int", constant.MakeInt64(int64(q.SO_SNDTIMEO))},
			"SO_TIMESTAMP":                       {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMP))},
			"SO_TIMESTAMP_MONOTONIC":             {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMP_MONOTONIC))},
			"SO_TYPE":                            {"untyped int", constant.MakeInt64(int64(q.SO_TYPE))},
			"SO_UPCALLCLOSEWAIT":                 {"untyped int", constant.MakeInt64(int64(q.SO_UPCALLCLOSEWAIT))},
			"SO_USELOOPBACK":                     {"untyped int", constant.MakeInt64(int64(q.SO_USELOOPBACK))},
			"SO_WANTMORE":                        {"untyped int", constant.MakeInt64(int64(q.SO_WANTMORE))},
			"SO_WANTOOBFLAG":                     {"untyped int", constant.MakeInt64(int64(q.SO_WANTOOBFLAG))},
			"SYS_ACCEPT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_ACCEPT))},
			"SYS_ACCEPT_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_ACCEPT_NOCANCEL))},
			"SYS_ACCESS":                         {"untyped int", constant.MakeInt64(int64(q.SYS_ACCESS))},
			"SYS_ACCESS_EXTENDED":                {"untyped int", constant.MakeInt64(int64(q.SYS_ACCESS_EXTENDED))},
			"SYS_ACCT":                           {"untyped int", constant.MakeInt64(int64(q.SYS_ACCT))},
			"SYS_ADD_PROFIL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_ADD_PROFIL))},
			"SYS_ADJTIME":                        {"untyped int", constant.MakeInt64(int64(q.SYS_ADJTIME))},
			"SYS_AIO_CANCEL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_CANCEL))},
			"SYS_AIO_ERROR":                      {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_ERROR))},
			"SYS_AIO_FSYNC":                      {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_FSYNC))},
			"SYS_AIO_READ":                       {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_READ))},
			"SYS_AIO_RETURN":                     {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_RETURN))},
			"SYS_AIO_SUSPEND":                    {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_SUSPEND))},
			"SYS_AIO_SUSPEND_NOCANCEL":           {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_SUSPEND_NOCANCEL))},
			"SYS_AIO_WRITE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_WRITE))},
			"SYS_ATGETMSG":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ATGETMSG))},
			"SYS_ATPGETREQ":                      {"untyped int", constant.MakeInt64(int64(q.SYS_ATPGETREQ))},
			"SYS_ATPGETRSP":                      {"untyped int", constant.MakeInt64(int64(q.SYS_ATPGETRSP))},
			"SYS_ATPSNDREQ":                      {"untyped int", constant.MakeInt64(int64(q.SYS_ATPSNDREQ))},
			"SYS_ATPSNDRSP":                      {"untyped int", constant.MakeInt64(int64(q.SYS_ATPSNDRSP))},
			"SYS_ATPUTMSG":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ATPUTMSG))},
			"SYS_ATSOCKET":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ATSOCKET))},
			"SYS_AUDIT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_AUDIT))},
			"SYS_AUDITCTL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_AUDITCTL))},
			"SYS_AUDITON":                        {"untyped int", constant.MakeInt64(int64(q.SYS_AUDITON))},
			"SYS_AUDIT_SESSION_JOIN":             {"untyped int", constant.MakeInt64(int64(q.SYS_AUDIT_SESSION_JOIN))},
			"SYS_AUDIT_SESSION_PORT":             {"untyped int", constant.MakeInt64(int64(q.SYS_AUDIT_SESSION_PORT))},
			"SYS_AUDIT_SESSION_SELF":             {"untyped int", constant.MakeInt64(int64(q.SYS_AUDIT_SESSION_SELF))},
			"SYS_BIND":                           {"untyped int", constant.MakeInt64(int64(q.SYS_BIND))},
			"SYS_BSDTHREAD_CREATE":               {"untyped int", constant.MakeInt64(int64(q.SYS_BSDTHREAD_CREATE))},
			"SYS_BSDTHREAD_REGISTER":             {"untyped int", constant.MakeInt64(int64(q.SYS_BSDTHREAD_REGISTER))},
			"SYS_BSDTHREAD_TERMINATE":            {"untyped int", constant.MakeInt64(int64(q.SYS_BSDTHREAD_TERMINATE))},
			"SYS_CHDIR":                          {"untyped int", constant.MakeInt64(int64(q.SYS_CHDIR))},
			"SYS_CHFLAGS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CHFLAGS))},
			"SYS_CHMOD":                          {"untyped int", constant.MakeInt64(int64(q.SYS_CHMOD))},
			"SYS_CHMOD_EXTENDED":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CHMOD_EXTENDED))},
			"SYS_CHOWN":                          {"untyped int", constant.MakeInt64(int64(q.SYS_CHOWN))},
			"SYS_CHROOT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CHROOT))},
			"SYS_CHUD":                           {"untyped int", constant.MakeInt64(int64(q.SYS_CHUD))},
			"SYS_CLOSE":                          {"untyped int", constant.MakeInt64(int64(q.SYS_CLOSE))},
			"SYS_CLOSE_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CLOSE_NOCANCEL))},
			"SYS_CONNECT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CONNECT))},
			"SYS_CONNECT_NOCANCEL":               {"untyped int", constant.MakeInt64(int64(q.SYS_CONNECT_NOCANCEL))},
			"SYS_COPYFILE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_COPYFILE))},
			"SYS_CSOPS":                          {"untyped int", constant.MakeInt64(int64(q.SYS_CSOPS))},
			"SYS_DELETE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_DELETE))},
			"SYS_DUP":                            {"untyped int", constant.MakeInt64(int64(q.SYS_DUP))},
			"SYS_DUP2":                           {"untyped int", constant.MakeInt64(int64(q.SYS_DUP2))},
			"SYS_EXCHANGEDATA":                   {"untyped int", constant.MakeInt64(int64(q.SYS_EXCHANGEDATA))},
			"SYS_EXECVE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_EXECVE))},
			"SYS_EXIT":                           {"untyped int", constant.MakeInt64(int64(q.SYS_EXIT))},
			"SYS_FCHDIR":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FCHDIR))},
			"SYS_FCHFLAGS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FCHFLAGS))},
			"SYS_FCHMOD":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMOD))},
			"SYS_FCHMOD_EXTENDED":                {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMOD_EXTENDED))},
			"SYS_FCHOWN":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FCHOWN))},
			"SYS_FCNTL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_FCNTL))},
			"SYS_FCNTL_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_FCNTL_NOCANCEL))},
			"SYS_FDATASYNC":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FDATASYNC))},
			"SYS_FFSCTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FFSCTL))},
			"SYS_FGETATTRLIST":                   {"untyped int", constant.MakeInt64(int64(q.SYS_FGETATTRLIST))},
			"SYS_FGETXATTR":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FGETXATTR))},
			"SYS_FHOPEN":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FHOPEN))},
			"SYS_FILEPORT_MAKEFD":                {"untyped int", constant.MakeInt64(int64(q.SYS_FILEPORT_MAKEFD))},
			"SYS_FILEPORT_MAKEPORT":              {"untyped int", constant.MakeInt64(int64(q.SYS_FILEPORT_MAKEPORT))},
			"SYS_FLISTXATTR":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FLISTXATTR))},
			"SYS_FLOCK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_FLOCK))},
			"SYS_FORK":                           {"untyped int", constant.MakeInt64(int64(q.SYS_FORK))},
			"SYS_FPATHCONF":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FPATHCONF))},
			"SYS_FREMOVEXATTR":                   {"untyped int", constant.MakeInt64(int64(q.SYS_FREMOVEXATTR))},
			"SYS_FSCTL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_FSCTL))},
			"SYS_FSETATTRLIST":                   {"untyped int", constant.MakeInt64(int64(q.SYS_FSETATTRLIST))},
			"SYS_FSETXATTR":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FSETXATTR))},
			"SYS_FSGETPATH":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FSGETPATH))},
			"SYS_FSTAT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_FSTAT))},
			"SYS_FSTAT64":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FSTAT64))},
			"SYS_FSTAT64_EXTENDED":               {"untyped int", constant.MakeInt64(int64(q.SYS_FSTAT64_EXTENDED))},
			"SYS_FSTATFS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATFS))},
			"SYS_FSTATFS64":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATFS64))},
			"SYS_FSTATV":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATV))},
			"SYS_FSTAT_EXTENDED":                 {"untyped int", constant.MakeInt64(int64(q.SYS_FSTAT_EXTENDED))},
			"SYS_FSYNC":                          {"untyped int", constant.MakeInt64(int64(q.SYS_FSYNC))},
			"SYS_FSYNC_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_FSYNC_NOCANCEL))},
			"SYS_FTRUNCATE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FTRUNCATE))},
			"SYS_FUTIMES":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FUTIMES))},
			"SYS_GETATTRLIST":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETATTRLIST))},
			"SYS_GETAUDIT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETAUDIT))},
			"SYS_GETAUDIT_ADDR":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETAUDIT_ADDR))},
			"SYS_GETAUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETAUID))},
			"SYS_GETDIRENTRIES":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETDIRENTRIES))},
			"SYS_GETDIRENTRIES64":                {"untyped int", constant.MakeInt64(int64(q.SYS_GETDIRENTRIES64))},
			"SYS_GETDIRENTRIESATTR":              {"untyped int", constant.MakeInt64(int64(q.SYS_GETDIRENTRIESATTR))},
			"SYS_GETDTABLESIZE":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETDTABLESIZE))},
			"SYS_GETEGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETEGID))},
			"SYS_GETEUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETEUID))},
			"SYS_GETFH":                          {"untyped int", constant.MakeInt64(int64(q.SYS_GETFH))},
			"SYS_GETFSSTAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETFSSTAT))},
			"SYS_GETFSSTAT64":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETFSSTAT64))},
			"SYS_GETGID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_GETGID))},
			"SYS_GETGROUPS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETGROUPS))},
			"SYS_GETHOSTUUID":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETHOSTUUID))},
			"SYS_GETITIMER":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETITIMER))},
			"SYS_GETLCID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETLCID))},
			"SYS_GETLOGIN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETLOGIN))},
			"SYS_GETPEERNAME":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETPEERNAME))},
			"SYS_GETPGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGID))},
			"SYS_GETPGRP":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGRP))},
			"SYS_GETPID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_GETPID))},
			"SYS_GETPPID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETPPID))},
			"SYS_GETPRIORITY":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETPRIORITY))},
			"SYS_GETRLIMIT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETRLIMIT))},
			"SYS_GETRUSAGE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETRUSAGE))},
			"SYS_GETSGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETSGROUPS))},
			"SYS_GETSID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_GETSID))},
			"SYS_GETSOCKNAME":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKNAME))},
			"SYS_GETSOCKOPT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKOPT))},
			"SYS_GETTID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_GETTID))},
			"SYS_GETTIMEOFDAY":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETTIMEOFDAY))},
			"SYS_GETUID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_GETUID))},
			"SYS_GETWGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETWGROUPS))},
			"SYS_GETXATTR":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETXATTR))},
			"SYS_IDENTITYSVC":                    {"untyped int", constant.MakeInt64(int64(q.SYS_IDENTITYSVC))},
			"SYS_INITGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_INITGROUPS))},
			"SYS_IOCTL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_IOCTL))},
			"SYS_IOPOLICYSYS":                    {"untyped int", constant.MakeInt64(int64(q.SYS_IOPOLICYSYS))},
			"SYS_ISSETUGID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_ISSETUGID))},
			"SYS_KDEBUG_TRACE":                   {"untyped int", constant.MakeInt64(int64(q.SYS_KDEBUG_TRACE))},
			"SYS_KEVENT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_KEVENT))},
			"SYS_KEVENT64":                       {"untyped int", constant.MakeInt64(int64(q.SYS_KEVENT64))},
			"SYS_KILL":                           {"untyped int", constant.MakeInt64(int64(q.SYS_KILL))},
			"SYS_KQUEUE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_KQUEUE))},
			"SYS_LCHOWN":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LCHOWN))},
			"SYS_LINK":                           {"untyped int", constant.MakeInt64(int64(q.SYS_LINK))},
			"SYS_LIO_LISTIO":                     {"untyped int", constant.MakeInt64(int64(q.SYS_LIO_LISTIO))},
			"SYS_LISTEN":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LISTEN))},
			"SYS_LISTXATTR":                      {"untyped int", constant.MakeInt64(int64(q.SYS_LISTXATTR))},
			"SYS_LSEEK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_LSEEK))},
			"SYS_LSTAT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_LSTAT))},
			"SYS_LSTAT64":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LSTAT64))},
			"SYS_LSTAT64_EXTENDED":               {"untyped int", constant.MakeInt64(int64(q.SYS_LSTAT64_EXTENDED))},
			"SYS_LSTATV":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LSTATV))},
			"SYS_LSTAT_EXTENDED":                 {"untyped int", constant.MakeInt64(int64(q.SYS_LSTAT_EXTENDED))},
			"SYS_MADVISE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MADVISE))},
			"SYS_MAXSYSCALL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_MAXSYSCALL))},
			"SYS_MINCORE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MINCORE))},
			"SYS_MINHERIT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MINHERIT))},
			"SYS_MKCOMPLEX":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MKCOMPLEX))},
			"SYS_MKDIR":                          {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIR))},
			"SYS_MKDIR_EXTENDED":                 {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIR_EXTENDED))},
			"SYS_MKFIFO":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MKFIFO))},
			"SYS_MKFIFO_EXTENDED":                {"untyped int", constant.MakeInt64(int64(q.SYS_MKFIFO_EXTENDED))},
			"SYS_MKNOD":                          {"untyped int", constant.MakeInt64(int64(q.SYS_MKNOD))},
			"SYS_MLOCK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCK))},
			"SYS_MLOCKALL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCKALL))},
			"SYS_MMAP":                           {"untyped int", constant.MakeInt64(int64(q.SYS_MMAP))},
			"SYS_MODWATCH":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MODWATCH))},
			"SYS_MOUNT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_MOUNT))},
			"SYS_MPROTECT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MPROTECT))},
			"SYS_MSGCTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MSGCTL))},
			"SYS_MSGGET":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MSGGET))},
			"SYS_MSGRCV":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MSGRCV))},
			"SYS_MSGRCV_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_MSGRCV_NOCANCEL))},
			"SYS_MSGSND":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MSGSND))},
			"SYS_MSGSND_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_MSGSND_NOCANCEL))},
			"SYS_MSGSYS":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MSGSYS))},
			"SYS_MSYNC":                          {"untyped int", constant.MakeInt64(int64(q.SYS_MSYNC))},
			"SYS_MSYNC_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_MSYNC_NOCANCEL))},
			"SYS_MUNLOCK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCK))},
			"SYS_MUNLOCKALL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCKALL))},
			"SYS_MUNMAP":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MUNMAP))},
			"SYS_NFSCLNT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_NFSCLNT))},
			"SYS_NFSSVC":                         {"untyped int", constant.MakeInt64(int64(q.SYS_NFSSVC))},
			"SYS_OPEN":                           {"untyped int", constant.MakeInt64(int64(q.SYS_OPEN))},
			"SYS_OPEN_EXTENDED":                  {"untyped int", constant.MakeInt64(int64(q.SYS_OPEN_EXTENDED))},
			"SYS_OPEN_NOCANCEL":                  {"untyped int", constant.MakeInt64(int64(q.SYS_OPEN_NOCANCEL))},
			"SYS_PATHCONF":                       {"untyped int", constant.MakeInt64(int64(q.SYS_PATHCONF))},
			"SYS_PID_HIBERNATE":                  {"untyped int", constant.MakeInt64(int64(q.SYS_PID_HIBERNATE))},
			"SYS_PID_RESUME":                     {"untyped int", constant.MakeInt64(int64(q.SYS_PID_RESUME))},
			"SYS_PID_SHUTDOWN_SOCKETS":           {"untyped int", constant.MakeInt64(int64(q.SYS_PID_SHUTDOWN_SOCKETS))},
			"SYS_PID_SUSPEND":                    {"untyped int", constant.MakeInt64(int64(q.SYS_PID_SUSPEND))},
			"SYS_PIPE":                           {"untyped int", constant.MakeInt64(int64(q.SYS_PIPE))},
			"SYS_POLL":                           {"untyped int", constant.MakeInt64(int64(q.SYS_POLL))},
			"SYS_POLL_NOCANCEL":                  {"untyped int", constant.MakeInt64(int64(q.SYS_POLL_NOCANCEL))},
			"SYS_POSIX_SPAWN":                    {"untyped int", constant.MakeInt64(int64(q.SYS_POSIX_SPAWN))},
			"SYS_PREAD":                          {"untyped int", constant.MakeInt64(int64(q.SYS_PREAD))},
			"SYS_PREAD_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_PREAD_NOCANCEL))},
			"SYS_PROCESS_POLICY":                 {"untyped int", constant.MakeInt64(int64(q.SYS_PROCESS_POLICY))},
			"SYS_PROC_INFO":                      {"untyped int", constant.MakeInt64(int64(q.SYS_PROC_INFO))},
			"SYS_PROFIL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PROFIL))},
			"SYS_PSYNCH_CVBROAD":                 {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_CVBROAD))},
			"SYS_PSYNCH_CVCLRPREPOST":            {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_CVCLRPREPOST))},
			"SYS_PSYNCH_CVSIGNAL":                {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_CVSIGNAL))},
			"SYS_PSYNCH_CVWAIT":                  {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_CVWAIT))},
			"SYS_PSYNCH_MUTEXDROP":               {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_MUTEXDROP))},
			"SYS_PSYNCH_MUTEXWAIT":               {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_MUTEXWAIT))},
			"SYS_PSYNCH_RW_DOWNGRADE":            {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_DOWNGRADE))},
			"SYS_PSYNCH_RW_LONGRDLOCK":           {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_LONGRDLOCK))},
			"SYS_PSYNCH_RW_RDLOCK":               {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_RDLOCK))},
			"SYS_PSYNCH_RW_UNLOCK":               {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_UNLOCK))},
			"SYS_PSYNCH_RW_UNLOCK2":              {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_UNLOCK2))},
			"SYS_PSYNCH_RW_UPGRADE":              {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_UPGRADE))},
			"SYS_PSYNCH_RW_WRLOCK":               {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_WRLOCK))},
			"SYS_PSYNCH_RW_YIELDWRLOCK":          {"untyped int", constant.MakeInt64(int64(q.SYS_PSYNCH_RW_YIELDWRLOCK))},
			"SYS_PTRACE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PTRACE))},
			"SYS_PWRITE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PWRITE))},
			"SYS_PWRITE_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_PWRITE_NOCANCEL))},
			"SYS_QUOTACTL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_QUOTACTL))},
			"SYS_READ":                           {"untyped int", constant.MakeInt64(int64(q.SYS_READ))},
			"SYS_READLINK":                       {"untyped int", constant.MakeInt64(int64(q.SYS_READLINK))},
			"SYS_READV":                          {"untyped int", constant.MakeInt64(int64(q.SYS_READV))},
			"SYS_READV_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_READV_NOCANCEL))},
			"SYS_READ_NOCANCEL":                  {"untyped int", constant.MakeInt64(int64(q.SYS_READ_NOCANCEL))},
			"SYS_REBOOT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_REBOOT))},
			"SYS_RECVFROM":                       {"untyped int", constant.MakeInt64(int64(q.SYS_RECVFROM))},
			"SYS_RECVFROM_NOCANCEL":              {"untyped int", constant.MakeInt64(int64(q.SYS_RECVFROM_NOCANCEL))},
			"SYS_RECVMSG":                        {"untyped int", constant.MakeInt64(int64(q.SYS_RECVMSG))},
			"SYS_RECVMSG_NOCANCEL":               {"untyped int", constant.MakeInt64(int64(q.SYS_RECVMSG_NOCANCEL))},
			"SYS_REMOVEXATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_REMOVEXATTR))},
			"SYS_RENAME":                         {"untyped int", constant.MakeInt64(int64(q.SYS_RENAME))},
			"SYS_REVOKE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_REVOKE))},
			"SYS_RMDIR":                          {"untyped int", constant.MakeInt64(int64(q.SYS_RMDIR))},
			"SYS_SEARCHFS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SEARCHFS))},
			"SYS_SELECT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SELECT))},
			"SYS_SELECT_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_SELECT_NOCANCEL))},
			"SYS_SEMCTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SEMCTL))},
			"SYS_SEMGET":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SEMGET))},
			"SYS_SEMOP":                          {"untyped int", constant.MakeInt64(int64(q.SYS_SEMOP))},
			"SYS_SEMSYS":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SEMSYS))},
			"SYS_SEM_CLOSE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_CLOSE))},
			"SYS_SEM_DESTROY":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_DESTROY))},
			"SYS_SEM_GETVALUE":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_GETVALUE))},
			"SYS_SEM_INIT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_INIT))},
			"SYS_SEM_OPEN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_OPEN))},
			"SYS_SEM_POST":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_POST))},
			"SYS_SEM_TRYWAIT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_TRYWAIT))},
			"SYS_SEM_UNLINK":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_UNLINK))},
			"SYS_SEM_WAIT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_WAIT))},
			"SYS_SEM_WAIT_NOCANCEL":              {"untyped int", constant.MakeInt64(int64(q.SYS_SEM_WAIT_NOCANCEL))},
			"SYS_SENDFILE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SENDFILE))},
			"SYS_SENDMSG":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SENDMSG))},
			"SYS_SENDMSG_NOCANCEL":               {"untyped int", constant.MakeInt64(int64(q.SYS_SENDMSG_NOCANCEL))},
			"SYS_SENDTO":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SENDTO))},
			"SYS_SENDTO_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_SENDTO_NOCANCEL))},
			"SYS_SETATTRLIST":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETATTRLIST))},
			"SYS_SETAUDIT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETAUDIT))},
			"SYS_SETAUDIT_ADDR":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SETAUDIT_ADDR))},
			"SYS_SETAUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETAUID))},
			"SYS_SETEGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETEGID))},
			"SYS_SETEUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETEUID))},
			"SYS_SETGID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SETGID))},
			"SYS_SETGROUPS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETGROUPS))},
			"SYS_SETITIMER":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETITIMER))},
			"SYS_SETLCID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETLCID))},
			"SYS_SETLOGIN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETLOGIN))},
			"SYS_SETPGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETPGID))},
			"SYS_SETPRIORITY":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETPRIORITY))},
			"SYS_SETPRIVEXEC":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETPRIVEXEC))},
			"SYS_SETREGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETREGID))},
			"SYS_SETREUID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETREUID))},
			"SYS_SETRLIMIT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETRLIMIT))},
			"SYS_SETSGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETSGROUPS))},
			"SYS_SETSID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SETSID))},
			"SYS_SETSOCKOPT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETSOCKOPT))},
			"SYS_SETTID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SETTID))},
			"SYS_SETTID_WITH_PID":                {"untyped int", constant.MakeInt64(int64(q.SYS_SETTID_WITH_PID))},
			"SYS_SETTIMEOFDAY":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SETTIMEOFDAY))},
			"SYS_SETUID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SETUID))},
			"SYS_SETWGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETWGROUPS))},
			"SYS_SETXATTR":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETXATTR))},
			"SYS_SHARED_REGION_CHECK_NP":         {"untyped int", constant.MakeInt64(int64(q.SYS_SHARED_REGION_CHECK_NP))},
			"SYS_SHARED_REGION_MAP_AND_SLIDE_NP": {"untyped int", constant.MakeInt64(int64(q.SYS_SHARED_REGION_MAP_AND_SLIDE_NP))},
			"SYS_SHMAT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_SHMAT))},
			"SYS_SHMCTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SHMCTL))},
			"SYS_SHMDT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_SHMDT))},
			"SYS_SHMGET":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SHMGET))},
			"SYS_SHMSYS":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SHMSYS))},
			"SYS_SHM_OPEN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SHM_OPEN))},
			"SYS_SHM_UNLINK":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SHM_UNLINK))},
			"SYS_SHUTDOWN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SHUTDOWN))},
			"SYS_SIGACTION":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SIGACTION))},
			"SYS_SIGALTSTACK":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGALTSTACK))},
			"SYS_SIGPENDING":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPENDING))},
			"SYS_SIGPROCMASK":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPROCMASK))},
			"SYS_SIGRETURN":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SIGRETURN))},
			"SYS_SIGSUSPEND":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SIGSUSPEND))},
			"SYS_SIGSUSPEND_NOCANCEL":            {"untyped int", constant.MakeInt64(int64(q.SYS_SIGSUSPEND_NOCANCEL))},
			"SYS_SOCKET":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKET))},
			"SYS_SOCKETPAIR":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKETPAIR))},
			"SYS_STACK_SNAPSHOT":                 {"untyped int", constant.MakeInt64(int64(q.SYS_STACK_SNAPSHOT))},
			"SYS_STAT":                           {"untyped int", constant.MakeInt64(int64(q.SYS_STAT))},
			"SYS_STAT64":                         {"untyped int", constant.MakeInt64(int64(q.SYS_STAT64))},
			"SYS_STAT64_EXTENDED":                {"untyped int", constant.MakeInt64(int64(q.SYS_STAT64_EXTENDED))},
			"SYS_STATFS":                         {"untyped int", constant.MakeInt64(int64(q.SYS_STATFS))},
			"SYS_STATFS64":                       {"untyped int", constant.MakeInt64(int64(q.SYS_STATFS64))},
			"SYS_STATV":                          {"untyped int", constant.MakeInt64(int64(q.SYS_STATV))},
			"SYS_STAT_EXTENDED":                  {"untyped int", constant.MakeInt64(int64(q.SYS_STAT_EXTENDED))},
			"SYS_SWAPON":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SWAPON))},
			"SYS_SYMLINK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SYMLINK))},
			"SYS_SYNC":                           {"untyped int", constant.MakeInt64(int64(q.SYS_SYNC))},
			"SYS_SYSCALL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SYSCALL))},
			"SYS_THREAD_SELFID":                  {"untyped int", constant.MakeInt64(int64(q.SYS_THREAD_SELFID))},
			"SYS_TRUNCATE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_TRUNCATE))},
			"SYS_UMASK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_UMASK))},
			"SYS_UMASK_EXTENDED":                 {"untyped int", constant.MakeInt64(int64(q.SYS_UMASK_EXTENDED))},
			"SYS_UNDELETE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_UNDELETE))},
			"SYS_UNLINK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_UNLINK))},
			"SYS_UNMOUNT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UNMOUNT))},
			"SYS_UTIMES":                         {"untyped int", constant.MakeInt64(int64(q.SYS_UTIMES))},
			"SYS_VFORK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_VFORK))},
			"SYS_VM_PRESSURE_MONITOR":            {"untyped int", constant.MakeInt64(int64(q.SYS_VM_PRESSURE_MONITOR))},
			"SYS_WAIT4":                          {"untyped int", constant.MakeInt64(int64(q.SYS_WAIT4))},
			"SYS_WAIT4_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_WAIT4_NOCANCEL))},
			"SYS_WAITEVENT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_WAITEVENT))},
			"SYS_WAITID":                         {"untyped int", constant.MakeInt64(int64(q.SYS_WAITID))},
			"SYS_WAITID_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_WAITID_NOCANCEL))},
			"SYS_WATCHEVENT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_WATCHEVENT))},
			"SYS_WORKQ_KERNRETURN":               {"untyped int", constant.MakeInt64(int64(q.SYS_WORKQ_KERNRETURN))},
			"SYS_WORKQ_OPEN":                     {"untyped int", constant.MakeInt64(int64(q.SYS_WORKQ_OPEN))},
			"SYS_WRITE":                          {"untyped int", constant.MakeInt64(int64(q.SYS_WRITE))},
			"SYS_WRITEV":                         {"untyped int", constant.MakeInt64(int64(q.SYS_WRITEV))},
			"SYS_WRITEV_NOCANCEL":                {"untyped int", constant.MakeInt64(int64(q.SYS_WRITEV_NOCANCEL))},
			"SYS_WRITE_NOCANCEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_WRITE_NOCANCEL))},
			"SYS___DISABLE_THREADSIGNAL":         {"untyped int", constant.MakeInt64(int64(q.SYS___DISABLE_THREADSIGNAL))},
			"SYS___MAC_EXECVE":                   {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_EXECVE))},
			"SYS___MAC_GETFSSTAT":                {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GETFSSTAT))},
			"SYS___MAC_GET_FD":                   {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_FD))},
			"SYS___MAC_GET_FILE":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_FILE))},
			"SYS___MAC_GET_LCID":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_LCID))},
			"SYS___MAC_GET_LCTX":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_LCTX))},
			"SYS___MAC_GET_LINK":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_LINK))},
			"SYS___MAC_GET_MOUNT":                {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_MOUNT))},
			"SYS___MAC_GET_PID":                  {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_PID))},
			"SYS___MAC_GET_PROC":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_GET_PROC))},
			"SYS___MAC_MOUNT":                    {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_MOUNT))},
			"SYS___MAC_SET_FD":                   {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_SET_FD))},
			"SYS___MAC_SET_FILE":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_SET_FILE))},
			"SYS___MAC_SET_LCTX":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_SET_LCTX))},
			"SYS___MAC_SET_LINK":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_SET_LINK))},
			"SYS___MAC_SET_PROC":                 {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_SET_PROC))},
			"SYS___MAC_SYSCALL":                  {"untyped int", constant.MakeInt64(int64(q.SYS___MAC_SYSCALL))},
			"SYS___OLD_SEMWAIT_SIGNAL":           {"untyped int", constant.MakeInt64(int64(q.SYS___OLD_SEMWAIT_SIGNAL))},
			"SYS___OLD_SEMWAIT_SIGNAL_NOCANCEL":  {"untyped int", constant.MakeInt64(int64(q.SYS___OLD_SEMWAIT_SIGNAL_NOCANCEL))},
			"SYS___PTHREAD_CANCELED":             {"untyped int", constant.MakeInt64(int64(q.SYS___PTHREAD_CANCELED))},
			"SYS___PTHREAD_CHDIR":                {"untyped int", constant.MakeInt64(int64(q.SYS___PTHREAD_CHDIR))},
			"SYS___PTHREAD_FCHDIR":               {"untyped int", constant.MakeInt64(int64(q.SYS___PTHREAD_FCHDIR))},
			"SYS___PTHREAD_KILL":                 {"untyped int", constant.MakeInt64(int64(q.SYS___PTHREAD_KILL))},
			"SYS___PTHREAD_MARKCANCEL":           {"untyped int", constant.MakeInt64(int64(q.SYS___PTHREAD_MARKCANCEL))},
			"SYS___PTHREAD_SIGMASK":              {"untyped int", constant.MakeInt64(int64(q.SYS___PTHREAD_SIGMASK))},
			"SYS___SEMWAIT_SIGNAL":               {"untyped int", constant.MakeInt64(int64(q.SYS___SEMWAIT_SIGNAL))},
			"SYS___SEMWAIT_SIGNAL_NOCANCEL":      {"untyped int", constant.MakeInt64(int64(q.SYS___SEMWAIT_SIGNAL_NOCANCEL))},
			"SYS___SIGWAIT":                      {"untyped int", constant.MakeInt64(int64(q.SYS___SIGWAIT))},
			"SYS___SIGWAIT_NOCANCEL":             {"untyped int", constant.MakeInt64(int64(q.SYS___SIGWAIT_NOCANCEL))},
			"SYS___SYSCTL":                       {"untyped int", constant.MakeInt64(int64(q.SYS___SYSCTL))},
			"S_IEXEC":                            {"untyped int", constant.MakeInt64(int64(q.S_IEXEC))},
			"S_IFBLK":                            {"untyped int", constant.MakeInt64(int64(q.S_IFBLK))},
			"S_IFCHR":                            {"untyped int", constant.MakeInt64(int64(q.S_IFCHR))},
			"S_IFDIR":                            {"untyped int", constant.MakeInt64(int64(q.S_IFDIR))},
			"S_IFIFO":                            {"untyped int", constant.MakeInt64(int64(q.S_IFIFO))},
			"S_IFLNK":                            {"untyped int", constant.MakeInt64(int64(q.S_IFLNK))},
			"S_IFMT":                             {"untyped int", constant.MakeInt64(int64(q.S_IFMT))},
			"S_IFREG":                            {"untyped int", constant.MakeInt64(int64(q.S_IFREG))},
			"S_IFSOCK":                           {"untyped int", constant.MakeInt64(int64(q.S_IFSOCK))},
			"S_IFWHT":                            {"untyped int", constant.MakeInt64(int64(q.S_IFWHT))},
			"S_IREAD":                            {"untyped int", constant.MakeInt64(int64(q.S_IREAD))},
			"S_IRGRP":                            {"untyped int", constant.MakeInt64(int64(q.S_IRGRP))},
			"S_IROTH":                            {"untyped int", constant.MakeInt64(int64(q.S_IROTH))},
			"S_IRUSR":                            {"untyped int", constant.MakeInt64(int64(q.S_IRUSR))},
			"S_IRWXG":                            {"untyped int", constant.MakeInt64(int64(q.S_IRWXG))},
			"S_IRWXO":                            {"untyped int", constant.MakeInt64(int64(q.S_IRWXO))},
			"S_IRWXU":                            {"untyped int", constant.MakeInt64(int64(q.S_IRWXU))},
			"S_ISGID":                            {"untyped int", constant.MakeInt64(int64(q.S_ISGID))},
			"S_ISTXT":                            {"untyped int", constant.MakeInt64(int64(q.S_ISTXT))},
			"S_ISUID":                            {"untyped int", constant.MakeInt64(int64(q.S_ISUID))},
			"S_ISVTX":                            {"untyped int", constant.MakeInt64(int64(q.S_ISVTX))},
			"S_IWGRP":                            {"untyped int", constant.MakeInt64(int64(q.S_IWGRP))},
			"S_IWOTH":                            {"untyped int", constant.MakeInt64(int64(q.S_IWOTH))},
			"S_IWRITE":                           {"untyped int", constant.MakeInt64(int64(q.S_IWRITE))},
			"S_IWUSR":                            {"untyped int", constant.MakeInt64(int64(q.S_IWUSR))},
			"S_IXGRP":                            {"untyped int", constant.MakeInt64(int64(q.S_IXGRP))},
			"S_IXOTH":                            {"untyped int", constant.MakeInt64(int64(q.S_IXOTH))},
			"S_IXUSR":                            {"untyped int", constant.MakeInt64(int64(q.S_IXUSR))},
			"SizeofBpfHdr":                       {"untyped int", constant.MakeInt64(int64(q.SizeofBpfHdr))},
			"SizeofBpfInsn":                      {"untyped int", constant.MakeInt64(int64(q.SizeofBpfInsn))},
			"SizeofBpfProgram":                   {"untyped int", constant.MakeInt64(int64(q.SizeofBpfProgram))},
			"SizeofBpfStat":                      {"untyped int", constant.MakeInt64(int64(q.SizeofBpfStat))},
			"SizeofBpfVersion":                   {"untyped int", constant.MakeInt64(int64(q.SizeofBpfVersion))},
			"SizeofCmsghdr":                      {"untyped int", constant.MakeInt64(int64(q.SizeofCmsghdr))},
			"SizeofICMPv6Filter":                 {"untyped int", constant.MakeInt64(int64(q.SizeofICMPv6Filter))},
			"SizeofIPMreq":                       {"untyped int", constant.MakeInt64(int64(q.SizeofIPMreq))},
			"SizeofIPv6MTUInfo":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6MTUInfo))},
			"SizeofIPv6Mreq":                     {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6Mreq))},
			"SizeofIfData":                       {"untyped int", constant.MakeInt64(int64(q.SizeofIfData))},
			"SizeofIfMsghdr":                     {"untyped int", constant.MakeInt64(int64(q.SizeofIfMsghdr))},
			"SizeofIfaMsghdr":                    {"untyped int", constant.MakeInt64(int64(q.SizeofIfaMsghdr))},
			"SizeofIfmaMsghdr":                   {"untyped int", constant.MakeInt64(int64(q.SizeofIfmaMsghdr))},
			"SizeofIfmaMsghdr2":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIfmaMsghdr2))},
			"SizeofInet4Pktinfo":                 {"untyped int", constant.MakeInt64(int64(q.SizeofInet4Pktinfo))},
			"SizeofInet6Pktinfo":                 {"untyped int", constant.MakeInt64(int64(q.SizeofInet6Pktinfo))},
			"SizeofLinger":                       {"untyped int", constant.MakeInt64(int64(q.SizeofLinger))},
			"SizeofMsghdr":                       {"untyped int", constant.MakeInt64(int64(q.SizeofMsghdr))},
			"SizeofRtMetrics":                    {"untyped int", constant.MakeInt64(int64(q.SizeofRtMetrics))},
			"SizeofRtMsghdr":                     {"untyped int", constant.MakeInt64(int64(q.SizeofRtMsghdr))},
			"SizeofSockaddrAny":                  {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrAny))},
			"SizeofSockaddrDatalink":             {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrDatalink))},
			"SizeofSockaddrInet4":                {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet4))},
			"SizeofSockaddrInet6":                {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet6))},
			"SizeofSockaddrUnix":                 {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrUnix))},
			"TCIFLUSH":                           {"untyped int", constant.MakeInt64(int64(q.TCIFLUSH))},
			"TCIOFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.TCIOFLUSH))},
			"TCOFLUSH":                           {"untyped int", constant.MakeInt64(int64(q.TCOFLUSH))},
			"TCP_CONNECTIONTIMEOUT":              {"untyped int", constant.MakeInt64(int64(q.TCP_CONNECTIONTIMEOUT))},
			"TCP_KEEPALIVE":                      {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPALIVE))},
			"TCP_MAXHLEN":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MAXHLEN))},
			"TCP_MAXOLEN":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MAXOLEN))},
			"TCP_MAXSEG":                         {"untyped int", constant.MakeInt64(int64(q.TCP_MAXSEG))},
			"TCP_MAXWIN":                         {"untyped int", constant.MakeInt64(int64(q.TCP_MAXWIN))},
			"TCP_MAX_SACK":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MAX_SACK))},
			"TCP_MAX_WINSHIFT":                   {"untyped int", constant.MakeInt64(int64(q.TCP_MAX_WINSHIFT))},
			"TCP_MINMSS":                         {"untyped int", constant.MakeInt64(int64(q.TCP_MINMSS))},
			"TCP_MINMSSOVERLOAD":                 {"untyped int", constant.MakeInt64(int64(q.TCP_MINMSSOVERLOAD))},
			"TCP_MSS":                            {"untyped int", constant.MakeInt64(int64(q.TCP_MSS))},
			"TCP_NODELAY":                        {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAY))},
			"TCP_NOOPT":                          {"untyped int", constant.MakeInt64(int64(q.TCP_NOOPT))},
			"TCP_NOPUSH":                         {"untyped int", constant.MakeInt64(int64(q.TCP_NOPUSH))},
			"TCP_RXT_CONNDROPTIME":               {"untyped int", constant.MakeInt64(int64(q.TCP_RXT_CONNDROPTIME))},
			"TCP_RXT_FINDROP":                    {"untyped int", constant.MakeInt64(int64(q.TCP_RXT_FINDROP))},
			"TCSAFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.TCSAFLUSH))},
			"TIOCCBRK":                           {"untyped int", constant.MakeInt64(int64(q.TIOCCBRK))},
			"TIOCCDTR":                           {"untyped int", constant.MakeInt64(int64(q.TIOCCDTR))},
			"TIOCCONS":                           {"untyped int", constant.MakeInt64(int64(q.TIOCCONS))},
			"TIOCDCDTIMESTAMP":                   {"untyped int", constant.MakeInt64(int64(q.TIOCDCDTIMESTAMP))},
			"TIOCDRAIN":                          {"untyped int", constant.MakeInt64(int64(q.TIOCDRAIN))},
			"TIOCDSIMICROCODE":                   {"untyped int", constant.MakeInt64(int64(q.TIOCDSIMICROCODE))},
			"TIOCEXCL":                           {"untyped int", constant.MakeInt64(int64(q.TIOCEXCL))},
			"TIOCEXT":                            {"untyped int", constant.MakeInt64(int64(q.TIOCEXT))},
			"TIOCFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.TIOCFLUSH))},
			"TIOCGDRAINWAIT":                     {"untyped int", constant.MakeInt64(int64(q.TIOCGDRAINWAIT))},
			"TIOCGETA":                           {"untyped int", constant.MakeInt64(int64(q.TIOCGETA))},
			"TIOCGETD":                           {"untyped int", constant.MakeInt64(int64(q.TIOCGETD))},
			"TIOCGPGRP":                          {"untyped int", constant.MakeInt64(int64(q.TIOCGPGRP))},
			"TIOCGWINSZ":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGWINSZ))},
			"TIOCIXOFF":                          {"untyped int", constant.MakeInt64(int64(q.TIOCIXOFF))},
			"TIOCIXON":                           {"untyped int", constant.MakeInt64(int64(q.TIOCIXON))},
			"TIOCMBIC":                           {"untyped int", constant.MakeInt64(int64(q.TIOCMBIC))},
			"TIOCMBIS":                           {"untyped int", constant.MakeInt64(int64(q.TIOCMBIS))},
			"TIOCMGDTRWAIT":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMGDTRWAIT))},
			"TIOCMGET":                           {"untyped int", constant.MakeInt64(int64(q.TIOCMGET))},
			"TIOCMODG":                           {"untyped int", constant.MakeInt64(int64(q.TIOCMODG))},
			"TIOCMODS":                           {"untyped int", constant.MakeInt64(int64(q.TIOCMODS))},
			"TIOCMSDTRWAIT":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMSDTRWAIT))},
			"TIOCMSET":                           {"untyped int", constant.MakeInt64(int64(q.TIOCMSET))},
			"TIOCM_CAR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_CAR))},
			"TIOCM_CD":                           {"untyped int", constant.MakeInt64(int64(q.TIOCM_CD))},
			"TIOCM_CTS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_CTS))},
			"TIOCM_DSR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_DSR))},
			"TIOCM_DTR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_DTR))},
			"TIOCM_LE":                           {"untyped int", constant.MakeInt64(int64(q.TIOCM_LE))},
			"TIOCM_RI":                           {"untyped int", constant.MakeInt64(int64(q.TIOCM_RI))},
			"TIOCM_RNG":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_RNG))},
			"TIOCM_RTS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_RTS))},
			"TIOCM_SR":                           {"untyped int", constant.MakeInt64(int64(q.TIOCM_SR))},
			"TIOCM_ST":                           {"untyped int", constant.MakeInt64(int64(q.TIOCM_ST))},
			"TIOCNOTTY":                          {"untyped int", constant.MakeInt64(int64(q.TIOCNOTTY))},
			"TIOCNXCL":                           {"untyped int", constant.MakeInt64(int64(q.TIOCNXCL))},
			"TIOCOUTQ":                           {"untyped int", constant.MakeInt64(int64(q.TIOCOUTQ))},
			"TIOCPKT":                            {"untyped int", constant.MakeInt64(int64(q.TIOCPKT))},
			"TIOCPKT_DATA":                       {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DATA))},
			"TIOCPKT_DOSTOP":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DOSTOP))},
			"TIOCPKT_FLUSHREAD":                  {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHREAD))},
			"TIOCPKT_FLUSHWRITE":                 {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHWRITE))},
			"TIOCPKT_IOCTL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_IOCTL))},
			"TIOCPKT_NOSTOP":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_NOSTOP))},
			"TIOCPKT_START":                      {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_START))},
			"TIOCPKT_STOP":                       {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_STOP))},
			"TIOCPTYGNAME":                       {"untyped int", constant.MakeInt64(int64(q.TIOCPTYGNAME))},
			"TIOCPTYGRANT":                       {"untyped int", constant.MakeInt64(int64(q.TIOCPTYGRANT))},
			"TIOCPTYUNLK":                        {"untyped int", constant.MakeInt64(int64(q.TIOCPTYUNLK))},
			"TIOCREMOTE":                         {"untyped int", constant.MakeInt64(int64(q.TIOCREMOTE))},
			"TIOCSBRK":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSBRK))},
			"TIOCSCONS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSCONS))},
			"TIOCSCTTY":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSCTTY))},
			"TIOCSDRAINWAIT":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSDRAINWAIT))},
			"TIOCSDTR":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSDTR))},
			"TIOCSETA":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSETA))},
			"TIOCSETAF":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSETAF))},
			"TIOCSETAW":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSETAW))},
			"TIOCSETD":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSETD))},
			"TIOCSIG":                            {"untyped int", constant.MakeInt64(int64(q.TIOCSIG))},
			"TIOCSPGRP":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSPGRP))},
			"TIOCSTART":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSTART))},
			"TIOCSTAT":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSTAT))},
			"TIOCSTI":                            {"untyped int", constant.MakeInt64(int64(q.TIOCSTI))},
			"TIOCSTOP":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSTOP))},
			"TIOCSWINSZ":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSWINSZ))},
			"TIOCTIMESTAMP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCTIMESTAMP))},
			"TIOCUCNTL":                          {"untyped int", constant.MakeInt64(int64(q.TIOCUCNTL))},
			"TOSTOP":                             {"untyped int", constant.MakeInt64(int64(q.TOSTOP))},
			"VDISCARD":                           {"untyped int", constant.MakeInt64(int64(q.VDISCARD))},
			"VDSUSP":                             {"untyped int", constant.MakeInt64(int64(q.VDSUSP))},
			"VEOF":                               {"untyped int", constant.MakeInt64(int64(q.VEOF))},
			"VEOL":                               {"untyped int", constant.MakeInt64(int64(q.VEOL))},
			"VEOL2":                              {"untyped int", constant.MakeInt64(int64(q.VEOL2))},
			"VERASE":                             {"untyped int", constant.MakeInt64(int64(q.VERASE))},
			"VINTR":                              {"untyped int", constant.MakeInt64(int64(q.VINTR))},
			"VKILL":                              {"untyped int", constant.MakeInt64(int64(q.VKILL))},
			"VLNEXT":                             {"untyped int", constant.MakeInt64(int64(q.VLNEXT))},
			"VMIN":                               {"untyped int", constant.MakeInt64(int64(q.VMIN))},
			"VQUIT":                              {"untyped int", constant.MakeInt64(int64(q.VQUIT))},
			"VREPRINT":                           {"untyped int", constant.MakeInt64(int64(q.VREPRINT))},
			"VSTART":                             {"untyped int", constant.MakeInt64(int64(q.VSTART))},
			"VSTATUS":                            {"untyped int", constant.MakeInt64(int64(q.VSTATUS))},
			"VSTOP":                              {"untyped int", constant.MakeInt64(int64(q.VSTOP))},
			"VSUSP":                              {"untyped int", constant.MakeInt64(int64(q.VSUSP))},
			"VT0":                                {"untyped int", constant.MakeInt64(int64(q.VT0))},
			"VT1":                                {"untyped int", constant.MakeInt64(int64(q.VT1))},
			"VTDLY":                              {"untyped int", constant.MakeInt64(int64(q.VTDLY))},
			"VTIME":                              {"untyped int", constant.MakeInt64(int64(q.VTIME))},
			"VWERASE":                            {"untyped int", constant.MakeInt64(int64(q.VWERASE))},
			"WCONTINUED":                         {"untyped int", constant.MakeInt64(int64(q.WCONTINUED))},
			"WCOREFLAG":                          {"untyped int", constant.MakeInt64(int64(q.WCOREFLAG))},
			"WEXITED":                            {"untyped int", constant.MakeInt64(int64(q.WEXITED))},
			"WNOHANG":                            {"untyped int", constant.MakeInt64(int64(q.WNOHANG))},
			"WNOWAIT":                            {"untyped int", constant.MakeInt64(int64(q.WNOWAIT))},
			"WORDSIZE":                           {"untyped int", constant.MakeInt64(int64(q.WORDSIZE))},
			"WSTOPPED":                           {"untyped int", constant.MakeInt64(int64(q.WSTOPPED))},
			"WUNTRACED":                          {"untyped int", constant.MakeInt64(int64(q.WUNTRACED))},
		},
	})
}
