// export by github.com/goplus/igop/cmd/qexp

//go:build go1.18 && !go1.19
// +build go1.18,!go1.19

package syscall

import (
	q "syscall"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "syscall",
		Path: "syscall",
		Deps: map[string]string{
			"errors":                "errors",
			"internal/bytealg":      "bytealg",
			"internal/itoa":         "itoa",
			"internal/oserror":      "oserror",
			"internal/race":         "race",
			"internal/unsafeheader": "unsafeheader",
			"runtime":               "runtime",
			"sync":                  "sync",
			"unsafe":                "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Conn":     reflect.TypeOf((*q.Conn)(nil)).Elem(),
			"RawConn":  reflect.TypeOf((*q.RawConn)(nil)).Elem(),
			"Sockaddr": reflect.TypeOf((*q.Sockaddr)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"Cmsghdr":              reflect.TypeOf((*q.Cmsghdr)(nil)).Elem(),
			"Credential":           reflect.TypeOf((*q.Credential)(nil)).Elem(),
			"Dirent":               reflect.TypeOf((*q.Dirent)(nil)).Elem(),
			"Errno":                reflect.TypeOf((*q.Errno)(nil)).Elem(),
			"Flock_t":              reflect.TypeOf((*q.Flock_t)(nil)).Elem(),
			"Fsid64_t":             reflect.TypeOf((*q.Fsid64_t)(nil)).Elem(),
			"ICMPv6Filter":         reflect.TypeOf((*q.ICMPv6Filter)(nil)).Elem(),
			"IPMreq":               reflect.TypeOf((*q.IPMreq)(nil)).Elem(),
			"IPv6Mreq":             reflect.TypeOf((*q.IPv6Mreq)(nil)).Elem(),
			"IfMsgHdr":             reflect.TypeOf((*q.IfMsgHdr)(nil)).Elem(),
			"Iovec":                reflect.TypeOf((*q.Iovec)(nil)).Elem(),
			"Linger":               reflect.TypeOf((*q.Linger)(nil)).Elem(),
			"Msghdr":               reflect.TypeOf((*q.Msghdr)(nil)).Elem(),
			"ProcAttr":             reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"RawSockaddr":          reflect.TypeOf((*q.RawSockaddr)(nil)).Elem(),
			"RawSockaddrAny":       reflect.TypeOf((*q.RawSockaddrAny)(nil)).Elem(),
			"RawSockaddrDatalink":  reflect.TypeOf((*q.RawSockaddrDatalink)(nil)).Elem(),
			"RawSockaddrInet4":     reflect.TypeOf((*q.RawSockaddrInet4)(nil)).Elem(),
			"RawSockaddrInet6":     reflect.TypeOf((*q.RawSockaddrInet6)(nil)).Elem(),
			"RawSockaddrUnix":      reflect.TypeOf((*q.RawSockaddrUnix)(nil)).Elem(),
			"Rlimit":               reflect.TypeOf((*q.Rlimit)(nil)).Elem(),
			"Rusage":               reflect.TypeOf((*q.Rusage)(nil)).Elem(),
			"Signal":               reflect.TypeOf((*q.Signal)(nil)).Elem(),
			"SockaddrDatalink":     reflect.TypeOf((*q.SockaddrDatalink)(nil)).Elem(),
			"SockaddrInet4":        reflect.TypeOf((*q.SockaddrInet4)(nil)).Elem(),
			"SockaddrInet6":        reflect.TypeOf((*q.SockaddrInet6)(nil)).Elem(),
			"SockaddrUnix":         reflect.TypeOf((*q.SockaddrUnix)(nil)).Elem(),
			"SocketControlMessage": reflect.TypeOf((*q.SocketControlMessage)(nil)).Elem(),
			"StTimespec_t":         reflect.TypeOf((*q.StTimespec_t)(nil)).Elem(),
			"Stat_t":               reflect.TypeOf((*q.Stat_t)(nil)).Elem(),
			"Statfs_t":             reflect.TypeOf((*q.Statfs_t)(nil)).Elem(),
			"SysProcAttr":          reflect.TypeOf((*q.SysProcAttr)(nil)).Elem(),
			"Termios":              reflect.TypeOf((*q.Termios)(nil)).Elem(),
			"Timespec":             reflect.TypeOf((*q.Timespec)(nil)).Elem(),
			"Timeval":              reflect.TypeOf((*q.Timeval)(nil)).Elem(),
			"Timeval32":            reflect.TypeOf((*q.Timeval32)(nil)).Elem(),
			"Timezone":             reflect.TypeOf((*q.Timezone)(nil)).Elem(),
			"Utsname":              reflect.TypeOf((*q.Utsname)(nil)).Elem(),
			"WaitStatus":           reflect.TypeOf((*q.WaitStatus)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ForkLock":          reflect.ValueOf(&q.ForkLock),
			"SocketDisableIPv6": reflect.ValueOf(&q.SocketDisableIPv6),
			"Stderr":            reflect.ValueOf(&q.Stderr),
			"Stdin":             reflect.ValueOf(&q.Stdin),
			"Stdout":            reflect.ValueOf(&q.Stdout),
		},
		Funcs: map[string]reflect.Value{
			"Accept":                    reflect.ValueOf(q.Accept),
			"Access":                    reflect.ValueOf(q.Access),
			"Acct":                      reflect.ValueOf(q.Acct),
			"Bind":                      reflect.ValueOf(q.Bind),
			"BytePtrFromString":         reflect.ValueOf(q.BytePtrFromString),
			"ByteSliceFromString":       reflect.ValueOf(q.ByteSliceFromString),
			"Chdir":                     reflect.ValueOf(q.Chdir),
			"Chmod":                     reflect.ValueOf(q.Chmod),
			"Chown":                     reflect.ValueOf(q.Chown),
			"Chroot":                    reflect.ValueOf(q.Chroot),
			"Clearenv":                  reflect.ValueOf(q.Clearenv),
			"Close":                     reflect.ValueOf(q.Close),
			"CloseOnExec":               reflect.ValueOf(q.CloseOnExec),
			"CmsgLen":                   reflect.ValueOf(q.CmsgLen),
			"CmsgSpace":                 reflect.ValueOf(q.CmsgSpace),
			"Connect":                   reflect.ValueOf(q.Connect),
			"Dup":                       reflect.ValueOf(q.Dup),
			"Dup2":                      reflect.ValueOf(q.Dup2),
			"Environ":                   reflect.ValueOf(q.Environ),
			"Exec":                      reflect.ValueOf(q.Exec),
			"Exit":                      reflect.ValueOf(q.Exit),
			"Faccessat":                 reflect.ValueOf(q.Faccessat),
			"Fchdir":                    reflect.ValueOf(q.Fchdir),
			"Fchmod":                    reflect.ValueOf(q.Fchmod),
			"Fchmodat":                  reflect.ValueOf(q.Fchmodat),
			"Fchown":                    reflect.ValueOf(q.Fchown),
			"Fchownat":                  reflect.ValueOf(q.Fchownat),
			"FcntlFlock":                reflect.ValueOf(q.FcntlFlock),
			"ForkExec":                  reflect.ValueOf(q.ForkExec),
			"Fpathconf":                 reflect.ValueOf(q.Fpathconf),
			"Fstat":                     reflect.ValueOf(q.Fstat),
			"Fstatfs":                   reflect.ValueOf(q.Fstatfs),
			"Fsync":                     reflect.ValueOf(q.Fsync),
			"Ftruncate":                 reflect.ValueOf(q.Ftruncate),
			"Getcwd":                    reflect.ValueOf(q.Getcwd),
			"Getegid":                   reflect.ValueOf(q.Getegid),
			"Getenv":                    reflect.ValueOf(q.Getenv),
			"Geteuid":                   reflect.ValueOf(q.Geteuid),
			"Getgid":                    reflect.ValueOf(q.Getgid),
			"Getgroups":                 reflect.ValueOf(q.Getgroups),
			"Getkerninfo":               reflect.ValueOf(q.Getkerninfo),
			"Getpagesize":               reflect.ValueOf(q.Getpagesize),
			"Getpeername":               reflect.ValueOf(q.Getpeername),
			"Getpid":                    reflect.ValueOf(q.Getpid),
			"Getppid":                   reflect.ValueOf(q.Getppid),
			"Getpriority":               reflect.ValueOf(q.Getpriority),
			"Getrlimit":                 reflect.ValueOf(q.Getrlimit),
			"Getsockname":               reflect.ValueOf(q.Getsockname),
			"GetsockoptInt":             reflect.ValueOf(q.GetsockoptInt),
			"Gettimeofday":              reflect.ValueOf(q.Gettimeofday),
			"Getuid":                    reflect.ValueOf(q.Getuid),
			"Getwd":                     reflect.ValueOf(q.Getwd),
			"Kill":                      reflect.ValueOf(q.Kill),
			"Lchown":                    reflect.ValueOf(q.Lchown),
			"Link":                      reflect.ValueOf(q.Link),
			"Listen":                    reflect.ValueOf(q.Listen),
			"Lstat":                     reflect.ValueOf(q.Lstat),
			"Mkdir":                     reflect.ValueOf(q.Mkdir),
			"Mkdirat":                   reflect.ValueOf(q.Mkdirat),
			"Mknodat":                   reflect.ValueOf(q.Mknodat),
			"Mmap":                      reflect.ValueOf(q.Mmap),
			"Munmap":                    reflect.ValueOf(q.Munmap),
			"NsecToTimespec":            reflect.ValueOf(q.NsecToTimespec),
			"NsecToTimeval":             reflect.ValueOf(q.NsecToTimeval),
			"Open":                      reflect.ValueOf(q.Open),
			"Openat":                    reflect.ValueOf(q.Openat),
			"ParseDirent":               reflect.ValueOf(q.ParseDirent),
			"ParseSocketControlMessage": reflect.ValueOf(q.ParseSocketControlMessage),
			"ParseUnixRights":           reflect.ValueOf(q.ParseUnixRights),
			"Pipe":                      reflect.ValueOf(q.Pipe),
			"Pread":                     reflect.ValueOf(q.Pread),
			"PtraceAttach":              reflect.ValueOf(q.PtraceAttach),
			"PtraceCont":                reflect.ValueOf(q.PtraceCont),
			"PtraceDetach":              reflect.ValueOf(q.PtraceDetach),
			"PtracePeekData":            reflect.ValueOf(q.PtracePeekData),
			"PtracePeekText":            reflect.ValueOf(q.PtracePeekText),
			"PtracePokeData":            reflect.ValueOf(q.PtracePokeData),
			"PtracePokeText":            reflect.ValueOf(q.PtracePokeText),
			"PtraceSingleStep":          reflect.ValueOf(q.PtraceSingleStep),
			"Pwrite":                    reflect.ValueOf(q.Pwrite),
			"RawSyscall":                reflect.ValueOf(q.RawSyscall),
			"RawSyscall6":               reflect.ValueOf(q.RawSyscall6),
			"Read":                      reflect.ValueOf(q.Read),
			"ReadDirent":                reflect.ValueOf(q.ReadDirent),
			"Readlink":                  reflect.ValueOf(q.Readlink),
			"Reboot":                    reflect.ValueOf(q.Reboot),
			"Recvfrom":                  reflect.ValueOf(q.Recvfrom),
			"Recvmsg":                   reflect.ValueOf(q.Recvmsg),
			"Rename":                    reflect.ValueOf(q.Rename),
			"Renameat":                  reflect.ValueOf(q.Renameat),
			"Rmdir":                     reflect.ValueOf(q.Rmdir),
			"Seek":                      reflect.ValueOf(q.Seek),
			"Sendfile":                  reflect.ValueOf(q.Sendfile),
			"Sendmsg":                   reflect.ValueOf(q.Sendmsg),
			"SendmsgN":                  reflect.ValueOf(q.SendmsgN),
			"Sendto":                    reflect.ValueOf(q.Sendto),
			"SetNonblock":               reflect.ValueOf(q.SetNonblock),
			"Setegid":                   reflect.ValueOf(q.Setegid),
			"Setenv":                    reflect.ValueOf(q.Setenv),
			"Seteuid":                   reflect.ValueOf(q.Seteuid),
			"Setgid":                    reflect.ValueOf(q.Setgid),
			"Setgroups":                 reflect.ValueOf(q.Setgroups),
			"Setpgid":                   reflect.ValueOf(q.Setpgid),
			"Setpriority":               reflect.ValueOf(q.Setpriority),
			"Setregid":                  reflect.ValueOf(q.Setregid),
			"Setreuid":                  reflect.ValueOf(q.Setreuid),
			"Setrlimit":                 reflect.ValueOf(q.Setrlimit),
			"SetsockoptByte":            reflect.ValueOf(q.SetsockoptByte),
			"SetsockoptICMPv6Filter":    reflect.ValueOf(q.SetsockoptICMPv6Filter),
			"SetsockoptIPMreq":          reflect.ValueOf(q.SetsockoptIPMreq),
			"SetsockoptIPv6Mreq":        reflect.ValueOf(q.SetsockoptIPv6Mreq),
			"SetsockoptInet4Addr":       reflect.ValueOf(q.SetsockoptInet4Addr),
			"SetsockoptInt":             reflect.ValueOf(q.SetsockoptInt),
			"SetsockoptLinger":          reflect.ValueOf(q.SetsockoptLinger),
			"SetsockoptString":          reflect.ValueOf(q.SetsockoptString),
			"SetsockoptTimeval":         reflect.ValueOf(q.SetsockoptTimeval),
			"Shutdown":                  reflect.ValueOf(q.Shutdown),
			"SlicePtrFromStrings":       reflect.ValueOf(q.SlicePtrFromStrings),
			"Socket":                    reflect.ValueOf(q.Socket),
			"Socketpair":                reflect.ValueOf(q.Socketpair),
			"StartProcess":              reflect.ValueOf(q.StartProcess),
			"Stat":                      reflect.ValueOf(q.Stat),
			"Statfs":                    reflect.ValueOf(q.Statfs),
			"StringBytePtr":             reflect.ValueOf(q.StringBytePtr),
			"StringByteSlice":           reflect.ValueOf(q.StringByteSlice),
			"StringSlicePtr":            reflect.ValueOf(q.StringSlicePtr),
			"Symlink":                   reflect.ValueOf(q.Symlink),
			"Syscall":                   reflect.ValueOf(q.Syscall),
			"Syscall6":                  reflect.ValueOf(q.Syscall6),
			"TimespecToNsec":            reflect.ValueOf(q.TimespecToNsec),
			"TimevalToNsec":             reflect.ValueOf(q.TimevalToNsec),
			"Truncate":                  reflect.ValueOf(q.Truncate),
			"Umask":                     reflect.ValueOf(q.Umask),
			"Uname":                     reflect.ValueOf(q.Uname),
			"UnixRights":                reflect.ValueOf(q.UnixRights),
			"Unlink":                    reflect.ValueOf(q.Unlink),
			"Unlinkat":                  reflect.ValueOf(q.Unlinkat),
			"Unsetenv":                  reflect.ValueOf(q.Unsetenv),
			"Utimes":                    reflect.ValueOf(q.Utimes),
			"UtimesNano":                reflect.ValueOf(q.UtimesNano),
			"Wait4":                     reflect.ValueOf(q.Wait4),
			"Write":                     reflect.ValueOf(q.Write),
		},
		TypedConsts: map[string]igop.TypedConst{
			"E2BIG":           {reflect.TypeOf(q.E2BIG), constant.MakeInt64(int64(q.E2BIG))},
			"EACCES":          {reflect.TypeOf(q.EACCES), constant.MakeInt64(int64(q.EACCES))},
			"EADDRINUSE":      {reflect.TypeOf(q.EADDRINUSE), constant.MakeInt64(int64(q.EADDRINUSE))},
			"EADDRNOTAVAIL":   {reflect.TypeOf(q.EADDRNOTAVAIL), constant.MakeInt64(int64(q.EADDRNOTAVAIL))},
			"EAFNOSUPPORT":    {reflect.TypeOf(q.EAFNOSUPPORT), constant.MakeInt64(int64(q.EAFNOSUPPORT))},
			"EAGAIN":          {reflect.TypeOf(q.EAGAIN), constant.MakeInt64(int64(q.EAGAIN))},
			"EALREADY":        {reflect.TypeOf(q.EALREADY), constant.MakeInt64(int64(q.EALREADY))},
			"EBADF":           {reflect.TypeOf(q.EBADF), constant.MakeInt64(int64(q.EBADF))},
			"EBADMSG":         {reflect.TypeOf(q.EBADMSG), constant.MakeInt64(int64(q.EBADMSG))},
			"EBUSY":           {reflect.TypeOf(q.EBUSY), constant.MakeInt64(int64(q.EBUSY))},
			"ECANCELED":       {reflect.TypeOf(q.ECANCELED), constant.MakeInt64(int64(q.ECANCELED))},
			"ECHILD":          {reflect.TypeOf(q.ECHILD), constant.MakeInt64(int64(q.ECHILD))},
			"ECHRNG":          {reflect.TypeOf(q.ECHRNG), constant.MakeInt64(int64(q.ECHRNG))},
			"ECLONEME":        {reflect.TypeOf(q.ECLONEME), constant.MakeInt64(int64(q.ECLONEME))},
			"ECONNABORTED":    {reflect.TypeOf(q.ECONNABORTED), constant.MakeInt64(int64(q.ECONNABORTED))},
			"ECONNREFUSED":    {reflect.TypeOf(q.ECONNREFUSED), constant.MakeInt64(int64(q.ECONNREFUSED))},
			"ECONNRESET":      {reflect.TypeOf(q.ECONNRESET), constant.MakeInt64(int64(q.ECONNRESET))},
			"ECORRUPT":        {reflect.TypeOf(q.ECORRUPT), constant.MakeInt64(int64(q.ECORRUPT))},
			"EDEADLK":         {reflect.TypeOf(q.EDEADLK), constant.MakeInt64(int64(q.EDEADLK))},
			"EDESTADDREQ":     {reflect.TypeOf(q.EDESTADDREQ), constant.MakeInt64(int64(q.EDESTADDREQ))},
			"EDESTADDRREQ":    {reflect.TypeOf(q.EDESTADDRREQ), constant.MakeInt64(int64(q.EDESTADDRREQ))},
			"EDIST":           {reflect.TypeOf(q.EDIST), constant.MakeInt64(int64(q.EDIST))},
			"EDOM":            {reflect.TypeOf(q.EDOM), constant.MakeInt64(int64(q.EDOM))},
			"EDQUOT":          {reflect.TypeOf(q.EDQUOT), constant.MakeInt64(int64(q.EDQUOT))},
			"EEXIST":          {reflect.TypeOf(q.EEXIST), constant.MakeInt64(int64(q.EEXIST))},
			"EFAULT":          {reflect.TypeOf(q.EFAULT), constant.MakeInt64(int64(q.EFAULT))},
			"EFBIG":           {reflect.TypeOf(q.EFBIG), constant.MakeInt64(int64(q.EFBIG))},
			"EFORMAT":         {reflect.TypeOf(q.EFORMAT), constant.MakeInt64(int64(q.EFORMAT))},
			"EHOSTDOWN":       {reflect.TypeOf(q.EHOSTDOWN), constant.MakeInt64(int64(q.EHOSTDOWN))},
			"EHOSTUNREACH":    {reflect.TypeOf(q.EHOSTUNREACH), constant.MakeInt64(int64(q.EHOSTUNREACH))},
			"EIDRM":           {reflect.TypeOf(q.EIDRM), constant.MakeInt64(int64(q.EIDRM))},
			"EILSEQ":          {reflect.TypeOf(q.EILSEQ), constant.MakeInt64(int64(q.EILSEQ))},
			"EINPROGRESS":     {reflect.TypeOf(q.EINPROGRESS), constant.MakeInt64(int64(q.EINPROGRESS))},
			"EINTR":           {reflect.TypeOf(q.EINTR), constant.MakeInt64(int64(q.EINTR))},
			"EINVAL":          {reflect.TypeOf(q.EINVAL), constant.MakeInt64(int64(q.EINVAL))},
			"EIO":             {reflect.TypeOf(q.EIO), constant.MakeInt64(int64(q.EIO))},
			"EISCONN":         {reflect.TypeOf(q.EISCONN), constant.MakeInt64(int64(q.EISCONN))},
			"EISDIR":          {reflect.TypeOf(q.EISDIR), constant.MakeInt64(int64(q.EISDIR))},
			"EL2HLT":          {reflect.TypeOf(q.EL2HLT), constant.MakeInt64(int64(q.EL2HLT))},
			"EL2NSYNC":        {reflect.TypeOf(q.EL2NSYNC), constant.MakeInt64(int64(q.EL2NSYNC))},
			"EL3HLT":          {reflect.TypeOf(q.EL3HLT), constant.MakeInt64(int64(q.EL3HLT))},
			"EL3RST":          {reflect.TypeOf(q.EL3RST), constant.MakeInt64(int64(q.EL3RST))},
			"ELNRNG":          {reflect.TypeOf(q.ELNRNG), constant.MakeInt64(int64(q.ELNRNG))},
			"ELOOP":           {reflect.TypeOf(q.ELOOP), constant.MakeInt64(int64(q.ELOOP))},
			"EMEDIA":          {reflect.TypeOf(q.EMEDIA), constant.MakeInt64(int64(q.EMEDIA))},
			"EMFILE":          {reflect.TypeOf(q.EMFILE), constant.MakeInt64(int64(q.EMFILE))},
			"EMLINK":          {reflect.TypeOf(q.EMLINK), constant.MakeInt64(int64(q.EMLINK))},
			"EMSGSIZE":        {reflect.TypeOf(q.EMSGSIZE), constant.MakeInt64(int64(q.EMSGSIZE))},
			"EMULTIHOP":       {reflect.TypeOf(q.EMULTIHOP), constant.MakeInt64(int64(q.EMULTIHOP))},
			"ENAMETOOLONG":    {reflect.TypeOf(q.ENAMETOOLONG), constant.MakeInt64(int64(q.ENAMETOOLONG))},
			"ENETDOWN":        {reflect.TypeOf(q.ENETDOWN), constant.MakeInt64(int64(q.ENETDOWN))},
			"ENETRESET":       {reflect.TypeOf(q.ENETRESET), constant.MakeInt64(int64(q.ENETRESET))},
			"ENETUNREACH":     {reflect.TypeOf(q.ENETUNREACH), constant.MakeInt64(int64(q.ENETUNREACH))},
			"ENFILE":          {reflect.TypeOf(q.ENFILE), constant.MakeInt64(int64(q.ENFILE))},
			"ENOATTR":         {reflect.TypeOf(q.ENOATTR), constant.MakeInt64(int64(q.ENOATTR))},
			"ENOBUFS":         {reflect.TypeOf(q.ENOBUFS), constant.MakeInt64(int64(q.ENOBUFS))},
			"ENOCONNECT":      {reflect.TypeOf(q.ENOCONNECT), constant.MakeInt64(int64(q.ENOCONNECT))},
			"ENOCSI":          {reflect.TypeOf(q.ENOCSI), constant.MakeInt64(int64(q.ENOCSI))},
			"ENODATA":         {reflect.TypeOf(q.ENODATA), constant.MakeInt64(int64(q.ENODATA))},
			"ENODEV":          {reflect.TypeOf(q.ENODEV), constant.MakeInt64(int64(q.ENODEV))},
			"ENOENT":          {reflect.TypeOf(q.ENOENT), constant.MakeInt64(int64(q.ENOENT))},
			"ENOEXEC":         {reflect.TypeOf(q.ENOEXEC), constant.MakeInt64(int64(q.ENOEXEC))},
			"ENOLCK":          {reflect.TypeOf(q.ENOLCK), constant.MakeInt64(int64(q.ENOLCK))},
			"ENOLINK":         {reflect.TypeOf(q.ENOLINK), constant.MakeInt64(int64(q.ENOLINK))},
			"ENOMEM":          {reflect.TypeOf(q.ENOMEM), constant.MakeInt64(int64(q.ENOMEM))},
			"ENOMSG":          {reflect.TypeOf(q.ENOMSG), constant.MakeInt64(int64(q.ENOMSG))},
			"ENOPROTOOPT":     {reflect.TypeOf(q.ENOPROTOOPT), constant.MakeInt64(int64(q.ENOPROTOOPT))},
			"ENOSPC":          {reflect.TypeOf(q.ENOSPC), constant.MakeInt64(int64(q.ENOSPC))},
			"ENOSR":           {reflect.TypeOf(q.ENOSR), constant.MakeInt64(int64(q.ENOSR))},
			"ENOSTR":          {reflect.TypeOf(q.ENOSTR), constant.MakeInt64(int64(q.ENOSTR))},
			"ENOSYS":          {reflect.TypeOf(q.ENOSYS), constant.MakeInt64(int64(q.ENOSYS))},
			"ENOTBLK":         {reflect.TypeOf(q.ENOTBLK), constant.MakeInt64(int64(q.ENOTBLK))},
			"ENOTCONN":        {reflect.TypeOf(q.ENOTCONN), constant.MakeInt64(int64(q.ENOTCONN))},
			"ENOTDIR":         {reflect.TypeOf(q.ENOTDIR), constant.MakeInt64(int64(q.ENOTDIR))},
			"ENOTEMPTY":       {reflect.TypeOf(q.ENOTEMPTY), constant.MakeInt64(int64(q.ENOTEMPTY))},
			"ENOTREADY":       {reflect.TypeOf(q.ENOTREADY), constant.MakeInt64(int64(q.ENOTREADY))},
			"ENOTRECOVERABLE": {reflect.TypeOf(q.ENOTRECOVERABLE), constant.MakeInt64(int64(q.ENOTRECOVERABLE))},
			"ENOTRUST":        {reflect.TypeOf(q.ENOTRUST), constant.MakeInt64(int64(q.ENOTRUST))},
			"ENOTSOCK":        {reflect.TypeOf(q.ENOTSOCK), constant.MakeInt64(int64(q.ENOTSOCK))},
			"ENOTSUP":         {reflect.TypeOf(q.ENOTSUP), constant.MakeInt64(int64(q.ENOTSUP))},
			"ENOTTY":          {reflect.TypeOf(q.ENOTTY), constant.MakeInt64(int64(q.ENOTTY))},
			"ENXIO":           {reflect.TypeOf(q.ENXIO), constant.MakeInt64(int64(q.ENXIO))},
			"EOPNOTSUPP":      {reflect.TypeOf(q.EOPNOTSUPP), constant.MakeInt64(int64(q.EOPNOTSUPP))},
			"EOVERFLOW":       {reflect.TypeOf(q.EOVERFLOW), constant.MakeInt64(int64(q.EOVERFLOW))},
			"EOWNERDEAD":      {reflect.TypeOf(q.EOWNERDEAD), constant.MakeInt64(int64(q.EOWNERDEAD))},
			"EPERM":           {reflect.TypeOf(q.EPERM), constant.MakeInt64(int64(q.EPERM))},
			"EPFNOSUPPORT":    {reflect.TypeOf(q.EPFNOSUPPORT), constant.MakeInt64(int64(q.EPFNOSUPPORT))},
			"EPIPE":           {reflect.TypeOf(q.EPIPE), constant.MakeInt64(int64(q.EPIPE))},
			"EPROCLIM":        {reflect.TypeOf(q.EPROCLIM), constant.MakeInt64(int64(q.EPROCLIM))},
			"EPROTO":          {reflect.TypeOf(q.EPROTO), constant.MakeInt64(int64(q.EPROTO))},
			"EPROTONOSUPPORT": {reflect.TypeOf(q.EPROTONOSUPPORT), constant.MakeInt64(int64(q.EPROTONOSUPPORT))},
			"EPROTOTYPE":      {reflect.TypeOf(q.EPROTOTYPE), constant.MakeInt64(int64(q.EPROTOTYPE))},
			"ERANGE":          {reflect.TypeOf(q.ERANGE), constant.MakeInt64(int64(q.ERANGE))},
			"EREMOTE":         {reflect.TypeOf(q.EREMOTE), constant.MakeInt64(int64(q.EREMOTE))},
			"ERESTART":        {reflect.TypeOf(q.ERESTART), constant.MakeInt64(int64(q.ERESTART))},
			"EROFS":           {reflect.TypeOf(q.EROFS), constant.MakeInt64(int64(q.EROFS))},
			"ESAD":            {reflect.TypeOf(q.ESAD), constant.MakeInt64(int64(q.ESAD))},
			"ESHUTDOWN":       {reflect.TypeOf(q.ESHUTDOWN), constant.MakeInt64(int64(q.ESHUTDOWN))},
			"ESOCKTNOSUPPORT": {reflect.TypeOf(q.ESOCKTNOSUPPORT), constant.MakeInt64(int64(q.ESOCKTNOSUPPORT))},
			"ESOFT":           {reflect.TypeOf(q.ESOFT), constant.MakeInt64(int64(q.ESOFT))},
			"ESPIPE":          {reflect.TypeOf(q.ESPIPE), constant.MakeInt64(int64(q.ESPIPE))},
			"ESRCH":           {reflect.TypeOf(q.ESRCH), constant.MakeInt64(int64(q.ESRCH))},
			"ESTALE":          {reflect.TypeOf(q.ESTALE), constant.MakeInt64(int64(q.ESTALE))},
			"ESYSERROR":       {reflect.TypeOf(q.ESYSERROR), constant.MakeInt64(int64(q.ESYSERROR))},
			"ETIME":           {reflect.TypeOf(q.ETIME), constant.MakeInt64(int64(q.ETIME))},
			"ETIMEDOUT":       {reflect.TypeOf(q.ETIMEDOUT), constant.MakeInt64(int64(q.ETIMEDOUT))},
			"ETOOMANYREFS":    {reflect.TypeOf(q.ETOOMANYREFS), constant.MakeInt64(int64(q.ETOOMANYREFS))},
			"ETXTBSY":         {reflect.TypeOf(q.ETXTBSY), constant.MakeInt64(int64(q.ETXTBSY))},
			"EUNATCH":         {reflect.TypeOf(q.EUNATCH), constant.MakeInt64(int64(q.EUNATCH))},
			"EUSERS":          {reflect.TypeOf(q.EUSERS), constant.MakeInt64(int64(q.EUSERS))},
			"EWOULDBLOCK":     {reflect.TypeOf(q.EWOULDBLOCK), constant.MakeInt64(int64(q.EWOULDBLOCK))},
			"EWRPROTECT":      {reflect.TypeOf(q.EWRPROTECT), constant.MakeInt64(int64(q.EWRPROTECT))},
			"EXDEV":           {reflect.TypeOf(q.EXDEV), constant.MakeInt64(int64(q.EXDEV))},
			"SIGABRT":         {reflect.TypeOf(q.SIGABRT), constant.MakeInt64(int64(q.SIGABRT))},
			"SIGAIO":          {reflect.TypeOf(q.SIGAIO), constant.MakeInt64(int64(q.SIGAIO))},
			"SIGALRM":         {reflect.TypeOf(q.SIGALRM), constant.MakeInt64(int64(q.SIGALRM))},
			"SIGALRM1":        {reflect.TypeOf(q.SIGALRM1), constant.MakeInt64(int64(q.SIGALRM1))},
			"SIGBUS":          {reflect.TypeOf(q.SIGBUS), constant.MakeInt64(int64(q.SIGBUS))},
			"SIGCAPI":         {reflect.TypeOf(q.SIGCAPI), constant.MakeInt64(int64(q.SIGCAPI))},
			"SIGCHLD":         {reflect.TypeOf(q.SIGCHLD), constant.MakeInt64(int64(q.SIGCHLD))},
			"SIGCLD":          {reflect.TypeOf(q.SIGCLD), constant.MakeInt64(int64(q.SIGCLD))},
			"SIGCONT":         {reflect.TypeOf(q.SIGCONT), constant.MakeInt64(int64(q.SIGCONT))},
			"SIGCPUFAIL":      {reflect.TypeOf(q.SIGCPUFAIL), constant.MakeInt64(int64(q.SIGCPUFAIL))},
			"SIGDANGER":       {reflect.TypeOf(q.SIGDANGER), constant.MakeInt64(int64(q.SIGDANGER))},
			"SIGEMT":          {reflect.TypeOf(q.SIGEMT), constant.MakeInt64(int64(q.SIGEMT))},
			"SIGFPE":          {reflect.TypeOf(q.SIGFPE), constant.MakeInt64(int64(q.SIGFPE))},
			"SIGGRANT":        {reflect.TypeOf(q.SIGGRANT), constant.MakeInt64(int64(q.SIGGRANT))},
			"SIGHUP":          {reflect.TypeOf(q.SIGHUP), constant.MakeInt64(int64(q.SIGHUP))},
			"SIGILL":          {reflect.TypeOf(q.SIGILL), constant.MakeInt64(int64(q.SIGILL))},
			"SIGINT":          {reflect.TypeOf(q.SIGINT), constant.MakeInt64(int64(q.SIGINT))},
			"SIGIO":           {reflect.TypeOf(q.SIGIO), constant.MakeInt64(int64(q.SIGIO))},
			"SIGIOINT":        {reflect.TypeOf(q.SIGIOINT), constant.MakeInt64(int64(q.SIGIOINT))},
			"SIGIOT":          {reflect.TypeOf(q.SIGIOT), constant.MakeInt64(int64(q.SIGIOT))},
			"SIGKAP":          {reflect.TypeOf(q.SIGKAP), constant.MakeInt64(int64(q.SIGKAP))},
			"SIGKILL":         {reflect.TypeOf(q.SIGKILL), constant.MakeInt64(int64(q.SIGKILL))},
			"SIGLOST":         {reflect.TypeOf(q.SIGLOST), constant.MakeInt64(int64(q.SIGLOST))},
			"SIGMAX":          {reflect.TypeOf(q.SIGMAX), constant.MakeInt64(int64(q.SIGMAX))},
			"SIGMAX32":        {reflect.TypeOf(q.SIGMAX32), constant.MakeInt64(int64(q.SIGMAX32))},
			"SIGMAX64":        {reflect.TypeOf(q.SIGMAX64), constant.MakeInt64(int64(q.SIGMAX64))},
			"SIGMIGRATE":      {reflect.TypeOf(q.SIGMIGRATE), constant.MakeInt64(int64(q.SIGMIGRATE))},
			"SIGMSG":          {reflect.TypeOf(q.SIGMSG), constant.MakeInt64(int64(q.SIGMSG))},
			"SIGPIPE":         {reflect.TypeOf(q.SIGPIPE), constant.MakeInt64(int64(q.SIGPIPE))},
			"SIGPOLL":         {reflect.TypeOf(q.SIGPOLL), constant.MakeInt64(int64(q.SIGPOLL))},
			"SIGPRE":          {reflect.TypeOf(q.SIGPRE), constant.MakeInt64(int64(q.SIGPRE))},
			"SIGPROF":         {reflect.TypeOf(q.SIGPROF), constant.MakeInt64(int64(q.SIGPROF))},
			"SIGPTY":          {reflect.TypeOf(q.SIGPTY), constant.MakeInt64(int64(q.SIGPTY))},
			"SIGPWR":          {reflect.TypeOf(q.SIGPWR), constant.MakeInt64(int64(q.SIGPWR))},
			"SIGQUIT":         {reflect.TypeOf(q.SIGQUIT), constant.MakeInt64(int64(q.SIGQUIT))},
			"SIGRECONFIG":     {reflect.TypeOf(q.SIGRECONFIG), constant.MakeInt64(int64(q.SIGRECONFIG))},
			"SIGRETRACT":      {reflect.TypeOf(q.SIGRETRACT), constant.MakeInt64(int64(q.SIGRETRACT))},
			"SIGSAK":          {reflect.TypeOf(q.SIGSAK), constant.MakeInt64(int64(q.SIGSAK))},
			"SIGSEGV":         {reflect.TypeOf(q.SIGSEGV), constant.MakeInt64(int64(q.SIGSEGV))},
			"SIGSOUND":        {reflect.TypeOf(q.SIGSOUND), constant.MakeInt64(int64(q.SIGSOUND))},
			"SIGSTOP":         {reflect.TypeOf(q.SIGSTOP), constant.MakeInt64(int64(q.SIGSTOP))},
			"SIGSYS":          {reflect.TypeOf(q.SIGSYS), constant.MakeInt64(int64(q.SIGSYS))},
			"SIGSYSERROR":     {reflect.TypeOf(q.SIGSYSERROR), constant.MakeInt64(int64(q.SIGSYSERROR))},
			"SIGTALRM":        {reflect.TypeOf(q.SIGTALRM), constant.MakeInt64(int64(q.SIGTALRM))},
			"SIGTERM":         {reflect.TypeOf(q.SIGTERM), constant.MakeInt64(int64(q.SIGTERM))},
			"SIGTRAP":         {reflect.TypeOf(q.SIGTRAP), constant.MakeInt64(int64(q.SIGTRAP))},
			"SIGTSTP":         {reflect.TypeOf(q.SIGTSTP), constant.MakeInt64(int64(q.SIGTSTP))},
			"SIGTTIN":         {reflect.TypeOf(q.SIGTTIN), constant.MakeInt64(int64(q.SIGTTIN))},
			"SIGTTOU":         {reflect.TypeOf(q.SIGTTOU), constant.MakeInt64(int64(q.SIGTTOU))},
			"SIGURG":          {reflect.TypeOf(q.SIGURG), constant.MakeInt64(int64(q.SIGURG))},
			"SIGUSR1":         {reflect.TypeOf(q.SIGUSR1), constant.MakeInt64(int64(q.SIGUSR1))},
			"SIGUSR2":         {reflect.TypeOf(q.SIGUSR2), constant.MakeInt64(int64(q.SIGUSR2))},
			"SIGVIRT":         {reflect.TypeOf(q.SIGVIRT), constant.MakeInt64(int64(q.SIGVIRT))},
			"SIGVTALRM":       {reflect.TypeOf(q.SIGVTALRM), constant.MakeInt64(int64(q.SIGVTALRM))},
			"SIGWAITING":      {reflect.TypeOf(q.SIGWAITING), constant.MakeInt64(int64(q.SIGWAITING))},
			"SIGWINCH":        {reflect.TypeOf(q.SIGWINCH), constant.MakeInt64(int64(q.SIGWINCH))},
			"SIGXCPU":         {reflect.TypeOf(q.SIGXCPU), constant.MakeInt64(int64(q.SIGXCPU))},
			"SIGXFSZ":         {reflect.TypeOf(q.SIGXFSZ), constant.MakeInt64(int64(q.SIGXFSZ))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"AF_APPLETALK":                  {"untyped int", constant.MakeInt64(int64(q.AF_APPLETALK))},
			"AF_BYPASS":                     {"untyped int", constant.MakeInt64(int64(q.AF_BYPASS))},
			"AF_CCITT":                      {"untyped int", constant.MakeInt64(int64(q.AF_CCITT))},
			"AF_CHAOS":                      {"untyped int", constant.MakeInt64(int64(q.AF_CHAOS))},
			"AF_DATAKIT":                    {"untyped int", constant.MakeInt64(int64(q.AF_DATAKIT))},
			"AF_DECnet":                     {"untyped int", constant.MakeInt64(int64(q.AF_DECnet))},
			"AF_DLI":                        {"untyped int", constant.MakeInt64(int64(q.AF_DLI))},
			"AF_ECMA":                       {"untyped int", constant.MakeInt64(int64(q.AF_ECMA))},
			"AF_HYLINK":                     {"untyped int", constant.MakeInt64(int64(q.AF_HYLINK))},
			"AF_IMPLINK":                    {"untyped int", constant.MakeInt64(int64(q.AF_IMPLINK))},
			"AF_INET":                       {"untyped int", constant.MakeInt64(int64(q.AF_INET))},
			"AF_INET6":                      {"untyped int", constant.MakeInt64(int64(q.AF_INET6))},
			"AF_INTF":                       {"untyped int", constant.MakeInt64(int64(q.AF_INTF))},
			"AF_ISO":                        {"untyped int", constant.MakeInt64(int64(q.AF_ISO))},
			"AF_LAT":                        {"untyped int", constant.MakeInt64(int64(q.AF_LAT))},
			"AF_LINK":                       {"untyped int", constant.MakeInt64(int64(q.AF_LINK))},
			"AF_LOCAL":                      {"untyped int", constant.MakeInt64(int64(q.AF_LOCAL))},
			"AF_MAX":                        {"untyped int", constant.MakeInt64(int64(q.AF_MAX))},
			"AF_NDD":                        {"untyped int", constant.MakeInt64(int64(q.AF_NDD))},
			"AF_NETWARE":                    {"untyped int", constant.MakeInt64(int64(q.AF_NETWARE))},
			"AF_NS":                         {"untyped int", constant.MakeInt64(int64(q.AF_NS))},
			"AF_OSI":                        {"untyped int", constant.MakeInt64(int64(q.AF_OSI))},
			"AF_PUP":                        {"untyped int", constant.MakeInt64(int64(q.AF_PUP))},
			"AF_RIF":                        {"untyped int", constant.MakeInt64(int64(q.AF_RIF))},
			"AF_ROUTE":                      {"untyped int", constant.MakeInt64(int64(q.AF_ROUTE))},
			"AF_SNA":                        {"untyped int", constant.MakeInt64(int64(q.AF_SNA))},
			"AF_UNIX":                       {"untyped int", constant.MakeInt64(int64(q.AF_UNIX))},
			"AF_UNSPEC":                     {"untyped int", constant.MakeInt64(int64(q.AF_UNSPEC))},
			"ARPHRD_802_3":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_802_3))},
			"ARPHRD_802_5":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_802_5))},
			"ARPHRD_ETHER":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ETHER))},
			"ARPHRD_FDDI":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FDDI))},
			"B0":                            {"untyped int", constant.MakeInt64(int64(q.B0))},
			"B110":                          {"untyped int", constant.MakeInt64(int64(q.B110))},
			"B1200":                         {"untyped int", constant.MakeInt64(int64(q.B1200))},
			"B134":                          {"untyped int", constant.MakeInt64(int64(q.B134))},
			"B150":                          {"untyped int", constant.MakeInt64(int64(q.B150))},
			"B1800":                         {"untyped int", constant.MakeInt64(int64(q.B1800))},
			"B19200":                        {"untyped int", constant.MakeInt64(int64(q.B19200))},
			"B200":                          {"untyped int", constant.MakeInt64(int64(q.B200))},
			"B2400":                         {"untyped int", constant.MakeInt64(int64(q.B2400))},
			"B300":                          {"untyped int", constant.MakeInt64(int64(q.B300))},
			"B38400":                        {"untyped int", constant.MakeInt64(int64(q.B38400))},
			"B4800":                         {"untyped int", constant.MakeInt64(int64(q.B4800))},
			"B50":                           {"untyped int", constant.MakeInt64(int64(q.B50))},
			"B600":                          {"untyped int", constant.MakeInt64(int64(q.B600))},
			"B75":                           {"untyped int", constant.MakeInt64(int64(q.B75))},
			"B9600":                         {"untyped int", constant.MakeInt64(int64(q.B9600))},
			"BRKINT":                        {"untyped int", constant.MakeInt64(int64(q.BRKINT))},
			"CFLUSH":                        {"untyped int", constant.MakeInt64(int64(q.CFLUSH))},
			"CLOCAL":                        {"untyped int", constant.MakeInt64(int64(q.CLOCAL))},
			"CREAD":                         {"untyped int", constant.MakeInt64(int64(q.CREAD))},
			"CS5":                           {"untyped int", constant.MakeInt64(int64(q.CS5))},
			"CS6":                           {"untyped int", constant.MakeInt64(int64(q.CS6))},
			"CS7":                           {"untyped int", constant.MakeInt64(int64(q.CS7))},
			"CS8":                           {"untyped int", constant.MakeInt64(int64(q.CS8))},
			"CSIOCGIFCONF":                  {"untyped int", constant.MakeInt64(int64(q.CSIOCGIFCONF))},
			"CSIZE":                         {"untyped int", constant.MakeInt64(int64(q.CSIZE))},
			"CSMAP_DIR":                     {"untyped string", constant.MakeString(string(q.CSMAP_DIR))},
			"CSTART":                        {"untyped rune", constant.MakeInt64(int64(q.CSTART))},
			"CSTOP":                         {"untyped rune", constant.MakeInt64(int64(q.CSTOP))},
			"CSTOPB":                        {"untyped int", constant.MakeInt64(int64(q.CSTOPB))},
			"CSUSP":                         {"untyped int", constant.MakeInt64(int64(q.CSUSP))},
			"ECHO":                          {"untyped int", constant.MakeInt64(int64(q.ECHO))},
			"ECHOCTL":                       {"untyped int", constant.MakeInt64(int64(q.ECHOCTL))},
			"ECHOE":                         {"untyped int", constant.MakeInt64(int64(q.ECHOE))},
			"ECHOK":                         {"untyped int", constant.MakeInt64(int64(q.ECHOK))},
			"ECHOKE":                        {"untyped int", constant.MakeInt64(int64(q.ECHOKE))},
			"ECHONL":                        {"untyped int", constant.MakeInt64(int64(q.ECHONL))},
			"ECHOPRT":                       {"untyped int", constant.MakeInt64(int64(q.ECHOPRT))},
			"ECH_ICMPID":                    {"untyped int", constant.MakeInt64(int64(q.ECH_ICMPID))},
			"ETHERNET_CSMACD":               {"untyped int", constant.MakeInt64(int64(q.ETHERNET_CSMACD))},
			"EVENP":                         {"untyped int", constant.MakeInt64(int64(q.EVENP))},
			"EXCONTINUE":                    {"untyped int", constant.MakeInt64(int64(q.EXCONTINUE))},
			"EXDLOK":                        {"untyped int", constant.MakeInt64(int64(q.EXDLOK))},
			"EXIO":                          {"untyped int", constant.MakeInt64(int64(q.EXIO))},
			"EXPGIO":                        {"untyped int", constant.MakeInt64(int64(q.EXPGIO))},
			"EXRESUME":                      {"untyped int", constant.MakeInt64(int64(q.EXRESUME))},
			"EXRETURN":                      {"untyped int", constant.MakeInt64(int64(q.EXRETURN))},
			"EXSIG":                         {"untyped int", constant.MakeInt64(int64(q.EXSIG))},
			"EXTA":                          {"untyped int", constant.MakeInt64(int64(q.EXTA))},
			"EXTB":                          {"untyped int", constant.MakeInt64(int64(q.EXTB))},
			"EXTRAP":                        {"untyped int", constant.MakeInt64(int64(q.EXTRAP))},
			"EYEC_RTENTRYA":                 {"untyped int", constant.MakeInt64(int64(q.EYEC_RTENTRYA))},
			"EYEC_RTENTRYF":                 {"untyped int", constant.MakeInt64(int64(q.EYEC_RTENTRYF))},
			"E_ACC":                         {"untyped int", constant.MakeInt64(int64(q.E_ACC))},
			"FD_CLOEXEC":                    {"untyped int", constant.MakeInt64(int64(q.FD_CLOEXEC))},
			"FD_SETSIZE":                    {"untyped int", constant.MakeInt64(int64(q.FD_SETSIZE))},
			"FLUSHBAND":                     {"untyped int", constant.MakeInt64(int64(q.FLUSHBAND))},
			"FLUSHLOW":                      {"untyped int", constant.MakeInt64(int64(q.FLUSHLOW))},
			"FLUSHO":                        {"untyped int", constant.MakeInt64(int64(q.FLUSHO))},
			"FLUSHR":                        {"untyped int", constant.MakeInt64(int64(q.FLUSHR))},
			"FLUSHRW":                       {"untyped int", constant.MakeInt64(int64(q.FLUSHRW))},
			"FLUSHW":                        {"untyped int", constant.MakeInt64(int64(q.FLUSHW))},
			"F_CLOSEM":                      {"untyped int", constant.MakeInt64(int64(q.F_CLOSEM))},
			"F_DUP2FD":                      {"untyped int", constant.MakeInt64(int64(q.F_DUP2FD))},
			"F_DUPFD":                       {"untyped int", constant.MakeInt64(int64(q.F_DUPFD))},
			"F_DUPFD_CLOEXEC":               {"untyped int", constant.MakeInt64(int64(q.F_DUPFD_CLOEXEC))},
			"F_GETFD":                       {"untyped int", constant.MakeInt64(int64(q.F_GETFD))},
			"F_GETFL":                       {"untyped int", constant.MakeInt64(int64(q.F_GETFL))},
			"F_GETLK":                       {"untyped int", constant.MakeInt64(int64(q.F_GETLK))},
			"F_GETLK64":                     {"untyped int", constant.MakeInt64(int64(q.F_GETLK64))},
			"F_GETOWN":                      {"untyped int", constant.MakeInt64(int64(q.F_GETOWN))},
			"F_LOCK":                        {"untyped int", constant.MakeInt64(int64(q.F_LOCK))},
			"F_OK":                          {"untyped int", constant.MakeInt64(int64(q.F_OK))},
			"F_RDLCK":                       {"untyped int", constant.MakeInt64(int64(q.F_RDLCK))},
			"F_SETFD":                       {"untyped int", constant.MakeInt64(int64(q.F_SETFD))},
			"F_SETFL":                       {"untyped int", constant.MakeInt64(int64(q.F_SETFL))},
			"F_SETLK":                       {"untyped int", constant.MakeInt64(int64(q.F_SETLK))},
			"F_SETLK64":                     {"untyped int", constant.MakeInt64(int64(q.F_SETLK64))},
			"F_SETLKW":                      {"untyped int", constant.MakeInt64(int64(q.F_SETLKW))},
			"F_SETLKW64":                    {"untyped int", constant.MakeInt64(int64(q.F_SETLKW64))},
			"F_SETOWN":                      {"untyped int", constant.MakeInt64(int64(q.F_SETOWN))},
			"F_TEST":                        {"untyped int", constant.MakeInt64(int64(q.F_TEST))},
			"F_TLOCK":                       {"untyped int", constant.MakeInt64(int64(q.F_TLOCK))},
			"F_TSTLK":                       {"untyped int", constant.MakeInt64(int64(q.F_TSTLK))},
			"F_ULOCK":                       {"untyped int", constant.MakeInt64(int64(q.F_ULOCK))},
			"F_UNLCK":                       {"untyped int", constant.MakeInt64(int64(q.F_UNLCK))},
			"F_WRLCK":                       {"untyped int", constant.MakeInt64(int64(q.F_WRLCK))},
			"HUPCL":                         {"untyped int", constant.MakeInt64(int64(q.HUPCL))},
			"ICANON":                        {"untyped int", constant.MakeInt64(int64(q.ICANON))},
			"ICMP6_FILTER":                  {"untyped int", constant.MakeInt64(int64(q.ICMP6_FILTER))},
			"ICMP6_SEC_SEND_DEL":            {"untyped int", constant.MakeInt64(int64(q.ICMP6_SEC_SEND_DEL))},
			"ICMP6_SEC_SEND_GET":            {"untyped int", constant.MakeInt64(int64(q.ICMP6_SEC_SEND_GET))},
			"ICMP6_SEC_SEND_SET":            {"untyped int", constant.MakeInt64(int64(q.ICMP6_SEC_SEND_SET))},
			"ICMP6_SEC_SEND_SET_CGA_ADDR":   {"untyped int", constant.MakeInt64(int64(q.ICMP6_SEC_SEND_SET_CGA_ADDR))},
			"ICRNL":                         {"untyped int", constant.MakeInt64(int64(q.ICRNL))},
			"IEXTEN":                        {"untyped int", constant.MakeInt64(int64(q.IEXTEN))},
			"IFA_FIRSTALIAS":                {"untyped int", constant.MakeInt64(int64(q.IFA_FIRSTALIAS))},
			"IFA_ROUTE":                     {"untyped int", constant.MakeInt64(int64(q.IFA_ROUTE))},
			"IFF_64BIT":                     {"untyped int", constant.MakeInt64(int64(q.IFF_64BIT))},
			"IFF_ALLCAST":                   {"untyped int", constant.MakeInt64(int64(q.IFF_ALLCAST))},
			"IFF_ALLMULTI":                  {"untyped int", constant.MakeInt64(int64(q.IFF_ALLMULTI))},
			"IFF_BPF":                       {"untyped int", constant.MakeInt64(int64(q.IFF_BPF))},
			"IFF_BRIDGE":                    {"untyped int", constant.MakeInt64(int64(q.IFF_BRIDGE))},
			"IFF_BROADCAST":                 {"untyped int", constant.MakeInt64(int64(q.IFF_BROADCAST))},
			"IFF_CANTCHANGE":                {"untyped int", constant.MakeInt64(int64(q.IFF_CANTCHANGE))},
			"IFF_CHECKSUM_OFFLOAD":          {"untyped int", constant.MakeInt64(int64(q.IFF_CHECKSUM_OFFLOAD))},
			"IFF_D1":                        {"untyped int", constant.MakeInt64(int64(q.IFF_D1))},
			"IFF_D2":                        {"untyped int", constant.MakeInt64(int64(q.IFF_D2))},
			"IFF_D3":                        {"untyped int", constant.MakeInt64(int64(q.IFF_D3))},
			"IFF_D4":                        {"untyped int", constant.MakeInt64(int64(q.IFF_D4))},
			"IFF_DEBUG":                     {"untyped int", constant.MakeInt64(int64(q.IFF_DEBUG))},
			"IFF_DEVHEALTH":                 {"untyped int", constant.MakeInt64(int64(q.IFF_DEVHEALTH))},
			"IFF_DO_HW_LOOPBACK":            {"untyped int", constant.MakeInt64(int64(q.IFF_DO_HW_LOOPBACK))},
			"IFF_GROUP_ROUTING":             {"untyped int", constant.MakeInt64(int64(q.IFF_GROUP_ROUTING))},
			"IFF_IFBUFMGT":                  {"untyped int", constant.MakeInt64(int64(q.IFF_IFBUFMGT))},
			"IFF_LINK0":                     {"untyped int", constant.MakeInt64(int64(q.IFF_LINK0))},
			"IFF_LINK1":                     {"untyped int", constant.MakeInt64(int64(q.IFF_LINK1))},
			"IFF_LINK2":                     {"untyped int", constant.MakeInt64(int64(q.IFF_LINK2))},
			"IFF_LOOPBACK":                  {"untyped int", constant.MakeInt64(int64(q.IFF_LOOPBACK))},
			"IFF_MULTICAST":                 {"untyped int", constant.MakeInt64(int64(q.IFF_MULTICAST))},
			"IFF_NOARP":                     {"untyped int", constant.MakeInt64(int64(q.IFF_NOARP))},
			"IFF_NOECHO":                    {"untyped int", constant.MakeInt64(int64(q.IFF_NOECHO))},
			"IFF_NOTRAILERS":                {"untyped int", constant.MakeInt64(int64(q.IFF_NOTRAILERS))},
			"IFF_OACTIVE":                   {"untyped int", constant.MakeInt64(int64(q.IFF_OACTIVE))},
			"IFF_POINTOPOINT":               {"untyped int", constant.MakeInt64(int64(q.IFF_POINTOPOINT))},
			"IFF_PROMISC":                   {"untyped int", constant.MakeInt64(int64(q.IFF_PROMISC))},
			"IFF_PSEG":                      {"untyped int", constant.MakeInt64(int64(q.IFF_PSEG))},
			"IFF_RUNNING":                   {"untyped int", constant.MakeInt64(int64(q.IFF_RUNNING))},
			"IFF_SIMPLEX":                   {"untyped int", constant.MakeInt64(int64(q.IFF_SIMPLEX))},
			"IFF_SNAP":                      {"untyped int", constant.MakeInt64(int64(q.IFF_SNAP))},
			"IFF_TCP_DISABLE_CKSUM":         {"untyped int", constant.MakeInt64(int64(q.IFF_TCP_DISABLE_CKSUM))},
			"IFF_TCP_NOCKSUM":               {"untyped int", constant.MakeInt64(int64(q.IFF_TCP_NOCKSUM))},
			"IFF_UP":                        {"untyped int", constant.MakeInt64(int64(q.IFF_UP))},
			"IFF_VIPA":                      {"untyped int", constant.MakeInt64(int64(q.IFF_VIPA))},
			"IFNAMSIZ":                      {"untyped int", constant.MakeInt64(int64(q.IFNAMSIZ))},
			"IFO_FLUSH":                     {"untyped int", constant.MakeInt64(int64(q.IFO_FLUSH))},
			"IFT_1822":                      {"untyped int", constant.MakeInt64(int64(q.IFT_1822))},
			"IFT_AAL5":                      {"untyped int", constant.MakeInt64(int64(q.IFT_AAL5))},
			"IFT_ARCNET":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNET))},
			"IFT_ARCNETPLUS":                {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNETPLUS))},
			"IFT_ATM":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ATM))},
			"IFT_CEPT":                      {"untyped int", constant.MakeInt64(int64(q.IFT_CEPT))},
			"IFT_CLUSTER":                   {"untyped int", constant.MakeInt64(int64(q.IFT_CLUSTER))},
			"IFT_DS3":                       {"untyped int", constant.MakeInt64(int64(q.IFT_DS3))},
			"IFT_EON":                       {"untyped int", constant.MakeInt64(int64(q.IFT_EON))},
			"IFT_ETHER":                     {"untyped int", constant.MakeInt64(int64(q.IFT_ETHER))},
			"IFT_FCS":                       {"untyped int", constant.MakeInt64(int64(q.IFT_FCS))},
			"IFT_FDDI":                      {"untyped int", constant.MakeInt64(int64(q.IFT_FDDI))},
			"IFT_FRELAY":                    {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAY))},
			"IFT_FRELAYDCE":                 {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAYDCE))},
			"IFT_GIFTUNNEL":                 {"untyped int", constant.MakeInt64(int64(q.IFT_GIFTUNNEL))},
			"IFT_HDH1822":                   {"untyped int", constant.MakeInt64(int64(q.IFT_HDH1822))},
			"IFT_HF":                        {"untyped int", constant.MakeInt64(int64(q.IFT_HF))},
			"IFT_HIPPI":                     {"untyped int", constant.MakeInt64(int64(q.IFT_HIPPI))},
			"IFT_HSSI":                      {"untyped int", constant.MakeInt64(int64(q.IFT_HSSI))},
			"IFT_HY":                        {"untyped int", constant.MakeInt64(int64(q.IFT_HY))},
			"IFT_IB":                        {"untyped int", constant.MakeInt64(int64(q.IFT_IB))},
			"IFT_ISDNBASIC":                 {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNBASIC))},
			"IFT_ISDNPRIMARY":               {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNPRIMARY))},
			"IFT_ISO88022LLC":               {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88022LLC))},
			"IFT_ISO88023":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88023))},
			"IFT_ISO88024":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88024))},
			"IFT_ISO88025":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025))},
			"IFT_ISO88026":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88026))},
			"IFT_LAPB":                      {"untyped int", constant.MakeInt64(int64(q.IFT_LAPB))},
			"IFT_LOCALTALK":                 {"untyped int", constant.MakeInt64(int64(q.IFT_LOCALTALK))},
			"IFT_LOOP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_LOOP))},
			"IFT_MIOX25":                    {"untyped int", constant.MakeInt64(int64(q.IFT_MIOX25))},
			"IFT_MODEM":                     {"untyped int", constant.MakeInt64(int64(q.IFT_MODEM))},
			"IFT_NSIP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_NSIP))},
			"IFT_OTHER":                     {"untyped int", constant.MakeInt64(int64(q.IFT_OTHER))},
			"IFT_P10":                       {"untyped int", constant.MakeInt64(int64(q.IFT_P10))},
			"IFT_P80":                       {"untyped int", constant.MakeInt64(int64(q.IFT_P80))},
			"IFT_PARA":                      {"untyped int", constant.MakeInt64(int64(q.IFT_PARA))},
			"IFT_PPP":                       {"untyped int", constant.MakeInt64(int64(q.IFT_PPP))},
			"IFT_PROPMUX":                   {"untyped int", constant.MakeInt64(int64(q.IFT_PROPMUX))},
			"IFT_PROPVIRTUAL":               {"untyped int", constant.MakeInt64(int64(q.IFT_PROPVIRTUAL))},
			"IFT_PTPSERIAL":                 {"untyped int", constant.MakeInt64(int64(q.IFT_PTPSERIAL))},
			"IFT_RS232":                     {"untyped int", constant.MakeInt64(int64(q.IFT_RS232))},
			"IFT_SDLC":                      {"untyped int", constant.MakeInt64(int64(q.IFT_SDLC))},
			"IFT_SIP":                       {"untyped int", constant.MakeInt64(int64(q.IFT_SIP))},
			"IFT_SLIP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_SLIP))},
			"IFT_SMDSDXI":                   {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSDXI))},
			"IFT_SMDSICIP":                  {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSICIP))},
			"IFT_SN":                        {"untyped int", constant.MakeInt64(int64(q.IFT_SN))},
			"IFT_SONET":                     {"untyped int", constant.MakeInt64(int64(q.IFT_SONET))},
			"IFT_SONETPATH":                 {"untyped int", constant.MakeInt64(int64(q.IFT_SONETPATH))},
			"IFT_SONETVT":                   {"untyped int", constant.MakeInt64(int64(q.IFT_SONETVT))},
			"IFT_SP":                        {"untyped int", constant.MakeInt64(int64(q.IFT_SP))},
			"IFT_STARLAN":                   {"untyped int", constant.MakeInt64(int64(q.IFT_STARLAN))},
			"IFT_T1":                        {"untyped int", constant.MakeInt64(int64(q.IFT_T1))},
			"IFT_TUNNEL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_TUNNEL))},
			"IFT_ULTRA":                     {"untyped int", constant.MakeInt64(int64(q.IFT_ULTRA))},
			"IFT_V35":                       {"untyped int", constant.MakeInt64(int64(q.IFT_V35))},
			"IFT_VIPA":                      {"untyped int", constant.MakeInt64(int64(q.IFT_VIPA))},
			"IFT_X25":                       {"untyped int", constant.MakeInt64(int64(q.IFT_X25))},
			"IFT_X25DDN":                    {"untyped int", constant.MakeInt64(int64(q.IFT_X25DDN))},
			"IFT_X25PLE":                    {"untyped int", constant.MakeInt64(int64(q.IFT_X25PLE))},
			"IFT_XETHER":                    {"untyped int", constant.MakeInt64(int64(q.IFT_XETHER))},
			"IGNBRK":                        {"untyped int", constant.MakeInt64(int64(q.IGNBRK))},
			"IGNCR":                         {"untyped int", constant.MakeInt64(int64(q.IGNCR))},
			"IGNPAR":                        {"untyped int", constant.MakeInt64(int64(q.IGNPAR))},
			"IMAXBEL":                       {"untyped int", constant.MakeInt64(int64(q.IMAXBEL))},
			"INLCR":                         {"untyped int", constant.MakeInt64(int64(q.INLCR))},
			"INPCK":                         {"untyped int", constant.MakeInt64(int64(q.INPCK))},
			"IN_CLASSA_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_HOST))},
			"IN_CLASSA_MAX":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_MAX))},
			"IN_CLASSA_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NET))},
			"IN_CLASSA_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NSHIFT))},
			"IN_CLASSB_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_HOST))},
			"IN_CLASSB_MAX":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_MAX))},
			"IN_CLASSB_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NET))},
			"IN_CLASSB_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NSHIFT))},
			"IN_CLASSC_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_HOST))},
			"IN_CLASSC_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NET))},
			"IN_CLASSC_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NSHIFT))},
			"IN_CLASSD_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_HOST))},
			"IN_CLASSD_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NET))},
			"IN_CLASSD_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NSHIFT))},
			"IN_LOOPBACKNET":                {"untyped int", constant.MakeInt64(int64(q.IN_LOOPBACKNET))},
			"IN_USE":                        {"untyped int", constant.MakeInt64(int64(q.IN_USE))},
			"IPPROTO_AH":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AH))},
			"IPPROTO_BIP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BIP))},
			"IPPROTO_DSTOPTS":               {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DSTOPTS))},
			"IPPROTO_EGP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EGP))},
			"IPPROTO_EON":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EON))},
			"IPPROTO_ESP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ESP))},
			"IPPROTO_FRAGMENT":              {"untyped int", constant.MakeInt64(int64(q.IPPROTO_FRAGMENT))},
			"IPPROTO_GGP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GGP))},
			"IPPROTO_GIF":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GIF))},
			"IPPROTO_GRE":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GRE))},
			"IPPROTO_HOPOPTS":               {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HOPOPTS))},
			"IPPROTO_ICMP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMP))},
			"IPPROTO_ICMPV6":                {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMPV6))},
			"IPPROTO_IDP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDP))},
			"IPPROTO_IGMP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGMP))},
			"IPPROTO_IP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IP))},
			"IPPROTO_IPIP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPIP))},
			"IPPROTO_IPV6":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV6))},
			"IPPROTO_LOCAL":                 {"untyped int", constant.MakeInt64(int64(q.IPPROTO_LOCAL))},
			"IPPROTO_MAX":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAX))},
			"IPPROTO_MH":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MH))},
			"IPPROTO_NONE":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NONE))},
			"IPPROTO_PUP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PUP))},
			"IPPROTO_QOS":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_QOS))},
			"IPPROTO_RAW":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RAW))},
			"IPPROTO_ROUTING":               {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ROUTING))},
			"IPPROTO_RSVP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RSVP))},
			"IPPROTO_SCTP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SCTP))},
			"IPPROTO_TCP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCP))},
			"IPPROTO_TP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TP))},
			"IPPROTO_UDP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDP))},
			"IPV6_ADDRFORM":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_ADDRFORM))},
			"IPV6_ADDR_PREFERENCES":         {"untyped int", constant.MakeInt64(int64(q.IPV6_ADDR_PREFERENCES))},
			"IPV6_ADD_MEMBERSHIP":           {"untyped int", constant.MakeInt64(int64(q.IPV6_ADD_MEMBERSHIP))},
			"IPV6_AIXRAWSOCKET":             {"untyped int", constant.MakeInt64(int64(q.IPV6_AIXRAWSOCKET))},
			"IPV6_CHECKSUM":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_CHECKSUM))},
			"IPV6_DONTFRAG":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_DONTFRAG))},
			"IPV6_DROP_MEMBERSHIP":          {"untyped int", constant.MakeInt64(int64(q.IPV6_DROP_MEMBERSHIP))},
			"IPV6_DSTOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_DSTOPTS))},
			"IPV6_FLOWINFO_FLOWLABEL":       {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_FLOWLABEL))},
			"IPV6_FLOWINFO_PRIFLOW":         {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_PRIFLOW))},
			"IPV6_FLOWINFO_PRIORITY":        {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_PRIORITY))},
			"IPV6_FLOWINFO_SRFLAG":          {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_SRFLAG))},
			"IPV6_FLOWINFO_VERSION":         {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_VERSION))},
			"IPV6_HOPLIMIT":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPLIMIT))},
			"IPV6_HOPOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPOPTS))},
			"IPV6_JOIN_GROUP":               {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_GROUP))},
			"IPV6_LEAVE_GROUP":              {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_GROUP))},
			"IPV6_MIPDSTOPTS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_MIPDSTOPTS))},
			"IPV6_MULTICAST_HOPS":           {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_HOPS))},
			"IPV6_MULTICAST_IF":             {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_IF))},
			"IPV6_MULTICAST_LOOP":           {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_LOOP))},
			"IPV6_NEXTHOP":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_NEXTHOP))},
			"IPV6_NOPROBE":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_NOPROBE))},
			"IPV6_PATHMTU":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_PATHMTU))},
			"IPV6_PKTINFO":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_PKTINFO))},
			"IPV6_PKTOPTIONS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PKTOPTIONS))},
			"IPV6_PRIORITY_10":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_10))},
			"IPV6_PRIORITY_11":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_11))},
			"IPV6_PRIORITY_12":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_12))},
			"IPV6_PRIORITY_13":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_13))},
			"IPV6_PRIORITY_14":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_14))},
			"IPV6_PRIORITY_15":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_15))},
			"IPV6_PRIORITY_8":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_8))},
			"IPV6_PRIORITY_9":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_9))},
			"IPV6_PRIORITY_BULK":            {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_BULK))},
			"IPV6_PRIORITY_CONTROL":         {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_CONTROL))},
			"IPV6_PRIORITY_FILLER":          {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_FILLER))},
			"IPV6_PRIORITY_INTERACTIVE":     {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_INTERACTIVE))},
			"IPV6_PRIORITY_RESERVED1":       {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_RESERVED1))},
			"IPV6_PRIORITY_RESERVED2":       {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_RESERVED2))},
			"IPV6_PRIORITY_UNATTENDED":      {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_UNATTENDED))},
			"IPV6_PRIORITY_UNCHARACTERIZED": {"untyped int", constant.MakeInt64(int64(q.IPV6_PRIORITY_UNCHARACTERIZED))},
			"IPV6_RECVDSTOPTS":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVDSTOPTS))},
			"IPV6_RECVHOPLIMIT":             {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPLIMIT))},
			"IPV6_RECVHOPOPTS":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPOPTS))},
			"IPV6_RECVHOPS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPS))},
			"IPV6_RECVIF":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVIF))},
			"IPV6_RECVPATHMTU":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPATHMTU))},
			"IPV6_RECVPKTINFO":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPKTINFO))},
			"IPV6_RECVRTHDR":                {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVRTHDR))},
			"IPV6_RECVSRCRT":                {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVSRCRT))},
			"IPV6_RECVTCLASS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVTCLASS))},
			"IPV6_RTHDR":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR))},
			"IPV6_RTHDRDSTOPTS":             {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDRDSTOPTS))},
			"IPV6_RTHDR_TYPE_0":             {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_TYPE_0))},
			"IPV6_RTHDR_TYPE_2":             {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_TYPE_2))},
			"IPV6_SENDIF":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_SENDIF))},
			"IPV6_SRFLAG_LOOSE":             {"untyped int", constant.MakeInt64(int64(q.IPV6_SRFLAG_LOOSE))},
			"IPV6_SRFLAG_STRICT":            {"untyped int", constant.MakeInt64(int64(q.IPV6_SRFLAG_STRICT))},
			"IPV6_TCLASS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_TCLASS))},
			"IPV6_TOKEN_LENGTH":             {"untyped int", constant.MakeInt64(int64(q.IPV6_TOKEN_LENGTH))},
			"IPV6_UNICAST_HOPS":             {"untyped int", constant.MakeInt64(int64(q.IPV6_UNICAST_HOPS))},
			"IPV6_USE_MIN_MTU":              {"untyped int", constant.MakeInt64(int64(q.IPV6_USE_MIN_MTU))},
			"IPV6_V6ONLY":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_V6ONLY))},
			"IPV6_VERSION":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_VERSION))},
			"IP_ADDRFORM":                   {"untyped int", constant.MakeInt64(int64(q.IP_ADDRFORM))},
			"IP_ADD_MEMBERSHIP":             {"untyped int", constant.MakeInt64(int64(q.IP_ADD_MEMBERSHIP))},
			"IP_ADD_SOURCE_MEMBERSHIP":      {"untyped int", constant.MakeInt64(int64(q.IP_ADD_SOURCE_MEMBERSHIP))},
			"IP_BLOCK_SOURCE":               {"untyped int", constant.MakeInt64(int64(q.IP_BLOCK_SOURCE))},
			"IP_BROADCAST_IF":               {"untyped int", constant.MakeInt64(int64(q.IP_BROADCAST_IF))},
			"IP_CACHE_LINE_SIZE":            {"untyped int", constant.MakeInt64(int64(q.IP_CACHE_LINE_SIZE))},
			"IP_DEFAULT_MULTICAST_LOOP":     {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_LOOP))},
			"IP_DEFAULT_MULTICAST_TTL":      {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_TTL))},
			"IP_DF":                         {"untyped int", constant.MakeInt64(int64(q.IP_DF))},
			"IP_DHCPMODE":                   {"untyped int", constant.MakeInt64(int64(q.IP_DHCPMODE))},
			"IP_DONTFRAG":                   {"untyped int", constant.MakeInt64(int64(q.IP_DONTFRAG))},
			"IP_DROP_MEMBERSHIP":            {"untyped int", constant.MakeInt64(int64(q.IP_DROP_MEMBERSHIP))},
			"IP_DROP_SOURCE_MEMBERSHIP":     {"untyped int", constant.MakeInt64(int64(q.IP_DROP_SOURCE_MEMBERSHIP))},
			"IP_FINDPMTU":                   {"untyped int", constant.MakeInt64(int64(q.IP_FINDPMTU))},
			"IP_HDRINCL":                    {"untyped int", constant.MakeInt64(int64(q.IP_HDRINCL))},
			"IP_INC_MEMBERSHIPS":            {"untyped int", constant.MakeInt64(int64(q.IP_INC_MEMBERSHIPS))},
			"IP_INIT_MEMBERSHIP":            {"untyped int", constant.MakeInt64(int64(q.IP_INIT_MEMBERSHIP))},
			"IP_MAXPACKET":                  {"untyped int", constant.MakeInt64(int64(q.IP_MAXPACKET))},
			"IP_MF":                         {"untyped int", constant.MakeInt64(int64(q.IP_MF))},
			"IP_MSS":                        {"untyped int", constant.MakeInt64(int64(q.IP_MSS))},
			"IP_MULTICAST_HOPS":             {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_HOPS))},
			"IP_MULTICAST_IF":               {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IF))},
			"IP_MULTICAST_LOOP":             {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_LOOP))},
			"IP_MULTICAST_TTL":              {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_TTL))},
			"IP_OPT":                        {"untyped int", constant.MakeInt64(int64(q.IP_OPT))},
			"IP_OPTIONS":                    {"untyped int", constant.MakeInt64(int64(q.IP_OPTIONS))},
			"IP_PMTUAGE":                    {"untyped int", constant.MakeInt64(int64(q.IP_PMTUAGE))},
			"IP_RECVDSTADDR":                {"untyped int", constant.MakeInt64(int64(q.IP_RECVDSTADDR))},
			"IP_RECVIF":                     {"untyped int", constant.MakeInt64(int64(q.IP_RECVIF))},
			"IP_RECVIFINFO":                 {"untyped int", constant.MakeInt64(int64(q.IP_RECVIFINFO))},
			"IP_RECVINTERFACE":              {"untyped int", constant.MakeInt64(int64(q.IP_RECVINTERFACE))},
			"IP_RECVMACHDR":                 {"untyped int", constant.MakeInt64(int64(q.IP_RECVMACHDR))},
			"IP_RECVOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IP_RECVOPTS))},
			"IP_RECVRETOPTS":                {"untyped int", constant.MakeInt64(int64(q.IP_RECVRETOPTS))},
			"IP_RECVTTL":                    {"untyped int", constant.MakeInt64(int64(q.IP_RECVTTL))},
			"IP_RETOPTS":                    {"untyped int", constant.MakeInt64(int64(q.IP_RETOPTS))},
			"IP_SOURCE_FILTER":              {"untyped int", constant.MakeInt64(int64(q.IP_SOURCE_FILTER))},
			"IP_TOS":                        {"untyped int", constant.MakeInt64(int64(q.IP_TOS))},
			"IP_TTL":                        {"untyped int", constant.MakeInt64(int64(q.IP_TTL))},
			"IP_UNBLOCK_SOURCE":             {"untyped int", constant.MakeInt64(int64(q.IP_UNBLOCK_SOURCE))},
			"IP_UNICAST_HOPS":               {"untyped int", constant.MakeInt64(int64(q.IP_UNICAST_HOPS))},
			"ISIG":                          {"untyped int", constant.MakeInt64(int64(q.ISIG))},
			"ISTRIP":                        {"untyped int", constant.MakeInt64(int64(q.ISTRIP))},
			"IXANY":                         {"untyped int", constant.MakeInt64(int64(q.IXANY))},
			"IXOFF":                         {"untyped int", constant.MakeInt64(int64(q.IXOFF))},
			"IXON":                          {"untyped int", constant.MakeInt64(int64(q.IXON))},
			"I_FLUSH":                       {"untyped int", constant.MakeInt64(int64(q.I_FLUSH))},
			"ImplementsGetwd":               {"untyped bool", constant.MakeBool(bool(q.ImplementsGetwd))},
			"LNOFLSH":                       {"untyped int", constant.MakeInt64(int64(q.LNOFLSH))},
			"LOCK_EX":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_EX))},
			"LOCK_NB":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_NB))},
			"LOCK_SH":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_SH))},
			"LOCK_UN":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_UN))},
			"MADV_DONTNEED":                 {"untyped int", constant.MakeInt64(int64(q.MADV_DONTNEED))},
			"MADV_NORMAL":                   {"untyped int", constant.MakeInt64(int64(q.MADV_NORMAL))},
			"MADV_RANDOM":                   {"untyped int", constant.MakeInt64(int64(q.MADV_RANDOM))},
			"MADV_SEQUENTIAL":               {"untyped int", constant.MakeInt64(int64(q.MADV_SEQUENTIAL))},
			"MADV_SPACEAVAIL":               {"untyped int", constant.MakeInt64(int64(q.MADV_SPACEAVAIL))},
			"MADV_WILLNEED":                 {"untyped int", constant.MakeInt64(int64(q.MADV_WILLNEED))},
			"MAP_ANON":                      {"untyped int", constant.MakeInt64(int64(q.MAP_ANON))},
			"MAP_ANONYMOUS":                 {"untyped int", constant.MakeInt64(int64(q.MAP_ANONYMOUS))},
			"MAP_FILE":                      {"untyped int", constant.MakeInt64(int64(q.MAP_FILE))},
			"MAP_FIXED":                     {"untyped int", constant.MakeInt64(int64(q.MAP_FIXED))},
			"MAP_PRIVATE":                   {"untyped int", constant.MakeInt64(int64(q.MAP_PRIVATE))},
			"MAP_SHARED":                    {"untyped int", constant.MakeInt64(int64(q.MAP_SHARED))},
			"MAP_TYPE":                      {"untyped int", constant.MakeInt64(int64(q.MAP_TYPE))},
			"MAP_VARIABLE":                  {"untyped int", constant.MakeInt64(int64(q.MAP_VARIABLE))},
			"MCL_CURRENT":                   {"untyped int", constant.MakeInt64(int64(q.MCL_CURRENT))},
			"MCL_FUTURE":                    {"untyped int", constant.MakeInt64(int64(q.MCL_FUTURE))},
			"MSG_ANY":                       {"untyped int", constant.MakeInt64(int64(q.MSG_ANY))},
			"MSG_ARGEXT":                    {"untyped int", constant.MakeInt64(int64(q.MSG_ARGEXT))},
			"MSG_BAND":                      {"untyped int", constant.MakeInt64(int64(q.MSG_BAND))},
			"MSG_COMPAT":                    {"untyped int", constant.MakeInt64(int64(q.MSG_COMPAT))},
			"MSG_CTRUNC":                    {"untyped int", constant.MakeInt64(int64(q.MSG_CTRUNC))},
			"MSG_DONTROUTE":                 {"untyped int", constant.MakeInt64(int64(q.MSG_DONTROUTE))},
			"MSG_EOR":                       {"untyped int", constant.MakeInt64(int64(q.MSG_EOR))},
			"MSG_HIPRI":                     {"untyped int", constant.MakeInt64(int64(q.MSG_HIPRI))},
			"MSG_MAXIOVLEN":                 {"untyped int", constant.MakeInt64(int64(q.MSG_MAXIOVLEN))},
			"MSG_MPEG2":                     {"untyped int", constant.MakeInt64(int64(q.MSG_MPEG2))},
			"MSG_NONBLOCK":                  {"untyped int", constant.MakeInt64(int64(q.MSG_NONBLOCK))},
			"MSG_NOSIGNAL":                  {"untyped int", constant.MakeInt64(int64(q.MSG_NOSIGNAL))},
			"MSG_OOB":                       {"untyped int", constant.MakeInt64(int64(q.MSG_OOB))},
			"MSG_PEEK":                      {"untyped int", constant.MakeInt64(int64(q.MSG_PEEK))},
			"MSG_TRUNC":                     {"untyped int", constant.MakeInt64(int64(q.MSG_TRUNC))},
			"MSG_WAITALL":                   {"untyped int", constant.MakeInt64(int64(q.MSG_WAITALL))},
			"MSG_WAITFORONE":                {"untyped int", constant.MakeInt64(int64(q.MSG_WAITFORONE))},
			"MS_ASYNC":                      {"untyped int", constant.MakeInt64(int64(q.MS_ASYNC))},
			"MS_EINTR":                      {"untyped int", constant.MakeInt64(int64(q.MS_EINTR))},
			"MS_INVALIDATE":                 {"untyped int", constant.MakeInt64(int64(q.MS_INVALIDATE))},
			"MS_PER_SEC":                    {"untyped int", constant.MakeInt64(int64(q.MS_PER_SEC))},
			"MS_SYNC":                       {"untyped int", constant.MakeInt64(int64(q.MS_SYNC))},
			"NOFLSH":                        {"untyped int", constant.MakeInt64(int64(q.NOFLSH))},
			"NOFLUSH":                       {"untyped int", constant.MakeInt64(int64(q.NOFLUSH))},
			"OCRNL":                         {"untyped int", constant.MakeInt64(int64(q.OCRNL))},
			"OFDEL":                         {"untyped int", constant.MakeInt64(int64(q.OFDEL))},
			"OFILL":                         {"untyped int", constant.MakeInt64(int64(q.OFILL))},
			"ONLCR":                         {"untyped int", constant.MakeInt64(int64(q.ONLCR))},
			"ONLRET":                        {"untyped int", constant.MakeInt64(int64(q.ONLRET))},
			"ONOCR":                         {"untyped int", constant.MakeInt64(int64(q.ONOCR))},
			"ONOEOT":                        {"untyped int", constant.MakeInt64(int64(q.ONOEOT))},
			"OPOST":                         {"untyped int", constant.MakeInt64(int64(q.OPOST))},
			"O_ACCMODE":                     {"untyped int", constant.MakeInt64(int64(q.O_ACCMODE))},
			"O_APPEND":                      {"untyped int", constant.MakeInt64(int64(q.O_APPEND))},
			"O_CIO":                         {"untyped int", constant.MakeInt64(int64(q.O_CIO))},
			"O_CIOR":                        {"untyped int", constant.MakeInt64(int64(q.O_CIOR))},
			"O_CLOEXEC":                     {"untyped int", constant.MakeInt64(int64(q.O_CLOEXEC))},
			"O_CREAT":                       {"untyped int", constant.MakeInt64(int64(q.O_CREAT))},
			"O_DEFER":                       {"untyped int", constant.MakeInt64(int64(q.O_DEFER))},
			"O_DELAY":                       {"untyped int", constant.MakeInt64(int64(q.O_DELAY))},
			"O_DIRECT":                      {"untyped int", constant.MakeInt64(int64(q.O_DIRECT))},
			"O_DIRECTORY":                   {"untyped int", constant.MakeInt64(int64(q.O_DIRECTORY))},
			"O_DSYNC":                       {"untyped int", constant.MakeInt64(int64(q.O_DSYNC))},
			"O_EFSOFF":                      {"untyped int", constant.MakeInt64(int64(q.O_EFSOFF))},
			"O_EFSON":                       {"untyped int", constant.MakeInt64(int64(q.O_EFSON))},
			"O_EXCL":                        {"untyped int", constant.MakeInt64(int64(q.O_EXCL))},
			"O_EXEC":                        {"untyped int", constant.MakeInt64(int64(q.O_EXEC))},
			"O_LARGEFILE":                   {"untyped int", constant.MakeInt64(int64(q.O_LARGEFILE))},
			"O_NDELAY":                      {"untyped int", constant.MakeInt64(int64(q.O_NDELAY))},
			"O_NOCACHE":                     {"untyped int", constant.MakeInt64(int64(q.O_NOCACHE))},
			"O_NOCTTY":                      {"untyped int", constant.MakeInt64(int64(q.O_NOCTTY))},
			"O_NOFOLLOW":                    {"untyped int", constant.MakeInt64(int64(q.O_NOFOLLOW))},
			"O_NONBLOCK":                    {"untyped int", constant.MakeInt64(int64(q.O_NONBLOCK))},
			"O_NONE":                        {"untyped int", constant.MakeInt64(int64(q.O_NONE))},
			"O_NSHARE":                      {"untyped int", constant.MakeInt64(int64(q.O_NSHARE))},
			"O_RAW":                         {"untyped int", constant.MakeInt64(int64(q.O_RAW))},
			"O_RDONLY":                      {"untyped int", constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":                        {"untyped int", constant.MakeInt64(int64(q.O_RDWR))},
			"O_RSHARE":                      {"untyped int", constant.MakeInt64(int64(q.O_RSHARE))},
			"O_RSYNC":                       {"untyped int", constant.MakeInt64(int64(q.O_RSYNC))},
			"O_SEARCH":                      {"untyped int", constant.MakeInt64(int64(q.O_SEARCH))},
			"O_SNAPSHOT":                    {"untyped int", constant.MakeInt64(int64(q.O_SNAPSHOT))},
			"O_SYNC":                        {"untyped int", constant.MakeInt64(int64(q.O_SYNC))},
			"O_TRUNC":                       {"untyped int", constant.MakeInt64(int64(q.O_TRUNC))},
			"O_TTY_INIT":                    {"untyped int", constant.MakeInt64(int64(q.O_TTY_INIT))},
			"O_WRONLY":                      {"untyped int", constant.MakeInt64(int64(q.O_WRONLY))},
			"PARENB":                        {"untyped int", constant.MakeInt64(int64(q.PARENB))},
			"PAREXT":                        {"untyped int", constant.MakeInt64(int64(q.PAREXT))},
			"PARMRK":                        {"untyped int", constant.MakeInt64(int64(q.PARMRK))},
			"PARODD":                        {"untyped int", constant.MakeInt64(int64(q.PARODD))},
			"PENDIN":                        {"untyped int", constant.MakeInt64(int64(q.PENDIN))},
			"PRIO_PGRP":                     {"untyped int", constant.MakeInt64(int64(q.PRIO_PGRP))},
			"PRIO_PROCESS":                  {"untyped int", constant.MakeInt64(int64(q.PRIO_PROCESS))},
			"PRIO_USER":                     {"untyped int", constant.MakeInt64(int64(q.PRIO_USER))},
			"PROT_EXEC":                     {"untyped int", constant.MakeInt64(int64(q.PROT_EXEC))},
			"PROT_NONE":                     {"untyped int", constant.MakeInt64(int64(q.PROT_NONE))},
			"PROT_READ":                     {"untyped int", constant.MakeInt64(int64(q.PROT_READ))},
			"PROT_WRITE":                    {"untyped int", constant.MakeInt64(int64(q.PROT_WRITE))},
			"PR_64BIT":                      {"untyped int", constant.MakeInt64(int64(q.PR_64BIT))},
			"PR_ADDR":                       {"untyped int", constant.MakeInt64(int64(q.PR_ADDR))},
			"PR_ARGEXT":                     {"untyped int", constant.MakeInt64(int64(q.PR_ARGEXT))},
			"PR_ATOMIC":                     {"untyped int", constant.MakeInt64(int64(q.PR_ATOMIC))},
			"PR_CONNREQUIRED":               {"untyped int", constant.MakeInt64(int64(q.PR_CONNREQUIRED))},
			"PR_FASTHZ":                     {"untyped int", constant.MakeInt64(int64(q.PR_FASTHZ))},
			"PR_INP":                        {"untyped int", constant.MakeInt64(int64(q.PR_INP))},
			"PR_INTRLEVEL":                  {"untyped int", constant.MakeInt64(int64(q.PR_INTRLEVEL))},
			"PR_MLS":                        {"untyped int", constant.MakeInt64(int64(q.PR_MLS))},
			"PR_MLS_1_LABEL":                {"untyped int", constant.MakeInt64(int64(q.PR_MLS_1_LABEL))},
			"PR_NOEOR":                      {"untyped int", constant.MakeInt64(int64(q.PR_NOEOR))},
			"PR_RIGHTS":                     {"untyped int", constant.MakeInt64(int64(q.PR_RIGHTS))},
			"PR_SLOWHZ":                     {"untyped int", constant.MakeInt64(int64(q.PR_SLOWHZ))},
			"PR_WANTRCVD":                   {"untyped int", constant.MakeInt64(int64(q.PR_WANTRCVD))},
			"PTRACE_CONT":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_CONT))},
			"PTRACE_KILL":                   {"untyped int", constant.MakeInt64(int64(q.PTRACE_KILL))},
			"PTRACE_TRACEME":                {"untyped int", constant.MakeInt64(int64(q.PTRACE_TRACEME))},
			"PT_ATTACH":                     {"untyped int", constant.MakeInt64(int64(q.PT_ATTACH))},
			"PT_CLEAR":                      {"untyped int", constant.MakeInt64(int64(q.PT_CLEAR))},
			"PT_COMMAND_MAX":                {"untyped int", constant.MakeInt64(int64(q.PT_COMMAND_MAX))},
			"PT_CONTINUE":                   {"untyped int", constant.MakeInt64(int64(q.PT_CONTINUE))},
			"PT_DETACH":                     {"untyped int", constant.MakeInt64(int64(q.PT_DETACH))},
			"PT_GET_UKEY":                   {"untyped int", constant.MakeInt64(int64(q.PT_GET_UKEY))},
			"PT_KILL":                       {"untyped int", constant.MakeInt64(int64(q.PT_KILL))},
			"PT_LDINFO":                     {"untyped int", constant.MakeInt64(int64(q.PT_LDINFO))},
			"PT_LDXINFO":                    {"untyped int", constant.MakeInt64(int64(q.PT_LDXINFO))},
			"PT_MULTI":                      {"untyped int", constant.MakeInt64(int64(q.PT_MULTI))},
			"PT_NEXT":                       {"untyped int", constant.MakeInt64(int64(q.PT_NEXT))},
			"PT_QUERY":                      {"untyped int", constant.MakeInt64(int64(q.PT_QUERY))},
			"PT_READ_BLOCK":                 {"untyped int", constant.MakeInt64(int64(q.PT_READ_BLOCK))},
			"PT_READ_D":                     {"untyped int", constant.MakeInt64(int64(q.PT_READ_D))},
			"PT_READ_FPR":                   {"untyped int", constant.MakeInt64(int64(q.PT_READ_FPR))},
			"PT_READ_GPR":                   {"untyped int", constant.MakeInt64(int64(q.PT_READ_GPR))},
			"PT_READ_I":                     {"untyped int", constant.MakeInt64(int64(q.PT_READ_I))},
			"PT_REATT":                      {"untyped int", constant.MakeInt64(int64(q.PT_REATT))},
			"PT_REGSET":                     {"untyped int", constant.MakeInt64(int64(q.PT_REGSET))},
			"PT_SET":                        {"untyped int", constant.MakeInt64(int64(q.PT_SET))},
			"PT_STEP":                       {"untyped int", constant.MakeInt64(int64(q.PT_STEP))},
			"PT_TRACE_ME":                   {"untyped int", constant.MakeInt64(int64(q.PT_TRACE_ME))},
			"PT_WATCH":                      {"untyped int", constant.MakeInt64(int64(q.PT_WATCH))},
			"PT_WRITE_BLOCK":                {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_BLOCK))},
			"PT_WRITE_D":                    {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_D))},
			"PT_WRITE_FPR":                  {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_FPR))},
			"PT_WRITE_GPR":                  {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_GPR))},
			"PT_WRITE_I":                    {"untyped int", constant.MakeInt64(int64(q.PT_WRITE_I))},
			"PathMax":                       {"untyped int", constant.MakeInt64(int64(q.PathMax))},
			"RLIMIT_AS":                     {"untyped int", constant.MakeInt64(int64(q.RLIMIT_AS))},
			"RLIMIT_CORE":                   {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CORE))},
			"RLIMIT_CPU":                    {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CPU))},
			"RLIMIT_DATA":                   {"untyped int", constant.MakeInt64(int64(q.RLIMIT_DATA))},
			"RLIMIT_FSIZE":                  {"untyped int", constant.MakeInt64(int64(q.RLIMIT_FSIZE))},
			"RLIMIT_NOFILE":                 {"untyped int", constant.MakeInt64(int64(q.RLIMIT_NOFILE))},
			"RLIMIT_STACK":                  {"untyped int", constant.MakeInt64(int64(q.RLIMIT_STACK))},
			"RLIM_INFINITY":                 {"untyped int", constant.MakeInt64(int64(q.RLIM_INFINITY))},
			"RTAX_AUTHOR":                   {"untyped int", constant.MakeInt64(int64(q.RTAX_AUTHOR))},
			"RTAX_BRD":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_BRD))},
			"RTAX_DST":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_DST))},
			"RTAX_GATEWAY":                  {"untyped int", constant.MakeInt64(int64(q.RTAX_GATEWAY))},
			"RTAX_GENMASK":                  {"untyped int", constant.MakeInt64(int64(q.RTAX_GENMASK))},
			"RTAX_IFA":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_IFA))},
			"RTAX_IFP":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_IFP))},
			"RTAX_MAX":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_MAX))},
			"RTAX_NETMASK":                  {"untyped int", constant.MakeInt64(int64(q.RTAX_NETMASK))},
			"RTA_AUTHOR":                    {"untyped int", constant.MakeInt64(int64(q.RTA_AUTHOR))},
			"RTA_BRD":                       {"untyped int", constant.MakeInt64(int64(q.RTA_BRD))},
			"RTA_DOWNSTREAM":                {"untyped int", constant.MakeInt64(int64(q.RTA_DOWNSTREAM))},
			"RTA_DST":                       {"untyped int", constant.MakeInt64(int64(q.RTA_DST))},
			"RTA_GATEWAY":                   {"untyped int", constant.MakeInt64(int64(q.RTA_GATEWAY))},
			"RTA_GENMASK":                   {"untyped int", constant.MakeInt64(int64(q.RTA_GENMASK))},
			"RTA_IFA":                       {"untyped int", constant.MakeInt64(int64(q.RTA_IFA))},
			"RTA_IFP":                       {"untyped int", constant.MakeInt64(int64(q.RTA_IFP))},
			"RTA_NETMASK":                   {"untyped int", constant.MakeInt64(int64(q.RTA_NETMASK))},
			"RTF_ACTIVE_DGD":                {"untyped int", constant.MakeInt64(int64(q.RTF_ACTIVE_DGD))},
			"RTF_BCE":                       {"untyped int", constant.MakeInt64(int64(q.RTF_BCE))},
			"RTF_BLACKHOLE":                 {"untyped int", constant.MakeInt64(int64(q.RTF_BLACKHOLE))},
			"RTF_BROADCAST":                 {"untyped int", constant.MakeInt64(int64(q.RTF_BROADCAST))},
			"RTF_BUL":                       {"untyped int", constant.MakeInt64(int64(q.RTF_BUL))},
			"RTF_CLONE":                     {"untyped int", constant.MakeInt64(int64(q.RTF_CLONE))},
			"RTF_CLONED":                    {"untyped int", constant.MakeInt64(int64(q.RTF_CLONED))},
			"RTF_CLONING":                   {"untyped int", constant.MakeInt64(int64(q.RTF_CLONING))},
			"RTF_DONE":                      {"untyped int", constant.MakeInt64(int64(q.RTF_DONE))},
			"RTF_DYNAMIC":                   {"untyped int", constant.MakeInt64(int64(q.RTF_DYNAMIC))},
			"RTF_FREE_IN_PROG":              {"untyped int", constant.MakeInt64(int64(q.RTF_FREE_IN_PROG))},
			"RTF_GATEWAY":                   {"untyped int", constant.MakeInt64(int64(q.RTF_GATEWAY))},
			"RTF_HOST":                      {"untyped int", constant.MakeInt64(int64(q.RTF_HOST))},
			"RTF_LLINFO":                    {"untyped int", constant.MakeInt64(int64(q.RTF_LLINFO))},
			"RTF_LOCAL":                     {"untyped int", constant.MakeInt64(int64(q.RTF_LOCAL))},
			"RTF_MASK":                      {"untyped int", constant.MakeInt64(int64(q.RTF_MASK))},
			"RTF_MODIFIED":                  {"untyped int", constant.MakeInt64(int64(q.RTF_MODIFIED))},
			"RTF_MULTICAST":                 {"untyped int", constant.MakeInt64(int64(q.RTF_MULTICAST))},
			"RTF_PERMANENT6":                {"untyped int", constant.MakeInt64(int64(q.RTF_PERMANENT6))},
			"RTF_PINNED":                    {"untyped int", constant.MakeInt64(int64(q.RTF_PINNED))},
			"RTF_PROTO1":                    {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO1))},
			"RTF_PROTO2":                    {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO2))},
			"RTF_PROTO3":                    {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO3))},
			"RTF_REJECT":                    {"untyped int", constant.MakeInt64(int64(q.RTF_REJECT))},
			"RTF_SMALLMTU":                  {"untyped int", constant.MakeInt64(int64(q.RTF_SMALLMTU))},
			"RTF_STATIC":                    {"untyped int", constant.MakeInt64(int64(q.RTF_STATIC))},
			"RTF_STOPSRCH":                  {"untyped int", constant.MakeInt64(int64(q.RTF_STOPSRCH))},
			"RTF_UNREACHABLE":               {"untyped int", constant.MakeInt64(int64(q.RTF_UNREACHABLE))},
			"RTF_UP":                        {"untyped int", constant.MakeInt64(int64(q.RTF_UP))},
			"RTF_XRESOLVE":                  {"untyped int", constant.MakeInt64(int64(q.RTF_XRESOLVE))},
			"RTM_ADD":                       {"untyped int", constant.MakeInt64(int64(q.RTM_ADD))},
			"RTM_CHANGE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_CHANGE))},
			"RTM_DELADDR":                   {"untyped int", constant.MakeInt64(int64(q.RTM_DELADDR))},
			"RTM_DELETE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_DELETE))},
			"RTM_EXPIRE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_EXPIRE))},
			"RTM_GET":                       {"untyped int", constant.MakeInt64(int64(q.RTM_GET))},
			"RTM_GETNEXT":                   {"untyped int", constant.MakeInt64(int64(q.RTM_GETNEXT))},
			"RTM_IFINFO":                    {"untyped int", constant.MakeInt64(int64(q.RTM_IFINFO))},
			"RTM_LOCK":                      {"untyped int", constant.MakeInt64(int64(q.RTM_LOCK))},
			"RTM_LOSING":                    {"untyped int", constant.MakeInt64(int64(q.RTM_LOSING))},
			"RTM_MISS":                      {"untyped int", constant.MakeInt64(int64(q.RTM_MISS))},
			"RTM_NEWADDR":                   {"untyped int", constant.MakeInt64(int64(q.RTM_NEWADDR))},
			"RTM_OLDADD":                    {"untyped int", constant.MakeInt64(int64(q.RTM_OLDADD))},
			"RTM_OLDDEL":                    {"untyped int", constant.MakeInt64(int64(q.RTM_OLDDEL))},
			"RTM_REDIRECT":                  {"untyped int", constant.MakeInt64(int64(q.RTM_REDIRECT))},
			"RTM_RESOLVE":                   {"untyped int", constant.MakeInt64(int64(q.RTM_RESOLVE))},
			"RTM_RTLOST":                    {"untyped int", constant.MakeInt64(int64(q.RTM_RTLOST))},
			"RTM_RTTUNIT":                   {"untyped int", constant.MakeInt64(int64(q.RTM_RTTUNIT))},
			"RTM_SAMEADDR":                  {"untyped int", constant.MakeInt64(int64(q.RTM_SAMEADDR))},
			"RTM_SET":                       {"untyped int", constant.MakeInt64(int64(q.RTM_SET))},
			"RTM_VERSION":                   {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION))},
			"RTM_VERSION_GR":                {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION_GR))},
			"RTM_VERSION_GR_COMPAT":         {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION_GR_COMPAT))},
			"RTM_VERSION_POLICY":            {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION_POLICY))},
			"RTM_VERSION_POLICY_EXT":        {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION_POLICY_EXT))},
			"RTM_VERSION_POLICY_PRFN":       {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION_POLICY_PRFN))},
			"RTV_EXPIRE":                    {"untyped int", constant.MakeInt64(int64(q.RTV_EXPIRE))},
			"RTV_HOPCOUNT":                  {"untyped int", constant.MakeInt64(int64(q.RTV_HOPCOUNT))},
			"RTV_MTU":                       {"untyped int", constant.MakeInt64(int64(q.RTV_MTU))},
			"RTV_RPIPE":                     {"untyped int", constant.MakeInt64(int64(q.RTV_RPIPE))},
			"RTV_RTT":                       {"untyped int", constant.MakeInt64(int64(q.RTV_RTT))},
			"RTV_RTTVAR":                    {"untyped int", constant.MakeInt64(int64(q.RTV_RTTVAR))},
			"RTV_SPIPE":                     {"untyped int", constant.MakeInt64(int64(q.RTV_SPIPE))},
			"RTV_SSTHRESH":                  {"untyped int", constant.MakeInt64(int64(q.RTV_SSTHRESH))},
			"RUSAGE_CHILDREN":               {"untyped int", constant.MakeInt64(int64(q.RUSAGE_CHILDREN))},
			"RUSAGE_SELF":                   {"untyped int", constant.MakeInt64(int64(q.RUSAGE_SELF))},
			"RUSAGE_THREAD":                 {"untyped int", constant.MakeInt64(int64(q.RUSAGE_THREAD))},
			"SCM_RIGHTS":                    {"untyped int", constant.MakeInt64(int64(q.SCM_RIGHTS))},
			"SHUT_RD":                       {"untyped int", constant.MakeInt64(int64(q.SHUT_RD))},
			"SHUT_RDWR":                     {"untyped int", constant.MakeInt64(int64(q.SHUT_RDWR))},
			"SHUT_WR":                       {"untyped int", constant.MakeInt64(int64(q.SHUT_WR))},
			"SIGQUEUE_MAX":                  {"untyped int", constant.MakeInt64(int64(q.SIGQUEUE_MAX))},
			"SIOCADDIFVIPA":                 {"untyped int", constant.MakeInt64(int64(q.SIOCADDIFVIPA))},
			"SIOCADDMTU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCADDMTU))},
			"SIOCADDMULTI":                  {"untyped int", constant.MakeInt64(int64(q.SIOCADDMULTI))},
			"SIOCADDNETID":                  {"untyped int", constant.MakeInt64(int64(q.SIOCADDNETID))},
			"SIOCADDRT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCADDRT))},
			"SIOCAIFADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCAIFADDR))},
			"SIOCATMARK":                    {"untyped int", constant.MakeInt64(int64(q.SIOCATMARK))},
			"SIOCDARP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDARP))},
			"SIOCDELIFVIPA":                 {"untyped int", constant.MakeInt64(int64(q.SIOCDELIFVIPA))},
			"SIOCDELMTU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCDELMTU))},
			"SIOCDELMULTI":                  {"untyped int", constant.MakeInt64(int64(q.SIOCDELMULTI))},
			"SIOCDELPMTU":                   {"untyped int", constant.MakeInt64(int64(q.SIOCDELPMTU))},
			"SIOCDELRT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCDELRT))},
			"SIOCDIFADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCDIFADDR))},
			"SIOCDNETOPT":                   {"untyped int", constant.MakeInt64(int64(q.SIOCDNETOPT))},
			"SIOCDX25XLATE":                 {"untyped int", constant.MakeInt64(int64(q.SIOCDX25XLATE))},
			"SIOCFIFADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCFIFADDR))},
			"SIOCGARP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGARP))},
			"SIOCGETMTUS":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGETMTUS))},
			"SIOCGETSGCNT":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGETSGCNT))},
			"SIOCGETVIFCNT":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGETVIFCNT))},
			"SIOCGHIWAT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGHIWAT))},
			"SIOCGIFADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFADDR))},
			"SIOCGIFADDRS":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGIFADDRS))},
			"SIOCGIFBAUDRATE":               {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBAUDRATE))},
			"SIOCGIFBRDADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBRDADDR))},
			"SIOCGIFCONF":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCONF))},
			"SIOCGIFCONFGLOB":               {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCONFGLOB))},
			"SIOCGIFDSTADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDSTADDR))},
			"SIOCGIFFLAGS":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGIFFLAGS))},
			"SIOCGIFGIDLIST":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGIDLIST))},
			"SIOCGIFHWADDR":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGIFHWADDR))},
			"SIOCGIFMETRIC":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMETRIC))},
			"SIOCGIFMTU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMTU))},
			"SIOCGIFNETMASK":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNETMASK))},
			"SIOCGIFOPTIONS":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFOPTIONS))},
			"SIOCGISNO":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGISNO))},
			"SIOCGLOADF":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGLOADF))},
			"SIOCGLOWAT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGLOWAT))},
			"SIOCGNETOPT":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGNETOPT))},
			"SIOCGNETOPT1":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGNETOPT1))},
			"SIOCGNMTUS":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGNMTUS))},
			"SIOCGPGRP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGPGRP))},
			"SIOCGSIZIFCONF":                {"untyped int", constant.MakeInt64(int64(q.SIOCGSIZIFCONF))},
			"SIOCGSRCFILTER":                {"untyped int", constant.MakeInt64(int64(q.SIOCGSRCFILTER))},
			"SIOCGTUNEPHASE":                {"untyped int", constant.MakeInt64(int64(q.SIOCGTUNEPHASE))},
			"SIOCGX25XLATE":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGX25XLATE))},
			"SIOCIFATTACH":                  {"untyped int", constant.MakeInt64(int64(q.SIOCIFATTACH))},
			"SIOCIFDETACH":                  {"untyped int", constant.MakeInt64(int64(q.SIOCIFDETACH))},
			"SIOCIFGETPKEY":                 {"untyped int", constant.MakeInt64(int64(q.SIOCIFGETPKEY))},
			"SIOCIF_ATM_DARP":               {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_DARP))},
			"SIOCIF_ATM_DUMPARP":            {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_DUMPARP))},
			"SIOCIF_ATM_GARP":               {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_GARP))},
			"SIOCIF_ATM_IDLE":               {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_IDLE))},
			"SIOCIF_ATM_SARP":               {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_SARP))},
			"SIOCIF_ATM_SNMPARP":            {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_SNMPARP))},
			"SIOCIF_ATM_SVC":                {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_SVC))},
			"SIOCIF_ATM_UBR":                {"untyped int", constant.MakeInt64(int64(q.SIOCIF_ATM_UBR))},
			"SIOCIF_DEVHEALTH":              {"untyped int", constant.MakeInt64(int64(q.SIOCIF_DEVHEALTH))},
			"SIOCIF_IB_ARP_INCOMP":          {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_ARP_INCOMP))},
			"SIOCIF_IB_ARP_TIMER":           {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_ARP_TIMER))},
			"SIOCIF_IB_CLEAR_PINFO":         {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_CLEAR_PINFO))},
			"SIOCIF_IB_DEL_ARP":             {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_DEL_ARP))},
			"SIOCIF_IB_DEL_PINFO":           {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_DEL_PINFO))},
			"SIOCIF_IB_DUMP_ARP":            {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_DUMP_ARP))},
			"SIOCIF_IB_GET_ARP":             {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_GET_ARP))},
			"SIOCIF_IB_GET_INFO":            {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_GET_INFO))},
			"SIOCIF_IB_GET_STATS":           {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_GET_STATS))},
			"SIOCIF_IB_NOTIFY_ADDR_REM":     {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_NOTIFY_ADDR_REM))},
			"SIOCIF_IB_RESET_STATS":         {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_RESET_STATS))},
			"SIOCIF_IB_RESIZE_CQ":           {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_RESIZE_CQ))},
			"SIOCIF_IB_SET_ARP":             {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_SET_ARP))},
			"SIOCIF_IB_SET_PKEY":            {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_SET_PKEY))},
			"SIOCIF_IB_SET_PORT":            {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_SET_PORT))},
			"SIOCIF_IB_SET_QKEY":            {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_SET_QKEY))},
			"SIOCIF_IB_SET_QSIZE":           {"untyped int", constant.MakeInt64(int64(q.SIOCIF_IB_SET_QSIZE))},
			"SIOCLISTIFVIPA":                {"untyped int", constant.MakeInt64(int64(q.SIOCLISTIFVIPA))},
			"SIOCSARP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSARP))},
			"SIOCSHIWAT":                    {"untyped int", constant.MakeUint64(uint64(q.SIOCSHIWAT))},
			"SIOCSIFADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSIFADDR))},
			"SIOCSIFADDRORI":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFADDRORI))},
			"SIOCSIFBRDADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBRDADDR))},
			"SIOCSIFDSTADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFDSTADDR))},
			"SIOCSIFFLAGS":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSIFFLAGS))},
			"SIOCSIFGIDLIST":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFGIDLIST))},
			"SIOCSIFMETRIC":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMETRIC))},
			"SIOCSIFMTU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMTU))},
			"SIOCSIFNETDUMP":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNETDUMP))},
			"SIOCSIFNETMASK":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNETMASK))},
			"SIOCSIFOPTIONS":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFOPTIONS))},
			"SIOCSIFSUBCHAN":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFSUBCHAN))},
			"SIOCSISNO":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSISNO))},
			"SIOCSLOADF":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSLOADF))},
			"SIOCSLOWAT":                    {"untyped int", constant.MakeUint64(uint64(q.SIOCSLOWAT))},
			"SIOCSNETOPT":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSNETOPT))},
			"SIOCSPGRP":                     {"untyped int", constant.MakeUint64(uint64(q.SIOCSPGRP))},
			"SIOCSX25XLATE":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSX25XLATE))},
			"SOCK_CONN_DGRAM":               {"untyped int", constant.MakeInt64(int64(q.SOCK_CONN_DGRAM))},
			"SOCK_DGRAM":                    {"untyped int", constant.MakeInt64(int64(q.SOCK_DGRAM))},
			"SOCK_RAW":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_RAW))},
			"SOCK_RDM":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_RDM))},
			"SOCK_SEQPACKET":                {"untyped int", constant.MakeInt64(int64(q.SOCK_SEQPACKET))},
			"SOCK_STREAM":                   {"untyped int", constant.MakeInt64(int64(q.SOCK_STREAM))},
			"SOL_SOCKET":                    {"untyped int", constant.MakeInt64(int64(q.SOL_SOCKET))},
			"SOMAXCONN":                     {"untyped int", constant.MakeInt64(int64(q.SOMAXCONN))},
			"SO_ACCEPTCONN":                 {"untyped int", constant.MakeInt64(int64(q.SO_ACCEPTCONN))},
			"SO_AUDIT":                      {"untyped int", constant.MakeInt64(int64(q.SO_AUDIT))},
			"SO_BROADCAST":                  {"untyped int", constant.MakeInt64(int64(q.SO_BROADCAST))},
			"SO_CKSUMRECV":                  {"untyped int", constant.MakeInt64(int64(q.SO_CKSUMRECV))},
			"SO_DEBUG":                      {"untyped int", constant.MakeInt64(int64(q.SO_DEBUG))},
			"SO_DONTROUTE":                  {"untyped int", constant.MakeInt64(int64(q.SO_DONTROUTE))},
			"SO_ERROR":                      {"untyped int", constant.MakeInt64(int64(q.SO_ERROR))},
			"SO_KEEPALIVE":                  {"untyped int", constant.MakeInt64(int64(q.SO_KEEPALIVE))},
			"SO_KERNACCEPT":                 {"untyped int", constant.MakeInt64(int64(q.SO_KERNACCEPT))},
			"SO_LINGER":                     {"untyped int", constant.MakeInt64(int64(q.SO_LINGER))},
			"SO_NOMULTIPATH":                {"untyped int", constant.MakeInt64(int64(q.SO_NOMULTIPATH))},
			"SO_NOREUSEADDR":                {"untyped int", constant.MakeInt64(int64(q.SO_NOREUSEADDR))},
			"SO_OOBINLINE":                  {"untyped int", constant.MakeInt64(int64(q.SO_OOBINLINE))},
			"SO_PEERID":                     {"untyped int", constant.MakeInt64(int64(q.SO_PEERID))},
			"SO_RCVBUF":                     {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUF))},
			"SO_RCVLOWAT":                   {"untyped int", constant.MakeInt64(int64(q.SO_RCVLOWAT))},
			"SO_RCVTIMEO":                   {"untyped int", constant.MakeInt64(int64(q.SO_RCVTIMEO))},
			"SO_REUSEADDR":                  {"untyped int", constant.MakeInt64(int64(q.SO_REUSEADDR))},
			"SO_REUSEPORT":                  {"untyped int", constant.MakeInt64(int64(q.SO_REUSEPORT))},
			"SO_SNDBUF":                     {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUF))},
			"SO_SNDLOWAT":                   {"untyped int", constant.MakeInt64(int64(q.SO_SNDLOWAT))},
			"SO_SNDTIMEO":                   {"untyped int", constant.MakeInt64(int64(q.SO_SNDTIMEO))},
			"SO_TIMESTAMPNS":                {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMPNS))},
			"SO_TYPE":                       {"untyped int", constant.MakeInt64(int64(q.SO_TYPE))},
			"SO_USELOOPBACK":                {"untyped int", constant.MakeInt64(int64(q.SO_USELOOPBACK))},
			"SO_USE_IFBUFS":                 {"untyped int", constant.MakeInt64(int64(q.SO_USE_IFBUFS))},
			"SYS_EXECVE":                    {"untyped int", constant.MakeInt64(int64(q.SYS_EXECVE))},
			"SYS_FCNTL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FCNTL))},
			"S_BANDURG":                     {"untyped int", constant.MakeInt64(int64(q.S_BANDURG))},
			"S_EMODFMT":                     {"untyped int", constant.MakeInt64(int64(q.S_EMODFMT))},
			"S_ENFMT":                       {"untyped int", constant.MakeInt64(int64(q.S_ENFMT))},
			"S_ERROR":                       {"untyped int", constant.MakeInt64(int64(q.S_ERROR))},
			"S_HANGUP":                      {"untyped int", constant.MakeInt64(int64(q.S_HANGUP))},
			"S_HIPRI":                       {"untyped int", constant.MakeInt64(int64(q.S_HIPRI))},
			"S_ICRYPTO":                     {"untyped int", constant.MakeInt64(int64(q.S_ICRYPTO))},
			"S_IEXEC":                       {"untyped int", constant.MakeInt64(int64(q.S_IEXEC))},
			"S_IFBLK":                       {"untyped int", constant.MakeInt64(int64(q.S_IFBLK))},
			"S_IFCHR":                       {"untyped int", constant.MakeInt64(int64(q.S_IFCHR))},
			"S_IFDIR":                       {"untyped int", constant.MakeInt64(int64(q.S_IFDIR))},
			"S_IFIFO":                       {"untyped int", constant.MakeInt64(int64(q.S_IFIFO))},
			"S_IFJOURNAL":                   {"untyped int", constant.MakeInt64(int64(q.S_IFJOURNAL))},
			"S_IFLNK":                       {"untyped int", constant.MakeInt64(int64(q.S_IFLNK))},
			"S_IFMPX":                       {"untyped int", constant.MakeInt64(int64(q.S_IFMPX))},
			"S_IFMT":                        {"untyped int", constant.MakeInt64(int64(q.S_IFMT))},
			"S_IFPDIR":                      {"untyped int", constant.MakeInt64(int64(q.S_IFPDIR))},
			"S_IFPSDIR":                     {"untyped int", constant.MakeInt64(int64(q.S_IFPSDIR))},
			"S_IFPSSDIR":                    {"untyped int", constant.MakeInt64(int64(q.S_IFPSSDIR))},
			"S_IFREG":                       {"untyped int", constant.MakeInt64(int64(q.S_IFREG))},
			"S_IFSOCK":                      {"untyped int", constant.MakeInt64(int64(q.S_IFSOCK))},
			"S_IFSYSEA":                     {"untyped int", constant.MakeInt64(int64(q.S_IFSYSEA))},
			"S_INPUT":                       {"untyped int", constant.MakeInt64(int64(q.S_INPUT))},
			"S_IREAD":                       {"untyped int", constant.MakeInt64(int64(q.S_IREAD))},
			"S_IRGRP":                       {"untyped int", constant.MakeInt64(int64(q.S_IRGRP))},
			"S_IROTH":                       {"untyped int", constant.MakeInt64(int64(q.S_IROTH))},
			"S_IRUSR":                       {"untyped int", constant.MakeInt64(int64(q.S_IRUSR))},
			"S_IRWXG":                       {"untyped int", constant.MakeInt64(int64(q.S_IRWXG))},
			"S_IRWXO":                       {"untyped int", constant.MakeInt64(int64(q.S_IRWXO))},
			"S_IRWXU":                       {"untyped int", constant.MakeInt64(int64(q.S_IRWXU))},
			"S_ISGID":                       {"untyped int", constant.MakeInt64(int64(q.S_ISGID))},
			"S_ISUID":                       {"untyped int", constant.MakeInt64(int64(q.S_ISUID))},
			"S_ISVTX":                       {"untyped int", constant.MakeInt64(int64(q.S_ISVTX))},
			"S_ITCB":                        {"untyped int", constant.MakeInt64(int64(q.S_ITCB))},
			"S_ITP":                         {"untyped int", constant.MakeInt64(int64(q.S_ITP))},
			"S_IWGRP":                       {"untyped int", constant.MakeInt64(int64(q.S_IWGRP))},
			"S_IWOTH":                       {"untyped int", constant.MakeInt64(int64(q.S_IWOTH))},
			"S_IWRITE":                      {"untyped int", constant.MakeInt64(int64(q.S_IWRITE))},
			"S_IWUSR":                       {"untyped int", constant.MakeInt64(int64(q.S_IWUSR))},
			"S_IXACL":                       {"untyped int", constant.MakeInt64(int64(q.S_IXACL))},
			"S_IXATTR":                      {"untyped int", constant.MakeInt64(int64(q.S_IXATTR))},
			"S_IXGRP":                       {"untyped int", constant.MakeInt64(int64(q.S_IXGRP))},
			"S_IXINTERFACE":                 {"untyped int", constant.MakeInt64(int64(q.S_IXINTERFACE))},
			"S_IXMOD":                       {"untyped int", constant.MakeInt64(int64(q.S_IXMOD))},
			"S_IXOTH":                       {"untyped int", constant.MakeInt64(int64(q.S_IXOTH))},
			"S_IXUSR":                       {"untyped int", constant.MakeInt64(int64(q.S_IXUSR))},
			"S_MSG":                         {"untyped int", constant.MakeInt64(int64(q.S_MSG))},
			"S_OUTPUT":                      {"untyped int", constant.MakeInt64(int64(q.S_OUTPUT))},
			"S_RDBAND":                      {"untyped int", constant.MakeInt64(int64(q.S_RDBAND))},
			"S_RDNORM":                      {"untyped int", constant.MakeInt64(int64(q.S_RDNORM))},
			"S_RESERVED1":                   {"untyped int", constant.MakeInt64(int64(q.S_RESERVED1))},
			"S_RESERVED2":                   {"untyped int", constant.MakeInt64(int64(q.S_RESERVED2))},
			"S_RESERVED3":                   {"untyped int", constant.MakeInt64(int64(q.S_RESERVED3))},
			"S_RESERVED4":                   {"untyped int", constant.MakeInt64(int64(q.S_RESERVED4))},
			"S_RESFMT1":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT1))},
			"S_RESFMT10":                    {"untyped int", constant.MakeInt64(int64(q.S_RESFMT10))},
			"S_RESFMT11":                    {"untyped int", constant.MakeInt64(int64(q.S_RESFMT11))},
			"S_RESFMT12":                    {"untyped int", constant.MakeInt64(int64(q.S_RESFMT12))},
			"S_RESFMT2":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT2))},
			"S_RESFMT3":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT3))},
			"S_RESFMT4":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT4))},
			"S_RESFMT5":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT5))},
			"S_RESFMT6":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT6))},
			"S_RESFMT7":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT7))},
			"S_RESFMT8":                     {"untyped int", constant.MakeInt64(int64(q.S_RESFMT8))},
			"S_WRBAND":                      {"untyped int", constant.MakeInt64(int64(q.S_WRBAND))},
			"S_WRNORM":                      {"untyped int", constant.MakeInt64(int64(q.S_WRNORM))},
			"SizeofCmsghdr":                 {"untyped int", constant.MakeInt64(int64(q.SizeofCmsghdr))},
			"SizeofICMPv6Filter":            {"untyped int", constant.MakeInt64(int64(q.SizeofICMPv6Filter))},
			"SizeofIPMreq":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIPMreq))},
			"SizeofIPv6Mreq":                {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6Mreq))},
			"SizeofIfMsghdr":                {"untyped int", constant.MakeInt64(int64(q.SizeofIfMsghdr))},
			"SizeofLinger":                  {"untyped int", constant.MakeInt64(int64(q.SizeofLinger))},
			"SizeofMsghdr":                  {"untyped int", constant.MakeInt64(int64(q.SizeofMsghdr))},
			"SizeofSockaddrAny":             {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrAny))},
			"SizeofSockaddrDatalink":        {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrDatalink))},
			"SizeofSockaddrInet4":           {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet4))},
			"SizeofSockaddrInet6":           {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet6))},
			"SizeofSockaddrUnix":            {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrUnix))},
			"TCIFLUSH":                      {"untyped int", constant.MakeInt64(int64(q.TCIFLUSH))},
			"TCIOFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.TCIOFLUSH))},
			"TCOFLUSH":                      {"untyped int", constant.MakeInt64(int64(q.TCOFLUSH))},
			"TCP_24DAYS_WORTH_OF_SLOWTICKS": {"untyped int", constant.MakeInt64(int64(q.TCP_24DAYS_WORTH_OF_SLOWTICKS))},
			"TCP_ACLADD":                    {"untyped int", constant.MakeInt64(int64(q.TCP_ACLADD))},
			"TCP_ACLBIND":                   {"untyped int", constant.MakeInt64(int64(q.TCP_ACLBIND))},
			"TCP_ACLCLEAR":                  {"untyped int", constant.MakeInt64(int64(q.TCP_ACLCLEAR))},
			"TCP_ACLDEL":                    {"untyped int", constant.MakeInt64(int64(q.TCP_ACLDEL))},
			"TCP_ACLDENY":                   {"untyped int", constant.MakeInt64(int64(q.TCP_ACLDENY))},
			"TCP_ACLFLUSH":                  {"untyped int", constant.MakeInt64(int64(q.TCP_ACLFLUSH))},
			"TCP_ACLGID":                    {"untyped int", constant.MakeInt64(int64(q.TCP_ACLGID))},
			"TCP_ACLLS":                     {"untyped int", constant.MakeInt64(int64(q.TCP_ACLLS))},
			"TCP_ACLSUBNET":                 {"untyped int", constant.MakeInt64(int64(q.TCP_ACLSUBNET))},
			"TCP_ACLUID":                    {"untyped int", constant.MakeInt64(int64(q.TCP_ACLUID))},
			"TCP_CWND_DF":                   {"untyped int", constant.MakeInt64(int64(q.TCP_CWND_DF))},
			"TCP_CWND_IF":                   {"untyped int", constant.MakeInt64(int64(q.TCP_CWND_IF))},
			"TCP_DELAY_ACK_FIN":             {"untyped int", constant.MakeInt64(int64(q.TCP_DELAY_ACK_FIN))},
			"TCP_DELAY_ACK_SYN":             {"untyped int", constant.MakeInt64(int64(q.TCP_DELAY_ACK_SYN))},
			"TCP_FASTNAME":                  {"untyped int", constant.MakeInt64(int64(q.TCP_FASTNAME))},
			"TCP_KEEPCNT":                   {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPCNT))},
			"TCP_KEEPIDLE":                  {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPIDLE))},
			"TCP_KEEPINTVL":                 {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPINTVL))},
			"TCP_LSPRIV":                    {"untyped int", constant.MakeInt64(int64(q.TCP_LSPRIV))},
			"TCP_LUID":                      {"untyped int", constant.MakeInt64(int64(q.TCP_LUID))},
			"TCP_MAXBURST":                  {"untyped int", constant.MakeInt64(int64(q.TCP_MAXBURST))},
			"TCP_MAXDF":                     {"untyped int", constant.MakeInt64(int64(q.TCP_MAXDF))},
			"TCP_MAXIF":                     {"untyped int", constant.MakeInt64(int64(q.TCP_MAXIF))},
			"TCP_MAXSEG":                    {"untyped int", constant.MakeInt64(int64(q.TCP_MAXSEG))},
			"TCP_MAXWIN":                    {"untyped int", constant.MakeInt64(int64(q.TCP_MAXWIN))},
			"TCP_MAXWINDOWSCALE":            {"untyped int", constant.MakeInt64(int64(q.TCP_MAXWINDOWSCALE))},
			"TCP_MAX_SACK":                  {"untyped int", constant.MakeInt64(int64(q.TCP_MAX_SACK))},
			"TCP_MSS":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MSS))},
			"TCP_NODELAY":                   {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAY))},
			"TCP_NODELAYACK":                {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAYACK))},
			"TCP_NOREDUCE_CWND_EXIT_FRXMT":  {"untyped int", constant.MakeInt64(int64(q.TCP_NOREDUCE_CWND_EXIT_FRXMT))},
			"TCP_NOREDUCE_CWND_IN_FRXMT":    {"untyped int", constant.MakeInt64(int64(q.TCP_NOREDUCE_CWND_IN_FRXMT))},
			"TCP_NOTENTER_SSTART":           {"untyped int", constant.MakeInt64(int64(q.TCP_NOTENTER_SSTART))},
			"TCP_OPT":                       {"untyped int", constant.MakeInt64(int64(q.TCP_OPT))},
			"TCP_RFC1323":                   {"untyped int", constant.MakeInt64(int64(q.TCP_RFC1323))},
			"TCP_SETPRIV":                   {"untyped int", constant.MakeInt64(int64(q.TCP_SETPRIV))},
			"TCP_STDURG":                    {"untyped int", constant.MakeInt64(int64(q.TCP_STDURG))},
			"TCP_TIMESTAMP_OPTLEN":          {"untyped int", constant.MakeInt64(int64(q.TCP_TIMESTAMP_OPTLEN))},
			"TCP_UNSETPRIV":                 {"untyped int", constant.MakeInt64(int64(q.TCP_UNSETPRIV))},
			"TCSAFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.TCSAFLUSH))},
			"TIOCCBRK":                      {"untyped int", constant.MakeInt64(int64(q.TIOCCBRK))},
			"TIOCCDTR":                      {"untyped int", constant.MakeInt64(int64(q.TIOCCDTR))},
			"TIOCCONS":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCCONS))},
			"TIOCEXCL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCEXCL))},
			"TIOCFLUSH":                     {"untyped int", constant.MakeUint64(uint64(q.TIOCFLUSH))},
			"TIOCGETC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGETC))},
			"TIOCGETD":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGETD))},
			"TIOCGETP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGETP))},
			"TIOCGLTC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGLTC))},
			"TIOCGPGRP":                     {"untyped int", constant.MakeInt64(int64(q.TIOCGPGRP))},
			"TIOCGSID":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGSID))},
			"TIOCGSIZE":                     {"untyped int", constant.MakeInt64(int64(q.TIOCGSIZE))},
			"TIOCGWINSZ":                    {"untyped int", constant.MakeInt64(int64(q.TIOCGWINSZ))},
			"TIOCHPCL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCHPCL))},
			"TIOCLBIC":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCLBIC))},
			"TIOCLBIS":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCLBIS))},
			"TIOCLGET":                      {"untyped int", constant.MakeInt64(int64(q.TIOCLGET))},
			"TIOCLSET":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCLSET))},
			"TIOCMBIC":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCMBIC))},
			"TIOCMBIS":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCMBIS))},
			"TIOCMGET":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMGET))},
			"TIOCMIWAIT":                    {"untyped int", constant.MakeUint64(uint64(q.TIOCMIWAIT))},
			"TIOCMODG":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMODG))},
			"TIOCMODS":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCMODS))},
			"TIOCMSET":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCMSET))},
			"TIOCM_CAR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_CAR))},
			"TIOCM_CD":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_CD))},
			"TIOCM_CTS":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_CTS))},
			"TIOCM_DSR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_DSR))},
			"TIOCM_DTR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_DTR))},
			"TIOCM_LE":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_LE))},
			"TIOCM_RI":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_RI))},
			"TIOCM_RNG":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_RNG))},
			"TIOCM_RTS":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_RTS))},
			"TIOCM_SR":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_SR))},
			"TIOCM_ST":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_ST))},
			"TIOCNOTTY":                     {"untyped int", constant.MakeInt64(int64(q.TIOCNOTTY))},
			"TIOCNXCL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCNXCL))},
			"TIOCOUTQ":                      {"untyped int", constant.MakeInt64(int64(q.TIOCOUTQ))},
			"TIOCPKT":                       {"untyped int", constant.MakeUint64(uint64(q.TIOCPKT))},
			"TIOCPKT_DATA":                  {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DATA))},
			"TIOCPKT_DOSTOP":                {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DOSTOP))},
			"TIOCPKT_FLUSHREAD":             {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHREAD))},
			"TIOCPKT_FLUSHWRITE":            {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHWRITE))},
			"TIOCPKT_NOSTOP":                {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_NOSTOP))},
			"TIOCPKT_START":                 {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_START))},
			"TIOCPKT_STOP":                  {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_STOP))},
			"TIOCREMOTE":                    {"untyped int", constant.MakeUint64(uint64(q.TIOCREMOTE))},
			"TIOCSBRK":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSBRK))},
			"TIOCSCTTY":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSCTTY))},
			"TIOCSDTR":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSDTR))},
			"TIOCSETC":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCSETC))},
			"TIOCSETD":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCSETD))},
			"TIOCSETN":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCSETN))},
			"TIOCSETP":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCSETP))},
			"TIOCSLTC":                      {"untyped int", constant.MakeUint64(uint64(q.TIOCSLTC))},
			"TIOCSPGRP":                     {"untyped int", constant.MakeUint64(uint64(q.TIOCSPGRP))},
			"TIOCSSIZE":                     {"untyped int", constant.MakeUint64(uint64(q.TIOCSSIZE))},
			"TIOCSTART":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSTART))},
			"TIOCSTI":                       {"untyped int", constant.MakeUint64(uint64(q.TIOCSTI))},
			"TIOCSTOP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSTOP))},
			"TIOCSWINSZ":                    {"untyped int", constant.MakeUint64(uint64(q.TIOCSWINSZ))},
			"TIOCUCNTL":                     {"untyped int", constant.MakeUint64(uint64(q.TIOCUCNTL))},
			"TOSTOP":                        {"untyped int", constant.MakeInt64(int64(q.TOSTOP))},
			"VDISCRD":                       {"untyped int", constant.MakeInt64(int64(q.VDISCRD))},
			"VDSUSP":                        {"untyped int", constant.MakeInt64(int64(q.VDSUSP))},
			"VEOF":                          {"untyped int", constant.MakeInt64(int64(q.VEOF))},
			"VEOL":                          {"untyped int", constant.MakeInt64(int64(q.VEOL))},
			"VEOL2":                         {"untyped int", constant.MakeInt64(int64(q.VEOL2))},
			"VERASE":                        {"untyped int", constant.MakeInt64(int64(q.VERASE))},
			"VINTR":                         {"untyped int", constant.MakeInt64(int64(q.VINTR))},
			"VKILL":                         {"untyped int", constant.MakeInt64(int64(q.VKILL))},
			"VLNEXT":                        {"untyped int", constant.MakeInt64(int64(q.VLNEXT))},
			"VMIN":                          {"untyped int", constant.MakeInt64(int64(q.VMIN))},
			"VQUIT":                         {"untyped int", constant.MakeInt64(int64(q.VQUIT))},
			"VREPRINT":                      {"untyped int", constant.MakeInt64(int64(q.VREPRINT))},
			"VSTART":                        {"untyped int", constant.MakeInt64(int64(q.VSTART))},
			"VSTOP":                         {"untyped int", constant.MakeInt64(int64(q.VSTOP))},
			"VSTRT":                         {"untyped int", constant.MakeInt64(int64(q.VSTRT))},
			"VSUSP":                         {"untyped int", constant.MakeInt64(int64(q.VSUSP))},
			"VT0":                           {"untyped int", constant.MakeInt64(int64(q.VT0))},
			"VT1":                           {"untyped int", constant.MakeInt64(int64(q.VT1))},
			"VTDELAY":                       {"untyped int", constant.MakeInt64(int64(q.VTDELAY))},
			"VTDLY":                         {"untyped int", constant.MakeInt64(int64(q.VTDLY))},
			"VTIME":                         {"untyped int", constant.MakeInt64(int64(q.VTIME))},
			"VWERSE":                        {"untyped int", constant.MakeInt64(int64(q.VWERSE))},
			"WPARSTART":                     {"untyped int", constant.MakeInt64(int64(q.WPARSTART))},
			"WPARSTOP":                      {"untyped int", constant.MakeInt64(int64(q.WPARSTOP))},
			"WPARTTYNAME":                   {"untyped string", constant.MakeString(string(q.WPARTTYNAME))},
		},
	})
}
