// export by github.com/goplus/igop/cmd/qexp

//go:build go1.18 && !go1.19
// +build go1.18,!go1.19

package syscall

import (
	q "syscall"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "syscall",
		Path: "syscall",
		Deps: map[string]string{
			"errors":                "errors",
			"internal/bytealg":      "bytealg",
			"internal/itoa":         "itoa",
			"internal/oserror":      "oserror",
			"internal/race":         "race",
			"internal/unsafeheader": "unsafeheader",
			"runtime":               "runtime",
			"sync":                  "sync",
			"unsafe":                "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Conn":     reflect.TypeOf((*q.Conn)(nil)).Elem(),
			"RawConn":  reflect.TypeOf((*q.RawConn)(nil)).Elem(),
			"Sockaddr": reflect.TypeOf((*q.Sockaddr)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"BpfHdr":               reflect.TypeOf((*q.BpfHdr)(nil)).Elem(),
			"BpfInsn":              reflect.TypeOf((*q.BpfInsn)(nil)).Elem(),
			"BpfProgram":           reflect.TypeOf((*q.BpfProgram)(nil)).Elem(),
			"BpfStat":              reflect.TypeOf((*q.BpfStat)(nil)).Elem(),
			"BpfTimeval":           reflect.TypeOf((*q.BpfTimeval)(nil)).Elem(),
			"BpfVersion":           reflect.TypeOf((*q.BpfVersion)(nil)).Elem(),
			"Cmsghdr":              reflect.TypeOf((*q.Cmsghdr)(nil)).Elem(),
			"Credential":           reflect.TypeOf((*q.Credential)(nil)).Elem(),
			"Dirent":               reflect.TypeOf((*q.Dirent)(nil)).Elem(),
			"Errno":                reflect.TypeOf((*q.Errno)(nil)).Elem(),
			"FdSet":                reflect.TypeOf((*q.FdSet)(nil)).Elem(),
			"Flock_t":              reflect.TypeOf((*q.Flock_t)(nil)).Elem(),
			"ICMPv6Filter":         reflect.TypeOf((*q.ICMPv6Filter)(nil)).Elem(),
			"IPMreq":               reflect.TypeOf((*q.IPMreq)(nil)).Elem(),
			"IPv6MTUInfo":          reflect.TypeOf((*q.IPv6MTUInfo)(nil)).Elem(),
			"IPv6Mreq":             reflect.TypeOf((*q.IPv6Mreq)(nil)).Elem(),
			"IfData":               reflect.TypeOf((*q.IfData)(nil)).Elem(),
			"IfMsghdr":             reflect.TypeOf((*q.IfMsghdr)(nil)).Elem(),
			"IfaMsghdr":            reflect.TypeOf((*q.IfaMsghdr)(nil)).Elem(),
			"Inet6Pktinfo":         reflect.TypeOf((*q.Inet6Pktinfo)(nil)).Elem(),
			"Iovec":                reflect.TypeOf((*q.Iovec)(nil)).Elem(),
			"Linger":               reflect.TypeOf((*q.Linger)(nil)).Elem(),
			"Msghdr":               reflect.TypeOf((*q.Msghdr)(nil)).Elem(),
			"ProcAttr":             reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"RawSockaddr":          reflect.TypeOf((*q.RawSockaddr)(nil)).Elem(),
			"RawSockaddrAny":       reflect.TypeOf((*q.RawSockaddrAny)(nil)).Elem(),
			"RawSockaddrDatalink":  reflect.TypeOf((*q.RawSockaddrDatalink)(nil)).Elem(),
			"RawSockaddrInet4":     reflect.TypeOf((*q.RawSockaddrInet4)(nil)).Elem(),
			"RawSockaddrInet6":     reflect.TypeOf((*q.RawSockaddrInet6)(nil)).Elem(),
			"RawSockaddrUnix":      reflect.TypeOf((*q.RawSockaddrUnix)(nil)).Elem(),
			"Rlimit":               reflect.TypeOf((*q.Rlimit)(nil)).Elem(),
			"RtMetrics":            reflect.TypeOf((*q.RtMetrics)(nil)).Elem(),
			"RtMsghdr":             reflect.TypeOf((*q.RtMsghdr)(nil)).Elem(),
			"Rusage":               reflect.TypeOf((*q.Rusage)(nil)).Elem(),
			"Signal":               reflect.TypeOf((*q.Signal)(nil)).Elem(),
			"SockaddrDatalink":     reflect.TypeOf((*q.SockaddrDatalink)(nil)).Elem(),
			"SockaddrInet4":        reflect.TypeOf((*q.SockaddrInet4)(nil)).Elem(),
			"SockaddrInet6":        reflect.TypeOf((*q.SockaddrInet6)(nil)).Elem(),
			"SockaddrUnix":         reflect.TypeOf((*q.SockaddrUnix)(nil)).Elem(),
			"SocketControlMessage": reflect.TypeOf((*q.SocketControlMessage)(nil)).Elem(),
			"Stat_t":               reflect.TypeOf((*q.Stat_t)(nil)).Elem(),
			"SysProcAttr":          reflect.TypeOf((*q.SysProcAttr)(nil)).Elem(),
			"Termios":              reflect.TypeOf((*q.Termios)(nil)).Elem(),
			"Timespec":             reflect.TypeOf((*q.Timespec)(nil)).Elem(),
			"Timeval":              reflect.TypeOf((*q.Timeval)(nil)).Elem(),
			"Timeval32":            reflect.TypeOf((*q.Timeval32)(nil)).Elem(),
			"WaitStatus":           reflect.TypeOf((*q.WaitStatus)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ForkLock":          reflect.ValueOf(&q.ForkLock),
			"SocketDisableIPv6": reflect.ValueOf(&q.SocketDisableIPv6),
			"Stderr":            reflect.ValueOf(&q.Stderr),
			"Stdin":             reflect.ValueOf(&q.Stdin),
			"Stdout":            reflect.ValueOf(&q.Stdout),
		},
		Funcs: map[string]reflect.Value{
			"Accept":                    reflect.ValueOf(q.Accept),
			"Accept4":                   reflect.ValueOf(q.Accept4),
			"Access":                    reflect.ValueOf(q.Access),
			"Adjtime":                   reflect.ValueOf(q.Adjtime),
			"Bind":                      reflect.ValueOf(q.Bind),
			"BytePtrFromString":         reflect.ValueOf(q.BytePtrFromString),
			"ByteSliceFromString":       reflect.ValueOf(q.ByteSliceFromString),
			"Chdir":                     reflect.ValueOf(q.Chdir),
			"Chmod":                     reflect.ValueOf(q.Chmod),
			"Chown":                     reflect.ValueOf(q.Chown),
			"Chroot":                    reflect.ValueOf(q.Chroot),
			"Clearenv":                  reflect.ValueOf(q.Clearenv),
			"Close":                     reflect.ValueOf(q.Close),
			"CloseOnExec":               reflect.ValueOf(q.CloseOnExec),
			"CmsgLen":                   reflect.ValueOf(q.CmsgLen),
			"CmsgSpace":                 reflect.ValueOf(q.CmsgSpace),
			"Connect":                   reflect.ValueOf(q.Connect),
			"Dup":                       reflect.ValueOf(q.Dup),
			"Environ":                   reflect.ValueOf(q.Environ),
			"Exec":                      reflect.ValueOf(q.Exec),
			"Exit":                      reflect.ValueOf(q.Exit),
			"Fchdir":                    reflect.ValueOf(q.Fchdir),
			"Fchmod":                    reflect.ValueOf(q.Fchmod),
			"Fchown":                    reflect.ValueOf(q.Fchown),
			"FcntlFlock":                reflect.ValueOf(q.FcntlFlock),
			"Flock":                     reflect.ValueOf(q.Flock),
			"ForkExec":                  reflect.ValueOf(q.ForkExec),
			"Fpathconf":                 reflect.ValueOf(q.Fpathconf),
			"Fstat":                     reflect.ValueOf(q.Fstat),
			"Fsync":                     reflect.ValueOf(q.Fsync),
			"Ftruncate":                 reflect.ValueOf(q.Ftruncate),
			"Getcwd":                    reflect.ValueOf(q.Getcwd),
			"Getdents":                  reflect.ValueOf(q.Getdents),
			"Getegid":                   reflect.ValueOf(q.Getegid),
			"Getenv":                    reflect.ValueOf(q.Getenv),
			"Geteuid":                   reflect.ValueOf(q.Geteuid),
			"Getexecname":               reflect.ValueOf(q.Getexecname),
			"Getgid":                    reflect.ValueOf(q.Getgid),
			"Getgroups":                 reflect.ValueOf(q.Getgroups),
			"Gethostname":               reflect.ValueOf(q.Gethostname),
			"Getpagesize":               reflect.ValueOf(q.Getpagesize),
			"Getpeername":               reflect.ValueOf(q.Getpeername),
			"Getpid":                    reflect.ValueOf(q.Getpid),
			"Getppid":                   reflect.ValueOf(q.Getppid),
			"Getpriority":               reflect.ValueOf(q.Getpriority),
			"Getrlimit":                 reflect.ValueOf(q.Getrlimit),
			"Getsockname":               reflect.ValueOf(q.Getsockname),
			"GetsockoptInt":             reflect.ValueOf(q.GetsockoptInt),
			"Gettimeofday":              reflect.ValueOf(q.Gettimeofday),
			"Getuid":                    reflect.ValueOf(q.Getuid),
			"Getwd":                     reflect.ValueOf(q.Getwd),
			"Kill":                      reflect.ValueOf(q.Kill),
			"Lchown":                    reflect.ValueOf(q.Lchown),
			"Link":                      reflect.ValueOf(q.Link),
			"Listen":                    reflect.ValueOf(q.Listen),
			"Lstat":                     reflect.ValueOf(q.Lstat),
			"Mkdir":                     reflect.ValueOf(q.Mkdir),
			"Mknod":                     reflect.ValueOf(q.Mknod),
			"Nanosleep":                 reflect.ValueOf(q.Nanosleep),
			"NsecToTimespec":            reflect.ValueOf(q.NsecToTimespec),
			"NsecToTimeval":             reflect.ValueOf(q.NsecToTimeval),
			"Open":                      reflect.ValueOf(q.Open),
			"ParseDirent":               reflect.ValueOf(q.ParseDirent),
			"ParseSocketControlMessage": reflect.ValueOf(q.ParseSocketControlMessage),
			"ParseUnixRights":           reflect.ValueOf(q.ParseUnixRights),
			"Pathconf":                  reflect.ValueOf(q.Pathconf),
			"Pipe":                      reflect.ValueOf(q.Pipe),
			"Pread":                     reflect.ValueOf(q.Pread),
			"Pwrite":                    reflect.ValueOf(q.Pwrite),
			"RawSyscall":                reflect.ValueOf(q.RawSyscall),
			"RawSyscall6":               reflect.ValueOf(q.RawSyscall6),
			"Read":                      reflect.ValueOf(q.Read),
			"ReadDirent":                reflect.ValueOf(q.ReadDirent),
			"Readlink":                  reflect.ValueOf(q.Readlink),
			"Recvfrom":                  reflect.ValueOf(q.Recvfrom),
			"Recvmsg":                   reflect.ValueOf(q.Recvmsg),
			"Rename":                    reflect.ValueOf(q.Rename),
			"Rmdir":                     reflect.ValueOf(q.Rmdir),
			"Seek":                      reflect.ValueOf(q.Seek),
			"Sendfile":                  reflect.ValueOf(q.Sendfile),
			"Sendmsg":                   reflect.ValueOf(q.Sendmsg),
			"SendmsgN":                  reflect.ValueOf(q.SendmsgN),
			"Sendto":                    reflect.ValueOf(q.Sendto),
			"SetNonblock":               reflect.ValueOf(q.SetNonblock),
			"Setegid":                   reflect.ValueOf(q.Setegid),
			"Setenv":                    reflect.ValueOf(q.Setenv),
			"Seteuid":                   reflect.ValueOf(q.Seteuid),
			"Setgid":                    reflect.ValueOf(q.Setgid),
			"Setgroups":                 reflect.ValueOf(q.Setgroups),
			"Setpgid":                   reflect.ValueOf(q.Setpgid),
			"Setpriority":               reflect.ValueOf(q.Setpriority),
			"Setregid":                  reflect.ValueOf(q.Setregid),
			"Setreuid":                  reflect.ValueOf(q.Setreuid),
			"Setrlimit":                 reflect.ValueOf(q.Setrlimit),
			"Setsid":                    reflect.ValueOf(q.Setsid),
			"SetsockoptByte":            reflect.ValueOf(q.SetsockoptByte),
			"SetsockoptICMPv6Filter":    reflect.ValueOf(q.SetsockoptICMPv6Filter),
			"SetsockoptIPMreq":          reflect.ValueOf(q.SetsockoptIPMreq),
			"SetsockoptIPv6Mreq":        reflect.ValueOf(q.SetsockoptIPv6Mreq),
			"SetsockoptInet4Addr":       reflect.ValueOf(q.SetsockoptInet4Addr),
			"SetsockoptInt":             reflect.ValueOf(q.SetsockoptInt),
			"SetsockoptLinger":          reflect.ValueOf(q.SetsockoptLinger),
			"SetsockoptString":          reflect.ValueOf(q.SetsockoptString),
			"SetsockoptTimeval":         reflect.ValueOf(q.SetsockoptTimeval),
			"Setuid":                    reflect.ValueOf(q.Setuid),
			"Shutdown":                  reflect.ValueOf(q.Shutdown),
			"SlicePtrFromStrings":       reflect.ValueOf(q.SlicePtrFromStrings),
			"Socket":                    reflect.ValueOf(q.Socket),
			"Socketpair":                reflect.ValueOf(q.Socketpair),
			"StartProcess":              reflect.ValueOf(q.StartProcess),
			"Stat":                      reflect.ValueOf(q.Stat),
			"StringBytePtr":             reflect.ValueOf(q.StringBytePtr),
			"StringByteSlice":           reflect.ValueOf(q.StringByteSlice),
			"StringSlicePtr":            reflect.ValueOf(q.StringSlicePtr),
			"Symlink":                   reflect.ValueOf(q.Symlink),
			"Sync":                      reflect.ValueOf(q.Sync),
			"Syscall":                   reflect.ValueOf(q.Syscall),
			"Syscall6":                  reflect.ValueOf(q.Syscall6),
			"TimespecToNsec":            reflect.ValueOf(q.TimespecToNsec),
			"TimevalToNsec":             reflect.ValueOf(q.TimevalToNsec),
			"Truncate":                  reflect.ValueOf(q.Truncate),
			"Umask":                     reflect.ValueOf(q.Umask),
			"UnixRights":                reflect.ValueOf(q.UnixRights),
			"Unlink":                    reflect.ValueOf(q.Unlink),
			"Unsetenv":                  reflect.ValueOf(q.Unsetenv),
			"Utimes":                    reflect.ValueOf(q.Utimes),
			"UtimesNano":                reflect.ValueOf(q.UtimesNano),
			"Wait4":                     reflect.ValueOf(q.Wait4),
			"Write":                     reflect.ValueOf(q.Write),
		},
		TypedConsts: map[string]igop.TypedConst{
			"E2BIG":           {reflect.TypeOf(q.E2BIG), constant.MakeInt64(int64(q.E2BIG))},
			"EACCES":          {reflect.TypeOf(q.EACCES), constant.MakeInt64(int64(q.EACCES))},
			"EADDRINUSE":      {reflect.TypeOf(q.EADDRINUSE), constant.MakeInt64(int64(q.EADDRINUSE))},
			"EADDRNOTAVAIL":   {reflect.TypeOf(q.EADDRNOTAVAIL), constant.MakeInt64(int64(q.EADDRNOTAVAIL))},
			"EADV":            {reflect.TypeOf(q.EADV), constant.MakeInt64(int64(q.EADV))},
			"EAFNOSUPPORT":    {reflect.TypeOf(q.EAFNOSUPPORT), constant.MakeInt64(int64(q.EAFNOSUPPORT))},
			"EAGAIN":          {reflect.TypeOf(q.EAGAIN), constant.MakeInt64(int64(q.EAGAIN))},
			"EALREADY":        {reflect.TypeOf(q.EALREADY), constant.MakeInt64(int64(q.EALREADY))},
			"EBADE":           {reflect.TypeOf(q.EBADE), constant.MakeInt64(int64(q.EBADE))},
			"EBADF":           {reflect.TypeOf(q.EBADF), constant.MakeInt64(int64(q.EBADF))},
			"EBADFD":          {reflect.TypeOf(q.EBADFD), constant.MakeInt64(int64(q.EBADFD))},
			"EBADMSG":         {reflect.TypeOf(q.EBADMSG), constant.MakeInt64(int64(q.EBADMSG))},
			"EBADR":           {reflect.TypeOf(q.EBADR), constant.MakeInt64(int64(q.EBADR))},
			"EBADRQC":         {reflect.TypeOf(q.EBADRQC), constant.MakeInt64(int64(q.EBADRQC))},
			"EBADSLT":         {reflect.TypeOf(q.EBADSLT), constant.MakeInt64(int64(q.EBADSLT))},
			"EBFONT":          {reflect.TypeOf(q.EBFONT), constant.MakeInt64(int64(q.EBFONT))},
			"EBUSY":           {reflect.TypeOf(q.EBUSY), constant.MakeInt64(int64(q.EBUSY))},
			"ECANCELED":       {reflect.TypeOf(q.ECANCELED), constant.MakeInt64(int64(q.ECANCELED))},
			"ECHILD":          {reflect.TypeOf(q.ECHILD), constant.MakeInt64(int64(q.ECHILD))},
			"ECHRNG":          {reflect.TypeOf(q.ECHRNG), constant.MakeInt64(int64(q.ECHRNG))},
			"ECOMM":           {reflect.TypeOf(q.ECOMM), constant.MakeInt64(int64(q.ECOMM))},
			"ECONNABORTED":    {reflect.TypeOf(q.ECONNABORTED), constant.MakeInt64(int64(q.ECONNABORTED))},
			"ECONNREFUSED":    {reflect.TypeOf(q.ECONNREFUSED), constant.MakeInt64(int64(q.ECONNREFUSED))},
			"ECONNRESET":      {reflect.TypeOf(q.ECONNRESET), constant.MakeInt64(int64(q.ECONNRESET))},
			"EDEADLK":         {reflect.TypeOf(q.EDEADLK), constant.MakeInt64(int64(q.EDEADLK))},
			"EDEADLOCK":       {reflect.TypeOf(q.EDEADLOCK), constant.MakeInt64(int64(q.EDEADLOCK))},
			"EDESTADDRREQ":    {reflect.TypeOf(q.EDESTADDRREQ), constant.MakeInt64(int64(q.EDESTADDRREQ))},
			"EDOM":            {reflect.TypeOf(q.EDOM), constant.MakeInt64(int64(q.EDOM))},
			"EDQUOT":          {reflect.TypeOf(q.EDQUOT), constant.MakeInt64(int64(q.EDQUOT))},
			"EEXIST":          {reflect.TypeOf(q.EEXIST), constant.MakeInt64(int64(q.EEXIST))},
			"EFAULT":          {reflect.TypeOf(q.EFAULT), constant.MakeInt64(int64(q.EFAULT))},
			"EFBIG":           {reflect.TypeOf(q.EFBIG), constant.MakeInt64(int64(q.EFBIG))},
			"EHOSTDOWN":       {reflect.TypeOf(q.EHOSTDOWN), constant.MakeInt64(int64(q.EHOSTDOWN))},
			"EHOSTUNREACH":    {reflect.TypeOf(q.EHOSTUNREACH), constant.MakeInt64(int64(q.EHOSTUNREACH))},
			"EIDRM":           {reflect.TypeOf(q.EIDRM), constant.MakeInt64(int64(q.EIDRM))},
			"EILSEQ":          {reflect.TypeOf(q.EILSEQ), constant.MakeInt64(int64(q.EILSEQ))},
			"EINPROGRESS":     {reflect.TypeOf(q.EINPROGRESS), constant.MakeInt64(int64(q.EINPROGRESS))},
			"EINTR":           {reflect.TypeOf(q.EINTR), constant.MakeInt64(int64(q.EINTR))},
			"EINVAL":          {reflect.TypeOf(q.EINVAL), constant.MakeInt64(int64(q.EINVAL))},
			"EIO":             {reflect.TypeOf(q.EIO), constant.MakeInt64(int64(q.EIO))},
			"EISCONN":         {reflect.TypeOf(q.EISCONN), constant.MakeInt64(int64(q.EISCONN))},
			"EISDIR":          {reflect.TypeOf(q.EISDIR), constant.MakeInt64(int64(q.EISDIR))},
			"EL2HLT":          {reflect.TypeOf(q.EL2HLT), constant.MakeInt64(int64(q.EL2HLT))},
			"EL2NSYNC":        {reflect.TypeOf(q.EL2NSYNC), constant.MakeInt64(int64(q.EL2NSYNC))},
			"EL3HLT":          {reflect.TypeOf(q.EL3HLT), constant.MakeInt64(int64(q.EL3HLT))},
			"EL3RST":          {reflect.TypeOf(q.EL3RST), constant.MakeInt64(int64(q.EL3RST))},
			"ELIBACC":         {reflect.TypeOf(q.ELIBACC), constant.MakeInt64(int64(q.ELIBACC))},
			"ELIBBAD":         {reflect.TypeOf(q.ELIBBAD), constant.MakeInt64(int64(q.ELIBBAD))},
			"ELIBEXEC":        {reflect.TypeOf(q.ELIBEXEC), constant.MakeInt64(int64(q.ELIBEXEC))},
			"ELIBMAX":         {reflect.TypeOf(q.ELIBMAX), constant.MakeInt64(int64(q.ELIBMAX))},
			"ELIBSCN":         {reflect.TypeOf(q.ELIBSCN), constant.MakeInt64(int64(q.ELIBSCN))},
			"ELNRNG":          {reflect.TypeOf(q.ELNRNG), constant.MakeInt64(int64(q.ELNRNG))},
			"ELOCKUNMAPPED":   {reflect.TypeOf(q.ELOCKUNMAPPED), constant.MakeInt64(int64(q.ELOCKUNMAPPED))},
			"ELOOP":           {reflect.TypeOf(q.ELOOP), constant.MakeInt64(int64(q.ELOOP))},
			"EMFILE":          {reflect.TypeOf(q.EMFILE), constant.MakeInt64(int64(q.EMFILE))},
			"EMLINK":          {reflect.TypeOf(q.EMLINK), constant.MakeInt64(int64(q.EMLINK))},
			"EMSGSIZE":        {reflect.TypeOf(q.EMSGSIZE), constant.MakeInt64(int64(q.EMSGSIZE))},
			"EMULTIHOP":       {reflect.TypeOf(q.EMULTIHOP), constant.MakeInt64(int64(q.EMULTIHOP))},
			"ENAMETOOLONG":    {reflect.TypeOf(q.ENAMETOOLONG), constant.MakeInt64(int64(q.ENAMETOOLONG))},
			"ENETDOWN":        {reflect.TypeOf(q.ENETDOWN), constant.MakeInt64(int64(q.ENETDOWN))},
			"ENETRESET":       {reflect.TypeOf(q.ENETRESET), constant.MakeInt64(int64(q.ENETRESET))},
			"ENETUNREACH":     {reflect.TypeOf(q.ENETUNREACH), constant.MakeInt64(int64(q.ENETUNREACH))},
			"ENFILE":          {reflect.TypeOf(q.ENFILE), constant.MakeInt64(int64(q.ENFILE))},
			"ENOANO":          {reflect.TypeOf(q.ENOANO), constant.MakeInt64(int64(q.ENOANO))},
			"ENOBUFS":         {reflect.TypeOf(q.ENOBUFS), constant.MakeInt64(int64(q.ENOBUFS))},
			"ENOCSI":          {reflect.TypeOf(q.ENOCSI), constant.MakeInt64(int64(q.ENOCSI))},
			"ENODATA":         {reflect.TypeOf(q.ENODATA), constant.MakeInt64(int64(q.ENODATA))},
			"ENODEV":          {reflect.TypeOf(q.ENODEV), constant.MakeInt64(int64(q.ENODEV))},
			"ENOENT":          {reflect.TypeOf(q.ENOENT), constant.MakeInt64(int64(q.ENOENT))},
			"ENOEXEC":         {reflect.TypeOf(q.ENOEXEC), constant.MakeInt64(int64(q.ENOEXEC))},
			"ENOLCK":          {reflect.TypeOf(q.ENOLCK), constant.MakeInt64(int64(q.ENOLCK))},
			"ENOLINK":         {reflect.TypeOf(q.ENOLINK), constant.MakeInt64(int64(q.ENOLINK))},
			"ENOMEM":          {reflect.TypeOf(q.ENOMEM), constant.MakeInt64(int64(q.ENOMEM))},
			"ENOMSG":          {reflect.TypeOf(q.ENOMSG), constant.MakeInt64(int64(q.ENOMSG))},
			"ENONET":          {reflect.TypeOf(q.ENONET), constant.MakeInt64(int64(q.ENONET))},
			"ENOPKG":          {reflect.TypeOf(q.ENOPKG), constant.MakeInt64(int64(q.ENOPKG))},
			"ENOPROTOOPT":     {reflect.TypeOf(q.ENOPROTOOPT), constant.MakeInt64(int64(q.ENOPROTOOPT))},
			"ENOSPC":          {reflect.TypeOf(q.ENOSPC), constant.MakeInt64(int64(q.ENOSPC))},
			"ENOSR":           {reflect.TypeOf(q.ENOSR), constant.MakeInt64(int64(q.ENOSR))},
			"ENOSTR":          {reflect.TypeOf(q.ENOSTR), constant.MakeInt64(int64(q.ENOSTR))},
			"ENOSYS":          {reflect.TypeOf(q.ENOSYS), constant.MakeInt64(int64(q.ENOSYS))},
			"ENOTACTIVE":      {reflect.TypeOf(q.ENOTACTIVE), constant.MakeInt64(int64(q.ENOTACTIVE))},
			"ENOTBLK":         {reflect.TypeOf(q.ENOTBLK), constant.MakeInt64(int64(q.ENOTBLK))},
			"ENOTCONN":        {reflect.TypeOf(q.ENOTCONN), constant.MakeInt64(int64(q.ENOTCONN))},
			"ENOTDIR":         {reflect.TypeOf(q.ENOTDIR), constant.MakeInt64(int64(q.ENOTDIR))},
			"ENOTEMPTY":       {reflect.TypeOf(q.ENOTEMPTY), constant.MakeInt64(int64(q.ENOTEMPTY))},
			"ENOTRECOVERABLE": {reflect.TypeOf(q.ENOTRECOVERABLE), constant.MakeInt64(int64(q.ENOTRECOVERABLE))},
			"ENOTSOCK":        {reflect.TypeOf(q.ENOTSOCK), constant.MakeInt64(int64(q.ENOTSOCK))},
			"ENOTSUP":         {reflect.TypeOf(q.ENOTSUP), constant.MakeInt64(int64(q.ENOTSUP))},
			"ENOTTY":          {reflect.TypeOf(q.ENOTTY), constant.MakeInt64(int64(q.ENOTTY))},
			"ENOTUNIQ":        {reflect.TypeOf(q.ENOTUNIQ), constant.MakeInt64(int64(q.ENOTUNIQ))},
			"ENXIO":           {reflect.TypeOf(q.ENXIO), constant.MakeInt64(int64(q.ENXIO))},
			"EOPNOTSUPP":      {reflect.TypeOf(q.EOPNOTSUPP), constant.MakeInt64(int64(q.EOPNOTSUPP))},
			"EOVERFLOW":       {reflect.TypeOf(q.EOVERFLOW), constant.MakeInt64(int64(q.EOVERFLOW))},
			"EOWNERDEAD":      {reflect.TypeOf(q.EOWNERDEAD), constant.MakeInt64(int64(q.EOWNERDEAD))},
			"EPERM":           {reflect.TypeOf(q.EPERM), constant.MakeInt64(int64(q.EPERM))},
			"EPFNOSUPPORT":    {reflect.TypeOf(q.EPFNOSUPPORT), constant.MakeInt64(int64(q.EPFNOSUPPORT))},
			"EPIPE":           {reflect.TypeOf(q.EPIPE), constant.MakeInt64(int64(q.EPIPE))},
			"EPROTO":          {reflect.TypeOf(q.EPROTO), constant.MakeInt64(int64(q.EPROTO))},
			"EPROTONOSUPPORT": {reflect.TypeOf(q.EPROTONOSUPPORT), constant.MakeInt64(int64(q.EPROTONOSUPPORT))},
			"EPROTOTYPE":      {reflect.TypeOf(q.EPROTOTYPE), constant.MakeInt64(int64(q.EPROTOTYPE))},
			"ERANGE":          {reflect.TypeOf(q.ERANGE), constant.MakeInt64(int64(q.ERANGE))},
			"EREMCHG":         {reflect.TypeOf(q.EREMCHG), constant.MakeInt64(int64(q.EREMCHG))},
			"EREMOTE":         {reflect.TypeOf(q.EREMOTE), constant.MakeInt64(int64(q.EREMOTE))},
			"ERESTART":        {reflect.TypeOf(q.ERESTART), constant.MakeInt64(int64(q.ERESTART))},
			"EROFS":           {reflect.TypeOf(q.EROFS), constant.MakeInt64(int64(q.EROFS))},
			"ESHUTDOWN":       {reflect.TypeOf(q.ESHUTDOWN), constant.MakeInt64(int64(q.ESHUTDOWN))},
			"ESOCKTNOSUPPORT": {reflect.TypeOf(q.ESOCKTNOSUPPORT), constant.MakeInt64(int64(q.ESOCKTNOSUPPORT))},
			"ESPIPE":          {reflect.TypeOf(q.ESPIPE), constant.MakeInt64(int64(q.ESPIPE))},
			"ESRCH":           {reflect.TypeOf(q.ESRCH), constant.MakeInt64(int64(q.ESRCH))},
			"ESRMNT":          {reflect.TypeOf(q.ESRMNT), constant.MakeInt64(int64(q.ESRMNT))},
			"ESTALE":          {reflect.TypeOf(q.ESTALE), constant.MakeInt64(int64(q.ESTALE))},
			"ESTRPIPE":        {reflect.TypeOf(q.ESTRPIPE), constant.MakeInt64(int64(q.ESTRPIPE))},
			"ETIME":           {reflect.TypeOf(q.ETIME), constant.MakeInt64(int64(q.ETIME))},
			"ETIMEDOUT":       {reflect.TypeOf(q.ETIMEDOUT), constant.MakeInt64(int64(q.ETIMEDOUT))},
			"ETOOMANYREFS":    {reflect.TypeOf(q.ETOOMANYREFS), constant.MakeInt64(int64(q.ETOOMANYREFS))},
			"ETXTBSY":         {reflect.TypeOf(q.ETXTBSY), constant.MakeInt64(int64(q.ETXTBSY))},
			"EUNATCH":         {reflect.TypeOf(q.EUNATCH), constant.MakeInt64(int64(q.EUNATCH))},
			"EUSERS":          {reflect.TypeOf(q.EUSERS), constant.MakeInt64(int64(q.EUSERS))},
			"EWOULDBLOCK":     {reflect.TypeOf(q.EWOULDBLOCK), constant.MakeInt64(int64(q.EWOULDBLOCK))},
			"EXDEV":           {reflect.TypeOf(q.EXDEV), constant.MakeInt64(int64(q.EXDEV))},
			"EXFULL":          {reflect.TypeOf(q.EXFULL), constant.MakeInt64(int64(q.EXFULL))},
			"SIGABRT":         {reflect.TypeOf(q.SIGABRT), constant.MakeInt64(int64(q.SIGABRT))},
			"SIGALRM":         {reflect.TypeOf(q.SIGALRM), constant.MakeInt64(int64(q.SIGALRM))},
			"SIGBUS":          {reflect.TypeOf(q.SIGBUS), constant.MakeInt64(int64(q.SIGBUS))},
			"SIGCANCEL":       {reflect.TypeOf(q.SIGCANCEL), constant.MakeInt64(int64(q.SIGCANCEL))},
			"SIGCHLD":         {reflect.TypeOf(q.SIGCHLD), constant.MakeInt64(int64(q.SIGCHLD))},
			"SIGCLD":          {reflect.TypeOf(q.SIGCLD), constant.MakeInt64(int64(q.SIGCLD))},
			"SIGCONT":         {reflect.TypeOf(q.SIGCONT), constant.MakeInt64(int64(q.SIGCONT))},
			"SIGEMT":          {reflect.TypeOf(q.SIGEMT), constant.MakeInt64(int64(q.SIGEMT))},
			"SIGFPE":          {reflect.TypeOf(q.SIGFPE), constant.MakeInt64(int64(q.SIGFPE))},
			"SIGFREEZE":       {reflect.TypeOf(q.SIGFREEZE), constant.MakeInt64(int64(q.SIGFREEZE))},
			"SIGHUP":          {reflect.TypeOf(q.SIGHUP), constant.MakeInt64(int64(q.SIGHUP))},
			"SIGILL":          {reflect.TypeOf(q.SIGILL), constant.MakeInt64(int64(q.SIGILL))},
			"SIGINT":          {reflect.TypeOf(q.SIGINT), constant.MakeInt64(int64(q.SIGINT))},
			"SIGIO":           {reflect.TypeOf(q.SIGIO), constant.MakeInt64(int64(q.SIGIO))},
			"SIGIOT":          {reflect.TypeOf(q.SIGIOT), constant.MakeInt64(int64(q.SIGIOT))},
			"SIGJVM1":         {reflect.TypeOf(q.SIGJVM1), constant.MakeInt64(int64(q.SIGJVM1))},
			"SIGJVM2":         {reflect.TypeOf(q.SIGJVM2), constant.MakeInt64(int64(q.SIGJVM2))},
			"SIGKILL":         {reflect.TypeOf(q.SIGKILL), constant.MakeInt64(int64(q.SIGKILL))},
			"SIGLOST":         {reflect.TypeOf(q.SIGLOST), constant.MakeInt64(int64(q.SIGLOST))},
			"SIGLWP":          {reflect.TypeOf(q.SIGLWP), constant.MakeInt64(int64(q.SIGLWP))},
			"SIGPIPE":         {reflect.TypeOf(q.SIGPIPE), constant.MakeInt64(int64(q.SIGPIPE))},
			"SIGPOLL":         {reflect.TypeOf(q.SIGPOLL), constant.MakeInt64(int64(q.SIGPOLL))},
			"SIGPROF":         {reflect.TypeOf(q.SIGPROF), constant.MakeInt64(int64(q.SIGPROF))},
			"SIGPWR":          {reflect.TypeOf(q.SIGPWR), constant.MakeInt64(int64(q.SIGPWR))},
			"SIGQUIT":         {reflect.TypeOf(q.SIGQUIT), constant.MakeInt64(int64(q.SIGQUIT))},
			"SIGSEGV":         {reflect.TypeOf(q.SIGSEGV), constant.MakeInt64(int64(q.SIGSEGV))},
			"SIGSTOP":         {reflect.TypeOf(q.SIGSTOP), constant.MakeInt64(int64(q.SIGSTOP))},
			"SIGSYS":          {reflect.TypeOf(q.SIGSYS), constant.MakeInt64(int64(q.SIGSYS))},
			"SIGTERM":         {reflect.TypeOf(q.SIGTERM), constant.MakeInt64(int64(q.SIGTERM))},
			"SIGTHAW":         {reflect.TypeOf(q.SIGTHAW), constant.MakeInt64(int64(q.SIGTHAW))},
			"SIGTRAP":         {reflect.TypeOf(q.SIGTRAP), constant.MakeInt64(int64(q.SIGTRAP))},
			"SIGTSTP":         {reflect.TypeOf(q.SIGTSTP), constant.MakeInt64(int64(q.SIGTSTP))},
			"SIGTTIN":         {reflect.TypeOf(q.SIGTTIN), constant.MakeInt64(int64(q.SIGTTIN))},
			"SIGTTOU":         {reflect.TypeOf(q.SIGTTOU), constant.MakeInt64(int64(q.SIGTTOU))},
			"SIGURG":          {reflect.TypeOf(q.SIGURG), constant.MakeInt64(int64(q.SIGURG))},
			"SIGUSR1":         {reflect.TypeOf(q.SIGUSR1), constant.MakeInt64(int64(q.SIGUSR1))},
			"SIGUSR2":         {reflect.TypeOf(q.SIGUSR2), constant.MakeInt64(int64(q.SIGUSR2))},
			"SIGVTALRM":       {reflect.TypeOf(q.SIGVTALRM), constant.MakeInt64(int64(q.SIGVTALRM))},
			"SIGWAITING":      {reflect.TypeOf(q.SIGWAITING), constant.MakeInt64(int64(q.SIGWAITING))},
			"SIGWINCH":        {reflect.TypeOf(q.SIGWINCH), constant.MakeInt64(int64(q.SIGWINCH))},
			"SIGXCPU":         {reflect.TypeOf(q.SIGXCPU), constant.MakeInt64(int64(q.SIGXCPU))},
			"SIGXFSZ":         {reflect.TypeOf(q.SIGXFSZ), constant.MakeInt64(int64(q.SIGXFSZ))},
			"SIGXRES":         {reflect.TypeOf(q.SIGXRES), constant.MakeInt64(int64(q.SIGXRES))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"AF_802":                        {"untyped int", constant.MakeInt64(int64(q.AF_802))},
			"AF_APPLETALK":                  {"untyped int", constant.MakeInt64(int64(q.AF_APPLETALK))},
			"AF_CCITT":                      {"untyped int", constant.MakeInt64(int64(q.AF_CCITT))},
			"AF_CHAOS":                      {"untyped int", constant.MakeInt64(int64(q.AF_CHAOS))},
			"AF_DATAKIT":                    {"untyped int", constant.MakeInt64(int64(q.AF_DATAKIT))},
			"AF_DECnet":                     {"untyped int", constant.MakeInt64(int64(q.AF_DECnet))},
			"AF_DLI":                        {"untyped int", constant.MakeInt64(int64(q.AF_DLI))},
			"AF_ECMA":                       {"untyped int", constant.MakeInt64(int64(q.AF_ECMA))},
			"AF_FILE":                       {"untyped int", constant.MakeInt64(int64(q.AF_FILE))},
			"AF_GOSIP":                      {"untyped int", constant.MakeInt64(int64(q.AF_GOSIP))},
			"AF_HYLINK":                     {"untyped int", constant.MakeInt64(int64(q.AF_HYLINK))},
			"AF_IMPLINK":                    {"untyped int", constant.MakeInt64(int64(q.AF_IMPLINK))},
			"AF_INET":                       {"untyped int", constant.MakeInt64(int64(q.AF_INET))},
			"AF_INET6":                      {"untyped int", constant.MakeInt64(int64(q.AF_INET6))},
			"AF_INET_OFFLOAD":               {"untyped int", constant.MakeInt64(int64(q.AF_INET_OFFLOAD))},
			"AF_IPX":                        {"untyped int", constant.MakeInt64(int64(q.AF_IPX))},
			"AF_KEY":                        {"untyped int", constant.MakeInt64(int64(q.AF_KEY))},
			"AF_LAT":                        {"untyped int", constant.MakeInt64(int64(q.AF_LAT))},
			"AF_LINK":                       {"untyped int", constant.MakeInt64(int64(q.AF_LINK))},
			"AF_LOCAL":                      {"untyped int", constant.MakeInt64(int64(q.AF_LOCAL))},
			"AF_MAX":                        {"untyped int", constant.MakeInt64(int64(q.AF_MAX))},
			"AF_NBS":                        {"untyped int", constant.MakeInt64(int64(q.AF_NBS))},
			"AF_NCA":                        {"untyped int", constant.MakeInt64(int64(q.AF_NCA))},
			"AF_NIT":                        {"untyped int", constant.MakeInt64(int64(q.AF_NIT))},
			"AF_NS":                         {"untyped int", constant.MakeInt64(int64(q.AF_NS))},
			"AF_OSI":                        {"untyped int", constant.MakeInt64(int64(q.AF_OSI))},
			"AF_OSINET":                     {"untyped int", constant.MakeInt64(int64(q.AF_OSINET))},
			"AF_PACKET":                     {"untyped int", constant.MakeInt64(int64(q.AF_PACKET))},
			"AF_POLICY":                     {"untyped int", constant.MakeInt64(int64(q.AF_POLICY))},
			"AF_PUP":                        {"untyped int", constant.MakeInt64(int64(q.AF_PUP))},
			"AF_ROUTE":                      {"untyped int", constant.MakeInt64(int64(q.AF_ROUTE))},
			"AF_SNA":                        {"untyped int", constant.MakeInt64(int64(q.AF_SNA))},
			"AF_TRILL":                      {"untyped int", constant.MakeInt64(int64(q.AF_TRILL))},
			"AF_UNIX":                       {"untyped int", constant.MakeInt64(int64(q.AF_UNIX))},
			"AF_UNSPEC":                     {"untyped int", constant.MakeInt64(int64(q.AF_UNSPEC))},
			"AF_X25":                        {"untyped int", constant.MakeInt64(int64(q.AF_X25))},
			"ARPHRD_ARCNET":                 {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ARCNET))},
			"ARPHRD_ATM":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ATM))},
			"ARPHRD_AX25":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_AX25))},
			"ARPHRD_CHAOS":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_CHAOS))},
			"ARPHRD_EETHER":                 {"untyped int", constant.MakeInt64(int64(q.ARPHRD_EETHER))},
			"ARPHRD_ETHER":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ETHER))},
			"ARPHRD_FC":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FC))},
			"ARPHRD_FRAME":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FRAME))},
			"ARPHRD_HDLC":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_HDLC))},
			"ARPHRD_IB":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IB))},
			"ARPHRD_IEEE802":                {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE802))},
			"ARPHRD_IPATM":                  {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IPATM))},
			"ARPHRD_METRICOM":               {"untyped int", constant.MakeInt64(int64(q.ARPHRD_METRICOM))},
			"ARPHRD_TUNNEL":                 {"untyped int", constant.MakeInt64(int64(q.ARPHRD_TUNNEL))},
			"B0":                            {"untyped int", constant.MakeInt64(int64(q.B0))},
			"B110":                          {"untyped int", constant.MakeInt64(int64(q.B110))},
			"B115200":                       {"untyped int", constant.MakeInt64(int64(q.B115200))},
			"B1200":                         {"untyped int", constant.MakeInt64(int64(q.B1200))},
			"B134":                          {"untyped int", constant.MakeInt64(int64(q.B134))},
			"B150":                          {"untyped int", constant.MakeInt64(int64(q.B150))},
			"B153600":                       {"untyped int", constant.MakeInt64(int64(q.B153600))},
			"B1800":                         {"untyped int", constant.MakeInt64(int64(q.B1800))},
			"B19200":                        {"untyped int", constant.MakeInt64(int64(q.B19200))},
			"B200":                          {"untyped int", constant.MakeInt64(int64(q.B200))},
			"B230400":                       {"untyped int", constant.MakeInt64(int64(q.B230400))},
			"B2400":                         {"untyped int", constant.MakeInt64(int64(q.B2400))},
			"B300":                          {"untyped int", constant.MakeInt64(int64(q.B300))},
			"B307200":                       {"untyped int", constant.MakeInt64(int64(q.B307200))},
			"B38400":                        {"untyped int", constant.MakeInt64(int64(q.B38400))},
			"B460800":                       {"untyped int", constant.MakeInt64(int64(q.B460800))},
			"B4800":                         {"untyped int", constant.MakeInt64(int64(q.B4800))},
			"B50":                           {"untyped int", constant.MakeInt64(int64(q.B50))},
			"B57600":                        {"untyped int", constant.MakeInt64(int64(q.B57600))},
			"B600":                          {"untyped int", constant.MakeInt64(int64(q.B600))},
			"B75":                           {"untyped int", constant.MakeInt64(int64(q.B75))},
			"B76800":                        {"untyped int", constant.MakeInt64(int64(q.B76800))},
			"B921600":                       {"untyped int", constant.MakeInt64(int64(q.B921600))},
			"B9600":                         {"untyped int", constant.MakeInt64(int64(q.B9600))},
			"BIOCFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.BIOCFLUSH))},
			"BIOCGBLEN":                     {"untyped int", constant.MakeInt64(int64(q.BIOCGBLEN))},
			"BIOCGDLT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGDLT))},
			"BIOCGDLTLIST":                  {"untyped int", constant.MakeInt64(int64(q.BIOCGDLTLIST))},
			"BIOCGDLTLIST32":                {"untyped int", constant.MakeInt64(int64(q.BIOCGDLTLIST32))},
			"BIOCGETIF":                     {"untyped int", constant.MakeInt64(int64(q.BIOCGETIF))},
			"BIOCGETLIF":                    {"untyped int", constant.MakeInt64(int64(q.BIOCGETLIF))},
			"BIOCGHDRCMPLT":                 {"untyped int", constant.MakeInt64(int64(q.BIOCGHDRCMPLT))},
			"BIOCGRTIMEOUT":                 {"untyped int", constant.MakeInt64(int64(q.BIOCGRTIMEOUT))},
			"BIOCGRTIMEOUT32":               {"untyped int", constant.MakeInt64(int64(q.BIOCGRTIMEOUT32))},
			"BIOCGSEESENT":                  {"untyped int", constant.MakeInt64(int64(q.BIOCGSEESENT))},
			"BIOCGSTATS":                    {"untyped int", constant.MakeInt64(int64(q.BIOCGSTATS))},
			"BIOCGSTATSOLD":                 {"untyped int", constant.MakeInt64(int64(q.BIOCGSTATSOLD))},
			"BIOCIMMEDIATE":                 {"untyped int", constant.MakeInt64(int64(q.BIOCIMMEDIATE))},
			"BIOCPROMISC":                   {"untyped int", constant.MakeInt64(int64(q.BIOCPROMISC))},
			"BIOCSBLEN":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSBLEN))},
			"BIOCSDLT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCSDLT))},
			"BIOCSETF":                      {"untyped int", constant.MakeInt64(int64(q.BIOCSETF))},
			"BIOCSETF32":                    {"untyped int", constant.MakeInt64(int64(q.BIOCSETF32))},
			"BIOCSETIF":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSETIF))},
			"BIOCSETLIF":                    {"untyped int", constant.MakeInt64(int64(q.BIOCSETLIF))},
			"BIOCSHDRCMPLT":                 {"untyped int", constant.MakeInt64(int64(q.BIOCSHDRCMPLT))},
			"BIOCSRTIMEOUT":                 {"untyped int", constant.MakeInt64(int64(q.BIOCSRTIMEOUT))},
			"BIOCSRTIMEOUT32":               {"untyped int", constant.MakeInt64(int64(q.BIOCSRTIMEOUT32))},
			"BIOCSSEESENT":                  {"untyped int", constant.MakeInt64(int64(q.BIOCSSEESENT))},
			"BIOCSTCPF":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSTCPF))},
			"BIOCSUDPF":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSUDPF))},
			"BIOCVERSION":                   {"untyped int", constant.MakeInt64(int64(q.BIOCVERSION))},
			"BPF_A":                         {"untyped int", constant.MakeInt64(int64(q.BPF_A))},
			"BPF_ABS":                       {"untyped int", constant.MakeInt64(int64(q.BPF_ABS))},
			"BPF_ADD":                       {"untyped int", constant.MakeInt64(int64(q.BPF_ADD))},
			"BPF_ALIGNMENT":                 {"untyped int", constant.MakeInt64(int64(q.BPF_ALIGNMENT))},
			"BPF_ALU":                       {"untyped int", constant.MakeInt64(int64(q.BPF_ALU))},
			"BPF_AND":                       {"untyped int", constant.MakeInt64(int64(q.BPF_AND))},
			"BPF_B":                         {"untyped int", constant.MakeInt64(int64(q.BPF_B))},
			"BPF_DFLTBUFSIZE":               {"untyped int", constant.MakeInt64(int64(q.BPF_DFLTBUFSIZE))},
			"BPF_DIV":                       {"untyped int", constant.MakeInt64(int64(q.BPF_DIV))},
			"BPF_H":                         {"untyped int", constant.MakeInt64(int64(q.BPF_H))},
			"BPF_IMM":                       {"untyped int", constant.MakeInt64(int64(q.BPF_IMM))},
			"BPF_IND":                       {"untyped int", constant.MakeInt64(int64(q.BPF_IND))},
			"BPF_JA":                        {"untyped int", constant.MakeInt64(int64(q.BPF_JA))},
			"BPF_JEQ":                       {"untyped int", constant.MakeInt64(int64(q.BPF_JEQ))},
			"BPF_JGE":                       {"untyped int", constant.MakeInt64(int64(q.BPF_JGE))},
			"BPF_JGT":                       {"untyped int", constant.MakeInt64(int64(q.BPF_JGT))},
			"BPF_JMP":                       {"untyped int", constant.MakeInt64(int64(q.BPF_JMP))},
			"BPF_JSET":                      {"untyped int", constant.MakeInt64(int64(q.BPF_JSET))},
			"BPF_K":                         {"untyped int", constant.MakeInt64(int64(q.BPF_K))},
			"BPF_LD":                        {"untyped int", constant.MakeInt64(int64(q.BPF_LD))},
			"BPF_LDX":                       {"untyped int", constant.MakeInt64(int64(q.BPF_LDX))},
			"BPF_LEN":                       {"untyped int", constant.MakeInt64(int64(q.BPF_LEN))},
			"BPF_LSH":                       {"untyped int", constant.MakeInt64(int64(q.BPF_LSH))},
			"BPF_MAJOR_VERSION":             {"untyped int", constant.MakeInt64(int64(q.BPF_MAJOR_VERSION))},
			"BPF_MAXBUFSIZE":                {"untyped int", constant.MakeInt64(int64(q.BPF_MAXBUFSIZE))},
			"BPF_MAXINSNS":                  {"untyped int", constant.MakeInt64(int64(q.BPF_MAXINSNS))},
			"BPF_MEM":                       {"untyped int", constant.MakeInt64(int64(q.BPF_MEM))},
			"BPF_MEMWORDS":                  {"untyped int", constant.MakeInt64(int64(q.BPF_MEMWORDS))},
			"BPF_MINBUFSIZE":                {"untyped int", constant.MakeInt64(int64(q.BPF_MINBUFSIZE))},
			"BPF_MINOR_VERSION":             {"untyped int", constant.MakeInt64(int64(q.BPF_MINOR_VERSION))},
			"BPF_MISC":                      {"untyped int", constant.MakeInt64(int64(q.BPF_MISC))},
			"BPF_MSH":                       {"untyped int", constant.MakeInt64(int64(q.BPF_MSH))},
			"BPF_MUL":                       {"untyped int", constant.MakeInt64(int64(q.BPF_MUL))},
			"BPF_NEG":                       {"untyped int", constant.MakeInt64(int64(q.BPF_NEG))},
			"BPF_OR":                        {"untyped int", constant.MakeInt64(int64(q.BPF_OR))},
			"BPF_RELEASE":                   {"untyped int", constant.MakeInt64(int64(q.BPF_RELEASE))},
			"BPF_RET":                       {"untyped int", constant.MakeInt64(int64(q.BPF_RET))},
			"BPF_RSH":                       {"untyped int", constant.MakeInt64(int64(q.BPF_RSH))},
			"BPF_ST":                        {"untyped int", constant.MakeInt64(int64(q.BPF_ST))},
			"BPF_STX":                       {"untyped int", constant.MakeInt64(int64(q.BPF_STX))},
			"BPF_SUB":                       {"untyped int", constant.MakeInt64(int64(q.BPF_SUB))},
			"BPF_TAX":                       {"untyped int", constant.MakeInt64(int64(q.BPF_TAX))},
			"BPF_TXA":                       {"untyped int", constant.MakeInt64(int64(q.BPF_TXA))},
			"BPF_W":                         {"untyped int", constant.MakeInt64(int64(q.BPF_W))},
			"BPF_X":                         {"untyped int", constant.MakeInt64(int64(q.BPF_X))},
			"BRKINT":                        {"untyped int", constant.MakeInt64(int64(q.BRKINT))},
			"CFLUSH":                        {"untyped int", constant.MakeInt64(int64(q.CFLUSH))},
			"CLOCAL":                        {"untyped int", constant.MakeInt64(int64(q.CLOCAL))},
			"CREAD":                         {"untyped int", constant.MakeInt64(int64(q.CREAD))},
			"CS5":                           {"untyped int", constant.MakeInt64(int64(q.CS5))},
			"CS6":                           {"untyped int", constant.MakeInt64(int64(q.CS6))},
			"CS7":                           {"untyped int", constant.MakeInt64(int64(q.CS7))},
			"CS8":                           {"untyped int", constant.MakeInt64(int64(q.CS8))},
			"CSIZE":                         {"untyped int", constant.MakeInt64(int64(q.CSIZE))},
			"CSTART":                        {"untyped int", constant.MakeInt64(int64(q.CSTART))},
			"CSTOP":                         {"untyped int", constant.MakeInt64(int64(q.CSTOP))},
			"CSTOPB":                        {"untyped int", constant.MakeInt64(int64(q.CSTOPB))},
			"CSUSP":                         {"untyped int", constant.MakeInt64(int64(q.CSUSP))},
			"CSWTCH":                        {"untyped int", constant.MakeInt64(int64(q.CSWTCH))},
			"DLT_AIRONET_HEADER":            {"untyped int", constant.MakeInt64(int64(q.DLT_AIRONET_HEADER))},
			"DLT_APPLE_IP_OVER_IEEE1394":    {"untyped int", constant.MakeInt64(int64(q.DLT_APPLE_IP_OVER_IEEE1394))},
			"DLT_ARCNET":                    {"untyped int", constant.MakeInt64(int64(q.DLT_ARCNET))},
			"DLT_ARCNET_LINUX":              {"untyped int", constant.MakeInt64(int64(q.DLT_ARCNET_LINUX))},
			"DLT_ATM_CLIP":                  {"untyped int", constant.MakeInt64(int64(q.DLT_ATM_CLIP))},
			"DLT_ATM_RFC1483":               {"untyped int", constant.MakeInt64(int64(q.DLT_ATM_RFC1483))},
			"DLT_AURORA":                    {"untyped int", constant.MakeInt64(int64(q.DLT_AURORA))},
			"DLT_AX25":                      {"untyped int", constant.MakeInt64(int64(q.DLT_AX25))},
			"DLT_BACNET_MS_TP":              {"untyped int", constant.MakeInt64(int64(q.DLT_BACNET_MS_TP))},
			"DLT_CHAOS":                     {"untyped int", constant.MakeInt64(int64(q.DLT_CHAOS))},
			"DLT_CISCO_IOS":                 {"untyped int", constant.MakeInt64(int64(q.DLT_CISCO_IOS))},
			"DLT_C_HDLC":                    {"untyped int", constant.MakeInt64(int64(q.DLT_C_HDLC))},
			"DLT_DOCSIS":                    {"untyped int", constant.MakeInt64(int64(q.DLT_DOCSIS))},
			"DLT_ECONET":                    {"untyped int", constant.MakeInt64(int64(q.DLT_ECONET))},
			"DLT_EN10MB":                    {"untyped int", constant.MakeInt64(int64(q.DLT_EN10MB))},
			"DLT_EN3MB":                     {"untyped int", constant.MakeInt64(int64(q.DLT_EN3MB))},
			"DLT_ENC":                       {"untyped int", constant.MakeInt64(int64(q.DLT_ENC))},
			"DLT_ERF_ETH":                   {"untyped int", constant.MakeInt64(int64(q.DLT_ERF_ETH))},
			"DLT_ERF_POS":                   {"untyped int", constant.MakeInt64(int64(q.DLT_ERF_POS))},
			"DLT_FDDI":                      {"untyped int", constant.MakeInt64(int64(q.DLT_FDDI))},
			"DLT_FRELAY":                    {"untyped int", constant.MakeInt64(int64(q.DLT_FRELAY))},
			"DLT_GCOM_SERIAL":               {"untyped int", constant.MakeInt64(int64(q.DLT_GCOM_SERIAL))},
			"DLT_GCOM_T1E1":                 {"untyped int", constant.MakeInt64(int64(q.DLT_GCOM_T1E1))},
			"DLT_GPF_F":                     {"untyped int", constant.MakeInt64(int64(q.DLT_GPF_F))},
			"DLT_GPF_T":                     {"untyped int", constant.MakeInt64(int64(q.DLT_GPF_T))},
			"DLT_GPRS_LLC":                  {"untyped int", constant.MakeInt64(int64(q.DLT_GPRS_LLC))},
			"DLT_HDLC":                      {"untyped int", constant.MakeInt64(int64(q.DLT_HDLC))},
			"DLT_HHDLC":                     {"untyped int", constant.MakeInt64(int64(q.DLT_HHDLC))},
			"DLT_HIPPI":                     {"untyped int", constant.MakeInt64(int64(q.DLT_HIPPI))},
			"DLT_IBM_SN":                    {"untyped int", constant.MakeInt64(int64(q.DLT_IBM_SN))},
			"DLT_IBM_SP":                    {"untyped int", constant.MakeInt64(int64(q.DLT_IBM_SP))},
			"DLT_IEEE802":                   {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802))},
			"DLT_IEEE802_11":                {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11))},
			"DLT_IEEE802_11_RADIO":          {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11_RADIO))},
			"DLT_IEEE802_11_RADIO_AVS":      {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11_RADIO_AVS))},
			"DLT_IPNET":                     {"untyped int", constant.MakeInt64(int64(q.DLT_IPNET))},
			"DLT_IPOIB":                     {"untyped int", constant.MakeInt64(int64(q.DLT_IPOIB))},
			"DLT_IP_OVER_FC":                {"untyped int", constant.MakeInt64(int64(q.DLT_IP_OVER_FC))},
			"DLT_JUNIPER_ATM1":              {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ATM1))},
			"DLT_JUNIPER_ATM2":              {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ATM2))},
			"DLT_JUNIPER_CHDLC":             {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_CHDLC))},
			"DLT_JUNIPER_ES":                {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ES))},
			"DLT_JUNIPER_ETHER":             {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ETHER))},
			"DLT_JUNIPER_FRELAY":            {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_FRELAY))},
			"DLT_JUNIPER_GGSN":              {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_GGSN))},
			"DLT_JUNIPER_MFR":               {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MFR))},
			"DLT_JUNIPER_MLFR":              {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MLFR))},
			"DLT_JUNIPER_MLPPP":             {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MLPPP))},
			"DLT_JUNIPER_MONITOR":           {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MONITOR))},
			"DLT_JUNIPER_PIC_PEER":          {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PIC_PEER))},
			"DLT_JUNIPER_PPP":               {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PPP))},
			"DLT_JUNIPER_PPPOE":             {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PPPOE))},
			"DLT_JUNIPER_PPPOE_ATM":         {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PPPOE_ATM))},
			"DLT_JUNIPER_SERVICES":          {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_SERVICES))},
			"DLT_LINUX_IRDA":                {"untyped int", constant.MakeInt64(int64(q.DLT_LINUX_IRDA))},
			"DLT_LINUX_LAPD":                {"untyped int", constant.MakeInt64(int64(q.DLT_LINUX_LAPD))},
			"DLT_LINUX_SLL":                 {"untyped int", constant.MakeInt64(int64(q.DLT_LINUX_SLL))},
			"DLT_LOOP":                      {"untyped int", constant.MakeInt64(int64(q.DLT_LOOP))},
			"DLT_LTALK":                     {"untyped int", constant.MakeInt64(int64(q.DLT_LTALK))},
			"DLT_MTP2":                      {"untyped int", constant.MakeInt64(int64(q.DLT_MTP2))},
			"DLT_MTP2_WITH_PHDR":            {"untyped int", constant.MakeInt64(int64(q.DLT_MTP2_WITH_PHDR))},
			"DLT_MTP3":                      {"untyped int", constant.MakeInt64(int64(q.DLT_MTP3))},
			"DLT_NULL":                      {"untyped int", constant.MakeInt64(int64(q.DLT_NULL))},
			"DLT_PCI_EXP":                   {"untyped int", constant.MakeInt64(int64(q.DLT_PCI_EXP))},
			"DLT_PFLOG":                     {"untyped int", constant.MakeInt64(int64(q.DLT_PFLOG))},
			"DLT_PFSYNC":                    {"untyped int", constant.MakeInt64(int64(q.DLT_PFSYNC))},
			"DLT_PPP":                       {"untyped int", constant.MakeInt64(int64(q.DLT_PPP))},
			"DLT_PPP_BSDOS":                 {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_BSDOS))},
			"DLT_PPP_PPPD":                  {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_PPPD))},
			"DLT_PRISM_HEADER":              {"untyped int", constant.MakeInt64(int64(q.DLT_PRISM_HEADER))},
			"DLT_PRONET":                    {"untyped int", constant.MakeInt64(int64(q.DLT_PRONET))},
			"DLT_RAW":                       {"untyped int", constant.MakeInt64(int64(q.DLT_RAW))},
			"DLT_RAWAF_MASK":                {"untyped int", constant.MakeInt64(int64(q.DLT_RAWAF_MASK))},
			"DLT_RIO":                       {"untyped int", constant.MakeInt64(int64(q.DLT_RIO))},
			"DLT_SCCP":                      {"untyped int", constant.MakeInt64(int64(q.DLT_SCCP))},
			"DLT_SLIP":                      {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP))},
			"DLT_SLIP_BSDOS":                {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP_BSDOS))},
			"DLT_SUNATM":                    {"untyped int", constant.MakeInt64(int64(q.DLT_SUNATM))},
			"DLT_SYMANTEC_FIREWALL":         {"untyped int", constant.MakeInt64(int64(q.DLT_SYMANTEC_FIREWALL))},
			"DLT_TZSP":                      {"untyped int", constant.MakeInt64(int64(q.DLT_TZSP))},
			"ECHO":                          {"untyped int", constant.MakeInt64(int64(q.ECHO))},
			"ECHOCTL":                       {"untyped int", constant.MakeInt64(int64(q.ECHOCTL))},
			"ECHOE":                         {"untyped int", constant.MakeInt64(int64(q.ECHOE))},
			"ECHOK":                         {"untyped int", constant.MakeInt64(int64(q.ECHOK))},
			"ECHOKE":                        {"untyped int", constant.MakeInt64(int64(q.ECHOKE))},
			"ECHONL":                        {"untyped int", constant.MakeInt64(int64(q.ECHONL))},
			"ECHOPRT":                       {"untyped int", constant.MakeInt64(int64(q.ECHOPRT))},
			"EMPTY_SET":                     {"untyped int", constant.MakeInt64(int64(q.EMPTY_SET))},
			"EMT_CPCOVF":                    {"untyped int", constant.MakeInt64(int64(q.EMT_CPCOVF))},
			"EQUALITY_CHECK":                {"untyped int", constant.MakeInt64(int64(q.EQUALITY_CHECK))},
			"EXTA":                          {"untyped int", constant.MakeInt64(int64(q.EXTA))},
			"EXTB":                          {"untyped int", constant.MakeInt64(int64(q.EXTB))},
			"FD_CLOEXEC":                    {"untyped int", constant.MakeInt64(int64(q.FD_CLOEXEC))},
			"FD_NFDBITS":                    {"untyped int", constant.MakeInt64(int64(q.FD_NFDBITS))},
			"FD_SETSIZE":                    {"untyped int", constant.MakeInt64(int64(q.FD_SETSIZE))},
			"FLUSHALL":                      {"untyped int", constant.MakeInt64(int64(q.FLUSHALL))},
			"FLUSHDATA":                     {"untyped int", constant.MakeInt64(int64(q.FLUSHDATA))},
			"FLUSHO":                        {"untyped int", constant.MakeInt64(int64(q.FLUSHO))},
			"F_ALLOCSP":                     {"untyped int", constant.MakeInt64(int64(q.F_ALLOCSP))},
			"F_ALLOCSP64":                   {"untyped int", constant.MakeInt64(int64(q.F_ALLOCSP64))},
			"F_BADFD":                       {"untyped int", constant.MakeInt64(int64(q.F_BADFD))},
			"F_BLKSIZE":                     {"untyped int", constant.MakeInt64(int64(q.F_BLKSIZE))},
			"F_BLOCKS":                      {"untyped int", constant.MakeInt64(int64(q.F_BLOCKS))},
			"F_CHKFL":                       {"untyped int", constant.MakeInt64(int64(q.F_CHKFL))},
			"F_COMPAT":                      {"untyped int", constant.MakeInt64(int64(q.F_COMPAT))},
			"F_DUP2FD":                      {"untyped int", constant.MakeInt64(int64(q.F_DUP2FD))},
			"F_DUP2FD_CLOEXEC":              {"untyped int", constant.MakeInt64(int64(q.F_DUP2FD_CLOEXEC))},
			"F_DUPFD":                       {"untyped int", constant.MakeInt64(int64(q.F_DUPFD))},
			"F_DUPFD_CLOEXEC":               {"untyped int", constant.MakeInt64(int64(q.F_DUPFD_CLOEXEC))},
			"F_FREESP":                      {"untyped int", constant.MakeInt64(int64(q.F_FREESP))},
			"F_FREESP64":                    {"untyped int", constant.MakeInt64(int64(q.F_FREESP64))},
			"F_GETFD":                       {"untyped int", constant.MakeInt64(int64(q.F_GETFD))},
			"F_GETFL":                       {"untyped int", constant.MakeInt64(int64(q.F_GETFL))},
			"F_GETLK":                       {"untyped int", constant.MakeInt64(int64(q.F_GETLK))},
			"F_GETLK64":                     {"untyped int", constant.MakeInt64(int64(q.F_GETLK64))},
			"F_GETOWN":                      {"untyped int", constant.MakeInt64(int64(q.F_GETOWN))},
			"F_GETXFL":                      {"untyped int", constant.MakeInt64(int64(q.F_GETXFL))},
			"F_HASREMOTELOCKS":              {"untyped int", constant.MakeInt64(int64(q.F_HASREMOTELOCKS))},
			"F_ISSTREAM":                    {"untyped int", constant.MakeInt64(int64(q.F_ISSTREAM))},
			"F_MANDDNY":                     {"untyped int", constant.MakeInt64(int64(q.F_MANDDNY))},
			"F_MDACC":                       {"untyped int", constant.MakeInt64(int64(q.F_MDACC))},
			"F_NODNY":                       {"untyped int", constant.MakeInt64(int64(q.F_NODNY))},
			"F_NPRIV":                       {"untyped int", constant.MakeInt64(int64(q.F_NPRIV))},
			"F_PRIV":                        {"untyped int", constant.MakeInt64(int64(q.F_PRIV))},
			"F_QUOTACTL":                    {"untyped int", constant.MakeInt64(int64(q.F_QUOTACTL))},
			"F_RDACC":                       {"untyped int", constant.MakeInt64(int64(q.F_RDACC))},
			"F_RDDNY":                       {"untyped int", constant.MakeInt64(int64(q.F_RDDNY))},
			"F_RDLCK":                       {"untyped int", constant.MakeInt64(int64(q.F_RDLCK))},
			"F_REVOKE":                      {"untyped int", constant.MakeInt64(int64(q.F_REVOKE))},
			"F_RMACC":                       {"untyped int", constant.MakeInt64(int64(q.F_RMACC))},
			"F_RMDNY":                       {"untyped int", constant.MakeInt64(int64(q.F_RMDNY))},
			"F_RWACC":                       {"untyped int", constant.MakeInt64(int64(q.F_RWACC))},
			"F_RWDNY":                       {"untyped int", constant.MakeInt64(int64(q.F_RWDNY))},
			"F_SETFD":                       {"untyped int", constant.MakeInt64(int64(q.F_SETFD))},
			"F_SETFL":                       {"untyped int", constant.MakeInt64(int64(q.F_SETFL))},
			"F_SETLK":                       {"untyped int", constant.MakeInt64(int64(q.F_SETLK))},
			"F_SETLK64":                     {"untyped int", constant.MakeInt64(int64(q.F_SETLK64))},
			"F_SETLK64_NBMAND":              {"untyped int", constant.MakeInt64(int64(q.F_SETLK64_NBMAND))},
			"F_SETLKW":                      {"untyped int", constant.MakeInt64(int64(q.F_SETLKW))},
			"F_SETLKW64":                    {"untyped int", constant.MakeInt64(int64(q.F_SETLKW64))},
			"F_SETLK_NBMAND":                {"untyped int", constant.MakeInt64(int64(q.F_SETLK_NBMAND))},
			"F_SETOWN":                      {"untyped int", constant.MakeInt64(int64(q.F_SETOWN))},
			"F_SHARE":                       {"untyped int", constant.MakeInt64(int64(q.F_SHARE))},
			"F_SHARE_NBMAND":                {"untyped int", constant.MakeInt64(int64(q.F_SHARE_NBMAND))},
			"F_UNLCK":                       {"untyped int", constant.MakeInt64(int64(q.F_UNLCK))},
			"F_UNLKSYS":                     {"untyped int", constant.MakeInt64(int64(q.F_UNLKSYS))},
			"F_UNSHARE":                     {"untyped int", constant.MakeInt64(int64(q.F_UNSHARE))},
			"F_WRACC":                       {"untyped int", constant.MakeInt64(int64(q.F_WRACC))},
			"F_WRDNY":                       {"untyped int", constant.MakeInt64(int64(q.F_WRDNY))},
			"F_WRLCK":                       {"untyped int", constant.MakeInt64(int64(q.F_WRLCK))},
			"HUPCL":                         {"untyped int", constant.MakeInt64(int64(q.HUPCL))},
			"ICANON":                        {"untyped int", constant.MakeInt64(int64(q.ICANON))},
			"ICRNL":                         {"untyped int", constant.MakeInt64(int64(q.ICRNL))},
			"IEXTEN":                        {"untyped int", constant.MakeInt64(int64(q.IEXTEN))},
			"IFF_ADDRCONF":                  {"untyped int", constant.MakeInt64(int64(q.IFF_ADDRCONF))},
			"IFF_ALLMULTI":                  {"untyped int", constant.MakeInt64(int64(q.IFF_ALLMULTI))},
			"IFF_ANYCAST":                   {"untyped int", constant.MakeInt64(int64(q.IFF_ANYCAST))},
			"IFF_BROADCAST":                 {"untyped int", constant.MakeInt64(int64(q.IFF_BROADCAST))},
			"IFF_CANTCHANGE":                {"untyped int", constant.MakeInt64(int64(q.IFF_CANTCHANGE))},
			"IFF_COS_ENABLED":               {"untyped int", constant.MakeInt64(int64(q.IFF_COS_ENABLED))},
			"IFF_DEBUG":                     {"untyped int", constant.MakeInt64(int64(q.IFF_DEBUG))},
			"IFF_DEPRECATED":                {"untyped int", constant.MakeInt64(int64(q.IFF_DEPRECATED))},
			"IFF_DHCPRUNNING":               {"untyped int", constant.MakeInt64(int64(q.IFF_DHCPRUNNING))},
			"IFF_DUPLICATE":                 {"untyped int", constant.MakeInt64(int64(q.IFF_DUPLICATE))},
			"IFF_FAILED":                    {"untyped int", constant.MakeInt64(int64(q.IFF_FAILED))},
			"IFF_FIXEDMTU":                  {"untyped int", constant.MakeInt64(int64(q.IFF_FIXEDMTU))},
			"IFF_INACTIVE":                  {"untyped int", constant.MakeInt64(int64(q.IFF_INACTIVE))},
			"IFF_INTELLIGENT":               {"untyped int", constant.MakeInt64(int64(q.IFF_INTELLIGENT))},
			"IFF_IPMP":                      {"untyped int", constant.MakeInt64(int64(q.IFF_IPMP))},
			"IFF_IPMP_CANTCHANGE":           {"untyped int", constant.MakeInt64(int64(q.IFF_IPMP_CANTCHANGE))},
			"IFF_IPMP_INVALID":              {"untyped int", constant.MakeInt64(int64(q.IFF_IPMP_INVALID))},
			"IFF_IPV4":                      {"untyped int", constant.MakeInt64(int64(q.IFF_IPV4))},
			"IFF_IPV6":                      {"untyped int", constant.MakeInt64(int64(q.IFF_IPV6))},
			"IFF_L3PROTECT":                 {"untyped int", constant.MakeInt64(int64(q.IFF_L3PROTECT))},
			"IFF_LOOPBACK":                  {"untyped int", constant.MakeInt64(int64(q.IFF_LOOPBACK))},
			"IFF_MULTICAST":                 {"untyped int", constant.MakeInt64(int64(q.IFF_MULTICAST))},
			"IFF_MULTI_BCAST":               {"untyped int", constant.MakeInt64(int64(q.IFF_MULTI_BCAST))},
			"IFF_NOACCEPT":                  {"untyped int", constant.MakeInt64(int64(q.IFF_NOACCEPT))},
			"IFF_NOARP":                     {"untyped int", constant.MakeInt64(int64(q.IFF_NOARP))},
			"IFF_NOFAILOVER":                {"untyped int", constant.MakeInt64(int64(q.IFF_NOFAILOVER))},
			"IFF_NOLINKLOCAL":               {"untyped int", constant.MakeInt64(int64(q.IFF_NOLINKLOCAL))},
			"IFF_NOLOCAL":                   {"untyped int", constant.MakeInt64(int64(q.IFF_NOLOCAL))},
			"IFF_NONUD":                     {"untyped int", constant.MakeInt64(int64(q.IFF_NONUD))},
			"IFF_NORTEXCH":                  {"untyped int", constant.MakeInt64(int64(q.IFF_NORTEXCH))},
			"IFF_NOTRAILERS":                {"untyped int", constant.MakeInt64(int64(q.IFF_NOTRAILERS))},
			"IFF_NOXMIT":                    {"untyped int", constant.MakeInt64(int64(q.IFF_NOXMIT))},
			"IFF_OFFLINE":                   {"untyped int", constant.MakeInt64(int64(q.IFF_OFFLINE))},
			"IFF_POINTOPOINT":               {"untyped int", constant.MakeInt64(int64(q.IFF_POINTOPOINT))},
			"IFF_PREFERRED":                 {"untyped int", constant.MakeInt64(int64(q.IFF_PREFERRED))},
			"IFF_PRIVATE":                   {"untyped int", constant.MakeInt64(int64(q.IFF_PRIVATE))},
			"IFF_PROMISC":                   {"untyped int", constant.MakeInt64(int64(q.IFF_PROMISC))},
			"IFF_ROUTER":                    {"untyped int", constant.MakeInt64(int64(q.IFF_ROUTER))},
			"IFF_RUNNING":                   {"untyped int", constant.MakeInt64(int64(q.IFF_RUNNING))},
			"IFF_STANDBY":                   {"untyped int", constant.MakeInt64(int64(q.IFF_STANDBY))},
			"IFF_TEMPORARY":                 {"untyped int", constant.MakeInt64(int64(q.IFF_TEMPORARY))},
			"IFF_UNNUMBERED":                {"untyped int", constant.MakeInt64(int64(q.IFF_UNNUMBERED))},
			"IFF_UP":                        {"untyped int", constant.MakeInt64(int64(q.IFF_UP))},
			"IFF_VIRTUAL":                   {"untyped int", constant.MakeInt64(int64(q.IFF_VIRTUAL))},
			"IFF_VRRP":                      {"untyped int", constant.MakeInt64(int64(q.IFF_VRRP))},
			"IFF_XRESOLV":                   {"untyped int", constant.MakeInt64(int64(q.IFF_XRESOLV))},
			"IFNAMSIZ":                      {"untyped int", constant.MakeInt64(int64(q.IFNAMSIZ))},
			"IFT_1822":                      {"untyped int", constant.MakeInt64(int64(q.IFT_1822))},
			"IFT_6TO4":                      {"untyped int", constant.MakeInt64(int64(q.IFT_6TO4))},
			"IFT_AAL5":                      {"untyped int", constant.MakeInt64(int64(q.IFT_AAL5))},
			"IFT_ARCNET":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNET))},
			"IFT_ARCNETPLUS":                {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNETPLUS))},
			"IFT_ATM":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ATM))},
			"IFT_CEPT":                      {"untyped int", constant.MakeInt64(int64(q.IFT_CEPT))},
			"IFT_DS3":                       {"untyped int", constant.MakeInt64(int64(q.IFT_DS3))},
			"IFT_EON":                       {"untyped int", constant.MakeInt64(int64(q.IFT_EON))},
			"IFT_ETHER":                     {"untyped int", constant.MakeInt64(int64(q.IFT_ETHER))},
			"IFT_FDDI":                      {"untyped int", constant.MakeInt64(int64(q.IFT_FDDI))},
			"IFT_FRELAY":                    {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAY))},
			"IFT_FRELAYDCE":                 {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAYDCE))},
			"IFT_HDH1822":                   {"untyped int", constant.MakeInt64(int64(q.IFT_HDH1822))},
			"IFT_HIPPI":                     {"untyped int", constant.MakeInt64(int64(q.IFT_HIPPI))},
			"IFT_HSSI":                      {"untyped int", constant.MakeInt64(int64(q.IFT_HSSI))},
			"IFT_HY":                        {"untyped int", constant.MakeInt64(int64(q.IFT_HY))},
			"IFT_IB":                        {"untyped int", constant.MakeInt64(int64(q.IFT_IB))},
			"IFT_IPV4":                      {"untyped int", constant.MakeInt64(int64(q.IFT_IPV4))},
			"IFT_IPV6":                      {"untyped int", constant.MakeInt64(int64(q.IFT_IPV6))},
			"IFT_ISDNBASIC":                 {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNBASIC))},
			"IFT_ISDNPRIMARY":               {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNPRIMARY))},
			"IFT_ISO88022LLC":               {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88022LLC))},
			"IFT_ISO88023":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88023))},
			"IFT_ISO88024":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88024))},
			"IFT_ISO88025":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025))},
			"IFT_ISO88026":                  {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88026))},
			"IFT_LAPB":                      {"untyped int", constant.MakeInt64(int64(q.IFT_LAPB))},
			"IFT_LOCALTALK":                 {"untyped int", constant.MakeInt64(int64(q.IFT_LOCALTALK))},
			"IFT_LOOP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_LOOP))},
			"IFT_MIOX25":                    {"untyped int", constant.MakeInt64(int64(q.IFT_MIOX25))},
			"IFT_MODEM":                     {"untyped int", constant.MakeInt64(int64(q.IFT_MODEM))},
			"IFT_NSIP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_NSIP))},
			"IFT_OTHER":                     {"untyped int", constant.MakeInt64(int64(q.IFT_OTHER))},
			"IFT_P10":                       {"untyped int", constant.MakeInt64(int64(q.IFT_P10))},
			"IFT_P80":                       {"untyped int", constant.MakeInt64(int64(q.IFT_P80))},
			"IFT_PARA":                      {"untyped int", constant.MakeInt64(int64(q.IFT_PARA))},
			"IFT_PPP":                       {"untyped int", constant.MakeInt64(int64(q.IFT_PPP))},
			"IFT_PROPMUX":                   {"untyped int", constant.MakeInt64(int64(q.IFT_PROPMUX))},
			"IFT_PROPVIRTUAL":               {"untyped int", constant.MakeInt64(int64(q.IFT_PROPVIRTUAL))},
			"IFT_PTPSERIAL":                 {"untyped int", constant.MakeInt64(int64(q.IFT_PTPSERIAL))},
			"IFT_RS232":                     {"untyped int", constant.MakeInt64(int64(q.IFT_RS232))},
			"IFT_SDLC":                      {"untyped int", constant.MakeInt64(int64(q.IFT_SDLC))},
			"IFT_SIP":                       {"untyped int", constant.MakeInt64(int64(q.IFT_SIP))},
			"IFT_SLIP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_SLIP))},
			"IFT_SMDSDXI":                   {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSDXI))},
			"IFT_SMDSICIP":                  {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSICIP))},
			"IFT_SONET":                     {"untyped int", constant.MakeInt64(int64(q.IFT_SONET))},
			"IFT_SONETPATH":                 {"untyped int", constant.MakeInt64(int64(q.IFT_SONETPATH))},
			"IFT_SONETVT":                   {"untyped int", constant.MakeInt64(int64(q.IFT_SONETVT))},
			"IFT_STARLAN":                   {"untyped int", constant.MakeInt64(int64(q.IFT_STARLAN))},
			"IFT_T1":                        {"untyped int", constant.MakeInt64(int64(q.IFT_T1))},
			"IFT_ULTRA":                     {"untyped int", constant.MakeInt64(int64(q.IFT_ULTRA))},
			"IFT_V35":                       {"untyped int", constant.MakeInt64(int64(q.IFT_V35))},
			"IFT_X25":                       {"untyped int", constant.MakeInt64(int64(q.IFT_X25))},
			"IFT_X25DDN":                    {"untyped int", constant.MakeInt64(int64(q.IFT_X25DDN))},
			"IFT_X25PLE":                    {"untyped int", constant.MakeInt64(int64(q.IFT_X25PLE))},
			"IFT_XETHER":                    {"untyped int", constant.MakeInt64(int64(q.IFT_XETHER))},
			"IGNBRK":                        {"untyped int", constant.MakeInt64(int64(q.IGNBRK))},
			"IGNCR":                         {"untyped int", constant.MakeInt64(int64(q.IGNCR))},
			"IGNPAR":                        {"untyped int", constant.MakeInt64(int64(q.IGNPAR))},
			"IMAXBEL":                       {"untyped int", constant.MakeInt64(int64(q.IMAXBEL))},
			"INLCR":                         {"untyped int", constant.MakeInt64(int64(q.INLCR))},
			"INPCK":                         {"untyped int", constant.MakeInt64(int64(q.INPCK))},
			"IN_AUTOCONF_MASK":              {"untyped int", constant.MakeInt64(int64(q.IN_AUTOCONF_MASK))},
			"IN_AUTOCONF_NET":               {"untyped int", constant.MakeInt64(int64(q.IN_AUTOCONF_NET))},
			"IN_CLASSA_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_HOST))},
			"IN_CLASSA_MAX":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_MAX))},
			"IN_CLASSA_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NET))},
			"IN_CLASSA_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NSHIFT))},
			"IN_CLASSB_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_HOST))},
			"IN_CLASSB_MAX":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_MAX))},
			"IN_CLASSB_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NET))},
			"IN_CLASSB_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NSHIFT))},
			"IN_CLASSC_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_HOST))},
			"IN_CLASSC_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NET))},
			"IN_CLASSC_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NSHIFT))},
			"IN_CLASSD_HOST":                {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_HOST))},
			"IN_CLASSD_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NET))},
			"IN_CLASSD_NSHIFT":              {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NSHIFT))},
			"IN_CLASSE_NET":                 {"untyped int", constant.MakeInt64(int64(q.IN_CLASSE_NET))},
			"IN_LOOPBACKNET":                {"untyped int", constant.MakeInt64(int64(q.IN_LOOPBACKNET))},
			"IN_PRIVATE12_MASK":             {"untyped int", constant.MakeInt64(int64(q.IN_PRIVATE12_MASK))},
			"IN_PRIVATE12_NET":              {"untyped int", constant.MakeInt64(int64(q.IN_PRIVATE12_NET))},
			"IN_PRIVATE16_MASK":             {"untyped int", constant.MakeInt64(int64(q.IN_PRIVATE16_MASK))},
			"IN_PRIVATE16_NET":              {"untyped int", constant.MakeInt64(int64(q.IN_PRIVATE16_NET))},
			"IN_PRIVATE8_MASK":              {"untyped int", constant.MakeInt64(int64(q.IN_PRIVATE8_MASK))},
			"IN_PRIVATE8_NET":               {"untyped int", constant.MakeInt64(int64(q.IN_PRIVATE8_NET))},
			"IPPROTO_AH":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AH))},
			"IPPROTO_DSTOPTS":               {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DSTOPTS))},
			"IPPROTO_EGP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EGP))},
			"IPPROTO_ENCAP":                 {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ENCAP))},
			"IPPROTO_EON":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EON))},
			"IPPROTO_ESP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ESP))},
			"IPPROTO_FRAGMENT":              {"untyped int", constant.MakeInt64(int64(q.IPPROTO_FRAGMENT))},
			"IPPROTO_GGP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GGP))},
			"IPPROTO_HELLO":                 {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HELLO))},
			"IPPROTO_HOPOPTS":               {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HOPOPTS))},
			"IPPROTO_ICMP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMP))},
			"IPPROTO_ICMPV6":                {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMPV6))},
			"IPPROTO_IDP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDP))},
			"IPPROTO_IGMP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGMP))},
			"IPPROTO_IP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IP))},
			"IPPROTO_IPV6":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV6))},
			"IPPROTO_MAX":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAX))},
			"IPPROTO_ND":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ND))},
			"IPPROTO_NONE":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NONE))},
			"IPPROTO_OSPF":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_OSPF))},
			"IPPROTO_PIM":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PIM))},
			"IPPROTO_PUP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PUP))},
			"IPPROTO_RAW":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RAW))},
			"IPPROTO_ROUTING":               {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ROUTING))},
			"IPPROTO_RSVP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RSVP))},
			"IPPROTO_SCTP":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SCTP))},
			"IPPROTO_TCP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCP))},
			"IPPROTO_UDP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDP))},
			"IPV6_ADD_MEMBERSHIP":           {"untyped int", constant.MakeInt64(int64(q.IPV6_ADD_MEMBERSHIP))},
			"IPV6_BOUND_IF":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_BOUND_IF))},
			"IPV6_CHECKSUM":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_CHECKSUM))},
			"IPV6_DONTFRAG":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_DONTFRAG))},
			"IPV6_DROP_MEMBERSHIP":          {"untyped int", constant.MakeInt64(int64(q.IPV6_DROP_MEMBERSHIP))},
			"IPV6_DSTOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_DSTOPTS))},
			"IPV6_FLOWINFO_FLOWLABEL":       {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_FLOWLABEL))},
			"IPV6_FLOWINFO_TCLASS":          {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_TCLASS))},
			"IPV6_HOPLIMIT":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPLIMIT))},
			"IPV6_HOPOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPOPTS))},
			"IPV6_JOIN_GROUP":               {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_GROUP))},
			"IPV6_LEAVE_GROUP":              {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_GROUP))},
			"IPV6_MULTICAST_HOPS":           {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_HOPS))},
			"IPV6_MULTICAST_IF":             {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_IF))},
			"IPV6_MULTICAST_LOOP":           {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_LOOP))},
			"IPV6_NEXTHOP":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_NEXTHOP))},
			"IPV6_PAD1_OPT":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_PAD1_OPT))},
			"IPV6_PATHMTU":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_PATHMTU))},
			"IPV6_PKTINFO":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_PKTINFO))},
			"IPV6_PREFER_SRC_CGA":           {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_CGA))},
			"IPV6_PREFER_SRC_CGADEFAULT":    {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_CGADEFAULT))},
			"IPV6_PREFER_SRC_CGAMASK":       {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_CGAMASK))},
			"IPV6_PREFER_SRC_COA":           {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_COA))},
			"IPV6_PREFER_SRC_DEFAULT":       {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_DEFAULT))},
			"IPV6_PREFER_SRC_HOME":          {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_HOME))},
			"IPV6_PREFER_SRC_MASK":          {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_MASK))},
			"IPV6_PREFER_SRC_MIPDEFAULT":    {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_MIPDEFAULT))},
			"IPV6_PREFER_SRC_MIPMASK":       {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_MIPMASK))},
			"IPV6_PREFER_SRC_NONCGA":        {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_NONCGA))},
			"IPV6_PREFER_SRC_PUBLIC":        {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_PUBLIC))},
			"IPV6_PREFER_SRC_TMP":           {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_TMP))},
			"IPV6_PREFER_SRC_TMPDEFAULT":    {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_TMPDEFAULT))},
			"IPV6_PREFER_SRC_TMPMASK":       {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_SRC_TMPMASK))},
			"IPV6_RECVDSTOPTS":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVDSTOPTS))},
			"IPV6_RECVHOPLIMIT":             {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPLIMIT))},
			"IPV6_RECVHOPOPTS":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPOPTS))},
			"IPV6_RECVPATHMTU":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPATHMTU))},
			"IPV6_RECVPKTINFO":              {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPKTINFO))},
			"IPV6_RECVRTHDR":                {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVRTHDR))},
			"IPV6_RECVRTHDRDSTOPTS":         {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVRTHDRDSTOPTS))},
			"IPV6_RECVTCLASS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVTCLASS))},
			"IPV6_RTHDR":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR))},
			"IPV6_RTHDRDSTOPTS":             {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDRDSTOPTS))},
			"IPV6_RTHDR_TYPE_0":             {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_TYPE_0))},
			"IPV6_SEC_OPT":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_SEC_OPT))},
			"IPV6_SRC_PREFERENCES":          {"untyped int", constant.MakeInt64(int64(q.IPV6_SRC_PREFERENCES))},
			"IPV6_TCLASS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_TCLASS))},
			"IPV6_UNICAST_HOPS":             {"untyped int", constant.MakeInt64(int64(q.IPV6_UNICAST_HOPS))},
			"IPV6_UNSPEC_SRC":               {"untyped int", constant.MakeInt64(int64(q.IPV6_UNSPEC_SRC))},
			"IPV6_USE_MIN_MTU":              {"untyped int", constant.MakeInt64(int64(q.IPV6_USE_MIN_MTU))},
			"IPV6_V6ONLY":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_V6ONLY))},
			"IP_ADD_MEMBERSHIP":             {"untyped int", constant.MakeInt64(int64(q.IP_ADD_MEMBERSHIP))},
			"IP_ADD_SOURCE_MEMBERSHIP":      {"untyped int", constant.MakeInt64(int64(q.IP_ADD_SOURCE_MEMBERSHIP))},
			"IP_BLOCK_SOURCE":               {"untyped int", constant.MakeInt64(int64(q.IP_BLOCK_SOURCE))},
			"IP_BOUND_IF":                   {"untyped int", constant.MakeInt64(int64(q.IP_BOUND_IF))},
			"IP_BROADCAST":                  {"untyped int", constant.MakeInt64(int64(q.IP_BROADCAST))},
			"IP_BROADCAST_TTL":              {"untyped int", constant.MakeInt64(int64(q.IP_BROADCAST_TTL))},
			"IP_DEFAULT_MULTICAST_LOOP":     {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_LOOP))},
			"IP_DEFAULT_MULTICAST_TTL":      {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_TTL))},
			"IP_DF":                         {"untyped int", constant.MakeInt64(int64(q.IP_DF))},
			"IP_DHCPINIT_IF":                {"untyped int", constant.MakeInt64(int64(q.IP_DHCPINIT_IF))},
			"IP_DONTFRAG":                   {"untyped int", constant.MakeInt64(int64(q.IP_DONTFRAG))},
			"IP_DONTROUTE":                  {"untyped int", constant.MakeInt64(int64(q.IP_DONTROUTE))},
			"IP_DROP_MEMBERSHIP":            {"untyped int", constant.MakeInt64(int64(q.IP_DROP_MEMBERSHIP))},
			"IP_DROP_SOURCE_MEMBERSHIP":     {"untyped int", constant.MakeInt64(int64(q.IP_DROP_SOURCE_MEMBERSHIP))},
			"IP_HDRINCL":                    {"untyped int", constant.MakeInt64(int64(q.IP_HDRINCL))},
			"IP_MAXPACKET":                  {"untyped int", constant.MakeInt64(int64(q.IP_MAXPACKET))},
			"IP_MF":                         {"untyped int", constant.MakeInt64(int64(q.IP_MF))},
			"IP_MSS":                        {"untyped int", constant.MakeInt64(int64(q.IP_MSS))},
			"IP_MULTICAST_IF":               {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IF))},
			"IP_MULTICAST_LOOP":             {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_LOOP))},
			"IP_MULTICAST_TTL":              {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_TTL))},
			"IP_NEXTHOP":                    {"untyped int", constant.MakeInt64(int64(q.IP_NEXTHOP))},
			"IP_OPTIONS":                    {"untyped int", constant.MakeInt64(int64(q.IP_OPTIONS))},
			"IP_PKTINFO":                    {"untyped int", constant.MakeInt64(int64(q.IP_PKTINFO))},
			"IP_RECVDSTADDR":                {"untyped int", constant.MakeInt64(int64(q.IP_RECVDSTADDR))},
			"IP_RECVIF":                     {"untyped int", constant.MakeInt64(int64(q.IP_RECVIF))},
			"IP_RECVOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IP_RECVOPTS))},
			"IP_RECVPKTINFO":                {"untyped int", constant.MakeInt64(int64(q.IP_RECVPKTINFO))},
			"IP_RECVRETOPTS":                {"untyped int", constant.MakeInt64(int64(q.IP_RECVRETOPTS))},
			"IP_RECVSLLA":                   {"untyped int", constant.MakeInt64(int64(q.IP_RECVSLLA))},
			"IP_RECVTTL":                    {"untyped int", constant.MakeInt64(int64(q.IP_RECVTTL))},
			"IP_RETOPTS":                    {"untyped int", constant.MakeInt64(int64(q.IP_RETOPTS))},
			"IP_REUSEADDR":                  {"untyped int", constant.MakeInt64(int64(q.IP_REUSEADDR))},
			"IP_SEC_OPT":                    {"untyped int", constant.MakeInt64(int64(q.IP_SEC_OPT))},
			"IP_TOS":                        {"untyped int", constant.MakeInt64(int64(q.IP_TOS))},
			"IP_TTL":                        {"untyped int", constant.MakeInt64(int64(q.IP_TTL))},
			"IP_UNBLOCK_SOURCE":             {"untyped int", constant.MakeInt64(int64(q.IP_UNBLOCK_SOURCE))},
			"IP_UNSPEC_SRC":                 {"untyped int", constant.MakeInt64(int64(q.IP_UNSPEC_SRC))},
			"ISIG":                          {"untyped int", constant.MakeInt64(int64(q.ISIG))},
			"ISTRIP":                        {"untyped int", constant.MakeInt64(int64(q.ISTRIP))},
			"IXANY":                         {"untyped int", constant.MakeInt64(int64(q.IXANY))},
			"IXOFF":                         {"untyped int", constant.MakeInt64(int64(q.IXOFF))},
			"IXON":                          {"untyped int", constant.MakeInt64(int64(q.IXON))},
			"ImplementsGetwd":               {"untyped bool", constant.MakeBool(bool(q.ImplementsGetwd))},
			"LOCK_EX":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_EX))},
			"LOCK_NB":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_NB))},
			"LOCK_SH":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_SH))},
			"LOCK_UN":                       {"untyped int", constant.MakeInt64(int64(q.LOCK_UN))},
			"MADV_ACCESS_DEFAULT":           {"untyped int", constant.MakeInt64(int64(q.MADV_ACCESS_DEFAULT))},
			"MADV_ACCESS_LWP":               {"untyped int", constant.MakeInt64(int64(q.MADV_ACCESS_LWP))},
			"MADV_ACCESS_MANY":              {"untyped int", constant.MakeInt64(int64(q.MADV_ACCESS_MANY))},
			"MADV_DONTNEED":                 {"untyped int", constant.MakeInt64(int64(q.MADV_DONTNEED))},
			"MADV_FREE":                     {"untyped int", constant.MakeInt64(int64(q.MADV_FREE))},
			"MADV_NORMAL":                   {"untyped int", constant.MakeInt64(int64(q.MADV_NORMAL))},
			"MADV_RANDOM":                   {"untyped int", constant.MakeInt64(int64(q.MADV_RANDOM))},
			"MADV_SEQUENTIAL":               {"untyped int", constant.MakeInt64(int64(q.MADV_SEQUENTIAL))},
			"MADV_WILLNEED":                 {"untyped int", constant.MakeInt64(int64(q.MADV_WILLNEED))},
			"MAP_32BIT":                     {"untyped int", constant.MakeInt64(int64(q.MAP_32BIT))},
			"MAP_ALIGN":                     {"untyped int", constant.MakeInt64(int64(q.MAP_ALIGN))},
			"MAP_ANON":                      {"untyped int", constant.MakeInt64(int64(q.MAP_ANON))},
			"MAP_ANONYMOUS":                 {"untyped int", constant.MakeInt64(int64(q.MAP_ANONYMOUS))},
			"MAP_FIXED":                     {"untyped int", constant.MakeInt64(int64(q.MAP_FIXED))},
			"MAP_INITDATA":                  {"untyped int", constant.MakeInt64(int64(q.MAP_INITDATA))},
			"MAP_NORESERVE":                 {"untyped int", constant.MakeInt64(int64(q.MAP_NORESERVE))},
			"MAP_PRIVATE":                   {"untyped int", constant.MakeInt64(int64(q.MAP_PRIVATE))},
			"MAP_RENAME":                    {"untyped int", constant.MakeInt64(int64(q.MAP_RENAME))},
			"MAP_SHARED":                    {"untyped int", constant.MakeInt64(int64(q.MAP_SHARED))},
			"MAP_TEXT":                      {"untyped int", constant.MakeInt64(int64(q.MAP_TEXT))},
			"MAP_TYPE":                      {"untyped int", constant.MakeInt64(int64(q.MAP_TYPE))},
			"MCL_CURRENT":                   {"untyped int", constant.MakeInt64(int64(q.MCL_CURRENT))},
			"MCL_FUTURE":                    {"untyped int", constant.MakeInt64(int64(q.MCL_FUTURE))},
			"MSG_CTRUNC":                    {"untyped int", constant.MakeInt64(int64(q.MSG_CTRUNC))},
			"MSG_DONTROUTE":                 {"untyped int", constant.MakeInt64(int64(q.MSG_DONTROUTE))},
			"MSG_DONTWAIT":                  {"untyped int", constant.MakeInt64(int64(q.MSG_DONTWAIT))},
			"MSG_DUPCTRL":                   {"untyped int", constant.MakeInt64(int64(q.MSG_DUPCTRL))},
			"MSG_EOR":                       {"untyped int", constant.MakeInt64(int64(q.MSG_EOR))},
			"MSG_MAXIOVLEN":                 {"untyped int", constant.MakeInt64(int64(q.MSG_MAXIOVLEN))},
			"MSG_NOTIFICATION":              {"untyped int", constant.MakeInt64(int64(q.MSG_NOTIFICATION))},
			"MSG_OOB":                       {"untyped int", constant.MakeInt64(int64(q.MSG_OOB))},
			"MSG_PEEK":                      {"untyped int", constant.MakeInt64(int64(q.MSG_PEEK))},
			"MSG_TRUNC":                     {"untyped int", constant.MakeInt64(int64(q.MSG_TRUNC))},
			"MSG_WAITALL":                   {"untyped int", constant.MakeInt64(int64(q.MSG_WAITALL))},
			"MSG_XPG4_2":                    {"untyped int", constant.MakeInt64(int64(q.MSG_XPG4_2))},
			"MS_ASYNC":                      {"untyped int", constant.MakeInt64(int64(q.MS_ASYNC))},
			"MS_INVALIDATE":                 {"untyped int", constant.MakeInt64(int64(q.MS_INVALIDATE))},
			"MS_OLDSYNC":                    {"untyped int", constant.MakeInt64(int64(q.MS_OLDSYNC))},
			"MS_SYNC":                       {"untyped int", constant.MakeInt64(int64(q.MS_SYNC))},
			"M_FLUSH":                       {"untyped int", constant.MakeInt64(int64(q.M_FLUSH))},
			"NOFLSH":                        {"untyped int", constant.MakeInt64(int64(q.NOFLSH))},
			"OCRNL":                         {"untyped int", constant.MakeInt64(int64(q.OCRNL))},
			"OFDEL":                         {"untyped int", constant.MakeInt64(int64(q.OFDEL))},
			"OFILL":                         {"untyped int", constant.MakeInt64(int64(q.OFILL))},
			"ONLCR":                         {"untyped int", constant.MakeInt64(int64(q.ONLCR))},
			"ONLRET":                        {"untyped int", constant.MakeInt64(int64(q.ONLRET))},
			"ONOCR":                         {"untyped int", constant.MakeInt64(int64(q.ONOCR))},
			"OPENFAIL":                      {"untyped int", constant.MakeInt64(int64(q.OPENFAIL))},
			"OPOST":                         {"untyped int", constant.MakeInt64(int64(q.OPOST))},
			"O_ACCMODE":                     {"untyped int", constant.MakeInt64(int64(q.O_ACCMODE))},
			"O_APPEND":                      {"untyped int", constant.MakeInt64(int64(q.O_APPEND))},
			"O_CLOEXEC":                     {"untyped int", constant.MakeInt64(int64(q.O_CLOEXEC))},
			"O_CREAT":                       {"untyped int", constant.MakeInt64(int64(q.O_CREAT))},
			"O_DSYNC":                       {"untyped int", constant.MakeInt64(int64(q.O_DSYNC))},
			"O_EXCL":                        {"untyped int", constant.MakeInt64(int64(q.O_EXCL))},
			"O_EXEC":                        {"untyped int", constant.MakeInt64(int64(q.O_EXEC))},
			"O_LARGEFILE":                   {"untyped int", constant.MakeInt64(int64(q.O_LARGEFILE))},
			"O_NDELAY":                      {"untyped int", constant.MakeInt64(int64(q.O_NDELAY))},
			"O_NOCTTY":                      {"untyped int", constant.MakeInt64(int64(q.O_NOCTTY))},
			"O_NOFOLLOW":                    {"untyped int", constant.MakeInt64(int64(q.O_NOFOLLOW))},
			"O_NOLINKS":                     {"untyped int", constant.MakeInt64(int64(q.O_NOLINKS))},
			"O_NONBLOCK":                    {"untyped int", constant.MakeInt64(int64(q.O_NONBLOCK))},
			"O_RDONLY":                      {"untyped int", constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":                        {"untyped int", constant.MakeInt64(int64(q.O_RDWR))},
			"O_RSYNC":                       {"untyped int", constant.MakeInt64(int64(q.O_RSYNC))},
			"O_SEARCH":                      {"untyped int", constant.MakeInt64(int64(q.O_SEARCH))},
			"O_SIOCGIFCONF":                 {"untyped int", constant.MakeInt64(int64(q.O_SIOCGIFCONF))},
			"O_SIOCGLIFCONF":                {"untyped int", constant.MakeInt64(int64(q.O_SIOCGLIFCONF))},
			"O_SYNC":                        {"untyped int", constant.MakeInt64(int64(q.O_SYNC))},
			"O_TRUNC":                       {"untyped int", constant.MakeInt64(int64(q.O_TRUNC))},
			"O_WRONLY":                      {"untyped int", constant.MakeInt64(int64(q.O_WRONLY))},
			"O_XATTR":                       {"untyped int", constant.MakeInt64(int64(q.O_XATTR))},
			"PARENB":                        {"untyped int", constant.MakeInt64(int64(q.PARENB))},
			"PAREXT":                        {"untyped int", constant.MakeInt64(int64(q.PAREXT))},
			"PARMRK":                        {"untyped int", constant.MakeInt64(int64(q.PARMRK))},
			"PARODD":                        {"untyped int", constant.MakeInt64(int64(q.PARODD))},
			"PENDIN":                        {"untyped int", constant.MakeInt64(int64(q.PENDIN))},
			"PRIO_PGRP":                     {"untyped int", constant.MakeInt64(int64(q.PRIO_PGRP))},
			"PRIO_PROCESS":                  {"untyped int", constant.MakeInt64(int64(q.PRIO_PROCESS))},
			"PRIO_USER":                     {"untyped int", constant.MakeInt64(int64(q.PRIO_USER))},
			"PROT_EXEC":                     {"untyped int", constant.MakeInt64(int64(q.PROT_EXEC))},
			"PROT_NONE":                     {"untyped int", constant.MakeInt64(int64(q.PROT_NONE))},
			"PROT_READ":                     {"untyped int", constant.MakeInt64(int64(q.PROT_READ))},
			"PROT_WRITE":                    {"untyped int", constant.MakeInt64(int64(q.PROT_WRITE))},
			"PathMax":                       {"untyped int", constant.MakeInt64(int64(q.PathMax))},
			"RLIMIT_AS":                     {"untyped int", constant.MakeInt64(int64(q.RLIMIT_AS))},
			"RLIMIT_CORE":                   {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CORE))},
			"RLIMIT_CPU":                    {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CPU))},
			"RLIMIT_DATA":                   {"untyped int", constant.MakeInt64(int64(q.RLIMIT_DATA))},
			"RLIMIT_FSIZE":                  {"untyped int", constant.MakeInt64(int64(q.RLIMIT_FSIZE))},
			"RLIMIT_NOFILE":                 {"untyped int", constant.MakeInt64(int64(q.RLIMIT_NOFILE))},
			"RLIMIT_STACK":                  {"untyped int", constant.MakeInt64(int64(q.RLIMIT_STACK))},
			"RLIM_INFINITY":                 {"untyped int", constant.MakeInt64(int64(q.RLIM_INFINITY))},
			"RTAX_AUTHOR":                   {"untyped int", constant.MakeInt64(int64(q.RTAX_AUTHOR))},
			"RTAX_BRD":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_BRD))},
			"RTAX_DST":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_DST))},
			"RTAX_GATEWAY":                  {"untyped int", constant.MakeInt64(int64(q.RTAX_GATEWAY))},
			"RTAX_GENMASK":                  {"untyped int", constant.MakeInt64(int64(q.RTAX_GENMASK))},
			"RTAX_IFA":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_IFA))},
			"RTAX_IFP":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_IFP))},
			"RTAX_MAX":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_MAX))},
			"RTAX_NETMASK":                  {"untyped int", constant.MakeInt64(int64(q.RTAX_NETMASK))},
			"RTAX_SRC":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_SRC))},
			"RTA_AUTHOR":                    {"untyped int", constant.MakeInt64(int64(q.RTA_AUTHOR))},
			"RTA_BRD":                       {"untyped int", constant.MakeInt64(int64(q.RTA_BRD))},
			"RTA_DST":                       {"untyped int", constant.MakeInt64(int64(q.RTA_DST))},
			"RTA_GATEWAY":                   {"untyped int", constant.MakeInt64(int64(q.RTA_GATEWAY))},
			"RTA_GENMASK":                   {"untyped int", constant.MakeInt64(int64(q.RTA_GENMASK))},
			"RTA_IFA":                       {"untyped int", constant.MakeInt64(int64(q.RTA_IFA))},
			"RTA_IFP":                       {"untyped int", constant.MakeInt64(int64(q.RTA_IFP))},
			"RTA_NETMASK":                   {"untyped int", constant.MakeInt64(int64(q.RTA_NETMASK))},
			"RTA_NUMBITS":                   {"untyped int", constant.MakeInt64(int64(q.RTA_NUMBITS))},
			"RTA_SRC":                       {"untyped int", constant.MakeInt64(int64(q.RTA_SRC))},
			"RTF_BLACKHOLE":                 {"untyped int", constant.MakeInt64(int64(q.RTF_BLACKHOLE))},
			"RTF_CLONING":                   {"untyped int", constant.MakeInt64(int64(q.RTF_CLONING))},
			"RTF_DONE":                      {"untyped int", constant.MakeInt64(int64(q.RTF_DONE))},
			"RTF_DYNAMIC":                   {"untyped int", constant.MakeInt64(int64(q.RTF_DYNAMIC))},
			"RTF_GATEWAY":                   {"untyped int", constant.MakeInt64(int64(q.RTF_GATEWAY))},
			"RTF_HOST":                      {"untyped int", constant.MakeInt64(int64(q.RTF_HOST))},
			"RTF_INDIRECT":                  {"untyped int", constant.MakeInt64(int64(q.RTF_INDIRECT))},
			"RTF_KERNEL":                    {"untyped int", constant.MakeInt64(int64(q.RTF_KERNEL))},
			"RTF_LLINFO":                    {"untyped int", constant.MakeInt64(int64(q.RTF_LLINFO))},
			"RTF_MASK":                      {"untyped int", constant.MakeInt64(int64(q.RTF_MASK))},
			"RTF_MODIFIED":                  {"untyped int", constant.MakeInt64(int64(q.RTF_MODIFIED))},
			"RTF_MULTIRT":                   {"untyped int", constant.MakeInt64(int64(q.RTF_MULTIRT))},
			"RTF_PRIVATE":                   {"untyped int", constant.MakeInt64(int64(q.RTF_PRIVATE))},
			"RTF_PROTO1":                    {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO1))},
			"RTF_PROTO2":                    {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO2))},
			"RTF_REJECT":                    {"untyped int", constant.MakeInt64(int64(q.RTF_REJECT))},
			"RTF_SETSRC":                    {"untyped int", constant.MakeInt64(int64(q.RTF_SETSRC))},
			"RTF_STATIC":                    {"untyped int", constant.MakeInt64(int64(q.RTF_STATIC))},
			"RTF_UP":                        {"untyped int", constant.MakeInt64(int64(q.RTF_UP))},
			"RTF_XRESOLVE":                  {"untyped int", constant.MakeInt64(int64(q.RTF_XRESOLVE))},
			"RTF_ZONE":                      {"untyped int", constant.MakeInt64(int64(q.RTF_ZONE))},
			"RTM_ADD":                       {"untyped int", constant.MakeInt64(int64(q.RTM_ADD))},
			"RTM_CHANGE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_CHANGE))},
			"RTM_CHGADDR":                   {"untyped int", constant.MakeInt64(int64(q.RTM_CHGADDR))},
			"RTM_DELADDR":                   {"untyped int", constant.MakeInt64(int64(q.RTM_DELADDR))},
			"RTM_DELETE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_DELETE))},
			"RTM_FREEADDR":                  {"untyped int", constant.MakeInt64(int64(q.RTM_FREEADDR))},
			"RTM_GET":                       {"untyped int", constant.MakeInt64(int64(q.RTM_GET))},
			"RTM_IFINFO":                    {"untyped int", constant.MakeInt64(int64(q.RTM_IFINFO))},
			"RTM_LOCK":                      {"untyped int", constant.MakeInt64(int64(q.RTM_LOCK))},
			"RTM_LOSING":                    {"untyped int", constant.MakeInt64(int64(q.RTM_LOSING))},
			"RTM_MISS":                      {"untyped int", constant.MakeInt64(int64(q.RTM_MISS))},
			"RTM_NEWADDR":                   {"untyped int", constant.MakeInt64(int64(q.RTM_NEWADDR))},
			"RTM_OLDADD":                    {"untyped int", constant.MakeInt64(int64(q.RTM_OLDADD))},
			"RTM_OLDDEL":                    {"untyped int", constant.MakeInt64(int64(q.RTM_OLDDEL))},
			"RTM_REDIRECT":                  {"untyped int", constant.MakeInt64(int64(q.RTM_REDIRECT))},
			"RTM_RESOLVE":                   {"untyped int", constant.MakeInt64(int64(q.RTM_RESOLVE))},
			"RTM_VERSION":                   {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION))},
			"RTV_EXPIRE":                    {"untyped int", constant.MakeInt64(int64(q.RTV_EXPIRE))},
			"RTV_HOPCOUNT":                  {"untyped int", constant.MakeInt64(int64(q.RTV_HOPCOUNT))},
			"RTV_MTU":                       {"untyped int", constant.MakeInt64(int64(q.RTV_MTU))},
			"RTV_RPIPE":                     {"untyped int", constant.MakeInt64(int64(q.RTV_RPIPE))},
			"RTV_RTT":                       {"untyped int", constant.MakeInt64(int64(q.RTV_RTT))},
			"RTV_RTTVAR":                    {"untyped int", constant.MakeInt64(int64(q.RTV_RTTVAR))},
			"RTV_SPIPE":                     {"untyped int", constant.MakeInt64(int64(q.RTV_SPIPE))},
			"RTV_SSTHRESH":                  {"untyped int", constant.MakeInt64(int64(q.RTV_SSTHRESH))},
			"RT_AWARE":                      {"untyped int", constant.MakeInt64(int64(q.RT_AWARE))},
			"RUSAGE_CHILDREN":               {"untyped int", constant.MakeInt64(int64(q.RUSAGE_CHILDREN))},
			"RUSAGE_SELF":                   {"untyped int", constant.MakeInt64(int64(q.RUSAGE_SELF))},
			"SCM_RIGHTS":                    {"untyped int", constant.MakeInt64(int64(q.SCM_RIGHTS))},
			"SCM_TIMESTAMP":                 {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMP))},
			"SCM_UCRED":                     {"untyped int", constant.MakeInt64(int64(q.SCM_UCRED))},
			"SHUT_RD":                       {"untyped int", constant.MakeInt64(int64(q.SHUT_RD))},
			"SHUT_RDWR":                     {"untyped int", constant.MakeInt64(int64(q.SHUT_RDWR))},
			"SHUT_WR":                       {"untyped int", constant.MakeInt64(int64(q.SHUT_WR))},
			"SIG2STR_MAX":                   {"untyped int", constant.MakeInt64(int64(q.SIG2STR_MAX))},
			"SIOCADDMULTI":                  {"untyped int", constant.MakeInt64(int64(q.SIOCADDMULTI))},
			"SIOCADDRT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCADDRT))},
			"SIOCATMARK":                    {"untyped int", constant.MakeInt64(int64(q.SIOCATMARK))},
			"SIOCDARP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDARP))},
			"SIOCDELMULTI":                  {"untyped int", constant.MakeInt64(int64(q.SIOCDELMULTI))},
			"SIOCDELRT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCDELRT))},
			"SIOCDIPSECONFIG":               {"untyped int", constant.MakeInt64(int64(q.SIOCDIPSECONFIG))},
			"SIOCDXARP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCDXARP))},
			"SIOCFIPSECONFIG":               {"untyped int", constant.MakeInt64(int64(q.SIOCFIPSECONFIG))},
			"SIOCGARP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGARP))},
			"SIOCGDSTINFO":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGDSTINFO))},
			"SIOCGENADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGENADDR))},
			"SIOCGENPSTATS":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGENPSTATS))},
			"SIOCGETLSGCNT":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGETLSGCNT))},
			"SIOCGETNAME":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGETNAME))},
			"SIOCGETPEER":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGETPEER))},
			"SIOCGETPROP":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGETPROP))},
			"SIOCGETSGCNT":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGETSGCNT))},
			"SIOCGETSYNC":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGETSYNC))},
			"SIOCGETVIFCNT":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGETVIFCNT))},
			"SIOCGHIWAT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGHIWAT))},
			"SIOCGIFADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFADDR))},
			"SIOCGIFBRDADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBRDADDR))},
			"SIOCGIFCONF":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCONF))},
			"SIOCGIFDSTADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDSTADDR))},
			"SIOCGIFFLAGS":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGIFFLAGS))},
			"SIOCGIFHWADDR":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGIFHWADDR))},
			"SIOCGIFINDEX":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGIFINDEX))},
			"SIOCGIFMEM":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMEM))},
			"SIOCGIFMETRIC":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMETRIC))},
			"SIOCGIFMTU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMTU))},
			"SIOCGIFMUXID":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMUXID))},
			"SIOCGIFNETMASK":                {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNETMASK))},
			"SIOCGIFNUM":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNUM))},
			"SIOCGIP6ADDRPOLICY":            {"untyped int", constant.MakeInt64(int64(q.SIOCGIP6ADDRPOLICY))},
			"SIOCGIPMSFILTER":               {"untyped int", constant.MakeInt64(int64(q.SIOCGIPMSFILTER))},
			"SIOCGLIFADDR":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFADDR))},
			"SIOCGLIFBINDING":               {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFBINDING))},
			"SIOCGLIFBRDADDR":               {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFBRDADDR))},
			"SIOCGLIFCONF":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFCONF))},
			"SIOCGLIFDADSTATE":              {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFDADSTATE))},
			"SIOCGLIFDSTADDR":               {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFDSTADDR))},
			"SIOCGLIFFLAGS":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFFLAGS))},
			"SIOCGLIFGROUPINFO":             {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFGROUPINFO))},
			"SIOCGLIFGROUPNAME":             {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFGROUPNAME))},
			"SIOCGLIFHWADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFHWADDR))},
			"SIOCGLIFINDEX":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFINDEX))},
			"SIOCGLIFLNKINFO":               {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFLNKINFO))},
			"SIOCGLIFMETRIC":                {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFMETRIC))},
			"SIOCGLIFMTU":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFMTU))},
			"SIOCGLIFMUXID":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFMUXID))},
			"SIOCGLIFNETMASK":               {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFNETMASK))},
			"SIOCGLIFNUM":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFNUM))},
			"SIOCGLIFSRCOF":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFSRCOF))},
			"SIOCGLIFSUBNET":                {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFSUBNET))},
			"SIOCGLIFTOKEN":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFTOKEN))},
			"SIOCGLIFUSESRC":                {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFUSESRC))},
			"SIOCGLIFZONE":                  {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFZONE))},
			"SIOCGLOWAT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGLOWAT))},
			"SIOCGMSFILTER":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGMSFILTER))},
			"SIOCGPGRP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGPGRP))},
			"SIOCGSTAMP":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGSTAMP))},
			"SIOCGXARP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGXARP))},
			"SIOCIFDETACH":                  {"untyped int", constant.MakeInt64(int64(q.SIOCIFDETACH))},
			"SIOCILB":                       {"untyped int", constant.MakeInt64(int64(q.SIOCILB))},
			"SIOCLIFADDIF":                  {"untyped int", constant.MakeInt64(int64(q.SIOCLIFADDIF))},
			"SIOCLIFDELND":                  {"untyped int", constant.MakeInt64(int64(q.SIOCLIFDELND))},
			"SIOCLIFGETND":                  {"untyped int", constant.MakeInt64(int64(q.SIOCLIFGETND))},
			"SIOCLIFREMOVEIF":               {"untyped int", constant.MakeInt64(int64(q.SIOCLIFREMOVEIF))},
			"SIOCLIFSETND":                  {"untyped int", constant.MakeInt64(int64(q.SIOCLIFSETND))},
			"SIOCLIPSECONFIG":               {"untyped int", constant.MakeInt64(int64(q.SIOCLIPSECONFIG))},
			"SIOCLOWER":                     {"untyped int", constant.MakeInt64(int64(q.SIOCLOWER))},
			"SIOCSARP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSARP))},
			"SIOCSCTPGOPT":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSCTPGOPT))},
			"SIOCSCTPPEELOFF":               {"untyped int", constant.MakeInt64(int64(q.SIOCSCTPPEELOFF))},
			"SIOCSCTPSOPT":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSCTPSOPT))},
			"SIOCSENABLESDP":                {"untyped int", constant.MakeInt64(int64(q.SIOCSENABLESDP))},
			"SIOCSETPROP":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSETPROP))},
			"SIOCSETSYNC":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSETSYNC))},
			"SIOCSHIWAT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSHIWAT))},
			"SIOCSIFADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSIFADDR))},
			"SIOCSIFBRDADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBRDADDR))},
			"SIOCSIFDSTADDR":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFDSTADDR))},
			"SIOCSIFFLAGS":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSIFFLAGS))},
			"SIOCSIFINDEX":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSIFINDEX))},
			"SIOCSIFMEM":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMEM))},
			"SIOCSIFMETRIC":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMETRIC))},
			"SIOCSIFMTU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMTU))},
			"SIOCSIFMUXID":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMUXID))},
			"SIOCSIFNAME":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNAME))},
			"SIOCSIFNETMASK":                {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNETMASK))},
			"SIOCSIP6ADDRPOLICY":            {"untyped int", constant.MakeInt64(int64(q.SIOCSIP6ADDRPOLICY))},
			"SIOCSIPMSFILTER":               {"untyped int", constant.MakeInt64(int64(q.SIOCSIPMSFILTER))},
			"SIOCSIPSECONFIG":               {"untyped int", constant.MakeInt64(int64(q.SIOCSIPSECONFIG))},
			"SIOCSLGETREQ":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSLGETREQ))},
			"SIOCSLIFADDR":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFADDR))},
			"SIOCSLIFBRDADDR":               {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFBRDADDR))},
			"SIOCSLIFDSTADDR":               {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFDSTADDR))},
			"SIOCSLIFFLAGS":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFFLAGS))},
			"SIOCSLIFGROUPNAME":             {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFGROUPNAME))},
			"SIOCSLIFINDEX":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFINDEX))},
			"SIOCSLIFLNKINFO":               {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFLNKINFO))},
			"SIOCSLIFMETRIC":                {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFMETRIC))},
			"SIOCSLIFMTU":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFMTU))},
			"SIOCSLIFMUXID":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFMUXID))},
			"SIOCSLIFNAME":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFNAME))},
			"SIOCSLIFNETMASK":               {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFNETMASK))},
			"SIOCSLIFPREFIX":                {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPREFIX))},
			"SIOCSLIFSUBNET":                {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFSUBNET))},
			"SIOCSLIFTOKEN":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFTOKEN))},
			"SIOCSLIFUSESRC":                {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFUSESRC))},
			"SIOCSLIFZONE":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFZONE))},
			"SIOCSLOWAT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSLOWAT))},
			"SIOCSLSTAT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSLSTAT))},
			"SIOCSMSFILTER":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSMSFILTER))},
			"SIOCSPGRP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSPGRP))},
			"SIOCSPROMISC":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSPROMISC))},
			"SIOCSQPTR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSQPTR))},
			"SIOCSSDSTATS":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSSDSTATS))},
			"SIOCSSESTATS":                  {"untyped int", constant.MakeInt64(int64(q.SIOCSSESTATS))},
			"SIOCSXARP":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSXARP))},
			"SIOCTMYADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCTMYADDR))},
			"SIOCTMYSITE":                   {"untyped int", constant.MakeInt64(int64(q.SIOCTMYSITE))},
			"SIOCTONLINK":                   {"untyped int", constant.MakeInt64(int64(q.SIOCTONLINK))},
			"SIOCUPPER":                     {"untyped int", constant.MakeInt64(int64(q.SIOCUPPER))},
			"SIOCX25RCV":                    {"untyped int", constant.MakeInt64(int64(q.SIOCX25RCV))},
			"SIOCX25TBL":                    {"untyped int", constant.MakeInt64(int64(q.SIOCX25TBL))},
			"SIOCX25XMT":                    {"untyped int", constant.MakeInt64(int64(q.SIOCX25XMT))},
			"SIOCXPROTO":                    {"untyped int", constant.MakeInt64(int64(q.SIOCXPROTO))},
			"SOCK_CLOEXEC":                  {"untyped int", constant.MakeInt64(int64(q.SOCK_CLOEXEC))},
			"SOCK_DGRAM":                    {"untyped int", constant.MakeInt64(int64(q.SOCK_DGRAM))},
			"SOCK_NDELAY":                   {"untyped int", constant.MakeInt64(int64(q.SOCK_NDELAY))},
			"SOCK_NONBLOCK":                 {"untyped int", constant.MakeInt64(int64(q.SOCK_NONBLOCK))},
			"SOCK_RAW":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_RAW))},
			"SOCK_RDM":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_RDM))},
			"SOCK_SEQPACKET":                {"untyped int", constant.MakeInt64(int64(q.SOCK_SEQPACKET))},
			"SOCK_STREAM":                   {"untyped int", constant.MakeInt64(int64(q.SOCK_STREAM))},
			"SOCK_TYPE_MASK":                {"untyped int", constant.MakeInt64(int64(q.SOCK_TYPE_MASK))},
			"SOL_FILTER":                    {"untyped int", constant.MakeInt64(int64(q.SOL_FILTER))},
			"SOL_PACKET":                    {"untyped int", constant.MakeInt64(int64(q.SOL_PACKET))},
			"SOL_ROUTE":                     {"untyped int", constant.MakeInt64(int64(q.SOL_ROUTE))},
			"SOL_SOCKET":                    {"untyped int", constant.MakeInt64(int64(q.SOL_SOCKET))},
			"SOMAXCONN":                     {"untyped int", constant.MakeInt64(int64(q.SOMAXCONN))},
			"SO_ACCEPTCONN":                 {"untyped int", constant.MakeInt64(int64(q.SO_ACCEPTCONN))},
			"SO_ALL":                        {"untyped int", constant.MakeInt64(int64(q.SO_ALL))},
			"SO_ALLZONES":                   {"untyped int", constant.MakeInt64(int64(q.SO_ALLZONES))},
			"SO_ANON_MLP":                   {"untyped int", constant.MakeInt64(int64(q.SO_ANON_MLP))},
			"SO_ATTACH_FILTER":              {"untyped int", constant.MakeInt64(int64(q.SO_ATTACH_FILTER))},
			"SO_BAND":                       {"untyped int", constant.MakeInt64(int64(q.SO_BAND))},
			"SO_BROADCAST":                  {"untyped int", constant.MakeInt64(int64(q.SO_BROADCAST))},
			"SO_COPYOPT":                    {"untyped int", constant.MakeInt64(int64(q.SO_COPYOPT))},
			"SO_DEBUG":                      {"untyped int", constant.MakeInt64(int64(q.SO_DEBUG))},
			"SO_DELIM":                      {"untyped int", constant.MakeInt64(int64(q.SO_DELIM))},
			"SO_DETACH_FILTER":              {"untyped int", constant.MakeInt64(int64(q.SO_DETACH_FILTER))},
			"SO_DGRAM_ERRIND":               {"untyped int", constant.MakeInt64(int64(q.SO_DGRAM_ERRIND))},
			"SO_DOMAIN":                     {"untyped int", constant.MakeInt64(int64(q.SO_DOMAIN))},
			"SO_DONTLINGER":                 {"untyped int", constant.MakeInt64(int64(q.SO_DONTLINGER))},
			"SO_DONTROUTE":                  {"untyped int", constant.MakeInt64(int64(q.SO_DONTROUTE))},
			"SO_ERROPT":                     {"untyped int", constant.MakeInt64(int64(q.SO_ERROPT))},
			"SO_ERROR":                      {"untyped int", constant.MakeInt64(int64(q.SO_ERROR))},
			"SO_EXCLBIND":                   {"untyped int", constant.MakeInt64(int64(q.SO_EXCLBIND))},
			"SO_HIWAT":                      {"untyped int", constant.MakeInt64(int64(q.SO_HIWAT))},
			"SO_ISNTTY":                     {"untyped int", constant.MakeInt64(int64(q.SO_ISNTTY))},
			"SO_ISTTY":                      {"untyped int", constant.MakeInt64(int64(q.SO_ISTTY))},
			"SO_KEEPALIVE":                  {"untyped int", constant.MakeInt64(int64(q.SO_KEEPALIVE))},
			"SO_LINGER":                     {"untyped int", constant.MakeInt64(int64(q.SO_LINGER))},
			"SO_LOWAT":                      {"untyped int", constant.MakeInt64(int64(q.SO_LOWAT))},
			"SO_MAC_EXEMPT":                 {"untyped int", constant.MakeInt64(int64(q.SO_MAC_EXEMPT))},
			"SO_MAC_IMPLICIT":               {"untyped int", constant.MakeInt64(int64(q.SO_MAC_IMPLICIT))},
			"SO_MAXBLK":                     {"untyped int", constant.MakeInt64(int64(q.SO_MAXBLK))},
			"SO_MAXPSZ":                     {"untyped int", constant.MakeInt64(int64(q.SO_MAXPSZ))},
			"SO_MINPSZ":                     {"untyped int", constant.MakeInt64(int64(q.SO_MINPSZ))},
			"SO_MREADOFF":                   {"untyped int", constant.MakeInt64(int64(q.SO_MREADOFF))},
			"SO_MREADON":                    {"untyped int", constant.MakeInt64(int64(q.SO_MREADON))},
			"SO_NDELOFF":                    {"untyped int", constant.MakeInt64(int64(q.SO_NDELOFF))},
			"SO_NDELON":                     {"untyped int", constant.MakeInt64(int64(q.SO_NDELON))},
			"SO_NODELIM":                    {"untyped int", constant.MakeInt64(int64(q.SO_NODELIM))},
			"SO_OOBINLINE":                  {"untyped int", constant.MakeInt64(int64(q.SO_OOBINLINE))},
			"SO_PROTOTYPE":                  {"untyped int", constant.MakeInt64(int64(q.SO_PROTOTYPE))},
			"SO_RCVBUF":                     {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUF))},
			"SO_RCVLOWAT":                   {"untyped int", constant.MakeInt64(int64(q.SO_RCVLOWAT))},
			"SO_RCVPSH":                     {"untyped int", constant.MakeInt64(int64(q.SO_RCVPSH))},
			"SO_RCVTIMEO":                   {"untyped int", constant.MakeInt64(int64(q.SO_RCVTIMEO))},
			"SO_READOPT":                    {"untyped int", constant.MakeInt64(int64(q.SO_READOPT))},
			"SO_RECVUCRED":                  {"untyped int", constant.MakeInt64(int64(q.SO_RECVUCRED))},
			"SO_REUSEADDR":                  {"untyped int", constant.MakeInt64(int64(q.SO_REUSEADDR))},
			"SO_SECATTR":                    {"untyped int", constant.MakeInt64(int64(q.SO_SECATTR))},
			"SO_SNDBUF":                     {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUF))},
			"SO_SNDLOWAT":                   {"untyped int", constant.MakeInt64(int64(q.SO_SNDLOWAT))},
			"SO_SNDTIMEO":                   {"untyped int", constant.MakeInt64(int64(q.SO_SNDTIMEO))},
			"SO_STRHOLD":                    {"untyped int", constant.MakeInt64(int64(q.SO_STRHOLD))},
			"SO_TAIL":                       {"untyped int", constant.MakeInt64(int64(q.SO_TAIL))},
			"SO_TIMESTAMP":                  {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMP))},
			"SO_TONSTOP":                    {"untyped int", constant.MakeInt64(int64(q.SO_TONSTOP))},
			"SO_TOSTOP":                     {"untyped int", constant.MakeInt64(int64(q.SO_TOSTOP))},
			"SO_TYPE":                       {"untyped int", constant.MakeInt64(int64(q.SO_TYPE))},
			"SO_USELOOPBACK":                {"untyped int", constant.MakeInt64(int64(q.SO_USELOOPBACK))},
			"SO_VRRP":                       {"untyped int", constant.MakeInt64(int64(q.SO_VRRP))},
			"SO_WROFF":                      {"untyped int", constant.MakeInt64(int64(q.SO_WROFF))},
			"SYS_EXECVE":                    {"untyped int", constant.MakeInt64(int64(q.SYS_EXECVE))},
			"SYS_FCNTL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FCNTL))},
			"S_IFBLK":                       {"untyped int", constant.MakeInt64(int64(q.S_IFBLK))},
			"S_IFCHR":                       {"untyped int", constant.MakeInt64(int64(q.S_IFCHR))},
			"S_IFDIR":                       {"untyped int", constant.MakeInt64(int64(q.S_IFDIR))},
			"S_IFIFO":                       {"untyped int", constant.MakeInt64(int64(q.S_IFIFO))},
			"S_IFLNK":                       {"untyped int", constant.MakeInt64(int64(q.S_IFLNK))},
			"S_IFMT":                        {"untyped int", constant.MakeInt64(int64(q.S_IFMT))},
			"S_IFREG":                       {"untyped int", constant.MakeInt64(int64(q.S_IFREG))},
			"S_IFSOCK":                      {"untyped int", constant.MakeInt64(int64(q.S_IFSOCK))},
			"S_IRUSR":                       {"untyped int", constant.MakeInt64(int64(q.S_IRUSR))},
			"S_IRWXG":                       {"untyped int", constant.MakeInt64(int64(q.S_IRWXG))},
			"S_IRWXO":                       {"untyped int", constant.MakeInt64(int64(q.S_IRWXO))},
			"S_ISGID":                       {"untyped int", constant.MakeInt64(int64(q.S_ISGID))},
			"S_ISUID":                       {"untyped int", constant.MakeInt64(int64(q.S_ISUID))},
			"S_ISVTX":                       {"untyped int", constant.MakeInt64(int64(q.S_ISVTX))},
			"S_IWUSR":                       {"untyped int", constant.MakeInt64(int64(q.S_IWUSR))},
			"S_IXUSR":                       {"untyped int", constant.MakeInt64(int64(q.S_IXUSR))},
			"SizeofBpfHdr":                  {"untyped int", constant.MakeInt64(int64(q.SizeofBpfHdr))},
			"SizeofBpfInsn":                 {"untyped int", constant.MakeInt64(int64(q.SizeofBpfInsn))},
			"SizeofBpfProgram":              {"untyped int", constant.MakeInt64(int64(q.SizeofBpfProgram))},
			"SizeofBpfStat":                 {"untyped int", constant.MakeInt64(int64(q.SizeofBpfStat))},
			"SizeofBpfVersion":              {"untyped int", constant.MakeInt64(int64(q.SizeofBpfVersion))},
			"SizeofCmsghdr":                 {"untyped int", constant.MakeInt64(int64(q.SizeofCmsghdr))},
			"SizeofICMPv6Filter":            {"untyped int", constant.MakeInt64(int64(q.SizeofICMPv6Filter))},
			"SizeofIPMreq":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIPMreq))},
			"SizeofIPv6MTUInfo":             {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6MTUInfo))},
			"SizeofIPv6Mreq":                {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6Mreq))},
			"SizeofIfData":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIfData))},
			"SizeofIfMsghdr":                {"untyped int", constant.MakeInt64(int64(q.SizeofIfMsghdr))},
			"SizeofIfaMsghdr":               {"untyped int", constant.MakeInt64(int64(q.SizeofIfaMsghdr))},
			"SizeofInet6Pktinfo":            {"untyped int", constant.MakeInt64(int64(q.SizeofInet6Pktinfo))},
			"SizeofLinger":                  {"untyped int", constant.MakeInt64(int64(q.SizeofLinger))},
			"SizeofMsghdr":                  {"untyped int", constant.MakeInt64(int64(q.SizeofMsghdr))},
			"SizeofRtMetrics":               {"untyped int", constant.MakeInt64(int64(q.SizeofRtMetrics))},
			"SizeofRtMsghdr":                {"untyped int", constant.MakeInt64(int64(q.SizeofRtMsghdr))},
			"SizeofSockaddrAny":             {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrAny))},
			"SizeofSockaddrDatalink":        {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrDatalink))},
			"SizeofSockaddrInet4":           {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet4))},
			"SizeofSockaddrInet6":           {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet6))},
			"SizeofSockaddrUnix":            {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrUnix))},
			"TCFLSH":                        {"untyped int", constant.MakeInt64(int64(q.TCFLSH))},
			"TCIFLUSH":                      {"untyped int", constant.MakeInt64(int64(q.TCIFLUSH))},
			"TCIOFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.TCIOFLUSH))},
			"TCOFLUSH":                      {"untyped int", constant.MakeInt64(int64(q.TCOFLUSH))},
			"TCP_ABORT_THRESHOLD":           {"untyped int", constant.MakeInt64(int64(q.TCP_ABORT_THRESHOLD))},
			"TCP_ANONPRIVBIND":              {"untyped int", constant.MakeInt64(int64(q.TCP_ANONPRIVBIND))},
			"TCP_CONN_ABORT_THRESHOLD":      {"untyped int", constant.MakeInt64(int64(q.TCP_CONN_ABORT_THRESHOLD))},
			"TCP_CONN_NOTIFY_THRESHOLD":     {"untyped int", constant.MakeInt64(int64(q.TCP_CONN_NOTIFY_THRESHOLD))},
			"TCP_CORK":                      {"untyped int", constant.MakeInt64(int64(q.TCP_CORK))},
			"TCP_EXCLBIND":                  {"untyped int", constant.MakeInt64(int64(q.TCP_EXCLBIND))},
			"TCP_INIT_CWND":                 {"untyped int", constant.MakeInt64(int64(q.TCP_INIT_CWND))},
			"TCP_KEEPALIVE":                 {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPALIVE))},
			"TCP_KEEPALIVE_ABORT_THRESHOLD": {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPALIVE_ABORT_THRESHOLD))},
			"TCP_KEEPALIVE_THRESHOLD":       {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPALIVE_THRESHOLD))},
			"TCP_KEEPCNT":                   {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPCNT))},
			"TCP_KEEPIDLE":                  {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPIDLE))},
			"TCP_KEEPINTVL":                 {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPINTVL))},
			"TCP_LINGER2":                   {"untyped int", constant.MakeInt64(int64(q.TCP_LINGER2))},
			"TCP_MAXSEG":                    {"untyped int", constant.MakeInt64(int64(q.TCP_MAXSEG))},
			"TCP_MSS":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MSS))},
			"TCP_NODELAY":                   {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAY))},
			"TCP_NOTIFY_THRESHOLD":          {"untyped int", constant.MakeInt64(int64(q.TCP_NOTIFY_THRESHOLD))},
			"TCP_RECVDSTADDR":               {"untyped int", constant.MakeInt64(int64(q.TCP_RECVDSTADDR))},
			"TCP_RTO_INITIAL":               {"untyped int", constant.MakeInt64(int64(q.TCP_RTO_INITIAL))},
			"TCP_RTO_MAX":                   {"untyped int", constant.MakeInt64(int64(q.TCP_RTO_MAX))},
			"TCP_RTO_MIN":                   {"untyped int", constant.MakeInt64(int64(q.TCP_RTO_MIN))},
			"TCSAFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.TCSAFLUSH))},
			"TIOC":                          {"untyped int", constant.MakeInt64(int64(q.TIOC))},
			"TIOCCBRK":                      {"untyped int", constant.MakeInt64(int64(q.TIOCCBRK))},
			"TIOCCDTR":                      {"untyped int", constant.MakeInt64(int64(q.TIOCCDTR))},
			"TIOCCILOOP":                    {"untyped int", constant.MakeInt64(int64(q.TIOCCILOOP))},
			"TIOCEXCL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCEXCL))},
			"TIOCFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.TIOCFLUSH))},
			"TIOCGETC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGETC))},
			"TIOCGETD":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGETD))},
			"TIOCGETP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGETP))},
			"TIOCGLTC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGLTC))},
			"TIOCGPGRP":                     {"untyped int", constant.MakeInt64(int64(q.TIOCGPGRP))},
			"TIOCGPPS":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGPPS))},
			"TIOCGPPSEV":                    {"untyped int", constant.MakeInt64(int64(q.TIOCGPPSEV))},
			"TIOCGSID":                      {"untyped int", constant.MakeInt64(int64(q.TIOCGSID))},
			"TIOCGSOFTCAR":                  {"untyped int", constant.MakeInt64(int64(q.TIOCGSOFTCAR))},
			"TIOCGWINSZ":                    {"untyped int", constant.MakeInt64(int64(q.TIOCGWINSZ))},
			"TIOCHPCL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCHPCL))},
			"TIOCKBOF":                      {"untyped int", constant.MakeInt64(int64(q.TIOCKBOF))},
			"TIOCKBON":                      {"untyped int", constant.MakeInt64(int64(q.TIOCKBON))},
			"TIOCLBIC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCLBIC))},
			"TIOCLBIS":                      {"untyped int", constant.MakeInt64(int64(q.TIOCLBIS))},
			"TIOCLGET":                      {"untyped int", constant.MakeInt64(int64(q.TIOCLGET))},
			"TIOCLSET":                      {"untyped int", constant.MakeInt64(int64(q.TIOCLSET))},
			"TIOCMBIC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMBIC))},
			"TIOCMBIS":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMBIS))},
			"TIOCMGET":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMGET))},
			"TIOCMSET":                      {"untyped int", constant.MakeInt64(int64(q.TIOCMSET))},
			"TIOCM_CAR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_CAR))},
			"TIOCM_CD":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_CD))},
			"TIOCM_CTS":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_CTS))},
			"TIOCM_DSR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_DSR))},
			"TIOCM_DTR":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_DTR))},
			"TIOCM_LE":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_LE))},
			"TIOCM_RI":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_RI))},
			"TIOCM_RNG":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_RNG))},
			"TIOCM_RTS":                     {"untyped int", constant.MakeInt64(int64(q.TIOCM_RTS))},
			"TIOCM_SR":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_SR))},
			"TIOCM_ST":                      {"untyped int", constant.MakeInt64(int64(q.TIOCM_ST))},
			"TIOCNOTTY":                     {"untyped int", constant.MakeInt64(int64(q.TIOCNOTTY))},
			"TIOCNXCL":                      {"untyped int", constant.MakeInt64(int64(q.TIOCNXCL))},
			"TIOCOUTQ":                      {"untyped int", constant.MakeInt64(int64(q.TIOCOUTQ))},
			"TIOCREMOTE":                    {"untyped int", constant.MakeInt64(int64(q.TIOCREMOTE))},
			"TIOCSBRK":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSBRK))},
			"TIOCSCTTY":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSCTTY))},
			"TIOCSDTR":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSDTR))},
			"TIOCSETC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSETC))},
			"TIOCSETD":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSETD))},
			"TIOCSETN":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSETN))},
			"TIOCSETP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSETP))},
			"TIOCSIGNAL":                    {"untyped int", constant.MakeInt64(int64(q.TIOCSIGNAL))},
			"TIOCSILOOP":                    {"untyped int", constant.MakeInt64(int64(q.TIOCSILOOP))},
			"TIOCSLTC":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSLTC))},
			"TIOCSPGRP":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSPGRP))},
			"TIOCSPPS":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSPPS))},
			"TIOCSSOFTCAR":                  {"untyped int", constant.MakeInt64(int64(q.TIOCSSOFTCAR))},
			"TIOCSTART":                     {"untyped int", constant.MakeInt64(int64(q.TIOCSTART))},
			"TIOCSTI":                       {"untyped int", constant.MakeInt64(int64(q.TIOCSTI))},
			"TIOCSTOP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCSTOP))},
			"TIOCSWINSZ":                    {"untyped int", constant.MakeInt64(int64(q.TIOCSWINSZ))},
			"TOSTOP":                        {"untyped int", constant.MakeInt64(int64(q.TOSTOP))},
			"VCEOF":                         {"untyped int", constant.MakeInt64(int64(q.VCEOF))},
			"VCEOL":                         {"untyped int", constant.MakeInt64(int64(q.VCEOL))},
			"VDISCARD":                      {"untyped int", constant.MakeInt64(int64(q.VDISCARD))},
			"VDSUSP":                        {"untyped int", constant.MakeInt64(int64(q.VDSUSP))},
			"VEOF":                          {"untyped int", constant.MakeInt64(int64(q.VEOF))},
			"VEOL":                          {"untyped int", constant.MakeInt64(int64(q.VEOL))},
			"VEOL2":                         {"untyped int", constant.MakeInt64(int64(q.VEOL2))},
			"VERASE":                        {"untyped int", constant.MakeInt64(int64(q.VERASE))},
			"VINTR":                         {"untyped int", constant.MakeInt64(int64(q.VINTR))},
			"VKILL":                         {"untyped int", constant.MakeInt64(int64(q.VKILL))},
			"VLNEXT":                        {"untyped int", constant.MakeInt64(int64(q.VLNEXT))},
			"VMIN":                          {"untyped int", constant.MakeInt64(int64(q.VMIN))},
			"VQUIT":                         {"untyped int", constant.MakeInt64(int64(q.VQUIT))},
			"VREPRINT":                      {"untyped int", constant.MakeInt64(int64(q.VREPRINT))},
			"VSTART":                        {"untyped int", constant.MakeInt64(int64(q.VSTART))},
			"VSTOP":                         {"untyped int", constant.MakeInt64(int64(q.VSTOP))},
			"VSUSP":                         {"untyped int", constant.MakeInt64(int64(q.VSUSP))},
			"VSWTCH":                        {"untyped int", constant.MakeInt64(int64(q.VSWTCH))},
			"VT0":                           {"untyped int", constant.MakeInt64(int64(q.VT0))},
			"VT1":                           {"untyped int", constant.MakeInt64(int64(q.VT1))},
			"VTDLY":                         {"untyped int", constant.MakeInt64(int64(q.VTDLY))},
			"VTIME":                         {"untyped int", constant.MakeInt64(int64(q.VTIME))},
			"VWERASE":                       {"untyped int", constant.MakeInt64(int64(q.VWERASE))},
			"WCONTFLG":                      {"untyped int", constant.MakeInt64(int64(q.WCONTFLG))},
			"WCONTINUED":                    {"untyped int", constant.MakeInt64(int64(q.WCONTINUED))},
			"WCOREFLG":                      {"untyped int", constant.MakeInt64(int64(q.WCOREFLG))},
			"WEXITED":                       {"untyped int", constant.MakeInt64(int64(q.WEXITED))},
			"WNOHANG":                       {"untyped int", constant.MakeInt64(int64(q.WNOHANG))},
			"WNOWAIT":                       {"untyped int", constant.MakeInt64(int64(q.WNOWAIT))},
			"WOPTMASK":                      {"untyped int", constant.MakeInt64(int64(q.WOPTMASK))},
			"WRAP":                          {"untyped int", constant.MakeInt64(int64(q.WRAP))},
			"WSIGMASK":                      {"untyped int", constant.MakeInt64(int64(q.WSIGMASK))},
			"WSTOPFLG":                      {"untyped int", constant.MakeInt64(int64(q.WSTOPFLG))},
			"WSTOPPED":                      {"untyped int", constant.MakeInt64(int64(q.WSTOPPED))},
			"WTRAPPED":                      {"untyped int", constant.MakeInt64(int64(q.WTRAPPED))},
			"WUNTRACED":                     {"untyped int", constant.MakeInt64(int64(q.WUNTRACED))},
		},
	})
}
