// export by github.com/goplus/igop/cmd/qexp

//go:build go1.19 && !go1.20
// +build go1.19,!go1.20

package syscall

import (
	q "syscall"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "syscall",
		Path: "syscall",
		Deps: map[string]string{
			"errors":                          "errors",
			"internal/bytealg":                "bytealg",
			"internal/itoa":                   "itoa",
			"internal/oserror":                "oserror",
			"internal/race":                   "race",
			"internal/syscall/windows/sysdll": "sysdll",
			"internal/unsafeheader":           "unsafeheader",
			"runtime":                         "runtime",
			"sync":                            "sync",
			"sync/atomic":                     "atomic",
			"unicode/utf16":                   "utf16",
			"unsafe":                          "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Conn":     reflect.TypeOf((*q.Conn)(nil)).Elem(),
			"RawConn":  reflect.TypeOf((*q.RawConn)(nil)).Elem(),
			"Sockaddr": reflect.TypeOf((*q.Sockaddr)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"AddrinfoW":                   reflect.TypeOf((*q.AddrinfoW)(nil)).Elem(),
			"ByHandleFileInformation":     reflect.TypeOf((*q.ByHandleFileInformation)(nil)).Elem(),
			"CertChainContext":            reflect.TypeOf((*q.CertChainContext)(nil)).Elem(),
			"CertChainElement":            reflect.TypeOf((*q.CertChainElement)(nil)).Elem(),
			"CertChainPara":               reflect.TypeOf((*q.CertChainPara)(nil)).Elem(),
			"CertChainPolicyPara":         reflect.TypeOf((*q.CertChainPolicyPara)(nil)).Elem(),
			"CertChainPolicyStatus":       reflect.TypeOf((*q.CertChainPolicyStatus)(nil)).Elem(),
			"CertContext":                 reflect.TypeOf((*q.CertContext)(nil)).Elem(),
			"CertEnhKeyUsage":             reflect.TypeOf((*q.CertEnhKeyUsage)(nil)).Elem(),
			"CertInfo":                    reflect.TypeOf((*q.CertInfo)(nil)).Elem(),
			"CertRevocationCrlInfo":       reflect.TypeOf((*q.CertRevocationCrlInfo)(nil)).Elem(),
			"CertRevocationInfo":          reflect.TypeOf((*q.CertRevocationInfo)(nil)).Elem(),
			"CertSimpleChain":             reflect.TypeOf((*q.CertSimpleChain)(nil)).Elem(),
			"CertTrustListInfo":           reflect.TypeOf((*q.CertTrustListInfo)(nil)).Elem(),
			"CertTrustStatus":             reflect.TypeOf((*q.CertTrustStatus)(nil)).Elem(),
			"CertUsageMatch":              reflect.TypeOf((*q.CertUsageMatch)(nil)).Elem(),
			"DLL":                         reflect.TypeOf((*q.DLL)(nil)).Elem(),
			"DLLError":                    reflect.TypeOf((*q.DLLError)(nil)).Elem(),
			"DNSMXData":                   reflect.TypeOf((*q.DNSMXData)(nil)).Elem(),
			"DNSPTRData":                  reflect.TypeOf((*q.DNSPTRData)(nil)).Elem(),
			"DNSRecord":                   reflect.TypeOf((*q.DNSRecord)(nil)).Elem(),
			"DNSSRVData":                  reflect.TypeOf((*q.DNSSRVData)(nil)).Elem(),
			"DNSTXTData":                  reflect.TypeOf((*q.DNSTXTData)(nil)).Elem(),
			"Errno":                       reflect.TypeOf((*q.Errno)(nil)).Elem(),
			"FileNotifyInformation":       reflect.TypeOf((*q.FileNotifyInformation)(nil)).Elem(),
			"Filetime":                    reflect.TypeOf((*q.Filetime)(nil)).Elem(),
			"GUID":                        reflect.TypeOf((*q.GUID)(nil)).Elem(),
			"Handle":                      reflect.TypeOf((*q.Handle)(nil)).Elem(),
			"Hostent":                     reflect.TypeOf((*q.Hostent)(nil)).Elem(),
			"IPMreq":                      reflect.TypeOf((*q.IPMreq)(nil)).Elem(),
			"IPv6Mreq":                    reflect.TypeOf((*q.IPv6Mreq)(nil)).Elem(),
			"InterfaceInfo":               reflect.TypeOf((*q.InterfaceInfo)(nil)).Elem(),
			"IpAdapterInfo":               reflect.TypeOf((*q.IpAdapterInfo)(nil)).Elem(),
			"IpAddrString":                reflect.TypeOf((*q.IpAddrString)(nil)).Elem(),
			"IpAddressString":             reflect.TypeOf((*q.IpAddressString)(nil)).Elem(),
			"IpMaskString":                reflect.TypeOf((*q.IpMaskString)(nil)).Elem(),
			"LazyDLL":                     reflect.TypeOf((*q.LazyDLL)(nil)).Elem(),
			"LazyProc":                    reflect.TypeOf((*q.LazyProc)(nil)).Elem(),
			"Linger":                      reflect.TypeOf((*q.Linger)(nil)).Elem(),
			"MibIfRow":                    reflect.TypeOf((*q.MibIfRow)(nil)).Elem(),
			"Overlapped":                  reflect.TypeOf((*q.Overlapped)(nil)).Elem(),
			"Pointer":                     reflect.TypeOf((*q.Pointer)(nil)).Elem(),
			"Proc":                        reflect.TypeOf((*q.Proc)(nil)).Elem(),
			"ProcAttr":                    reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"ProcessEntry32":              reflect.TypeOf((*q.ProcessEntry32)(nil)).Elem(),
			"ProcessInformation":          reflect.TypeOf((*q.ProcessInformation)(nil)).Elem(),
			"Protoent":                    reflect.TypeOf((*q.Protoent)(nil)).Elem(),
			"RawSockaddr":                 reflect.TypeOf((*q.RawSockaddr)(nil)).Elem(),
			"RawSockaddrAny":              reflect.TypeOf((*q.RawSockaddrAny)(nil)).Elem(),
			"RawSockaddrInet4":            reflect.TypeOf((*q.RawSockaddrInet4)(nil)).Elem(),
			"RawSockaddrInet6":            reflect.TypeOf((*q.RawSockaddrInet6)(nil)).Elem(),
			"RawSockaddrUnix":             reflect.TypeOf((*q.RawSockaddrUnix)(nil)).Elem(),
			"Rusage":                      reflect.TypeOf((*q.Rusage)(nil)).Elem(),
			"SID":                         reflect.TypeOf((*q.SID)(nil)).Elem(),
			"SIDAndAttributes":            reflect.TypeOf((*q.SIDAndAttributes)(nil)).Elem(),
			"SSLExtraCertChainPolicyPara": reflect.TypeOf((*q.SSLExtraCertChainPolicyPara)(nil)).Elem(),
			"SecurityAttributes":          reflect.TypeOf((*q.SecurityAttributes)(nil)).Elem(),
			"Servent":                     reflect.TypeOf((*q.Servent)(nil)).Elem(),
			"Signal":                      reflect.TypeOf((*q.Signal)(nil)).Elem(),
			"SockaddrGen":                 reflect.TypeOf((*q.SockaddrGen)(nil)).Elem(),
			"SockaddrInet4":               reflect.TypeOf((*q.SockaddrInet4)(nil)).Elem(),
			"SockaddrInet6":               reflect.TypeOf((*q.SockaddrInet6)(nil)).Elem(),
			"SockaddrUnix":                reflect.TypeOf((*q.SockaddrUnix)(nil)).Elem(),
			"StartupInfo":                 reflect.TypeOf((*q.StartupInfo)(nil)).Elem(),
			"SysProcAttr":                 reflect.TypeOf((*q.SysProcAttr)(nil)).Elem(),
			"Systemtime":                  reflect.TypeOf((*q.Systemtime)(nil)).Elem(),
			"TCPKeepalive":                reflect.TypeOf((*q.TCPKeepalive)(nil)).Elem(),
			"Timespec":                    reflect.TypeOf((*q.Timespec)(nil)).Elem(),
			"Timeval":                     reflect.TypeOf((*q.Timeval)(nil)).Elem(),
			"Timezoneinformation":         reflect.TypeOf((*q.Timezoneinformation)(nil)).Elem(),
			"Token":                       reflect.TypeOf((*q.Token)(nil)).Elem(),
			"Tokenprimarygroup":           reflect.TypeOf((*q.Tokenprimarygroup)(nil)).Elem(),
			"Tokenuser":                   reflect.TypeOf((*q.Tokenuser)(nil)).Elem(),
			"TransmitFileBuffers":         reflect.TypeOf((*q.TransmitFileBuffers)(nil)).Elem(),
			"UserInfo10":                  reflect.TypeOf((*q.UserInfo10)(nil)).Elem(),
			"WSABuf":                      reflect.TypeOf((*q.WSABuf)(nil)).Elem(),
			"WSAData":                     reflect.TypeOf((*q.WSAData)(nil)).Elem(),
			"WSAProtocolChain":            reflect.TypeOf((*q.WSAProtocolChain)(nil)).Elem(),
			"WSAProtocolInfo":             reflect.TypeOf((*q.WSAProtocolInfo)(nil)).Elem(),
			"WaitStatus":                  reflect.TypeOf((*q.WaitStatus)(nil)).Elem(),
			"Win32FileAttributeData":      reflect.TypeOf((*q.Win32FileAttributeData)(nil)).Elem(),
			"Win32finddata":               reflect.TypeOf((*q.Win32finddata)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ForkLock":                reflect.ValueOf(&q.ForkLock),
			"OID_PKIX_KP_SERVER_AUTH": reflect.ValueOf(&q.OID_PKIX_KP_SERVER_AUTH),
			"OID_SERVER_GATED_CRYPTO": reflect.ValueOf(&q.OID_SERVER_GATED_CRYPTO),
			"OID_SGC_NETSCAPE":        reflect.ValueOf(&q.OID_SGC_NETSCAPE),
			"SocketDisableIPv6":       reflect.ValueOf(&q.SocketDisableIPv6),
			"Stderr":                  reflect.ValueOf(&q.Stderr),
			"Stdin":                   reflect.ValueOf(&q.Stdin),
			"Stdout":                  reflect.ValueOf(&q.Stdout),
			"WSAID_CONNECTEX":         reflect.ValueOf(&q.WSAID_CONNECTEX),
		},
		Funcs: map[string]reflect.Value{
			"Accept":                                 reflect.ValueOf(q.Accept),
			"AcceptEx":                               reflect.ValueOf(q.AcceptEx),
			"Bind":                                   reflect.ValueOf(q.Bind),
			"BytePtrFromString":                      reflect.ValueOf(q.BytePtrFromString),
			"ByteSliceFromString":                    reflect.ValueOf(q.ByteSliceFromString),
			"CancelIo":                               reflect.ValueOf(q.CancelIo),
			"CancelIoEx":                             reflect.ValueOf(q.CancelIoEx),
			"CertAddCertificateContextToStore":       reflect.ValueOf(q.CertAddCertificateContextToStore),
			"CertCloseStore":                         reflect.ValueOf(q.CertCloseStore),
			"CertCreateCertificateContext":           reflect.ValueOf(q.CertCreateCertificateContext),
			"CertEnumCertificatesInStore":            reflect.ValueOf(q.CertEnumCertificatesInStore),
			"CertFreeCertificateChain":               reflect.ValueOf(q.CertFreeCertificateChain),
			"CertFreeCertificateContext":             reflect.ValueOf(q.CertFreeCertificateContext),
			"CertGetCertificateChain":                reflect.ValueOf(q.CertGetCertificateChain),
			"CertOpenStore":                          reflect.ValueOf(q.CertOpenStore),
			"CertOpenSystemStore":                    reflect.ValueOf(q.CertOpenSystemStore),
			"CertVerifyCertificateChainPolicy":       reflect.ValueOf(q.CertVerifyCertificateChainPolicy),
			"Chdir":                                  reflect.ValueOf(q.Chdir),
			"Chmod":                                  reflect.ValueOf(q.Chmod),
			"Chown":                                  reflect.ValueOf(q.Chown),
			"Clearenv":                               reflect.ValueOf(q.Clearenv),
			"Close":                                  reflect.ValueOf(q.Close),
			"CloseHandle":                            reflect.ValueOf(q.CloseHandle),
			"CloseOnExec":                            reflect.ValueOf(q.CloseOnExec),
			"Closesocket":                            reflect.ValueOf(q.Closesocket),
			"CommandLineToArgv":                      reflect.ValueOf(q.CommandLineToArgv),
			"ComputerName":                           reflect.ValueOf(q.ComputerName),
			"Connect":                                reflect.ValueOf(q.Connect),
			"ConnectEx":                              reflect.ValueOf(q.ConnectEx),
			"ConvertSidToStringSid":                  reflect.ValueOf(q.ConvertSidToStringSid),
			"ConvertStringSidToSid":                  reflect.ValueOf(q.ConvertStringSidToSid),
			"CopySid":                                reflect.ValueOf(q.CopySid),
			"CreateDirectory":                        reflect.ValueOf(q.CreateDirectory),
			"CreateFile":                             reflect.ValueOf(q.CreateFile),
			"CreateFileMapping":                      reflect.ValueOf(q.CreateFileMapping),
			"CreateHardLink":                         reflect.ValueOf(q.CreateHardLink),
			"CreateIoCompletionPort":                 reflect.ValueOf(q.CreateIoCompletionPort),
			"CreatePipe":                             reflect.ValueOf(q.CreatePipe),
			"CreateProcess":                          reflect.ValueOf(q.CreateProcess),
			"CreateProcessAsUser":                    reflect.ValueOf(q.CreateProcessAsUser),
			"CreateSymbolicLink":                     reflect.ValueOf(q.CreateSymbolicLink),
			"CreateToolhelp32Snapshot":               reflect.ValueOf(q.CreateToolhelp32Snapshot),
			"CryptAcquireContext":                    reflect.ValueOf(q.CryptAcquireContext),
			"CryptGenRandom":                         reflect.ValueOf(q.CryptGenRandom),
			"CryptReleaseContext":                    reflect.ValueOf(q.CryptReleaseContext),
			"DeleteFile":                             reflect.ValueOf(q.DeleteFile),
			"DeviceIoControl":                        reflect.ValueOf(q.DeviceIoControl),
			"DnsNameCompare":                         reflect.ValueOf(q.DnsNameCompare),
			"DnsQuery":                               reflect.ValueOf(q.DnsQuery),
			"DnsRecordListFree":                      reflect.ValueOf(q.DnsRecordListFree),
			"DuplicateHandle":                        reflect.ValueOf(q.DuplicateHandle),
			"Environ":                                reflect.ValueOf(q.Environ),
			"EscapeArg":                              reflect.ValueOf(q.EscapeArg),
			"Exec":                                   reflect.ValueOf(q.Exec),
			"Exit":                                   reflect.ValueOf(q.Exit),
			"ExitProcess":                            reflect.ValueOf(q.ExitProcess),
			"Fchdir":                                 reflect.ValueOf(q.Fchdir),
			"Fchmod":                                 reflect.ValueOf(q.Fchmod),
			"Fchown":                                 reflect.ValueOf(q.Fchown),
			"FindClose":                              reflect.ValueOf(q.FindClose),
			"FindFirstFile":                          reflect.ValueOf(q.FindFirstFile),
			"FindNextFile":                           reflect.ValueOf(q.FindNextFile),
			"FlushFileBuffers":                       reflect.ValueOf(q.FlushFileBuffers),
			"FlushViewOfFile":                        reflect.ValueOf(q.FlushViewOfFile),
			"FormatMessage":                          reflect.ValueOf(q.FormatMessage),
			"FreeAddrInfoW":                          reflect.ValueOf(q.FreeAddrInfoW),
			"FreeEnvironmentStrings":                 reflect.ValueOf(q.FreeEnvironmentStrings),
			"FreeLibrary":                            reflect.ValueOf(q.FreeLibrary),
			"Fsync":                                  reflect.ValueOf(q.Fsync),
			"Ftruncate":                              reflect.ValueOf(q.Ftruncate),
			"FullPath":                               reflect.ValueOf(q.FullPath),
			"GetAcceptExSockaddrs":                   reflect.ValueOf(q.GetAcceptExSockaddrs),
			"GetAdaptersInfo":                        reflect.ValueOf(q.GetAdaptersInfo),
			"GetAddrInfoW":                           reflect.ValueOf(q.GetAddrInfoW),
			"GetCommandLine":                         reflect.ValueOf(q.GetCommandLine),
			"GetComputerName":                        reflect.ValueOf(q.GetComputerName),
			"GetConsoleMode":                         reflect.ValueOf(q.GetConsoleMode),
			"GetCurrentDirectory":                    reflect.ValueOf(q.GetCurrentDirectory),
			"GetCurrentProcess":                      reflect.ValueOf(q.GetCurrentProcess),
			"GetEnvironmentStrings":                  reflect.ValueOf(q.GetEnvironmentStrings),
			"GetEnvironmentVariable":                 reflect.ValueOf(q.GetEnvironmentVariable),
			"GetExitCodeProcess":                     reflect.ValueOf(q.GetExitCodeProcess),
			"GetFileAttributes":                      reflect.ValueOf(q.GetFileAttributes),
			"GetFileAttributesEx":                    reflect.ValueOf(q.GetFileAttributesEx),
			"GetFileInformationByHandle":             reflect.ValueOf(q.GetFileInformationByHandle),
			"GetFileType":                            reflect.ValueOf(q.GetFileType),
			"GetFullPathName":                        reflect.ValueOf(q.GetFullPathName),
			"GetHostByName":                          reflect.ValueOf(q.GetHostByName),
			"GetIfEntry":                             reflect.ValueOf(q.GetIfEntry),
			"GetLastError":                           reflect.ValueOf(q.GetLastError),
			"GetLengthSid":                           reflect.ValueOf(q.GetLengthSid),
			"GetLongPathName":                        reflect.ValueOf(q.GetLongPathName),
			"GetProcAddress":                         reflect.ValueOf(q.GetProcAddress),
			"GetProcessTimes":                        reflect.ValueOf(q.GetProcessTimes),
			"GetProtoByName":                         reflect.ValueOf(q.GetProtoByName),
			"GetQueuedCompletionStatus":              reflect.ValueOf(q.GetQueuedCompletionStatus),
			"GetServByName":                          reflect.ValueOf(q.GetServByName),
			"GetShortPathName":                       reflect.ValueOf(q.GetShortPathName),
			"GetStartupInfo":                         reflect.ValueOf(q.GetStartupInfo),
			"GetStdHandle":                           reflect.ValueOf(q.GetStdHandle),
			"GetSystemTimeAsFileTime":                reflect.ValueOf(q.GetSystemTimeAsFileTime),
			"GetTempPath":                            reflect.ValueOf(q.GetTempPath),
			"GetTimeZoneInformation":                 reflect.ValueOf(q.GetTimeZoneInformation),
			"GetTokenInformation":                    reflect.ValueOf(q.GetTokenInformation),
			"GetUserNameEx":                          reflect.ValueOf(q.GetUserNameEx),
			"GetUserProfileDirectory":                reflect.ValueOf(q.GetUserProfileDirectory),
			"GetVersion":                             reflect.ValueOf(q.GetVersion),
			"Getegid":                                reflect.ValueOf(q.Getegid),
			"Getenv":                                 reflect.ValueOf(q.Getenv),
			"Geteuid":                                reflect.ValueOf(q.Geteuid),
			"Getgid":                                 reflect.ValueOf(q.Getgid),
			"Getgroups":                              reflect.ValueOf(q.Getgroups),
			"Getpagesize":                            reflect.ValueOf(q.Getpagesize),
			"Getpeername":                            reflect.ValueOf(q.Getpeername),
			"Getpid":                                 reflect.ValueOf(q.Getpid),
			"Getppid":                                reflect.ValueOf(q.Getppid),
			"Getsockname":                            reflect.ValueOf(q.Getsockname),
			"Getsockopt":                             reflect.ValueOf(q.Getsockopt),
			"GetsockoptInt":                          reflect.ValueOf(q.GetsockoptInt),
			"Gettimeofday":                           reflect.ValueOf(q.Gettimeofday),
			"Getuid":                                 reflect.ValueOf(q.Getuid),
			"Getwd":                                  reflect.ValueOf(q.Getwd),
			"Lchown":                                 reflect.ValueOf(q.Lchown),
			"Link":                                   reflect.ValueOf(q.Link),
			"Listen":                                 reflect.ValueOf(q.Listen),
			"LoadCancelIoEx":                         reflect.ValueOf(q.LoadCancelIoEx),
			"LoadConnectEx":                          reflect.ValueOf(q.LoadConnectEx),
			"LoadCreateSymbolicLink":                 reflect.ValueOf(q.LoadCreateSymbolicLink),
			"LoadDLL":                                reflect.ValueOf(q.LoadDLL),
			"LoadGetAddrInfo":                        reflect.ValueOf(q.LoadGetAddrInfo),
			"LoadLibrary":                            reflect.ValueOf(q.LoadLibrary),
			"LoadSetFileCompletionNotificationModes": reflect.ValueOf(q.LoadSetFileCompletionNotificationModes),
			"LocalFree":                              reflect.ValueOf(q.LocalFree),
			"LookupAccountName":                      reflect.ValueOf(q.LookupAccountName),
			"LookupAccountSid":                       reflect.ValueOf(q.LookupAccountSid),
			"LookupSID":                              reflect.ValueOf(q.LookupSID),
			"MapViewOfFile":                          reflect.ValueOf(q.MapViewOfFile),
			"Mkdir":                                  reflect.ValueOf(q.Mkdir),
			"MoveFile":                               reflect.ValueOf(q.MoveFile),
			"MustLoadDLL":                            reflect.ValueOf(q.MustLoadDLL),
			"NetApiBufferFree":                       reflect.ValueOf(q.NetApiBufferFree),
			"NetGetJoinInformation":                  reflect.ValueOf(q.NetGetJoinInformation),
			"NetUserGetInfo":                         reflect.ValueOf(q.NetUserGetInfo),
			"NewCallback":                            reflect.ValueOf(q.NewCallback),
			"NewCallbackCDecl":                       reflect.ValueOf(q.NewCallbackCDecl),
			"NewLazyDLL":                             reflect.ValueOf(q.NewLazyDLL),
			"NsecToFiletime":                         reflect.ValueOf(q.NsecToFiletime),
			"NsecToTimespec":                         reflect.ValueOf(q.NsecToTimespec),
			"NsecToTimeval":                          reflect.ValueOf(q.NsecToTimeval),
			"Ntohs":                                  reflect.ValueOf(q.Ntohs),
			"Open":                                   reflect.ValueOf(q.Open),
			"OpenCurrentProcessToken":                reflect.ValueOf(q.OpenCurrentProcessToken),
			"OpenProcess":                            reflect.ValueOf(q.OpenProcess),
			"OpenProcessToken":                       reflect.ValueOf(q.OpenProcessToken),
			"Pipe":                                   reflect.ValueOf(q.Pipe),
			"PostQueuedCompletionStatus":             reflect.ValueOf(q.PostQueuedCompletionStatus),
			"Process32First":                         reflect.ValueOf(q.Process32First),
			"Process32Next":                          reflect.ValueOf(q.Process32Next),
			"Read":                                   reflect.ValueOf(q.Read),
			"ReadConsole":                            reflect.ValueOf(q.ReadConsole),
			"ReadDirectoryChanges":                   reflect.ValueOf(q.ReadDirectoryChanges),
			"ReadFile":                               reflect.ValueOf(q.ReadFile),
			"Readlink":                               reflect.ValueOf(q.Readlink),
			"Recvfrom":                               reflect.ValueOf(q.Recvfrom),
			"RegCloseKey":                            reflect.ValueOf(q.RegCloseKey),
			"RegEnumKeyEx":                           reflect.ValueOf(q.RegEnumKeyEx),
			"RegOpenKeyEx":                           reflect.ValueOf(q.RegOpenKeyEx),
			"RegQueryInfoKey":                        reflect.ValueOf(q.RegQueryInfoKey),
			"RegQueryValueEx":                        reflect.ValueOf(q.RegQueryValueEx),
			"RemoveDirectory":                        reflect.ValueOf(q.RemoveDirectory),
			"Rename":                                 reflect.ValueOf(q.Rename),
			"Rmdir":                                  reflect.ValueOf(q.Rmdir),
			"Seek":                                   reflect.ValueOf(q.Seek),
			"Sendto":                                 reflect.ValueOf(q.Sendto),
			"SetCurrentDirectory":                    reflect.ValueOf(q.SetCurrentDirectory),
			"SetEndOfFile":                           reflect.ValueOf(q.SetEndOfFile),
			"SetEnvironmentVariable":                 reflect.ValueOf(q.SetEnvironmentVariable),
			"SetFileAttributes":                      reflect.ValueOf(q.SetFileAttributes),
			"SetFileCompletionNotificationModes":     reflect.ValueOf(q.SetFileCompletionNotificationModes),
			"SetFilePointer":                         reflect.ValueOf(q.SetFilePointer),
			"SetFileTime":                            reflect.ValueOf(q.SetFileTime),
			"SetHandleInformation":                   reflect.ValueOf(q.SetHandleInformation),
			"SetNonblock":                            reflect.ValueOf(q.SetNonblock),
			"Setenv":                                 reflect.ValueOf(q.Setenv),
			"Setsockopt":                             reflect.ValueOf(q.Setsockopt),
			"SetsockoptIPMreq":                       reflect.ValueOf(q.SetsockoptIPMreq),
			"SetsockoptIPv6Mreq":                     reflect.ValueOf(q.SetsockoptIPv6Mreq),
			"SetsockoptInet4Addr":                    reflect.ValueOf(q.SetsockoptInet4Addr),
			"SetsockoptInt":                          reflect.ValueOf(q.SetsockoptInt),
			"SetsockoptLinger":                       reflect.ValueOf(q.SetsockoptLinger),
			"SetsockoptTimeval":                      reflect.ValueOf(q.SetsockoptTimeval),
			"Shutdown":                               reflect.ValueOf(q.Shutdown),
			"Socket":                                 reflect.ValueOf(q.Socket),
			"StartProcess":                           reflect.ValueOf(q.StartProcess),
			"StringBytePtr":                          reflect.ValueOf(q.StringBytePtr),
			"StringByteSlice":                        reflect.ValueOf(q.StringByteSlice),
			"StringToSid":                            reflect.ValueOf(q.StringToSid),
			"StringToUTF16":                          reflect.ValueOf(q.StringToUTF16),
			"StringToUTF16Ptr":                       reflect.ValueOf(q.StringToUTF16Ptr),
			"Symlink":                                reflect.ValueOf(q.Symlink),
			"Syscall":                                reflect.ValueOf(q.Syscall),
			"Syscall12":                              reflect.ValueOf(q.Syscall12),
			"Syscall15":                              reflect.ValueOf(q.Syscall15),
			"Syscall18":                              reflect.ValueOf(q.Syscall18),
			"Syscall6":                               reflect.ValueOf(q.Syscall6),
			"Syscall9":                               reflect.ValueOf(q.Syscall9),
			"SyscallN":                               reflect.ValueOf(q.SyscallN),
			"TerminateProcess":                       reflect.ValueOf(q.TerminateProcess),
			"TimespecToNsec":                         reflect.ValueOf(q.TimespecToNsec),
			"TranslateAccountName":                   reflect.ValueOf(q.TranslateAccountName),
			"TranslateName":                          reflect.ValueOf(q.TranslateName),
			"TransmitFile":                           reflect.ValueOf(q.TransmitFile),
			"UTF16FromString":                        reflect.ValueOf(q.UTF16FromString),
			"UTF16PtrFromString":                     reflect.ValueOf(q.UTF16PtrFromString),
			"UTF16ToString":                          reflect.ValueOf(q.UTF16ToString),
			"Unlink":                                 reflect.ValueOf(q.Unlink),
			"UnmapViewOfFile":                        reflect.ValueOf(q.UnmapViewOfFile),
			"Unsetenv":                               reflect.ValueOf(q.Unsetenv),
			"Utimes":                                 reflect.ValueOf(q.Utimes),
			"UtimesNano":                             reflect.ValueOf(q.UtimesNano),
			"VirtualLock":                            reflect.ValueOf(q.VirtualLock),
			"VirtualUnlock":                          reflect.ValueOf(q.VirtualUnlock),
			"WSACleanup":                             reflect.ValueOf(q.WSACleanup),
			"WSAEnumProtocols":                       reflect.ValueOf(q.WSAEnumProtocols),
			"WSAIoctl":                               reflect.ValueOf(q.WSAIoctl),
			"WSARecv":                                reflect.ValueOf(q.WSARecv),
			"WSARecvFrom":                            reflect.ValueOf(q.WSARecvFrom),
			"WSASend":                                reflect.ValueOf(q.WSASend),
			"WSASendTo":                              reflect.ValueOf(q.WSASendTo),
			"WSASendto":                              reflect.ValueOf(q.WSASendto),
			"WSAStartup":                             reflect.ValueOf(q.WSAStartup),
			"WaitForSingleObject":                    reflect.ValueOf(q.WaitForSingleObject),
			"Write":                                  reflect.ValueOf(q.Write),
			"WriteConsole":                           reflect.ValueOf(q.WriteConsole),
			"WriteFile":                              reflect.ValueOf(q.WriteFile),
		},
		TypedConsts: map[string]igop.TypedConst{
			"E2BIG":                     {reflect.TypeOf(q.E2BIG), constant.MakeInt64(int64(q.E2BIG))},
			"EACCES":                    {reflect.TypeOf(q.EACCES), constant.MakeInt64(int64(q.EACCES))},
			"EADDRINUSE":                {reflect.TypeOf(q.EADDRINUSE), constant.MakeInt64(int64(q.EADDRINUSE))},
			"EADDRNOTAVAIL":             {reflect.TypeOf(q.EADDRNOTAVAIL), constant.MakeInt64(int64(q.EADDRNOTAVAIL))},
			"EADV":                      {reflect.TypeOf(q.EADV), constant.MakeInt64(int64(q.EADV))},
			"EAFNOSUPPORT":              {reflect.TypeOf(q.EAFNOSUPPORT), constant.MakeInt64(int64(q.EAFNOSUPPORT))},
			"EAGAIN":                    {reflect.TypeOf(q.EAGAIN), constant.MakeInt64(int64(q.EAGAIN))},
			"EALREADY":                  {reflect.TypeOf(q.EALREADY), constant.MakeInt64(int64(q.EALREADY))},
			"EBADE":                     {reflect.TypeOf(q.EBADE), constant.MakeInt64(int64(q.EBADE))},
			"EBADF":                     {reflect.TypeOf(q.EBADF), constant.MakeInt64(int64(q.EBADF))},
			"EBADFD":                    {reflect.TypeOf(q.EBADFD), constant.MakeInt64(int64(q.EBADFD))},
			"EBADMSG":                   {reflect.TypeOf(q.EBADMSG), constant.MakeInt64(int64(q.EBADMSG))},
			"EBADR":                     {reflect.TypeOf(q.EBADR), constant.MakeInt64(int64(q.EBADR))},
			"EBADRQC":                   {reflect.TypeOf(q.EBADRQC), constant.MakeInt64(int64(q.EBADRQC))},
			"EBADSLT":                   {reflect.TypeOf(q.EBADSLT), constant.MakeInt64(int64(q.EBADSLT))},
			"EBFONT":                    {reflect.TypeOf(q.EBFONT), constant.MakeInt64(int64(q.EBFONT))},
			"EBUSY":                     {reflect.TypeOf(q.EBUSY), constant.MakeInt64(int64(q.EBUSY))},
			"ECANCELED":                 {reflect.TypeOf(q.ECANCELED), constant.MakeInt64(int64(q.ECANCELED))},
			"ECHILD":                    {reflect.TypeOf(q.ECHILD), constant.MakeInt64(int64(q.ECHILD))},
			"ECHRNG":                    {reflect.TypeOf(q.ECHRNG), constant.MakeInt64(int64(q.ECHRNG))},
			"ECOMM":                     {reflect.TypeOf(q.ECOMM), constant.MakeInt64(int64(q.ECOMM))},
			"ECONNABORTED":              {reflect.TypeOf(q.ECONNABORTED), constant.MakeInt64(int64(q.ECONNABORTED))},
			"ECONNREFUSED":              {reflect.TypeOf(q.ECONNREFUSED), constant.MakeInt64(int64(q.ECONNREFUSED))},
			"ECONNRESET":                {reflect.TypeOf(q.ECONNRESET), constant.MakeInt64(int64(q.ECONNRESET))},
			"EDEADLK":                   {reflect.TypeOf(q.EDEADLK), constant.MakeInt64(int64(q.EDEADLK))},
			"EDEADLOCK":                 {reflect.TypeOf(q.EDEADLOCK), constant.MakeInt64(int64(q.EDEADLOCK))},
			"EDESTADDRREQ":              {reflect.TypeOf(q.EDESTADDRREQ), constant.MakeInt64(int64(q.EDESTADDRREQ))},
			"EDOM":                      {reflect.TypeOf(q.EDOM), constant.MakeInt64(int64(q.EDOM))},
			"EDOTDOT":                   {reflect.TypeOf(q.EDOTDOT), constant.MakeInt64(int64(q.EDOTDOT))},
			"EDQUOT":                    {reflect.TypeOf(q.EDQUOT), constant.MakeInt64(int64(q.EDQUOT))},
			"EEXIST":                    {reflect.TypeOf(q.EEXIST), constant.MakeInt64(int64(q.EEXIST))},
			"EFAULT":                    {reflect.TypeOf(q.EFAULT), constant.MakeInt64(int64(q.EFAULT))},
			"EFBIG":                     {reflect.TypeOf(q.EFBIG), constant.MakeInt64(int64(q.EFBIG))},
			"EHOSTDOWN":                 {reflect.TypeOf(q.EHOSTDOWN), constant.MakeInt64(int64(q.EHOSTDOWN))},
			"EHOSTUNREACH":              {reflect.TypeOf(q.EHOSTUNREACH), constant.MakeInt64(int64(q.EHOSTUNREACH))},
			"EIDRM":                     {reflect.TypeOf(q.EIDRM), constant.MakeInt64(int64(q.EIDRM))},
			"EILSEQ":                    {reflect.TypeOf(q.EILSEQ), constant.MakeInt64(int64(q.EILSEQ))},
			"EINPROGRESS":               {reflect.TypeOf(q.EINPROGRESS), constant.MakeInt64(int64(q.EINPROGRESS))},
			"EINTR":                     {reflect.TypeOf(q.EINTR), constant.MakeInt64(int64(q.EINTR))},
			"EINVAL":                    {reflect.TypeOf(q.EINVAL), constant.MakeInt64(int64(q.EINVAL))},
			"EIO":                       {reflect.TypeOf(q.EIO), constant.MakeInt64(int64(q.EIO))},
			"EISCONN":                   {reflect.TypeOf(q.EISCONN), constant.MakeInt64(int64(q.EISCONN))},
			"EISDIR":                    {reflect.TypeOf(q.EISDIR), constant.MakeInt64(int64(q.EISDIR))},
			"EISNAM":                    {reflect.TypeOf(q.EISNAM), constant.MakeInt64(int64(q.EISNAM))},
			"EKEYEXPIRED":               {reflect.TypeOf(q.EKEYEXPIRED), constant.MakeInt64(int64(q.EKEYEXPIRED))},
			"EKEYREJECTED":              {reflect.TypeOf(q.EKEYREJECTED), constant.MakeInt64(int64(q.EKEYREJECTED))},
			"EKEYREVOKED":               {reflect.TypeOf(q.EKEYREVOKED), constant.MakeInt64(int64(q.EKEYREVOKED))},
			"EL2HLT":                    {reflect.TypeOf(q.EL2HLT), constant.MakeInt64(int64(q.EL2HLT))},
			"EL2NSYNC":                  {reflect.TypeOf(q.EL2NSYNC), constant.MakeInt64(int64(q.EL2NSYNC))},
			"EL3HLT":                    {reflect.TypeOf(q.EL3HLT), constant.MakeInt64(int64(q.EL3HLT))},
			"EL3RST":                    {reflect.TypeOf(q.EL3RST), constant.MakeInt64(int64(q.EL3RST))},
			"ELIBACC":                   {reflect.TypeOf(q.ELIBACC), constant.MakeInt64(int64(q.ELIBACC))},
			"ELIBBAD":                   {reflect.TypeOf(q.ELIBBAD), constant.MakeInt64(int64(q.ELIBBAD))},
			"ELIBEXEC":                  {reflect.TypeOf(q.ELIBEXEC), constant.MakeInt64(int64(q.ELIBEXEC))},
			"ELIBMAX":                   {reflect.TypeOf(q.ELIBMAX), constant.MakeInt64(int64(q.ELIBMAX))},
			"ELIBSCN":                   {reflect.TypeOf(q.ELIBSCN), constant.MakeInt64(int64(q.ELIBSCN))},
			"ELNRNG":                    {reflect.TypeOf(q.ELNRNG), constant.MakeInt64(int64(q.ELNRNG))},
			"ELOOP":                     {reflect.TypeOf(q.ELOOP), constant.MakeInt64(int64(q.ELOOP))},
			"EMEDIUMTYPE":               {reflect.TypeOf(q.EMEDIUMTYPE), constant.MakeInt64(int64(q.EMEDIUMTYPE))},
			"EMFILE":                    {reflect.TypeOf(q.EMFILE), constant.MakeInt64(int64(q.EMFILE))},
			"EMLINK":                    {reflect.TypeOf(q.EMLINK), constant.MakeInt64(int64(q.EMLINK))},
			"EMSGSIZE":                  {reflect.TypeOf(q.EMSGSIZE), constant.MakeInt64(int64(q.EMSGSIZE))},
			"EMULTIHOP":                 {reflect.TypeOf(q.EMULTIHOP), constant.MakeInt64(int64(q.EMULTIHOP))},
			"ENAMETOOLONG":              {reflect.TypeOf(q.ENAMETOOLONG), constant.MakeInt64(int64(q.ENAMETOOLONG))},
			"ENAVAIL":                   {reflect.TypeOf(q.ENAVAIL), constant.MakeInt64(int64(q.ENAVAIL))},
			"ENETDOWN":                  {reflect.TypeOf(q.ENETDOWN), constant.MakeInt64(int64(q.ENETDOWN))},
			"ENETRESET":                 {reflect.TypeOf(q.ENETRESET), constant.MakeInt64(int64(q.ENETRESET))},
			"ENETUNREACH":               {reflect.TypeOf(q.ENETUNREACH), constant.MakeInt64(int64(q.ENETUNREACH))},
			"ENFILE":                    {reflect.TypeOf(q.ENFILE), constant.MakeInt64(int64(q.ENFILE))},
			"ENOANO":                    {reflect.TypeOf(q.ENOANO), constant.MakeInt64(int64(q.ENOANO))},
			"ENOBUFS":                   {reflect.TypeOf(q.ENOBUFS), constant.MakeInt64(int64(q.ENOBUFS))},
			"ENOCSI":                    {reflect.TypeOf(q.ENOCSI), constant.MakeInt64(int64(q.ENOCSI))},
			"ENODATA":                   {reflect.TypeOf(q.ENODATA), constant.MakeInt64(int64(q.ENODATA))},
			"ENODEV":                    {reflect.TypeOf(q.ENODEV), constant.MakeInt64(int64(q.ENODEV))},
			"ENOENT":                    {reflect.TypeOf(q.ENOENT), constant.MakeInt64(int64(q.ENOENT))},
			"ENOEXEC":                   {reflect.TypeOf(q.ENOEXEC), constant.MakeInt64(int64(q.ENOEXEC))},
			"ENOKEY":                    {reflect.TypeOf(q.ENOKEY), constant.MakeInt64(int64(q.ENOKEY))},
			"ENOLCK":                    {reflect.TypeOf(q.ENOLCK), constant.MakeInt64(int64(q.ENOLCK))},
			"ENOLINK":                   {reflect.TypeOf(q.ENOLINK), constant.MakeInt64(int64(q.ENOLINK))},
			"ENOMEDIUM":                 {reflect.TypeOf(q.ENOMEDIUM), constant.MakeInt64(int64(q.ENOMEDIUM))},
			"ENOMEM":                    {reflect.TypeOf(q.ENOMEM), constant.MakeInt64(int64(q.ENOMEM))},
			"ENOMSG":                    {reflect.TypeOf(q.ENOMSG), constant.MakeInt64(int64(q.ENOMSG))},
			"ENONET":                    {reflect.TypeOf(q.ENONET), constant.MakeInt64(int64(q.ENONET))},
			"ENOPKG":                    {reflect.TypeOf(q.ENOPKG), constant.MakeInt64(int64(q.ENOPKG))},
			"ENOPROTOOPT":               {reflect.TypeOf(q.ENOPROTOOPT), constant.MakeInt64(int64(q.ENOPROTOOPT))},
			"ENOSPC":                    {reflect.TypeOf(q.ENOSPC), constant.MakeInt64(int64(q.ENOSPC))},
			"ENOSR":                     {reflect.TypeOf(q.ENOSR), constant.MakeInt64(int64(q.ENOSR))},
			"ENOSTR":                    {reflect.TypeOf(q.ENOSTR), constant.MakeInt64(int64(q.ENOSTR))},
			"ENOSYS":                    {reflect.TypeOf(q.ENOSYS), constant.MakeInt64(int64(q.ENOSYS))},
			"ENOTBLK":                   {reflect.TypeOf(q.ENOTBLK), constant.MakeInt64(int64(q.ENOTBLK))},
			"ENOTCONN":                  {reflect.TypeOf(q.ENOTCONN), constant.MakeInt64(int64(q.ENOTCONN))},
			"ENOTDIR":                   {reflect.TypeOf(q.ENOTDIR), constant.MakeInt64(int64(q.ENOTDIR))},
			"ENOTEMPTY":                 {reflect.TypeOf(q.ENOTEMPTY), constant.MakeInt64(int64(q.ENOTEMPTY))},
			"ENOTNAM":                   {reflect.TypeOf(q.ENOTNAM), constant.MakeInt64(int64(q.ENOTNAM))},
			"ENOTRECOVERABLE":           {reflect.TypeOf(q.ENOTRECOVERABLE), constant.MakeInt64(int64(q.ENOTRECOVERABLE))},
			"ENOTSOCK":                  {reflect.TypeOf(q.ENOTSOCK), constant.MakeInt64(int64(q.ENOTSOCK))},
			"ENOTSUP":                   {reflect.TypeOf(q.ENOTSUP), constant.MakeInt64(int64(q.ENOTSUP))},
			"ENOTTY":                    {reflect.TypeOf(q.ENOTTY), constant.MakeInt64(int64(q.ENOTTY))},
			"ENOTUNIQ":                  {reflect.TypeOf(q.ENOTUNIQ), constant.MakeInt64(int64(q.ENOTUNIQ))},
			"ENXIO":                     {reflect.TypeOf(q.ENXIO), constant.MakeInt64(int64(q.ENXIO))},
			"EOPNOTSUPP":                {reflect.TypeOf(q.EOPNOTSUPP), constant.MakeInt64(int64(q.EOPNOTSUPP))},
			"EOVERFLOW":                 {reflect.TypeOf(q.EOVERFLOW), constant.MakeInt64(int64(q.EOVERFLOW))},
			"EOWNERDEAD":                {reflect.TypeOf(q.EOWNERDEAD), constant.MakeInt64(int64(q.EOWNERDEAD))},
			"EPERM":                     {reflect.TypeOf(q.EPERM), constant.MakeInt64(int64(q.EPERM))},
			"EPFNOSUPPORT":              {reflect.TypeOf(q.EPFNOSUPPORT), constant.MakeInt64(int64(q.EPFNOSUPPORT))},
			"EPIPE":                     {reflect.TypeOf(q.EPIPE), constant.MakeInt64(int64(q.EPIPE))},
			"EPROTO":                    {reflect.TypeOf(q.EPROTO), constant.MakeInt64(int64(q.EPROTO))},
			"EPROTONOSUPPORT":           {reflect.TypeOf(q.EPROTONOSUPPORT), constant.MakeInt64(int64(q.EPROTONOSUPPORT))},
			"EPROTOTYPE":                {reflect.TypeOf(q.EPROTOTYPE), constant.MakeInt64(int64(q.EPROTOTYPE))},
			"ERANGE":                    {reflect.TypeOf(q.ERANGE), constant.MakeInt64(int64(q.ERANGE))},
			"EREMCHG":                   {reflect.TypeOf(q.EREMCHG), constant.MakeInt64(int64(q.EREMCHG))},
			"EREMOTE":                   {reflect.TypeOf(q.EREMOTE), constant.MakeInt64(int64(q.EREMOTE))},
			"EREMOTEIO":                 {reflect.TypeOf(q.EREMOTEIO), constant.MakeInt64(int64(q.EREMOTEIO))},
			"ERESTART":                  {reflect.TypeOf(q.ERESTART), constant.MakeInt64(int64(q.ERESTART))},
			"EROFS":                     {reflect.TypeOf(q.EROFS), constant.MakeInt64(int64(q.EROFS))},
			"ERROR_ACCESS_DENIED":       {reflect.TypeOf(q.ERROR_ACCESS_DENIED), constant.MakeInt64(int64(q.ERROR_ACCESS_DENIED))},
			"ERROR_ALREADY_EXISTS":      {reflect.TypeOf(q.ERROR_ALREADY_EXISTS), constant.MakeInt64(int64(q.ERROR_ALREADY_EXISTS))},
			"ERROR_BROKEN_PIPE":         {reflect.TypeOf(q.ERROR_BROKEN_PIPE), constant.MakeInt64(int64(q.ERROR_BROKEN_PIPE))},
			"ERROR_BUFFER_OVERFLOW":     {reflect.TypeOf(q.ERROR_BUFFER_OVERFLOW), constant.MakeInt64(int64(q.ERROR_BUFFER_OVERFLOW))},
			"ERROR_DIR_NOT_EMPTY":       {reflect.TypeOf(q.ERROR_DIR_NOT_EMPTY), constant.MakeInt64(int64(q.ERROR_DIR_NOT_EMPTY))},
			"ERROR_ENVVAR_NOT_FOUND":    {reflect.TypeOf(q.ERROR_ENVVAR_NOT_FOUND), constant.MakeInt64(int64(q.ERROR_ENVVAR_NOT_FOUND))},
			"ERROR_FILE_EXISTS":         {reflect.TypeOf(q.ERROR_FILE_EXISTS), constant.MakeInt64(int64(q.ERROR_FILE_EXISTS))},
			"ERROR_FILE_NOT_FOUND":      {reflect.TypeOf(q.ERROR_FILE_NOT_FOUND), constant.MakeInt64(int64(q.ERROR_FILE_NOT_FOUND))},
			"ERROR_HANDLE_EOF":          {reflect.TypeOf(q.ERROR_HANDLE_EOF), constant.MakeInt64(int64(q.ERROR_HANDLE_EOF))},
			"ERROR_INSUFFICIENT_BUFFER": {reflect.TypeOf(q.ERROR_INSUFFICIENT_BUFFER), constant.MakeInt64(int64(q.ERROR_INSUFFICIENT_BUFFER))},
			"ERROR_IO_PENDING":          {reflect.TypeOf(q.ERROR_IO_PENDING), constant.MakeInt64(int64(q.ERROR_IO_PENDING))},
			"ERROR_MOD_NOT_FOUND":       {reflect.TypeOf(q.ERROR_MOD_NOT_FOUND), constant.MakeInt64(int64(q.ERROR_MOD_NOT_FOUND))},
			"ERROR_MORE_DATA":           {reflect.TypeOf(q.ERROR_MORE_DATA), constant.MakeInt64(int64(q.ERROR_MORE_DATA))},
			"ERROR_NETNAME_DELETED":     {reflect.TypeOf(q.ERROR_NETNAME_DELETED), constant.MakeInt64(int64(q.ERROR_NETNAME_DELETED))},
			"ERROR_NOT_FOUND":           {reflect.TypeOf(q.ERROR_NOT_FOUND), constant.MakeInt64(int64(q.ERROR_NOT_FOUND))},
			"ERROR_NO_MORE_FILES":       {reflect.TypeOf(q.ERROR_NO_MORE_FILES), constant.MakeInt64(int64(q.ERROR_NO_MORE_FILES))},
			"ERROR_OPERATION_ABORTED":   {reflect.TypeOf(q.ERROR_OPERATION_ABORTED), constant.MakeInt64(int64(q.ERROR_OPERATION_ABORTED))},
			"ERROR_PATH_NOT_FOUND":      {reflect.TypeOf(q.ERROR_PATH_NOT_FOUND), constant.MakeInt64(int64(q.ERROR_PATH_NOT_FOUND))},
			"ERROR_PRIVILEGE_NOT_HELD":  {reflect.TypeOf(q.ERROR_PRIVILEGE_NOT_HELD), constant.MakeInt64(int64(q.ERROR_PRIVILEGE_NOT_HELD))},
			"ERROR_PROC_NOT_FOUND":      {reflect.TypeOf(q.ERROR_PROC_NOT_FOUND), constant.MakeInt64(int64(q.ERROR_PROC_NOT_FOUND))},
			"ESHUTDOWN":                 {reflect.TypeOf(q.ESHUTDOWN), constant.MakeInt64(int64(q.ESHUTDOWN))},
			"ESOCKTNOSUPPORT":           {reflect.TypeOf(q.ESOCKTNOSUPPORT), constant.MakeInt64(int64(q.ESOCKTNOSUPPORT))},
			"ESPIPE":                    {reflect.TypeOf(q.ESPIPE), constant.MakeInt64(int64(q.ESPIPE))},
			"ESRCH":                     {reflect.TypeOf(q.ESRCH), constant.MakeInt64(int64(q.ESRCH))},
			"ESRMNT":                    {reflect.TypeOf(q.ESRMNT), constant.MakeInt64(int64(q.ESRMNT))},
			"ESTALE":                    {reflect.TypeOf(q.ESTALE), constant.MakeInt64(int64(q.ESTALE))},
			"ESTRPIPE":                  {reflect.TypeOf(q.ESTRPIPE), constant.MakeInt64(int64(q.ESTRPIPE))},
			"ETIME":                     {reflect.TypeOf(q.ETIME), constant.MakeInt64(int64(q.ETIME))},
			"ETIMEDOUT":                 {reflect.TypeOf(q.ETIMEDOUT), constant.MakeInt64(int64(q.ETIMEDOUT))},
			"ETOOMANYREFS":              {reflect.TypeOf(q.ETOOMANYREFS), constant.MakeInt64(int64(q.ETOOMANYREFS))},
			"ETXTBSY":                   {reflect.TypeOf(q.ETXTBSY), constant.MakeInt64(int64(q.ETXTBSY))},
			"EUCLEAN":                   {reflect.TypeOf(q.EUCLEAN), constant.MakeInt64(int64(q.EUCLEAN))},
			"EUNATCH":                   {reflect.TypeOf(q.EUNATCH), constant.MakeInt64(int64(q.EUNATCH))},
			"EUSERS":                    {reflect.TypeOf(q.EUSERS), constant.MakeInt64(int64(q.EUSERS))},
			"EWINDOWS":                  {reflect.TypeOf(q.EWINDOWS), constant.MakeInt64(int64(q.EWINDOWS))},
			"EWOULDBLOCK":               {reflect.TypeOf(q.EWOULDBLOCK), constant.MakeInt64(int64(q.EWOULDBLOCK))},
			"EXDEV":                     {reflect.TypeOf(q.EXDEV), constant.MakeInt64(int64(q.EXDEV))},
			"EXFULL":                    {reflect.TypeOf(q.EXFULL), constant.MakeInt64(int64(q.EXFULL))},
			"InvalidHandle":             {reflect.TypeOf(q.InvalidHandle), constant.MakeUint64(uint64(q.InvalidHandle))},
			"SIGABRT":                   {reflect.TypeOf(q.SIGABRT), constant.MakeInt64(int64(q.SIGABRT))},
			"SIGALRM":                   {reflect.TypeOf(q.SIGALRM), constant.MakeInt64(int64(q.SIGALRM))},
			"SIGBUS":                    {reflect.TypeOf(q.SIGBUS), constant.MakeInt64(int64(q.SIGBUS))},
			"SIGFPE":                    {reflect.TypeOf(q.SIGFPE), constant.MakeInt64(int64(q.SIGFPE))},
			"SIGHUP":                    {reflect.TypeOf(q.SIGHUP), constant.MakeInt64(int64(q.SIGHUP))},
			"SIGILL":                    {reflect.TypeOf(q.SIGILL), constant.MakeInt64(int64(q.SIGILL))},
			"SIGINT":                    {reflect.TypeOf(q.SIGINT), constant.MakeInt64(int64(q.SIGINT))},
			"SIGKILL":                   {reflect.TypeOf(q.SIGKILL), constant.MakeInt64(int64(q.SIGKILL))},
			"SIGPIPE":                   {reflect.TypeOf(q.SIGPIPE), constant.MakeInt64(int64(q.SIGPIPE))},
			"SIGQUIT":                   {reflect.TypeOf(q.SIGQUIT), constant.MakeInt64(int64(q.SIGQUIT))},
			"SIGSEGV":                   {reflect.TypeOf(q.SIGSEGV), constant.MakeInt64(int64(q.SIGSEGV))},
			"SIGTERM":                   {reflect.TypeOf(q.SIGTERM), constant.MakeInt64(int64(q.SIGTERM))},
			"SIGTRAP":                   {reflect.TypeOf(q.SIGTRAP), constant.MakeInt64(int64(q.SIGTRAP))},
			"WSAEACCES":                 {reflect.TypeOf(q.WSAEACCES), constant.MakeInt64(int64(q.WSAEACCES))},
			"WSAECONNABORTED":           {reflect.TypeOf(q.WSAECONNABORTED), constant.MakeInt64(int64(q.WSAECONNABORTED))},
			"WSAECONNRESET":             {reflect.TypeOf(q.WSAECONNRESET), constant.MakeInt64(int64(q.WSAECONNRESET))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"AF_INET":                             {"untyped int", constant.MakeInt64(int64(q.AF_INET))},
			"AF_INET6":                            {"untyped int", constant.MakeInt64(int64(q.AF_INET6))},
			"AF_NETBIOS":                          {"untyped int", constant.MakeInt64(int64(q.AF_NETBIOS))},
			"AF_UNIX":                             {"untyped int", constant.MakeInt64(int64(q.AF_UNIX))},
			"AF_UNSPEC":                           {"untyped int", constant.MakeInt64(int64(q.AF_UNSPEC))},
			"AI_CANONNAME":                        {"untyped int", constant.MakeInt64(int64(q.AI_CANONNAME))},
			"AI_NUMERICHOST":                      {"untyped int", constant.MakeInt64(int64(q.AI_NUMERICHOST))},
			"AI_PASSIVE":                          {"untyped int", constant.MakeInt64(int64(q.AI_PASSIVE))},
			"APPLICATION_ERROR":                   {"untyped int", constant.MakeInt64(int64(q.APPLICATION_ERROR))},
			"AUTHTYPE_CLIENT":                     {"untyped int", constant.MakeInt64(int64(q.AUTHTYPE_CLIENT))},
			"AUTHTYPE_SERVER":                     {"untyped int", constant.MakeInt64(int64(q.AUTHTYPE_SERVER))},
			"BASE_PROTOCOL":                       {"untyped int", constant.MakeInt64(int64(q.BASE_PROTOCOL))},
			"CERT_CHAIN_POLICY_AUTHENTICODE":      {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_AUTHENTICODE))},
			"CERT_CHAIN_POLICY_AUTHENTICODE_TS":   {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_AUTHENTICODE_TS))},
			"CERT_CHAIN_POLICY_BASE":              {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_BASE))},
			"CERT_CHAIN_POLICY_BASIC_CONSTRAINTS": {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_BASIC_CONSTRAINTS))},
			"CERT_CHAIN_POLICY_EV":                {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_EV))},
			"CERT_CHAIN_POLICY_MICROSOFT_ROOT":    {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_MICROSOFT_ROOT))},
			"CERT_CHAIN_POLICY_NT_AUTH":           {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_NT_AUTH))},
			"CERT_CHAIN_POLICY_SSL":               {"untyped int", constant.MakeInt64(int64(q.CERT_CHAIN_POLICY_SSL))},
			"CERT_E_CN_NO_MATCH":                  {"untyped int", constant.MakeInt64(int64(q.CERT_E_CN_NO_MATCH))},
			"CERT_E_EXPIRED":                      {"untyped int", constant.MakeInt64(int64(q.CERT_E_EXPIRED))},
			"CERT_E_PURPOSE":                      {"untyped int", constant.MakeInt64(int64(q.CERT_E_PURPOSE))},
			"CERT_E_ROLE":                         {"untyped int", constant.MakeInt64(int64(q.CERT_E_ROLE))},
			"CERT_E_UNTRUSTEDROOT":                {"untyped int", constant.MakeInt64(int64(q.CERT_E_UNTRUSTEDROOT))},
			"CERT_STORE_ADD_ALWAYS":               {"untyped int", constant.MakeInt64(int64(q.CERT_STORE_ADD_ALWAYS))},
			"CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG":  {"untyped int", constant.MakeInt64(int64(q.CERT_STORE_DEFER_CLOSE_UNTIL_LAST_FREE_FLAG))},
			"CERT_STORE_PROV_MEMORY":                       {"untyped int", constant.MakeInt64(int64(q.CERT_STORE_PROV_MEMORY))},
			"CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT":      {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_HAS_EXCLUDED_NAME_CONSTRAINT))},
			"CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT":   {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_HAS_NOT_DEFINED_NAME_CONSTRAINT))},
			"CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT": {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_HAS_NOT_PERMITTED_NAME_CONSTRAINT))},
			"CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT":    {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_HAS_NOT_SUPPORTED_CRITICAL_EXT))},
			"CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT": {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_HAS_NOT_SUPPORTED_NAME_CONSTRAINT))},
			"CERT_TRUST_INVALID_BASIC_CONSTRAINTS":         {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_INVALID_BASIC_CONSTRAINTS))},
			"CERT_TRUST_INVALID_EXTENSION":                 {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_INVALID_EXTENSION))},
			"CERT_TRUST_INVALID_NAME_CONSTRAINTS":          {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_INVALID_NAME_CONSTRAINTS))},
			"CERT_TRUST_INVALID_POLICY_CONSTRAINTS":        {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_INVALID_POLICY_CONSTRAINTS))},
			"CERT_TRUST_IS_CYCLIC":                         {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_CYCLIC))},
			"CERT_TRUST_IS_EXPLICIT_DISTRUST":              {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_EXPLICIT_DISTRUST))},
			"CERT_TRUST_IS_NOT_SIGNATURE_VALID":            {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_NOT_SIGNATURE_VALID))},
			"CERT_TRUST_IS_NOT_TIME_VALID":                 {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_NOT_TIME_VALID))},
			"CERT_TRUST_IS_NOT_VALID_FOR_USAGE":            {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_NOT_VALID_FOR_USAGE))},
			"CERT_TRUST_IS_OFFLINE_REVOCATION":             {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_OFFLINE_REVOCATION))},
			"CERT_TRUST_IS_REVOKED":                        {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_REVOKED))},
			"CERT_TRUST_IS_UNTRUSTED_ROOT":                 {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_IS_UNTRUSTED_ROOT))},
			"CERT_TRUST_NO_ERROR":                          {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_NO_ERROR))},
			"CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY":          {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_NO_ISSUANCE_CHAIN_POLICY))},
			"CERT_TRUST_REVOCATION_STATUS_UNKNOWN":         {"untyped int", constant.MakeInt64(int64(q.CERT_TRUST_REVOCATION_STATUS_UNKNOWN))},
			"CREATE_ALWAYS":                                {"untyped int", constant.MakeInt64(int64(q.CREATE_ALWAYS))},
			"CREATE_NEW":                                   {"untyped int", constant.MakeInt64(int64(q.CREATE_NEW))},
			"CREATE_NEW_PROCESS_GROUP":                     {"untyped int", constant.MakeInt64(int64(q.CREATE_NEW_PROCESS_GROUP))},
			"CREATE_UNICODE_ENVIRONMENT":                   {"untyped int", constant.MakeInt64(int64(q.CREATE_UNICODE_ENVIRONMENT))},
			"CRYPT_DEFAULT_CONTAINER_OPTIONAL":             {"untyped int", constant.MakeInt64(int64(q.CRYPT_DEFAULT_CONTAINER_OPTIONAL))},
			"CRYPT_DELETEKEYSET":                           {"untyped int", constant.MakeInt64(int64(q.CRYPT_DELETEKEYSET))},
			"CRYPT_MACHINE_KEYSET":                         {"untyped int", constant.MakeInt64(int64(q.CRYPT_MACHINE_KEYSET))},
			"CRYPT_NEWKEYSET":                              {"untyped int", constant.MakeInt64(int64(q.CRYPT_NEWKEYSET))},
			"CRYPT_SILENT":                                 {"untyped int", constant.MakeInt64(int64(q.CRYPT_SILENT))},
			"CRYPT_VERIFYCONTEXT":                          {"untyped int", constant.MakeInt64(int64(q.CRYPT_VERIFYCONTEXT))},
			"CTRL_BREAK_EVENT":                             {"untyped int", constant.MakeInt64(int64(q.CTRL_BREAK_EVENT))},
			"CTRL_CLOSE_EVENT":                             {"untyped int", constant.MakeInt64(int64(q.CTRL_CLOSE_EVENT))},
			"CTRL_C_EVENT":                                 {"untyped int", constant.MakeInt64(int64(q.CTRL_C_EVENT))},
			"CTRL_LOGOFF_EVENT":                            {"untyped int", constant.MakeInt64(int64(q.CTRL_LOGOFF_EVENT))},
			"CTRL_SHUTDOWN_EVENT":                          {"untyped int", constant.MakeInt64(int64(q.CTRL_SHUTDOWN_EVENT))},
			"DNS_INFO_NO_RECORDS":                          {"untyped int", constant.MakeInt64(int64(q.DNS_INFO_NO_RECORDS))},
			"DNS_TYPE_A":                                   {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_A))},
			"DNS_TYPE_A6":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_A6))},
			"DNS_TYPE_AAAA":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_AAAA))},
			"DNS_TYPE_ADDRS":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_ADDRS))},
			"DNS_TYPE_AFSDB":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_AFSDB))},
			"DNS_TYPE_ALL":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_ALL))},
			"DNS_TYPE_ANY":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_ANY))},
			"DNS_TYPE_ATMA":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_ATMA))},
			"DNS_TYPE_AXFR":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_AXFR))},
			"DNS_TYPE_CERT":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_CERT))},
			"DNS_TYPE_CNAME":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_CNAME))},
			"DNS_TYPE_DHCID":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_DHCID))},
			"DNS_TYPE_DNAME":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_DNAME))},
			"DNS_TYPE_DNSKEY":                              {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_DNSKEY))},
			"DNS_TYPE_DS":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_DS))},
			"DNS_TYPE_EID":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_EID))},
			"DNS_TYPE_GID":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_GID))},
			"DNS_TYPE_GPOS":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_GPOS))},
			"DNS_TYPE_HINFO":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_HINFO))},
			"DNS_TYPE_ISDN":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_ISDN))},
			"DNS_TYPE_IXFR":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_IXFR))},
			"DNS_TYPE_KEY":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_KEY))},
			"DNS_TYPE_KX":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_KX))},
			"DNS_TYPE_LOC":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_LOC))},
			"DNS_TYPE_MAILA":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MAILA))},
			"DNS_TYPE_MAILB":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MAILB))},
			"DNS_TYPE_MB":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MB))},
			"DNS_TYPE_MD":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MD))},
			"DNS_TYPE_MF":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MF))},
			"DNS_TYPE_MG":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MG))},
			"DNS_TYPE_MINFO":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MINFO))},
			"DNS_TYPE_MR":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MR))},
			"DNS_TYPE_MX":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_MX))},
			"DNS_TYPE_NAPTR":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NAPTR))},
			"DNS_TYPE_NBSTAT":                              {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NBSTAT))},
			"DNS_TYPE_NIMLOC":                              {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NIMLOC))},
			"DNS_TYPE_NS":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NS))},
			"DNS_TYPE_NSAP":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NSAP))},
			"DNS_TYPE_NSAPPTR":                             {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NSAPPTR))},
			"DNS_TYPE_NSEC":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NSEC))},
			"DNS_TYPE_NULL":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NULL))},
			"DNS_TYPE_NXT":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_NXT))},
			"DNS_TYPE_OPT":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_OPT))},
			"DNS_TYPE_PTR":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_PTR))},
			"DNS_TYPE_PX":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_PX))},
			"DNS_TYPE_RP":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_RP))},
			"DNS_TYPE_RRSIG":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_RRSIG))},
			"DNS_TYPE_RT":                                  {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_RT))},
			"DNS_TYPE_SIG":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_SIG))},
			"DNS_TYPE_SINK":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_SINK))},
			"DNS_TYPE_SOA":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_SOA))},
			"DNS_TYPE_SRV":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_SRV))},
			"DNS_TYPE_TEXT":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_TEXT))},
			"DNS_TYPE_TKEY":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_TKEY))},
			"DNS_TYPE_TSIG":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_TSIG))},
			"DNS_TYPE_UID":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_UID))},
			"DNS_TYPE_UINFO":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_UINFO))},
			"DNS_TYPE_UNSPEC":                              {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_UNSPEC))},
			"DNS_TYPE_WINS":                                {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_WINS))},
			"DNS_TYPE_WINSR":                               {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_WINSR))},
			"DNS_TYPE_WKS":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_WKS))},
			"DNS_TYPE_X25":                                 {"untyped int", constant.MakeInt64(int64(q.DNS_TYPE_X25))},
			"DUPLICATE_CLOSE_SOURCE":                       {"untyped int", constant.MakeInt64(int64(q.DUPLICATE_CLOSE_SOURCE))},
			"DUPLICATE_SAME_ACCESS":                        {"untyped int", constant.MakeInt64(int64(q.DUPLICATE_SAME_ACCESS))},
			"DnsSectionAdditional":                         {"untyped int", constant.MakeInt64(int64(q.DnsSectionAdditional))},
			"DnsSectionAnswer":                             {"untyped int", constant.MakeInt64(int64(q.DnsSectionAnswer))},
			"DnsSectionAuthority":                          {"untyped int", constant.MakeInt64(int64(q.DnsSectionAuthority))},
			"DnsSectionQuestion":                           {"untyped int", constant.MakeInt64(int64(q.DnsSectionQuestion))},
			"FILE_ACTION_ADDED":                            {"untyped int", constant.MakeInt64(int64(q.FILE_ACTION_ADDED))},
			"FILE_ACTION_MODIFIED":                         {"untyped int", constant.MakeInt64(int64(q.FILE_ACTION_MODIFIED))},
			"FILE_ACTION_REMOVED":                          {"untyped int", constant.MakeInt64(int64(q.FILE_ACTION_REMOVED))},
			"FILE_ACTION_RENAMED_NEW_NAME":                 {"untyped int", constant.MakeInt64(int64(q.FILE_ACTION_RENAMED_NEW_NAME))},
			"FILE_ACTION_RENAMED_OLD_NAME":                 {"untyped int", constant.MakeInt64(int64(q.FILE_ACTION_RENAMED_OLD_NAME))},
			"FILE_APPEND_DATA":                             {"untyped int", constant.MakeInt64(int64(q.FILE_APPEND_DATA))},
			"FILE_ATTRIBUTE_ARCHIVE":                       {"untyped int", constant.MakeInt64(int64(q.FILE_ATTRIBUTE_ARCHIVE))},
			"FILE_ATTRIBUTE_DIRECTORY":                     {"untyped int", constant.MakeInt64(int64(q.FILE_ATTRIBUTE_DIRECTORY))},
			"FILE_ATTRIBUTE_HIDDEN":                        {"untyped int", constant.MakeInt64(int64(q.FILE_ATTRIBUTE_HIDDEN))},
			"FILE_ATTRIBUTE_NORMAL":                        {"untyped int", constant.MakeInt64(int64(q.FILE_ATTRIBUTE_NORMAL))},
			"FILE_ATTRIBUTE_READONLY":                      {"untyped int", constant.MakeInt64(int64(q.FILE_ATTRIBUTE_READONLY))},
			"FILE_ATTRIBUTE_REPARSE_POINT":                 {"untyped int", constant.MakeInt64(int64(q.FILE_ATTRIBUTE_REPARSE_POINT))},
			"FILE_ATTRIBUTE_SYSTEM":                        {"untyped int", constant.MakeInt64(int64(q.FILE_ATTRIBUTE_SYSTEM))},
			"FILE_BEGIN":                                   {"untyped int", constant.MakeInt64(int64(q.FILE_BEGIN))},
			"FILE_CURRENT":                                 {"untyped int", constant.MakeInt64(int64(q.FILE_CURRENT))},
			"FILE_END":                                     {"untyped int", constant.MakeInt64(int64(q.FILE_END))},
			"FILE_FLAG_BACKUP_SEMANTICS":                   {"untyped int", constant.MakeInt64(int64(q.FILE_FLAG_BACKUP_SEMANTICS))},
			"FILE_FLAG_OPEN_REPARSE_POINT":                 {"untyped int", constant.MakeInt64(int64(q.FILE_FLAG_OPEN_REPARSE_POINT))},
			"FILE_FLAG_OVERLAPPED":                         {"untyped int", constant.MakeInt64(int64(q.FILE_FLAG_OVERLAPPED))},
			"FILE_LIST_DIRECTORY":                          {"untyped int", constant.MakeInt64(int64(q.FILE_LIST_DIRECTORY))},
			"FILE_MAP_COPY":                                {"untyped int", constant.MakeInt64(int64(q.FILE_MAP_COPY))},
			"FILE_MAP_EXECUTE":                             {"untyped int", constant.MakeInt64(int64(q.FILE_MAP_EXECUTE))},
			"FILE_MAP_READ":                                {"untyped int", constant.MakeInt64(int64(q.FILE_MAP_READ))},
			"FILE_MAP_WRITE":                               {"untyped int", constant.MakeInt64(int64(q.FILE_MAP_WRITE))},
			"FILE_NOTIFY_CHANGE_ATTRIBUTES":                {"untyped int", constant.MakeInt64(int64(q.FILE_NOTIFY_CHANGE_ATTRIBUTES))},
			"FILE_NOTIFY_CHANGE_CREATION":                  {"untyped int", constant.MakeInt64(int64(q.FILE_NOTIFY_CHANGE_CREATION))},
			"FILE_NOTIFY_CHANGE_DIR_NAME":                  {"untyped int", constant.MakeInt64(int64(q.FILE_NOTIFY_CHANGE_DIR_NAME))},
			"FILE_NOTIFY_CHANGE_FILE_NAME":                 {"untyped int", constant.MakeInt64(int64(q.FILE_NOTIFY_CHANGE_FILE_NAME))},
			"FILE_NOTIFY_CHANGE_LAST_ACCESS":               {"untyped int", constant.MakeInt64(int64(q.FILE_NOTIFY_CHANGE_LAST_ACCESS))},
			"FILE_NOTIFY_CHANGE_LAST_WRITE":                {"untyped int", constant.MakeInt64(int64(q.FILE_NOTIFY_CHANGE_LAST_WRITE))},
			"FILE_NOTIFY_CHANGE_SIZE":                      {"untyped int", constant.MakeInt64(int64(q.FILE_NOTIFY_CHANGE_SIZE))},
			"FILE_SHARE_DELETE":                            {"untyped int", constant.MakeInt64(int64(q.FILE_SHARE_DELETE))},
			"FILE_SHARE_READ":                              {"untyped int", constant.MakeInt64(int64(q.FILE_SHARE_READ))},
			"FILE_SHARE_WRITE":                             {"untyped int", constant.MakeInt64(int64(q.FILE_SHARE_WRITE))},
			"FILE_SKIP_COMPLETION_PORT_ON_SUCCESS":         {"untyped int", constant.MakeInt64(int64(q.FILE_SKIP_COMPLETION_PORT_ON_SUCCESS))},
			"FILE_SKIP_SET_EVENT_ON_HANDLE":                {"untyped int", constant.MakeInt64(int64(q.FILE_SKIP_SET_EVENT_ON_HANDLE))},
			"FILE_TYPE_CHAR":                               {"untyped int", constant.MakeInt64(int64(q.FILE_TYPE_CHAR))},
			"FILE_TYPE_DISK":                               {"untyped int", constant.MakeInt64(int64(q.FILE_TYPE_DISK))},
			"FILE_TYPE_PIPE":                               {"untyped int", constant.MakeInt64(int64(q.FILE_TYPE_PIPE))},
			"FILE_TYPE_REMOTE":                             {"untyped int", constant.MakeInt64(int64(q.FILE_TYPE_REMOTE))},
			"FILE_TYPE_UNKNOWN":                            {"untyped int", constant.MakeInt64(int64(q.FILE_TYPE_UNKNOWN))},
			"FILE_WRITE_ATTRIBUTES":                        {"untyped int", constant.MakeInt64(int64(q.FILE_WRITE_ATTRIBUTES))},
			"FORMAT_MESSAGE_ALLOCATE_BUFFER":               {"untyped int", constant.MakeInt64(int64(q.FORMAT_MESSAGE_ALLOCATE_BUFFER))},
			"FORMAT_MESSAGE_ARGUMENT_ARRAY":                {"untyped int", constant.MakeInt64(int64(q.FORMAT_MESSAGE_ARGUMENT_ARRAY))},
			"FORMAT_MESSAGE_FROM_HMODULE":                  {"untyped int", constant.MakeInt64(int64(q.FORMAT_MESSAGE_FROM_HMODULE))},
			"FORMAT_MESSAGE_FROM_STRING":                   {"untyped int", constant.MakeInt64(int64(q.FORMAT_MESSAGE_FROM_STRING))},
			"FORMAT_MESSAGE_FROM_SYSTEM":                   {"untyped int", constant.MakeInt64(int64(q.FORMAT_MESSAGE_FROM_SYSTEM))},
			"FORMAT_MESSAGE_IGNORE_INSERTS":                {"untyped int", constant.MakeInt64(int64(q.FORMAT_MESSAGE_IGNORE_INSERTS))},
			"FORMAT_MESSAGE_MAX_WIDTH_MASK":                {"untyped int", constant.MakeInt64(int64(q.FORMAT_MESSAGE_MAX_WIDTH_MASK))},
			"FSCTL_GET_REPARSE_POINT":                      {"untyped int", constant.MakeInt64(int64(q.FSCTL_GET_REPARSE_POINT))},
			"GENERIC_ALL":                                  {"untyped int", constant.MakeInt64(int64(q.GENERIC_ALL))},
			"GENERIC_EXECUTE":                              {"untyped int", constant.MakeInt64(int64(q.GENERIC_EXECUTE))},
			"GENERIC_READ":                                 {"untyped int", constant.MakeInt64(int64(q.GENERIC_READ))},
			"GENERIC_WRITE":                                {"untyped int", constant.MakeInt64(int64(q.GENERIC_WRITE))},
			"GetFileExInfoStandard":                        {"untyped int", constant.MakeInt64(int64(q.GetFileExInfoStandard))},
			"GetFileExMaxInfoLevel":                        {"untyped int", constant.MakeInt64(int64(q.GetFileExMaxInfoLevel))},
			"HANDLE_FLAG_INHERIT":                          {"untyped int", constant.MakeInt64(int64(q.HANDLE_FLAG_INHERIT))},
			"HKEY_CLASSES_ROOT":                            {"untyped int", constant.MakeInt64(int64(q.HKEY_CLASSES_ROOT))},
			"HKEY_CURRENT_CONFIG":                          {"untyped int", constant.MakeInt64(int64(q.HKEY_CURRENT_CONFIG))},
			"HKEY_CURRENT_USER":                            {"untyped int", constant.MakeInt64(int64(q.HKEY_CURRENT_USER))},
			"HKEY_DYN_DATA":                                {"untyped int", constant.MakeInt64(int64(q.HKEY_DYN_DATA))},
			"HKEY_LOCAL_MACHINE":                           {"untyped int", constant.MakeInt64(int64(q.HKEY_LOCAL_MACHINE))},
			"HKEY_PERFORMANCE_DATA":                        {"untyped int", constant.MakeInt64(int64(q.HKEY_PERFORMANCE_DATA))},
			"HKEY_USERS":                                   {"untyped int", constant.MakeInt64(int64(q.HKEY_USERS))},
			"IFF_BROADCAST":                                {"untyped int", constant.MakeInt64(int64(q.IFF_BROADCAST))},
			"IFF_LOOPBACK":                                 {"untyped int", constant.MakeInt64(int64(q.IFF_LOOPBACK))},
			"IFF_MULTICAST":                                {"untyped int", constant.MakeInt64(int64(q.IFF_MULTICAST))},
			"IFF_POINTTOPOINT":                             {"untyped int", constant.MakeInt64(int64(q.IFF_POINTTOPOINT))},
			"IFF_UP":                                       {"untyped int", constant.MakeInt64(int64(q.IFF_UP))},
			"IGNORE":                                       {"untyped int", constant.MakeInt64(int64(q.IGNORE))},
			"INFINITE":                                     {"untyped int", constant.MakeInt64(int64(q.INFINITE))},
			"INVALID_FILE_ATTRIBUTES":                      {"untyped int", constant.MakeInt64(int64(q.INVALID_FILE_ATTRIBUTES))},
			"IOC_IN":                                       {"untyped int", constant.MakeInt64(int64(q.IOC_IN))},
			"IOC_INOUT":                                    {"untyped int", constant.MakeInt64(int64(q.IOC_INOUT))},
			"IOC_OUT":                                      {"untyped int", constant.MakeInt64(int64(q.IOC_OUT))},
			"IOC_VENDOR":                                   {"untyped int", constant.MakeInt64(int64(q.IOC_VENDOR))},
			"IOC_WS2":                                      {"untyped int", constant.MakeInt64(int64(q.IOC_WS2))},
			"IO_REPARSE_TAG_SYMLINK":                       {"untyped int", constant.MakeInt64(int64(q.IO_REPARSE_TAG_SYMLINK))},
			"IPPROTO_IP":                                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IP))},
			"IPPROTO_IPV6":                                 {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV6))},
			"IPPROTO_TCP":                                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCP))},
			"IPPROTO_UDP":                                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDP))},
			"IPV6_JOIN_GROUP":                              {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_GROUP))},
			"IPV6_LEAVE_GROUP":                             {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_GROUP))},
			"IPV6_MULTICAST_HOPS":                          {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_HOPS))},
			"IPV6_MULTICAST_IF":                            {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_IF))},
			"IPV6_MULTICAST_LOOP":                          {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_LOOP))},
			"IPV6_UNICAST_HOPS":                            {"untyped int", constant.MakeInt64(int64(q.IPV6_UNICAST_HOPS))},
			"IPV6_V6ONLY":                                  {"untyped int", constant.MakeInt64(int64(q.IPV6_V6ONLY))},
			"IP_ADD_MEMBERSHIP":                            {"untyped int", constant.MakeInt64(int64(q.IP_ADD_MEMBERSHIP))},
			"IP_DROP_MEMBERSHIP":                           {"untyped int", constant.MakeInt64(int64(q.IP_DROP_MEMBERSHIP))},
			"IP_MULTICAST_IF":                              {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IF))},
			"IP_MULTICAST_LOOP":                            {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_LOOP))},
			"IP_MULTICAST_TTL":                             {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_TTL))},
			"IP_TOS":                                       {"untyped int", constant.MakeInt64(int64(q.IP_TOS))},
			"IP_TTL":                                       {"untyped int", constant.MakeInt64(int64(q.IP_TTL))},
			"ImplementsGetwd":                              {"untyped bool", constant.MakeBool(bool(q.ImplementsGetwd))},
			"KEY_ALL_ACCESS":                               {"untyped int", constant.MakeInt64(int64(q.KEY_ALL_ACCESS))},
			"KEY_CREATE_LINK":                              {"untyped int", constant.MakeInt64(int64(q.KEY_CREATE_LINK))},
			"KEY_CREATE_SUB_KEY":                           {"untyped int", constant.MakeInt64(int64(q.KEY_CREATE_SUB_KEY))},
			"KEY_ENUMERATE_SUB_KEYS":                       {"untyped int", constant.MakeInt64(int64(q.KEY_ENUMERATE_SUB_KEYS))},
			"KEY_EXECUTE":                                  {"untyped int", constant.MakeInt64(int64(q.KEY_EXECUTE))},
			"KEY_NOTIFY":                                   {"untyped int", constant.MakeInt64(int64(q.KEY_NOTIFY))},
			"KEY_QUERY_VALUE":                              {"untyped int", constant.MakeInt64(int64(q.KEY_QUERY_VALUE))},
			"KEY_READ":                                     {"untyped int", constant.MakeInt64(int64(q.KEY_READ))},
			"KEY_SET_VALUE":                                {"untyped int", constant.MakeInt64(int64(q.KEY_SET_VALUE))},
			"KEY_WOW64_32KEY":                              {"untyped int", constant.MakeInt64(int64(q.KEY_WOW64_32KEY))},
			"KEY_WOW64_64KEY":                              {"untyped int", constant.MakeInt64(int64(q.KEY_WOW64_64KEY))},
			"KEY_WRITE":                                    {"untyped int", constant.MakeInt64(int64(q.KEY_WRITE))},
			"LANG_ENGLISH":                                 {"untyped int", constant.MakeInt64(int64(q.LANG_ENGLISH))},
			"LAYERED_PROTOCOL":                             {"untyped int", constant.MakeInt64(int64(q.LAYERED_PROTOCOL))},
			"MAXIMUM_REPARSE_DATA_BUFFER_SIZE":             {"untyped int", constant.MakeInt64(int64(q.MAXIMUM_REPARSE_DATA_BUFFER_SIZE))},
			"MAXLEN_IFDESCR":                               {"untyped int", constant.MakeInt64(int64(q.MAXLEN_IFDESCR))},
			"MAXLEN_PHYSADDR":                              {"untyped int", constant.MakeInt64(int64(q.MAXLEN_PHYSADDR))},
			"MAX_ADAPTER_ADDRESS_LENGTH":                   {"untyped int", constant.MakeInt64(int64(q.MAX_ADAPTER_ADDRESS_LENGTH))},
			"MAX_ADAPTER_DESCRIPTION_LENGTH":               {"untyped int", constant.MakeInt64(int64(q.MAX_ADAPTER_DESCRIPTION_LENGTH))},
			"MAX_ADAPTER_NAME_LENGTH":                      {"untyped int", constant.MakeInt64(int64(q.MAX_ADAPTER_NAME_LENGTH))},
			"MAX_COMPUTERNAME_LENGTH":                      {"untyped int", constant.MakeInt64(int64(q.MAX_COMPUTERNAME_LENGTH))},
			"MAX_INTERFACE_NAME_LEN":                       {"untyped int", constant.MakeInt64(int64(q.MAX_INTERFACE_NAME_LEN))},
			"MAX_LONG_PATH":                                {"untyped int", constant.MakeInt64(int64(q.MAX_LONG_PATH))},
			"MAX_PATH":                                     {"untyped int", constant.MakeInt64(int64(q.MAX_PATH))},
			"MAX_PROTOCOL_CHAIN":                           {"untyped int", constant.MakeInt64(int64(q.MAX_PROTOCOL_CHAIN))},
			"MaxTokenInfoClass":                            {"untyped int", constant.MakeInt64(int64(q.MaxTokenInfoClass))},
			"NameCanonical":                                {"untyped int", constant.MakeInt64(int64(q.NameCanonical))},
			"NameCanonicalEx":                              {"untyped int", constant.MakeInt64(int64(q.NameCanonicalEx))},
			"NameDisplay":                                  {"untyped int", constant.MakeInt64(int64(q.NameDisplay))},
			"NameDnsDomain":                                {"untyped int", constant.MakeInt64(int64(q.NameDnsDomain))},
			"NameFullyQualifiedDN":                         {"untyped int", constant.MakeInt64(int64(q.NameFullyQualifiedDN))},
			"NameSamCompatible":                            {"untyped int", constant.MakeInt64(int64(q.NameSamCompatible))},
			"NameServicePrincipal":                         {"untyped int", constant.MakeInt64(int64(q.NameServicePrincipal))},
			"NameUniqueId":                                 {"untyped int", constant.MakeInt64(int64(q.NameUniqueId))},
			"NameUnknown":                                  {"untyped int", constant.MakeInt64(int64(q.NameUnknown))},
			"NameUserPrincipal":                            {"untyped int", constant.MakeInt64(int64(q.NameUserPrincipal))},
			"NetSetupDomainName":                           {"untyped int", constant.MakeInt64(int64(q.NetSetupDomainName))},
			"NetSetupUnjoined":                             {"untyped int", constant.MakeInt64(int64(q.NetSetupUnjoined))},
			"NetSetupUnknownStatus":                        {"untyped int", constant.MakeInt64(int64(q.NetSetupUnknownStatus))},
			"NetSetupWorkgroupName":                        {"untyped int", constant.MakeInt64(int64(q.NetSetupWorkgroupName))},
			"OPEN_ALWAYS":                                  {"untyped int", constant.MakeInt64(int64(q.OPEN_ALWAYS))},
			"OPEN_EXISTING":                                {"untyped int", constant.MakeInt64(int64(q.OPEN_EXISTING))},
			"O_APPEND":                                     {"untyped int", constant.MakeInt64(int64(q.O_APPEND))},
			"O_ASYNC":                                      {"untyped int", constant.MakeInt64(int64(q.O_ASYNC))},
			"O_CLOEXEC":                                    {"untyped int", constant.MakeInt64(int64(q.O_CLOEXEC))},
			"O_CREAT":                                      {"untyped int", constant.MakeInt64(int64(q.O_CREAT))},
			"O_EXCL":                                       {"untyped int", constant.MakeInt64(int64(q.O_EXCL))},
			"O_NOCTTY":                                     {"untyped int", constant.MakeInt64(int64(q.O_NOCTTY))},
			"O_NONBLOCK":                                   {"untyped int", constant.MakeInt64(int64(q.O_NONBLOCK))},
			"O_RDONLY":                                     {"untyped int", constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":                                       {"untyped int", constant.MakeInt64(int64(q.O_RDWR))},
			"O_SYNC":                                       {"untyped int", constant.MakeInt64(int64(q.O_SYNC))},
			"O_TRUNC":                                      {"untyped int", constant.MakeInt64(int64(q.O_TRUNC))},
			"O_WRONLY":                                     {"untyped int", constant.MakeInt64(int64(q.O_WRONLY))},
			"PAGE_EXECUTE_READ":                            {"untyped int", constant.MakeInt64(int64(q.PAGE_EXECUTE_READ))},
			"PAGE_EXECUTE_READWRITE":                       {"untyped int", constant.MakeInt64(int64(q.PAGE_EXECUTE_READWRITE))},
			"PAGE_EXECUTE_WRITECOPY":                       {"untyped int", constant.MakeInt64(int64(q.PAGE_EXECUTE_WRITECOPY))},
			"PAGE_READONLY":                                {"untyped int", constant.MakeInt64(int64(q.PAGE_READONLY))},
			"PAGE_READWRITE":                               {"untyped int", constant.MakeInt64(int64(q.PAGE_READWRITE))},
			"PAGE_WRITECOPY":                               {"untyped int", constant.MakeInt64(int64(q.PAGE_WRITECOPY))},
			"PFL_HIDDEN":                                   {"untyped int", constant.MakeInt64(int64(q.PFL_HIDDEN))},
			"PFL_MATCHES_PROTOCOL_ZERO":                    {"untyped int", constant.MakeInt64(int64(q.PFL_MATCHES_PROTOCOL_ZERO))},
			"PFL_MULTIPLE_PROTO_ENTRIES":                   {"untyped int", constant.MakeInt64(int64(q.PFL_MULTIPLE_PROTO_ENTRIES))},
			"PFL_NETWORKDIRECT_PROVIDER":                   {"untyped int", constant.MakeInt64(int64(q.PFL_NETWORKDIRECT_PROVIDER))},
			"PFL_RECOMMENDED_PROTO_ENTRY":                  {"untyped int", constant.MakeInt64(int64(q.PFL_RECOMMENDED_PROTO_ENTRY))},
			"PKCS_7_ASN_ENCODING":                          {"untyped int", constant.MakeInt64(int64(q.PKCS_7_ASN_ENCODING))},
			"PROCESS_QUERY_INFORMATION":                    {"untyped int", constant.MakeInt64(int64(q.PROCESS_QUERY_INFORMATION))},
			"PROCESS_TERMINATE":                            {"untyped int", constant.MakeInt64(int64(q.PROCESS_TERMINATE))},
			"PROV_DH_SCHANNEL":                             {"untyped int", constant.MakeInt64(int64(q.PROV_DH_SCHANNEL))},
			"PROV_DSS":                                     {"untyped int", constant.MakeInt64(int64(q.PROV_DSS))},
			"PROV_DSS_DH":                                  {"untyped int", constant.MakeInt64(int64(q.PROV_DSS_DH))},
			"PROV_EC_ECDSA_FULL":                           {"untyped int", constant.MakeInt64(int64(q.PROV_EC_ECDSA_FULL))},
			"PROV_EC_ECDSA_SIG":                            {"untyped int", constant.MakeInt64(int64(q.PROV_EC_ECDSA_SIG))},
			"PROV_EC_ECNRA_FULL":                           {"untyped int", constant.MakeInt64(int64(q.PROV_EC_ECNRA_FULL))},
			"PROV_EC_ECNRA_SIG":                            {"untyped int", constant.MakeInt64(int64(q.PROV_EC_ECNRA_SIG))},
			"PROV_FORTEZZA":                                {"untyped int", constant.MakeInt64(int64(q.PROV_FORTEZZA))},
			"PROV_INTEL_SEC":                               {"untyped int", constant.MakeInt64(int64(q.PROV_INTEL_SEC))},
			"PROV_MS_EXCHANGE":                             {"untyped int", constant.MakeInt64(int64(q.PROV_MS_EXCHANGE))},
			"PROV_REPLACE_OWF":                             {"untyped int", constant.MakeInt64(int64(q.PROV_REPLACE_OWF))},
			"PROV_RNG":                                     {"untyped int", constant.MakeInt64(int64(q.PROV_RNG))},
			"PROV_RSA_AES":                                 {"untyped int", constant.MakeInt64(int64(q.PROV_RSA_AES))},
			"PROV_RSA_FULL":                                {"untyped int", constant.MakeInt64(int64(q.PROV_RSA_FULL))},
			"PROV_RSA_SCHANNEL":                            {"untyped int", constant.MakeInt64(int64(q.PROV_RSA_SCHANNEL))},
			"PROV_RSA_SIG":                                 {"untyped int", constant.MakeInt64(int64(q.PROV_RSA_SIG))},
			"PROV_SPYRUS_LYNKS":                            {"untyped int", constant.MakeInt64(int64(q.PROV_SPYRUS_LYNKS))},
			"PROV_SSL":                                     {"untyped int", constant.MakeInt64(int64(q.PROV_SSL))},
			"REG_BINARY":                                   {"untyped int", constant.MakeInt64(int64(q.REG_BINARY))},
			"REG_DWORD":                                    {"untyped int", constant.MakeInt64(int64(q.REG_DWORD))},
			"REG_DWORD_BIG_ENDIAN":                         {"untyped int", constant.MakeInt64(int64(q.REG_DWORD_BIG_ENDIAN))},
			"REG_DWORD_LITTLE_ENDIAN":                      {"untyped int", constant.MakeInt64(int64(q.REG_DWORD_LITTLE_ENDIAN))},
			"REG_EXPAND_SZ":                                {"untyped int", constant.MakeInt64(int64(q.REG_EXPAND_SZ))},
			"REG_FULL_RESOURCE_DESCRIPTOR":                 {"untyped int", constant.MakeInt64(int64(q.REG_FULL_RESOURCE_DESCRIPTOR))},
			"REG_LINK":                                     {"untyped int", constant.MakeInt64(int64(q.REG_LINK))},
			"REG_MULTI_SZ":                                 {"untyped int", constant.MakeInt64(int64(q.REG_MULTI_SZ))},
			"REG_NONE":                                     {"untyped int", constant.MakeInt64(int64(q.REG_NONE))},
			"REG_QWORD":                                    {"untyped int", constant.MakeInt64(int64(q.REG_QWORD))},
			"REG_QWORD_LITTLE_ENDIAN":                      {"untyped int", constant.MakeInt64(int64(q.REG_QWORD_LITTLE_ENDIAN))},
			"REG_RESOURCE_LIST":                            {"untyped int", constant.MakeInt64(int64(q.REG_RESOURCE_LIST))},
			"REG_RESOURCE_REQUIREMENTS_LIST":               {"untyped int", constant.MakeInt64(int64(q.REG_RESOURCE_REQUIREMENTS_LIST))},
			"REG_SZ":                                       {"untyped int", constant.MakeInt64(int64(q.REG_SZ))},
			"SHUT_RD":                                      {"untyped int", constant.MakeInt64(int64(q.SHUT_RD))},
			"SHUT_RDWR":                                    {"untyped int", constant.MakeInt64(int64(q.SHUT_RDWR))},
			"SHUT_WR":                                      {"untyped int", constant.MakeInt64(int64(q.SHUT_WR))},
			"SIO_GET_EXTENSION_FUNCTION_POINTER":           {"untyped int", constant.MakeInt64(int64(q.SIO_GET_EXTENSION_FUNCTION_POINTER))},
			"SIO_GET_INTERFACE_LIST":                       {"untyped int", constant.MakeInt64(int64(q.SIO_GET_INTERFACE_LIST))},
			"SIO_KEEPALIVE_VALS":                           {"untyped int", constant.MakeInt64(int64(q.SIO_KEEPALIVE_VALS))},
			"SIO_UDP_CONNRESET":                            {"untyped int", constant.MakeInt64(int64(q.SIO_UDP_CONNRESET))},
			"SOCK_DGRAM":                                   {"untyped int", constant.MakeInt64(int64(q.SOCK_DGRAM))},
			"SOCK_RAW":                                     {"untyped int", constant.MakeInt64(int64(q.SOCK_RAW))},
			"SOCK_SEQPACKET":                               {"untyped int", constant.MakeInt64(int64(q.SOCK_SEQPACKET))},
			"SOCK_STREAM":                                  {"untyped int", constant.MakeInt64(int64(q.SOCK_STREAM))},
			"SOL_SOCKET":                                   {"untyped int", constant.MakeInt64(int64(q.SOL_SOCKET))},
			"SOMAXCONN":                                    {"untyped int", constant.MakeInt64(int64(q.SOMAXCONN))},
			"SO_BROADCAST":                                 {"untyped int", constant.MakeInt64(int64(q.SO_BROADCAST))},
			"SO_DONTROUTE":                                 {"untyped int", constant.MakeInt64(int64(q.SO_DONTROUTE))},
			"SO_KEEPALIVE":                                 {"untyped int", constant.MakeInt64(int64(q.SO_KEEPALIVE))},
			"SO_LINGER":                                    {"untyped int", constant.MakeInt64(int64(q.SO_LINGER))},
			"SO_RCVBUF":                                    {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUF))},
			"SO_REUSEADDR":                                 {"untyped int", constant.MakeInt64(int64(q.SO_REUSEADDR))},
			"SO_SNDBUF":                                    {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUF))},
			"SO_UPDATE_ACCEPT_CONTEXT":                     {"untyped int", constant.MakeInt64(int64(q.SO_UPDATE_ACCEPT_CONTEXT))},
			"SO_UPDATE_CONNECT_CONTEXT":                    {"untyped int", constant.MakeInt64(int64(q.SO_UPDATE_CONNECT_CONTEXT))},
			"STANDARD_RIGHTS_ALL":                          {"untyped int", constant.MakeInt64(int64(q.STANDARD_RIGHTS_ALL))},
			"STANDARD_RIGHTS_EXECUTE":                      {"untyped int", constant.MakeInt64(int64(q.STANDARD_RIGHTS_EXECUTE))},
			"STANDARD_RIGHTS_READ":                         {"untyped int", constant.MakeInt64(int64(q.STANDARD_RIGHTS_READ))},
			"STANDARD_RIGHTS_REQUIRED":                     {"untyped int", constant.MakeInt64(int64(q.STANDARD_RIGHTS_REQUIRED))},
			"STANDARD_RIGHTS_WRITE":                        {"untyped int", constant.MakeInt64(int64(q.STANDARD_RIGHTS_WRITE))},
			"STARTF_USESHOWWINDOW":                         {"untyped int", constant.MakeInt64(int64(q.STARTF_USESHOWWINDOW))},
			"STARTF_USESTDHANDLES":                         {"untyped int", constant.MakeInt64(int64(q.STARTF_USESTDHANDLES))},
			"STD_ERROR_HANDLE":                             {"untyped int", constant.MakeInt64(int64(q.STD_ERROR_HANDLE))},
			"STD_INPUT_HANDLE":                             {"untyped int", constant.MakeInt64(int64(q.STD_INPUT_HANDLE))},
			"STD_OUTPUT_HANDLE":                            {"untyped int", constant.MakeInt64(int64(q.STD_OUTPUT_HANDLE))},
			"SUBLANG_ENGLISH_US":                           {"untyped int", constant.MakeInt64(int64(q.SUBLANG_ENGLISH_US))},
			"SW_FORCEMINIMIZE":                             {"untyped int", constant.MakeInt64(int64(q.SW_FORCEMINIMIZE))},
			"SW_HIDE":                                      {"untyped int", constant.MakeInt64(int64(q.SW_HIDE))},
			"SW_MAXIMIZE":                                  {"untyped int", constant.MakeInt64(int64(q.SW_MAXIMIZE))},
			"SW_MINIMIZE":                                  {"untyped int", constant.MakeInt64(int64(q.SW_MINIMIZE))},
			"SW_NORMAL":                                    {"untyped int", constant.MakeInt64(int64(q.SW_NORMAL))},
			"SW_RESTORE":                                   {"untyped int", constant.MakeInt64(int64(q.SW_RESTORE))},
			"SW_SHOW":                                      {"untyped int", constant.MakeInt64(int64(q.SW_SHOW))},
			"SW_SHOWDEFAULT":                               {"untyped int", constant.MakeInt64(int64(q.SW_SHOWDEFAULT))},
			"SW_SHOWMAXIMIZED":                             {"untyped int", constant.MakeInt64(int64(q.SW_SHOWMAXIMIZED))},
			"SW_SHOWMINIMIZED":                             {"untyped int", constant.MakeInt64(int64(q.SW_SHOWMINIMIZED))},
			"SW_SHOWMINNOACTIVE":                           {"untyped int", constant.MakeInt64(int64(q.SW_SHOWMINNOACTIVE))},
			"SW_SHOWNA":                                    {"untyped int", constant.MakeInt64(int64(q.SW_SHOWNA))},
			"SW_SHOWNOACTIVATE":                            {"untyped int", constant.MakeInt64(int64(q.SW_SHOWNOACTIVATE))},
			"SW_SHOWNORMAL":                                {"untyped int", constant.MakeInt64(int64(q.SW_SHOWNORMAL))},
			"SYMBOLIC_LINK_FLAG_DIRECTORY":                 {"untyped int", constant.MakeInt64(int64(q.SYMBOLIC_LINK_FLAG_DIRECTORY))},
			"SYNCHRONIZE":                                  {"untyped int", constant.MakeInt64(int64(q.SYNCHRONIZE))},
			"S_IFBLK":                                      {"untyped int", constant.MakeInt64(int64(q.S_IFBLK))},
			"S_IFCHR":                                      {"untyped int", constant.MakeInt64(int64(q.S_IFCHR))},
			"S_IFDIR":                                      {"untyped int", constant.MakeInt64(int64(q.S_IFDIR))},
			"S_IFIFO":                                      {"untyped int", constant.MakeInt64(int64(q.S_IFIFO))},
			"S_IFLNK":                                      {"untyped int", constant.MakeInt64(int64(q.S_IFLNK))},
			"S_IFMT":                                       {"untyped int", constant.MakeInt64(int64(q.S_IFMT))},
			"S_IFREG":                                      {"untyped int", constant.MakeInt64(int64(q.S_IFREG))},
			"S_IFSOCK":                                     {"untyped int", constant.MakeInt64(int64(q.S_IFSOCK))},
			"S_IRUSR":                                      {"untyped int", constant.MakeInt64(int64(q.S_IRUSR))},
			"S_ISGID":                                      {"untyped int", constant.MakeInt64(int64(q.S_ISGID))},
			"S_ISUID":                                      {"untyped int", constant.MakeInt64(int64(q.S_ISUID))},
			"S_ISVTX":                                      {"untyped int", constant.MakeInt64(int64(q.S_ISVTX))},
			"S_IWRITE":                                     {"untyped int", constant.MakeInt64(int64(q.S_IWRITE))},
			"S_IWUSR":                                      {"untyped int", constant.MakeInt64(int64(q.S_IWUSR))},
			"S_IXUSR":                                      {"untyped int", constant.MakeInt64(int64(q.S_IXUSR))},
			"SidTypeAlias":                                 {"untyped int", constant.MakeInt64(int64(q.SidTypeAlias))},
			"SidTypeComputer":                              {"untyped int", constant.MakeInt64(int64(q.SidTypeComputer))},
			"SidTypeDeletedAccount":                        {"untyped int", constant.MakeInt64(int64(q.SidTypeDeletedAccount))},
			"SidTypeDomain":                                {"untyped int", constant.MakeInt64(int64(q.SidTypeDomain))},
			"SidTypeGroup":                                 {"untyped int", constant.MakeInt64(int64(q.SidTypeGroup))},
			"SidTypeInvalid":                               {"untyped int", constant.MakeInt64(int64(q.SidTypeInvalid))},
			"SidTypeLabel":                                 {"untyped int", constant.MakeInt64(int64(q.SidTypeLabel))},
			"SidTypeUnknown":                               {"untyped int", constant.MakeInt64(int64(q.SidTypeUnknown))},
			"SidTypeUser":                                  {"untyped int", constant.MakeInt64(int64(q.SidTypeUser))},
			"SidTypeWellKnownGroup":                        {"untyped int", constant.MakeInt64(int64(q.SidTypeWellKnownGroup))},
			"TCP_NODELAY":                                  {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAY))},
			"TF_DISCONNECT":                                {"untyped int", constant.MakeInt64(int64(q.TF_DISCONNECT))},
			"TF_REUSE_SOCKET":                              {"untyped int", constant.MakeInt64(int64(q.TF_REUSE_SOCKET))},
			"TF_USE_DEFAULT_WORKER":                        {"untyped int", constant.MakeInt64(int64(q.TF_USE_DEFAULT_WORKER))},
			"TF_USE_KERNEL_APC":                            {"untyped int", constant.MakeInt64(int64(q.TF_USE_KERNEL_APC))},
			"TF_USE_SYSTEM_THREAD":                         {"untyped int", constant.MakeInt64(int64(q.TF_USE_SYSTEM_THREAD))},
			"TF_WRITE_BEHIND":                              {"untyped int", constant.MakeInt64(int64(q.TF_WRITE_BEHIND))},
			"TH32CS_INHERIT":                               {"untyped int", constant.MakeInt64(int64(q.TH32CS_INHERIT))},
			"TH32CS_SNAPALL":                               {"untyped int", constant.MakeInt64(int64(q.TH32CS_SNAPALL))},
			"TH32CS_SNAPHEAPLIST":                          {"untyped int", constant.MakeInt64(int64(q.TH32CS_SNAPHEAPLIST))},
			"TH32CS_SNAPMODULE":                            {"untyped int", constant.MakeInt64(int64(q.TH32CS_SNAPMODULE))},
			"TH32CS_SNAPMODULE32":                          {"untyped int", constant.MakeInt64(int64(q.TH32CS_SNAPMODULE32))},
			"TH32CS_SNAPPROCESS":                           {"untyped int", constant.MakeInt64(int64(q.TH32CS_SNAPPROCESS))},
			"TH32CS_SNAPTHREAD":                            {"untyped int", constant.MakeInt64(int64(q.TH32CS_SNAPTHREAD))},
			"TIME_ZONE_ID_DAYLIGHT":                        {"untyped int", constant.MakeInt64(int64(q.TIME_ZONE_ID_DAYLIGHT))},
			"TIME_ZONE_ID_STANDARD":                        {"untyped int", constant.MakeInt64(int64(q.TIME_ZONE_ID_STANDARD))},
			"TIME_ZONE_ID_UNKNOWN":                         {"untyped int", constant.MakeInt64(int64(q.TIME_ZONE_ID_UNKNOWN))},
			"TOKEN_ADJUST_DEFAULT":                         {"untyped int", constant.MakeInt64(int64(q.TOKEN_ADJUST_DEFAULT))},
			"TOKEN_ADJUST_GROUPS":                          {"untyped int", constant.MakeInt64(int64(q.TOKEN_ADJUST_GROUPS))},
			"TOKEN_ADJUST_PRIVILEGES":                      {"untyped int", constant.MakeInt64(int64(q.TOKEN_ADJUST_PRIVILEGES))},
			"TOKEN_ADJUST_SESSIONID":                       {"untyped int", constant.MakeInt64(int64(q.TOKEN_ADJUST_SESSIONID))},
			"TOKEN_ALL_ACCESS":                             {"untyped int", constant.MakeInt64(int64(q.TOKEN_ALL_ACCESS))},
			"TOKEN_ASSIGN_PRIMARY":                         {"untyped int", constant.MakeInt64(int64(q.TOKEN_ASSIGN_PRIMARY))},
			"TOKEN_DUPLICATE":                              {"untyped int", constant.MakeInt64(int64(q.TOKEN_DUPLICATE))},
			"TOKEN_EXECUTE":                                {"untyped int", constant.MakeInt64(int64(q.TOKEN_EXECUTE))},
			"TOKEN_IMPERSONATE":                            {"untyped int", constant.MakeInt64(int64(q.TOKEN_IMPERSONATE))},
			"TOKEN_QUERY":                                  {"untyped int", constant.MakeInt64(int64(q.TOKEN_QUERY))},
			"TOKEN_QUERY_SOURCE":                           {"untyped int", constant.MakeInt64(int64(q.TOKEN_QUERY_SOURCE))},
			"TOKEN_READ":                                   {"untyped int", constant.MakeInt64(int64(q.TOKEN_READ))},
			"TOKEN_WRITE":                                  {"untyped int", constant.MakeInt64(int64(q.TOKEN_WRITE))},
			"TRUNCATE_EXISTING":                            {"untyped int", constant.MakeInt64(int64(q.TRUNCATE_EXISTING))},
			"TokenAccessInformation":                       {"untyped int", constant.MakeInt64(int64(q.TokenAccessInformation))},
			"TokenAuditPolicy":                             {"untyped int", constant.MakeInt64(int64(q.TokenAuditPolicy))},
			"TokenDefaultDacl":                             {"untyped int", constant.MakeInt64(int64(q.TokenDefaultDacl))},
			"TokenElevation":                               {"untyped int", constant.MakeInt64(int64(q.TokenElevation))},
			"TokenElevationType":                           {"untyped int", constant.MakeInt64(int64(q.TokenElevationType))},
			"TokenGroups":                                  {"untyped int", constant.MakeInt64(int64(q.TokenGroups))},
			"TokenGroupsAndPrivileges":                     {"untyped int", constant.MakeInt64(int64(q.TokenGroupsAndPrivileges))},
			"TokenHasRestrictions":                         {"untyped int", constant.MakeInt64(int64(q.TokenHasRestrictions))},
			"TokenImpersonationLevel":                      {"untyped int", constant.MakeInt64(int64(q.TokenImpersonationLevel))},
			"TokenIntegrityLevel":                          {"untyped int", constant.MakeInt64(int64(q.TokenIntegrityLevel))},
			"TokenLinkedToken":                             {"untyped int", constant.MakeInt64(int64(q.TokenLinkedToken))},
			"TokenLogonSid":                                {"untyped int", constant.MakeInt64(int64(q.TokenLogonSid))},
			"TokenMandatoryPolicy":                         {"untyped int", constant.MakeInt64(int64(q.TokenMandatoryPolicy))},
			"TokenOrigin":                                  {"untyped int", constant.MakeInt64(int64(q.TokenOrigin))},
			"TokenOwner":                                   {"untyped int", constant.MakeInt64(int64(q.TokenOwner))},
			"TokenPrimaryGroup":                            {"untyped int", constant.MakeInt64(int64(q.TokenPrimaryGroup))},
			"TokenPrivileges":                              {"untyped int", constant.MakeInt64(int64(q.TokenPrivileges))},
			"TokenRestrictedSids":                          {"untyped int", constant.MakeInt64(int64(q.TokenRestrictedSids))},
			"TokenSandBoxInert":                            {"untyped int", constant.MakeInt64(int64(q.TokenSandBoxInert))},
			"TokenSessionId":                               {"untyped int", constant.MakeInt64(int64(q.TokenSessionId))},
			"TokenSessionReference":                        {"untyped int", constant.MakeInt64(int64(q.TokenSessionReference))},
			"TokenSource":                                  {"untyped int", constant.MakeInt64(int64(q.TokenSource))},
			"TokenStatistics":                              {"untyped int", constant.MakeInt64(int64(q.TokenStatistics))},
			"TokenType":                                    {"untyped int", constant.MakeInt64(int64(q.TokenType))},
			"TokenUIAccess":                                {"untyped int", constant.MakeInt64(int64(q.TokenUIAccess))},
			"TokenUser":                                    {"untyped int", constant.MakeInt64(int64(q.TokenUser))},
			"TokenVirtualizationAllowed":                   {"untyped int", constant.MakeInt64(int64(q.TokenVirtualizationAllowed))},
			"TokenVirtualizationEnabled":                   {"untyped int", constant.MakeInt64(int64(q.TokenVirtualizationEnabled))},
			"UNIX_PATH_MAX":                                {"untyped int", constant.MakeInt64(int64(q.UNIX_PATH_MAX))},
			"USAGE_MATCH_TYPE_AND":                         {"untyped int", constant.MakeInt64(int64(q.USAGE_MATCH_TYPE_AND))},
			"USAGE_MATCH_TYPE_OR":                          {"untyped int", constant.MakeInt64(int64(q.USAGE_MATCH_TYPE_OR))},
			"WAIT_ABANDONED":                               {"untyped int", constant.MakeInt64(int64(q.WAIT_ABANDONED))},
			"WAIT_FAILED":                                  {"untyped int", constant.MakeInt64(int64(q.WAIT_FAILED))},
			"WAIT_OBJECT_0":                                {"untyped int", constant.MakeInt64(int64(q.WAIT_OBJECT_0))},
			"WAIT_TIMEOUT":                                 {"untyped int", constant.MakeInt64(int64(q.WAIT_TIMEOUT))},
			"WSADESCRIPTION_LEN":                           {"untyped int", constant.MakeInt64(int64(q.WSADESCRIPTION_LEN))},
			"WSAPROTOCOL_LEN":                              {"untyped int", constant.MakeInt64(int64(q.WSAPROTOCOL_LEN))},
			"WSASYS_STATUS_LEN":                            {"untyped int", constant.MakeInt64(int64(q.WSASYS_STATUS_LEN))},
			"X509_ASN_ENCODING":                            {"untyped int", constant.MakeInt64(int64(q.X509_ASN_ENCODING))},
			"XP1_CONNECTIONLESS":                           {"untyped int", constant.MakeInt64(int64(q.XP1_CONNECTIONLESS))},
			"XP1_CONNECT_DATA":                             {"untyped int", constant.MakeInt64(int64(q.XP1_CONNECT_DATA))},
			"XP1_DISCONNECT_DATA":                          {"untyped int", constant.MakeInt64(int64(q.XP1_DISCONNECT_DATA))},
			"XP1_EXPEDITED_DATA":                           {"untyped int", constant.MakeInt64(int64(q.XP1_EXPEDITED_DATA))},
			"XP1_GRACEFUL_CLOSE":                           {"untyped int", constant.MakeInt64(int64(q.XP1_GRACEFUL_CLOSE))},
			"XP1_GUARANTEED_DELIVERY":                      {"untyped int", constant.MakeInt64(int64(q.XP1_GUARANTEED_DELIVERY))},
			"XP1_GUARANTEED_ORDER":                         {"untyped int", constant.MakeInt64(int64(q.XP1_GUARANTEED_ORDER))},
			"XP1_IFS_HANDLES":                              {"untyped int", constant.MakeInt64(int64(q.XP1_IFS_HANDLES))},
			"XP1_MESSAGE_ORIENTED":                         {"untyped int", constant.MakeInt64(int64(q.XP1_MESSAGE_ORIENTED))},
			"XP1_MULTIPOINT_CONTROL_PLANE":                 {"untyped int", constant.MakeInt64(int64(q.XP1_MULTIPOINT_CONTROL_PLANE))},
			"XP1_MULTIPOINT_DATA_PLANE":                    {"untyped int", constant.MakeInt64(int64(q.XP1_MULTIPOINT_DATA_PLANE))},
			"XP1_PARTIAL_MESSAGE":                          {"untyped int", constant.MakeInt64(int64(q.XP1_PARTIAL_MESSAGE))},
			"XP1_PSEUDO_STREAM":                            {"untyped int", constant.MakeInt64(int64(q.XP1_PSEUDO_STREAM))},
			"XP1_QOS_SUPPORTED":                            {"untyped int", constant.MakeInt64(int64(q.XP1_QOS_SUPPORTED))},
			"XP1_SAN_SUPPORT_SDP":                          {"untyped int", constant.MakeInt64(int64(q.XP1_SAN_SUPPORT_SDP))},
			"XP1_SUPPORT_BROADCAST":                        {"untyped int", constant.MakeInt64(int64(q.XP1_SUPPORT_BROADCAST))},
			"XP1_SUPPORT_MULTIPOINT":                       {"untyped int", constant.MakeInt64(int64(q.XP1_SUPPORT_MULTIPOINT))},
			"XP1_UNI_RECV":                                 {"untyped int", constant.MakeInt64(int64(q.XP1_UNI_RECV))},
			"XP1_UNI_SEND":                                 {"untyped int", constant.MakeInt64(int64(q.XP1_UNI_SEND))},
		},
	})
}
