// export by github.com/goplus/igop/cmd/qexp

//go:build go1.20
// +build go1.20

package syscall

import (
	q "syscall"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "syscall",
		Path: "syscall",
		Deps: map[string]string{
			"errors":           "errors",
			"internal/bytealg": "bytealg",
			"internal/itoa":    "itoa",
			"internal/oserror": "oserror",
			"internal/race":    "race",
			"runtime":          "runtime",
			"sync":             "sync",
			"unsafe":           "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Conn":           reflect.TypeOf((*q.Conn)(nil)).Elem(),
			"RawConn":        reflect.TypeOf((*q.RawConn)(nil)).Elem(),
			"RoutingMessage": reflect.TypeOf((*q.RoutingMessage)(nil)).Elem(),
			"Sockaddr":       reflect.TypeOf((*q.Sockaddr)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"BpfHdr":                        reflect.TypeOf((*q.BpfHdr)(nil)).Elem(),
			"BpfInsn":                       reflect.TypeOf((*q.BpfInsn)(nil)).Elem(),
			"BpfProgram":                    reflect.TypeOf((*q.BpfProgram)(nil)).Elem(),
			"BpfStat":                       reflect.TypeOf((*q.BpfStat)(nil)).Elem(),
			"BpfVersion":                    reflect.TypeOf((*q.BpfVersion)(nil)).Elem(),
			"Cmsghdr":                       reflect.TypeOf((*q.Cmsghdr)(nil)).Elem(),
			"Credential":                    reflect.TypeOf((*q.Credential)(nil)).Elem(),
			"Dirent":                        reflect.TypeOf((*q.Dirent)(nil)).Elem(),
			"Errno":                         reflect.TypeOf((*q.Errno)(nil)).Elem(),
			"FdSet":                         reflect.TypeOf((*q.FdSet)(nil)).Elem(),
			"Flock_t":                       reflect.TypeOf((*q.Flock_t)(nil)).Elem(),
			"Fsid":                          reflect.TypeOf((*q.Fsid)(nil)).Elem(),
			"ICMPv6Filter":                  reflect.TypeOf((*q.ICMPv6Filter)(nil)).Elem(),
			"IPMreq":                        reflect.TypeOf((*q.IPMreq)(nil)).Elem(),
			"IPv6MTUInfo":                   reflect.TypeOf((*q.IPv6MTUInfo)(nil)).Elem(),
			"IPv6Mreq":                      reflect.TypeOf((*q.IPv6Mreq)(nil)).Elem(),
			"IfAnnounceMsghdr":              reflect.TypeOf((*q.IfAnnounceMsghdr)(nil)).Elem(),
			"IfData":                        reflect.TypeOf((*q.IfData)(nil)).Elem(),
			"IfMsghdr":                      reflect.TypeOf((*q.IfMsghdr)(nil)).Elem(),
			"IfaMsghdr":                     reflect.TypeOf((*q.IfaMsghdr)(nil)).Elem(),
			"IfmaMsghdr":                    reflect.TypeOf((*q.IfmaMsghdr)(nil)).Elem(),
			"Inet6Pktinfo":                  reflect.TypeOf((*q.Inet6Pktinfo)(nil)).Elem(),
			"InterfaceAddrMessage":          reflect.TypeOf((*q.InterfaceAddrMessage)(nil)).Elem(),
			"InterfaceAnnounceMessage":      reflect.TypeOf((*q.InterfaceAnnounceMessage)(nil)).Elem(),
			"InterfaceMessage":              reflect.TypeOf((*q.InterfaceMessage)(nil)).Elem(),
			"InterfaceMulticastAddrMessage": reflect.TypeOf((*q.InterfaceMulticastAddrMessage)(nil)).Elem(),
			"Iovec":                         reflect.TypeOf((*q.Iovec)(nil)).Elem(),
			"Kevent_t":                      reflect.TypeOf((*q.Kevent_t)(nil)).Elem(),
			"Linger":                        reflect.TypeOf((*q.Linger)(nil)).Elem(),
			"Msghdr":                        reflect.TypeOf((*q.Msghdr)(nil)).Elem(),
			"ProcAttr":                      reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"RawSockaddr":                   reflect.TypeOf((*q.RawSockaddr)(nil)).Elem(),
			"RawSockaddrAny":                reflect.TypeOf((*q.RawSockaddrAny)(nil)).Elem(),
			"RawSockaddrDatalink":           reflect.TypeOf((*q.RawSockaddrDatalink)(nil)).Elem(),
			"RawSockaddrInet4":              reflect.TypeOf((*q.RawSockaddrInet4)(nil)).Elem(),
			"RawSockaddrInet6":              reflect.TypeOf((*q.RawSockaddrInet6)(nil)).Elem(),
			"RawSockaddrUnix":               reflect.TypeOf((*q.RawSockaddrUnix)(nil)).Elem(),
			"Rlimit":                        reflect.TypeOf((*q.Rlimit)(nil)).Elem(),
			"RouteMessage":                  reflect.TypeOf((*q.RouteMessage)(nil)).Elem(),
			"RtMetrics":                     reflect.TypeOf((*q.RtMetrics)(nil)).Elem(),
			"RtMsghdr":                      reflect.TypeOf((*q.RtMsghdr)(nil)).Elem(),
			"Rusage":                        reflect.TypeOf((*q.Rusage)(nil)).Elem(),
			"Signal":                        reflect.TypeOf((*q.Signal)(nil)).Elem(),
			"SockaddrDatalink":              reflect.TypeOf((*q.SockaddrDatalink)(nil)).Elem(),
			"SockaddrInet4":                 reflect.TypeOf((*q.SockaddrInet4)(nil)).Elem(),
			"SockaddrInet6":                 reflect.TypeOf((*q.SockaddrInet6)(nil)).Elem(),
			"SockaddrUnix":                  reflect.TypeOf((*q.SockaddrUnix)(nil)).Elem(),
			"SocketControlMessage":          reflect.TypeOf((*q.SocketControlMessage)(nil)).Elem(),
			"Stat_t":                        reflect.TypeOf((*q.Stat_t)(nil)).Elem(),
			"Statfs_t":                      reflect.TypeOf((*q.Statfs_t)(nil)).Elem(),
			"SysProcAttr":                   reflect.TypeOf((*q.SysProcAttr)(nil)).Elem(),
			"Termios":                       reflect.TypeOf((*q.Termios)(nil)).Elem(),
			"Timespec":                      reflect.TypeOf((*q.Timespec)(nil)).Elem(),
			"Timeval":                       reflect.TypeOf((*q.Timeval)(nil)).Elem(),
			"WaitStatus":                    reflect.TypeOf((*q.WaitStatus)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ForkLock":          reflect.ValueOf(&q.ForkLock),
			"SocketDisableIPv6": reflect.ValueOf(&q.SocketDisableIPv6),
			"Stderr":            reflect.ValueOf(&q.Stderr),
			"Stdin":             reflect.ValueOf(&q.Stdin),
			"Stdout":            reflect.ValueOf(&q.Stdout),
		},
		Funcs: map[string]reflect.Value{
			"Accept":                    reflect.ValueOf(q.Accept),
			"Accept4":                   reflect.ValueOf(q.Accept4),
			"Access":                    reflect.ValueOf(q.Access),
			"Adjtime":                   reflect.ValueOf(q.Adjtime),
			"Bind":                      reflect.ValueOf(q.Bind),
			"BpfBuflen":                 reflect.ValueOf(q.BpfBuflen),
			"BpfDatalink":               reflect.ValueOf(q.BpfDatalink),
			"BpfHeadercmpl":             reflect.ValueOf(q.BpfHeadercmpl),
			"BpfInterface":              reflect.ValueOf(q.BpfInterface),
			"BpfJump":                   reflect.ValueOf(q.BpfJump),
			"BpfStats":                  reflect.ValueOf(q.BpfStats),
			"BpfStmt":                   reflect.ValueOf(q.BpfStmt),
			"BpfTimeout":                reflect.ValueOf(q.BpfTimeout),
			"BytePtrFromString":         reflect.ValueOf(q.BytePtrFromString),
			"ByteSliceFromString":       reflect.ValueOf(q.ByteSliceFromString),
			"Chdir":                     reflect.ValueOf(q.Chdir),
			"CheckBpfVersion":           reflect.ValueOf(q.CheckBpfVersion),
			"Chflags":                   reflect.ValueOf(q.Chflags),
			"Chmod":                     reflect.ValueOf(q.Chmod),
			"Chown":                     reflect.ValueOf(q.Chown),
			"Chroot":                    reflect.ValueOf(q.Chroot),
			"Clearenv":                  reflect.ValueOf(q.Clearenv),
			"Close":                     reflect.ValueOf(q.Close),
			"CloseOnExec":               reflect.ValueOf(q.CloseOnExec),
			"CmsgLen":                   reflect.ValueOf(q.CmsgLen),
			"CmsgSpace":                 reflect.ValueOf(q.CmsgSpace),
			"Connect":                   reflect.ValueOf(q.Connect),
			"Dup":                       reflect.ValueOf(q.Dup),
			"Dup2":                      reflect.ValueOf(q.Dup2),
			"Environ":                   reflect.ValueOf(q.Environ),
			"Exec":                      reflect.ValueOf(q.Exec),
			"Exit":                      reflect.ValueOf(q.Exit),
			"Fchdir":                    reflect.ValueOf(q.Fchdir),
			"Fchflags":                  reflect.ValueOf(q.Fchflags),
			"Fchmod":                    reflect.ValueOf(q.Fchmod),
			"Fchown":                    reflect.ValueOf(q.Fchown),
			"FcntlFlock":                reflect.ValueOf(q.FcntlFlock),
			"Flock":                     reflect.ValueOf(q.Flock),
			"FlushBpf":                  reflect.ValueOf(q.FlushBpf),
			"ForkExec":                  reflect.ValueOf(q.ForkExec),
			"Fpathconf":                 reflect.ValueOf(q.Fpathconf),
			"Fstat":                     reflect.ValueOf(q.Fstat),
			"Fstatfs":                   reflect.ValueOf(q.Fstatfs),
			"Fsync":                     reflect.ValueOf(q.Fsync),
			"Ftruncate":                 reflect.ValueOf(q.Ftruncate),
			"Futimes":                   reflect.ValueOf(q.Futimes),
			"Getdirentries":             reflect.ValueOf(q.Getdirentries),
			"Getdtablesize":             reflect.ValueOf(q.Getdtablesize),
			"Getegid":                   reflect.ValueOf(q.Getegid),
			"Getenv":                    reflect.ValueOf(q.Getenv),
			"Geteuid":                   reflect.ValueOf(q.Geteuid),
			"Getfsstat":                 reflect.ValueOf(q.Getfsstat),
			"Getgid":                    reflect.ValueOf(q.Getgid),
			"Getgroups":                 reflect.ValueOf(q.Getgroups),
			"Getpagesize":               reflect.ValueOf(q.Getpagesize),
			"Getpeername":               reflect.ValueOf(q.Getpeername),
			"Getpgid":                   reflect.ValueOf(q.Getpgid),
			"Getpgrp":                   reflect.ValueOf(q.Getpgrp),
			"Getpid":                    reflect.ValueOf(q.Getpid),
			"Getppid":                   reflect.ValueOf(q.Getppid),
			"Getpriority":               reflect.ValueOf(q.Getpriority),
			"Getrlimit":                 reflect.ValueOf(q.Getrlimit),
			"Getrusage":                 reflect.ValueOf(q.Getrusage),
			"Getsid":                    reflect.ValueOf(q.Getsid),
			"Getsockname":               reflect.ValueOf(q.Getsockname),
			"GetsockoptByte":            reflect.ValueOf(q.GetsockoptByte),
			"GetsockoptICMPv6Filter":    reflect.ValueOf(q.GetsockoptICMPv6Filter),
			"GetsockoptIPMreq":          reflect.ValueOf(q.GetsockoptIPMreq),
			"GetsockoptIPv6MTUInfo":     reflect.ValueOf(q.GetsockoptIPv6MTUInfo),
			"GetsockoptIPv6Mreq":        reflect.ValueOf(q.GetsockoptIPv6Mreq),
			"GetsockoptInet4Addr":       reflect.ValueOf(q.GetsockoptInet4Addr),
			"GetsockoptInt":             reflect.ValueOf(q.GetsockoptInt),
			"Gettimeofday":              reflect.ValueOf(q.Gettimeofday),
			"Getuid":                    reflect.ValueOf(q.Getuid),
			"Getwd":                     reflect.ValueOf(q.Getwd),
			"Issetugid":                 reflect.ValueOf(q.Issetugid),
			"Kevent":                    reflect.ValueOf(q.Kevent),
			"Kill":                      reflect.ValueOf(q.Kill),
			"Kqueue":                    reflect.ValueOf(q.Kqueue),
			"Lchown":                    reflect.ValueOf(q.Lchown),
			"Link":                      reflect.ValueOf(q.Link),
			"Listen":                    reflect.ValueOf(q.Listen),
			"Lstat":                     reflect.ValueOf(q.Lstat),
			"Mkdir":                     reflect.ValueOf(q.Mkdir),
			"Mkfifo":                    reflect.ValueOf(q.Mkfifo),
			"Mknod":                     reflect.ValueOf(q.Mknod),
			"Mmap":                      reflect.ValueOf(q.Mmap),
			"Munmap":                    reflect.ValueOf(q.Munmap),
			"Nanosleep":                 reflect.ValueOf(q.Nanosleep),
			"NsecToTimespec":            reflect.ValueOf(q.NsecToTimespec),
			"NsecToTimeval":             reflect.ValueOf(q.NsecToTimeval),
			"Open":                      reflect.ValueOf(q.Open),
			"ParseDirent":               reflect.ValueOf(q.ParseDirent),
			"ParseRoutingMessage":       reflect.ValueOf(q.ParseRoutingMessage),
			"ParseRoutingSockaddr":      reflect.ValueOf(q.ParseRoutingSockaddr),
			"ParseSocketControlMessage": reflect.ValueOf(q.ParseSocketControlMessage),
			"ParseUnixRights":           reflect.ValueOf(q.ParseUnixRights),
			"Pathconf":                  reflect.ValueOf(q.Pathconf),
			"Pipe":                      reflect.ValueOf(q.Pipe),
			"Pipe2":                     reflect.ValueOf(q.Pipe2),
			"Pread":                     reflect.ValueOf(q.Pread),
			"Pwrite":                    reflect.ValueOf(q.Pwrite),
			"RawSyscall":                reflect.ValueOf(q.RawSyscall),
			"RawSyscall6":               reflect.ValueOf(q.RawSyscall6),
			"Read":                      reflect.ValueOf(q.Read),
			"ReadDirent":                reflect.ValueOf(q.ReadDirent),
			"Readlink":                  reflect.ValueOf(q.Readlink),
			"Recvfrom":                  reflect.ValueOf(q.Recvfrom),
			"Recvmsg":                   reflect.ValueOf(q.Recvmsg),
			"Rename":                    reflect.ValueOf(q.Rename),
			"Revoke":                    reflect.ValueOf(q.Revoke),
			"Rmdir":                     reflect.ValueOf(q.Rmdir),
			"RouteRIB":                  reflect.ValueOf(q.RouteRIB),
			"Seek":                      reflect.ValueOf(q.Seek),
			"Select":                    reflect.ValueOf(q.Select),
			"Sendfile":                  reflect.ValueOf(q.Sendfile),
			"Sendmsg":                   reflect.ValueOf(q.Sendmsg),
			"SendmsgN":                  reflect.ValueOf(q.SendmsgN),
			"Sendto":                    reflect.ValueOf(q.Sendto),
			"SetBpf":                    reflect.ValueOf(q.SetBpf),
			"SetBpfBuflen":              reflect.ValueOf(q.SetBpfBuflen),
			"SetBpfDatalink":            reflect.ValueOf(q.SetBpfDatalink),
			"SetBpfHeadercmpl":          reflect.ValueOf(q.SetBpfHeadercmpl),
			"SetBpfImmediate":           reflect.ValueOf(q.SetBpfImmediate),
			"SetBpfInterface":           reflect.ValueOf(q.SetBpfInterface),
			"SetBpfPromisc":             reflect.ValueOf(q.SetBpfPromisc),
			"SetBpfTimeout":             reflect.ValueOf(q.SetBpfTimeout),
			"SetKevent":                 reflect.ValueOf(q.SetKevent),
			"SetNonblock":               reflect.ValueOf(q.SetNonblock),
			"Setegid":                   reflect.ValueOf(q.Setegid),
			"Setenv":                    reflect.ValueOf(q.Setenv),
			"Seteuid":                   reflect.ValueOf(q.Seteuid),
			"Setgid":                    reflect.ValueOf(q.Setgid),
			"Setgroups":                 reflect.ValueOf(q.Setgroups),
			"Setlogin":                  reflect.ValueOf(q.Setlogin),
			"Setpgid":                   reflect.ValueOf(q.Setpgid),
			"Setpriority":               reflect.ValueOf(q.Setpriority),
			"Setregid":                  reflect.ValueOf(q.Setregid),
			"Setreuid":                  reflect.ValueOf(q.Setreuid),
			"Setrlimit":                 reflect.ValueOf(q.Setrlimit),
			"Setsid":                    reflect.ValueOf(q.Setsid),
			"SetsockoptByte":            reflect.ValueOf(q.SetsockoptByte),
			"SetsockoptICMPv6Filter":    reflect.ValueOf(q.SetsockoptICMPv6Filter),
			"SetsockoptIPMreq":          reflect.ValueOf(q.SetsockoptIPMreq),
			"SetsockoptIPv6Mreq":        reflect.ValueOf(q.SetsockoptIPv6Mreq),
			"SetsockoptInet4Addr":       reflect.ValueOf(q.SetsockoptInet4Addr),
			"SetsockoptInt":             reflect.ValueOf(q.SetsockoptInt),
			"SetsockoptLinger":          reflect.ValueOf(q.SetsockoptLinger),
			"SetsockoptString":          reflect.ValueOf(q.SetsockoptString),
			"SetsockoptTimeval":         reflect.ValueOf(q.SetsockoptTimeval),
			"Settimeofday":              reflect.ValueOf(q.Settimeofday),
			"Setuid":                    reflect.ValueOf(q.Setuid),
			"Shutdown":                  reflect.ValueOf(q.Shutdown),
			"SlicePtrFromStrings":       reflect.ValueOf(q.SlicePtrFromStrings),
			"Socket":                    reflect.ValueOf(q.Socket),
			"Socketpair":                reflect.ValueOf(q.Socketpair),
			"StartProcess":              reflect.ValueOf(q.StartProcess),
			"Stat":                      reflect.ValueOf(q.Stat),
			"Statfs":                    reflect.ValueOf(q.Statfs),
			"StringBytePtr":             reflect.ValueOf(q.StringBytePtr),
			"StringByteSlice":           reflect.ValueOf(q.StringByteSlice),
			"StringSlicePtr":            reflect.ValueOf(q.StringSlicePtr),
			"Symlink":                   reflect.ValueOf(q.Symlink),
			"Sync":                      reflect.ValueOf(q.Sync),
			"Syscall":                   reflect.ValueOf(q.Syscall),
			"Syscall6":                  reflect.ValueOf(q.Syscall6),
			"Syscall9":                  reflect.ValueOf(q.Syscall9),
			"Sysctl":                    reflect.ValueOf(q.Sysctl),
			"SysctlUint32":              reflect.ValueOf(q.SysctlUint32),
			"TimespecToNsec":            reflect.ValueOf(q.TimespecToNsec),
			"TimevalToNsec":             reflect.ValueOf(q.TimevalToNsec),
			"Truncate":                  reflect.ValueOf(q.Truncate),
			"Umask":                     reflect.ValueOf(q.Umask),
			"Undelete":                  reflect.ValueOf(q.Undelete),
			"UnixRights":                reflect.ValueOf(q.UnixRights),
			"Unlink":                    reflect.ValueOf(q.Unlink),
			"Unmount":                   reflect.ValueOf(q.Unmount),
			"Unsetenv":                  reflect.ValueOf(q.Unsetenv),
			"Utimes":                    reflect.ValueOf(q.Utimes),
			"UtimesNano":                reflect.ValueOf(q.UtimesNano),
			"Wait4":                     reflect.ValueOf(q.Wait4),
			"Write":                     reflect.ValueOf(q.Write),
		},
		TypedConsts: map[string]igop.TypedConst{
			"E2BIG":           {reflect.TypeOf(q.E2BIG), constant.MakeInt64(int64(q.E2BIG))},
			"EACCES":          {reflect.TypeOf(q.EACCES), constant.MakeInt64(int64(q.EACCES))},
			"EADDRINUSE":      {reflect.TypeOf(q.EADDRINUSE), constant.MakeInt64(int64(q.EADDRINUSE))},
			"EADDRNOTAVAIL":   {reflect.TypeOf(q.EADDRNOTAVAIL), constant.MakeInt64(int64(q.EADDRNOTAVAIL))},
			"EAFNOSUPPORT":    {reflect.TypeOf(q.EAFNOSUPPORT), constant.MakeInt64(int64(q.EAFNOSUPPORT))},
			"EAGAIN":          {reflect.TypeOf(q.EAGAIN), constant.MakeInt64(int64(q.EAGAIN))},
			"EALREADY":        {reflect.TypeOf(q.EALREADY), constant.MakeInt64(int64(q.EALREADY))},
			"EASYNC":          {reflect.TypeOf(q.EASYNC), constant.MakeInt64(int64(q.EASYNC))},
			"EAUTH":           {reflect.TypeOf(q.EAUTH), constant.MakeInt64(int64(q.EAUTH))},
			"EBADF":           {reflect.TypeOf(q.EBADF), constant.MakeInt64(int64(q.EBADF))},
			"EBADMSG":         {reflect.TypeOf(q.EBADMSG), constant.MakeInt64(int64(q.EBADMSG))},
			"EBADRPC":         {reflect.TypeOf(q.EBADRPC), constant.MakeInt64(int64(q.EBADRPC))},
			"EBUSY":           {reflect.TypeOf(q.EBUSY), constant.MakeInt64(int64(q.EBUSY))},
			"ECANCELED":       {reflect.TypeOf(q.ECANCELED), constant.MakeInt64(int64(q.ECANCELED))},
			"ECHILD":          {reflect.TypeOf(q.ECHILD), constant.MakeInt64(int64(q.ECHILD))},
			"ECONNABORTED":    {reflect.TypeOf(q.ECONNABORTED), constant.MakeInt64(int64(q.ECONNABORTED))},
			"ECONNREFUSED":    {reflect.TypeOf(q.ECONNREFUSED), constant.MakeInt64(int64(q.ECONNREFUSED))},
			"ECONNRESET":      {reflect.TypeOf(q.ECONNRESET), constant.MakeInt64(int64(q.ECONNRESET))},
			"EDEADLK":         {reflect.TypeOf(q.EDEADLK), constant.MakeInt64(int64(q.EDEADLK))},
			"EDESTADDRREQ":    {reflect.TypeOf(q.EDESTADDRREQ), constant.MakeInt64(int64(q.EDESTADDRREQ))},
			"EDOM":            {reflect.TypeOf(q.EDOM), constant.MakeInt64(int64(q.EDOM))},
			"EDOOFUS":         {reflect.TypeOf(q.EDOOFUS), constant.MakeInt64(int64(q.EDOOFUS))},
			"EDQUOT":          {reflect.TypeOf(q.EDQUOT), constant.MakeInt64(int64(q.EDQUOT))},
			"EEXIST":          {reflect.TypeOf(q.EEXIST), constant.MakeInt64(int64(q.EEXIST))},
			"EFAULT":          {reflect.TypeOf(q.EFAULT), constant.MakeInt64(int64(q.EFAULT))},
			"EFBIG":           {reflect.TypeOf(q.EFBIG), constant.MakeInt64(int64(q.EFBIG))},
			"EFTYPE":          {reflect.TypeOf(q.EFTYPE), constant.MakeInt64(int64(q.EFTYPE))},
			"EHOSTDOWN":       {reflect.TypeOf(q.EHOSTDOWN), constant.MakeInt64(int64(q.EHOSTDOWN))},
			"EHOSTUNREACH":    {reflect.TypeOf(q.EHOSTUNREACH), constant.MakeInt64(int64(q.EHOSTUNREACH))},
			"EIDRM":           {reflect.TypeOf(q.EIDRM), constant.MakeInt64(int64(q.EIDRM))},
			"EILSEQ":          {reflect.TypeOf(q.EILSEQ), constant.MakeInt64(int64(q.EILSEQ))},
			"EINPROGRESS":     {reflect.TypeOf(q.EINPROGRESS), constant.MakeInt64(int64(q.EINPROGRESS))},
			"EINTR":           {reflect.TypeOf(q.EINTR), constant.MakeInt64(int64(q.EINTR))},
			"EINVAL":          {reflect.TypeOf(q.EINVAL), constant.MakeInt64(int64(q.EINVAL))},
			"EIO":             {reflect.TypeOf(q.EIO), constant.MakeInt64(int64(q.EIO))},
			"EISCONN":         {reflect.TypeOf(q.EISCONN), constant.MakeInt64(int64(q.EISCONN))},
			"EISDIR":          {reflect.TypeOf(q.EISDIR), constant.MakeInt64(int64(q.EISDIR))},
			"ELAST":           {reflect.TypeOf(q.ELAST), constant.MakeInt64(int64(q.ELAST))},
			"ELOOP":           {reflect.TypeOf(q.ELOOP), constant.MakeInt64(int64(q.ELOOP))},
			"EMFILE":          {reflect.TypeOf(q.EMFILE), constant.MakeInt64(int64(q.EMFILE))},
			"EMLINK":          {reflect.TypeOf(q.EMLINK), constant.MakeInt64(int64(q.EMLINK))},
			"EMSGSIZE":        {reflect.TypeOf(q.EMSGSIZE), constant.MakeInt64(int64(q.EMSGSIZE))},
			"EMULTIHOP":       {reflect.TypeOf(q.EMULTIHOP), constant.MakeInt64(int64(q.EMULTIHOP))},
			"ENAMETOOLONG":    {reflect.TypeOf(q.ENAMETOOLONG), constant.MakeInt64(int64(q.ENAMETOOLONG))},
			"ENEEDAUTH":       {reflect.TypeOf(q.ENEEDAUTH), constant.MakeInt64(int64(q.ENEEDAUTH))},
			"ENETDOWN":        {reflect.TypeOf(q.ENETDOWN), constant.MakeInt64(int64(q.ENETDOWN))},
			"ENETRESET":       {reflect.TypeOf(q.ENETRESET), constant.MakeInt64(int64(q.ENETRESET))},
			"ENETUNREACH":     {reflect.TypeOf(q.ENETUNREACH), constant.MakeInt64(int64(q.ENETUNREACH))},
			"ENFILE":          {reflect.TypeOf(q.ENFILE), constant.MakeInt64(int64(q.ENFILE))},
			"ENOATTR":         {reflect.TypeOf(q.ENOATTR), constant.MakeInt64(int64(q.ENOATTR))},
			"ENOBUFS":         {reflect.TypeOf(q.ENOBUFS), constant.MakeInt64(int64(q.ENOBUFS))},
			"ENODEV":          {reflect.TypeOf(q.ENODEV), constant.MakeInt64(int64(q.ENODEV))},
			"ENOENT":          {reflect.TypeOf(q.ENOENT), constant.MakeInt64(int64(q.ENOENT))},
			"ENOEXEC":         {reflect.TypeOf(q.ENOEXEC), constant.MakeInt64(int64(q.ENOEXEC))},
			"ENOLCK":          {reflect.TypeOf(q.ENOLCK), constant.MakeInt64(int64(q.ENOLCK))},
			"ENOLINK":         {reflect.TypeOf(q.ENOLINK), constant.MakeInt64(int64(q.ENOLINK))},
			"ENOMEDIUM":       {reflect.TypeOf(q.ENOMEDIUM), constant.MakeInt64(int64(q.ENOMEDIUM))},
			"ENOMEM":          {reflect.TypeOf(q.ENOMEM), constant.MakeInt64(int64(q.ENOMEM))},
			"ENOMSG":          {reflect.TypeOf(q.ENOMSG), constant.MakeInt64(int64(q.ENOMSG))},
			"ENOPROTOOPT":     {reflect.TypeOf(q.ENOPROTOOPT), constant.MakeInt64(int64(q.ENOPROTOOPT))},
			"ENOSPC":          {reflect.TypeOf(q.ENOSPC), constant.MakeInt64(int64(q.ENOSPC))},
			"ENOSYS":          {reflect.TypeOf(q.ENOSYS), constant.MakeInt64(int64(q.ENOSYS))},
			"ENOTBLK":         {reflect.TypeOf(q.ENOTBLK), constant.MakeInt64(int64(q.ENOTBLK))},
			"ENOTCONN":        {reflect.TypeOf(q.ENOTCONN), constant.MakeInt64(int64(q.ENOTCONN))},
			"ENOTDIR":         {reflect.TypeOf(q.ENOTDIR), constant.MakeInt64(int64(q.ENOTDIR))},
			"ENOTEMPTY":       {reflect.TypeOf(q.ENOTEMPTY), constant.MakeInt64(int64(q.ENOTEMPTY))},
			"ENOTSOCK":        {reflect.TypeOf(q.ENOTSOCK), constant.MakeInt64(int64(q.ENOTSOCK))},
			"ENOTSUP":         {reflect.TypeOf(q.ENOTSUP), constant.MakeInt64(int64(q.ENOTSUP))},
			"ENOTTY":          {reflect.TypeOf(q.ENOTTY), constant.MakeInt64(int64(q.ENOTTY))},
			"ENXIO":           {reflect.TypeOf(q.ENXIO), constant.MakeInt64(int64(q.ENXIO))},
			"EOPNOTSUPP":      {reflect.TypeOf(q.EOPNOTSUPP), constant.MakeInt64(int64(q.EOPNOTSUPP))},
			"EOVERFLOW":       {reflect.TypeOf(q.EOVERFLOW), constant.MakeInt64(int64(q.EOVERFLOW))},
			"EPERM":           {reflect.TypeOf(q.EPERM), constant.MakeInt64(int64(q.EPERM))},
			"EPFNOSUPPORT":    {reflect.TypeOf(q.EPFNOSUPPORT), constant.MakeInt64(int64(q.EPFNOSUPPORT))},
			"EPIPE":           {reflect.TypeOf(q.EPIPE), constant.MakeInt64(int64(q.EPIPE))},
			"EPROCLIM":        {reflect.TypeOf(q.EPROCLIM), constant.MakeInt64(int64(q.EPROCLIM))},
			"EPROCUNAVAIL":    {reflect.TypeOf(q.EPROCUNAVAIL), constant.MakeInt64(int64(q.EPROCUNAVAIL))},
			"EPROGMISMATCH":   {reflect.TypeOf(q.EPROGMISMATCH), constant.MakeInt64(int64(q.EPROGMISMATCH))},
			"EPROGUNAVAIL":    {reflect.TypeOf(q.EPROGUNAVAIL), constant.MakeInt64(int64(q.EPROGUNAVAIL))},
			"EPROTO":          {reflect.TypeOf(q.EPROTO), constant.MakeInt64(int64(q.EPROTO))},
			"EPROTONOSUPPORT": {reflect.TypeOf(q.EPROTONOSUPPORT), constant.MakeInt64(int64(q.EPROTONOSUPPORT))},
			"EPROTOTYPE":      {reflect.TypeOf(q.EPROTOTYPE), constant.MakeInt64(int64(q.EPROTOTYPE))},
			"ERANGE":          {reflect.TypeOf(q.ERANGE), constant.MakeInt64(int64(q.ERANGE))},
			"EREMOTE":         {reflect.TypeOf(q.EREMOTE), constant.MakeInt64(int64(q.EREMOTE))},
			"EROFS":           {reflect.TypeOf(q.EROFS), constant.MakeInt64(int64(q.EROFS))},
			"ERPCMISMATCH":    {reflect.TypeOf(q.ERPCMISMATCH), constant.MakeInt64(int64(q.ERPCMISMATCH))},
			"ESHUTDOWN":       {reflect.TypeOf(q.ESHUTDOWN), constant.MakeInt64(int64(q.ESHUTDOWN))},
			"ESOCKTNOSUPPORT": {reflect.TypeOf(q.ESOCKTNOSUPPORT), constant.MakeInt64(int64(q.ESOCKTNOSUPPORT))},
			"ESPIPE":          {reflect.TypeOf(q.ESPIPE), constant.MakeInt64(int64(q.ESPIPE))},
			"ESRCH":           {reflect.TypeOf(q.ESRCH), constant.MakeInt64(int64(q.ESRCH))},
			"ESTALE":          {reflect.TypeOf(q.ESTALE), constant.MakeInt64(int64(q.ESTALE))},
			"ETIMEDOUT":       {reflect.TypeOf(q.ETIMEDOUT), constant.MakeInt64(int64(q.ETIMEDOUT))},
			"ETOOMANYREFS":    {reflect.TypeOf(q.ETOOMANYREFS), constant.MakeInt64(int64(q.ETOOMANYREFS))},
			"ETXTBSY":         {reflect.TypeOf(q.ETXTBSY), constant.MakeInt64(int64(q.ETXTBSY))},
			"EUNUSED94":       {reflect.TypeOf(q.EUNUSED94), constant.MakeInt64(int64(q.EUNUSED94))},
			"EUNUSED95":       {reflect.TypeOf(q.EUNUSED95), constant.MakeInt64(int64(q.EUNUSED95))},
			"EUNUSED96":       {reflect.TypeOf(q.EUNUSED96), constant.MakeInt64(int64(q.EUNUSED96))},
			"EUNUSED97":       {reflect.TypeOf(q.EUNUSED97), constant.MakeInt64(int64(q.EUNUSED97))},
			"EUNUSED98":       {reflect.TypeOf(q.EUNUSED98), constant.MakeInt64(int64(q.EUNUSED98))},
			"EUSERS":          {reflect.TypeOf(q.EUSERS), constant.MakeInt64(int64(q.EUSERS))},
			"EWOULDBLOCK":     {reflect.TypeOf(q.EWOULDBLOCK), constant.MakeInt64(int64(q.EWOULDBLOCK))},
			"EXDEV":           {reflect.TypeOf(q.EXDEV), constant.MakeInt64(int64(q.EXDEV))},
			"SIGABRT":         {reflect.TypeOf(q.SIGABRT), constant.MakeInt64(int64(q.SIGABRT))},
			"SIGALRM":         {reflect.TypeOf(q.SIGALRM), constant.MakeInt64(int64(q.SIGALRM))},
			"SIGBUS":          {reflect.TypeOf(q.SIGBUS), constant.MakeInt64(int64(q.SIGBUS))},
			"SIGCHLD":         {reflect.TypeOf(q.SIGCHLD), constant.MakeInt64(int64(q.SIGCHLD))},
			"SIGCKPT":         {reflect.TypeOf(q.SIGCKPT), constant.MakeInt64(int64(q.SIGCKPT))},
			"SIGCKPTEXIT":     {reflect.TypeOf(q.SIGCKPTEXIT), constant.MakeInt64(int64(q.SIGCKPTEXIT))},
			"SIGCONT":         {reflect.TypeOf(q.SIGCONT), constant.MakeInt64(int64(q.SIGCONT))},
			"SIGEMT":          {reflect.TypeOf(q.SIGEMT), constant.MakeInt64(int64(q.SIGEMT))},
			"SIGFPE":          {reflect.TypeOf(q.SIGFPE), constant.MakeInt64(int64(q.SIGFPE))},
			"SIGHUP":          {reflect.TypeOf(q.SIGHUP), constant.MakeInt64(int64(q.SIGHUP))},
			"SIGILL":          {reflect.TypeOf(q.SIGILL), constant.MakeInt64(int64(q.SIGILL))},
			"SIGINFO":         {reflect.TypeOf(q.SIGINFO), constant.MakeInt64(int64(q.SIGINFO))},
			"SIGINT":          {reflect.TypeOf(q.SIGINT), constant.MakeInt64(int64(q.SIGINT))},
			"SIGIO":           {reflect.TypeOf(q.SIGIO), constant.MakeInt64(int64(q.SIGIO))},
			"SIGIOT":          {reflect.TypeOf(q.SIGIOT), constant.MakeInt64(int64(q.SIGIOT))},
			"SIGKILL":         {reflect.TypeOf(q.SIGKILL), constant.MakeInt64(int64(q.SIGKILL))},
			"SIGPIPE":         {reflect.TypeOf(q.SIGPIPE), constant.MakeInt64(int64(q.SIGPIPE))},
			"SIGPROF":         {reflect.TypeOf(q.SIGPROF), constant.MakeInt64(int64(q.SIGPROF))},
			"SIGQUIT":         {reflect.TypeOf(q.SIGQUIT), constant.MakeInt64(int64(q.SIGQUIT))},
			"SIGSEGV":         {reflect.TypeOf(q.SIGSEGV), constant.MakeInt64(int64(q.SIGSEGV))},
			"SIGSTOP":         {reflect.TypeOf(q.SIGSTOP), constant.MakeInt64(int64(q.SIGSTOP))},
			"SIGSYS":          {reflect.TypeOf(q.SIGSYS), constant.MakeInt64(int64(q.SIGSYS))},
			"SIGTERM":         {reflect.TypeOf(q.SIGTERM), constant.MakeInt64(int64(q.SIGTERM))},
			"SIGTHR":          {reflect.TypeOf(q.SIGTHR), constant.MakeInt64(int64(q.SIGTHR))},
			"SIGTRAP":         {reflect.TypeOf(q.SIGTRAP), constant.MakeInt64(int64(q.SIGTRAP))},
			"SIGTSTP":         {reflect.TypeOf(q.SIGTSTP), constant.MakeInt64(int64(q.SIGTSTP))},
			"SIGTTIN":         {reflect.TypeOf(q.SIGTTIN), constant.MakeInt64(int64(q.SIGTTIN))},
			"SIGTTOU":         {reflect.TypeOf(q.SIGTTOU), constant.MakeInt64(int64(q.SIGTTOU))},
			"SIGURG":          {reflect.TypeOf(q.SIGURG), constant.MakeInt64(int64(q.SIGURG))},
			"SIGUSR1":         {reflect.TypeOf(q.SIGUSR1), constant.MakeInt64(int64(q.SIGUSR1))},
			"SIGUSR2":         {reflect.TypeOf(q.SIGUSR2), constant.MakeInt64(int64(q.SIGUSR2))},
			"SIGVTALRM":       {reflect.TypeOf(q.SIGVTALRM), constant.MakeInt64(int64(q.SIGVTALRM))},
			"SIGWINCH":        {reflect.TypeOf(q.SIGWINCH), constant.MakeInt64(int64(q.SIGWINCH))},
			"SIGXCPU":         {reflect.TypeOf(q.SIGXCPU), constant.MakeInt64(int64(q.SIGXCPU))},
			"SIGXFSZ":         {reflect.TypeOf(q.SIGXFSZ), constant.MakeInt64(int64(q.SIGXFSZ))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"AF_APPLETALK":                      {"untyped int", constant.MakeInt64(int64(q.AF_APPLETALK))},
			"AF_ATM":                            {"untyped int", constant.MakeInt64(int64(q.AF_ATM))},
			"AF_BLUETOOTH":                      {"untyped int", constant.MakeInt64(int64(q.AF_BLUETOOTH))},
			"AF_CCITT":                          {"untyped int", constant.MakeInt64(int64(q.AF_CCITT))},
			"AF_CHAOS":                          {"untyped int", constant.MakeInt64(int64(q.AF_CHAOS))},
			"AF_CNT":                            {"untyped int", constant.MakeInt64(int64(q.AF_CNT))},
			"AF_COIP":                           {"untyped int", constant.MakeInt64(int64(q.AF_COIP))},
			"AF_DATAKIT":                        {"untyped int", constant.MakeInt64(int64(q.AF_DATAKIT))},
			"AF_DECnet":                         {"untyped int", constant.MakeInt64(int64(q.AF_DECnet))},
			"AF_DLI":                            {"untyped int", constant.MakeInt64(int64(q.AF_DLI))},
			"AF_E164":                           {"untyped int", constant.MakeInt64(int64(q.AF_E164))},
			"AF_ECMA":                           {"untyped int", constant.MakeInt64(int64(q.AF_ECMA))},
			"AF_HYLINK":                         {"untyped int", constant.MakeInt64(int64(q.AF_HYLINK))},
			"AF_IEEE80211":                      {"untyped int", constant.MakeInt64(int64(q.AF_IEEE80211))},
			"AF_IMPLINK":                        {"untyped int", constant.MakeInt64(int64(q.AF_IMPLINK))},
			"AF_INET":                           {"untyped int", constant.MakeInt64(int64(q.AF_INET))},
			"AF_INET6":                          {"untyped int", constant.MakeInt64(int64(q.AF_INET6))},
			"AF_IPX":                            {"untyped int", constant.MakeInt64(int64(q.AF_IPX))},
			"AF_ISDN":                           {"untyped int", constant.MakeInt64(int64(q.AF_ISDN))},
			"AF_ISO":                            {"untyped int", constant.MakeInt64(int64(q.AF_ISO))},
			"AF_LAT":                            {"untyped int", constant.MakeInt64(int64(q.AF_LAT))},
			"AF_LINK":                           {"untyped int", constant.MakeInt64(int64(q.AF_LINK))},
			"AF_LOCAL":                          {"untyped int", constant.MakeInt64(int64(q.AF_LOCAL))},
			"AF_MAX":                            {"untyped int", constant.MakeInt64(int64(q.AF_MAX))},
			"AF_MPLS":                           {"untyped int", constant.MakeInt64(int64(q.AF_MPLS))},
			"AF_NATM":                           {"untyped int", constant.MakeInt64(int64(q.AF_NATM))},
			"AF_NETGRAPH":                       {"untyped int", constant.MakeInt64(int64(q.AF_NETGRAPH))},
			"AF_NS":                             {"untyped int", constant.MakeInt64(int64(q.AF_NS))},
			"AF_OSI":                            {"untyped int", constant.MakeInt64(int64(q.AF_OSI))},
			"AF_PUP":                            {"untyped int", constant.MakeInt64(int64(q.AF_PUP))},
			"AF_ROUTE":                          {"untyped int", constant.MakeInt64(int64(q.AF_ROUTE))},
			"AF_SIP":                            {"untyped int", constant.MakeInt64(int64(q.AF_SIP))},
			"AF_SNA":                            {"untyped int", constant.MakeInt64(int64(q.AF_SNA))},
			"AF_UNIX":                           {"untyped int", constant.MakeInt64(int64(q.AF_UNIX))},
			"AF_UNSPEC":                         {"untyped int", constant.MakeInt64(int64(q.AF_UNSPEC))},
			"B0":                                {"untyped int", constant.MakeInt64(int64(q.B0))},
			"B110":                              {"untyped int", constant.MakeInt64(int64(q.B110))},
			"B115200":                           {"untyped int", constant.MakeInt64(int64(q.B115200))},
			"B1200":                             {"untyped int", constant.MakeInt64(int64(q.B1200))},
			"B134":                              {"untyped int", constant.MakeInt64(int64(q.B134))},
			"B14400":                            {"untyped int", constant.MakeInt64(int64(q.B14400))},
			"B150":                              {"untyped int", constant.MakeInt64(int64(q.B150))},
			"B1800":                             {"untyped int", constant.MakeInt64(int64(q.B1800))},
			"B19200":                            {"untyped int", constant.MakeInt64(int64(q.B19200))},
			"B200":                              {"untyped int", constant.MakeInt64(int64(q.B200))},
			"B230400":                           {"untyped int", constant.MakeInt64(int64(q.B230400))},
			"B2400":                             {"untyped int", constant.MakeInt64(int64(q.B2400))},
			"B28800":                            {"untyped int", constant.MakeInt64(int64(q.B28800))},
			"B300":                              {"untyped int", constant.MakeInt64(int64(q.B300))},
			"B38400":                            {"untyped int", constant.MakeInt64(int64(q.B38400))},
			"B4800":                             {"untyped int", constant.MakeInt64(int64(q.B4800))},
			"B50":                               {"untyped int", constant.MakeInt64(int64(q.B50))},
			"B57600":                            {"untyped int", constant.MakeInt64(int64(q.B57600))},
			"B600":                              {"untyped int", constant.MakeInt64(int64(q.B600))},
			"B7200":                             {"untyped int", constant.MakeInt64(int64(q.B7200))},
			"B75":                               {"untyped int", constant.MakeInt64(int64(q.B75))},
			"B76800":                            {"untyped int", constant.MakeInt64(int64(q.B76800))},
			"B9600":                             {"untyped int", constant.MakeInt64(int64(q.B9600))},
			"BIOCFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.BIOCFLUSH))},
			"BIOCGBLEN":                         {"untyped int", constant.MakeInt64(int64(q.BIOCGBLEN))},
			"BIOCGDLT":                          {"untyped int", constant.MakeInt64(int64(q.BIOCGDLT))},
			"BIOCGDLTLIST":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGDLTLIST))},
			"BIOCGETIF":                         {"untyped int", constant.MakeInt64(int64(q.BIOCGETIF))},
			"BIOCGHDRCMPLT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCGHDRCMPLT))},
			"BIOCGRSIG":                         {"untyped int", constant.MakeInt64(int64(q.BIOCGRSIG))},
			"BIOCGRTIMEOUT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCGRTIMEOUT))},
			"BIOCGSEESENT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGSEESENT))},
			"BIOCGSTATS":                        {"untyped int", constant.MakeInt64(int64(q.BIOCGSTATS))},
			"BIOCIMMEDIATE":                     {"untyped int", constant.MakeInt64(int64(q.BIOCIMMEDIATE))},
			"BIOCLOCK":                          {"untyped int", constant.MakeInt64(int64(q.BIOCLOCK))},
			"BIOCPROMISC":                       {"untyped int", constant.MakeInt64(int64(q.BIOCPROMISC))},
			"BIOCSBLEN":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSBLEN))},
			"BIOCSDLT":                          {"untyped int", constant.MakeInt64(int64(q.BIOCSDLT))},
			"BIOCSETF":                          {"untyped int", constant.MakeInt64(int64(q.BIOCSETF))},
			"BIOCSETIF":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSETIF))},
			"BIOCSETWF":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSETWF))},
			"BIOCSHDRCMPLT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSHDRCMPLT))},
			"BIOCSRSIG":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSRSIG))},
			"BIOCSRTIMEOUT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSRTIMEOUT))},
			"BIOCSSEESENT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCSSEESENT))},
			"BIOCVERSION":                       {"untyped int", constant.MakeInt64(int64(q.BIOCVERSION))},
			"BPF_A":                             {"untyped int", constant.MakeInt64(int64(q.BPF_A))},
			"BPF_ABS":                           {"untyped int", constant.MakeInt64(int64(q.BPF_ABS))},
			"BPF_ADD":                           {"untyped int", constant.MakeInt64(int64(q.BPF_ADD))},
			"BPF_ALIGNMENT":                     {"untyped int", constant.MakeInt64(int64(q.BPF_ALIGNMENT))},
			"BPF_ALU":                           {"untyped int", constant.MakeInt64(int64(q.BPF_ALU))},
			"BPF_AND":                           {"untyped int", constant.MakeInt64(int64(q.BPF_AND))},
			"BPF_B":                             {"untyped int", constant.MakeInt64(int64(q.BPF_B))},
			"BPF_DEFAULTBUFSIZE":                {"untyped int", constant.MakeInt64(int64(q.BPF_DEFAULTBUFSIZE))},
			"BPF_DIV":                           {"untyped int", constant.MakeInt64(int64(q.BPF_DIV))},
			"BPF_H":                             {"untyped int", constant.MakeInt64(int64(q.BPF_H))},
			"BPF_IMM":                           {"untyped int", constant.MakeInt64(int64(q.BPF_IMM))},
			"BPF_IND":                           {"untyped int", constant.MakeInt64(int64(q.BPF_IND))},
			"BPF_JA":                            {"untyped int", constant.MakeInt64(int64(q.BPF_JA))},
			"BPF_JEQ":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JEQ))},
			"BPF_JGE":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JGE))},
			"BPF_JGT":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JGT))},
			"BPF_JMP":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JMP))},
			"BPF_JSET":                          {"untyped int", constant.MakeInt64(int64(q.BPF_JSET))},
			"BPF_K":                             {"untyped int", constant.MakeInt64(int64(q.BPF_K))},
			"BPF_LD":                            {"untyped int", constant.MakeInt64(int64(q.BPF_LD))},
			"BPF_LDX":                           {"untyped int", constant.MakeInt64(int64(q.BPF_LDX))},
			"BPF_LEN":                           {"untyped int", constant.MakeInt64(int64(q.BPF_LEN))},
			"BPF_LSH":                           {"untyped int", constant.MakeInt64(int64(q.BPF_LSH))},
			"BPF_MAJOR_VERSION":                 {"untyped int", constant.MakeInt64(int64(q.BPF_MAJOR_VERSION))},
			"BPF_MAXBUFSIZE":                    {"untyped int", constant.MakeInt64(int64(q.BPF_MAXBUFSIZE))},
			"BPF_MAXINSNS":                      {"untyped int", constant.MakeInt64(int64(q.BPF_MAXINSNS))},
			"BPF_MAX_CLONES":                    {"untyped int", constant.MakeInt64(int64(q.BPF_MAX_CLONES))},
			"BPF_MEM":                           {"untyped int", constant.MakeInt64(int64(q.BPF_MEM))},
			"BPF_MEMWORDS":                      {"untyped int", constant.MakeInt64(int64(q.BPF_MEMWORDS))},
			"BPF_MINBUFSIZE":                    {"untyped int", constant.MakeInt64(int64(q.BPF_MINBUFSIZE))},
			"BPF_MINOR_VERSION":                 {"untyped int", constant.MakeInt64(int64(q.BPF_MINOR_VERSION))},
			"BPF_MISC":                          {"untyped int", constant.MakeInt64(int64(q.BPF_MISC))},
			"BPF_MSH":                           {"untyped int", constant.MakeInt64(int64(q.BPF_MSH))},
			"BPF_MUL":                           {"untyped int", constant.MakeInt64(int64(q.BPF_MUL))},
			"BPF_NEG":                           {"untyped int", constant.MakeInt64(int64(q.BPF_NEG))},
			"BPF_OR":                            {"untyped int", constant.MakeInt64(int64(q.BPF_OR))},
			"BPF_RELEASE":                       {"untyped int", constant.MakeInt64(int64(q.BPF_RELEASE))},
			"BPF_RET":                           {"untyped int", constant.MakeInt64(int64(q.BPF_RET))},
			"BPF_RSH":                           {"untyped int", constant.MakeInt64(int64(q.BPF_RSH))},
			"BPF_ST":                            {"untyped int", constant.MakeInt64(int64(q.BPF_ST))},
			"BPF_STX":                           {"untyped int", constant.MakeInt64(int64(q.BPF_STX))},
			"BPF_SUB":                           {"untyped int", constant.MakeInt64(int64(q.BPF_SUB))},
			"BPF_TAX":                           {"untyped int", constant.MakeInt64(int64(q.BPF_TAX))},
			"BPF_TXA":                           {"untyped int", constant.MakeInt64(int64(q.BPF_TXA))},
			"BPF_W":                             {"untyped int", constant.MakeInt64(int64(q.BPF_W))},
			"BPF_X":                             {"untyped int", constant.MakeInt64(int64(q.BPF_X))},
			"BRKINT":                            {"untyped int", constant.MakeInt64(int64(q.BRKINT))},
			"CFLUSH":                            {"untyped int", constant.MakeInt64(int64(q.CFLUSH))},
			"CLOCAL":                            {"untyped int", constant.MakeInt64(int64(q.CLOCAL))},
			"CREAD":                             {"untyped int", constant.MakeInt64(int64(q.CREAD))},
			"CS5":                               {"untyped int", constant.MakeInt64(int64(q.CS5))},
			"CS6":                               {"untyped int", constant.MakeInt64(int64(q.CS6))},
			"CS7":                               {"untyped int", constant.MakeInt64(int64(q.CS7))},
			"CS8":                               {"untyped int", constant.MakeInt64(int64(q.CS8))},
			"CSIZE":                             {"untyped int", constant.MakeInt64(int64(q.CSIZE))},
			"CSTART":                            {"untyped int", constant.MakeInt64(int64(q.CSTART))},
			"CSTATUS":                           {"untyped int", constant.MakeInt64(int64(q.CSTATUS))},
			"CSTOP":                             {"untyped int", constant.MakeInt64(int64(q.CSTOP))},
			"CSTOPB":                            {"untyped int", constant.MakeInt64(int64(q.CSTOPB))},
			"CSUSP":                             {"untyped int", constant.MakeInt64(int64(q.CSUSP))},
			"CTL_MAXNAME":                       {"untyped int", constant.MakeInt64(int64(q.CTL_MAXNAME))},
			"CTL_NET":                           {"untyped int", constant.MakeInt64(int64(q.CTL_NET))},
			"DLT_A429":                          {"untyped int", constant.MakeInt64(int64(q.DLT_A429))},
			"DLT_A653_ICM":                      {"untyped int", constant.MakeInt64(int64(q.DLT_A653_ICM))},
			"DLT_AIRONET_HEADER":                {"untyped int", constant.MakeInt64(int64(q.DLT_AIRONET_HEADER))},
			"DLT_APPLE_IP_OVER_IEEE1394":        {"untyped int", constant.MakeInt64(int64(q.DLT_APPLE_IP_OVER_IEEE1394))},
			"DLT_ARCNET":                        {"untyped int", constant.MakeInt64(int64(q.DLT_ARCNET))},
			"DLT_ARCNET_LINUX":                  {"untyped int", constant.MakeInt64(int64(q.DLT_ARCNET_LINUX))},
			"DLT_ATM_CLIP":                      {"untyped int", constant.MakeInt64(int64(q.DLT_ATM_CLIP))},
			"DLT_ATM_RFC1483":                   {"untyped int", constant.MakeInt64(int64(q.DLT_ATM_RFC1483))},
			"DLT_AURORA":                        {"untyped int", constant.MakeInt64(int64(q.DLT_AURORA))},
			"DLT_AX25":                          {"untyped int", constant.MakeInt64(int64(q.DLT_AX25))},
			"DLT_AX25_KISS":                     {"untyped int", constant.MakeInt64(int64(q.DLT_AX25_KISS))},
			"DLT_BACNET_MS_TP":                  {"untyped int", constant.MakeInt64(int64(q.DLT_BACNET_MS_TP))},
			"DLT_BLUETOOTH_HCI_H4":              {"untyped int", constant.MakeInt64(int64(q.DLT_BLUETOOTH_HCI_H4))},
			"DLT_BLUETOOTH_HCI_H4_WITH_PHDR":    {"untyped int", constant.MakeInt64(int64(q.DLT_BLUETOOTH_HCI_H4_WITH_PHDR))},
			"DLT_CAN20B":                        {"untyped int", constant.MakeInt64(int64(q.DLT_CAN20B))},
			"DLT_CHAOS":                         {"untyped int", constant.MakeInt64(int64(q.DLT_CHAOS))},
			"DLT_CHDLC":                         {"untyped int", constant.MakeInt64(int64(q.DLT_CHDLC))},
			"DLT_CISCO_IOS":                     {"untyped int", constant.MakeInt64(int64(q.DLT_CISCO_IOS))},
			"DLT_C_HDLC":                        {"untyped int", constant.MakeInt64(int64(q.DLT_C_HDLC))},
			"DLT_C_HDLC_WITH_DIR":               {"untyped int", constant.MakeInt64(int64(q.DLT_C_HDLC_WITH_DIR))},
			"DLT_DOCSIS":                        {"untyped int", constant.MakeInt64(int64(q.DLT_DOCSIS))},
			"DLT_ECONET":                        {"untyped int", constant.MakeInt64(int64(q.DLT_ECONET))},
			"DLT_EN10MB":                        {"untyped int", constant.MakeInt64(int64(q.DLT_EN10MB))},
			"DLT_EN3MB":                         {"untyped int", constant.MakeInt64(int64(q.DLT_EN3MB))},
			"DLT_ENC":                           {"untyped int", constant.MakeInt64(int64(q.DLT_ENC))},
			"DLT_ERF":                           {"untyped int", constant.MakeInt64(int64(q.DLT_ERF))},
			"DLT_ERF_ETH":                       {"untyped int", constant.MakeInt64(int64(q.DLT_ERF_ETH))},
			"DLT_ERF_POS":                       {"untyped int", constant.MakeInt64(int64(q.DLT_ERF_POS))},
			"DLT_FDDI":                          {"untyped int", constant.MakeInt64(int64(q.DLT_FDDI))},
			"DLT_FLEXRAY":                       {"untyped int", constant.MakeInt64(int64(q.DLT_FLEXRAY))},
			"DLT_FRELAY":                        {"untyped int", constant.MakeInt64(int64(q.DLT_FRELAY))},
			"DLT_FRELAY_WITH_DIR":               {"untyped int", constant.MakeInt64(int64(q.DLT_FRELAY_WITH_DIR))},
			"DLT_GCOM_SERIAL":                   {"untyped int", constant.MakeInt64(int64(q.DLT_GCOM_SERIAL))},
			"DLT_GCOM_T1E1":                     {"untyped int", constant.MakeInt64(int64(q.DLT_GCOM_T1E1))},
			"DLT_GPF_F":                         {"untyped int", constant.MakeInt64(int64(q.DLT_GPF_F))},
			"DLT_GPF_T":                         {"untyped int", constant.MakeInt64(int64(q.DLT_GPF_T))},
			"DLT_GPRS_LLC":                      {"untyped int", constant.MakeInt64(int64(q.DLT_GPRS_LLC))},
			"DLT_HHDLC":                         {"untyped int", constant.MakeInt64(int64(q.DLT_HHDLC))},
			"DLT_IBM_SN":                        {"untyped int", constant.MakeInt64(int64(q.DLT_IBM_SN))},
			"DLT_IBM_SP":                        {"untyped int", constant.MakeInt64(int64(q.DLT_IBM_SP))},
			"DLT_IEEE802":                       {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802))},
			"DLT_IEEE802_11":                    {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11))},
			"DLT_IEEE802_11_RADIO":              {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11_RADIO))},
			"DLT_IEEE802_11_RADIO_AVS":          {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11_RADIO_AVS))},
			"DLT_IEEE802_15_4":                  {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_15_4))},
			"DLT_IEEE802_15_4_LINUX":            {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_15_4_LINUX))},
			"DLT_IEEE802_15_4_NONASK_PHY":       {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_15_4_NONASK_PHY))},
			"DLT_IEEE802_16_MAC_CPS":            {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_16_MAC_CPS))},
			"DLT_IEEE802_16_MAC_CPS_RADIO":      {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_16_MAC_CPS_RADIO))},
			"DLT_IPFILTER":                      {"untyped int", constant.MakeInt64(int64(q.DLT_IPFILTER))},
			"DLT_IPMB":                          {"untyped int", constant.MakeInt64(int64(q.DLT_IPMB))},
			"DLT_IPMB_LINUX":                    {"untyped int", constant.MakeInt64(int64(q.DLT_IPMB_LINUX))},
			"DLT_IP_OVER_FC":                    {"untyped int", constant.MakeInt64(int64(q.DLT_IP_OVER_FC))},
			"DLT_JUNIPER_ATM1":                  {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ATM1))},
			"DLT_JUNIPER_ATM2":                  {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ATM2))},
			"DLT_JUNIPER_CHDLC":                 {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_CHDLC))},
			"DLT_JUNIPER_ES":                    {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ES))},
			"DLT_JUNIPER_ETHER":                 {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ETHER))},
			"DLT_JUNIPER_FRELAY":                {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_FRELAY))},
			"DLT_JUNIPER_GGSN":                  {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_GGSN))},
			"DLT_JUNIPER_ISM":                   {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ISM))},
			"DLT_JUNIPER_MFR":                   {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MFR))},
			"DLT_JUNIPER_MLFR":                  {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MLFR))},
			"DLT_JUNIPER_MLPPP":                 {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MLPPP))},
			"DLT_JUNIPER_MONITOR":               {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_MONITOR))},
			"DLT_JUNIPER_PIC_PEER":              {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PIC_PEER))},
			"DLT_JUNIPER_PPP":                   {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PPP))},
			"DLT_JUNIPER_PPPOE":                 {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PPPOE))},
			"DLT_JUNIPER_PPPOE_ATM":             {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_PPPOE_ATM))},
			"DLT_JUNIPER_SERVICES":              {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_SERVICES))},
			"DLT_JUNIPER_ST":                    {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_ST))},
			"DLT_JUNIPER_VP":                    {"untyped int", constant.MakeInt64(int64(q.DLT_JUNIPER_VP))},
			"DLT_LAPB_WITH_DIR":                 {"untyped int", constant.MakeInt64(int64(q.DLT_LAPB_WITH_DIR))},
			"DLT_LAPD":                          {"untyped int", constant.MakeInt64(int64(q.DLT_LAPD))},
			"DLT_LIN":                           {"untyped int", constant.MakeInt64(int64(q.DLT_LIN))},
			"DLT_LINUX_IRDA":                    {"untyped int", constant.MakeInt64(int64(q.DLT_LINUX_IRDA))},
			"DLT_LINUX_LAPD":                    {"untyped int", constant.MakeInt64(int64(q.DLT_LINUX_LAPD))},
			"DLT_LINUX_SLL":                     {"untyped int", constant.MakeInt64(int64(q.DLT_LINUX_SLL))},
			"DLT_LOOP":                          {"untyped int", constant.MakeInt64(int64(q.DLT_LOOP))},
			"DLT_LTALK":                         {"untyped int", constant.MakeInt64(int64(q.DLT_LTALK))},
			"DLT_MFR":                           {"untyped int", constant.MakeInt64(int64(q.DLT_MFR))},
			"DLT_MOST":                          {"untyped int", constant.MakeInt64(int64(q.DLT_MOST))},
			"DLT_MTP2":                          {"untyped int", constant.MakeInt64(int64(q.DLT_MTP2))},
			"DLT_MTP2_WITH_PHDR":                {"untyped int", constant.MakeInt64(int64(q.DLT_MTP2_WITH_PHDR))},
			"DLT_MTP3":                          {"untyped int", constant.MakeInt64(int64(q.DLT_MTP3))},
			"DLT_NULL":                          {"untyped int", constant.MakeInt64(int64(q.DLT_NULL))},
			"DLT_PCI_EXP":                       {"untyped int", constant.MakeInt64(int64(q.DLT_PCI_EXP))},
			"DLT_PFLOG":                         {"untyped int", constant.MakeInt64(int64(q.DLT_PFLOG))},
			"DLT_PFSYNC":                        {"untyped int", constant.MakeInt64(int64(q.DLT_PFSYNC))},
			"DLT_PPI":                           {"untyped int", constant.MakeInt64(int64(q.DLT_PPI))},
			"DLT_PPP":                           {"untyped int", constant.MakeInt64(int64(q.DLT_PPP))},
			"DLT_PPP_BSDOS":                     {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_BSDOS))},
			"DLT_PPP_ETHER":                     {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_ETHER))},
			"DLT_PPP_PPPD":                      {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_PPPD))},
			"DLT_PPP_SERIAL":                    {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_SERIAL))},
			"DLT_PPP_WITH_DIR":                  {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_WITH_DIR))},
			"DLT_PRISM_HEADER":                  {"untyped int", constant.MakeInt64(int64(q.DLT_PRISM_HEADER))},
			"DLT_PRONET":                        {"untyped int", constant.MakeInt64(int64(q.DLT_PRONET))},
			"DLT_RAIF1":                         {"untyped int", constant.MakeInt64(int64(q.DLT_RAIF1))},
			"DLT_RAW":                           {"untyped int", constant.MakeInt64(int64(q.DLT_RAW))},
			"DLT_REDBACK_SMARTEDGE":             {"untyped int", constant.MakeInt64(int64(q.DLT_REDBACK_SMARTEDGE))},
			"DLT_RIO":                           {"untyped int", constant.MakeInt64(int64(q.DLT_RIO))},
			"DLT_SCCP":                          {"untyped int", constant.MakeInt64(int64(q.DLT_SCCP))},
			"DLT_SITA":                          {"untyped int", constant.MakeInt64(int64(q.DLT_SITA))},
			"DLT_SLIP":                          {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP))},
			"DLT_SLIP_BSDOS":                    {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP_BSDOS))},
			"DLT_SUNATM":                        {"untyped int", constant.MakeInt64(int64(q.DLT_SUNATM))},
			"DLT_SYMANTEC_FIREWALL":             {"untyped int", constant.MakeInt64(int64(q.DLT_SYMANTEC_FIREWALL))},
			"DLT_TZSP":                          {"untyped int", constant.MakeInt64(int64(q.DLT_TZSP))},
			"DLT_USB":                           {"untyped int", constant.MakeInt64(int64(q.DLT_USB))},
			"DLT_USB_LINUX":                     {"untyped int", constant.MakeInt64(int64(q.DLT_USB_LINUX))},
			"DLT_X2E_SERIAL":                    {"untyped int", constant.MakeInt64(int64(q.DLT_X2E_SERIAL))},
			"DLT_X2E_XORAYA":                    {"untyped int", constant.MakeInt64(int64(q.DLT_X2E_XORAYA))},
			"DT_BLK":                            {"untyped int", constant.MakeInt64(int64(q.DT_BLK))},
			"DT_CHR":                            {"untyped int", constant.MakeInt64(int64(q.DT_CHR))},
			"DT_DBF":                            {"untyped int", constant.MakeInt64(int64(q.DT_DBF))},
			"DT_DIR":                            {"untyped int", constant.MakeInt64(int64(q.DT_DIR))},
			"DT_FIFO":                           {"untyped int", constant.MakeInt64(int64(q.DT_FIFO))},
			"DT_LNK":                            {"untyped int", constant.MakeInt64(int64(q.DT_LNK))},
			"DT_REG":                            {"untyped int", constant.MakeInt64(int64(q.DT_REG))},
			"DT_SOCK":                           {"untyped int", constant.MakeInt64(int64(q.DT_SOCK))},
			"DT_UNKNOWN":                        {"untyped int", constant.MakeInt64(int64(q.DT_UNKNOWN))},
			"DT_WHT":                            {"untyped int", constant.MakeInt64(int64(q.DT_WHT))},
			"ECHO":                              {"untyped int", constant.MakeInt64(int64(q.ECHO))},
			"ECHOCTL":                           {"untyped int", constant.MakeInt64(int64(q.ECHOCTL))},
			"ECHOE":                             {"untyped int", constant.MakeInt64(int64(q.ECHOE))},
			"ECHOK":                             {"untyped int", constant.MakeInt64(int64(q.ECHOK))},
			"ECHOKE":                            {"untyped int", constant.MakeInt64(int64(q.ECHOKE))},
			"ECHONL":                            {"untyped int", constant.MakeInt64(int64(q.ECHONL))},
			"ECHOPRT":                           {"untyped int", constant.MakeInt64(int64(q.ECHOPRT))},
			"EVFILT_AIO":                        {"untyped int", constant.MakeInt64(int64(q.EVFILT_AIO))},
			"EVFILT_EXCEPT":                     {"untyped int", constant.MakeInt64(int64(q.EVFILT_EXCEPT))},
			"EVFILT_MARKER":                     {"untyped int", constant.MakeInt64(int64(q.EVFILT_MARKER))},
			"EVFILT_PROC":                       {"untyped int", constant.MakeInt64(int64(q.EVFILT_PROC))},
			"EVFILT_READ":                       {"untyped int", constant.MakeInt64(int64(q.EVFILT_READ))},
			"EVFILT_SIGNAL":                     {"untyped int", constant.MakeInt64(int64(q.EVFILT_SIGNAL))},
			"EVFILT_SYSCOUNT":                   {"untyped int", constant.MakeInt64(int64(q.EVFILT_SYSCOUNT))},
			"EVFILT_TIMER":                      {"untyped int", constant.MakeInt64(int64(q.EVFILT_TIMER))},
			"EVFILT_VNODE":                      {"untyped int", constant.MakeInt64(int64(q.EVFILT_VNODE))},
			"EVFILT_WRITE":                      {"untyped int", constant.MakeInt64(int64(q.EVFILT_WRITE))},
			"EV_ADD":                            {"untyped int", constant.MakeInt64(int64(q.EV_ADD))},
			"EV_CLEAR":                          {"untyped int", constant.MakeInt64(int64(q.EV_CLEAR))},
			"EV_DELETE":                         {"untyped int", constant.MakeInt64(int64(q.EV_DELETE))},
			"EV_DISABLE":                        {"untyped int", constant.MakeInt64(int64(q.EV_DISABLE))},
			"EV_ENABLE":                         {"untyped int", constant.MakeInt64(int64(q.EV_ENABLE))},
			"EV_EOF":                            {"untyped int", constant.MakeInt64(int64(q.EV_EOF))},
			"EV_ERROR":                          {"untyped int", constant.MakeInt64(int64(q.EV_ERROR))},
			"EV_FLAG1":                          {"untyped int", constant.MakeInt64(int64(q.EV_FLAG1))},
			"EV_NODATA":                         {"untyped int", constant.MakeInt64(int64(q.EV_NODATA))},
			"EV_ONESHOT":                        {"untyped int", constant.MakeInt64(int64(q.EV_ONESHOT))},
			"EV_SYSFLAGS":                       {"untyped int", constant.MakeInt64(int64(q.EV_SYSFLAGS))},
			"EXTA":                              {"untyped int", constant.MakeInt64(int64(q.EXTA))},
			"EXTB":                              {"untyped int", constant.MakeInt64(int64(q.EXTB))},
			"EXTEXIT_LWP":                       {"untyped int", constant.MakeInt64(int64(q.EXTEXIT_LWP))},
			"EXTEXIT_PROC":                      {"untyped int", constant.MakeInt64(int64(q.EXTEXIT_PROC))},
			"EXTEXIT_SETINT":                    {"untyped int", constant.MakeInt64(int64(q.EXTEXIT_SETINT))},
			"EXTEXIT_SIMPLE":                    {"untyped int", constant.MakeInt64(int64(q.EXTEXIT_SIMPLE))},
			"EXTPROC":                           {"untyped int", constant.MakeInt64(int64(q.EXTPROC))},
			"FD_CLOEXEC":                        {"untyped int", constant.MakeInt64(int64(q.FD_CLOEXEC))},
			"FD_SETSIZE":                        {"untyped int", constant.MakeInt64(int64(q.FD_SETSIZE))},
			"FLUSHO":                            {"untyped int", constant.MakeInt64(int64(q.FLUSHO))},
			"F_DUP2FD":                          {"untyped int", constant.MakeInt64(int64(q.F_DUP2FD))},
			"F_DUP2FD_CLOEXEC":                  {"untyped int", constant.MakeInt64(int64(q.F_DUP2FD_CLOEXEC))},
			"F_DUPFD":                           {"untyped int", constant.MakeInt64(int64(q.F_DUPFD))},
			"F_DUPFD_CLOEXEC":                   {"untyped int", constant.MakeInt64(int64(q.F_DUPFD_CLOEXEC))},
			"F_GETFD":                           {"untyped int", constant.MakeInt64(int64(q.F_GETFD))},
			"F_GETFL":                           {"untyped int", constant.MakeInt64(int64(q.F_GETFL))},
			"F_GETLK":                           {"untyped int", constant.MakeInt64(int64(q.F_GETLK))},
			"F_GETOWN":                          {"untyped int", constant.MakeInt64(int64(q.F_GETOWN))},
			"F_OK":                              {"untyped int", constant.MakeInt64(int64(q.F_OK))},
			"F_RDLCK":                           {"untyped int", constant.MakeInt64(int64(q.F_RDLCK))},
			"F_SETFD":                           {"untyped int", constant.MakeInt64(int64(q.F_SETFD))},
			"F_SETFL":                           {"untyped int", constant.MakeInt64(int64(q.F_SETFL))},
			"F_SETLK":                           {"untyped int", constant.MakeInt64(int64(q.F_SETLK))},
			"F_SETLKW":                          {"untyped int", constant.MakeInt64(int64(q.F_SETLKW))},
			"F_SETOWN":                          {"untyped int", constant.MakeInt64(int64(q.F_SETOWN))},
			"F_UNLCK":                           {"untyped int", constant.MakeInt64(int64(q.F_UNLCK))},
			"F_WRLCK":                           {"untyped int", constant.MakeInt64(int64(q.F_WRLCK))},
			"HUPCL":                             {"untyped int", constant.MakeInt64(int64(q.HUPCL))},
			"ICANON":                            {"untyped int", constant.MakeInt64(int64(q.ICANON))},
			"ICMP6_FILTER":                      {"untyped int", constant.MakeInt64(int64(q.ICMP6_FILTER))},
			"ICRNL":                             {"untyped int", constant.MakeInt64(int64(q.ICRNL))},
			"IEXTEN":                            {"untyped int", constant.MakeInt64(int64(q.IEXTEN))},
			"IFAN_ARRIVAL":                      {"untyped int", constant.MakeInt64(int64(q.IFAN_ARRIVAL))},
			"IFAN_DEPARTURE":                    {"untyped int", constant.MakeInt64(int64(q.IFAN_DEPARTURE))},
			"IFF_ALLMULTI":                      {"untyped int", constant.MakeInt64(int64(q.IFF_ALLMULTI))},
			"IFF_ALTPHYS":                       {"untyped int", constant.MakeInt64(int64(q.IFF_ALTPHYS))},
			"IFF_BROADCAST":                     {"untyped int", constant.MakeInt64(int64(q.IFF_BROADCAST))},
			"IFF_CANTCHANGE":                    {"untyped int", constant.MakeInt64(int64(q.IFF_CANTCHANGE))},
			"IFF_DEBUG":                         {"untyped int", constant.MakeInt64(int64(q.IFF_DEBUG))},
			"IFF_LINK0":                         {"untyped int", constant.MakeInt64(int64(q.IFF_LINK0))},
			"IFF_LINK1":                         {"untyped int", constant.MakeInt64(int64(q.IFF_LINK1))},
			"IFF_LINK2":                         {"untyped int", constant.MakeInt64(int64(q.IFF_LINK2))},
			"IFF_LOOPBACK":                      {"untyped int", constant.MakeInt64(int64(q.IFF_LOOPBACK))},
			"IFF_MONITOR":                       {"untyped int", constant.MakeInt64(int64(q.IFF_MONITOR))},
			"IFF_MULTICAST":                     {"untyped int", constant.MakeInt64(int64(q.IFF_MULTICAST))},
			"IFF_NOARP":                         {"untyped int", constant.MakeInt64(int64(q.IFF_NOARP))},
			"IFF_NPOLLING":                      {"untyped int", constant.MakeInt64(int64(q.IFF_NPOLLING))},
			"IFF_OACTIVE":                       {"untyped int", constant.MakeInt64(int64(q.IFF_OACTIVE))},
			"IFF_OACTIVE_COMPAT":                {"untyped int", constant.MakeInt64(int64(q.IFF_OACTIVE_COMPAT))},
			"IFF_POINTOPOINT":                   {"untyped int", constant.MakeInt64(int64(q.IFF_POINTOPOINT))},
			"IFF_POLLING":                       {"untyped int", constant.MakeInt64(int64(q.IFF_POLLING))},
			"IFF_POLLING_COMPAT":                {"untyped int", constant.MakeInt64(int64(q.IFF_POLLING_COMPAT))},
			"IFF_PPROMISC":                      {"untyped int", constant.MakeInt64(int64(q.IFF_PPROMISC))},
			"IFF_PROMISC":                       {"untyped int", constant.MakeInt64(int64(q.IFF_PROMISC))},
			"IFF_RUNNING":                       {"untyped int", constant.MakeInt64(int64(q.IFF_RUNNING))},
			"IFF_SIMPLEX":                       {"untyped int", constant.MakeInt64(int64(q.IFF_SIMPLEX))},
			"IFF_SMART":                         {"untyped int", constant.MakeInt64(int64(q.IFF_SMART))},
			"IFF_STATICARP":                     {"untyped int", constant.MakeInt64(int64(q.IFF_STATICARP))},
			"IFF_UP":                            {"untyped int", constant.MakeInt64(int64(q.IFF_UP))},
			"IFNAMSIZ":                          {"untyped int", constant.MakeInt64(int64(q.IFNAMSIZ))},
			"IFT_1822":                          {"untyped int", constant.MakeInt64(int64(q.IFT_1822))},
			"IFT_A12MPPSWITCH":                  {"untyped int", constant.MakeInt64(int64(q.IFT_A12MPPSWITCH))},
			"IFT_AAL2":                          {"untyped int", constant.MakeInt64(int64(q.IFT_AAL2))},
			"IFT_AAL5":                          {"untyped int", constant.MakeInt64(int64(q.IFT_AAL5))},
			"IFT_ADSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ADSL))},
			"IFT_AFLANE8023":                    {"untyped int", constant.MakeInt64(int64(q.IFT_AFLANE8023))},
			"IFT_AFLANE8025":                    {"untyped int", constant.MakeInt64(int64(q.IFT_AFLANE8025))},
			"IFT_ARAP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ARAP))},
			"IFT_ARCNET":                        {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNET))},
			"IFT_ARCNETPLUS":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNETPLUS))},
			"IFT_ASYNC":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ASYNC))},
			"IFT_ATM":                           {"untyped int", constant.MakeInt64(int64(q.IFT_ATM))},
			"IFT_ATMDXI":                        {"untyped int", constant.MakeInt64(int64(q.IFT_ATMDXI))},
			"IFT_ATMFUNI":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ATMFUNI))},
			"IFT_ATMIMA":                        {"untyped int", constant.MakeInt64(int64(q.IFT_ATMIMA))},
			"IFT_ATMLOGICAL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ATMLOGICAL))},
			"IFT_ATMRADIO":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ATMRADIO))},
			"IFT_ATMSUBINTERFACE":               {"untyped int", constant.MakeInt64(int64(q.IFT_ATMSUBINTERFACE))},
			"IFT_ATMVCIENDPT":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ATMVCIENDPT))},
			"IFT_ATMVIRTUAL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ATMVIRTUAL))},
			"IFT_BGPPOLICYACCOUNTING":           {"untyped int", constant.MakeInt64(int64(q.IFT_BGPPOLICYACCOUNTING))},
			"IFT_BRIDGE":                        {"untyped int", constant.MakeInt64(int64(q.IFT_BRIDGE))},
			"IFT_BSC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_BSC))},
			"IFT_CARP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_CARP))},
			"IFT_CCTEMUL":                       {"untyped int", constant.MakeInt64(int64(q.IFT_CCTEMUL))},
			"IFT_CEPT":                          {"untyped int", constant.MakeInt64(int64(q.IFT_CEPT))},
			"IFT_CES":                           {"untyped int", constant.MakeInt64(int64(q.IFT_CES))},
			"IFT_CHANNEL":                       {"untyped int", constant.MakeInt64(int64(q.IFT_CHANNEL))},
			"IFT_CNR":                           {"untyped int", constant.MakeInt64(int64(q.IFT_CNR))},
			"IFT_COFFEE":                        {"untyped int", constant.MakeInt64(int64(q.IFT_COFFEE))},
			"IFT_COMPOSITELINK":                 {"untyped int", constant.MakeInt64(int64(q.IFT_COMPOSITELINK))},
			"IFT_DCN":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DCN))},
			"IFT_DIGITALPOWERLINE":              {"untyped int", constant.MakeInt64(int64(q.IFT_DIGITALPOWERLINE))},
			"IFT_DIGITALWRAPPEROVERHEADCHANNEL": {"untyped int", constant.MakeInt64(int64(q.IFT_DIGITALWRAPPEROVERHEADCHANNEL))},
			"IFT_DLSW":                          {"untyped int", constant.MakeInt64(int64(q.IFT_DLSW))},
			"IFT_DOCSCABLEDOWNSTREAM":           {"untyped int", constant.MakeInt64(int64(q.IFT_DOCSCABLEDOWNSTREAM))},
			"IFT_DOCSCABLEMACLAYER":             {"untyped int", constant.MakeInt64(int64(q.IFT_DOCSCABLEMACLAYER))},
			"IFT_DOCSCABLEUPSTREAM":             {"untyped int", constant.MakeInt64(int64(q.IFT_DOCSCABLEUPSTREAM))},
			"IFT_DS0":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DS0))},
			"IFT_DS0BUNDLE":                     {"untyped int", constant.MakeInt64(int64(q.IFT_DS0BUNDLE))},
			"IFT_DS1FDL":                        {"untyped int", constant.MakeInt64(int64(q.IFT_DS1FDL))},
			"IFT_DS3":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DS3))},
			"IFT_DTM":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DTM))},
			"IFT_DVBASILN":                      {"untyped int", constant.MakeInt64(int64(q.IFT_DVBASILN))},
			"IFT_DVBASIOUT":                     {"untyped int", constant.MakeInt64(int64(q.IFT_DVBASIOUT))},
			"IFT_DVBRCCDOWNSTREAM":              {"untyped int", constant.MakeInt64(int64(q.IFT_DVBRCCDOWNSTREAM))},
			"IFT_DVBRCCMACLAYER":                {"untyped int", constant.MakeInt64(int64(q.IFT_DVBRCCMACLAYER))},
			"IFT_DVBRCCUPSTREAM":                {"untyped int", constant.MakeInt64(int64(q.IFT_DVBRCCUPSTREAM))},
			"IFT_ENC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_ENC))},
			"IFT_EON":                           {"untyped int", constant.MakeInt64(int64(q.IFT_EON))},
			"IFT_EPLRS":                         {"untyped int", constant.MakeInt64(int64(q.IFT_EPLRS))},
			"IFT_ESCON":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ESCON))},
			"IFT_ETHER":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ETHER))},
			"IFT_FAITH":                         {"untyped int", constant.MakeInt64(int64(q.IFT_FAITH))},
			"IFT_FAST":                          {"untyped int", constant.MakeInt64(int64(q.IFT_FAST))},
			"IFT_FASTETHER":                     {"untyped int", constant.MakeInt64(int64(q.IFT_FASTETHER))},
			"IFT_FASTETHERFX":                   {"untyped int", constant.MakeInt64(int64(q.IFT_FASTETHERFX))},
			"IFT_FDDI":                          {"untyped int", constant.MakeInt64(int64(q.IFT_FDDI))},
			"IFT_FIBRECHANNEL":                  {"untyped int", constant.MakeInt64(int64(q.IFT_FIBRECHANNEL))},
			"IFT_FRAMERELAYINTERCONNECT":        {"untyped int", constant.MakeInt64(int64(q.IFT_FRAMERELAYINTERCONNECT))},
			"IFT_FRAMERELAYMPI":                 {"untyped int", constant.MakeInt64(int64(q.IFT_FRAMERELAYMPI))},
			"IFT_FRDLCIENDPT":                   {"untyped int", constant.MakeInt64(int64(q.IFT_FRDLCIENDPT))},
			"IFT_FRELAY":                        {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAY))},
			"IFT_FRELAYDCE":                     {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAYDCE))},
			"IFT_FRF16MFRBUNDLE":                {"untyped int", constant.MakeInt64(int64(q.IFT_FRF16MFRBUNDLE))},
			"IFT_FRFORWARD":                     {"untyped int", constant.MakeInt64(int64(q.IFT_FRFORWARD))},
			"IFT_G703AT2MB":                     {"untyped int", constant.MakeInt64(int64(q.IFT_G703AT2MB))},
			"IFT_G703AT64K":                     {"untyped int", constant.MakeInt64(int64(q.IFT_G703AT64K))},
			"IFT_GIF":                           {"untyped int", constant.MakeInt64(int64(q.IFT_GIF))},
			"IFT_GIGABITETHERNET":               {"untyped int", constant.MakeInt64(int64(q.IFT_GIGABITETHERNET))},
			"IFT_GR303IDT":                      {"untyped int", constant.MakeInt64(int64(q.IFT_GR303IDT))},
			"IFT_GR303RDT":                      {"untyped int", constant.MakeInt64(int64(q.IFT_GR303RDT))},
			"IFT_H323GATEKEEPER":                {"untyped int", constant.MakeInt64(int64(q.IFT_H323GATEKEEPER))},
			"IFT_H323PROXY":                     {"untyped int", constant.MakeInt64(int64(q.IFT_H323PROXY))},
			"IFT_HDH1822":                       {"untyped int", constant.MakeInt64(int64(q.IFT_HDH1822))},
			"IFT_HDLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_HDLC))},
			"IFT_HDSL2":                         {"untyped int", constant.MakeInt64(int64(q.IFT_HDSL2))},
			"IFT_HIPERLAN2":                     {"untyped int", constant.MakeInt64(int64(q.IFT_HIPERLAN2))},
			"IFT_HIPPI":                         {"untyped int", constant.MakeInt64(int64(q.IFT_HIPPI))},
			"IFT_HIPPIINTERFACE":                {"untyped int", constant.MakeInt64(int64(q.IFT_HIPPIINTERFACE))},
			"IFT_HOSTPAD":                       {"untyped int", constant.MakeInt64(int64(q.IFT_HOSTPAD))},
			"IFT_HSSI":                          {"untyped int", constant.MakeInt64(int64(q.IFT_HSSI))},
			"IFT_HY":                            {"untyped int", constant.MakeInt64(int64(q.IFT_HY))},
			"IFT_IBM370PARCHAN":                 {"untyped int", constant.MakeInt64(int64(q.IFT_IBM370PARCHAN))},
			"IFT_IDSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_IDSL))},
			"IFT_IEEE1394":                      {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE1394))},
			"IFT_IEEE80211":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE80211))},
			"IFT_IEEE80212":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE80212))},
			"IFT_IEEE8023ADLAG":                 {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE8023ADLAG))},
			"IFT_IFGSN":                         {"untyped int", constant.MakeInt64(int64(q.IFT_IFGSN))},
			"IFT_IMT":                           {"untyped int", constant.MakeInt64(int64(q.IFT_IMT))},
			"IFT_INTERLEAVE":                    {"untyped int", constant.MakeInt64(int64(q.IFT_INTERLEAVE))},
			"IFT_IP":                            {"untyped int", constant.MakeInt64(int64(q.IFT_IP))},
			"IFT_IPFORWARD":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IPFORWARD))},
			"IFT_IPOVERATM":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IPOVERATM))},
			"IFT_IPOVERCDLC":                    {"untyped int", constant.MakeInt64(int64(q.IFT_IPOVERCDLC))},
			"IFT_IPOVERCLAW":                    {"untyped int", constant.MakeInt64(int64(q.IFT_IPOVERCLAW))},
			"IFT_IPSWITCH":                      {"untyped int", constant.MakeInt64(int64(q.IFT_IPSWITCH))},
			"IFT_ISDN":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ISDN))},
			"IFT_ISDNBASIC":                     {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNBASIC))},
			"IFT_ISDNPRIMARY":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNPRIMARY))},
			"IFT_ISDNS":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNS))},
			"IFT_ISDNU":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNU))},
			"IFT_ISO88022LLC":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88022LLC))},
			"IFT_ISO88023":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88023))},
			"IFT_ISO88024":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88024))},
			"IFT_ISO88025":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025))},
			"IFT_ISO88025CRFPINT":               {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025CRFPINT))},
			"IFT_ISO88025DTR":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025DTR))},
			"IFT_ISO88025FIBER":                 {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025FIBER))},
			"IFT_ISO88026":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88026))},
			"IFT_ISUP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ISUP))},
			"IFT_L2VLAN":                        {"untyped int", constant.MakeInt64(int64(q.IFT_L2VLAN))},
			"IFT_L3IPVLAN":                      {"untyped int", constant.MakeInt64(int64(q.IFT_L3IPVLAN))},
			"IFT_L3IPXVLAN":                     {"untyped int", constant.MakeInt64(int64(q.IFT_L3IPXVLAN))},
			"IFT_LAPB":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LAPB))},
			"IFT_LAPD":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LAPD))},
			"IFT_LAPF":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LAPF))},
			"IFT_LOCALTALK":                     {"untyped int", constant.MakeInt64(int64(q.IFT_LOCALTALK))},
			"IFT_LOOP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LOOP))},
			"IFT_MEDIAMAILOVERIP":               {"untyped int", constant.MakeInt64(int64(q.IFT_MEDIAMAILOVERIP))},
			"IFT_MFSIGLINK":                     {"untyped int", constant.MakeInt64(int64(q.IFT_MFSIGLINK))},
			"IFT_MIOX25":                        {"untyped int", constant.MakeInt64(int64(q.IFT_MIOX25))},
			"IFT_MODEM":                         {"untyped int", constant.MakeInt64(int64(q.IFT_MODEM))},
			"IFT_MPC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_MPC))},
			"IFT_MPLS":                          {"untyped int", constant.MakeInt64(int64(q.IFT_MPLS))},
			"IFT_MPLSTUNNEL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_MPLSTUNNEL))},
			"IFT_MSDSL":                         {"untyped int", constant.MakeInt64(int64(q.IFT_MSDSL))},
			"IFT_MVL":                           {"untyped int", constant.MakeInt64(int64(q.IFT_MVL))},
			"IFT_MYRINET":                       {"untyped int", constant.MakeInt64(int64(q.IFT_MYRINET))},
			"IFT_NFAS":                          {"untyped int", constant.MakeInt64(int64(q.IFT_NFAS))},
			"IFT_NSIP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_NSIP))},
			"IFT_OPTICALCHANNEL":                {"untyped int", constant.MakeInt64(int64(q.IFT_OPTICALCHANNEL))},
			"IFT_OPTICALTRANSPORT":              {"untyped int", constant.MakeInt64(int64(q.IFT_OPTICALTRANSPORT))},
			"IFT_OTHER":                         {"untyped int", constant.MakeInt64(int64(q.IFT_OTHER))},
			"IFT_P10":                           {"untyped int", constant.MakeInt64(int64(q.IFT_P10))},
			"IFT_P80":                           {"untyped int", constant.MakeInt64(int64(q.IFT_P80))},
			"IFT_PARA":                          {"untyped int", constant.MakeInt64(int64(q.IFT_PARA))},
			"IFT_PFLOG":                         {"untyped int", constant.MakeInt64(int64(q.IFT_PFLOG))},
			"IFT_PFSYNC":                        {"untyped int", constant.MakeInt64(int64(q.IFT_PFSYNC))},
			"IFT_PLC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_PLC))},
			"IFT_POS":                           {"untyped int", constant.MakeInt64(int64(q.IFT_POS))},
			"IFT_PPP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_PPP))},
			"IFT_PPPMULTILINKBUNDLE":            {"untyped int", constant.MakeInt64(int64(q.IFT_PPPMULTILINKBUNDLE))},
			"IFT_PROPBWAP2MP":                   {"untyped int", constant.MakeInt64(int64(q.IFT_PROPBWAP2MP))},
			"IFT_PROPCNLS":                      {"untyped int", constant.MakeInt64(int64(q.IFT_PROPCNLS))},
			"IFT_PROPDOCSWIRELESSDOWNSTREAM":    {"untyped int", constant.MakeInt64(int64(q.IFT_PROPDOCSWIRELESSDOWNSTREAM))},
			"IFT_PROPDOCSWIRELESSMACLAYER":      {"untyped int", constant.MakeInt64(int64(q.IFT_PROPDOCSWIRELESSMACLAYER))},
			"IFT_PROPDOCSWIRELESSUPSTREAM":      {"untyped int", constant.MakeInt64(int64(q.IFT_PROPDOCSWIRELESSUPSTREAM))},
			"IFT_PROPMUX":                       {"untyped int", constant.MakeInt64(int64(q.IFT_PROPMUX))},
			"IFT_PROPVIRTUAL":                   {"untyped int", constant.MakeInt64(int64(q.IFT_PROPVIRTUAL))},
			"IFT_PROPWIRELESSP2P":               {"untyped int", constant.MakeInt64(int64(q.IFT_PROPWIRELESSP2P))},
			"IFT_PTPSERIAL":                     {"untyped int", constant.MakeInt64(int64(q.IFT_PTPSERIAL))},
			"IFT_PVC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_PVC))},
			"IFT_QLLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_QLLC))},
			"IFT_RADIOMAC":                      {"untyped int", constant.MakeInt64(int64(q.IFT_RADIOMAC))},
			"IFT_RADSL":                         {"untyped int", constant.MakeInt64(int64(q.IFT_RADSL))},
			"IFT_REACHDSL":                      {"untyped int", constant.MakeInt64(int64(q.IFT_REACHDSL))},
			"IFT_RFC1483":                       {"untyped int", constant.MakeInt64(int64(q.IFT_RFC1483))},
			"IFT_RS232":                         {"untyped int", constant.MakeInt64(int64(q.IFT_RS232))},
			"IFT_RSRB":                          {"untyped int", constant.MakeInt64(int64(q.IFT_RSRB))},
			"IFT_SDLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_SDLC))},
			"IFT_SDSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_SDSL))},
			"IFT_SHDSL":                         {"untyped int", constant.MakeInt64(int64(q.IFT_SHDSL))},
			"IFT_SIP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_SIP))},
			"IFT_SLIP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_SLIP))},
			"IFT_SMDSDXI":                       {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSDXI))},
			"IFT_SMDSICIP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSICIP))},
			"IFT_SONET":                         {"untyped int", constant.MakeInt64(int64(q.IFT_SONET))},
			"IFT_SONETOVERHEADCHANNEL":          {"untyped int", constant.MakeInt64(int64(q.IFT_SONETOVERHEADCHANNEL))},
			"IFT_SONETPATH":                     {"untyped int", constant.MakeInt64(int64(q.IFT_SONETPATH))},
			"IFT_SONETVT":                       {"untyped int", constant.MakeInt64(int64(q.IFT_SONETVT))},
			"IFT_SRP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_SRP))},
			"IFT_SS7SIGLINK":                    {"untyped int", constant.MakeInt64(int64(q.IFT_SS7SIGLINK))},
			"IFT_STACKTOSTACK":                  {"untyped int", constant.MakeInt64(int64(q.IFT_STACKTOSTACK))},
			"IFT_STARLAN":                       {"untyped int", constant.MakeInt64(int64(q.IFT_STARLAN))},
			"IFT_STF":                           {"untyped int", constant.MakeInt64(int64(q.IFT_STF))},
			"IFT_T1":                            {"untyped int", constant.MakeInt64(int64(q.IFT_T1))},
			"IFT_TDLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_TDLC))},
			"IFT_TERMPAD":                       {"untyped int", constant.MakeInt64(int64(q.IFT_TERMPAD))},
			"IFT_TR008":                         {"untyped int", constant.MakeInt64(int64(q.IFT_TR008))},
			"IFT_TRANSPHDLC":                    {"untyped int", constant.MakeInt64(int64(q.IFT_TRANSPHDLC))},
			"IFT_TUNNEL":                        {"untyped int", constant.MakeInt64(int64(q.IFT_TUNNEL))},
			"IFT_ULTRA":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ULTRA))},
			"IFT_USB":                           {"untyped int", constant.MakeInt64(int64(q.IFT_USB))},
			"IFT_V11":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V11))},
			"IFT_V35":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V35))},
			"IFT_V36":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V36))},
			"IFT_V37":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V37))},
			"IFT_VDSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_VDSL))},
			"IFT_VIRTUALIPADDRESS":              {"untyped int", constant.MakeInt64(int64(q.IFT_VIRTUALIPADDRESS))},
			"IFT_VOICEEM":                       {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEEM))},
			"IFT_VOICEENCAP":                    {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEENCAP))},
			"IFT_VOICEFXO":                      {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEFXO))},
			"IFT_VOICEFXS":                      {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEFXS))},
			"IFT_VOICEOVERATM":                  {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEOVERATM))},
			"IFT_VOICEOVERFRAMERELAY":           {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEOVERFRAMERELAY))},
			"IFT_VOICEOVERIP":                   {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEOVERIP))},
			"IFT_X213":                          {"untyped int", constant.MakeInt64(int64(q.IFT_X213))},
			"IFT_X25":                           {"untyped int", constant.MakeInt64(int64(q.IFT_X25))},
			"IFT_X25DDN":                        {"untyped int", constant.MakeInt64(int64(q.IFT_X25DDN))},
			"IFT_X25HUNTGROUP":                  {"untyped int", constant.MakeInt64(int64(q.IFT_X25HUNTGROUP))},
			"IFT_X25MLP":                        {"untyped int", constant.MakeInt64(int64(q.IFT_X25MLP))},
			"IFT_X25PLE":                        {"untyped int", constant.MakeInt64(int64(q.IFT_X25PLE))},
			"IFT_XETHER":                        {"untyped int", constant.MakeInt64(int64(q.IFT_XETHER))},
			"IGNBRK":                            {"untyped int", constant.MakeInt64(int64(q.IGNBRK))},
			"IGNCR":                             {"untyped int", constant.MakeInt64(int64(q.IGNCR))},
			"IGNPAR":                            {"untyped int", constant.MakeInt64(int64(q.IGNPAR))},
			"IMAXBEL":                           {"untyped int", constant.MakeInt64(int64(q.IMAXBEL))},
			"INLCR":                             {"untyped int", constant.MakeInt64(int64(q.INLCR))},
			"INPCK":                             {"untyped int", constant.MakeInt64(int64(q.INPCK))},
			"IN_CLASSA_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_HOST))},
			"IN_CLASSA_MAX":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_MAX))},
			"IN_CLASSA_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NET))},
			"IN_CLASSA_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NSHIFT))},
			"IN_CLASSB_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_HOST))},
			"IN_CLASSB_MAX":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_MAX))},
			"IN_CLASSB_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NET))},
			"IN_CLASSB_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NSHIFT))},
			"IN_CLASSC_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_HOST))},
			"IN_CLASSC_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NET))},
			"IN_CLASSC_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NSHIFT))},
			"IN_CLASSD_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_HOST))},
			"IN_CLASSD_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NET))},
			"IN_CLASSD_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NSHIFT))},
			"IN_LOOPBACKNET":                    {"untyped int", constant.MakeInt64(int64(q.IN_LOOPBACKNET))},
			"IPPROTO_3PC":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_3PC))},
			"IPPROTO_ADFS":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ADFS))},
			"IPPROTO_AH":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AH))},
			"IPPROTO_AHIP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AHIP))},
			"IPPROTO_APES":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_APES))},
			"IPPROTO_ARGUS":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ARGUS))},
			"IPPROTO_AX25":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AX25))},
			"IPPROTO_BHA":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BHA))},
			"IPPROTO_BLT":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BLT))},
			"IPPROTO_BRSATMON":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_BRSATMON))},
			"IPPROTO_CARP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CARP))},
			"IPPROTO_CFTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CFTP))},
			"IPPROTO_CHAOS":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CHAOS))},
			"IPPROTO_CMTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CMTP))},
			"IPPROTO_CPHB":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CPHB))},
			"IPPROTO_CPNX":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CPNX))},
			"IPPROTO_DDP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DDP))},
			"IPPROTO_DGP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DGP))},
			"IPPROTO_DIVERT":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DIVERT))},
			"IPPROTO_DONE":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DONE))},
			"IPPROTO_DSTOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DSTOPTS))},
			"IPPROTO_EGP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EGP))},
			"IPPROTO_EMCON":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EMCON))},
			"IPPROTO_ENCAP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ENCAP))},
			"IPPROTO_EON":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EON))},
			"IPPROTO_ESP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ESP))},
			"IPPROTO_ETHERIP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ETHERIP))},
			"IPPROTO_FRAGMENT":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_FRAGMENT))},
			"IPPROTO_GGP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GGP))},
			"IPPROTO_GMTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GMTP))},
			"IPPROTO_GRE":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GRE))},
			"IPPROTO_HELLO":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HELLO))},
			"IPPROTO_HMP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HMP))},
			"IPPROTO_HOPOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HOPOPTS))},
			"IPPROTO_ICMP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMP))},
			"IPPROTO_ICMPV6":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMPV6))},
			"IPPROTO_IDP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDP))},
			"IPPROTO_IDPR":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDPR))},
			"IPPROTO_IDRP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDRP))},
			"IPPROTO_IGMP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGMP))},
			"IPPROTO_IGP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGP))},
			"IPPROTO_IGRP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGRP))},
			"IPPROTO_IL":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IL))},
			"IPPROTO_INLSP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_INLSP))},
			"IPPROTO_INP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_INP))},
			"IPPROTO_IP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IP))},
			"IPPROTO_IPCOMP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPCOMP))},
			"IPPROTO_IPCV":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPCV))},
			"IPPROTO_IPEIP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPEIP))},
			"IPPROTO_IPIP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPIP))},
			"IPPROTO_IPPC":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPPC))},
			"IPPROTO_IPV4":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV4))},
			"IPPROTO_IPV6":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV6))},
			"IPPROTO_IRTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IRTP))},
			"IPPROTO_KRYPTOLAN":                 {"untyped int", constant.MakeInt64(int64(q.IPPROTO_KRYPTOLAN))},
			"IPPROTO_LARP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_LARP))},
			"IPPROTO_LEAF1":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_LEAF1))},
			"IPPROTO_LEAF2":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_LEAF2))},
			"IPPROTO_MAX":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAX))},
			"IPPROTO_MAXID":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAXID))},
			"IPPROTO_MEAS":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MEAS))},
			"IPPROTO_MHRP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MHRP))},
			"IPPROTO_MICP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MICP))},
			"IPPROTO_MOBILE":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MOBILE))},
			"IPPROTO_MTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MTP))},
			"IPPROTO_MUX":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MUX))},
			"IPPROTO_ND":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ND))},
			"IPPROTO_NHRP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NHRP))},
			"IPPROTO_NONE":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NONE))},
			"IPPROTO_NSP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NSP))},
			"IPPROTO_NVPII":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NVPII))},
			"IPPROTO_OSPFIGP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_OSPFIGP))},
			"IPPROTO_PFSYNC":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PFSYNC))},
			"IPPROTO_PGM":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PGM))},
			"IPPROTO_PIGP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PIGP))},
			"IPPROTO_PIM":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PIM))},
			"IPPROTO_PRM":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PRM))},
			"IPPROTO_PUP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PUP))},
			"IPPROTO_PVP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PVP))},
			"IPPROTO_RAW":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RAW))},
			"IPPROTO_RCCMON":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RCCMON))},
			"IPPROTO_RDP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RDP))},
			"IPPROTO_ROUTING":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ROUTING))},
			"IPPROTO_RSVP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RSVP))},
			"IPPROTO_RVD":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RVD))},
			"IPPROTO_SATEXPAK":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SATEXPAK))},
			"IPPROTO_SATMON":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SATMON))},
			"IPPROTO_SCCSP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SCCSP))},
			"IPPROTO_SCTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SCTP))},
			"IPPROTO_SDRP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SDRP))},
			"IPPROTO_SEP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SEP))},
			"IPPROTO_SKIP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SKIP))},
			"IPPROTO_SRPC":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SRPC))},
			"IPPROTO_ST":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ST))},
			"IPPROTO_SVMTP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SVMTP))},
			"IPPROTO_SWIPE":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_SWIPE))},
			"IPPROTO_TCF":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCF))},
			"IPPROTO_TCP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCP))},
			"IPPROTO_TLSP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TLSP))},
			"IPPROTO_TP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TP))},
			"IPPROTO_TPXX":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TPXX))},
			"IPPROTO_TRUNK1":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TRUNK1))},
			"IPPROTO_TRUNK2":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TRUNK2))},
			"IPPROTO_TTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TTP))},
			"IPPROTO_UDP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDP))},
			"IPPROTO_UNKNOWN":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UNKNOWN))},
			"IPPROTO_VINES":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_VINES))},
			"IPPROTO_VISA":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_VISA))},
			"IPPROTO_VMTP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_VMTP))},
			"IPPROTO_WBEXPAK":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_WBEXPAK))},
			"IPPROTO_WBMON":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_WBMON))},
			"IPPROTO_WSN":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_WSN))},
			"IPPROTO_XNET":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_XNET))},
			"IPPROTO_XTP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_XTP))},
			"IPV6_AUTOFLOWLABEL":                {"untyped int", constant.MakeInt64(int64(q.IPV6_AUTOFLOWLABEL))},
			"IPV6_BINDV6ONLY":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_BINDV6ONLY))},
			"IPV6_CHECKSUM":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_CHECKSUM))},
			"IPV6_DEFAULT_MULTICAST_HOPS":       {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFAULT_MULTICAST_HOPS))},
			"IPV6_DEFAULT_MULTICAST_LOOP":       {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFAULT_MULTICAST_LOOP))},
			"IPV6_DEFHLIM":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFHLIM))},
			"IPV6_DONTFRAG":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_DONTFRAG))},
			"IPV6_DSTOPTS":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_DSTOPTS))},
			"IPV6_FAITH":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_FAITH))},
			"IPV6_FLOWINFO_MASK":                {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_MASK))},
			"IPV6_FLOWLABEL_MASK":               {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWLABEL_MASK))},
			"IPV6_FRAGTTL":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_FRAGTTL))},
			"IPV6_FW_ADD":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_ADD))},
			"IPV6_FW_DEL":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_DEL))},
			"IPV6_FW_FLUSH":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_FLUSH))},
			"IPV6_FW_GET":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_GET))},
			"IPV6_FW_ZERO":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_FW_ZERO))},
			"IPV6_HLIMDEC":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_HLIMDEC))},
			"IPV6_HOPLIMIT":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPLIMIT))},
			"IPV6_HOPOPTS":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPOPTS))},
			"IPV6_IPSEC_POLICY":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_IPSEC_POLICY))},
			"IPV6_JOIN_GROUP":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_GROUP))},
			"IPV6_LEAVE_GROUP":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_GROUP))},
			"IPV6_MAXHLIM":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_MAXHLIM))},
			"IPV6_MAXPACKET":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_MAXPACKET))},
			"IPV6_MMTU":                         {"untyped int", constant.MakeInt64(int64(q.IPV6_MMTU))},
			"IPV6_MSFILTER":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_MSFILTER))},
			"IPV6_MULTICAST_HOPS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_HOPS))},
			"IPV6_MULTICAST_IF":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_IF))},
			"IPV6_MULTICAST_LOOP":               {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_LOOP))},
			"IPV6_NEXTHOP":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_NEXTHOP))},
			"IPV6_PATHMTU":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_PATHMTU))},
			"IPV6_PKTINFO":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_PKTINFO))},
			"IPV6_PKTOPTIONS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_PKTOPTIONS))},
			"IPV6_PORTRANGE":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE))},
			"IPV6_PORTRANGE_DEFAULT":            {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_DEFAULT))},
			"IPV6_PORTRANGE_HIGH":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_HIGH))},
			"IPV6_PORTRANGE_LOW":                {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_LOW))},
			"IPV6_PREFER_TEMPADDR":              {"untyped int", constant.MakeInt64(int64(q.IPV6_PREFER_TEMPADDR))},
			"IPV6_RECVDSTOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVDSTOPTS))},
			"IPV6_RECVHOPLIMIT":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPLIMIT))},
			"IPV6_RECVHOPOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPOPTS))},
			"IPV6_RECVPATHMTU":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPATHMTU))},
			"IPV6_RECVPKTINFO":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPKTINFO))},
			"IPV6_RECVRTHDR":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVRTHDR))},
			"IPV6_RECVTCLASS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVTCLASS))},
			"IPV6_RTHDR":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR))},
			"IPV6_RTHDRDSTOPTS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDRDSTOPTS))},
			"IPV6_RTHDR_LOOSE":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_LOOSE))},
			"IPV6_RTHDR_STRICT":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_STRICT))},
			"IPV6_RTHDR_TYPE_0":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_TYPE_0))},
			"IPV6_SOCKOPT_RESERVED1":            {"untyped int", constant.MakeInt64(int64(q.IPV6_SOCKOPT_RESERVED1))},
			"IPV6_TCLASS":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_TCLASS))},
			"IPV6_UNICAST_HOPS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_UNICAST_HOPS))},
			"IPV6_USE_MIN_MTU":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_USE_MIN_MTU))},
			"IPV6_V6ONLY":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_V6ONLY))},
			"IPV6_VERSION":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_VERSION))},
			"IPV6_VERSION_MASK":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_VERSION_MASK))},
			"IP_ADD_MEMBERSHIP":                 {"untyped int", constant.MakeInt64(int64(q.IP_ADD_MEMBERSHIP))},
			"IP_DEFAULT_MULTICAST_LOOP":         {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_LOOP))},
			"IP_DEFAULT_MULTICAST_TTL":          {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_TTL))},
			"IP_DF":                             {"untyped int", constant.MakeInt64(int64(q.IP_DF))},
			"IP_DROP_MEMBERSHIP":                {"untyped int", constant.MakeInt64(int64(q.IP_DROP_MEMBERSHIP))},
			"IP_DUMMYNET_CONFIGURE":             {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_CONFIGURE))},
			"IP_DUMMYNET_DEL":                   {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_DEL))},
			"IP_DUMMYNET_FLUSH":                 {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_FLUSH))},
			"IP_DUMMYNET_GET":                   {"untyped int", constant.MakeInt64(int64(q.IP_DUMMYNET_GET))},
			"IP_FAITH":                          {"untyped int", constant.MakeInt64(int64(q.IP_FAITH))},
			"IP_FW_ADD":                         {"untyped int", constant.MakeInt64(int64(q.IP_FW_ADD))},
			"IP_FW_DEL":                         {"untyped int", constant.MakeInt64(int64(q.IP_FW_DEL))},
			"IP_FW_FLUSH":                       {"untyped int", constant.MakeInt64(int64(q.IP_FW_FLUSH))},
			"IP_FW_GET":                         {"untyped int", constant.MakeInt64(int64(q.IP_FW_GET))},
			"IP_FW_RESETLOG":                    {"untyped int", constant.MakeInt64(int64(q.IP_FW_RESETLOG))},
			"IP_FW_ZERO":                        {"untyped int", constant.MakeInt64(int64(q.IP_FW_ZERO))},
			"IP_HDRINCL":                        {"untyped int", constant.MakeInt64(int64(q.IP_HDRINCL))},
			"IP_IPSEC_POLICY":                   {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_POLICY))},
			"IP_MAXPACKET":                      {"untyped int", constant.MakeInt64(int64(q.IP_MAXPACKET))},
			"IP_MAX_MEMBERSHIPS":                {"untyped int", constant.MakeInt64(int64(q.IP_MAX_MEMBERSHIPS))},
			"IP_MF":                             {"untyped int", constant.MakeInt64(int64(q.IP_MF))},
			"IP_MINTTL":                         {"untyped int", constant.MakeInt64(int64(q.IP_MINTTL))},
			"IP_MSS":                            {"untyped int", constant.MakeInt64(int64(q.IP_MSS))},
			"IP_MULTICAST_IF":                   {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IF))},
			"IP_MULTICAST_LOOP":                 {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_LOOP))},
			"IP_MULTICAST_TTL":                  {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_TTL))},
			"IP_MULTICAST_VIF":                  {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_VIF))},
			"IP_OFFMASK":                        {"untyped int", constant.MakeInt64(int64(q.IP_OFFMASK))},
			"IP_OPTIONS":                        {"untyped int", constant.MakeInt64(int64(q.IP_OPTIONS))},
			"IP_PORTRANGE":                      {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE))},
			"IP_PORTRANGE_DEFAULT":              {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_DEFAULT))},
			"IP_PORTRANGE_HIGH":                 {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_HIGH))},
			"IP_PORTRANGE_LOW":                  {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_LOW))},
			"IP_RECVDSTADDR":                    {"untyped int", constant.MakeInt64(int64(q.IP_RECVDSTADDR))},
			"IP_RECVIF":                         {"untyped int", constant.MakeInt64(int64(q.IP_RECVIF))},
			"IP_RECVOPTS":                       {"untyped int", constant.MakeInt64(int64(q.IP_RECVOPTS))},
			"IP_RECVRETOPTS":                    {"untyped int", constant.MakeInt64(int64(q.IP_RECVRETOPTS))},
			"IP_RECVTTL":                        {"untyped int", constant.MakeInt64(int64(q.IP_RECVTTL))},
			"IP_RETOPTS":                        {"untyped int", constant.MakeInt64(int64(q.IP_RETOPTS))},
			"IP_RF":                             {"untyped int", constant.MakeInt64(int64(q.IP_RF))},
			"IP_RSVP_OFF":                       {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_OFF))},
			"IP_RSVP_ON":                        {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_ON))},
			"IP_RSVP_VIF_OFF":                   {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_VIF_OFF))},
			"IP_RSVP_VIF_ON":                    {"untyped int", constant.MakeInt64(int64(q.IP_RSVP_VIF_ON))},
			"IP_TOS":                            {"untyped int", constant.MakeInt64(int64(q.IP_TOS))},
			"IP_TTL":                            {"untyped int", constant.MakeInt64(int64(q.IP_TTL))},
			"ISIG":                              {"untyped int", constant.MakeInt64(int64(q.ISIG))},
			"ISTRIP":                            {"untyped int", constant.MakeInt64(int64(q.ISTRIP))},
			"IXANY":                             {"untyped int", constant.MakeInt64(int64(q.IXANY))},
			"IXOFF":                             {"untyped int", constant.MakeInt64(int64(q.IXOFF))},
			"IXON":                              {"untyped int", constant.MakeInt64(int64(q.IXON))},
			"ImplementsGetwd":                   {"untyped bool", constant.MakeBool(bool(q.ImplementsGetwd))},
			"LOCK_EX":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_EX))},
			"LOCK_NB":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_NB))},
			"LOCK_SH":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_SH))},
			"LOCK_UN":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_UN))},
			"MADV_AUTOSYNC":                     {"untyped int", constant.MakeInt64(int64(q.MADV_AUTOSYNC))},
			"MADV_CONTROL_END":                  {"untyped int", constant.MakeInt64(int64(q.MADV_CONTROL_END))},
			"MADV_CONTROL_START":                {"untyped int", constant.MakeInt64(int64(q.MADV_CONTROL_START))},
			"MADV_CORE":                         {"untyped int", constant.MakeInt64(int64(q.MADV_CORE))},
			"MADV_DONTNEED":                     {"untyped int", constant.MakeInt64(int64(q.MADV_DONTNEED))},
			"MADV_FREE":                         {"untyped int", constant.MakeInt64(int64(q.MADV_FREE))},
			"MADV_INVAL":                        {"untyped int", constant.MakeInt64(int64(q.MADV_INVAL))},
			"MADV_NOCORE":                       {"untyped int", constant.MakeInt64(int64(q.MADV_NOCORE))},
			"MADV_NORMAL":                       {"untyped int", constant.MakeInt64(int64(q.MADV_NORMAL))},
			"MADV_NOSYNC":                       {"untyped int", constant.MakeInt64(int64(q.MADV_NOSYNC))},
			"MADV_RANDOM":                       {"untyped int", constant.MakeInt64(int64(q.MADV_RANDOM))},
			"MADV_SEQUENTIAL":                   {"untyped int", constant.MakeInt64(int64(q.MADV_SEQUENTIAL))},
			"MADV_SETMAP":                       {"untyped int", constant.MakeInt64(int64(q.MADV_SETMAP))},
			"MADV_WILLNEED":                     {"untyped int", constant.MakeInt64(int64(q.MADV_WILLNEED))},
			"MAP_ANON":                          {"untyped int", constant.MakeInt64(int64(q.MAP_ANON))},
			"MAP_COPY":                          {"untyped int", constant.MakeInt64(int64(q.MAP_COPY))},
			"MAP_FILE":                          {"untyped int", constant.MakeInt64(int64(q.MAP_FILE))},
			"MAP_FIXED":                         {"untyped int", constant.MakeInt64(int64(q.MAP_FIXED))},
			"MAP_HASSEMAPHORE":                  {"untyped int", constant.MakeInt64(int64(q.MAP_HASSEMAPHORE))},
			"MAP_INHERIT":                       {"untyped int", constant.MakeInt64(int64(q.MAP_INHERIT))},
			"MAP_NOCORE":                        {"untyped int", constant.MakeInt64(int64(q.MAP_NOCORE))},
			"MAP_NOEXTEND":                      {"untyped int", constant.MakeInt64(int64(q.MAP_NOEXTEND))},
			"MAP_NORESERVE":                     {"untyped int", constant.MakeInt64(int64(q.MAP_NORESERVE))},
			"MAP_NOSYNC":                        {"untyped int", constant.MakeInt64(int64(q.MAP_NOSYNC))},
			"MAP_PRIVATE":                       {"untyped int", constant.MakeInt64(int64(q.MAP_PRIVATE))},
			"MAP_RENAME":                        {"untyped int", constant.MakeInt64(int64(q.MAP_RENAME))},
			"MAP_SHARED":                        {"untyped int", constant.MakeInt64(int64(q.MAP_SHARED))},
			"MAP_SIZEALIGN":                     {"untyped int", constant.MakeInt64(int64(q.MAP_SIZEALIGN))},
			"MAP_STACK":                         {"untyped int", constant.MakeInt64(int64(q.MAP_STACK))},
			"MAP_TRYFIXED":                      {"untyped int", constant.MakeInt64(int64(q.MAP_TRYFIXED))},
			"MAP_VPAGETABLE":                    {"untyped int", constant.MakeInt64(int64(q.MAP_VPAGETABLE))},
			"MCL_CURRENT":                       {"untyped int", constant.MakeInt64(int64(q.MCL_CURRENT))},
			"MCL_FUTURE":                        {"untyped int", constant.MakeInt64(int64(q.MCL_FUTURE))},
			"MSG_CMSG_CLOEXEC":                  {"untyped int", constant.MakeInt64(int64(q.MSG_CMSG_CLOEXEC))},
			"MSG_CTRUNC":                        {"untyped int", constant.MakeInt64(int64(q.MSG_CTRUNC))},
			"MSG_DONTROUTE":                     {"untyped int", constant.MakeInt64(int64(q.MSG_DONTROUTE))},
			"MSG_DONTWAIT":                      {"untyped int", constant.MakeInt64(int64(q.MSG_DONTWAIT))},
			"MSG_EOF":                           {"untyped int", constant.MakeInt64(int64(q.MSG_EOF))},
			"MSG_EOR":                           {"untyped int", constant.MakeInt64(int64(q.MSG_EOR))},
			"MSG_FBLOCKING":                     {"untyped int", constant.MakeInt64(int64(q.MSG_FBLOCKING))},
			"MSG_FMASK":                         {"untyped int", constant.MakeInt64(int64(q.MSG_FMASK))},
			"MSG_FNONBLOCKING":                  {"untyped int", constant.MakeInt64(int64(q.MSG_FNONBLOCKING))},
			"MSG_NOSIGNAL":                      {"untyped int", constant.MakeInt64(int64(q.MSG_NOSIGNAL))},
			"MSG_NOTIFICATION":                  {"untyped int", constant.MakeInt64(int64(q.MSG_NOTIFICATION))},
			"MSG_OOB":                           {"untyped int", constant.MakeInt64(int64(q.MSG_OOB))},
			"MSG_PEEK":                          {"untyped int", constant.MakeInt64(int64(q.MSG_PEEK))},
			"MSG_SYNC":                          {"untyped int", constant.MakeInt64(int64(q.MSG_SYNC))},
			"MSG_TRUNC":                         {"untyped int", constant.MakeInt64(int64(q.MSG_TRUNC))},
			"MSG_WAITALL":                       {"untyped int", constant.MakeInt64(int64(q.MSG_WAITALL))},
			"MS_ASYNC":                          {"untyped int", constant.MakeInt64(int64(q.MS_ASYNC))},
			"MS_INVALIDATE":                     {"untyped int", constant.MakeInt64(int64(q.MS_INVALIDATE))},
			"MS_SYNC":                           {"untyped int", constant.MakeInt64(int64(q.MS_SYNC))},
			"NAME_MAX":                          {"untyped int", constant.MakeInt64(int64(q.NAME_MAX))},
			"NET_RT_DUMP":                       {"untyped int", constant.MakeInt64(int64(q.NET_RT_DUMP))},
			"NET_RT_FLAGS":                      {"untyped int", constant.MakeInt64(int64(q.NET_RT_FLAGS))},
			"NET_RT_IFLIST":                     {"untyped int", constant.MakeInt64(int64(q.NET_RT_IFLIST))},
			"NET_RT_MAXID":                      {"untyped int", constant.MakeInt64(int64(q.NET_RT_MAXID))},
			"NOFLSH":                            {"untyped int", constant.MakeInt64(int64(q.NOFLSH))},
			"NOTE_ATTRIB":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_ATTRIB))},
			"NOTE_CHILD":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_CHILD))},
			"NOTE_DELETE":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_DELETE))},
			"NOTE_EXEC":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_EXEC))},
			"NOTE_EXIT":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_EXIT))},
			"NOTE_EXTEND":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_EXTEND))},
			"NOTE_FORK":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_FORK))},
			"NOTE_LINK":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_LINK))},
			"NOTE_LOWAT":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_LOWAT))},
			"NOTE_OOB":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_OOB))},
			"NOTE_PCTRLMASK":                    {"untyped int", constant.MakeInt64(int64(q.NOTE_PCTRLMASK))},
			"NOTE_PDATAMASK":                    {"untyped int", constant.MakeInt64(int64(q.NOTE_PDATAMASK))},
			"NOTE_RENAME":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_RENAME))},
			"NOTE_REVOKE":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_REVOKE))},
			"NOTE_TRACK":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_TRACK))},
			"NOTE_TRACKERR":                     {"untyped int", constant.MakeInt64(int64(q.NOTE_TRACKERR))},
			"NOTE_WRITE":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_WRITE))},
			"OCRNL":                             {"untyped int", constant.MakeInt64(int64(q.OCRNL))},
			"ONLCR":                             {"untyped int", constant.MakeInt64(int64(q.ONLCR))},
			"ONLRET":                            {"untyped int", constant.MakeInt64(int64(q.ONLRET))},
			"ONOCR":                             {"untyped int", constant.MakeInt64(int64(q.ONOCR))},
			"ONOEOT":                            {"untyped int", constant.MakeInt64(int64(q.ONOEOT))},
			"OPOST":                             {"untyped int", constant.MakeInt64(int64(q.OPOST))},
			"O_ACCMODE":                         {"untyped int", constant.MakeInt64(int64(q.O_ACCMODE))},
			"O_APPEND":                          {"untyped int", constant.MakeInt64(int64(q.O_APPEND))},
			"O_ASYNC":                           {"untyped int", constant.MakeInt64(int64(q.O_ASYNC))},
			"O_CLOEXEC":                         {"untyped int", constant.MakeInt64(int64(q.O_CLOEXEC))},
			"O_CREAT":                           {"untyped int", constant.MakeInt64(int64(q.O_CREAT))},
			"O_DIRECT":                          {"untyped int", constant.MakeInt64(int64(q.O_DIRECT))},
			"O_DIRECTORY":                       {"untyped int", constant.MakeInt64(int64(q.O_DIRECTORY))},
			"O_EXCL":                            {"untyped int", constant.MakeInt64(int64(q.O_EXCL))},
			"O_EXLOCK":                          {"untyped int", constant.MakeInt64(int64(q.O_EXLOCK))},
			"O_FAPPEND":                         {"untyped int", constant.MakeInt64(int64(q.O_FAPPEND))},
			"O_FASYNCWRITE":                     {"untyped int", constant.MakeInt64(int64(q.O_FASYNCWRITE))},
			"O_FBLOCKING":                       {"untyped int", constant.MakeInt64(int64(q.O_FBLOCKING))},
			"O_FBUFFERED":                       {"untyped int", constant.MakeInt64(int64(q.O_FBUFFERED))},
			"O_FMASK":                           {"untyped int", constant.MakeInt64(int64(q.O_FMASK))},
			"O_FNONBLOCKING":                    {"untyped int", constant.MakeInt64(int64(q.O_FNONBLOCKING))},
			"O_FOFFSET":                         {"untyped int", constant.MakeInt64(int64(q.O_FOFFSET))},
			"O_FSYNC":                           {"untyped int", constant.MakeInt64(int64(q.O_FSYNC))},
			"O_FSYNCWRITE":                      {"untyped int", constant.MakeInt64(int64(q.O_FSYNCWRITE))},
			"O_FUNBUFFERED":                     {"untyped int", constant.MakeInt64(int64(q.O_FUNBUFFERED))},
			"O_MAPONREAD":                       {"untyped int", constant.MakeInt64(int64(q.O_MAPONREAD))},
			"O_NDELAY":                          {"untyped int", constant.MakeInt64(int64(q.O_NDELAY))},
			"O_NOCTTY":                          {"untyped int", constant.MakeInt64(int64(q.O_NOCTTY))},
			"O_NOFOLLOW":                        {"untyped int", constant.MakeInt64(int64(q.O_NOFOLLOW))},
			"O_NONBLOCK":                        {"untyped int", constant.MakeInt64(int64(q.O_NONBLOCK))},
			"O_RDONLY":                          {"untyped int", constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":                            {"untyped int", constant.MakeInt64(int64(q.O_RDWR))},
			"O_SHLOCK":                          {"untyped int", constant.MakeInt64(int64(q.O_SHLOCK))},
			"O_SYNC":                            {"untyped int", constant.MakeInt64(int64(q.O_SYNC))},
			"O_TRUNC":                           {"untyped int", constant.MakeInt64(int64(q.O_TRUNC))},
			"O_WRONLY":                          {"untyped int", constant.MakeInt64(int64(q.O_WRONLY))},
			"PARENB":                            {"untyped int", constant.MakeInt64(int64(q.PARENB))},
			"PARMRK":                            {"untyped int", constant.MakeInt64(int64(q.PARMRK))},
			"PARODD":                            {"untyped int", constant.MakeInt64(int64(q.PARODD))},
			"PENDIN":                            {"untyped int", constant.MakeInt64(int64(q.PENDIN))},
			"PRIO_PGRP":                         {"untyped int", constant.MakeInt64(int64(q.PRIO_PGRP))},
			"PRIO_PROCESS":                      {"untyped int", constant.MakeInt64(int64(q.PRIO_PROCESS))},
			"PRIO_USER":                         {"untyped int", constant.MakeInt64(int64(q.PRIO_USER))},
			"PROT_EXEC":                         {"untyped int", constant.MakeInt64(int64(q.PROT_EXEC))},
			"PROT_NONE":                         {"untyped int", constant.MakeInt64(int64(q.PROT_NONE))},
			"PROT_READ":                         {"untyped int", constant.MakeInt64(int64(q.PROT_READ))},
			"PROT_WRITE":                        {"untyped int", constant.MakeInt64(int64(q.PROT_WRITE))},
			"PTRACE_CONT":                       {"untyped int", constant.MakeInt64(int64(q.PTRACE_CONT))},
			"PTRACE_KILL":                       {"untyped int", constant.MakeInt64(int64(q.PTRACE_KILL))},
			"PTRACE_TRACEME":                    {"untyped int", constant.MakeInt64(int64(q.PTRACE_TRACEME))},
			"RLIMIT_AS":                         {"untyped int", constant.MakeInt64(int64(q.RLIMIT_AS))},
			"RLIMIT_CORE":                       {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CORE))},
			"RLIMIT_CPU":                        {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CPU))},
			"RLIMIT_DATA":                       {"untyped int", constant.MakeInt64(int64(q.RLIMIT_DATA))},
			"RLIMIT_FSIZE":                      {"untyped int", constant.MakeInt64(int64(q.RLIMIT_FSIZE))},
			"RLIMIT_NOFILE":                     {"untyped int", constant.MakeInt64(int64(q.RLIMIT_NOFILE))},
			"RLIMIT_STACK":                      {"untyped int", constant.MakeInt64(int64(q.RLIMIT_STACK))},
			"RLIM_INFINITY":                     {"untyped int", constant.MakeInt64(int64(q.RLIM_INFINITY))},
			"RTAX_AUTHOR":                       {"untyped int", constant.MakeInt64(int64(q.RTAX_AUTHOR))},
			"RTAX_BRD":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_BRD))},
			"RTAX_DST":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_DST))},
			"RTAX_GATEWAY":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_GATEWAY))},
			"RTAX_GENMASK":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_GENMASK))},
			"RTAX_IFA":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_IFA))},
			"RTAX_IFP":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_IFP))},
			"RTAX_MAX":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_MAX))},
			"RTAX_MPLS1":                        {"untyped int", constant.MakeInt64(int64(q.RTAX_MPLS1))},
			"RTAX_MPLS2":                        {"untyped int", constant.MakeInt64(int64(q.RTAX_MPLS2))},
			"RTAX_MPLS3":                        {"untyped int", constant.MakeInt64(int64(q.RTAX_MPLS3))},
			"RTAX_NETMASK":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_NETMASK))},
			"RTA_AUTHOR":                        {"untyped int", constant.MakeInt64(int64(q.RTA_AUTHOR))},
			"RTA_BRD":                           {"untyped int", constant.MakeInt64(int64(q.RTA_BRD))},
			"RTA_DST":                           {"untyped int", constant.MakeInt64(int64(q.RTA_DST))},
			"RTA_GATEWAY":                       {"untyped int", constant.MakeInt64(int64(q.RTA_GATEWAY))},
			"RTA_GENMASK":                       {"untyped int", constant.MakeInt64(int64(q.RTA_GENMASK))},
			"RTA_IFA":                           {"untyped int", constant.MakeInt64(int64(q.RTA_IFA))},
			"RTA_IFP":                           {"untyped int", constant.MakeInt64(int64(q.RTA_IFP))},
			"RTA_MPLS1":                         {"untyped int", constant.MakeInt64(int64(q.RTA_MPLS1))},
			"RTA_MPLS2":                         {"untyped int", constant.MakeInt64(int64(q.RTA_MPLS2))},
			"RTA_MPLS3":                         {"untyped int", constant.MakeInt64(int64(q.RTA_MPLS3))},
			"RTA_NETMASK":                       {"untyped int", constant.MakeInt64(int64(q.RTA_NETMASK))},
			"RTF_BLACKHOLE":                     {"untyped int", constant.MakeInt64(int64(q.RTF_BLACKHOLE))},
			"RTF_BROADCAST":                     {"untyped int", constant.MakeInt64(int64(q.RTF_BROADCAST))},
			"RTF_CLONING":                       {"untyped int", constant.MakeInt64(int64(q.RTF_CLONING))},
			"RTF_DONE":                          {"untyped int", constant.MakeInt64(int64(q.RTF_DONE))},
			"RTF_DYNAMIC":                       {"untyped int", constant.MakeInt64(int64(q.RTF_DYNAMIC))},
			"RTF_GATEWAY":                       {"untyped int", constant.MakeInt64(int64(q.RTF_GATEWAY))},
			"RTF_HOST":                          {"untyped int", constant.MakeInt64(int64(q.RTF_HOST))},
			"RTF_LLINFO":                        {"untyped int", constant.MakeInt64(int64(q.RTF_LLINFO))},
			"RTF_LOCAL":                         {"untyped int", constant.MakeInt64(int64(q.RTF_LOCAL))},
			"RTF_MODIFIED":                      {"untyped int", constant.MakeInt64(int64(q.RTF_MODIFIED))},
			"RTF_MPLSOPS":                       {"untyped int", constant.MakeInt64(int64(q.RTF_MPLSOPS))},
			"RTF_MULTICAST":                     {"untyped int", constant.MakeInt64(int64(q.RTF_MULTICAST))},
			"RTF_PINNED":                        {"untyped int", constant.MakeInt64(int64(q.RTF_PINNED))},
			"RTF_PRCLONING":                     {"untyped int", constant.MakeInt64(int64(q.RTF_PRCLONING))},
			"RTF_PROTO1":                        {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO1))},
			"RTF_PROTO2":                        {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO2))},
			"RTF_PROTO3":                        {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO3))},
			"RTF_REJECT":                        {"untyped int", constant.MakeInt64(int64(q.RTF_REJECT))},
			"RTF_STATIC":                        {"untyped int", constant.MakeInt64(int64(q.RTF_STATIC))},
			"RTF_UP":                            {"untyped int", constant.MakeInt64(int64(q.RTF_UP))},
			"RTF_WASCLONED":                     {"untyped int", constant.MakeInt64(int64(q.RTF_WASCLONED))},
			"RTF_XRESOLVE":                      {"untyped int", constant.MakeInt64(int64(q.RTF_XRESOLVE))},
			"RTM_ADD":                           {"untyped int", constant.MakeInt64(int64(q.RTM_ADD))},
			"RTM_CHANGE":                        {"untyped int", constant.MakeInt64(int64(q.RTM_CHANGE))},
			"RTM_DELADDR":                       {"untyped int", constant.MakeInt64(int64(q.RTM_DELADDR))},
			"RTM_DELETE":                        {"untyped int", constant.MakeInt64(int64(q.RTM_DELETE))},
			"RTM_DELMADDR":                      {"untyped int", constant.MakeInt64(int64(q.RTM_DELMADDR))},
			"RTM_GET":                           {"untyped int", constant.MakeInt64(int64(q.RTM_GET))},
			"RTM_IEEE80211":                     {"untyped int", constant.MakeInt64(int64(q.RTM_IEEE80211))},
			"RTM_IFANNOUNCE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_IFANNOUNCE))},
			"RTM_IFINFO":                        {"untyped int", constant.MakeInt64(int64(q.RTM_IFINFO))},
			"RTM_LOCK":                          {"untyped int", constant.MakeInt64(int64(q.RTM_LOCK))},
			"RTM_LOSING":                        {"untyped int", constant.MakeInt64(int64(q.RTM_LOSING))},
			"RTM_MISS":                          {"untyped int", constant.MakeInt64(int64(q.RTM_MISS))},
			"RTM_NEWADDR":                       {"untyped int", constant.MakeInt64(int64(q.RTM_NEWADDR))},
			"RTM_NEWMADDR":                      {"untyped int", constant.MakeInt64(int64(q.RTM_NEWMADDR))},
			"RTM_OLDADD":                        {"untyped int", constant.MakeInt64(int64(q.RTM_OLDADD))},
			"RTM_OLDDEL":                        {"untyped int", constant.MakeInt64(int64(q.RTM_OLDDEL))},
			"RTM_REDIRECT":                      {"untyped int", constant.MakeInt64(int64(q.RTM_REDIRECT))},
			"RTM_RESOLVE":                       {"untyped int", constant.MakeInt64(int64(q.RTM_RESOLVE))},
			"RTM_RTTUNIT":                       {"untyped int", constant.MakeInt64(int64(q.RTM_RTTUNIT))},
			"RTM_VERSION":                       {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION))},
			"RTV_EXPIRE":                        {"untyped int", constant.MakeInt64(int64(q.RTV_EXPIRE))},
			"RTV_HOPCOUNT":                      {"untyped int", constant.MakeInt64(int64(q.RTV_HOPCOUNT))},
			"RTV_IWCAPSEGS":                     {"untyped int", constant.MakeInt64(int64(q.RTV_IWCAPSEGS))},
			"RTV_IWMAXSEGS":                     {"untyped int", constant.MakeInt64(int64(q.RTV_IWMAXSEGS))},
			"RTV_MSL":                           {"untyped int", constant.MakeInt64(int64(q.RTV_MSL))},
			"RTV_MTU":                           {"untyped int", constant.MakeInt64(int64(q.RTV_MTU))},
			"RTV_RPIPE":                         {"untyped int", constant.MakeInt64(int64(q.RTV_RPIPE))},
			"RTV_RTT":                           {"untyped int", constant.MakeInt64(int64(q.RTV_RTT))},
			"RTV_RTTVAR":                        {"untyped int", constant.MakeInt64(int64(q.RTV_RTTVAR))},
			"RTV_SPIPE":                         {"untyped int", constant.MakeInt64(int64(q.RTV_SPIPE))},
			"RTV_SSTHRESH":                      {"untyped int", constant.MakeInt64(int64(q.RTV_SSTHRESH))},
			"RUSAGE_CHILDREN":                   {"untyped int", constant.MakeInt64(int64(q.RUSAGE_CHILDREN))},
			"RUSAGE_SELF":                       {"untyped int", constant.MakeInt64(int64(q.RUSAGE_SELF))},
			"SCM_CREDS":                         {"untyped int", constant.MakeInt64(int64(q.SCM_CREDS))},
			"SCM_RIGHTS":                        {"untyped int", constant.MakeInt64(int64(q.SCM_RIGHTS))},
			"SCM_TIMESTAMP":                     {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMP))},
			"SHUT_RD":                           {"untyped int", constant.MakeInt64(int64(q.SHUT_RD))},
			"SHUT_RDWR":                         {"untyped int", constant.MakeInt64(int64(q.SHUT_RDWR))},
			"SHUT_WR":                           {"untyped int", constant.MakeInt64(int64(q.SHUT_WR))},
			"SIOCADDMULTI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCADDMULTI))},
			"SIOCADDRT":                         {"untyped int", constant.MakeInt64(int64(q.SIOCADDRT))},
			"SIOCAIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCAIFADDR))},
			"SIOCALIFADDR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCALIFADDR))},
			"SIOCATMARK":                        {"untyped int", constant.MakeInt64(int64(q.SIOCATMARK))},
			"SIOCDELMULTI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDELMULTI))},
			"SIOCDELRT":                         {"untyped int", constant.MakeInt64(int64(q.SIOCDELRT))},
			"SIOCDIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCDIFADDR))},
			"SIOCDIFPHYADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCDIFPHYADDR))},
			"SIOCDLIFADDR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDLIFADDR))},
			"SIOCGDRVSPEC":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGDRVSPEC))},
			"SIOCGETSGCNT":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGETSGCNT))},
			"SIOCGETVIFCNT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGETVIFCNT))},
			"SIOCGHIWAT":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGHIWAT))},
			"SIOCGIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFADDR))},
			"SIOCGIFBRDADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBRDADDR))},
			"SIOCGIFCAP":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCAP))},
			"SIOCGIFCONF":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCONF))},
			"SIOCGIFDATA":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDATA))},
			"SIOCGIFDSTADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDSTADDR))},
			"SIOCGIFFLAGS":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFFLAGS))},
			"SIOCGIFGENERIC":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGENERIC))},
			"SIOCGIFGMEMB":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGMEMB))},
			"SIOCGIFINDEX":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFINDEX))},
			"SIOCGIFMEDIA":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMEDIA))},
			"SIOCGIFMETRIC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMETRIC))},
			"SIOCGIFMTU":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMTU))},
			"SIOCGIFNETMASK":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNETMASK))},
			"SIOCGIFPDSTADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPDSTADDR))},
			"SIOCGIFPHYS":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPHYS))},
			"SIOCGIFPOLLCPU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPOLLCPU))},
			"SIOCGIFPSRCADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPSRCADDR))},
			"SIOCGIFSTATUS":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFSTATUS))},
			"SIOCGIFTSOLEN":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFTSOLEN))},
			"SIOCGLIFADDR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFADDR))},
			"SIOCGLIFPHYADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFPHYADDR))},
			"SIOCGLOWAT":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGLOWAT))},
			"SIOCGPGRP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGPGRP))},
			"SIOCGPRIVATE_0":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGPRIVATE_0))},
			"SIOCGPRIVATE_1":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGPRIVATE_1))},
			"SIOCIFCREATE":                      {"untyped int", constant.MakeInt64(int64(q.SIOCIFCREATE))},
			"SIOCIFCREATE2":                     {"untyped int", constant.MakeInt64(int64(q.SIOCIFCREATE2))},
			"SIOCIFDESTROY":                     {"untyped int", constant.MakeInt64(int64(q.SIOCIFDESTROY))},
			"SIOCIFGCLONERS":                    {"untyped int", constant.MakeInt64(int64(q.SIOCIFGCLONERS))},
			"SIOCSDRVSPEC":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSDRVSPEC))},
			"SIOCSHIWAT":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSHIWAT))},
			"SIOCSIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFADDR))},
			"SIOCSIFBRDADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBRDADDR))},
			"SIOCSIFCAP":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFCAP))},
			"SIOCSIFDSTADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFDSTADDR))},
			"SIOCSIFFLAGS":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFFLAGS))},
			"SIOCSIFGENERIC":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFGENERIC))},
			"SIOCSIFLLADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFLLADDR))},
			"SIOCSIFMEDIA":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMEDIA))},
			"SIOCSIFMETRIC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMETRIC))},
			"SIOCSIFMTU":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMTU))},
			"SIOCSIFNAME":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNAME))},
			"SIOCSIFNETMASK":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNETMASK))},
			"SIOCSIFPHYADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPHYADDR))},
			"SIOCSIFPHYS":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPHYS))},
			"SIOCSIFPOLLCPU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPOLLCPU))},
			"SIOCSIFTSOLEN":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFTSOLEN))},
			"SIOCSLIFPHYADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPHYADDR))},
			"SIOCSLOWAT":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSLOWAT))},
			"SIOCSPGRP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSPGRP))},
			"SOCK_CLOEXEC":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_CLOEXEC))},
			"SOCK_DGRAM":                        {"untyped int", constant.MakeInt64(int64(q.SOCK_DGRAM))},
			"SOCK_MAXADDRLEN":                   {"untyped int", constant.MakeInt64(int64(q.SOCK_MAXADDRLEN))},
			"SOCK_NONBLOCK":                     {"untyped int", constant.MakeInt64(int64(q.SOCK_NONBLOCK))},
			"SOCK_RAW":                          {"untyped int", constant.MakeInt64(int64(q.SOCK_RAW))},
			"SOCK_RDM":                          {"untyped int", constant.MakeInt64(int64(q.SOCK_RDM))},
			"SOCK_SEQPACKET":                    {"untyped int", constant.MakeInt64(int64(q.SOCK_SEQPACKET))},
			"SOCK_STREAM":                       {"untyped int", constant.MakeInt64(int64(q.SOCK_STREAM))},
			"SOL_SOCKET":                        {"untyped int", constant.MakeInt64(int64(q.SOL_SOCKET))},
			"SOMAXCONN":                         {"untyped int", constant.MakeInt64(int64(q.SOMAXCONN))},
			"SO_ACCEPTCONN":                     {"untyped int", constant.MakeInt64(int64(q.SO_ACCEPTCONN))},
			"SO_ACCEPTFILTER":                   {"untyped int", constant.MakeInt64(int64(q.SO_ACCEPTFILTER))},
			"SO_BROADCAST":                      {"untyped int", constant.MakeInt64(int64(q.SO_BROADCAST))},
			"SO_DEBUG":                          {"untyped int", constant.MakeInt64(int64(q.SO_DEBUG))},
			"SO_DONTROUTE":                      {"untyped int", constant.MakeInt64(int64(q.SO_DONTROUTE))},
			"SO_ERROR":                          {"untyped int", constant.MakeInt64(int64(q.SO_ERROR))},
			"SO_KEEPALIVE":                      {"untyped int", constant.MakeInt64(int64(q.SO_KEEPALIVE))},
			"SO_LINGER":                         {"untyped int", constant.MakeInt64(int64(q.SO_LINGER))},
			"SO_NOSIGPIPE":                      {"untyped int", constant.MakeInt64(int64(q.SO_NOSIGPIPE))},
			"SO_OOBINLINE":                      {"untyped int", constant.MakeInt64(int64(q.SO_OOBINLINE))},
			"SO_RCVBUF":                         {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUF))},
			"SO_RCVLOWAT":                       {"untyped int", constant.MakeInt64(int64(q.SO_RCVLOWAT))},
			"SO_RCVTIMEO":                       {"untyped int", constant.MakeInt64(int64(q.SO_RCVTIMEO))},
			"SO_REUSEADDR":                      {"untyped int", constant.MakeInt64(int64(q.SO_REUSEADDR))},
			"SO_REUSEPORT":                      {"untyped int", constant.MakeInt64(int64(q.SO_REUSEPORT))},
			"SO_SNDBUF":                         {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUF))},
			"SO_SNDLOWAT":                       {"untyped int", constant.MakeInt64(int64(q.SO_SNDLOWAT))},
			"SO_SNDSPACE":                       {"untyped int", constant.MakeInt64(int64(q.SO_SNDSPACE))},
			"SO_SNDTIMEO":                       {"untyped int", constant.MakeInt64(int64(q.SO_SNDTIMEO))},
			"SO_TIMESTAMP":                      {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMP))},
			"SO_TYPE":                           {"untyped int", constant.MakeInt64(int64(q.SO_TYPE))},
			"SO_USELOOPBACK":                    {"untyped int", constant.MakeInt64(int64(q.SO_USELOOPBACK))},
			"SYS_ACCEPT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_ACCEPT))},
			"SYS_ACCEPT4":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ACCEPT4))},
			"SYS_ACCESS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_ACCESS))},
			"SYS_ACCT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_ACCT))},
			"SYS_ADJTIME":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ADJTIME))},
			"SYS_AIO_CANCEL":                    {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_CANCEL))},
			"SYS_AIO_ERROR":                     {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_ERROR))},
			"SYS_AIO_READ":                      {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_READ))},
			"SYS_AIO_RETURN":                    {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_RETURN))},
			"SYS_AIO_SUSPEND":                   {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_SUSPEND))},
			"SYS_AIO_WAITCOMPLETE":              {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_WAITCOMPLETE))},
			"SYS_AIO_WRITE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_AIO_WRITE))},
			"SYS_BIND":                          {"untyped int", constant.MakeInt64(int64(q.SYS_BIND))},
			"SYS_CHDIR":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CHDIR))},
			"SYS_CHFLAGS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_CHFLAGS))},
			"SYS_CHMOD":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CHMOD))},
			"SYS_CHOWN":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CHOWN))},
			"SYS_CHROOT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CHROOT))},
			"SYS_CHROOT_KERNEL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CHROOT_KERNEL))},
			"SYS_CLOCK_GETRES":                  {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_GETRES))},
			"SYS_CLOCK_GETTIME":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_GETTIME))},
			"SYS_CLOCK_SETTIME":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_SETTIME))},
			"SYS_CLOSE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CLOSE))},
			"SYS_CLOSEFROM":                     {"untyped int", constant.MakeInt64(int64(q.SYS_CLOSEFROM))},
			"SYS_CONNECT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_CONNECT))},
			"SYS_DUP":                           {"untyped int", constant.MakeInt64(int64(q.SYS_DUP))},
			"SYS_DUP2":                          {"untyped int", constant.MakeInt64(int64(q.SYS_DUP2))},
			"SYS_EACCESS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_EACCESS))},
			"SYS_EXECVE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_EXECVE))},
			"SYS_EXEC_SYS_REGISTER":             {"untyped int", constant.MakeInt64(int64(q.SYS_EXEC_SYS_REGISTER))},
			"SYS_EXEC_SYS_UNREGISTER":           {"untyped int", constant.MakeInt64(int64(q.SYS_EXEC_SYS_UNREGISTER))},
			"SYS_EXIT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_EXIT))},
			"SYS_EXTACCEPT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_EXTACCEPT))},
			"SYS_EXTATTRCTL":                    {"untyped int", constant.MakeInt64(int64(q.SYS_EXTATTRCTL))},
			"SYS_EXTATTR_DELETE_FILE":           {"untyped int", constant.MakeInt64(int64(q.SYS_EXTATTR_DELETE_FILE))},
			"SYS_EXTATTR_GET_FILE":              {"untyped int", constant.MakeInt64(int64(q.SYS_EXTATTR_GET_FILE))},
			"SYS_EXTATTR_SET_FILE":              {"untyped int", constant.MakeInt64(int64(q.SYS_EXTATTR_SET_FILE))},
			"SYS_EXTCONNECT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_EXTCONNECT))},
			"SYS_EXTEXIT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_EXTEXIT))},
			"SYS_EXTPREAD":                      {"untyped int", constant.MakeInt64(int64(q.SYS_EXTPREAD))},
			"SYS_EXTPREADV":                     {"untyped int", constant.MakeInt64(int64(q.SYS_EXTPREADV))},
			"SYS_EXTPWRITE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_EXTPWRITE))},
			"SYS_EXTPWRITEV":                    {"untyped int", constant.MakeInt64(int64(q.SYS_EXTPWRITEV))},
			"SYS_FACCESSAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FACCESSAT))},
			"SYS_FCHDIR":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FCHDIR))},
			"SYS_FCHFLAGS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FCHFLAGS))},
			"SYS_FCHMOD":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMOD))},
			"SYS_FCHMODAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMODAT))},
			"SYS_FCHOWN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FCHOWN))},
			"SYS_FCHOWNAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FCHOWNAT))},
			"SYS_FCNTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FCNTL))},
			"SYS_FHOPEN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FHOPEN))},
			"SYS_FHSTAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FHSTAT))},
			"SYS_FHSTATFS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FHSTATFS))},
			"SYS_FHSTATVFS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FHSTATVFS))},
			"SYS_FLOCK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FLOCK))},
			"SYS_FORK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_FORK))},
			"SYS_FPATHCONF":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FPATHCONF))},
			"SYS_FSTAT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FSTAT))},
			"SYS_FSTATAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATAT))},
			"SYS_FSTATFS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATFS))},
			"SYS_FSTATVFS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATVFS))},
			"SYS_FSYNC":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FSYNC))},
			"SYS_FTRUNCATE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FTRUNCATE))},
			"SYS_FUTIMES":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FUTIMES))},
			"SYS_GETDENTS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETDENTS))},
			"SYS_GETDIRENTRIES":                 {"untyped int", constant.MakeInt64(int64(q.SYS_GETDIRENTRIES))},
			"SYS_GETDOMAINNAME":                 {"untyped int", constant.MakeInt64(int64(q.SYS_GETDOMAINNAME))},
			"SYS_GETDTABLESIZE":                 {"untyped int", constant.MakeInt64(int64(q.SYS_GETDTABLESIZE))},
			"SYS_GETEGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETEGID))},
			"SYS_GETEUID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETEUID))},
			"SYS_GETFH":                         {"untyped int", constant.MakeInt64(int64(q.SYS_GETFH))},
			"SYS_GETFSSTAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETFSSTAT))},
			"SYS_GETGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETGID))},
			"SYS_GETGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETGROUPS))},
			"SYS_GETITIMER":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETITIMER))},
			"SYS_GETLOGIN":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETLOGIN))},
			"SYS_GETPEERNAME":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETPEERNAME))},
			"SYS_GETPGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGID))},
			"SYS_GETPGRP":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGRP))},
			"SYS_GETPID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETPID))},
			"SYS_GETPPID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETPPID))},
			"SYS_GETPRIORITY":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETPRIORITY))},
			"SYS_GETRESGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRESGID))},
			"SYS_GETRESUID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRESUID))},
			"SYS_GETRLIMIT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRLIMIT))},
			"SYS_GETRUSAGE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRUSAGE))},
			"SYS_GETSID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETSID))},
			"SYS_GETSOCKNAME":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKNAME))},
			"SYS_GETSOCKOPT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKOPT))},
			"SYS_GETTIMEOFDAY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETTIMEOFDAY))},
			"SYS_GETUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETUID))},
			"SYS_GETVFSSTAT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETVFSSTAT))},
			"SYS_GET_TLS_AREA":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GET_TLS_AREA))},
			"SYS_IOCTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_IOCTL))},
			"SYS_IOPRIO_GET":                    {"untyped int", constant.MakeInt64(int64(q.SYS_IOPRIO_GET))},
			"SYS_IOPRIO_SET":                    {"untyped int", constant.MakeInt64(int64(q.SYS_IOPRIO_SET))},
			"SYS_ISSETUGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_ISSETUGID))},
			"SYS_JAIL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_JAIL))},
			"SYS_JAIL_ATTACH":                   {"untyped int", constant.MakeInt64(int64(q.SYS_JAIL_ATTACH))},
			"SYS_KEVENT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_KEVENT))},
			"SYS_KILL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_KILL))},
			"SYS_KLDFIND":                       {"untyped int", constant.MakeInt64(int64(q.SYS_KLDFIND))},
			"SYS_KLDFIRSTMOD":                   {"untyped int", constant.MakeInt64(int64(q.SYS_KLDFIRSTMOD))},
			"SYS_KLDLOAD":                       {"untyped int", constant.MakeInt64(int64(q.SYS_KLDLOAD))},
			"SYS_KLDNEXT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_KLDNEXT))},
			"SYS_KLDSTAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_KLDSTAT))},
			"SYS_KLDSYM":                        {"untyped int", constant.MakeInt64(int64(q.SYS_KLDSYM))},
			"SYS_KLDUNLOAD":                     {"untyped int", constant.MakeInt64(int64(q.SYS_KLDUNLOAD))},
			"SYS_KQUEUE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_KQUEUE))},
			"SYS_KTRACE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_KTRACE))},
			"SYS_LCHFLAGS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_LCHFLAGS))},
			"SYS_LCHMOD":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LCHMOD))},
			"SYS_LCHOWN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LCHOWN))},
			"SYS_LINK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_LINK))},
			"SYS_LINKAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LINKAT))},
			"SYS_LIO_LISTIO":                    {"untyped int", constant.MakeInt64(int64(q.SYS_LIO_LISTIO))},
			"SYS_LISTEN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LISTEN))},
			"SYS_LPATHCONF":                     {"untyped int", constant.MakeInt64(int64(q.SYS_LPATHCONF))},
			"SYS_LSEEK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LSEEK))},
			"SYS_LSTAT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LSTAT))},
			"SYS_LUTIMES":                       {"untyped int", constant.MakeInt64(int64(q.SYS_LUTIMES))},
			"SYS_LWP_CREATE":                    {"untyped int", constant.MakeInt64(int64(q.SYS_LWP_CREATE))},
			"SYS_LWP_GETTID":                    {"untyped int", constant.MakeInt64(int64(q.SYS_LWP_GETTID))},
			"SYS_LWP_KILL":                      {"untyped int", constant.MakeInt64(int64(q.SYS_LWP_KILL))},
			"SYS_LWP_RTPRIO":                    {"untyped int", constant.MakeInt64(int64(q.SYS_LWP_RTPRIO))},
			"SYS_MADVISE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MADVISE))},
			"SYS_MCONTROL":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MCONTROL))},
			"SYS_MINCORE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MINCORE))},
			"SYS_MINHERIT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MINHERIT))},
			"SYS_MKDIR":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIR))},
			"SYS_MKDIRAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIRAT))},
			"SYS_MKFIFO":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MKFIFO))},
			"SYS_MKFIFOAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MKFIFOAT))},
			"SYS_MKNOD":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MKNOD))},
			"SYS_MKNODAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MKNODAT))},
			"SYS_MLOCK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCK))},
			"SYS_MLOCKALL":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCKALL))},
			"SYS_MMAP":                          {"untyped int", constant.MakeInt64(int64(q.SYS_MMAP))},
			"SYS_MODFIND":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MODFIND))},
			"SYS_MODFNEXT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MODFNEXT))},
			"SYS_MODNEXT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MODNEXT))},
			"SYS_MODSTAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MODSTAT))},
			"SYS_MOUNT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MOUNT))},
			"SYS_MOUNTCTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MOUNTCTL))},
			"SYS_MPROTECT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MPROTECT))},
			"SYS_MQ_CLOSE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_CLOSE))},
			"SYS_MQ_GETATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_GETATTR))},
			"SYS_MQ_NOTIFY":                     {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_NOTIFY))},
			"SYS_MQ_OPEN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_OPEN))},
			"SYS_MQ_RECEIVE":                    {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_RECEIVE))},
			"SYS_MQ_SEND":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_SEND))},
			"SYS_MQ_SETATTR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_SETATTR))},
			"SYS_MQ_TIMEDRECEIVE":               {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_TIMEDRECEIVE))},
			"SYS_MQ_TIMEDSEND":                  {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_TIMEDSEND))},
			"SYS_MQ_UNLINK":                     {"untyped int", constant.MakeInt64(int64(q.SYS_MQ_UNLINK))},
			"SYS_MSGCTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGCTL))},
			"SYS_MSGGET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGGET))},
			"SYS_MSGRCV":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGRCV))},
			"SYS_MSGSND":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGSND))},
			"SYS_MSYNC":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MSYNC))},
			"SYS_MUNLOCK":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCK))},
			"SYS_MUNLOCKALL":                    {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCKALL))},
			"SYS_MUNMAP":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MUNMAP))},
			"SYS_NANOSLEEP":                     {"untyped int", constant.MakeInt64(int64(q.SYS_NANOSLEEP))},
			"SYS_NTP_ADJTIME":                   {"untyped int", constant.MakeInt64(int64(q.SYS_NTP_ADJTIME))},
			"SYS_OBREAK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_OBREAK))},
			"SYS_OPEN":                          {"untyped int", constant.MakeInt64(int64(q.SYS_OPEN))},
			"SYS_OPENAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_OPENAT))},
			"SYS_OPENBSD_POLL":                  {"untyped int", constant.MakeInt64(int64(q.SYS_OPENBSD_POLL))},
			"SYS_PATHCONF":                      {"untyped int", constant.MakeInt64(int64(q.SYS_PATHCONF))},
			"SYS_PIPE":                          {"untyped int", constant.MakeInt64(int64(q.SYS_PIPE))},
			"SYS_PIPE2":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PIPE2))},
			"SYS_POLL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_POLL))},
			"SYS_PROFIL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PROFIL))},
			"SYS_PSELECT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_PSELECT))},
			"SYS_PTRACE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PTRACE))},
			"SYS_QUOTACTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS_QUOTACTL))},
			"SYS_READ":                          {"untyped int", constant.MakeInt64(int64(q.SYS_READ))},
			"SYS_READLINK":                      {"untyped int", constant.MakeInt64(int64(q.SYS_READLINK))},
			"SYS_READLINKAT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_READLINKAT))},
			"SYS_READV":                         {"untyped int", constant.MakeInt64(int64(q.SYS_READV))},
			"SYS_REBOOT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_REBOOT))},
			"SYS_RECVFROM":                      {"untyped int", constant.MakeInt64(int64(q.SYS_RECVFROM))},
			"SYS_RECVMSG":                       {"untyped int", constant.MakeInt64(int64(q.SYS_RECVMSG))},
			"SYS_RENAME":                        {"untyped int", constant.MakeInt64(int64(q.SYS_RENAME))},
			"SYS_RENAMEAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_RENAMEAT))},
			"SYS_REVOKE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_REVOKE))},
			"SYS_RFORK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_RFORK))},
			"SYS_RMDIR":                         {"untyped int", constant.MakeInt64(int64(q.SYS_RMDIR))},
			"SYS_RTPRIO":                        {"untyped int", constant.MakeInt64(int64(q.SYS_RTPRIO))},
			"SYS_SBRK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_SBRK))},
			"SYS_SCHED_GETPARAM":                {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GETPARAM))},
			"SYS_SCHED_GETSCHEDULER":            {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GETSCHEDULER))},
			"SYS_SCHED_GET_PRIORITY_MAX":        {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GET_PRIORITY_MAX))},
			"SYS_SCHED_GET_PRIORITY_MIN":        {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_GET_PRIORITY_MIN))},
			"SYS_SCHED_RR_GET_INTERVAL":         {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_RR_GET_INTERVAL))},
			"SYS_SCHED_SETPARAM":                {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_SETPARAM))},
			"SYS_SCHED_SETSCHEDULER":            {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_SETSCHEDULER))},
			"SYS_SCHED_YIELD":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_YIELD))},
			"SYS_SCTP_PEELOFF":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SCTP_PEELOFF))},
			"SYS_SELECT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SELECT))},
			"SYS_SEMGET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SEMGET))},
			"SYS_SEMOP":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SEMOP))},
			"SYS_SENDFILE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SENDFILE))},
			"SYS_SENDMSG":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SENDMSG))},
			"SYS_SENDTO":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SENDTO))},
			"SYS_SETDOMAINNAME":                 {"untyped int", constant.MakeInt64(int64(q.SYS_SETDOMAINNAME))},
			"SYS_SETEGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETEGID))},
			"SYS_SETEUID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETEUID))},
			"SYS_SETGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETGID))},
			"SYS_SETGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETGROUPS))},
			"SYS_SETITIMER":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETITIMER))},
			"SYS_SETLOGIN":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETLOGIN))},
			"SYS_SETPGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETPGID))},
			"SYS_SETPRIORITY":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SETPRIORITY))},
			"SYS_SETREGID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETREGID))},
			"SYS_SETRESGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETRESGID))},
			"SYS_SETRESUID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETRESUID))},
			"SYS_SETREUID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETREUID))},
			"SYS_SETRLIMIT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETRLIMIT))},
			"SYS_SETSID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETSID))},
			"SYS_SETSOCKOPT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETSOCKOPT))},
			"SYS_SETTIMEOFDAY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SETTIMEOFDAY))},
			"SYS_SETUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETUID))},
			"SYS_SET_TLS_AREA":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SET_TLS_AREA))},
			"SYS_SHMAT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SHMAT))},
			"SYS_SHMCTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SHMCTL))},
			"SYS_SHMDT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SHMDT))},
			"SYS_SHMGET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SHMGET))},
			"SYS_SHUTDOWN":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SHUTDOWN))},
			"SYS_SIGACTION":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SIGACTION))},
			"SYS_SIGALTSTACK":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SIGALTSTACK))},
			"SYS_SIGPENDING":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPENDING))},
			"SYS_SIGPROCMASK":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPROCMASK))},
			"SYS_SIGRETURN":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SIGRETURN))},
			"SYS_SIGSUSPEND":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGSUSPEND))},
			"SYS_SIGTIMEDWAIT":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SIGTIMEDWAIT))},
			"SYS_SIGWAITINFO":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SIGWAITINFO))},
			"SYS_SOCKET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKET))},
			"SYS_SOCKETPAIR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKETPAIR))},
			"SYS_SSTK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_SSTK))},
			"SYS_STAT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_STAT))},
			"SYS_STATFS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_STATFS))},
			"SYS_STATVFS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_STATVFS))},
			"SYS_SWAPOFF":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SWAPOFF))},
			"SYS_SWAPON":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SWAPON))},
			"SYS_SYMLINK":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SYMLINK))},
			"SYS_SYMLINKAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SYMLINKAT))},
			"SYS_SYNC":                          {"untyped int", constant.MakeInt64(int64(q.SYS_SYNC))},
			"SYS_SYSARCH":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SYSARCH))},
			"SYS_SYS_CHECKPOINT":                {"untyped int", constant.MakeInt64(int64(q.SYS_SYS_CHECKPOINT))},
			"SYS_TRUNCATE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_TRUNCATE))},
			"SYS_UMASK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_UMASK))},
			"SYS_UMTX_SLEEP":                    {"untyped int", constant.MakeInt64(int64(q.SYS_UMTX_SLEEP))},
			"SYS_UMTX_WAKEUP":                   {"untyped int", constant.MakeInt64(int64(q.SYS_UMTX_WAKEUP))},
			"SYS_UNAME":                         {"untyped int", constant.MakeInt64(int64(q.SYS_UNAME))},
			"SYS_UNDELETE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_UNDELETE))},
			"SYS_UNLINK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UNLINK))},
			"SYS_UNLINKAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_UNLINKAT))},
			"SYS_UNMOUNT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_UNMOUNT))},
			"SYS_USCHED_SET":                    {"untyped int", constant.MakeInt64(int64(q.SYS_USCHED_SET))},
			"SYS_UTIMENSAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_UTIMENSAT))},
			"SYS_UTIMES":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UTIMES))},
			"SYS_UTRACE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UTRACE))},
			"SYS_UUIDGEN":                       {"untyped int", constant.MakeInt64(int64(q.SYS_UUIDGEN))},
			"SYS_VARSYM_GET":                    {"untyped int", constant.MakeInt64(int64(q.SYS_VARSYM_GET))},
			"SYS_VARSYM_LIST":                   {"untyped int", constant.MakeInt64(int64(q.SYS_VARSYM_LIST))},
			"SYS_VARSYM_SET":                    {"untyped int", constant.MakeInt64(int64(q.SYS_VARSYM_SET))},
			"SYS_VFORK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_VFORK))},
			"SYS_VMM_GUEST_CTL":                 {"untyped int", constant.MakeInt64(int64(q.SYS_VMM_GUEST_CTL))},
			"SYS_VMM_GUEST_SYNC_ADDR":           {"untyped int", constant.MakeInt64(int64(q.SYS_VMM_GUEST_SYNC_ADDR))},
			"SYS_VMSPACE_CREATE":                {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_CREATE))},
			"SYS_VMSPACE_CTL":                   {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_CTL))},
			"SYS_VMSPACE_DESTROY":               {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_DESTROY))},
			"SYS_VMSPACE_MCONTROL":              {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_MCONTROL))},
			"SYS_VMSPACE_MMAP":                  {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_MMAP))},
			"SYS_VMSPACE_MUNMAP":                {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_MUNMAP))},
			"SYS_VMSPACE_PREAD":                 {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_PREAD))},
			"SYS_VMSPACE_PWRITE":                {"untyped int", constant.MakeInt64(int64(q.SYS_VMSPACE_PWRITE))},
			"SYS_VQUOTACTL":                     {"untyped int", constant.MakeInt64(int64(q.SYS_VQUOTACTL))},
			"SYS_WAIT4":                         {"untyped int", constant.MakeInt64(int64(q.SYS_WAIT4))},
			"SYS_WAIT6":                         {"untyped int", constant.MakeInt64(int64(q.SYS_WAIT6))},
			"SYS_WRITE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_WRITE))},
			"SYS_WRITEV":                        {"untyped int", constant.MakeInt64(int64(q.SYS_WRITEV))},
			"SYS_YIELD":                         {"untyped int", constant.MakeInt64(int64(q.SYS_YIELD))},
			"SYS___ACL_ACLCHECK_FD":             {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_ACLCHECK_FD))},
			"SYS___ACL_ACLCHECK_FILE":           {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_ACLCHECK_FILE))},
			"SYS___ACL_DELETE_FD":               {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_DELETE_FD))},
			"SYS___ACL_DELETE_FILE":             {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_DELETE_FILE))},
			"SYS___ACL_GET_FD":                  {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_GET_FD))},
			"SYS___ACL_GET_FILE":                {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_GET_FILE))},
			"SYS___ACL_SET_FD":                  {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_SET_FD))},
			"SYS___ACL_SET_FILE":                {"untyped int", constant.MakeInt64(int64(q.SYS___ACL_SET_FILE))},
			"SYS___GETCWD":                      {"untyped int", constant.MakeInt64(int64(q.SYS___GETCWD))},
			"SYS___SEMCTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS___SEMCTL))},
			"SYS___SYSCTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS___SYSCTL))},
			"S_IFBLK":                           {"untyped int", constant.MakeInt64(int64(q.S_IFBLK))},
			"S_IFCHR":                           {"untyped int", constant.MakeInt64(int64(q.S_IFCHR))},
			"S_IFDIR":                           {"untyped int", constant.MakeInt64(int64(q.S_IFDIR))},
			"S_IFIFO":                           {"untyped int", constant.MakeInt64(int64(q.S_IFIFO))},
			"S_IFLNK":                           {"untyped int", constant.MakeInt64(int64(q.S_IFLNK))},
			"S_IFMT":                            {"untyped int", constant.MakeInt64(int64(q.S_IFMT))},
			"S_IFREG":                           {"untyped int", constant.MakeInt64(int64(q.S_IFREG))},
			"S_IFSOCK":                          {"untyped int", constant.MakeInt64(int64(q.S_IFSOCK))},
			"S_IRUSR":                           {"untyped int", constant.MakeInt64(int64(q.S_IRUSR))},
			"S_IRWXG":                           {"untyped int", constant.MakeInt64(int64(q.S_IRWXG))},
			"S_IRWXO":                           {"untyped int", constant.MakeInt64(int64(q.S_IRWXO))},
			"S_ISGID":                           {"untyped int", constant.MakeInt64(int64(q.S_ISGID))},
			"S_ISUID":                           {"untyped int", constant.MakeInt64(int64(q.S_ISUID))},
			"S_ISVTX":                           {"untyped int", constant.MakeInt64(int64(q.S_ISVTX))},
			"S_IWUSR":                           {"untyped int", constant.MakeInt64(int64(q.S_IWUSR))},
			"S_IXUSR":                           {"untyped int", constant.MakeInt64(int64(q.S_IXUSR))},
			"SizeofBpfHdr":                      {"untyped int", constant.MakeInt64(int64(q.SizeofBpfHdr))},
			"SizeofBpfInsn":                     {"untyped int", constant.MakeInt64(int64(q.SizeofBpfInsn))},
			"SizeofBpfProgram":                  {"untyped int", constant.MakeInt64(int64(q.SizeofBpfProgram))},
			"SizeofBpfStat":                     {"untyped int", constant.MakeInt64(int64(q.SizeofBpfStat))},
			"SizeofBpfVersion":                  {"untyped int", constant.MakeInt64(int64(q.SizeofBpfVersion))},
			"SizeofCmsghdr":                     {"untyped int", constant.MakeInt64(int64(q.SizeofCmsghdr))},
			"SizeofICMPv6Filter":                {"untyped int", constant.MakeInt64(int64(q.SizeofICMPv6Filter))},
			"SizeofIPMreq":                      {"untyped int", constant.MakeInt64(int64(q.SizeofIPMreq))},
			"SizeofIPv6MTUInfo":                 {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6MTUInfo))},
			"SizeofIPv6Mreq":                    {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6Mreq))},
			"SizeofIfAnnounceMsghdr":            {"untyped int", constant.MakeInt64(int64(q.SizeofIfAnnounceMsghdr))},
			"SizeofIfData":                      {"untyped int", constant.MakeInt64(int64(q.SizeofIfData))},
			"SizeofIfMsghdr":                    {"untyped int", constant.MakeInt64(int64(q.SizeofIfMsghdr))},
			"SizeofIfaMsghdr":                   {"untyped int", constant.MakeInt64(int64(q.SizeofIfaMsghdr))},
			"SizeofIfmaMsghdr":                  {"untyped int", constant.MakeInt64(int64(q.SizeofIfmaMsghdr))},
			"SizeofInet6Pktinfo":                {"untyped int", constant.MakeInt64(int64(q.SizeofInet6Pktinfo))},
			"SizeofLinger":                      {"untyped int", constant.MakeInt64(int64(q.SizeofLinger))},
			"SizeofMsghdr":                      {"untyped int", constant.MakeInt64(int64(q.SizeofMsghdr))},
			"SizeofRtMetrics":                   {"untyped int", constant.MakeInt64(int64(q.SizeofRtMetrics))},
			"SizeofRtMsghdr":                    {"untyped int", constant.MakeInt64(int64(q.SizeofRtMsghdr))},
			"SizeofSockaddrAny":                 {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrAny))},
			"SizeofSockaddrDatalink":            {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrDatalink))},
			"SizeofSockaddrInet4":               {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet4))},
			"SizeofSockaddrInet6":               {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet6))},
			"SizeofSockaddrUnix":                {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrUnix))},
			"TCIFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.TCIFLUSH))},
			"TCIOFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TCIOFLUSH))},
			"TCOFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.TCOFLUSH))},
			"TCP_FASTKEEP":                      {"untyped int", constant.MakeInt64(int64(q.TCP_FASTKEEP))},
			"TCP_KEEPCNT":                       {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPCNT))},
			"TCP_KEEPIDLE":                      {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPIDLE))},
			"TCP_KEEPINIT":                      {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPINIT))},
			"TCP_KEEPINTVL":                     {"untyped int", constant.MakeInt64(int64(q.TCP_KEEPINTVL))},
			"TCP_MAXBURST":                      {"untyped int", constant.MakeInt64(int64(q.TCP_MAXBURST))},
			"TCP_MAXHLEN":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MAXHLEN))},
			"TCP_MAXOLEN":                       {"untyped int", constant.MakeInt64(int64(q.TCP_MAXOLEN))},
			"TCP_MAXSEG":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MAXSEG))},
			"TCP_MAXWIN":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MAXWIN))},
			"TCP_MAX_WINSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.TCP_MAX_WINSHIFT))},
			"TCP_MINMSS":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MINMSS))},
			"TCP_MIN_WINSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.TCP_MIN_WINSHIFT))},
			"TCP_MSS":                           {"untyped int", constant.MakeInt64(int64(q.TCP_MSS))},
			"TCP_NODELAY":                       {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAY))},
			"TCP_NOOPT":                         {"untyped int", constant.MakeInt64(int64(q.TCP_NOOPT))},
			"TCP_NOPUSH":                        {"untyped int", constant.MakeInt64(int64(q.TCP_NOPUSH))},
			"TCP_SIGNATURE_ENABLE":              {"untyped int", constant.MakeInt64(int64(q.TCP_SIGNATURE_ENABLE))},
			"TCSAFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TCSAFLUSH))},
			"TIOCCBRK":                          {"untyped int", constant.MakeInt64(int64(q.TIOCCBRK))},
			"TIOCCDTR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCCDTR))},
			"TIOCCONS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCCONS))},
			"TIOCDCDTIMESTAMP":                  {"untyped int", constant.MakeInt64(int64(q.TIOCDCDTIMESTAMP))},
			"TIOCDRAIN":                         {"untyped int", constant.MakeInt64(int64(q.TIOCDRAIN))},
			"TIOCEXCL":                          {"untyped int", constant.MakeInt64(int64(q.TIOCEXCL))},
			"TIOCEXT":                           {"untyped int", constant.MakeInt64(int64(q.TIOCEXT))},
			"TIOCFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TIOCFLUSH))},
			"TIOCGDRAINWAIT":                    {"untyped int", constant.MakeInt64(int64(q.TIOCGDRAINWAIT))},
			"TIOCGETA":                          {"untyped int", constant.MakeInt64(int64(q.TIOCGETA))},
			"TIOCGETD":                          {"untyped int", constant.MakeInt64(int64(q.TIOCGETD))},
			"TIOCGPGRP":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGPGRP))},
			"TIOCGSID":                          {"untyped int", constant.MakeInt64(int64(q.TIOCGSID))},
			"TIOCGSIZE":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGSIZE))},
			"TIOCGWINSZ":                        {"untyped int", constant.MakeInt64(int64(q.TIOCGWINSZ))},
			"TIOCISPTMASTER":                    {"untyped int", constant.MakeInt64(int64(q.TIOCISPTMASTER))},
			"TIOCMBIC":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMBIC))},
			"TIOCMBIS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMBIS))},
			"TIOCMGDTRWAIT":                     {"untyped int", constant.MakeInt64(int64(q.TIOCMGDTRWAIT))},
			"TIOCMGET":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMGET))},
			"TIOCMODG":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMODG))},
			"TIOCMODS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMODS))},
			"TIOCMSDTRWAIT":                     {"untyped int", constant.MakeInt64(int64(q.TIOCMSDTRWAIT))},
			"TIOCMSET":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMSET))},
			"TIOCM_CAR":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_CAR))},
			"TIOCM_CD":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_CD))},
			"TIOCM_CTS":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_CTS))},
			"TIOCM_DSR":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_DSR))},
			"TIOCM_DTR":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_DTR))},
			"TIOCM_LE":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_LE))},
			"TIOCM_RI":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_RI))},
			"TIOCM_RNG":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_RNG))},
			"TIOCM_RTS":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_RTS))},
			"TIOCM_SR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_SR))},
			"TIOCM_ST":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_ST))},
			"TIOCNOTTY":                         {"untyped int", constant.MakeInt64(int64(q.TIOCNOTTY))},
			"TIOCNXCL":                          {"untyped int", constant.MakeInt64(int64(q.TIOCNXCL))},
			"TIOCOUTQ":                          {"untyped int", constant.MakeInt64(int64(q.TIOCOUTQ))},
			"TIOCPKT":                           {"untyped int", constant.MakeInt64(int64(q.TIOCPKT))},
			"TIOCPKT_DATA":                      {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DATA))},
			"TIOCPKT_DOSTOP":                    {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DOSTOP))},
			"TIOCPKT_FLUSHREAD":                 {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHREAD))},
			"TIOCPKT_FLUSHWRITE":                {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHWRITE))},
			"TIOCPKT_IOCTL":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_IOCTL))},
			"TIOCPKT_NOSTOP":                    {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_NOSTOP))},
			"TIOCPKT_START":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_START))},
			"TIOCPKT_STOP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_STOP))},
			"TIOCREMOTE":                        {"untyped int", constant.MakeInt64(int64(q.TIOCREMOTE))},
			"TIOCSBRK":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSBRK))},
			"TIOCSCTTY":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSCTTY))},
			"TIOCSDRAINWAIT":                    {"untyped int", constant.MakeInt64(int64(q.TIOCSDRAINWAIT))},
			"TIOCSDTR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSDTR))},
			"TIOCSETA":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSETA))},
			"TIOCSETAF":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSETAF))},
			"TIOCSETAW":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSETAW))},
			"TIOCSETD":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSETD))},
			"TIOCSIG":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSIG))},
			"TIOCSPGRP":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSPGRP))},
			"TIOCSSIZE":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSSIZE))},
			"TIOCSTART":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSTART))},
			"TIOCSTAT":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSTAT))},
			"TIOCSTI":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSTI))},
			"TIOCSTOP":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSTOP))},
			"TIOCSWINSZ":                        {"untyped int", constant.MakeInt64(int64(q.TIOCSWINSZ))},
			"TIOCTIMESTAMP":                     {"untyped int", constant.MakeInt64(int64(q.TIOCTIMESTAMP))},
			"TIOCUCNTL":                         {"untyped int", constant.MakeInt64(int64(q.TIOCUCNTL))},
			"TOSTOP":                            {"untyped int", constant.MakeInt64(int64(q.TOSTOP))},
			"VCHECKPT":                          {"untyped int", constant.MakeInt64(int64(q.VCHECKPT))},
			"VDISCARD":                          {"untyped int", constant.MakeInt64(int64(q.VDISCARD))},
			"VDSUSP":                            {"untyped int", constant.MakeInt64(int64(q.VDSUSP))},
			"VEOF":                              {"untyped int", constant.MakeInt64(int64(q.VEOF))},
			"VEOL":                              {"untyped int", constant.MakeInt64(int64(q.VEOL))},
			"VEOL2":                             {"untyped int", constant.MakeInt64(int64(q.VEOL2))},
			"VERASE":                            {"untyped int", constant.MakeInt64(int64(q.VERASE))},
			"VERASE2":                           {"untyped int", constant.MakeInt64(int64(q.VERASE2))},
			"VINTR":                             {"untyped int", constant.MakeInt64(int64(q.VINTR))},
			"VKILL":                             {"untyped int", constant.MakeInt64(int64(q.VKILL))},
			"VLNEXT":                            {"untyped int", constant.MakeInt64(int64(q.VLNEXT))},
			"VMIN":                              {"untyped int", constant.MakeInt64(int64(q.VMIN))},
			"VQUIT":                             {"untyped int", constant.MakeInt64(int64(q.VQUIT))},
			"VREPRINT":                          {"untyped int", constant.MakeInt64(int64(q.VREPRINT))},
			"VSTART":                            {"untyped int", constant.MakeInt64(int64(q.VSTART))},
			"VSTATUS":                           {"untyped int", constant.MakeInt64(int64(q.VSTATUS))},
			"VSTOP":                             {"untyped int", constant.MakeInt64(int64(q.VSTOP))},
			"VSUSP":                             {"untyped int", constant.MakeInt64(int64(q.VSUSP))},
			"VTIME":                             {"untyped int", constant.MakeInt64(int64(q.VTIME))},
			"VWERASE":                           {"untyped int", constant.MakeInt64(int64(q.VWERASE))},
			"WCONTINUED":                        {"untyped int", constant.MakeInt64(int64(q.WCONTINUED))},
			"WCOREFLAG":                         {"untyped int", constant.MakeInt64(int64(q.WCOREFLAG))},
			"WEXITED":                           {"untyped int", constant.MakeInt64(int64(q.WEXITED))},
			"WLINUXCLONE":                       {"untyped int", constant.MakeInt64(int64(q.WLINUXCLONE))},
			"WNOHANG":                           {"untyped int", constant.MakeInt64(int64(q.WNOHANG))},
			"WNOWAIT":                           {"untyped int", constant.MakeInt64(int64(q.WNOWAIT))},
			"WSTOPPED":                          {"untyped int", constant.MakeInt64(int64(q.WSTOPPED))},
			"WUNTRACED":                         {"untyped int", constant.MakeInt64(int64(q.WUNTRACED))},
		},
	})
}
