// export by github.com/goplus/igop/cmd/qexp

//go:build go1.20
// +build go1.20

package syscall

import (
	q "syscall"

	"go/constant"
	"reflect"

	"github.com/goplus/igop"
)

func init() {
	igop.RegisterPackage(&igop.Package{
		Name: "syscall",
		Path: "syscall",
		Deps: map[string]string{
			"errors":           "errors",
			"internal/abi":     "abi",
			"internal/bytealg": "bytealg",
			"internal/itoa":    "itoa",
			"internal/oserror": "oserror",
			"internal/race":    "race",
			"runtime":          "runtime",
			"sync":             "sync",
			"unsafe":           "unsafe",
		},
		Interfaces: map[string]reflect.Type{
			"Conn":           reflect.TypeOf((*q.Conn)(nil)).Elem(),
			"RawConn":        reflect.TypeOf((*q.RawConn)(nil)).Elem(),
			"RoutingMessage": reflect.TypeOf((*q.RoutingMessage)(nil)).Elem(),
			"Sockaddr":       reflect.TypeOf((*q.Sockaddr)(nil)).Elem(),
		},
		NamedTypes: map[string]reflect.Type{
			"BpfHdr":                   reflect.TypeOf((*q.BpfHdr)(nil)).Elem(),
			"BpfInsn":                  reflect.TypeOf((*q.BpfInsn)(nil)).Elem(),
			"BpfProgram":               reflect.TypeOf((*q.BpfProgram)(nil)).Elem(),
			"BpfStat":                  reflect.TypeOf((*q.BpfStat)(nil)).Elem(),
			"BpfTimeval":               reflect.TypeOf((*q.BpfTimeval)(nil)).Elem(),
			"BpfVersion":               reflect.TypeOf((*q.BpfVersion)(nil)).Elem(),
			"Cmsghdr":                  reflect.TypeOf((*q.Cmsghdr)(nil)).Elem(),
			"Credential":               reflect.TypeOf((*q.Credential)(nil)).Elem(),
			"Dirent":                   reflect.TypeOf((*q.Dirent)(nil)).Elem(),
			"Errno":                    reflect.TypeOf((*q.Errno)(nil)).Elem(),
			"FdSet":                    reflect.TypeOf((*q.FdSet)(nil)).Elem(),
			"Flock_t":                  reflect.TypeOf((*q.Flock_t)(nil)).Elem(),
			"Fsid":                     reflect.TypeOf((*q.Fsid)(nil)).Elem(),
			"ICMPv6Filter":             reflect.TypeOf((*q.ICMPv6Filter)(nil)).Elem(),
			"IPMreq":                   reflect.TypeOf((*q.IPMreq)(nil)).Elem(),
			"IPv6MTUInfo":              reflect.TypeOf((*q.IPv6MTUInfo)(nil)).Elem(),
			"IPv6Mreq":                 reflect.TypeOf((*q.IPv6Mreq)(nil)).Elem(),
			"IfAnnounceMsghdr":         reflect.TypeOf((*q.IfAnnounceMsghdr)(nil)).Elem(),
			"IfData":                   reflect.TypeOf((*q.IfData)(nil)).Elem(),
			"IfMsghdr":                 reflect.TypeOf((*q.IfMsghdr)(nil)).Elem(),
			"IfaMsghdr":                reflect.TypeOf((*q.IfaMsghdr)(nil)).Elem(),
			"Inet6Pktinfo":             reflect.TypeOf((*q.Inet6Pktinfo)(nil)).Elem(),
			"InterfaceAddrMessage":     reflect.TypeOf((*q.InterfaceAddrMessage)(nil)).Elem(),
			"InterfaceAnnounceMessage": reflect.TypeOf((*q.InterfaceAnnounceMessage)(nil)).Elem(),
			"InterfaceMessage":         reflect.TypeOf((*q.InterfaceMessage)(nil)).Elem(),
			"Iovec":                    reflect.TypeOf((*q.Iovec)(nil)).Elem(),
			"Kevent_t":                 reflect.TypeOf((*q.Kevent_t)(nil)).Elem(),
			"Linger":                   reflect.TypeOf((*q.Linger)(nil)).Elem(),
			"Mclpool":                  reflect.TypeOf((*q.Mclpool)(nil)).Elem(),
			"Msghdr":                   reflect.TypeOf((*q.Msghdr)(nil)).Elem(),
			"ProcAttr":                 reflect.TypeOf((*q.ProcAttr)(nil)).Elem(),
			"RawSockaddr":              reflect.TypeOf((*q.RawSockaddr)(nil)).Elem(),
			"RawSockaddrAny":           reflect.TypeOf((*q.RawSockaddrAny)(nil)).Elem(),
			"RawSockaddrDatalink":      reflect.TypeOf((*q.RawSockaddrDatalink)(nil)).Elem(),
			"RawSockaddrInet4":         reflect.TypeOf((*q.RawSockaddrInet4)(nil)).Elem(),
			"RawSockaddrInet6":         reflect.TypeOf((*q.RawSockaddrInet6)(nil)).Elem(),
			"RawSockaddrUnix":          reflect.TypeOf((*q.RawSockaddrUnix)(nil)).Elem(),
			"Rlimit":                   reflect.TypeOf((*q.Rlimit)(nil)).Elem(),
			"RouteMessage":             reflect.TypeOf((*q.RouteMessage)(nil)).Elem(),
			"RtMetrics":                reflect.TypeOf((*q.RtMetrics)(nil)).Elem(),
			"RtMsghdr":                 reflect.TypeOf((*q.RtMsghdr)(nil)).Elem(),
			"Rusage":                   reflect.TypeOf((*q.Rusage)(nil)).Elem(),
			"Signal":                   reflect.TypeOf((*q.Signal)(nil)).Elem(),
			"SockaddrDatalink":         reflect.TypeOf((*q.SockaddrDatalink)(nil)).Elem(),
			"SockaddrInet4":            reflect.TypeOf((*q.SockaddrInet4)(nil)).Elem(),
			"SockaddrInet6":            reflect.TypeOf((*q.SockaddrInet6)(nil)).Elem(),
			"SockaddrUnix":             reflect.TypeOf((*q.SockaddrUnix)(nil)).Elem(),
			"SocketControlMessage":     reflect.TypeOf((*q.SocketControlMessage)(nil)).Elem(),
			"Stat_t":                   reflect.TypeOf((*q.Stat_t)(nil)).Elem(),
			"Statfs_t":                 reflect.TypeOf((*q.Statfs_t)(nil)).Elem(),
			"SysProcAttr":              reflect.TypeOf((*q.SysProcAttr)(nil)).Elem(),
			"Termios":                  reflect.TypeOf((*q.Termios)(nil)).Elem(),
			"Timespec":                 reflect.TypeOf((*q.Timespec)(nil)).Elem(),
			"Timeval":                  reflect.TypeOf((*q.Timeval)(nil)).Elem(),
			"WaitStatus":               reflect.TypeOf((*q.WaitStatus)(nil)).Elem(),
		},
		AliasTypes: map[string]reflect.Type{},
		Vars: map[string]reflect.Value{
			"ForkLock":          reflect.ValueOf(&q.ForkLock),
			"SocketDisableIPv6": reflect.ValueOf(&q.SocketDisableIPv6),
			"Stderr":            reflect.ValueOf(&q.Stderr),
			"Stdin":             reflect.ValueOf(&q.Stdin),
			"Stdout":            reflect.ValueOf(&q.Stdout),
		},
		Funcs: map[string]reflect.Value{
			"Accept":                    reflect.ValueOf(q.Accept),
			"Accept4":                   reflect.ValueOf(q.Accept4),
			"Access":                    reflect.ValueOf(q.Access),
			"Adjtime":                   reflect.ValueOf(q.Adjtime),
			"Bind":                      reflect.ValueOf(q.Bind),
			"BpfBuflen":                 reflect.ValueOf(q.BpfBuflen),
			"BpfDatalink":               reflect.ValueOf(q.BpfDatalink),
			"BpfHeadercmpl":             reflect.ValueOf(q.BpfHeadercmpl),
			"BpfInterface":              reflect.ValueOf(q.BpfInterface),
			"BpfJump":                   reflect.ValueOf(q.BpfJump),
			"BpfStats":                  reflect.ValueOf(q.BpfStats),
			"BpfStmt":                   reflect.ValueOf(q.BpfStmt),
			"BpfTimeout":                reflect.ValueOf(q.BpfTimeout),
			"BytePtrFromString":         reflect.ValueOf(q.BytePtrFromString),
			"ByteSliceFromString":       reflect.ValueOf(q.ByteSliceFromString),
			"Chdir":                     reflect.ValueOf(q.Chdir),
			"CheckBpfVersion":           reflect.ValueOf(q.CheckBpfVersion),
			"Chflags":                   reflect.ValueOf(q.Chflags),
			"Chmod":                     reflect.ValueOf(q.Chmod),
			"Chown":                     reflect.ValueOf(q.Chown),
			"Chroot":                    reflect.ValueOf(q.Chroot),
			"Clearenv":                  reflect.ValueOf(q.Clearenv),
			"Close":                     reflect.ValueOf(q.Close),
			"CloseOnExec":               reflect.ValueOf(q.CloseOnExec),
			"CmsgLen":                   reflect.ValueOf(q.CmsgLen),
			"CmsgSpace":                 reflect.ValueOf(q.CmsgSpace),
			"Connect":                   reflect.ValueOf(q.Connect),
			"Dup":                       reflect.ValueOf(q.Dup),
			"Dup2":                      reflect.ValueOf(q.Dup2),
			"Environ":                   reflect.ValueOf(q.Environ),
			"Exec":                      reflect.ValueOf(q.Exec),
			"Exit":                      reflect.ValueOf(q.Exit),
			"Fchdir":                    reflect.ValueOf(q.Fchdir),
			"Fchflags":                  reflect.ValueOf(q.Fchflags),
			"Fchmod":                    reflect.ValueOf(q.Fchmod),
			"Fchown":                    reflect.ValueOf(q.Fchown),
			"FcntlFlock":                reflect.ValueOf(q.FcntlFlock),
			"Flock":                     reflect.ValueOf(q.Flock),
			"FlushBpf":                  reflect.ValueOf(q.FlushBpf),
			"ForkExec":                  reflect.ValueOf(q.ForkExec),
			"Fpathconf":                 reflect.ValueOf(q.Fpathconf),
			"Fstat":                     reflect.ValueOf(q.Fstat),
			"Fstatfs":                   reflect.ValueOf(q.Fstatfs),
			"Fsync":                     reflect.ValueOf(q.Fsync),
			"Ftruncate":                 reflect.ValueOf(q.Ftruncate),
			"Futimes":                   reflect.ValueOf(q.Futimes),
			"Getdirentries":             reflect.ValueOf(q.Getdirentries),
			"Getegid":                   reflect.ValueOf(q.Getegid),
			"Getenv":                    reflect.ValueOf(q.Getenv),
			"Geteuid":                   reflect.ValueOf(q.Geteuid),
			"Getfsstat":                 reflect.ValueOf(q.Getfsstat),
			"Getgid":                    reflect.ValueOf(q.Getgid),
			"Getgroups":                 reflect.ValueOf(q.Getgroups),
			"Getpagesize":               reflect.ValueOf(q.Getpagesize),
			"Getpeername":               reflect.ValueOf(q.Getpeername),
			"Getpgid":                   reflect.ValueOf(q.Getpgid),
			"Getpgrp":                   reflect.ValueOf(q.Getpgrp),
			"Getpid":                    reflect.ValueOf(q.Getpid),
			"Getppid":                   reflect.ValueOf(q.Getppid),
			"Getpriority":               reflect.ValueOf(q.Getpriority),
			"Getrlimit":                 reflect.ValueOf(q.Getrlimit),
			"Getrusage":                 reflect.ValueOf(q.Getrusage),
			"Getsid":                    reflect.ValueOf(q.Getsid),
			"Getsockname":               reflect.ValueOf(q.Getsockname),
			"GetsockoptByte":            reflect.ValueOf(q.GetsockoptByte),
			"GetsockoptICMPv6Filter":    reflect.ValueOf(q.GetsockoptICMPv6Filter),
			"GetsockoptIPMreq":          reflect.ValueOf(q.GetsockoptIPMreq),
			"GetsockoptIPv6MTUInfo":     reflect.ValueOf(q.GetsockoptIPv6MTUInfo),
			"GetsockoptIPv6Mreq":        reflect.ValueOf(q.GetsockoptIPv6Mreq),
			"GetsockoptInet4Addr":       reflect.ValueOf(q.GetsockoptInet4Addr),
			"GetsockoptInt":             reflect.ValueOf(q.GetsockoptInt),
			"Gettimeofday":              reflect.ValueOf(q.Gettimeofday),
			"Getuid":                    reflect.ValueOf(q.Getuid),
			"Getwd":                     reflect.ValueOf(q.Getwd),
			"Issetugid":                 reflect.ValueOf(q.Issetugid),
			"Kevent":                    reflect.ValueOf(q.Kevent),
			"Kill":                      reflect.ValueOf(q.Kill),
			"Kqueue":                    reflect.ValueOf(q.Kqueue),
			"Lchown":                    reflect.ValueOf(q.Lchown),
			"Link":                      reflect.ValueOf(q.Link),
			"Listen":                    reflect.ValueOf(q.Listen),
			"Lstat":                     reflect.ValueOf(q.Lstat),
			"Mkdir":                     reflect.ValueOf(q.Mkdir),
			"Mkfifo":                    reflect.ValueOf(q.Mkfifo),
			"Mknod":                     reflect.ValueOf(q.Mknod),
			"Mmap":                      reflect.ValueOf(q.Mmap),
			"Munmap":                    reflect.ValueOf(q.Munmap),
			"Nanosleep":                 reflect.ValueOf(q.Nanosleep),
			"NsecToTimespec":            reflect.ValueOf(q.NsecToTimespec),
			"NsecToTimeval":             reflect.ValueOf(q.NsecToTimeval),
			"Open":                      reflect.ValueOf(q.Open),
			"ParseDirent":               reflect.ValueOf(q.ParseDirent),
			"ParseRoutingMessage":       reflect.ValueOf(q.ParseRoutingMessage),
			"ParseRoutingSockaddr":      reflect.ValueOf(q.ParseRoutingSockaddr),
			"ParseSocketControlMessage": reflect.ValueOf(q.ParseSocketControlMessage),
			"ParseUnixRights":           reflect.ValueOf(q.ParseUnixRights),
			"Pathconf":                  reflect.ValueOf(q.Pathconf),
			"Pipe":                      reflect.ValueOf(q.Pipe),
			"Pipe2":                     reflect.ValueOf(q.Pipe2),
			"Pread":                     reflect.ValueOf(q.Pread),
			"Pwrite":                    reflect.ValueOf(q.Pwrite),
			"RawSyscall":                reflect.ValueOf(q.RawSyscall),
			"RawSyscall6":               reflect.ValueOf(q.RawSyscall6),
			"Read":                      reflect.ValueOf(q.Read),
			"ReadDirent":                reflect.ValueOf(q.ReadDirent),
			"Readlink":                  reflect.ValueOf(q.Readlink),
			"Recvfrom":                  reflect.ValueOf(q.Recvfrom),
			"Recvmsg":                   reflect.ValueOf(q.Recvmsg),
			"Rename":                    reflect.ValueOf(q.Rename),
			"Revoke":                    reflect.ValueOf(q.Revoke),
			"Rmdir":                     reflect.ValueOf(q.Rmdir),
			"RouteRIB":                  reflect.ValueOf(q.RouteRIB),
			"Seek":                      reflect.ValueOf(q.Seek),
			"Select":                    reflect.ValueOf(q.Select),
			"Sendfile":                  reflect.ValueOf(q.Sendfile),
			"Sendmsg":                   reflect.ValueOf(q.Sendmsg),
			"SendmsgN":                  reflect.ValueOf(q.SendmsgN),
			"Sendto":                    reflect.ValueOf(q.Sendto),
			"SetBpf":                    reflect.ValueOf(q.SetBpf),
			"SetBpfBuflen":              reflect.ValueOf(q.SetBpfBuflen),
			"SetBpfDatalink":            reflect.ValueOf(q.SetBpfDatalink),
			"SetBpfHeadercmpl":          reflect.ValueOf(q.SetBpfHeadercmpl),
			"SetBpfImmediate":           reflect.ValueOf(q.SetBpfImmediate),
			"SetBpfInterface":           reflect.ValueOf(q.SetBpfInterface),
			"SetBpfPromisc":             reflect.ValueOf(q.SetBpfPromisc),
			"SetBpfTimeout":             reflect.ValueOf(q.SetBpfTimeout),
			"SetKevent":                 reflect.ValueOf(q.SetKevent),
			"SetNonblock":               reflect.ValueOf(q.SetNonblock),
			"Setegid":                   reflect.ValueOf(q.Setegid),
			"Setenv":                    reflect.ValueOf(q.Setenv),
			"Seteuid":                   reflect.ValueOf(q.Seteuid),
			"Setgid":                    reflect.ValueOf(q.Setgid),
			"Setgroups":                 reflect.ValueOf(q.Setgroups),
			"Setlogin":                  reflect.ValueOf(q.Setlogin),
			"Setpgid":                   reflect.ValueOf(q.Setpgid),
			"Setpriority":               reflect.ValueOf(q.Setpriority),
			"Setregid":                  reflect.ValueOf(q.Setregid),
			"Setreuid":                  reflect.ValueOf(q.Setreuid),
			"Setrlimit":                 reflect.ValueOf(q.Setrlimit),
			"Setsid":                    reflect.ValueOf(q.Setsid),
			"SetsockoptByte":            reflect.ValueOf(q.SetsockoptByte),
			"SetsockoptICMPv6Filter":    reflect.ValueOf(q.SetsockoptICMPv6Filter),
			"SetsockoptIPMreq":          reflect.ValueOf(q.SetsockoptIPMreq),
			"SetsockoptIPv6Mreq":        reflect.ValueOf(q.SetsockoptIPv6Mreq),
			"SetsockoptInet4Addr":       reflect.ValueOf(q.SetsockoptInet4Addr),
			"SetsockoptInt":             reflect.ValueOf(q.SetsockoptInt),
			"SetsockoptLinger":          reflect.ValueOf(q.SetsockoptLinger),
			"SetsockoptString":          reflect.ValueOf(q.SetsockoptString),
			"SetsockoptTimeval":         reflect.ValueOf(q.SetsockoptTimeval),
			"Settimeofday":              reflect.ValueOf(q.Settimeofday),
			"Setuid":                    reflect.ValueOf(q.Setuid),
			"Shutdown":                  reflect.ValueOf(q.Shutdown),
			"SlicePtrFromStrings":       reflect.ValueOf(q.SlicePtrFromStrings),
			"Socket":                    reflect.ValueOf(q.Socket),
			"Socketpair":                reflect.ValueOf(q.Socketpair),
			"StartProcess":              reflect.ValueOf(q.StartProcess),
			"Stat":                      reflect.ValueOf(q.Stat),
			"Statfs":                    reflect.ValueOf(q.Statfs),
			"StringBytePtr":             reflect.ValueOf(q.StringBytePtr),
			"StringByteSlice":           reflect.ValueOf(q.StringByteSlice),
			"StringSlicePtr":            reflect.ValueOf(q.StringSlicePtr),
			"Symlink":                   reflect.ValueOf(q.Symlink),
			"Sync":                      reflect.ValueOf(q.Sync),
			"Syscall":                   reflect.ValueOf(q.Syscall),
			"Syscall6":                  reflect.ValueOf(q.Syscall6),
			"Syscall9":                  reflect.ValueOf(q.Syscall9),
			"Sysctl":                    reflect.ValueOf(q.Sysctl),
			"SysctlUint32":              reflect.ValueOf(q.SysctlUint32),
			"TimespecToNsec":            reflect.ValueOf(q.TimespecToNsec),
			"TimevalToNsec":             reflect.ValueOf(q.TimevalToNsec),
			"Truncate":                  reflect.ValueOf(q.Truncate),
			"Umask":                     reflect.ValueOf(q.Umask),
			"UnixRights":                reflect.ValueOf(q.UnixRights),
			"Unlink":                    reflect.ValueOf(q.Unlink),
			"Unmount":                   reflect.ValueOf(q.Unmount),
			"Unsetenv":                  reflect.ValueOf(q.Unsetenv),
			"Utimes":                    reflect.ValueOf(q.Utimes),
			"UtimesNano":                reflect.ValueOf(q.UtimesNano),
			"Wait4":                     reflect.ValueOf(q.Wait4),
			"Write":                     reflect.ValueOf(q.Write),
		},
		TypedConsts: map[string]igop.TypedConst{
			"E2BIG":           {reflect.TypeOf(q.E2BIG), constant.MakeInt64(int64(q.E2BIG))},
			"EACCES":          {reflect.TypeOf(q.EACCES), constant.MakeInt64(int64(q.EACCES))},
			"EADDRINUSE":      {reflect.TypeOf(q.EADDRINUSE), constant.MakeInt64(int64(q.EADDRINUSE))},
			"EADDRNOTAVAIL":   {reflect.TypeOf(q.EADDRNOTAVAIL), constant.MakeInt64(int64(q.EADDRNOTAVAIL))},
			"EAFNOSUPPORT":    {reflect.TypeOf(q.EAFNOSUPPORT), constant.MakeInt64(int64(q.EAFNOSUPPORT))},
			"EAGAIN":          {reflect.TypeOf(q.EAGAIN), constant.MakeInt64(int64(q.EAGAIN))},
			"EALREADY":        {reflect.TypeOf(q.EALREADY), constant.MakeInt64(int64(q.EALREADY))},
			"EAUTH":           {reflect.TypeOf(q.EAUTH), constant.MakeInt64(int64(q.EAUTH))},
			"EBADF":           {reflect.TypeOf(q.EBADF), constant.MakeInt64(int64(q.EBADF))},
			"EBADMSG":         {reflect.TypeOf(q.EBADMSG), constant.MakeInt64(int64(q.EBADMSG))},
			"EBADRPC":         {reflect.TypeOf(q.EBADRPC), constant.MakeInt64(int64(q.EBADRPC))},
			"EBUSY":           {reflect.TypeOf(q.EBUSY), constant.MakeInt64(int64(q.EBUSY))},
			"ECANCELED":       {reflect.TypeOf(q.ECANCELED), constant.MakeInt64(int64(q.ECANCELED))},
			"ECHILD":          {reflect.TypeOf(q.ECHILD), constant.MakeInt64(int64(q.ECHILD))},
			"ECONNABORTED":    {reflect.TypeOf(q.ECONNABORTED), constant.MakeInt64(int64(q.ECONNABORTED))},
			"ECONNREFUSED":    {reflect.TypeOf(q.ECONNREFUSED), constant.MakeInt64(int64(q.ECONNREFUSED))},
			"ECONNRESET":      {reflect.TypeOf(q.ECONNRESET), constant.MakeInt64(int64(q.ECONNRESET))},
			"EDEADLK":         {reflect.TypeOf(q.EDEADLK), constant.MakeInt64(int64(q.EDEADLK))},
			"EDESTADDRREQ":    {reflect.TypeOf(q.EDESTADDRREQ), constant.MakeInt64(int64(q.EDESTADDRREQ))},
			"EDOM":            {reflect.TypeOf(q.EDOM), constant.MakeInt64(int64(q.EDOM))},
			"EDQUOT":          {reflect.TypeOf(q.EDQUOT), constant.MakeInt64(int64(q.EDQUOT))},
			"EEXIST":          {reflect.TypeOf(q.EEXIST), constant.MakeInt64(int64(q.EEXIST))},
			"EFAULT":          {reflect.TypeOf(q.EFAULT), constant.MakeInt64(int64(q.EFAULT))},
			"EFBIG":           {reflect.TypeOf(q.EFBIG), constant.MakeInt64(int64(q.EFBIG))},
			"EFTYPE":          {reflect.TypeOf(q.EFTYPE), constant.MakeInt64(int64(q.EFTYPE))},
			"EHOSTDOWN":       {reflect.TypeOf(q.EHOSTDOWN), constant.MakeInt64(int64(q.EHOSTDOWN))},
			"EHOSTUNREACH":    {reflect.TypeOf(q.EHOSTUNREACH), constant.MakeInt64(int64(q.EHOSTUNREACH))},
			"EIDRM":           {reflect.TypeOf(q.EIDRM), constant.MakeInt64(int64(q.EIDRM))},
			"EILSEQ":          {reflect.TypeOf(q.EILSEQ), constant.MakeInt64(int64(q.EILSEQ))},
			"EINPROGRESS":     {reflect.TypeOf(q.EINPROGRESS), constant.MakeInt64(int64(q.EINPROGRESS))},
			"EINTR":           {reflect.TypeOf(q.EINTR), constant.MakeInt64(int64(q.EINTR))},
			"EINVAL":          {reflect.TypeOf(q.EINVAL), constant.MakeInt64(int64(q.EINVAL))},
			"EIO":             {reflect.TypeOf(q.EIO), constant.MakeInt64(int64(q.EIO))},
			"EIPSEC":          {reflect.TypeOf(q.EIPSEC), constant.MakeInt64(int64(q.EIPSEC))},
			"EISCONN":         {reflect.TypeOf(q.EISCONN), constant.MakeInt64(int64(q.EISCONN))},
			"EISDIR":          {reflect.TypeOf(q.EISDIR), constant.MakeInt64(int64(q.EISDIR))},
			"ELAST":           {reflect.TypeOf(q.ELAST), constant.MakeInt64(int64(q.ELAST))},
			"ELOOP":           {reflect.TypeOf(q.ELOOP), constant.MakeInt64(int64(q.ELOOP))},
			"EMEDIUMTYPE":     {reflect.TypeOf(q.EMEDIUMTYPE), constant.MakeInt64(int64(q.EMEDIUMTYPE))},
			"EMFILE":          {reflect.TypeOf(q.EMFILE), constant.MakeInt64(int64(q.EMFILE))},
			"EMLINK":          {reflect.TypeOf(q.EMLINK), constant.MakeInt64(int64(q.EMLINK))},
			"EMSGSIZE":        {reflect.TypeOf(q.EMSGSIZE), constant.MakeInt64(int64(q.EMSGSIZE))},
			"ENAMETOOLONG":    {reflect.TypeOf(q.ENAMETOOLONG), constant.MakeInt64(int64(q.ENAMETOOLONG))},
			"ENEEDAUTH":       {reflect.TypeOf(q.ENEEDAUTH), constant.MakeInt64(int64(q.ENEEDAUTH))},
			"ENETDOWN":        {reflect.TypeOf(q.ENETDOWN), constant.MakeInt64(int64(q.ENETDOWN))},
			"ENETRESET":       {reflect.TypeOf(q.ENETRESET), constant.MakeInt64(int64(q.ENETRESET))},
			"ENETUNREACH":     {reflect.TypeOf(q.ENETUNREACH), constant.MakeInt64(int64(q.ENETUNREACH))},
			"ENFILE":          {reflect.TypeOf(q.ENFILE), constant.MakeInt64(int64(q.ENFILE))},
			"ENOATTR":         {reflect.TypeOf(q.ENOATTR), constant.MakeInt64(int64(q.ENOATTR))},
			"ENOBUFS":         {reflect.TypeOf(q.ENOBUFS), constant.MakeInt64(int64(q.ENOBUFS))},
			"ENODEV":          {reflect.TypeOf(q.ENODEV), constant.MakeInt64(int64(q.ENODEV))},
			"ENOENT":          {reflect.TypeOf(q.ENOENT), constant.MakeInt64(int64(q.ENOENT))},
			"ENOEXEC":         {reflect.TypeOf(q.ENOEXEC), constant.MakeInt64(int64(q.ENOEXEC))},
			"ENOLCK":          {reflect.TypeOf(q.ENOLCK), constant.MakeInt64(int64(q.ENOLCK))},
			"ENOMEDIUM":       {reflect.TypeOf(q.ENOMEDIUM), constant.MakeInt64(int64(q.ENOMEDIUM))},
			"ENOMEM":          {reflect.TypeOf(q.ENOMEM), constant.MakeInt64(int64(q.ENOMEM))},
			"ENOMSG":          {reflect.TypeOf(q.ENOMSG), constant.MakeInt64(int64(q.ENOMSG))},
			"ENOPROTOOPT":     {reflect.TypeOf(q.ENOPROTOOPT), constant.MakeInt64(int64(q.ENOPROTOOPT))},
			"ENOSPC":          {reflect.TypeOf(q.ENOSPC), constant.MakeInt64(int64(q.ENOSPC))},
			"ENOSYS":          {reflect.TypeOf(q.ENOSYS), constant.MakeInt64(int64(q.ENOSYS))},
			"ENOTBLK":         {reflect.TypeOf(q.ENOTBLK), constant.MakeInt64(int64(q.ENOTBLK))},
			"ENOTCONN":        {reflect.TypeOf(q.ENOTCONN), constant.MakeInt64(int64(q.ENOTCONN))},
			"ENOTDIR":         {reflect.TypeOf(q.ENOTDIR), constant.MakeInt64(int64(q.ENOTDIR))},
			"ENOTEMPTY":       {reflect.TypeOf(q.ENOTEMPTY), constant.MakeInt64(int64(q.ENOTEMPTY))},
			"ENOTRECOVERABLE": {reflect.TypeOf(q.ENOTRECOVERABLE), constant.MakeInt64(int64(q.ENOTRECOVERABLE))},
			"ENOTSOCK":        {reflect.TypeOf(q.ENOTSOCK), constant.MakeInt64(int64(q.ENOTSOCK))},
			"ENOTSUP":         {reflect.TypeOf(q.ENOTSUP), constant.MakeInt64(int64(q.ENOTSUP))},
			"ENOTTY":          {reflect.TypeOf(q.ENOTTY), constant.MakeInt64(int64(q.ENOTTY))},
			"ENXIO":           {reflect.TypeOf(q.ENXIO), constant.MakeInt64(int64(q.ENXIO))},
			"EOPNOTSUPP":      {reflect.TypeOf(q.EOPNOTSUPP), constant.MakeInt64(int64(q.EOPNOTSUPP))},
			"EOVERFLOW":       {reflect.TypeOf(q.EOVERFLOW), constant.MakeInt64(int64(q.EOVERFLOW))},
			"EOWNERDEAD":      {reflect.TypeOf(q.EOWNERDEAD), constant.MakeInt64(int64(q.EOWNERDEAD))},
			"EPERM":           {reflect.TypeOf(q.EPERM), constant.MakeInt64(int64(q.EPERM))},
			"EPFNOSUPPORT":    {reflect.TypeOf(q.EPFNOSUPPORT), constant.MakeInt64(int64(q.EPFNOSUPPORT))},
			"EPIPE":           {reflect.TypeOf(q.EPIPE), constant.MakeInt64(int64(q.EPIPE))},
			"EPROCLIM":        {reflect.TypeOf(q.EPROCLIM), constant.MakeInt64(int64(q.EPROCLIM))},
			"EPROCUNAVAIL":    {reflect.TypeOf(q.EPROCUNAVAIL), constant.MakeInt64(int64(q.EPROCUNAVAIL))},
			"EPROGMISMATCH":   {reflect.TypeOf(q.EPROGMISMATCH), constant.MakeInt64(int64(q.EPROGMISMATCH))},
			"EPROGUNAVAIL":    {reflect.TypeOf(q.EPROGUNAVAIL), constant.MakeInt64(int64(q.EPROGUNAVAIL))},
			"EPROTO":          {reflect.TypeOf(q.EPROTO), constant.MakeInt64(int64(q.EPROTO))},
			"EPROTONOSUPPORT": {reflect.TypeOf(q.EPROTONOSUPPORT), constant.MakeInt64(int64(q.EPROTONOSUPPORT))},
			"EPROTOTYPE":      {reflect.TypeOf(q.EPROTOTYPE), constant.MakeInt64(int64(q.EPROTOTYPE))},
			"ERANGE":          {reflect.TypeOf(q.ERANGE), constant.MakeInt64(int64(q.ERANGE))},
			"EREMOTE":         {reflect.TypeOf(q.EREMOTE), constant.MakeInt64(int64(q.EREMOTE))},
			"EROFS":           {reflect.TypeOf(q.EROFS), constant.MakeInt64(int64(q.EROFS))},
			"ERPCMISMATCH":    {reflect.TypeOf(q.ERPCMISMATCH), constant.MakeInt64(int64(q.ERPCMISMATCH))},
			"ESHUTDOWN":       {reflect.TypeOf(q.ESHUTDOWN), constant.MakeInt64(int64(q.ESHUTDOWN))},
			"ESOCKTNOSUPPORT": {reflect.TypeOf(q.ESOCKTNOSUPPORT), constant.MakeInt64(int64(q.ESOCKTNOSUPPORT))},
			"ESPIPE":          {reflect.TypeOf(q.ESPIPE), constant.MakeInt64(int64(q.ESPIPE))},
			"ESRCH":           {reflect.TypeOf(q.ESRCH), constant.MakeInt64(int64(q.ESRCH))},
			"ESTALE":          {reflect.TypeOf(q.ESTALE), constant.MakeInt64(int64(q.ESTALE))},
			"ETIMEDOUT":       {reflect.TypeOf(q.ETIMEDOUT), constant.MakeInt64(int64(q.ETIMEDOUT))},
			"ETOOMANYREFS":    {reflect.TypeOf(q.ETOOMANYREFS), constant.MakeInt64(int64(q.ETOOMANYREFS))},
			"ETXTBSY":         {reflect.TypeOf(q.ETXTBSY), constant.MakeInt64(int64(q.ETXTBSY))},
			"EUSERS":          {reflect.TypeOf(q.EUSERS), constant.MakeInt64(int64(q.EUSERS))},
			"EWOULDBLOCK":     {reflect.TypeOf(q.EWOULDBLOCK), constant.MakeInt64(int64(q.EWOULDBLOCK))},
			"EXDEV":           {reflect.TypeOf(q.EXDEV), constant.MakeInt64(int64(q.EXDEV))},
			"SIGABRT":         {reflect.TypeOf(q.SIGABRT), constant.MakeInt64(int64(q.SIGABRT))},
			"SIGALRM":         {reflect.TypeOf(q.SIGALRM), constant.MakeInt64(int64(q.SIGALRM))},
			"SIGBUS":          {reflect.TypeOf(q.SIGBUS), constant.MakeInt64(int64(q.SIGBUS))},
			"SIGCHLD":         {reflect.TypeOf(q.SIGCHLD), constant.MakeInt64(int64(q.SIGCHLD))},
			"SIGCONT":         {reflect.TypeOf(q.SIGCONT), constant.MakeInt64(int64(q.SIGCONT))},
			"SIGEMT":          {reflect.TypeOf(q.SIGEMT), constant.MakeInt64(int64(q.SIGEMT))},
			"SIGFPE":          {reflect.TypeOf(q.SIGFPE), constant.MakeInt64(int64(q.SIGFPE))},
			"SIGHUP":          {reflect.TypeOf(q.SIGHUP), constant.MakeInt64(int64(q.SIGHUP))},
			"SIGILL":          {reflect.TypeOf(q.SIGILL), constant.MakeInt64(int64(q.SIGILL))},
			"SIGINFO":         {reflect.TypeOf(q.SIGINFO), constant.MakeInt64(int64(q.SIGINFO))},
			"SIGINT":          {reflect.TypeOf(q.SIGINT), constant.MakeInt64(int64(q.SIGINT))},
			"SIGIO":           {reflect.TypeOf(q.SIGIO), constant.MakeInt64(int64(q.SIGIO))},
			"SIGIOT":          {reflect.TypeOf(q.SIGIOT), constant.MakeInt64(int64(q.SIGIOT))},
			"SIGKILL":         {reflect.TypeOf(q.SIGKILL), constant.MakeInt64(int64(q.SIGKILL))},
			"SIGPIPE":         {reflect.TypeOf(q.SIGPIPE), constant.MakeInt64(int64(q.SIGPIPE))},
			"SIGPROF":         {reflect.TypeOf(q.SIGPROF), constant.MakeInt64(int64(q.SIGPROF))},
			"SIGQUIT":         {reflect.TypeOf(q.SIGQUIT), constant.MakeInt64(int64(q.SIGQUIT))},
			"SIGSEGV":         {reflect.TypeOf(q.SIGSEGV), constant.MakeInt64(int64(q.SIGSEGV))},
			"SIGSTOP":         {reflect.TypeOf(q.SIGSTOP), constant.MakeInt64(int64(q.SIGSTOP))},
			"SIGSYS":          {reflect.TypeOf(q.SIGSYS), constant.MakeInt64(int64(q.SIGSYS))},
			"SIGTERM":         {reflect.TypeOf(q.SIGTERM), constant.MakeInt64(int64(q.SIGTERM))},
			"SIGTHR":          {reflect.TypeOf(q.SIGTHR), constant.MakeInt64(int64(q.SIGTHR))},
			"SIGTRAP":         {reflect.TypeOf(q.SIGTRAP), constant.MakeInt64(int64(q.SIGTRAP))},
			"SIGTSTP":         {reflect.TypeOf(q.SIGTSTP), constant.MakeInt64(int64(q.SIGTSTP))},
			"SIGTTIN":         {reflect.TypeOf(q.SIGTTIN), constant.MakeInt64(int64(q.SIGTTIN))},
			"SIGTTOU":         {reflect.TypeOf(q.SIGTTOU), constant.MakeInt64(int64(q.SIGTTOU))},
			"SIGURG":          {reflect.TypeOf(q.SIGURG), constant.MakeInt64(int64(q.SIGURG))},
			"SIGUSR1":         {reflect.TypeOf(q.SIGUSR1), constant.MakeInt64(int64(q.SIGUSR1))},
			"SIGUSR2":         {reflect.TypeOf(q.SIGUSR2), constant.MakeInt64(int64(q.SIGUSR2))},
			"SIGVTALRM":       {reflect.TypeOf(q.SIGVTALRM), constant.MakeInt64(int64(q.SIGVTALRM))},
			"SIGWINCH":        {reflect.TypeOf(q.SIGWINCH), constant.MakeInt64(int64(q.SIGWINCH))},
			"SIGXCPU":         {reflect.TypeOf(q.SIGXCPU), constant.MakeInt64(int64(q.SIGXCPU))},
			"SIGXFSZ":         {reflect.TypeOf(q.SIGXFSZ), constant.MakeInt64(int64(q.SIGXFSZ))},
		},
		UntypedConsts: map[string]igop.UntypedConst{
			"AF_APPLETALK":                      {"untyped int", constant.MakeInt64(int64(q.AF_APPLETALK))},
			"AF_BLUETOOTH":                      {"untyped int", constant.MakeInt64(int64(q.AF_BLUETOOTH))},
			"AF_CCITT":                          {"untyped int", constant.MakeInt64(int64(q.AF_CCITT))},
			"AF_CHAOS":                          {"untyped int", constant.MakeInt64(int64(q.AF_CHAOS))},
			"AF_CNT":                            {"untyped int", constant.MakeInt64(int64(q.AF_CNT))},
			"AF_COIP":                           {"untyped int", constant.MakeInt64(int64(q.AF_COIP))},
			"AF_DATAKIT":                        {"untyped int", constant.MakeInt64(int64(q.AF_DATAKIT))},
			"AF_DECnet":                         {"untyped int", constant.MakeInt64(int64(q.AF_DECnet))},
			"AF_DLI":                            {"untyped int", constant.MakeInt64(int64(q.AF_DLI))},
			"AF_E164":                           {"untyped int", constant.MakeInt64(int64(q.AF_E164))},
			"AF_ECMA":                           {"untyped int", constant.MakeInt64(int64(q.AF_ECMA))},
			"AF_ENCAP":                          {"untyped int", constant.MakeInt64(int64(q.AF_ENCAP))},
			"AF_HYLINK":                         {"untyped int", constant.MakeInt64(int64(q.AF_HYLINK))},
			"AF_IMPLINK":                        {"untyped int", constant.MakeInt64(int64(q.AF_IMPLINK))},
			"AF_INET":                           {"untyped int", constant.MakeInt64(int64(q.AF_INET))},
			"AF_INET6":                          {"untyped int", constant.MakeInt64(int64(q.AF_INET6))},
			"AF_IPX":                            {"untyped int", constant.MakeInt64(int64(q.AF_IPX))},
			"AF_ISDN":                           {"untyped int", constant.MakeInt64(int64(q.AF_ISDN))},
			"AF_ISO":                            {"untyped int", constant.MakeInt64(int64(q.AF_ISO))},
			"AF_KEY":                            {"untyped int", constant.MakeInt64(int64(q.AF_KEY))},
			"AF_LAT":                            {"untyped int", constant.MakeInt64(int64(q.AF_LAT))},
			"AF_LINK":                           {"untyped int", constant.MakeInt64(int64(q.AF_LINK))},
			"AF_LOCAL":                          {"untyped int", constant.MakeInt64(int64(q.AF_LOCAL))},
			"AF_MAX":                            {"untyped int", constant.MakeInt64(int64(q.AF_MAX))},
			"AF_MPLS":                           {"untyped int", constant.MakeInt64(int64(q.AF_MPLS))},
			"AF_NATM":                           {"untyped int", constant.MakeInt64(int64(q.AF_NATM))},
			"AF_NS":                             {"untyped int", constant.MakeInt64(int64(q.AF_NS))},
			"AF_OSI":                            {"untyped int", constant.MakeInt64(int64(q.AF_OSI))},
			"AF_PUP":                            {"untyped int", constant.MakeInt64(int64(q.AF_PUP))},
			"AF_ROUTE":                          {"untyped int", constant.MakeInt64(int64(q.AF_ROUTE))},
			"AF_SIP":                            {"untyped int", constant.MakeInt64(int64(q.AF_SIP))},
			"AF_SNA":                            {"untyped int", constant.MakeInt64(int64(q.AF_SNA))},
			"AF_UNIX":                           {"untyped int", constant.MakeInt64(int64(q.AF_UNIX))},
			"AF_UNSPEC":                         {"untyped int", constant.MakeInt64(int64(q.AF_UNSPEC))},
			"ARPHRD_ETHER":                      {"untyped int", constant.MakeInt64(int64(q.ARPHRD_ETHER))},
			"ARPHRD_FRELAY":                     {"untyped int", constant.MakeInt64(int64(q.ARPHRD_FRELAY))},
			"ARPHRD_IEEE1394":                   {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE1394))},
			"ARPHRD_IEEE802":                    {"untyped int", constant.MakeInt64(int64(q.ARPHRD_IEEE802))},
			"B0":                                {"untyped int", constant.MakeInt64(int64(q.B0))},
			"B110":                              {"untyped int", constant.MakeInt64(int64(q.B110))},
			"B115200":                           {"untyped int", constant.MakeInt64(int64(q.B115200))},
			"B1200":                             {"untyped int", constant.MakeInt64(int64(q.B1200))},
			"B134":                              {"untyped int", constant.MakeInt64(int64(q.B134))},
			"B14400":                            {"untyped int", constant.MakeInt64(int64(q.B14400))},
			"B150":                              {"untyped int", constant.MakeInt64(int64(q.B150))},
			"B1800":                             {"untyped int", constant.MakeInt64(int64(q.B1800))},
			"B19200":                            {"untyped int", constant.MakeInt64(int64(q.B19200))},
			"B200":                              {"untyped int", constant.MakeInt64(int64(q.B200))},
			"B230400":                           {"untyped int", constant.MakeInt64(int64(q.B230400))},
			"B2400":                             {"untyped int", constant.MakeInt64(int64(q.B2400))},
			"B28800":                            {"untyped int", constant.MakeInt64(int64(q.B28800))},
			"B300":                              {"untyped int", constant.MakeInt64(int64(q.B300))},
			"B38400":                            {"untyped int", constant.MakeInt64(int64(q.B38400))},
			"B4800":                             {"untyped int", constant.MakeInt64(int64(q.B4800))},
			"B50":                               {"untyped int", constant.MakeInt64(int64(q.B50))},
			"B57600":                            {"untyped int", constant.MakeInt64(int64(q.B57600))},
			"B600":                              {"untyped int", constant.MakeInt64(int64(q.B600))},
			"B7200":                             {"untyped int", constant.MakeInt64(int64(q.B7200))},
			"B75":                               {"untyped int", constant.MakeInt64(int64(q.B75))},
			"B76800":                            {"untyped int", constant.MakeInt64(int64(q.B76800))},
			"B9600":                             {"untyped int", constant.MakeInt64(int64(q.B9600))},
			"BIOCFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.BIOCFLUSH))},
			"BIOCGBLEN":                         {"untyped int", constant.MakeInt64(int64(q.BIOCGBLEN))},
			"BIOCGDIRFILT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGDIRFILT))},
			"BIOCGDLT":                          {"untyped int", constant.MakeInt64(int64(q.BIOCGDLT))},
			"BIOCGDLTLIST":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGDLTLIST))},
			"BIOCGETIF":                         {"untyped int", constant.MakeInt64(int64(q.BIOCGETIF))},
			"BIOCGFILDROP":                      {"untyped int", constant.MakeInt64(int64(q.BIOCGFILDROP))},
			"BIOCGHDRCMPLT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCGHDRCMPLT))},
			"BIOCGRSIG":                         {"untyped int", constant.MakeInt64(int64(q.BIOCGRSIG))},
			"BIOCGRTIMEOUT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCGRTIMEOUT))},
			"BIOCGSTATS":                        {"untyped int", constant.MakeInt64(int64(q.BIOCGSTATS))},
			"BIOCIMMEDIATE":                     {"untyped int", constant.MakeInt64(int64(q.BIOCIMMEDIATE))},
			"BIOCLOCK":                          {"untyped int", constant.MakeInt64(int64(q.BIOCLOCK))},
			"BIOCPROMISC":                       {"untyped int", constant.MakeInt64(int64(q.BIOCPROMISC))},
			"BIOCSBLEN":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSBLEN))},
			"BIOCSDIRFILT":                      {"untyped int", constant.MakeInt64(int64(q.BIOCSDIRFILT))},
			"BIOCSDLT":                          {"untyped int", constant.MakeInt64(int64(q.BIOCSDLT))},
			"BIOCSETF":                          {"untyped int", constant.MakeInt64(int64(q.BIOCSETF))},
			"BIOCSETIF":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSETIF))},
			"BIOCSETWF":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSETWF))},
			"BIOCSFILDROP":                      {"untyped int", constant.MakeInt64(int64(q.BIOCSFILDROP))},
			"BIOCSHDRCMPLT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSHDRCMPLT))},
			"BIOCSRSIG":                         {"untyped int", constant.MakeInt64(int64(q.BIOCSRSIG))},
			"BIOCSRTIMEOUT":                     {"untyped int", constant.MakeInt64(int64(q.BIOCSRTIMEOUT))},
			"BIOCVERSION":                       {"untyped int", constant.MakeInt64(int64(q.BIOCVERSION))},
			"BPF_A":                             {"untyped int", constant.MakeInt64(int64(q.BPF_A))},
			"BPF_ABS":                           {"untyped int", constant.MakeInt64(int64(q.BPF_ABS))},
			"BPF_ADD":                           {"untyped int", constant.MakeInt64(int64(q.BPF_ADD))},
			"BPF_ALIGNMENT":                     {"untyped int", constant.MakeInt64(int64(q.BPF_ALIGNMENT))},
			"BPF_ALU":                           {"untyped int", constant.MakeInt64(int64(q.BPF_ALU))},
			"BPF_AND":                           {"untyped int", constant.MakeInt64(int64(q.BPF_AND))},
			"BPF_B":                             {"untyped int", constant.MakeInt64(int64(q.BPF_B))},
			"BPF_DIRECTION_IN":                  {"untyped int", constant.MakeInt64(int64(q.BPF_DIRECTION_IN))},
			"BPF_DIRECTION_OUT":                 {"untyped int", constant.MakeInt64(int64(q.BPF_DIRECTION_OUT))},
			"BPF_DIV":                           {"untyped int", constant.MakeInt64(int64(q.BPF_DIV))},
			"BPF_FILDROP_CAPTURE":               {"untyped int", constant.MakeInt64(int64(q.BPF_FILDROP_CAPTURE))},
			"BPF_FILDROP_DROP":                  {"untyped int", constant.MakeInt64(int64(q.BPF_FILDROP_DROP))},
			"BPF_FILDROP_PASS":                  {"untyped int", constant.MakeInt64(int64(q.BPF_FILDROP_PASS))},
			"BPF_H":                             {"untyped int", constant.MakeInt64(int64(q.BPF_H))},
			"BPF_IMM":                           {"untyped int", constant.MakeInt64(int64(q.BPF_IMM))},
			"BPF_IND":                           {"untyped int", constant.MakeInt64(int64(q.BPF_IND))},
			"BPF_JA":                            {"untyped int", constant.MakeInt64(int64(q.BPF_JA))},
			"BPF_JEQ":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JEQ))},
			"BPF_JGE":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JGE))},
			"BPF_JGT":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JGT))},
			"BPF_JMP":                           {"untyped int", constant.MakeInt64(int64(q.BPF_JMP))},
			"BPF_JSET":                          {"untyped int", constant.MakeInt64(int64(q.BPF_JSET))},
			"BPF_K":                             {"untyped int", constant.MakeInt64(int64(q.BPF_K))},
			"BPF_LD":                            {"untyped int", constant.MakeInt64(int64(q.BPF_LD))},
			"BPF_LDX":                           {"untyped int", constant.MakeInt64(int64(q.BPF_LDX))},
			"BPF_LEN":                           {"untyped int", constant.MakeInt64(int64(q.BPF_LEN))},
			"BPF_LSH":                           {"untyped int", constant.MakeInt64(int64(q.BPF_LSH))},
			"BPF_MAJOR_VERSION":                 {"untyped int", constant.MakeInt64(int64(q.BPF_MAJOR_VERSION))},
			"BPF_MAXBUFSIZE":                    {"untyped int", constant.MakeInt64(int64(q.BPF_MAXBUFSIZE))},
			"BPF_MAXINSNS":                      {"untyped int", constant.MakeInt64(int64(q.BPF_MAXINSNS))},
			"BPF_MEM":                           {"untyped int", constant.MakeInt64(int64(q.BPF_MEM))},
			"BPF_MEMWORDS":                      {"untyped int", constant.MakeInt64(int64(q.BPF_MEMWORDS))},
			"BPF_MINBUFSIZE":                    {"untyped int", constant.MakeInt64(int64(q.BPF_MINBUFSIZE))},
			"BPF_MINOR_VERSION":                 {"untyped int", constant.MakeInt64(int64(q.BPF_MINOR_VERSION))},
			"BPF_MISC":                          {"untyped int", constant.MakeInt64(int64(q.BPF_MISC))},
			"BPF_MSH":                           {"untyped int", constant.MakeInt64(int64(q.BPF_MSH))},
			"BPF_MUL":                           {"untyped int", constant.MakeInt64(int64(q.BPF_MUL))},
			"BPF_NEG":                           {"untyped int", constant.MakeInt64(int64(q.BPF_NEG))},
			"BPF_OR":                            {"untyped int", constant.MakeInt64(int64(q.BPF_OR))},
			"BPF_RELEASE":                       {"untyped int", constant.MakeInt64(int64(q.BPF_RELEASE))},
			"BPF_RET":                           {"untyped int", constant.MakeInt64(int64(q.BPF_RET))},
			"BPF_RSH":                           {"untyped int", constant.MakeInt64(int64(q.BPF_RSH))},
			"BPF_ST":                            {"untyped int", constant.MakeInt64(int64(q.BPF_ST))},
			"BPF_STX":                           {"untyped int", constant.MakeInt64(int64(q.BPF_STX))},
			"BPF_SUB":                           {"untyped int", constant.MakeInt64(int64(q.BPF_SUB))},
			"BPF_TAX":                           {"untyped int", constant.MakeInt64(int64(q.BPF_TAX))},
			"BPF_TXA":                           {"untyped int", constant.MakeInt64(int64(q.BPF_TXA))},
			"BPF_W":                             {"untyped int", constant.MakeInt64(int64(q.BPF_W))},
			"BPF_X":                             {"untyped int", constant.MakeInt64(int64(q.BPF_X))},
			"BRKINT":                            {"untyped int", constant.MakeInt64(int64(q.BRKINT))},
			"CFLUSH":                            {"untyped int", constant.MakeInt64(int64(q.CFLUSH))},
			"CLOCAL":                            {"untyped int", constant.MakeInt64(int64(q.CLOCAL))},
			"CREAD":                             {"untyped int", constant.MakeInt64(int64(q.CREAD))},
			"CS5":                               {"untyped int", constant.MakeInt64(int64(q.CS5))},
			"CS6":                               {"untyped int", constant.MakeInt64(int64(q.CS6))},
			"CS7":                               {"untyped int", constant.MakeInt64(int64(q.CS7))},
			"CS8":                               {"untyped int", constant.MakeInt64(int64(q.CS8))},
			"CSIZE":                             {"untyped int", constant.MakeInt64(int64(q.CSIZE))},
			"CSTART":                            {"untyped int", constant.MakeInt64(int64(q.CSTART))},
			"CSTATUS":                           {"untyped int", constant.MakeInt64(int64(q.CSTATUS))},
			"CSTOP":                             {"untyped int", constant.MakeInt64(int64(q.CSTOP))},
			"CSTOPB":                            {"untyped int", constant.MakeInt64(int64(q.CSTOPB))},
			"CSUSP":                             {"untyped int", constant.MakeInt64(int64(q.CSUSP))},
			"CTL_MAXNAME":                       {"untyped int", constant.MakeInt64(int64(q.CTL_MAXNAME))},
			"CTL_NET":                           {"untyped int", constant.MakeInt64(int64(q.CTL_NET))},
			"DIOCOSFPFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.DIOCOSFPFLUSH))},
			"DLT_ARCNET":                        {"untyped int", constant.MakeInt64(int64(q.DLT_ARCNET))},
			"DLT_ATM_RFC1483":                   {"untyped int", constant.MakeInt64(int64(q.DLT_ATM_RFC1483))},
			"DLT_AX25":                          {"untyped int", constant.MakeInt64(int64(q.DLT_AX25))},
			"DLT_CHAOS":                         {"untyped int", constant.MakeInt64(int64(q.DLT_CHAOS))},
			"DLT_C_HDLC":                        {"untyped int", constant.MakeInt64(int64(q.DLT_C_HDLC))},
			"DLT_EN10MB":                        {"untyped int", constant.MakeInt64(int64(q.DLT_EN10MB))},
			"DLT_EN3MB":                         {"untyped int", constant.MakeInt64(int64(q.DLT_EN3MB))},
			"DLT_ENC":                           {"untyped int", constant.MakeInt64(int64(q.DLT_ENC))},
			"DLT_FDDI":                          {"untyped int", constant.MakeInt64(int64(q.DLT_FDDI))},
			"DLT_IEEE802":                       {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802))},
			"DLT_IEEE802_11":                    {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11))},
			"DLT_IEEE802_11_RADIO":              {"untyped int", constant.MakeInt64(int64(q.DLT_IEEE802_11_RADIO))},
			"DLT_LOOP":                          {"untyped int", constant.MakeInt64(int64(q.DLT_LOOP))},
			"DLT_MPLS":                          {"untyped int", constant.MakeInt64(int64(q.DLT_MPLS))},
			"DLT_NULL":                          {"untyped int", constant.MakeInt64(int64(q.DLT_NULL))},
			"DLT_OPENFLOW":                      {"untyped int", constant.MakeInt64(int64(q.DLT_OPENFLOW))},
			"DLT_PFLOG":                         {"untyped int", constant.MakeInt64(int64(q.DLT_PFLOG))},
			"DLT_PFSYNC":                        {"untyped int", constant.MakeInt64(int64(q.DLT_PFSYNC))},
			"DLT_PPP":                           {"untyped int", constant.MakeInt64(int64(q.DLT_PPP))},
			"DLT_PPP_BSDOS":                     {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_BSDOS))},
			"DLT_PPP_ETHER":                     {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_ETHER))},
			"DLT_PPP_SERIAL":                    {"untyped int", constant.MakeInt64(int64(q.DLT_PPP_SERIAL))},
			"DLT_PRONET":                        {"untyped int", constant.MakeInt64(int64(q.DLT_PRONET))},
			"DLT_RAW":                           {"untyped int", constant.MakeInt64(int64(q.DLT_RAW))},
			"DLT_SLIP":                          {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP))},
			"DLT_SLIP_BSDOS":                    {"untyped int", constant.MakeInt64(int64(q.DLT_SLIP_BSDOS))},
			"DLT_USBPCAP":                       {"untyped int", constant.MakeInt64(int64(q.DLT_USBPCAP))},
			"DLT_USER0":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER0))},
			"DLT_USER1":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER1))},
			"DLT_USER10":                        {"untyped int", constant.MakeInt64(int64(q.DLT_USER10))},
			"DLT_USER11":                        {"untyped int", constant.MakeInt64(int64(q.DLT_USER11))},
			"DLT_USER12":                        {"untyped int", constant.MakeInt64(int64(q.DLT_USER12))},
			"DLT_USER13":                        {"untyped int", constant.MakeInt64(int64(q.DLT_USER13))},
			"DLT_USER14":                        {"untyped int", constant.MakeInt64(int64(q.DLT_USER14))},
			"DLT_USER15":                        {"untyped int", constant.MakeInt64(int64(q.DLT_USER15))},
			"DLT_USER2":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER2))},
			"DLT_USER3":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER3))},
			"DLT_USER4":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER4))},
			"DLT_USER5":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER5))},
			"DLT_USER6":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER6))},
			"DLT_USER7":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER7))},
			"DLT_USER8":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER8))},
			"DLT_USER9":                         {"untyped int", constant.MakeInt64(int64(q.DLT_USER9))},
			"DT_BLK":                            {"untyped int", constant.MakeInt64(int64(q.DT_BLK))},
			"DT_CHR":                            {"untyped int", constant.MakeInt64(int64(q.DT_CHR))},
			"DT_DIR":                            {"untyped int", constant.MakeInt64(int64(q.DT_DIR))},
			"DT_FIFO":                           {"untyped int", constant.MakeInt64(int64(q.DT_FIFO))},
			"DT_LNK":                            {"untyped int", constant.MakeInt64(int64(q.DT_LNK))},
			"DT_REG":                            {"untyped int", constant.MakeInt64(int64(q.DT_REG))},
			"DT_SOCK":                           {"untyped int", constant.MakeInt64(int64(q.DT_SOCK))},
			"DT_UNKNOWN":                        {"untyped int", constant.MakeInt64(int64(q.DT_UNKNOWN))},
			"ECHO":                              {"untyped int", constant.MakeInt64(int64(q.ECHO))},
			"ECHOCTL":                           {"untyped int", constant.MakeInt64(int64(q.ECHOCTL))},
			"ECHOE":                             {"untyped int", constant.MakeInt64(int64(q.ECHOE))},
			"ECHOK":                             {"untyped int", constant.MakeInt64(int64(q.ECHOK))},
			"ECHOKE":                            {"untyped int", constant.MakeInt64(int64(q.ECHOKE))},
			"ECHONL":                            {"untyped int", constant.MakeInt64(int64(q.ECHONL))},
			"ECHOPRT":                           {"untyped int", constant.MakeInt64(int64(q.ECHOPRT))},
			"EMT_TAGOVF":                        {"untyped int", constant.MakeInt64(int64(q.EMT_TAGOVF))},
			"EMUL_ENABLED":                      {"untyped int", constant.MakeInt64(int64(q.EMUL_ENABLED))},
			"EMUL_NATIVE":                       {"untyped int", constant.MakeInt64(int64(q.EMUL_NATIVE))},
			"ENDRUNDISC":                        {"untyped int", constant.MakeInt64(int64(q.ENDRUNDISC))},
			"ETHERMIN":                          {"untyped int", constant.MakeInt64(int64(q.ETHERMIN))},
			"ETHERMTU":                          {"untyped int", constant.MakeInt64(int64(q.ETHERMTU))},
			"ETHERTYPE_8023":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_8023))},
			"ETHERTYPE_AARP":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AARP))},
			"ETHERTYPE_ACCTON":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ACCTON))},
			"ETHERTYPE_AEONIC":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AEONIC))},
			"ETHERTYPE_ALPHA":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ALPHA))},
			"ETHERTYPE_AMBER":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AMBER))},
			"ETHERTYPE_AMOEBA":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AMOEBA))},
			"ETHERTYPE_AOE":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AOE))},
			"ETHERTYPE_APOLLO":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_APOLLO))},
			"ETHERTYPE_APOLLODOMAIN":            {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_APOLLODOMAIN))},
			"ETHERTYPE_APPLETALK":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_APPLETALK))},
			"ETHERTYPE_APPLITEK":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_APPLITEK))},
			"ETHERTYPE_ARGONAUT":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ARGONAUT))},
			"ETHERTYPE_ARP":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ARP))},
			"ETHERTYPE_AT":                      {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AT))},
			"ETHERTYPE_ATALK":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ATALK))},
			"ETHERTYPE_ATOMIC":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ATOMIC))},
			"ETHERTYPE_ATT":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ATT))},
			"ETHERTYPE_ATTSTANFORD":             {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ATTSTANFORD))},
			"ETHERTYPE_AUTOPHON":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AUTOPHON))},
			"ETHERTYPE_AXIS":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_AXIS))},
			"ETHERTYPE_BCLOOP":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_BCLOOP))},
			"ETHERTYPE_BOFL":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_BOFL))},
			"ETHERTYPE_CABLETRON":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_CABLETRON))},
			"ETHERTYPE_CHAOS":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_CHAOS))},
			"ETHERTYPE_COMDESIGN":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_COMDESIGN))},
			"ETHERTYPE_COMPUGRAPHIC":            {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_COMPUGRAPHIC))},
			"ETHERTYPE_COUNTERPOINT":            {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_COUNTERPOINT))},
			"ETHERTYPE_CRONUS":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_CRONUS))},
			"ETHERTYPE_CRONUSVLN":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_CRONUSVLN))},
			"ETHERTYPE_DCA":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DCA))},
			"ETHERTYPE_DDE":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DDE))},
			"ETHERTYPE_DEBNI":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DEBNI))},
			"ETHERTYPE_DECAM":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECAM))},
			"ETHERTYPE_DECCUST":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECCUST))},
			"ETHERTYPE_DECDIAG":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECDIAG))},
			"ETHERTYPE_DECDNS":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECDNS))},
			"ETHERTYPE_DECDTS":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECDTS))},
			"ETHERTYPE_DECEXPER":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECEXPER))},
			"ETHERTYPE_DECLAST":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECLAST))},
			"ETHERTYPE_DECLTM":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECLTM))},
			"ETHERTYPE_DECMUMPS":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECMUMPS))},
			"ETHERTYPE_DECNETBIOS":              {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DECNETBIOS))},
			"ETHERTYPE_DELTACON":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DELTACON))},
			"ETHERTYPE_DIDDLE":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DIDDLE))},
			"ETHERTYPE_DLOG1":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DLOG1))},
			"ETHERTYPE_DLOG2":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DLOG2))},
			"ETHERTYPE_DN":                      {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DN))},
			"ETHERTYPE_DOGFIGHT":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DOGFIGHT))},
			"ETHERTYPE_DSMD":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_DSMD))},
			"ETHERTYPE_ECMA":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ECMA))},
			"ETHERTYPE_ENCRYPT":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ENCRYPT))},
			"ETHERTYPE_ES":                      {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_ES))},
			"ETHERTYPE_EXCELAN":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_EXCELAN))},
			"ETHERTYPE_EXPERDATA":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_EXPERDATA))},
			"ETHERTYPE_FLIP":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_FLIP))},
			"ETHERTYPE_FLOWCONTROL":             {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_FLOWCONTROL))},
			"ETHERTYPE_FRARP":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_FRARP))},
			"ETHERTYPE_GENDYN":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_GENDYN))},
			"ETHERTYPE_HAYES":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_HAYES))},
			"ETHERTYPE_HIPPI_FP":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_HIPPI_FP))},
			"ETHERTYPE_HITACHI":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_HITACHI))},
			"ETHERTYPE_HP":                      {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_HP))},
			"ETHERTYPE_IEEEPUP":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IEEEPUP))},
			"ETHERTYPE_IEEEPUPAT":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IEEEPUPAT))},
			"ETHERTYPE_IMLBL":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IMLBL))},
			"ETHERTYPE_IMLBLDIAG":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IMLBLDIAG))},
			"ETHERTYPE_IP":                      {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IP))},
			"ETHERTYPE_IPAS":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IPAS))},
			"ETHERTYPE_IPV6":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IPV6))},
			"ETHERTYPE_IPX":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IPX))},
			"ETHERTYPE_IPXNEW":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_IPXNEW))},
			"ETHERTYPE_KALPANA":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_KALPANA))},
			"ETHERTYPE_LANBRIDGE":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LANBRIDGE))},
			"ETHERTYPE_LANPROBE":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LANPROBE))},
			"ETHERTYPE_LAT":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LAT))},
			"ETHERTYPE_LBACK":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LBACK))},
			"ETHERTYPE_LITTLE":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LITTLE))},
			"ETHERTYPE_LLDP":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LLDP))},
			"ETHERTYPE_LOGICRAFT":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LOGICRAFT))},
			"ETHERTYPE_LOOPBACK":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_LOOPBACK))},
			"ETHERTYPE_MATRA":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MATRA))},
			"ETHERTYPE_MAX":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MAX))},
			"ETHERTYPE_MERIT":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MERIT))},
			"ETHERTYPE_MICP":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MICP))},
			"ETHERTYPE_MOPDL":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MOPDL))},
			"ETHERTYPE_MOPRC":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MOPRC))},
			"ETHERTYPE_MOTOROLA":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MOTOROLA))},
			"ETHERTYPE_MPLS":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MPLS))},
			"ETHERTYPE_MPLS_MCAST":              {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MPLS_MCAST))},
			"ETHERTYPE_MUMPS":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_MUMPS))},
			"ETHERTYPE_NBPCC":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPCC))},
			"ETHERTYPE_NBPCLAIM":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPCLAIM))},
			"ETHERTYPE_NBPCLREQ":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPCLREQ))},
			"ETHERTYPE_NBPCLRSP":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPCLRSP))},
			"ETHERTYPE_NBPCREQ":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPCREQ))},
			"ETHERTYPE_NBPCRSP":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPCRSP))},
			"ETHERTYPE_NBPDG":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPDG))},
			"ETHERTYPE_NBPDGB":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPDGB))},
			"ETHERTYPE_NBPDLTE":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPDLTE))},
			"ETHERTYPE_NBPRAR":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPRAR))},
			"ETHERTYPE_NBPRAS":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPRAS))},
			"ETHERTYPE_NBPRST":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPRST))},
			"ETHERTYPE_NBPSCD":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPSCD))},
			"ETHERTYPE_NBPVCD":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBPVCD))},
			"ETHERTYPE_NBS":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NBS))},
			"ETHERTYPE_NCD":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NCD))},
			"ETHERTYPE_NESTAR":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NESTAR))},
			"ETHERTYPE_NETBEUI":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NETBEUI))},
			"ETHERTYPE_NOVELL":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NOVELL))},
			"ETHERTYPE_NS":                      {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NS))},
			"ETHERTYPE_NSAT":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NSAT))},
			"ETHERTYPE_NSCOMPAT":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NSCOMPAT))},
			"ETHERTYPE_NTRAILER":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_NTRAILER))},
			"ETHERTYPE_OS9":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_OS9))},
			"ETHERTYPE_OS9NET":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_OS9NET))},
			"ETHERTYPE_PACER":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PACER))},
			"ETHERTYPE_PAE":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PAE))},
			"ETHERTYPE_PBB":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PBB))},
			"ETHERTYPE_PCS":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PCS))},
			"ETHERTYPE_PLANNING":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PLANNING))},
			"ETHERTYPE_PPP":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PPP))},
			"ETHERTYPE_PPPOE":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PPPOE))},
			"ETHERTYPE_PPPOEDISC":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PPPOEDISC))},
			"ETHERTYPE_PRIMENTS":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PRIMENTS))},
			"ETHERTYPE_PUP":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PUP))},
			"ETHERTYPE_PUPAT":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_PUPAT))},
			"ETHERTYPE_QINQ":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_QINQ))},
			"ETHERTYPE_RACAL":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_RACAL))},
			"ETHERTYPE_RATIONAL":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_RATIONAL))},
			"ETHERTYPE_RAWFR":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_RAWFR))},
			"ETHERTYPE_RCL":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_RCL))},
			"ETHERTYPE_RDP":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_RDP))},
			"ETHERTYPE_RETIX":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_RETIX))},
			"ETHERTYPE_REVARP":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_REVARP))},
			"ETHERTYPE_SCA":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SCA))},
			"ETHERTYPE_SECTRA":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SECTRA))},
			"ETHERTYPE_SECUREDATA":              {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SECUREDATA))},
			"ETHERTYPE_SGITW":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SGITW))},
			"ETHERTYPE_SG_BOUNCE":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SG_BOUNCE))},
			"ETHERTYPE_SG_DIAG":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SG_DIAG))},
			"ETHERTYPE_SG_NETGAMES":             {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SG_NETGAMES))},
			"ETHERTYPE_SG_RESV":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SG_RESV))},
			"ETHERTYPE_SIMNET":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SIMNET))},
			"ETHERTYPE_SLOW":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SLOW))},
			"ETHERTYPE_SNA":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SNA))},
			"ETHERTYPE_SNMP":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SNMP))},
			"ETHERTYPE_SONIX":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SONIX))},
			"ETHERTYPE_SPIDER":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SPIDER))},
			"ETHERTYPE_SPRITE":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_SPRITE))},
			"ETHERTYPE_STP":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_STP))},
			"ETHERTYPE_TALARIS":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TALARIS))},
			"ETHERTYPE_TALARISMC":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TALARISMC))},
			"ETHERTYPE_TCPCOMP":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TCPCOMP))},
			"ETHERTYPE_TCPSM":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TCPSM))},
			"ETHERTYPE_TEC":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TEC))},
			"ETHERTYPE_TIGAN":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TIGAN))},
			"ETHERTYPE_TRAIL":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TRAIL))},
			"ETHERTYPE_TRANSETHER":              {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TRANSETHER))},
			"ETHERTYPE_TYMSHARE":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_TYMSHARE))},
			"ETHERTYPE_UBBST":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_UBBST))},
			"ETHERTYPE_UBDEBUG":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_UBDEBUG))},
			"ETHERTYPE_UBDIAGLOOP":              {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_UBDIAGLOOP))},
			"ETHERTYPE_UBDL":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_UBDL))},
			"ETHERTYPE_UBNIU":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_UBNIU))},
			"ETHERTYPE_UBNMC":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_UBNMC))},
			"ETHERTYPE_VALID":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VALID))},
			"ETHERTYPE_VARIAN":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VARIAN))},
			"ETHERTYPE_VAXELN":                  {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VAXELN))},
			"ETHERTYPE_VEECO":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VEECO))},
			"ETHERTYPE_VEXP":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VEXP))},
			"ETHERTYPE_VGLAB":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VGLAB))},
			"ETHERTYPE_VINES":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VINES))},
			"ETHERTYPE_VINESECHO":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VINESECHO))},
			"ETHERTYPE_VINESLOOP":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VINESLOOP))},
			"ETHERTYPE_VITAL":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VITAL))},
			"ETHERTYPE_VLAN":                    {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VLAN))},
			"ETHERTYPE_VLTLMAN":                 {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VLTLMAN))},
			"ETHERTYPE_VPROD":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VPROD))},
			"ETHERTYPE_VURESERVED":              {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_VURESERVED))},
			"ETHERTYPE_WATERLOO":                {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_WATERLOO))},
			"ETHERTYPE_WELLFLEET":               {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_WELLFLEET))},
			"ETHERTYPE_X25":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_X25))},
			"ETHERTYPE_X75":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_X75))},
			"ETHERTYPE_XNSSM":                   {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_XNSSM))},
			"ETHERTYPE_XTP":                     {"untyped int", constant.MakeInt64(int64(q.ETHERTYPE_XTP))},
			"ETHER_ADDR_LEN":                    {"untyped int", constant.MakeInt64(int64(q.ETHER_ADDR_LEN))},
			"ETHER_ALIGN":                       {"untyped int", constant.MakeInt64(int64(q.ETHER_ALIGN))},
			"ETHER_CRC_LEN":                     {"untyped int", constant.MakeInt64(int64(q.ETHER_CRC_LEN))},
			"ETHER_CRC_POLY_BE":                 {"untyped int", constant.MakeInt64(int64(q.ETHER_CRC_POLY_BE))},
			"ETHER_CRC_POLY_LE":                 {"untyped int", constant.MakeInt64(int64(q.ETHER_CRC_POLY_LE))},
			"ETHER_HDR_LEN":                     {"untyped int", constant.MakeInt64(int64(q.ETHER_HDR_LEN))},
			"ETHER_MAX_DIX_LEN":                 {"untyped int", constant.MakeInt64(int64(q.ETHER_MAX_DIX_LEN))},
			"ETHER_MAX_HARDMTU_LEN":             {"untyped int", constant.MakeInt64(int64(q.ETHER_MAX_HARDMTU_LEN))},
			"ETHER_MAX_LEN":                     {"untyped int", constant.MakeInt64(int64(q.ETHER_MAX_LEN))},
			"ETHER_MIN_LEN":                     {"untyped int", constant.MakeInt64(int64(q.ETHER_MIN_LEN))},
			"ETHER_TYPE_LEN":                    {"untyped int", constant.MakeInt64(int64(q.ETHER_TYPE_LEN))},
			"ETHER_VLAN_ENCAP_LEN":              {"untyped int", constant.MakeInt64(int64(q.ETHER_VLAN_ENCAP_LEN))},
			"EVFILT_AIO":                        {"untyped int", constant.MakeInt64(int64(q.EVFILT_AIO))},
			"EVFILT_DEVICE":                     {"untyped int", constant.MakeInt64(int64(q.EVFILT_DEVICE))},
			"EVFILT_PROC":                       {"untyped int", constant.MakeInt64(int64(q.EVFILT_PROC))},
			"EVFILT_READ":                       {"untyped int", constant.MakeInt64(int64(q.EVFILT_READ))},
			"EVFILT_SIGNAL":                     {"untyped int", constant.MakeInt64(int64(q.EVFILT_SIGNAL))},
			"EVFILT_SYSCOUNT":                   {"untyped int", constant.MakeInt64(int64(q.EVFILT_SYSCOUNT))},
			"EVFILT_TIMER":                      {"untyped int", constant.MakeInt64(int64(q.EVFILT_TIMER))},
			"EVFILT_VNODE":                      {"untyped int", constant.MakeInt64(int64(q.EVFILT_VNODE))},
			"EVFILT_WRITE":                      {"untyped int", constant.MakeInt64(int64(q.EVFILT_WRITE))},
			"EVL_ENCAPLEN":                      {"untyped int", constant.MakeInt64(int64(q.EVL_ENCAPLEN))},
			"EVL_PRIO_BITS":                     {"untyped int", constant.MakeInt64(int64(q.EVL_PRIO_BITS))},
			"EVL_PRIO_MAX":                      {"untyped int", constant.MakeInt64(int64(q.EVL_PRIO_MAX))},
			"EVL_VLID_MASK":                     {"untyped int", constant.MakeInt64(int64(q.EVL_VLID_MASK))},
			"EVL_VLID_MAX":                      {"untyped int", constant.MakeInt64(int64(q.EVL_VLID_MAX))},
			"EVL_VLID_MIN":                      {"untyped int", constant.MakeInt64(int64(q.EVL_VLID_MIN))},
			"EVL_VLID_NULL":                     {"untyped int", constant.MakeInt64(int64(q.EVL_VLID_NULL))},
			"EV_ADD":                            {"untyped int", constant.MakeInt64(int64(q.EV_ADD))},
			"EV_CLEAR":                          {"untyped int", constant.MakeInt64(int64(q.EV_CLEAR))},
			"EV_DELETE":                         {"untyped int", constant.MakeInt64(int64(q.EV_DELETE))},
			"EV_DISABLE":                        {"untyped int", constant.MakeInt64(int64(q.EV_DISABLE))},
			"EV_DISPATCH":                       {"untyped int", constant.MakeInt64(int64(q.EV_DISPATCH))},
			"EV_ENABLE":                         {"untyped int", constant.MakeInt64(int64(q.EV_ENABLE))},
			"EV_EOF":                            {"untyped int", constant.MakeInt64(int64(q.EV_EOF))},
			"EV_ERROR":                          {"untyped int", constant.MakeInt64(int64(q.EV_ERROR))},
			"EV_FLAG1":                          {"untyped int", constant.MakeInt64(int64(q.EV_FLAG1))},
			"EV_ONESHOT":                        {"untyped int", constant.MakeInt64(int64(q.EV_ONESHOT))},
			"EV_RECEIPT":                        {"untyped int", constant.MakeInt64(int64(q.EV_RECEIPT))},
			"EV_SYSFLAGS":                       {"untyped int", constant.MakeInt64(int64(q.EV_SYSFLAGS))},
			"EXTA":                              {"untyped int", constant.MakeInt64(int64(q.EXTA))},
			"EXTB":                              {"untyped int", constant.MakeInt64(int64(q.EXTB))},
			"EXTPROC":                           {"untyped int", constant.MakeInt64(int64(q.EXTPROC))},
			"FD_CLOEXEC":                        {"untyped int", constant.MakeInt64(int64(q.FD_CLOEXEC))},
			"FD_SETSIZE":                        {"untyped int", constant.MakeInt64(int64(q.FD_SETSIZE))},
			"FLUSHO":                            {"untyped int", constant.MakeInt64(int64(q.FLUSHO))},
			"F_DUPFD":                           {"untyped int", constant.MakeInt64(int64(q.F_DUPFD))},
			"F_DUPFD_CLOEXEC":                   {"untyped int", constant.MakeInt64(int64(q.F_DUPFD_CLOEXEC))},
			"F_GETFD":                           {"untyped int", constant.MakeInt64(int64(q.F_GETFD))},
			"F_GETFL":                           {"untyped int", constant.MakeInt64(int64(q.F_GETFL))},
			"F_GETLK":                           {"untyped int", constant.MakeInt64(int64(q.F_GETLK))},
			"F_GETOWN":                          {"untyped int", constant.MakeInt64(int64(q.F_GETOWN))},
			"F_ISATTY":                          {"untyped int", constant.MakeInt64(int64(q.F_ISATTY))},
			"F_RDLCK":                           {"untyped int", constant.MakeInt64(int64(q.F_RDLCK))},
			"F_SETFD":                           {"untyped int", constant.MakeInt64(int64(q.F_SETFD))},
			"F_SETFL":                           {"untyped int", constant.MakeInt64(int64(q.F_SETFL))},
			"F_SETLK":                           {"untyped int", constant.MakeInt64(int64(q.F_SETLK))},
			"F_SETLKW":                          {"untyped int", constant.MakeInt64(int64(q.F_SETLKW))},
			"F_SETOWN":                          {"untyped int", constant.MakeInt64(int64(q.F_SETOWN))},
			"F_UNLCK":                           {"untyped int", constant.MakeInt64(int64(q.F_UNLCK))},
			"F_WRLCK":                           {"untyped int", constant.MakeInt64(int64(q.F_WRLCK))},
			"HUPCL":                             {"untyped int", constant.MakeInt64(int64(q.HUPCL))},
			"ICANON":                            {"untyped int", constant.MakeInt64(int64(q.ICANON))},
			"ICMP6_FILTER":                      {"untyped int", constant.MakeInt64(int64(q.ICMP6_FILTER))},
			"ICRNL":                             {"untyped int", constant.MakeInt64(int64(q.ICRNL))},
			"IEXTEN":                            {"untyped int", constant.MakeInt64(int64(q.IEXTEN))},
			"IFAN_ARRIVAL":                      {"untyped int", constant.MakeInt64(int64(q.IFAN_ARRIVAL))},
			"IFAN_DEPARTURE":                    {"untyped int", constant.MakeInt64(int64(q.IFAN_DEPARTURE))},
			"IFF_ALLMULTI":                      {"untyped int", constant.MakeInt64(int64(q.IFF_ALLMULTI))},
			"IFF_BROADCAST":                     {"untyped int", constant.MakeInt64(int64(q.IFF_BROADCAST))},
			"IFF_CANTCHANGE":                    {"untyped int", constant.MakeInt64(int64(q.IFF_CANTCHANGE))},
			"IFF_DEBUG":                         {"untyped int", constant.MakeInt64(int64(q.IFF_DEBUG))},
			"IFF_LINK0":                         {"untyped int", constant.MakeInt64(int64(q.IFF_LINK0))},
			"IFF_LINK1":                         {"untyped int", constant.MakeInt64(int64(q.IFF_LINK1))},
			"IFF_LINK2":                         {"untyped int", constant.MakeInt64(int64(q.IFF_LINK2))},
			"IFF_LOOPBACK":                      {"untyped int", constant.MakeInt64(int64(q.IFF_LOOPBACK))},
			"IFF_MULTICAST":                     {"untyped int", constant.MakeInt64(int64(q.IFF_MULTICAST))},
			"IFF_NOARP":                         {"untyped int", constant.MakeInt64(int64(q.IFF_NOARP))},
			"IFF_OACTIVE":                       {"untyped int", constant.MakeInt64(int64(q.IFF_OACTIVE))},
			"IFF_POINTOPOINT":                   {"untyped int", constant.MakeInt64(int64(q.IFF_POINTOPOINT))},
			"IFF_PROMISC":                       {"untyped int", constant.MakeInt64(int64(q.IFF_PROMISC))},
			"IFF_RUNNING":                       {"untyped int", constant.MakeInt64(int64(q.IFF_RUNNING))},
			"IFF_SIMPLEX":                       {"untyped int", constant.MakeInt64(int64(q.IFF_SIMPLEX))},
			"IFF_STATICARP":                     {"untyped int", constant.MakeInt64(int64(q.IFF_STATICARP))},
			"IFF_UP":                            {"untyped int", constant.MakeInt64(int64(q.IFF_UP))},
			"IFNAMSIZ":                          {"untyped int", constant.MakeInt64(int64(q.IFNAMSIZ))},
			"IFT_1822":                          {"untyped int", constant.MakeInt64(int64(q.IFT_1822))},
			"IFT_A12MPPSWITCH":                  {"untyped int", constant.MakeInt64(int64(q.IFT_A12MPPSWITCH))},
			"IFT_AAL2":                          {"untyped int", constant.MakeInt64(int64(q.IFT_AAL2))},
			"IFT_AAL5":                          {"untyped int", constant.MakeInt64(int64(q.IFT_AAL5))},
			"IFT_ADSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ADSL))},
			"IFT_AFLANE8023":                    {"untyped int", constant.MakeInt64(int64(q.IFT_AFLANE8023))},
			"IFT_AFLANE8025":                    {"untyped int", constant.MakeInt64(int64(q.IFT_AFLANE8025))},
			"IFT_ARAP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ARAP))},
			"IFT_ARCNET":                        {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNET))},
			"IFT_ARCNETPLUS":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ARCNETPLUS))},
			"IFT_ASYNC":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ASYNC))},
			"IFT_ATM":                           {"untyped int", constant.MakeInt64(int64(q.IFT_ATM))},
			"IFT_ATMDXI":                        {"untyped int", constant.MakeInt64(int64(q.IFT_ATMDXI))},
			"IFT_ATMFUNI":                       {"untyped int", constant.MakeInt64(int64(q.IFT_ATMFUNI))},
			"IFT_ATMIMA":                        {"untyped int", constant.MakeInt64(int64(q.IFT_ATMIMA))},
			"IFT_ATMLOGICAL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ATMLOGICAL))},
			"IFT_ATMRADIO":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ATMRADIO))},
			"IFT_ATMSUBINTERFACE":               {"untyped int", constant.MakeInt64(int64(q.IFT_ATMSUBINTERFACE))},
			"IFT_ATMVCIENDPT":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ATMVCIENDPT))},
			"IFT_ATMVIRTUAL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_ATMVIRTUAL))},
			"IFT_BGPPOLICYACCOUNTING":           {"untyped int", constant.MakeInt64(int64(q.IFT_BGPPOLICYACCOUNTING))},
			"IFT_BLUETOOTH":                     {"untyped int", constant.MakeInt64(int64(q.IFT_BLUETOOTH))},
			"IFT_BRIDGE":                        {"untyped int", constant.MakeInt64(int64(q.IFT_BRIDGE))},
			"IFT_BSC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_BSC))},
			"IFT_CARP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_CARP))},
			"IFT_CCTEMUL":                       {"untyped int", constant.MakeInt64(int64(q.IFT_CCTEMUL))},
			"IFT_CEPT":                          {"untyped int", constant.MakeInt64(int64(q.IFT_CEPT))},
			"IFT_CES":                           {"untyped int", constant.MakeInt64(int64(q.IFT_CES))},
			"IFT_CHANNEL":                       {"untyped int", constant.MakeInt64(int64(q.IFT_CHANNEL))},
			"IFT_CNR":                           {"untyped int", constant.MakeInt64(int64(q.IFT_CNR))},
			"IFT_COFFEE":                        {"untyped int", constant.MakeInt64(int64(q.IFT_COFFEE))},
			"IFT_COMPOSITELINK":                 {"untyped int", constant.MakeInt64(int64(q.IFT_COMPOSITELINK))},
			"IFT_DCN":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DCN))},
			"IFT_DIGITALPOWERLINE":              {"untyped int", constant.MakeInt64(int64(q.IFT_DIGITALPOWERLINE))},
			"IFT_DIGITALWRAPPEROVERHEADCHANNEL": {"untyped int", constant.MakeInt64(int64(q.IFT_DIGITALWRAPPEROVERHEADCHANNEL))},
			"IFT_DLSW":                          {"untyped int", constant.MakeInt64(int64(q.IFT_DLSW))},
			"IFT_DOCSCABLEDOWNSTREAM":           {"untyped int", constant.MakeInt64(int64(q.IFT_DOCSCABLEDOWNSTREAM))},
			"IFT_DOCSCABLEMACLAYER":             {"untyped int", constant.MakeInt64(int64(q.IFT_DOCSCABLEMACLAYER))},
			"IFT_DOCSCABLEUPSTREAM":             {"untyped int", constant.MakeInt64(int64(q.IFT_DOCSCABLEUPSTREAM))},
			"IFT_DOCSCABLEUPSTREAMCHANNEL":      {"untyped int", constant.MakeInt64(int64(q.IFT_DOCSCABLEUPSTREAMCHANNEL))},
			"IFT_DS0":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DS0))},
			"IFT_DS0BUNDLE":                     {"untyped int", constant.MakeInt64(int64(q.IFT_DS0BUNDLE))},
			"IFT_DS1FDL":                        {"untyped int", constant.MakeInt64(int64(q.IFT_DS1FDL))},
			"IFT_DS3":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DS3))},
			"IFT_DTM":                           {"untyped int", constant.MakeInt64(int64(q.IFT_DTM))},
			"IFT_DUMMY":                         {"untyped int", constant.MakeInt64(int64(q.IFT_DUMMY))},
			"IFT_DVBASILN":                      {"untyped int", constant.MakeInt64(int64(q.IFT_DVBASILN))},
			"IFT_DVBASIOUT":                     {"untyped int", constant.MakeInt64(int64(q.IFT_DVBASIOUT))},
			"IFT_DVBRCCDOWNSTREAM":              {"untyped int", constant.MakeInt64(int64(q.IFT_DVBRCCDOWNSTREAM))},
			"IFT_DVBRCCMACLAYER":                {"untyped int", constant.MakeInt64(int64(q.IFT_DVBRCCMACLAYER))},
			"IFT_DVBRCCUPSTREAM":                {"untyped int", constant.MakeInt64(int64(q.IFT_DVBRCCUPSTREAM))},
			"IFT_ECONET":                        {"untyped int", constant.MakeInt64(int64(q.IFT_ECONET))},
			"IFT_ENC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_ENC))},
			"IFT_EON":                           {"untyped int", constant.MakeInt64(int64(q.IFT_EON))},
			"IFT_EPLRS":                         {"untyped int", constant.MakeInt64(int64(q.IFT_EPLRS))},
			"IFT_ESCON":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ESCON))},
			"IFT_ETHER":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ETHER))},
			"IFT_FAITH":                         {"untyped int", constant.MakeInt64(int64(q.IFT_FAITH))},
			"IFT_FAST":                          {"untyped int", constant.MakeInt64(int64(q.IFT_FAST))},
			"IFT_FASTETHER":                     {"untyped int", constant.MakeInt64(int64(q.IFT_FASTETHER))},
			"IFT_FASTETHERFX":                   {"untyped int", constant.MakeInt64(int64(q.IFT_FASTETHERFX))},
			"IFT_FDDI":                          {"untyped int", constant.MakeInt64(int64(q.IFT_FDDI))},
			"IFT_FIBRECHANNEL":                  {"untyped int", constant.MakeInt64(int64(q.IFT_FIBRECHANNEL))},
			"IFT_FRAMERELAYINTERCONNECT":        {"untyped int", constant.MakeInt64(int64(q.IFT_FRAMERELAYINTERCONNECT))},
			"IFT_FRAMERELAYMPI":                 {"untyped int", constant.MakeInt64(int64(q.IFT_FRAMERELAYMPI))},
			"IFT_FRDLCIENDPT":                   {"untyped int", constant.MakeInt64(int64(q.IFT_FRDLCIENDPT))},
			"IFT_FRELAY":                        {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAY))},
			"IFT_FRELAYDCE":                     {"untyped int", constant.MakeInt64(int64(q.IFT_FRELAYDCE))},
			"IFT_FRF16MFRBUNDLE":                {"untyped int", constant.MakeInt64(int64(q.IFT_FRF16MFRBUNDLE))},
			"IFT_FRFORWARD":                     {"untyped int", constant.MakeInt64(int64(q.IFT_FRFORWARD))},
			"IFT_G703AT2MB":                     {"untyped int", constant.MakeInt64(int64(q.IFT_G703AT2MB))},
			"IFT_G703AT64K":                     {"untyped int", constant.MakeInt64(int64(q.IFT_G703AT64K))},
			"IFT_GIF":                           {"untyped int", constant.MakeInt64(int64(q.IFT_GIF))},
			"IFT_GIGABITETHERNET":               {"untyped int", constant.MakeInt64(int64(q.IFT_GIGABITETHERNET))},
			"IFT_GR303IDT":                      {"untyped int", constant.MakeInt64(int64(q.IFT_GR303IDT))},
			"IFT_GR303RDT":                      {"untyped int", constant.MakeInt64(int64(q.IFT_GR303RDT))},
			"IFT_H323GATEKEEPER":                {"untyped int", constant.MakeInt64(int64(q.IFT_H323GATEKEEPER))},
			"IFT_H323PROXY":                     {"untyped int", constant.MakeInt64(int64(q.IFT_H323PROXY))},
			"IFT_HDH1822":                       {"untyped int", constant.MakeInt64(int64(q.IFT_HDH1822))},
			"IFT_HDLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_HDLC))},
			"IFT_HDSL2":                         {"untyped int", constant.MakeInt64(int64(q.IFT_HDSL2))},
			"IFT_HIPERLAN2":                     {"untyped int", constant.MakeInt64(int64(q.IFT_HIPERLAN2))},
			"IFT_HIPPI":                         {"untyped int", constant.MakeInt64(int64(q.IFT_HIPPI))},
			"IFT_HIPPIINTERFACE":                {"untyped int", constant.MakeInt64(int64(q.IFT_HIPPIINTERFACE))},
			"IFT_HOSTPAD":                       {"untyped int", constant.MakeInt64(int64(q.IFT_HOSTPAD))},
			"IFT_HSSI":                          {"untyped int", constant.MakeInt64(int64(q.IFT_HSSI))},
			"IFT_HY":                            {"untyped int", constant.MakeInt64(int64(q.IFT_HY))},
			"IFT_IBM370PARCHAN":                 {"untyped int", constant.MakeInt64(int64(q.IFT_IBM370PARCHAN))},
			"IFT_IDSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_IDSL))},
			"IFT_IEEE1394":                      {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE1394))},
			"IFT_IEEE80211":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE80211))},
			"IFT_IEEE80212":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE80212))},
			"IFT_IEEE8023ADLAG":                 {"untyped int", constant.MakeInt64(int64(q.IFT_IEEE8023ADLAG))},
			"IFT_IFGSN":                         {"untyped int", constant.MakeInt64(int64(q.IFT_IFGSN))},
			"IFT_IMT":                           {"untyped int", constant.MakeInt64(int64(q.IFT_IMT))},
			"IFT_INFINIBAND":                    {"untyped int", constant.MakeInt64(int64(q.IFT_INFINIBAND))},
			"IFT_INTERLEAVE":                    {"untyped int", constant.MakeInt64(int64(q.IFT_INTERLEAVE))},
			"IFT_IP":                            {"untyped int", constant.MakeInt64(int64(q.IFT_IP))},
			"IFT_IPFORWARD":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IPFORWARD))},
			"IFT_IPOVERATM":                     {"untyped int", constant.MakeInt64(int64(q.IFT_IPOVERATM))},
			"IFT_IPOVERCDLC":                    {"untyped int", constant.MakeInt64(int64(q.IFT_IPOVERCDLC))},
			"IFT_IPOVERCLAW":                    {"untyped int", constant.MakeInt64(int64(q.IFT_IPOVERCLAW))},
			"IFT_IPSWITCH":                      {"untyped int", constant.MakeInt64(int64(q.IFT_IPSWITCH))},
			"IFT_ISDN":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ISDN))},
			"IFT_ISDNBASIC":                     {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNBASIC))},
			"IFT_ISDNPRIMARY":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNPRIMARY))},
			"IFT_ISDNS":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNS))},
			"IFT_ISDNU":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ISDNU))},
			"IFT_ISO88022LLC":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88022LLC))},
			"IFT_ISO88023":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88023))},
			"IFT_ISO88024":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88024))},
			"IFT_ISO88025":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025))},
			"IFT_ISO88025CRFPINT":               {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025CRFPINT))},
			"IFT_ISO88025DTR":                   {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025DTR))},
			"IFT_ISO88025FIBER":                 {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88025FIBER))},
			"IFT_ISO88026":                      {"untyped int", constant.MakeInt64(int64(q.IFT_ISO88026))},
			"IFT_ISUP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_ISUP))},
			"IFT_L2VLAN":                        {"untyped int", constant.MakeInt64(int64(q.IFT_L2VLAN))},
			"IFT_L3IPVLAN":                      {"untyped int", constant.MakeInt64(int64(q.IFT_L3IPVLAN))},
			"IFT_L3IPXVLAN":                     {"untyped int", constant.MakeInt64(int64(q.IFT_L3IPXVLAN))},
			"IFT_LAPB":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LAPB))},
			"IFT_LAPD":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LAPD))},
			"IFT_LAPF":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LAPF))},
			"IFT_LINEGROUP":                     {"untyped int", constant.MakeInt64(int64(q.IFT_LINEGROUP))},
			"IFT_LOCALTALK":                     {"untyped int", constant.MakeInt64(int64(q.IFT_LOCALTALK))},
			"IFT_LOOP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_LOOP))},
			"IFT_MBIM":                          {"untyped int", constant.MakeInt64(int64(q.IFT_MBIM))},
			"IFT_MEDIAMAILOVERIP":               {"untyped int", constant.MakeInt64(int64(q.IFT_MEDIAMAILOVERIP))},
			"IFT_MFSIGLINK":                     {"untyped int", constant.MakeInt64(int64(q.IFT_MFSIGLINK))},
			"IFT_MIOX25":                        {"untyped int", constant.MakeInt64(int64(q.IFT_MIOX25))},
			"IFT_MODEM":                         {"untyped int", constant.MakeInt64(int64(q.IFT_MODEM))},
			"IFT_MPC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_MPC))},
			"IFT_MPLS":                          {"untyped int", constant.MakeInt64(int64(q.IFT_MPLS))},
			"IFT_MPLSTUNNEL":                    {"untyped int", constant.MakeInt64(int64(q.IFT_MPLSTUNNEL))},
			"IFT_MSDSL":                         {"untyped int", constant.MakeInt64(int64(q.IFT_MSDSL))},
			"IFT_MVL":                           {"untyped int", constant.MakeInt64(int64(q.IFT_MVL))},
			"IFT_MYRINET":                       {"untyped int", constant.MakeInt64(int64(q.IFT_MYRINET))},
			"IFT_NFAS":                          {"untyped int", constant.MakeInt64(int64(q.IFT_NFAS))},
			"IFT_NSIP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_NSIP))},
			"IFT_OPTICALCHANNEL":                {"untyped int", constant.MakeInt64(int64(q.IFT_OPTICALCHANNEL))},
			"IFT_OPTICALTRANSPORT":              {"untyped int", constant.MakeInt64(int64(q.IFT_OPTICALTRANSPORT))},
			"IFT_OTHER":                         {"untyped int", constant.MakeInt64(int64(q.IFT_OTHER))},
			"IFT_P10":                           {"untyped int", constant.MakeInt64(int64(q.IFT_P10))},
			"IFT_P80":                           {"untyped int", constant.MakeInt64(int64(q.IFT_P80))},
			"IFT_PARA":                          {"untyped int", constant.MakeInt64(int64(q.IFT_PARA))},
			"IFT_PFLOG":                         {"untyped int", constant.MakeInt64(int64(q.IFT_PFLOG))},
			"IFT_PFLOW":                         {"untyped int", constant.MakeInt64(int64(q.IFT_PFLOW))},
			"IFT_PFSYNC":                        {"untyped int", constant.MakeInt64(int64(q.IFT_PFSYNC))},
			"IFT_PLC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_PLC))},
			"IFT_PON155":                        {"untyped int", constant.MakeInt64(int64(q.IFT_PON155))},
			"IFT_PON622":                        {"untyped int", constant.MakeInt64(int64(q.IFT_PON622))},
			"IFT_POS":                           {"untyped int", constant.MakeInt64(int64(q.IFT_POS))},
			"IFT_PPP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_PPP))},
			"IFT_PPPMULTILINKBUNDLE":            {"untyped int", constant.MakeInt64(int64(q.IFT_PPPMULTILINKBUNDLE))},
			"IFT_PROPATM":                       {"untyped int", constant.MakeInt64(int64(q.IFT_PROPATM))},
			"IFT_PROPBWAP2MP":                   {"untyped int", constant.MakeInt64(int64(q.IFT_PROPBWAP2MP))},
			"IFT_PROPCNLS":                      {"untyped int", constant.MakeInt64(int64(q.IFT_PROPCNLS))},
			"IFT_PROPDOCSWIRELESSDOWNSTREAM":    {"untyped int", constant.MakeInt64(int64(q.IFT_PROPDOCSWIRELESSDOWNSTREAM))},
			"IFT_PROPDOCSWIRELESSMACLAYER":      {"untyped int", constant.MakeInt64(int64(q.IFT_PROPDOCSWIRELESSMACLAYER))},
			"IFT_PROPDOCSWIRELESSUPSTREAM":      {"untyped int", constant.MakeInt64(int64(q.IFT_PROPDOCSWIRELESSUPSTREAM))},
			"IFT_PROPMUX":                       {"untyped int", constant.MakeInt64(int64(q.IFT_PROPMUX))},
			"IFT_PROPVIRTUAL":                   {"untyped int", constant.MakeInt64(int64(q.IFT_PROPVIRTUAL))},
			"IFT_PROPWIRELESSP2P":               {"untyped int", constant.MakeInt64(int64(q.IFT_PROPWIRELESSP2P))},
			"IFT_PTPSERIAL":                     {"untyped int", constant.MakeInt64(int64(q.IFT_PTPSERIAL))},
			"IFT_PVC":                           {"untyped int", constant.MakeInt64(int64(q.IFT_PVC))},
			"IFT_Q2931":                         {"untyped int", constant.MakeInt64(int64(q.IFT_Q2931))},
			"IFT_QLLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_QLLC))},
			"IFT_RADIOMAC":                      {"untyped int", constant.MakeInt64(int64(q.IFT_RADIOMAC))},
			"IFT_RADSL":                         {"untyped int", constant.MakeInt64(int64(q.IFT_RADSL))},
			"IFT_REACHDSL":                      {"untyped int", constant.MakeInt64(int64(q.IFT_REACHDSL))},
			"IFT_RFC1483":                       {"untyped int", constant.MakeInt64(int64(q.IFT_RFC1483))},
			"IFT_RS232":                         {"untyped int", constant.MakeInt64(int64(q.IFT_RS232))},
			"IFT_RSRB":                          {"untyped int", constant.MakeInt64(int64(q.IFT_RSRB))},
			"IFT_SDLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_SDLC))},
			"IFT_SDSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_SDSL))},
			"IFT_SHDSL":                         {"untyped int", constant.MakeInt64(int64(q.IFT_SHDSL))},
			"IFT_SIP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_SIP))},
			"IFT_SIPSIG":                        {"untyped int", constant.MakeInt64(int64(q.IFT_SIPSIG))},
			"IFT_SIPTG":                         {"untyped int", constant.MakeInt64(int64(q.IFT_SIPTG))},
			"IFT_SLIP":                          {"untyped int", constant.MakeInt64(int64(q.IFT_SLIP))},
			"IFT_SMDSDXI":                       {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSDXI))},
			"IFT_SMDSICIP":                      {"untyped int", constant.MakeInt64(int64(q.IFT_SMDSICIP))},
			"IFT_SONET":                         {"untyped int", constant.MakeInt64(int64(q.IFT_SONET))},
			"IFT_SONETOVERHEADCHANNEL":          {"untyped int", constant.MakeInt64(int64(q.IFT_SONETOVERHEADCHANNEL))},
			"IFT_SONETPATH":                     {"untyped int", constant.MakeInt64(int64(q.IFT_SONETPATH))},
			"IFT_SONETVT":                       {"untyped int", constant.MakeInt64(int64(q.IFT_SONETVT))},
			"IFT_SRP":                           {"untyped int", constant.MakeInt64(int64(q.IFT_SRP))},
			"IFT_SS7SIGLINK":                    {"untyped int", constant.MakeInt64(int64(q.IFT_SS7SIGLINK))},
			"IFT_STACKTOSTACK":                  {"untyped int", constant.MakeInt64(int64(q.IFT_STACKTOSTACK))},
			"IFT_STARLAN":                       {"untyped int", constant.MakeInt64(int64(q.IFT_STARLAN))},
			"IFT_T1":                            {"untyped int", constant.MakeInt64(int64(q.IFT_T1))},
			"IFT_TDLC":                          {"untyped int", constant.MakeInt64(int64(q.IFT_TDLC))},
			"IFT_TELINK":                        {"untyped int", constant.MakeInt64(int64(q.IFT_TELINK))},
			"IFT_TERMPAD":                       {"untyped int", constant.MakeInt64(int64(q.IFT_TERMPAD))},
			"IFT_TR008":                         {"untyped int", constant.MakeInt64(int64(q.IFT_TR008))},
			"IFT_TRANSPHDLC":                    {"untyped int", constant.MakeInt64(int64(q.IFT_TRANSPHDLC))},
			"IFT_TUNNEL":                        {"untyped int", constant.MakeInt64(int64(q.IFT_TUNNEL))},
			"IFT_ULTRA":                         {"untyped int", constant.MakeInt64(int64(q.IFT_ULTRA))},
			"IFT_USB":                           {"untyped int", constant.MakeInt64(int64(q.IFT_USB))},
			"IFT_V11":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V11))},
			"IFT_V35":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V35))},
			"IFT_V36":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V36))},
			"IFT_V37":                           {"untyped int", constant.MakeInt64(int64(q.IFT_V37))},
			"IFT_VDSL":                          {"untyped int", constant.MakeInt64(int64(q.IFT_VDSL))},
			"IFT_VIRTUALIPADDRESS":              {"untyped int", constant.MakeInt64(int64(q.IFT_VIRTUALIPADDRESS))},
			"IFT_VIRTUALTG":                     {"untyped int", constant.MakeInt64(int64(q.IFT_VIRTUALTG))},
			"IFT_VOICEDID":                      {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEDID))},
			"IFT_VOICEEM":                       {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEEM))},
			"IFT_VOICEEMFGD":                    {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEEMFGD))},
			"IFT_VOICEENCAP":                    {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEENCAP))},
			"IFT_VOICEFGDEANA":                  {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEFGDEANA))},
			"IFT_VOICEFXO":                      {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEFXO))},
			"IFT_VOICEFXS":                      {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEFXS))},
			"IFT_VOICEOVERATM":                  {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEOVERATM))},
			"IFT_VOICEOVERCABLE":                {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEOVERCABLE))},
			"IFT_VOICEOVERFRAMERELAY":           {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEOVERFRAMERELAY))},
			"IFT_VOICEOVERIP":                   {"untyped int", constant.MakeInt64(int64(q.IFT_VOICEOVERIP))},
			"IFT_X213":                          {"untyped int", constant.MakeInt64(int64(q.IFT_X213))},
			"IFT_X25":                           {"untyped int", constant.MakeInt64(int64(q.IFT_X25))},
			"IFT_X25DDN":                        {"untyped int", constant.MakeInt64(int64(q.IFT_X25DDN))},
			"IFT_X25HUNTGROUP":                  {"untyped int", constant.MakeInt64(int64(q.IFT_X25HUNTGROUP))},
			"IFT_X25MLP":                        {"untyped int", constant.MakeInt64(int64(q.IFT_X25MLP))},
			"IFT_X25PLE":                        {"untyped int", constant.MakeInt64(int64(q.IFT_X25PLE))},
			"IFT_XETHER":                        {"untyped int", constant.MakeInt64(int64(q.IFT_XETHER))},
			"IGNBRK":                            {"untyped int", constant.MakeInt64(int64(q.IGNBRK))},
			"IGNCR":                             {"untyped int", constant.MakeInt64(int64(q.IGNCR))},
			"IGNPAR":                            {"untyped int", constant.MakeInt64(int64(q.IGNPAR))},
			"IMAXBEL":                           {"untyped int", constant.MakeInt64(int64(q.IMAXBEL))},
			"INLCR":                             {"untyped int", constant.MakeInt64(int64(q.INLCR))},
			"INPCK":                             {"untyped int", constant.MakeInt64(int64(q.INPCK))},
			"IN_CLASSA_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_HOST))},
			"IN_CLASSA_MAX":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_MAX))},
			"IN_CLASSA_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NET))},
			"IN_CLASSA_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSA_NSHIFT))},
			"IN_CLASSB_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_HOST))},
			"IN_CLASSB_MAX":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_MAX))},
			"IN_CLASSB_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NET))},
			"IN_CLASSB_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSB_NSHIFT))},
			"IN_CLASSC_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_HOST))},
			"IN_CLASSC_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NET))},
			"IN_CLASSC_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSC_NSHIFT))},
			"IN_CLASSD_HOST":                    {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_HOST))},
			"IN_CLASSD_NET":                     {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NET))},
			"IN_CLASSD_NSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.IN_CLASSD_NSHIFT))},
			"IN_LOOPBACKNET":                    {"untyped int", constant.MakeInt64(int64(q.IN_LOOPBACKNET))},
			"IN_RFC3021_HOST":                   {"untyped int", constant.MakeInt64(int64(q.IN_RFC3021_HOST))},
			"IN_RFC3021_NET":                    {"untyped int", constant.MakeInt64(int64(q.IN_RFC3021_NET))},
			"IN_RFC3021_NSHIFT":                 {"untyped int", constant.MakeInt64(int64(q.IN_RFC3021_NSHIFT))},
			"IPPROTO_AH":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_AH))},
			"IPPROTO_CARP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_CARP))},
			"IPPROTO_DIVERT":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DIVERT))},
			"IPPROTO_DONE":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DONE))},
			"IPPROTO_DSTOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_DSTOPTS))},
			"IPPROTO_EGP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EGP))},
			"IPPROTO_ENCAP":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ENCAP))},
			"IPPROTO_EON":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_EON))},
			"IPPROTO_ESP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ESP))},
			"IPPROTO_ETHERIP":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ETHERIP))},
			"IPPROTO_FRAGMENT":                  {"untyped int", constant.MakeInt64(int64(q.IPPROTO_FRAGMENT))},
			"IPPROTO_GGP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GGP))},
			"IPPROTO_GRE":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_GRE))},
			"IPPROTO_HOPOPTS":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_HOPOPTS))},
			"IPPROTO_ICMP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMP))},
			"IPPROTO_ICMPV6":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ICMPV6))},
			"IPPROTO_IDP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IDP))},
			"IPPROTO_IGMP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IGMP))},
			"IPPROTO_IP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IP))},
			"IPPROTO_IPCOMP":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPCOMP))},
			"IPPROTO_IPIP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPIP))},
			"IPPROTO_IPV4":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV4))},
			"IPPROTO_IPV6":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_IPV6))},
			"IPPROTO_MAX":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAX))},
			"IPPROTO_MAXID":                     {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MAXID))},
			"IPPROTO_MOBILE":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MOBILE))},
			"IPPROTO_MPLS":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_MPLS))},
			"IPPROTO_NONE":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_NONE))},
			"IPPROTO_PFSYNC":                    {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PFSYNC))},
			"IPPROTO_PIM":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PIM))},
			"IPPROTO_PUP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_PUP))},
			"IPPROTO_RAW":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RAW))},
			"IPPROTO_ROUTING":                   {"untyped int", constant.MakeInt64(int64(q.IPPROTO_ROUTING))},
			"IPPROTO_RSVP":                      {"untyped int", constant.MakeInt64(int64(q.IPPROTO_RSVP))},
			"IPPROTO_TCP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TCP))},
			"IPPROTO_TP":                        {"untyped int", constant.MakeInt64(int64(q.IPPROTO_TP))},
			"IPPROTO_UDP":                       {"untyped int", constant.MakeInt64(int64(q.IPPROTO_UDP))},
			"IPV6_AUTH_LEVEL":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_AUTH_LEVEL))},
			"IPV6_AUTOFLOWLABEL":                {"untyped int", constant.MakeInt64(int64(q.IPV6_AUTOFLOWLABEL))},
			"IPV6_CHECKSUM":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_CHECKSUM))},
			"IPV6_DEFAULT_MULTICAST_HOPS":       {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFAULT_MULTICAST_HOPS))},
			"IPV6_DEFAULT_MULTICAST_LOOP":       {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFAULT_MULTICAST_LOOP))},
			"IPV6_DEFHLIM":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_DEFHLIM))},
			"IPV6_DONTFRAG":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_DONTFRAG))},
			"IPV6_DSTOPTS":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_DSTOPTS))},
			"IPV6_ESP_NETWORK_LEVEL":            {"untyped int", constant.MakeInt64(int64(q.IPV6_ESP_NETWORK_LEVEL))},
			"IPV6_ESP_TRANS_LEVEL":              {"untyped int", constant.MakeInt64(int64(q.IPV6_ESP_TRANS_LEVEL))},
			"IPV6_FAITH":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_FAITH))},
			"IPV6_FLOWINFO_MASK":                {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWINFO_MASK))},
			"IPV6_FLOWLABEL_MASK":               {"untyped int", constant.MakeInt64(int64(q.IPV6_FLOWLABEL_MASK))},
			"IPV6_FRAGTTL":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_FRAGTTL))},
			"IPV6_HLIMDEC":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_HLIMDEC))},
			"IPV6_HOPLIMIT":                     {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPLIMIT))},
			"IPV6_HOPOPTS":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_HOPOPTS))},
			"IPV6_IPCOMP_LEVEL":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_IPCOMP_LEVEL))},
			"IPV6_JOIN_GROUP":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_JOIN_GROUP))},
			"IPV6_LEAVE_GROUP":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_LEAVE_GROUP))},
			"IPV6_MAXHLIM":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_MAXHLIM))},
			"IPV6_MAXPACKET":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_MAXPACKET))},
			"IPV6_MINHOPCOUNT":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_MINHOPCOUNT))},
			"IPV6_MMTU":                         {"untyped int", constant.MakeInt64(int64(q.IPV6_MMTU))},
			"IPV6_MULTICAST_HOPS":               {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_HOPS))},
			"IPV6_MULTICAST_IF":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_IF))},
			"IPV6_MULTICAST_LOOP":               {"untyped int", constant.MakeInt64(int64(q.IPV6_MULTICAST_LOOP))},
			"IPV6_NEXTHOP":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_NEXTHOP))},
			"IPV6_OPTIONS":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_OPTIONS))},
			"IPV6_PATHMTU":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_PATHMTU))},
			"IPV6_PIPEX":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_PIPEX))},
			"IPV6_PKTINFO":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_PKTINFO))},
			"IPV6_PORTRANGE":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE))},
			"IPV6_PORTRANGE_DEFAULT":            {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_DEFAULT))},
			"IPV6_PORTRANGE_HIGH":               {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_HIGH))},
			"IPV6_PORTRANGE_LOW":                {"untyped int", constant.MakeInt64(int64(q.IPV6_PORTRANGE_LOW))},
			"IPV6_RECVDSTOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVDSTOPTS))},
			"IPV6_RECVDSTPORT":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVDSTPORT))},
			"IPV6_RECVHOPLIMIT":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPLIMIT))},
			"IPV6_RECVHOPOPTS":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVHOPOPTS))},
			"IPV6_RECVPATHMTU":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPATHMTU))},
			"IPV6_RECVPKTINFO":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVPKTINFO))},
			"IPV6_RECVRTHDR":                    {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVRTHDR))},
			"IPV6_RECVTCLASS":                   {"untyped int", constant.MakeInt64(int64(q.IPV6_RECVTCLASS))},
			"IPV6_RTABLE":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_RTABLE))},
			"IPV6_RTHDR":                        {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR))},
			"IPV6_RTHDRDSTOPTS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDRDSTOPTS))},
			"IPV6_RTHDR_LOOSE":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_LOOSE))},
			"IPV6_RTHDR_STRICT":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_STRICT))},
			"IPV6_RTHDR_TYPE_0":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_RTHDR_TYPE_0))},
			"IPV6_SOCKOPT_RESERVED1":            {"untyped int", constant.MakeInt64(int64(q.IPV6_SOCKOPT_RESERVED1))},
			"IPV6_TCLASS":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_TCLASS))},
			"IPV6_UNICAST_HOPS":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_UNICAST_HOPS))},
			"IPV6_USE_MIN_MTU":                  {"untyped int", constant.MakeInt64(int64(q.IPV6_USE_MIN_MTU))},
			"IPV6_V6ONLY":                       {"untyped int", constant.MakeInt64(int64(q.IPV6_V6ONLY))},
			"IPV6_VERSION":                      {"untyped int", constant.MakeInt64(int64(q.IPV6_VERSION))},
			"IPV6_VERSION_MASK":                 {"untyped int", constant.MakeInt64(int64(q.IPV6_VERSION_MASK))},
			"IP_ADD_MEMBERSHIP":                 {"untyped int", constant.MakeInt64(int64(q.IP_ADD_MEMBERSHIP))},
			"IP_AUTH_LEVEL":                     {"untyped int", constant.MakeInt64(int64(q.IP_AUTH_LEVEL))},
			"IP_DEFAULT_MULTICAST_LOOP":         {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_LOOP))},
			"IP_DEFAULT_MULTICAST_TTL":          {"untyped int", constant.MakeInt64(int64(q.IP_DEFAULT_MULTICAST_TTL))},
			"IP_DF":                             {"untyped int", constant.MakeInt64(int64(q.IP_DF))},
			"IP_DROP_MEMBERSHIP":                {"untyped int", constant.MakeInt64(int64(q.IP_DROP_MEMBERSHIP))},
			"IP_ESP_NETWORK_LEVEL":              {"untyped int", constant.MakeInt64(int64(q.IP_ESP_NETWORK_LEVEL))},
			"IP_ESP_TRANS_LEVEL":                {"untyped int", constant.MakeInt64(int64(q.IP_ESP_TRANS_LEVEL))},
			"IP_HDRINCL":                        {"untyped int", constant.MakeInt64(int64(q.IP_HDRINCL))},
			"IP_IPCOMP_LEVEL":                   {"untyped int", constant.MakeInt64(int64(q.IP_IPCOMP_LEVEL))},
			"IP_IPDEFTTL":                       {"untyped int", constant.MakeInt64(int64(q.IP_IPDEFTTL))},
			"IP_IPSECFLOWINFO":                  {"untyped int", constant.MakeInt64(int64(q.IP_IPSECFLOWINFO))},
			"IP_IPSEC_LOCAL_AUTH":               {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_LOCAL_AUTH))},
			"IP_IPSEC_LOCAL_CRED":               {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_LOCAL_CRED))},
			"IP_IPSEC_LOCAL_ID":                 {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_LOCAL_ID))},
			"IP_IPSEC_REMOTE_AUTH":              {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_REMOTE_AUTH))},
			"IP_IPSEC_REMOTE_CRED":              {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_REMOTE_CRED))},
			"IP_IPSEC_REMOTE_ID":                {"untyped int", constant.MakeInt64(int64(q.IP_IPSEC_REMOTE_ID))},
			"IP_MAXPACKET":                      {"untyped int", constant.MakeInt64(int64(q.IP_MAXPACKET))},
			"IP_MAX_MEMBERSHIPS":                {"untyped int", constant.MakeInt64(int64(q.IP_MAX_MEMBERSHIPS))},
			"IP_MF":                             {"untyped int", constant.MakeInt64(int64(q.IP_MF))},
			"IP_MINTTL":                         {"untyped int", constant.MakeInt64(int64(q.IP_MINTTL))},
			"IP_MIN_MEMBERSHIPS":                {"untyped int", constant.MakeInt64(int64(q.IP_MIN_MEMBERSHIPS))},
			"IP_MSS":                            {"untyped int", constant.MakeInt64(int64(q.IP_MSS))},
			"IP_MULTICAST_IF":                   {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_IF))},
			"IP_MULTICAST_LOOP":                 {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_LOOP))},
			"IP_MULTICAST_TTL":                  {"untyped int", constant.MakeInt64(int64(q.IP_MULTICAST_TTL))},
			"IP_OFFMASK":                        {"untyped int", constant.MakeInt64(int64(q.IP_OFFMASK))},
			"IP_OPTIONS":                        {"untyped int", constant.MakeInt64(int64(q.IP_OPTIONS))},
			"IP_PIPEX":                          {"untyped int", constant.MakeInt64(int64(q.IP_PIPEX))},
			"IP_PORTRANGE":                      {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE))},
			"IP_PORTRANGE_DEFAULT":              {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_DEFAULT))},
			"IP_PORTRANGE_HIGH":                 {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_HIGH))},
			"IP_PORTRANGE_LOW":                  {"untyped int", constant.MakeInt64(int64(q.IP_PORTRANGE_LOW))},
			"IP_RECVDSTADDR":                    {"untyped int", constant.MakeInt64(int64(q.IP_RECVDSTADDR))},
			"IP_RECVDSTPORT":                    {"untyped int", constant.MakeInt64(int64(q.IP_RECVDSTPORT))},
			"IP_RECVIF":                         {"untyped int", constant.MakeInt64(int64(q.IP_RECVIF))},
			"IP_RECVOPTS":                       {"untyped int", constant.MakeInt64(int64(q.IP_RECVOPTS))},
			"IP_RECVRETOPTS":                    {"untyped int", constant.MakeInt64(int64(q.IP_RECVRETOPTS))},
			"IP_RECVRTABLE":                     {"untyped int", constant.MakeInt64(int64(q.IP_RECVRTABLE))},
			"IP_RECVTTL":                        {"untyped int", constant.MakeInt64(int64(q.IP_RECVTTL))},
			"IP_RETOPTS":                        {"untyped int", constant.MakeInt64(int64(q.IP_RETOPTS))},
			"IP_RF":                             {"untyped int", constant.MakeInt64(int64(q.IP_RF))},
			"IP_RTABLE":                         {"untyped int", constant.MakeInt64(int64(q.IP_RTABLE))},
			"IP_SENDSRCADDR":                    {"untyped int", constant.MakeInt64(int64(q.IP_SENDSRCADDR))},
			"IP_TOS":                            {"untyped int", constant.MakeInt64(int64(q.IP_TOS))},
			"IP_TTL":                            {"untyped int", constant.MakeInt64(int64(q.IP_TTL))},
			"ISIG":                              {"untyped int", constant.MakeInt64(int64(q.ISIG))},
			"ISTRIP":                            {"untyped int", constant.MakeInt64(int64(q.ISTRIP))},
			"IXANY":                             {"untyped int", constant.MakeInt64(int64(q.IXANY))},
			"IXOFF":                             {"untyped int", constant.MakeInt64(int64(q.IXOFF))},
			"IXON":                              {"untyped int", constant.MakeInt64(int64(q.IXON))},
			"ImplementsGetwd":                   {"untyped bool", constant.MakeBool(bool(q.ImplementsGetwd))},
			"LCNT_OVERLOAD_FLUSH":               {"untyped int", constant.MakeInt64(int64(q.LCNT_OVERLOAD_FLUSH))},
			"LOCK_EX":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_EX))},
			"LOCK_NB":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_NB))},
			"LOCK_SH":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_SH))},
			"LOCK_UN":                           {"untyped int", constant.MakeInt64(int64(q.LOCK_UN))},
			"MADV_DONTNEED":                     {"untyped int", constant.MakeInt64(int64(q.MADV_DONTNEED))},
			"MADV_FREE":                         {"untyped int", constant.MakeInt64(int64(q.MADV_FREE))},
			"MADV_NORMAL":                       {"untyped int", constant.MakeInt64(int64(q.MADV_NORMAL))},
			"MADV_RANDOM":                       {"untyped int", constant.MakeInt64(int64(q.MADV_RANDOM))},
			"MADV_SEQUENTIAL":                   {"untyped int", constant.MakeInt64(int64(q.MADV_SEQUENTIAL))},
			"MADV_SPACEAVAIL":                   {"untyped int", constant.MakeInt64(int64(q.MADV_SPACEAVAIL))},
			"MADV_WILLNEED":                     {"untyped int", constant.MakeInt64(int64(q.MADV_WILLNEED))},
			"MAP_ANON":                          {"untyped int", constant.MakeInt64(int64(q.MAP_ANON))},
			"MAP_ANONYMOUS":                     {"untyped int", constant.MakeInt64(int64(q.MAP_ANONYMOUS))},
			"MAP_CONCEAL":                       {"untyped int", constant.MakeInt64(int64(q.MAP_CONCEAL))},
			"MAP_COPY":                          {"untyped int", constant.MakeInt64(int64(q.MAP_COPY))},
			"MAP_FILE":                          {"untyped int", constant.MakeInt64(int64(q.MAP_FILE))},
			"MAP_FIXED":                         {"untyped int", constant.MakeInt64(int64(q.MAP_FIXED))},
			"MAP_FLAGMASK":                      {"untyped int", constant.MakeInt64(int64(q.MAP_FLAGMASK))},
			"MAP_HASSEMAPHORE":                  {"untyped int", constant.MakeInt64(int64(q.MAP_HASSEMAPHORE))},
			"MAP_INHERIT":                       {"untyped int", constant.MakeInt64(int64(q.MAP_INHERIT))},
			"MAP_INHERIT_COPY":                  {"untyped int", constant.MakeInt64(int64(q.MAP_INHERIT_COPY))},
			"MAP_INHERIT_NONE":                  {"untyped int", constant.MakeInt64(int64(q.MAP_INHERIT_NONE))},
			"MAP_INHERIT_SHARE":                 {"untyped int", constant.MakeInt64(int64(q.MAP_INHERIT_SHARE))},
			"MAP_INHERIT_ZERO":                  {"untyped int", constant.MakeInt64(int64(q.MAP_INHERIT_ZERO))},
			"MAP_NOEXTEND":                      {"untyped int", constant.MakeInt64(int64(q.MAP_NOEXTEND))},
			"MAP_NORESERVE":                     {"untyped int", constant.MakeInt64(int64(q.MAP_NORESERVE))},
			"MAP_PRIVATE":                       {"untyped int", constant.MakeInt64(int64(q.MAP_PRIVATE))},
			"MAP_RENAME":                        {"untyped int", constant.MakeInt64(int64(q.MAP_RENAME))},
			"MAP_SHARED":                        {"untyped int", constant.MakeInt64(int64(q.MAP_SHARED))},
			"MAP_STACK":                         {"untyped int", constant.MakeInt64(int64(q.MAP_STACK))},
			"MAP_TRYFIXED":                      {"untyped int", constant.MakeInt64(int64(q.MAP_TRYFIXED))},
			"MCL_CURRENT":                       {"untyped int", constant.MakeInt64(int64(q.MCL_CURRENT))},
			"MCL_FUTURE":                        {"untyped int", constant.MakeInt64(int64(q.MCL_FUTURE))},
			"MSG_BCAST":                         {"untyped int", constant.MakeInt64(int64(q.MSG_BCAST))},
			"MSG_CMSG_CLOEXEC":                  {"untyped int", constant.MakeInt64(int64(q.MSG_CMSG_CLOEXEC))},
			"MSG_CTRUNC":                        {"untyped int", constant.MakeInt64(int64(q.MSG_CTRUNC))},
			"MSG_DONTROUTE":                     {"untyped int", constant.MakeInt64(int64(q.MSG_DONTROUTE))},
			"MSG_DONTWAIT":                      {"untyped int", constant.MakeInt64(int64(q.MSG_DONTWAIT))},
			"MSG_EOR":                           {"untyped int", constant.MakeInt64(int64(q.MSG_EOR))},
			"MSG_MCAST":                         {"untyped int", constant.MakeInt64(int64(q.MSG_MCAST))},
			"MSG_NOSIGNAL":                      {"untyped int", constant.MakeInt64(int64(q.MSG_NOSIGNAL))},
			"MSG_OOB":                           {"untyped int", constant.MakeInt64(int64(q.MSG_OOB))},
			"MSG_PEEK":                          {"untyped int", constant.MakeInt64(int64(q.MSG_PEEK))},
			"MSG_TRUNC":                         {"untyped int", constant.MakeInt64(int64(q.MSG_TRUNC))},
			"MSG_WAITALL":                       {"untyped int", constant.MakeInt64(int64(q.MSG_WAITALL))},
			"MS_ASYNC":                          {"untyped int", constant.MakeInt64(int64(q.MS_ASYNC))},
			"MS_INVALIDATE":                     {"untyped int", constant.MakeInt64(int64(q.MS_INVALIDATE))},
			"MS_SYNC":                           {"untyped int", constant.MakeInt64(int64(q.MS_SYNC))},
			"NAME_MAX":                          {"untyped int", constant.MakeInt64(int64(q.NAME_MAX))},
			"NET_RT_DUMP":                       {"untyped int", constant.MakeInt64(int64(q.NET_RT_DUMP))},
			"NET_RT_FLAGS":                      {"untyped int", constant.MakeInt64(int64(q.NET_RT_FLAGS))},
			"NET_RT_IFLIST":                     {"untyped int", constant.MakeInt64(int64(q.NET_RT_IFLIST))},
			"NET_RT_IFNAMES":                    {"untyped int", constant.MakeInt64(int64(q.NET_RT_IFNAMES))},
			"NET_RT_MAXID":                      {"untyped int", constant.MakeInt64(int64(q.NET_RT_MAXID))},
			"NET_RT_STATS":                      {"untyped int", constant.MakeInt64(int64(q.NET_RT_STATS))},
			"NET_RT_TABLE":                      {"untyped int", constant.MakeInt64(int64(q.NET_RT_TABLE))},
			"NOFLSH":                            {"untyped int", constant.MakeInt64(int64(q.NOFLSH))},
			"NOTE_ATTRIB":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_ATTRIB))},
			"NOTE_CHANGE":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_CHANGE))},
			"NOTE_CHILD":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_CHILD))},
			"NOTE_DELETE":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_DELETE))},
			"NOTE_EOF":                          {"untyped int", constant.MakeInt64(int64(q.NOTE_EOF))},
			"NOTE_EXEC":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_EXEC))},
			"NOTE_EXIT":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_EXIT))},
			"NOTE_EXTEND":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_EXTEND))},
			"NOTE_FORK":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_FORK))},
			"NOTE_LINK":                         {"untyped int", constant.MakeInt64(int64(q.NOTE_LINK))},
			"NOTE_LOWAT":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_LOWAT))},
			"NOTE_PCTRLMASK":                    {"untyped int", constant.MakeInt64(int64(q.NOTE_PCTRLMASK))},
			"NOTE_PDATAMASK":                    {"untyped int", constant.MakeInt64(int64(q.NOTE_PDATAMASK))},
			"NOTE_RENAME":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_RENAME))},
			"NOTE_REVOKE":                       {"untyped int", constant.MakeInt64(int64(q.NOTE_REVOKE))},
			"NOTE_TRACK":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_TRACK))},
			"NOTE_TRACKERR":                     {"untyped int", constant.MakeInt64(int64(q.NOTE_TRACKERR))},
			"NOTE_TRUNCATE":                     {"untyped int", constant.MakeInt64(int64(q.NOTE_TRUNCATE))},
			"NOTE_WRITE":                        {"untyped int", constant.MakeInt64(int64(q.NOTE_WRITE))},
			"OCRNL":                             {"untyped int", constant.MakeInt64(int64(q.OCRNL))},
			"ONLCR":                             {"untyped int", constant.MakeInt64(int64(q.ONLCR))},
			"ONLRET":                            {"untyped int", constant.MakeInt64(int64(q.ONLRET))},
			"ONOCR":                             {"untyped int", constant.MakeInt64(int64(q.ONOCR))},
			"ONOEOT":                            {"untyped int", constant.MakeInt64(int64(q.ONOEOT))},
			"OPOST":                             {"untyped int", constant.MakeInt64(int64(q.OPOST))},
			"O_ACCMODE":                         {"untyped int", constant.MakeInt64(int64(q.O_ACCMODE))},
			"O_APPEND":                          {"untyped int", constant.MakeInt64(int64(q.O_APPEND))},
			"O_ASYNC":                           {"untyped int", constant.MakeInt64(int64(q.O_ASYNC))},
			"O_CLOEXEC":                         {"untyped int", constant.MakeInt64(int64(q.O_CLOEXEC))},
			"O_CREAT":                           {"untyped int", constant.MakeInt64(int64(q.O_CREAT))},
			"O_DIRECTORY":                       {"untyped int", constant.MakeInt64(int64(q.O_DIRECTORY))},
			"O_DSYNC":                           {"untyped int", constant.MakeInt64(int64(q.O_DSYNC))},
			"O_EXCL":                            {"untyped int", constant.MakeInt64(int64(q.O_EXCL))},
			"O_EXLOCK":                          {"untyped int", constant.MakeInt64(int64(q.O_EXLOCK))},
			"O_FSYNC":                           {"untyped int", constant.MakeInt64(int64(q.O_FSYNC))},
			"O_NDELAY":                          {"untyped int", constant.MakeInt64(int64(q.O_NDELAY))},
			"O_NOCTTY":                          {"untyped int", constant.MakeInt64(int64(q.O_NOCTTY))},
			"O_NOFOLLOW":                        {"untyped int", constant.MakeInt64(int64(q.O_NOFOLLOW))},
			"O_NONBLOCK":                        {"untyped int", constant.MakeInt64(int64(q.O_NONBLOCK))},
			"O_RDONLY":                          {"untyped int", constant.MakeInt64(int64(q.O_RDONLY))},
			"O_RDWR":                            {"untyped int", constant.MakeInt64(int64(q.O_RDWR))},
			"O_RSYNC":                           {"untyped int", constant.MakeInt64(int64(q.O_RSYNC))},
			"O_SHLOCK":                          {"untyped int", constant.MakeInt64(int64(q.O_SHLOCK))},
			"O_SYNC":                            {"untyped int", constant.MakeInt64(int64(q.O_SYNC))},
			"O_TRUNC":                           {"untyped int", constant.MakeInt64(int64(q.O_TRUNC))},
			"O_WRONLY":                          {"untyped int", constant.MakeInt64(int64(q.O_WRONLY))},
			"PARENB":                            {"untyped int", constant.MakeInt64(int64(q.PARENB))},
			"PARMRK":                            {"untyped int", constant.MakeInt64(int64(q.PARMRK))},
			"PARODD":                            {"untyped int", constant.MakeInt64(int64(q.PARODD))},
			"PENDIN":                            {"untyped int", constant.MakeInt64(int64(q.PENDIN))},
			"PF_FLUSH":                          {"untyped int", constant.MakeInt64(int64(q.PF_FLUSH))},
			"PRIO_PGRP":                         {"untyped int", constant.MakeInt64(int64(q.PRIO_PGRP))},
			"PRIO_PROCESS":                      {"untyped int", constant.MakeInt64(int64(q.PRIO_PROCESS))},
			"PRIO_USER":                         {"untyped int", constant.MakeInt64(int64(q.PRIO_USER))},
			"PROT_EXEC":                         {"untyped int", constant.MakeInt64(int64(q.PROT_EXEC))},
			"PROT_NONE":                         {"untyped int", constant.MakeInt64(int64(q.PROT_NONE))},
			"PROT_READ":                         {"untyped int", constant.MakeInt64(int64(q.PROT_READ))},
			"PROT_WRITE":                        {"untyped int", constant.MakeInt64(int64(q.PROT_WRITE))},
			"PTRACE_CONT":                       {"untyped int", constant.MakeInt64(int64(q.PTRACE_CONT))},
			"PTRACE_KILL":                       {"untyped int", constant.MakeInt64(int64(q.PTRACE_KILL))},
			"PTRACE_TRACEME":                    {"untyped int", constant.MakeInt64(int64(q.PTRACE_TRACEME))},
			"RLIMIT_CORE":                       {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CORE))},
			"RLIMIT_CPU":                        {"untyped int", constant.MakeInt64(int64(q.RLIMIT_CPU))},
			"RLIMIT_DATA":                       {"untyped int", constant.MakeInt64(int64(q.RLIMIT_DATA))},
			"RLIMIT_FSIZE":                      {"untyped int", constant.MakeInt64(int64(q.RLIMIT_FSIZE))},
			"RLIMIT_NOFILE":                     {"untyped int", constant.MakeInt64(int64(q.RLIMIT_NOFILE))},
			"RLIMIT_STACK":                      {"untyped int", constant.MakeInt64(int64(q.RLIMIT_STACK))},
			"RLIM_INFINITY":                     {"untyped int", constant.MakeInt64(int64(q.RLIM_INFINITY))},
			"RTAX_AUTHOR":                       {"untyped int", constant.MakeInt64(int64(q.RTAX_AUTHOR))},
			"RTAX_BFD":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_BFD))},
			"RTAX_BRD":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_BRD))},
			"RTAX_DNS":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_DNS))},
			"RTAX_DST":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_DST))},
			"RTAX_GATEWAY":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_GATEWAY))},
			"RTAX_GENMASK":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_GENMASK))},
			"RTAX_IFA":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_IFA))},
			"RTAX_IFP":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_IFP))},
			"RTAX_LABEL":                        {"untyped int", constant.MakeInt64(int64(q.RTAX_LABEL))},
			"RTAX_MAX":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_MAX))},
			"RTAX_NETMASK":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_NETMASK))},
			"RTAX_SEARCH":                       {"untyped int", constant.MakeInt64(int64(q.RTAX_SEARCH))},
			"RTAX_SRC":                          {"untyped int", constant.MakeInt64(int64(q.RTAX_SRC))},
			"RTAX_SRCMASK":                      {"untyped int", constant.MakeInt64(int64(q.RTAX_SRCMASK))},
			"RTAX_STATIC":                       {"untyped int", constant.MakeInt64(int64(q.RTAX_STATIC))},
			"RTA_AUTHOR":                        {"untyped int", constant.MakeInt64(int64(q.RTA_AUTHOR))},
			"RTA_BFD":                           {"untyped int", constant.MakeInt64(int64(q.RTA_BFD))},
			"RTA_BRD":                           {"untyped int", constant.MakeInt64(int64(q.RTA_BRD))},
			"RTA_DNS":                           {"untyped int", constant.MakeInt64(int64(q.RTA_DNS))},
			"RTA_DST":                           {"untyped int", constant.MakeInt64(int64(q.RTA_DST))},
			"RTA_GATEWAY":                       {"untyped int", constant.MakeInt64(int64(q.RTA_GATEWAY))},
			"RTA_GENMASK":                       {"untyped int", constant.MakeInt64(int64(q.RTA_GENMASK))},
			"RTA_IFA":                           {"untyped int", constant.MakeInt64(int64(q.RTA_IFA))},
			"RTA_IFP":                           {"untyped int", constant.MakeInt64(int64(q.RTA_IFP))},
			"RTA_LABEL":                         {"untyped int", constant.MakeInt64(int64(q.RTA_LABEL))},
			"RTA_NETMASK":                       {"untyped int", constant.MakeInt64(int64(q.RTA_NETMASK))},
			"RTA_SEARCH":                        {"untyped int", constant.MakeInt64(int64(q.RTA_SEARCH))},
			"RTA_SRC":                           {"untyped int", constant.MakeInt64(int64(q.RTA_SRC))},
			"RTA_SRCMASK":                       {"untyped int", constant.MakeInt64(int64(q.RTA_SRCMASK))},
			"RTA_STATIC":                        {"untyped int", constant.MakeInt64(int64(q.RTA_STATIC))},
			"RTF_ANNOUNCE":                      {"untyped int", constant.MakeInt64(int64(q.RTF_ANNOUNCE))},
			"RTF_BFD":                           {"untyped int", constant.MakeInt64(int64(q.RTF_BFD))},
			"RTF_BLACKHOLE":                     {"untyped int", constant.MakeInt64(int64(q.RTF_BLACKHOLE))},
			"RTF_BROADCAST":                     {"untyped int", constant.MakeInt64(int64(q.RTF_BROADCAST))},
			"RTF_CACHED":                        {"untyped int", constant.MakeInt64(int64(q.RTF_CACHED))},
			"RTF_CLONED":                        {"untyped int", constant.MakeInt64(int64(q.RTF_CLONED))},
			"RTF_CLONING":                       {"untyped int", constant.MakeInt64(int64(q.RTF_CLONING))},
			"RTF_CONNECTED":                     {"untyped int", constant.MakeInt64(int64(q.RTF_CONNECTED))},
			"RTF_DONE":                          {"untyped int", constant.MakeInt64(int64(q.RTF_DONE))},
			"RTF_DYNAMIC":                       {"untyped int", constant.MakeInt64(int64(q.RTF_DYNAMIC))},
			"RTF_FMASK":                         {"untyped int", constant.MakeInt64(int64(q.RTF_FMASK))},
			"RTF_GATEWAY":                       {"untyped int", constant.MakeInt64(int64(q.RTF_GATEWAY))},
			"RTF_HOST":                          {"untyped int", constant.MakeInt64(int64(q.RTF_HOST))},
			"RTF_LLINFO":                        {"untyped int", constant.MakeInt64(int64(q.RTF_LLINFO))},
			"RTF_LOCAL":                         {"untyped int", constant.MakeInt64(int64(q.RTF_LOCAL))},
			"RTF_MODIFIED":                      {"untyped int", constant.MakeInt64(int64(q.RTF_MODIFIED))},
			"RTF_MPATH":                         {"untyped int", constant.MakeInt64(int64(q.RTF_MPATH))},
			"RTF_MPLS":                          {"untyped int", constant.MakeInt64(int64(q.RTF_MPLS))},
			"RTF_MULTICAST":                     {"untyped int", constant.MakeInt64(int64(q.RTF_MULTICAST))},
			"RTF_PERMANENT_ARP":                 {"untyped int", constant.MakeInt64(int64(q.RTF_PERMANENT_ARP))},
			"RTF_PROTO1":                        {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO1))},
			"RTF_PROTO2":                        {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO2))},
			"RTF_PROTO3":                        {"untyped int", constant.MakeInt64(int64(q.RTF_PROTO3))},
			"RTF_REJECT":                        {"untyped int", constant.MakeInt64(int64(q.RTF_REJECT))},
			"RTF_STATIC":                        {"untyped int", constant.MakeInt64(int64(q.RTF_STATIC))},
			"RTF_UP":                            {"untyped int", constant.MakeInt64(int64(q.RTF_UP))},
			"RTF_USETRAILERS":                   {"untyped int", constant.MakeInt64(int64(q.RTF_USETRAILERS))},
			"RTM_80211INFO":                     {"untyped int", constant.MakeInt64(int64(q.RTM_80211INFO))},
			"RTM_ADD":                           {"untyped int", constant.MakeInt64(int64(q.RTM_ADD))},
			"RTM_BFD":                           {"untyped int", constant.MakeInt64(int64(q.RTM_BFD))},
			"RTM_CHANGE":                        {"untyped int", constant.MakeInt64(int64(q.RTM_CHANGE))},
			"RTM_CHGADDRATTR":                   {"untyped int", constant.MakeInt64(int64(q.RTM_CHGADDRATTR))},
			"RTM_DELADDR":                       {"untyped int", constant.MakeInt64(int64(q.RTM_DELADDR))},
			"RTM_DELETE":                        {"untyped int", constant.MakeInt64(int64(q.RTM_DELETE))},
			"RTM_DESYNC":                        {"untyped int", constant.MakeInt64(int64(q.RTM_DESYNC))},
			"RTM_GET":                           {"untyped int", constant.MakeInt64(int64(q.RTM_GET))},
			"RTM_IFANNOUNCE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_IFANNOUNCE))},
			"RTM_IFINFO":                        {"untyped int", constant.MakeInt64(int64(q.RTM_IFINFO))},
			"RTM_INVALIDATE":                    {"untyped int", constant.MakeInt64(int64(q.RTM_INVALIDATE))},
			"RTM_LOCK":                          {"untyped int", constant.MakeInt64(int64(q.RTM_LOCK))},
			"RTM_LOSING":                        {"untyped int", constant.MakeInt64(int64(q.RTM_LOSING))},
			"RTM_MAXSIZE":                       {"untyped int", constant.MakeInt64(int64(q.RTM_MAXSIZE))},
			"RTM_MISS":                          {"untyped int", constant.MakeInt64(int64(q.RTM_MISS))},
			"RTM_NEWADDR":                       {"untyped int", constant.MakeInt64(int64(q.RTM_NEWADDR))},
			"RTM_PROPOSAL":                      {"untyped int", constant.MakeInt64(int64(q.RTM_PROPOSAL))},
			"RTM_REDIRECT":                      {"untyped int", constant.MakeInt64(int64(q.RTM_REDIRECT))},
			"RTM_RESOLVE":                       {"untyped int", constant.MakeInt64(int64(q.RTM_RESOLVE))},
			"RTM_RTTUNIT":                       {"untyped int", constant.MakeInt64(int64(q.RTM_RTTUNIT))},
			"RTM_VERSION":                       {"untyped int", constant.MakeInt64(int64(q.RTM_VERSION))},
			"RTV_EXPIRE":                        {"untyped int", constant.MakeInt64(int64(q.RTV_EXPIRE))},
			"RTV_HOPCOUNT":                      {"untyped int", constant.MakeInt64(int64(q.RTV_HOPCOUNT))},
			"RTV_MTU":                           {"untyped int", constant.MakeInt64(int64(q.RTV_MTU))},
			"RTV_RPIPE":                         {"untyped int", constant.MakeInt64(int64(q.RTV_RPIPE))},
			"RTV_RTT":                           {"untyped int", constant.MakeInt64(int64(q.RTV_RTT))},
			"RTV_RTTVAR":                        {"untyped int", constant.MakeInt64(int64(q.RTV_RTTVAR))},
			"RTV_SPIPE":                         {"untyped int", constant.MakeInt64(int64(q.RTV_SPIPE))},
			"RTV_SSTHRESH":                      {"untyped int", constant.MakeInt64(int64(q.RTV_SSTHRESH))},
			"RT_TABLEID_BITS":                   {"untyped int", constant.MakeInt64(int64(q.RT_TABLEID_BITS))},
			"RT_TABLEID_MASK":                   {"untyped int", constant.MakeInt64(int64(q.RT_TABLEID_MASK))},
			"RT_TABLEID_MAX":                    {"untyped int", constant.MakeInt64(int64(q.RT_TABLEID_MAX))},
			"RUSAGE_CHILDREN":                   {"untyped int", constant.MakeInt64(int64(q.RUSAGE_CHILDREN))},
			"RUSAGE_SELF":                       {"untyped int", constant.MakeInt64(int64(q.RUSAGE_SELF))},
			"RUSAGE_THREAD":                     {"untyped int", constant.MakeInt64(int64(q.RUSAGE_THREAD))},
			"SCM_RIGHTS":                        {"untyped int", constant.MakeInt64(int64(q.SCM_RIGHTS))},
			"SCM_TIMESTAMP":                     {"untyped int", constant.MakeInt64(int64(q.SCM_TIMESTAMP))},
			"SHUT_RD":                           {"untyped int", constant.MakeInt64(int64(q.SHUT_RD))},
			"SHUT_RDWR":                         {"untyped int", constant.MakeInt64(int64(q.SHUT_RDWR))},
			"SHUT_WR":                           {"untyped int", constant.MakeInt64(int64(q.SHUT_WR))},
			"SIOCADDMULTI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCADDMULTI))},
			"SIOCAIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCAIFADDR))},
			"SIOCAIFGROUP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCAIFGROUP))},
			"SIOCATMARK":                        {"untyped int", constant.MakeInt64(int64(q.SIOCATMARK))},
			"SIOCBRDGADD":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGADD))},
			"SIOCBRDGADDL":                      {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGADDL))},
			"SIOCBRDGADDS":                      {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGADDS))},
			"SIOCBRDGARL":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGARL))},
			"SIOCBRDGDADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGDADDR))},
			"SIOCBRDGDEL":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGDEL))},
			"SIOCBRDGDELS":                      {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGDELS))},
			"SIOCBRDGFLUSH":                     {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGFLUSH))},
			"SIOCBRDGFRL":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGFRL))},
			"SIOCBRDGGCACHE":                    {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGCACHE))},
			"SIOCBRDGGFD":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGFD))},
			"SIOCBRDGGHT":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGHT))},
			"SIOCBRDGGIFFLGS":                   {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGIFFLGS))},
			"SIOCBRDGGMA":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGMA))},
			"SIOCBRDGGPARAM":                    {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGPARAM))},
			"SIOCBRDGGPRI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGPRI))},
			"SIOCBRDGGRL":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGRL))},
			"SIOCBRDGGTO":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGGTO))},
			"SIOCBRDGIFS":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGIFS))},
			"SIOCBRDGRTS":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGRTS))},
			"SIOCBRDGSADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSADDR))},
			"SIOCBRDGSCACHE":                    {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSCACHE))},
			"SIOCBRDGSFD":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSFD))},
			"SIOCBRDGSHT":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSHT))},
			"SIOCBRDGSIFCOST":                   {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSIFCOST))},
			"SIOCBRDGSIFFLGS":                   {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSIFFLGS))},
			"SIOCBRDGSIFPRIO":                   {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSIFPRIO))},
			"SIOCBRDGSIFPROT":                   {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSIFPROT))},
			"SIOCBRDGSMA":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSMA))},
			"SIOCBRDGSPRI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSPRI))},
			"SIOCBRDGSPROTO":                    {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSPROTO))},
			"SIOCBRDGSTO":                       {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSTO))},
			"SIOCBRDGSTXHC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCBRDGSTXHC))},
			"SIOCDELLABEL":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDELLABEL))},
			"SIOCDELMULTI":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDELMULTI))},
			"SIOCDIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCDIFADDR))},
			"SIOCDIFGROUP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCDIFGROUP))},
			"SIOCDIFPARENT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCDIFPARENT))},
			"SIOCDIFPHYADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCDIFPHYADDR))},
			"SIOCDPWE3NEIGHBOR":                 {"untyped int", constant.MakeInt64(int64(q.SIOCDPWE3NEIGHBOR))},
			"SIOCDVNETID":                       {"untyped int", constant.MakeInt64(int64(q.SIOCDVNETID))},
			"SIOCGETKALIVE":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGETKALIVE))},
			"SIOCGETLABEL":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGETLABEL))},
			"SIOCGETMPWCFG":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGETMPWCFG))},
			"SIOCGETPFLOW":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGETPFLOW))},
			"SIOCGETPFSYNC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGETPFSYNC))},
			"SIOCGETSGCNT":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGETSGCNT))},
			"SIOCGETVIFCNT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGETVIFCNT))},
			"SIOCGETVLAN":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGETVLAN))},
			"SIOCGIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFADDR))},
			"SIOCGIFBRDADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFBRDADDR))},
			"SIOCGIFCONF":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFCONF))},
			"SIOCGIFDATA":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDATA))},
			"SIOCGIFDESCR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDESCR))},
			"SIOCGIFDSTADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFDSTADDR))},
			"SIOCGIFFLAGS":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFFLAGS))},
			"SIOCGIFGATTR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGATTR))},
			"SIOCGIFGENERIC":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGENERIC))},
			"SIOCGIFGLIST":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGLIST))},
			"SIOCGIFGMEMB":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGMEMB))},
			"SIOCGIFGROUP":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFGROUP))},
			"SIOCGIFHARDMTU":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFHARDMTU))},
			"SIOCGIFLLPRIO":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFLLPRIO))},
			"SIOCGIFMEDIA":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMEDIA))},
			"SIOCGIFMETRIC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMETRIC))},
			"SIOCGIFMTU":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFMTU))},
			"SIOCGIFNETMASK":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFNETMASK))},
			"SIOCGIFPAIR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPAIR))},
			"SIOCGIFPARENT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPARENT))},
			"SIOCGIFPRIORITY":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGIFPRIORITY))},
			"SIOCGIFRDOMAIN":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFRDOMAIN))},
			"SIOCGIFRTLABEL":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFRTLABEL))},
			"SIOCGIFRXR":                        {"untyped int", constant.MakeInt64(int64(q.SIOCGIFRXR))},
			"SIOCGIFSFFPAGE":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGIFSFFPAGE))},
			"SIOCGIFXFLAGS":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGIFXFLAGS))},
			"SIOCGLIFPHYADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFPHYADDR))},
			"SIOCGLIFPHYDF":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFPHYDF))},
			"SIOCGLIFPHYECN":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFPHYECN))},
			"SIOCGLIFPHYRTABLE":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFPHYRTABLE))},
			"SIOCGLIFPHYTTL":                    {"untyped int", constant.MakeInt64(int64(q.SIOCGLIFPHYTTL))},
			"SIOCGPGRP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGPGRP))},
			"SIOCGPWE3":                         {"untyped int", constant.MakeInt64(int64(q.SIOCGPWE3))},
			"SIOCGPWE3CTRLWORD":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGPWE3CTRLWORD))},
			"SIOCGPWE3FAT":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGPWE3FAT))},
			"SIOCGPWE3NEIGHBOR":                 {"untyped int", constant.MakeInt64(int64(q.SIOCGPWE3NEIGHBOR))},
			"SIOCGSPPPPARAMS":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGSPPPPARAMS))},
			"SIOCGTXHPRIO":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGTXHPRIO))},
			"SIOCGUMBINFO":                      {"untyped int", constant.MakeInt64(int64(q.SIOCGUMBINFO))},
			"SIOCGUMBPARAM":                     {"untyped int", constant.MakeInt64(int64(q.SIOCGUMBPARAM))},
			"SIOCGVH":                           {"untyped int", constant.MakeInt64(int64(q.SIOCGVH))},
			"SIOCGVNETFLOWID":                   {"untyped int", constant.MakeInt64(int64(q.SIOCGVNETFLOWID))},
			"SIOCGVNETID":                       {"untyped int", constant.MakeInt64(int64(q.SIOCGVNETID))},
			"SIOCIFAFATTACH":                    {"untyped int", constant.MakeInt64(int64(q.SIOCIFAFATTACH))},
			"SIOCIFAFDETACH":                    {"untyped int", constant.MakeInt64(int64(q.SIOCIFAFDETACH))},
			"SIOCIFCREATE":                      {"untyped int", constant.MakeInt64(int64(q.SIOCIFCREATE))},
			"SIOCIFDESTROY":                     {"untyped int", constant.MakeInt64(int64(q.SIOCIFDESTROY))},
			"SIOCIFGCLONERS":                    {"untyped int", constant.MakeInt64(int64(q.SIOCIFGCLONERS))},
			"SIOCSETKALIVE":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSETKALIVE))},
			"SIOCSETLABEL":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSETLABEL))},
			"SIOCSETMPWCFG":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSETMPWCFG))},
			"SIOCSETPFLOW":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSETPFLOW))},
			"SIOCSETPFSYNC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSETPFSYNC))},
			"SIOCSETVLAN":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSETVLAN))},
			"SIOCSIFADDR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFADDR))},
			"SIOCSIFBRDADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFBRDADDR))},
			"SIOCSIFDESCR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFDESCR))},
			"SIOCSIFDSTADDR":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFDSTADDR))},
			"SIOCSIFFLAGS":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFFLAGS))},
			"SIOCSIFGATTR":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFGATTR))},
			"SIOCSIFGENERIC":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFGENERIC))},
			"SIOCSIFLLADDR":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFLLADDR))},
			"SIOCSIFLLPRIO":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFLLPRIO))},
			"SIOCSIFMEDIA":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMEDIA))},
			"SIOCSIFMETRIC":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMETRIC))},
			"SIOCSIFMTU":                        {"untyped int", constant.MakeInt64(int64(q.SIOCSIFMTU))},
			"SIOCSIFNETMASK":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFNETMASK))},
			"SIOCSIFPAIR":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPAIR))},
			"SIOCSIFPARENT":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPARENT))},
			"SIOCSIFPRIORITY":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSIFPRIORITY))},
			"SIOCSIFRDOMAIN":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFRDOMAIN))},
			"SIOCSIFRTLABEL":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSIFRTLABEL))},
			"SIOCSIFXFLAGS":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSIFXFLAGS))},
			"SIOCSLIFPHYADDR":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPHYADDR))},
			"SIOCSLIFPHYDF":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPHYDF))},
			"SIOCSLIFPHYECN":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPHYECN))},
			"SIOCSLIFPHYRTABLE":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPHYRTABLE))},
			"SIOCSLIFPHYTTL":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSLIFPHYTTL))},
			"SIOCSPGRP":                         {"untyped int", constant.MakeInt64(int64(q.SIOCSPGRP))},
			"SIOCSPWE3CTRLWORD":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSPWE3CTRLWORD))},
			"SIOCSPWE3FAT":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSPWE3FAT))},
			"SIOCSPWE3NEIGHBOR":                 {"untyped int", constant.MakeInt64(int64(q.SIOCSPWE3NEIGHBOR))},
			"SIOCSSPPPPARAMS":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSSPPPPARAMS))},
			"SIOCSTXHPRIO":                      {"untyped int", constant.MakeInt64(int64(q.SIOCSTXHPRIO))},
			"SIOCSUMBPARAM":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSUMBPARAM))},
			"SIOCSVH":                           {"untyped int", constant.MakeInt64(int64(q.SIOCSVH))},
			"SIOCSVNETFLOWID":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSVNETFLOWID))},
			"SIOCSVNETID":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSVNETID))},
			"SIOCSWGDPID":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSWGDPID))},
			"SIOCSWGMAXFLOW":                    {"untyped int", constant.MakeInt64(int64(q.SIOCSWGMAXFLOW))},
			"SIOCSWGMAXGROUP":                   {"untyped int", constant.MakeInt64(int64(q.SIOCSWGMAXGROUP))},
			"SIOCSWSDPID":                       {"untyped int", constant.MakeInt64(int64(q.SIOCSWSDPID))},
			"SIOCSWSPORTNO":                     {"untyped int", constant.MakeInt64(int64(q.SIOCSWSPORTNO))},
			"SOCK_CLOEXEC":                      {"untyped int", constant.MakeInt64(int64(q.SOCK_CLOEXEC))},
			"SOCK_DGRAM":                        {"untyped int", constant.MakeInt64(int64(q.SOCK_DGRAM))},
			"SOCK_DNS":                          {"untyped int", constant.MakeInt64(int64(q.SOCK_DNS))},
			"SOCK_NONBLOCK":                     {"untyped int", constant.MakeInt64(int64(q.SOCK_NONBLOCK))},
			"SOCK_RAW":                          {"untyped int", constant.MakeInt64(int64(q.SOCK_RAW))},
			"SOCK_RDM":                          {"untyped int", constant.MakeInt64(int64(q.SOCK_RDM))},
			"SOCK_SEQPACKET":                    {"untyped int", constant.MakeInt64(int64(q.SOCK_SEQPACKET))},
			"SOCK_STREAM":                       {"untyped int", constant.MakeInt64(int64(q.SOCK_STREAM))},
			"SOL_SOCKET":                        {"untyped int", constant.MakeInt64(int64(q.SOL_SOCKET))},
			"SOMAXCONN":                         {"untyped int", constant.MakeInt64(int64(q.SOMAXCONN))},
			"SO_ACCEPTCONN":                     {"untyped int", constant.MakeInt64(int64(q.SO_ACCEPTCONN))},
			"SO_BINDANY":                        {"untyped int", constant.MakeInt64(int64(q.SO_BINDANY))},
			"SO_BROADCAST":                      {"untyped int", constant.MakeInt64(int64(q.SO_BROADCAST))},
			"SO_DEBUG":                          {"untyped int", constant.MakeInt64(int64(q.SO_DEBUG))},
			"SO_DONTROUTE":                      {"untyped int", constant.MakeInt64(int64(q.SO_DONTROUTE))},
			"SO_ERROR":                          {"untyped int", constant.MakeInt64(int64(q.SO_ERROR))},
			"SO_KEEPALIVE":                      {"untyped int", constant.MakeInt64(int64(q.SO_KEEPALIVE))},
			"SO_LINGER":                         {"untyped int", constant.MakeInt64(int64(q.SO_LINGER))},
			"SO_NETPROC":                        {"untyped int", constant.MakeInt64(int64(q.SO_NETPROC))},
			"SO_OOBINLINE":                      {"untyped int", constant.MakeInt64(int64(q.SO_OOBINLINE))},
			"SO_PEERCRED":                       {"untyped int", constant.MakeInt64(int64(q.SO_PEERCRED))},
			"SO_RCVBUF":                         {"untyped int", constant.MakeInt64(int64(q.SO_RCVBUF))},
			"SO_RCVLOWAT":                       {"untyped int", constant.MakeInt64(int64(q.SO_RCVLOWAT))},
			"SO_RCVTIMEO":                       {"untyped int", constant.MakeInt64(int64(q.SO_RCVTIMEO))},
			"SO_REUSEADDR":                      {"untyped int", constant.MakeInt64(int64(q.SO_REUSEADDR))},
			"SO_REUSEPORT":                      {"untyped int", constant.MakeInt64(int64(q.SO_REUSEPORT))},
			"SO_RTABLE":                         {"untyped int", constant.MakeInt64(int64(q.SO_RTABLE))},
			"SO_SNDBUF":                         {"untyped int", constant.MakeInt64(int64(q.SO_SNDBUF))},
			"SO_SNDLOWAT":                       {"untyped int", constant.MakeInt64(int64(q.SO_SNDLOWAT))},
			"SO_SNDTIMEO":                       {"untyped int", constant.MakeInt64(int64(q.SO_SNDTIMEO))},
			"SO_SPLICE":                         {"untyped int", constant.MakeInt64(int64(q.SO_SPLICE))},
			"SO_TIMESTAMP":                      {"untyped int", constant.MakeInt64(int64(q.SO_TIMESTAMP))},
			"SO_TYPE":                           {"untyped int", constant.MakeInt64(int64(q.SO_TYPE))},
			"SO_USELOOPBACK":                    {"untyped int", constant.MakeInt64(int64(q.SO_USELOOPBACK))},
			"SO_ZEROIZE":                        {"untyped int", constant.MakeInt64(int64(q.SO_ZEROIZE))},
			"SYS_ACCEPT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_ACCEPT))},
			"SYS_ACCEPT4":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ACCEPT4))},
			"SYS_ACCESS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_ACCESS))},
			"SYS_ACCT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_ACCT))},
			"SYS_ADJFREQ":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ADJFREQ))},
			"SYS_ADJTIME":                       {"untyped int", constant.MakeInt64(int64(q.SYS_ADJTIME))},
			"SYS_BIND":                          {"untyped int", constant.MakeInt64(int64(q.SYS_BIND))},
			"SYS_CHDIR":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CHDIR))},
			"SYS_CHFLAGS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_CHFLAGS))},
			"SYS_CHFLAGSAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_CHFLAGSAT))},
			"SYS_CHMOD":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CHMOD))},
			"SYS_CHOWN":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CHOWN))},
			"SYS_CHROOT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_CHROOT))},
			"SYS_CLOCK_GETRES":                  {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_GETRES))},
			"SYS_CLOCK_GETTIME":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_GETTIME))},
			"SYS_CLOCK_SETTIME":                 {"untyped int", constant.MakeInt64(int64(q.SYS_CLOCK_SETTIME))},
			"SYS_CLOSE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_CLOSE))},
			"SYS_CLOSEFROM":                     {"untyped int", constant.MakeInt64(int64(q.SYS_CLOSEFROM))},
			"SYS_CONNECT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_CONNECT))},
			"SYS_DUP":                           {"untyped int", constant.MakeInt64(int64(q.SYS_DUP))},
			"SYS_DUP2":                          {"untyped int", constant.MakeInt64(int64(q.SYS_DUP2))},
			"SYS_DUP3":                          {"untyped int", constant.MakeInt64(int64(q.SYS_DUP3))},
			"SYS_EXECVE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_EXECVE))},
			"SYS_EXIT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_EXIT))},
			"SYS_FACCESSAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FACCESSAT))},
			"SYS_FCHDIR":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FCHDIR))},
			"SYS_FCHFLAGS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FCHFLAGS))},
			"SYS_FCHMOD":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMOD))},
			"SYS_FCHMODAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FCHMODAT))},
			"SYS_FCHOWN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FCHOWN))},
			"SYS_FCHOWNAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FCHOWNAT))},
			"SYS_FCNTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FCNTL))},
			"SYS_FHOPEN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FHOPEN))},
			"SYS_FHSTAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_FHSTAT))},
			"SYS_FHSTATFS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FHSTATFS))},
			"SYS_FLOCK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FLOCK))},
			"SYS_FORK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_FORK))},
			"SYS_FPATHCONF":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FPATHCONF))},
			"SYS_FSTAT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FSTAT))},
			"SYS_FSTATAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATAT))},
			"SYS_FSTATFS":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FSTATFS))},
			"SYS_FSYNC":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FSYNC))},
			"SYS_FTRUNCATE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_FTRUNCATE))},
			"SYS_FUTEX":                         {"untyped int", constant.MakeInt64(int64(q.SYS_FUTEX))},
			"SYS_FUTIMENS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_FUTIMENS))},
			"SYS_FUTIMES":                       {"untyped int", constant.MakeInt64(int64(q.SYS_FUTIMES))},
			"SYS_GETDENTS":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETDENTS))},
			"SYS_GETDTABLECOUNT":                {"untyped int", constant.MakeInt64(int64(q.SYS_GETDTABLECOUNT))},
			"SYS_GETEGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETEGID))},
			"SYS_GETENTROPY":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETENTROPY))},
			"SYS_GETEUID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETEUID))},
			"SYS_GETFH":                         {"untyped int", constant.MakeInt64(int64(q.SYS_GETFH))},
			"SYS_GETFSSTAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETFSSTAT))},
			"SYS_GETGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETGID))},
			"SYS_GETGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETGROUPS))},
			"SYS_GETITIMER":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETITIMER))},
			"SYS_GETLOGIN_R":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETLOGIN_R))},
			"SYS_GETPEERNAME":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETPEERNAME))},
			"SYS_GETPGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGID))},
			"SYS_GETPGRP":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETPGRP))},
			"SYS_GETPID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETPID))},
			"SYS_GETPPID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_GETPPID))},
			"SYS_GETPRIORITY":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETPRIORITY))},
			"SYS_GETRESGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRESGID))},
			"SYS_GETRESUID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRESUID))},
			"SYS_GETRLIMIT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRLIMIT))},
			"SYS_GETRTABLE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRTABLE))},
			"SYS_GETRUSAGE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_GETRUSAGE))},
			"SYS_GETSID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETSID))},
			"SYS_GETSOCKNAME":                   {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKNAME))},
			"SYS_GETSOCKOPT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_GETSOCKOPT))},
			"SYS_GETTHRID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_GETTHRID))},
			"SYS_GETTIMEOFDAY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_GETTIMEOFDAY))},
			"SYS_GETUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_GETUID))},
			"SYS_IOCTL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_IOCTL))},
			"SYS_ISSETUGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_ISSETUGID))},
			"SYS_KBIND":                         {"untyped int", constant.MakeInt64(int64(q.SYS_KBIND))},
			"SYS_KEVENT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_KEVENT))},
			"SYS_KILL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_KILL))},
			"SYS_KQUEUE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_KQUEUE))},
			"SYS_KTRACE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_KTRACE))},
			"SYS_LCHOWN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LCHOWN))},
			"SYS_LINK":                          {"untyped int", constant.MakeInt64(int64(q.SYS_LINK))},
			"SYS_LINKAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LINKAT))},
			"SYS_LISTEN":                        {"untyped int", constant.MakeInt64(int64(q.SYS_LISTEN))},
			"SYS_LSEEK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LSEEK))},
			"SYS_LSTAT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_LSTAT))},
			"SYS_MADVISE":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MADVISE))},
			"SYS_MINHERIT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MINHERIT))},
			"SYS_MKDIR":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIR))},
			"SYS_MKDIRAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MKDIRAT))},
			"SYS_MKFIFO":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MKFIFO))},
			"SYS_MKFIFOAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MKFIFOAT))},
			"SYS_MKNOD":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MKNOD))},
			"SYS_MKNODAT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MKNODAT))},
			"SYS_MLOCK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCK))},
			"SYS_MLOCKALL":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MLOCKALL))},
			"SYS_MMAP":                          {"untyped int", constant.MakeInt64(int64(q.SYS_MMAP))},
			"SYS_MOUNT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MOUNT))},
			"SYS_MPROTECT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_MPROTECT))},
			"SYS_MQUERY":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MQUERY))},
			"SYS_MSGCTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGCTL))},
			"SYS_MSGGET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGGET))},
			"SYS_MSGRCV":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGRCV))},
			"SYS_MSGSND":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MSGSND))},
			"SYS_MSYNC":                         {"untyped int", constant.MakeInt64(int64(q.SYS_MSYNC))},
			"SYS_MUNLOCK":                       {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCK))},
			"SYS_MUNLOCKALL":                    {"untyped int", constant.MakeInt64(int64(q.SYS_MUNLOCKALL))},
			"SYS_MUNMAP":                        {"untyped int", constant.MakeInt64(int64(q.SYS_MUNMAP))},
			"SYS_NANOSLEEP":                     {"untyped int", constant.MakeInt64(int64(q.SYS_NANOSLEEP))},
			"SYS_NFSSVC":                        {"untyped int", constant.MakeInt64(int64(q.SYS_NFSSVC))},
			"SYS_OBREAK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_OBREAK))},
			"SYS_OPEN":                          {"untyped int", constant.MakeInt64(int64(q.SYS_OPEN))},
			"SYS_OPENAT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_OPENAT))},
			"SYS_PATHCONF":                      {"untyped int", constant.MakeInt64(int64(q.SYS_PATHCONF))},
			"SYS_PIPE":                          {"untyped int", constant.MakeInt64(int64(q.SYS_PIPE))},
			"SYS_PIPE2":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PIPE2))},
			"SYS_PLEDGE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PLEDGE))},
			"SYS_POLL":                          {"untyped int", constant.MakeInt64(int64(q.SYS_POLL))},
			"SYS_PPOLL":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PPOLL))},
			"SYS_PREAD":                         {"untyped int", constant.MakeInt64(int64(q.SYS_PREAD))},
			"SYS_PREADV":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PREADV))},
			"SYS_PROFIL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PROFIL))},
			"SYS_PSELECT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_PSELECT))},
			"SYS_PTRACE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PTRACE))},
			"SYS_PWRITE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_PWRITE))},
			"SYS_PWRITEV":                       {"untyped int", constant.MakeInt64(int64(q.SYS_PWRITEV))},
			"SYS_QUOTACTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS_QUOTACTL))},
			"SYS_READ":                          {"untyped int", constant.MakeInt64(int64(q.SYS_READ))},
			"SYS_READLINK":                      {"untyped int", constant.MakeInt64(int64(q.SYS_READLINK))},
			"SYS_READLINKAT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_READLINKAT))},
			"SYS_READV":                         {"untyped int", constant.MakeInt64(int64(q.SYS_READV))},
			"SYS_REBOOT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_REBOOT))},
			"SYS_RECVFROM":                      {"untyped int", constant.MakeInt64(int64(q.SYS_RECVFROM))},
			"SYS_RECVMSG":                       {"untyped int", constant.MakeInt64(int64(q.SYS_RECVMSG))},
			"SYS_RENAME":                        {"untyped int", constant.MakeInt64(int64(q.SYS_RENAME))},
			"SYS_RENAMEAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_RENAMEAT))},
			"SYS_REVOKE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_REVOKE))},
			"SYS_RMDIR":                         {"untyped int", constant.MakeInt64(int64(q.SYS_RMDIR))},
			"SYS_SCHED_YIELD":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SCHED_YIELD))},
			"SYS_SELECT":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SELECT))},
			"SYS_SEMGET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SEMGET))},
			"SYS_SEMOP":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SEMOP))},
			"SYS_SENDMSG":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SENDMSG))},
			"SYS_SENDSYSLOG":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SENDSYSLOG))},
			"SYS_SENDTO":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SENDTO))},
			"SYS_SETEGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETEGID))},
			"SYS_SETEUID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETEUID))},
			"SYS_SETGID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETGID))},
			"SYS_SETGROUPS":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETGROUPS))},
			"SYS_SETITIMER":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETITIMER))},
			"SYS_SETLOGIN":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETLOGIN))},
			"SYS_SETPGID":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SETPGID))},
			"SYS_SETPRIORITY":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SETPRIORITY))},
			"SYS_SETREGID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETREGID))},
			"SYS_SETRESGID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETRESGID))},
			"SYS_SETRESUID":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETRESUID))},
			"SYS_SETREUID":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SETREUID))},
			"SYS_SETRLIMIT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETRLIMIT))},
			"SYS_SETRTABLE":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SETRTABLE))},
			"SYS_SETSID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETSID))},
			"SYS_SETSOCKOPT":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SETSOCKOPT))},
			"SYS_SETTIMEOFDAY":                  {"untyped int", constant.MakeInt64(int64(q.SYS_SETTIMEOFDAY))},
			"SYS_SETUID":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SETUID))},
			"SYS_SHMAT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SHMAT))},
			"SYS_SHMCTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SHMCTL))},
			"SYS_SHMDT":                         {"untyped int", constant.MakeInt64(int64(q.SYS_SHMDT))},
			"SYS_SHMGET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SHMGET))},
			"SYS_SHUTDOWN":                      {"untyped int", constant.MakeInt64(int64(q.SYS_SHUTDOWN))},
			"SYS_SIGACTION":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SIGACTION))},
			"SYS_SIGALTSTACK":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SIGALTSTACK))},
			"SYS_SIGPENDING":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPENDING))},
			"SYS_SIGPROCMASK":                   {"untyped int", constant.MakeInt64(int64(q.SYS_SIGPROCMASK))},
			"SYS_SIGRETURN":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SIGRETURN))},
			"SYS_SIGSUSPEND":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SIGSUSPEND))},
			"SYS_SOCKET":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKET))},
			"SYS_SOCKETPAIR":                    {"untyped int", constant.MakeInt64(int64(q.SYS_SOCKETPAIR))},
			"SYS_STAT":                          {"untyped int", constant.MakeInt64(int64(q.SYS_STAT))},
			"SYS_STATFS":                        {"untyped int", constant.MakeInt64(int64(q.SYS_STATFS))},
			"SYS_SWAPCTL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SWAPCTL))},
			"SYS_SYMLINK":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SYMLINK))},
			"SYS_SYMLINKAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_SYMLINKAT))},
			"SYS_SYNC":                          {"untyped int", constant.MakeInt64(int64(q.SYS_SYNC))},
			"SYS_SYSARCH":                       {"untyped int", constant.MakeInt64(int64(q.SYS_SYSARCH))},
			"SYS_SYSCTL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_SYSCTL))},
			"SYS_THRKILL":                       {"untyped int", constant.MakeInt64(int64(q.SYS_THRKILL))},
			"SYS_TRUNCATE":                      {"untyped int", constant.MakeInt64(int64(q.SYS_TRUNCATE))},
			"SYS_UMASK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_UMASK))},
			"SYS_UNLINK":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UNLINK))},
			"SYS_UNLINKAT":                      {"untyped int", constant.MakeInt64(int64(q.SYS_UNLINKAT))},
			"SYS_UNMOUNT":                       {"untyped int", constant.MakeInt64(int64(q.SYS_UNMOUNT))},
			"SYS_UNVEIL":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UNVEIL))},
			"SYS_UTIMENSAT":                     {"untyped int", constant.MakeInt64(int64(q.SYS_UTIMENSAT))},
			"SYS_UTIMES":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UTIMES))},
			"SYS_UTRACE":                        {"untyped int", constant.MakeInt64(int64(q.SYS_UTRACE))},
			"SYS_VFORK":                         {"untyped int", constant.MakeInt64(int64(q.SYS_VFORK))},
			"SYS_WAIT4":                         {"untyped int", constant.MakeInt64(int64(q.SYS_WAIT4))},
			"SYS_WRITE":                         {"untyped int", constant.MakeInt64(int64(q.SYS_WRITE))},
			"SYS_WRITEV":                        {"untyped int", constant.MakeInt64(int64(q.SYS_WRITEV))},
			"SYS___GETCWD":                      {"untyped int", constant.MakeInt64(int64(q.SYS___GETCWD))},
			"SYS___GET_TCB":                     {"untyped int", constant.MakeInt64(int64(q.SYS___GET_TCB))},
			"SYS___SEMCTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS___SEMCTL))},
			"SYS___SET_TCB":                     {"untyped int", constant.MakeInt64(int64(q.SYS___SET_TCB))},
			"SYS___SYSCTL":                      {"untyped int", constant.MakeInt64(int64(q.SYS___SYSCTL))},
			"SYS___TFORK":                       {"untyped int", constant.MakeInt64(int64(q.SYS___TFORK))},
			"SYS___THREXIT":                     {"untyped int", constant.MakeInt64(int64(q.SYS___THREXIT))},
			"SYS___THRSIGDIVERT":                {"untyped int", constant.MakeInt64(int64(q.SYS___THRSIGDIVERT))},
			"SYS___THRSLEEP":                    {"untyped int", constant.MakeInt64(int64(q.SYS___THRSLEEP))},
			"SYS___THRWAKEUP":                   {"untyped int", constant.MakeInt64(int64(q.SYS___THRWAKEUP))},
			"S_IFBLK":                           {"untyped int", constant.MakeInt64(int64(q.S_IFBLK))},
			"S_IFCHR":                           {"untyped int", constant.MakeInt64(int64(q.S_IFCHR))},
			"S_IFDIR":                           {"untyped int", constant.MakeInt64(int64(q.S_IFDIR))},
			"S_IFIFO":                           {"untyped int", constant.MakeInt64(int64(q.S_IFIFO))},
			"S_IFLNK":                           {"untyped int", constant.MakeInt64(int64(q.S_IFLNK))},
			"S_IFMT":                            {"untyped int", constant.MakeInt64(int64(q.S_IFMT))},
			"S_IFREG":                           {"untyped int", constant.MakeInt64(int64(q.S_IFREG))},
			"S_IFSOCK":                          {"untyped int", constant.MakeInt64(int64(q.S_IFSOCK))},
			"S_IRUSR":                           {"untyped int", constant.MakeInt64(int64(q.S_IRUSR))},
			"S_IRWXG":                           {"untyped int", constant.MakeInt64(int64(q.S_IRWXG))},
			"S_IRWXO":                           {"untyped int", constant.MakeInt64(int64(q.S_IRWXO))},
			"S_ISGID":                           {"untyped int", constant.MakeInt64(int64(q.S_ISGID))},
			"S_ISUID":                           {"untyped int", constant.MakeInt64(int64(q.S_ISUID))},
			"S_ISVTX":                           {"untyped int", constant.MakeInt64(int64(q.S_ISVTX))},
			"S_IWUSR":                           {"untyped int", constant.MakeInt64(int64(q.S_IWUSR))},
			"S_IXUSR":                           {"untyped int", constant.MakeInt64(int64(q.S_IXUSR))},
			"SizeofBpfHdr":                      {"untyped int", constant.MakeInt64(int64(q.SizeofBpfHdr))},
			"SizeofBpfInsn":                     {"untyped int", constant.MakeInt64(int64(q.SizeofBpfInsn))},
			"SizeofBpfProgram":                  {"untyped int", constant.MakeInt64(int64(q.SizeofBpfProgram))},
			"SizeofBpfStat":                     {"untyped int", constant.MakeInt64(int64(q.SizeofBpfStat))},
			"SizeofBpfVersion":                  {"untyped int", constant.MakeInt64(int64(q.SizeofBpfVersion))},
			"SizeofCmsghdr":                     {"untyped int", constant.MakeInt64(int64(q.SizeofCmsghdr))},
			"SizeofICMPv6Filter":                {"untyped int", constant.MakeInt64(int64(q.SizeofICMPv6Filter))},
			"SizeofIPMreq":                      {"untyped int", constant.MakeInt64(int64(q.SizeofIPMreq))},
			"SizeofIPv6MTUInfo":                 {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6MTUInfo))},
			"SizeofIPv6Mreq":                    {"untyped int", constant.MakeInt64(int64(q.SizeofIPv6Mreq))},
			"SizeofIfAnnounceMsghdr":            {"untyped int", constant.MakeInt64(int64(q.SizeofIfAnnounceMsghdr))},
			"SizeofIfData":                      {"untyped int", constant.MakeInt64(int64(q.SizeofIfData))},
			"SizeofIfMsghdr":                    {"untyped int", constant.MakeInt64(int64(q.SizeofIfMsghdr))},
			"SizeofIfaMsghdr":                   {"untyped int", constant.MakeInt64(int64(q.SizeofIfaMsghdr))},
			"SizeofInet6Pktinfo":                {"untyped int", constant.MakeInt64(int64(q.SizeofInet6Pktinfo))},
			"SizeofLinger":                      {"untyped int", constant.MakeInt64(int64(q.SizeofLinger))},
			"SizeofMsghdr":                      {"untyped int", constant.MakeInt64(int64(q.SizeofMsghdr))},
			"SizeofRtMetrics":                   {"untyped int", constant.MakeInt64(int64(q.SizeofRtMetrics))},
			"SizeofRtMsghdr":                    {"untyped int", constant.MakeInt64(int64(q.SizeofRtMsghdr))},
			"SizeofSockaddrAny":                 {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrAny))},
			"SizeofSockaddrDatalink":            {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrDatalink))},
			"SizeofSockaddrInet4":               {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet4))},
			"SizeofSockaddrInet6":               {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrInet6))},
			"SizeofSockaddrUnix":                {"untyped int", constant.MakeInt64(int64(q.SizeofSockaddrUnix))},
			"TCIFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.TCIFLUSH))},
			"TCIOFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TCIOFLUSH))},
			"TCOFLUSH":                          {"untyped int", constant.MakeInt64(int64(q.TCOFLUSH))},
			"TCP_MAXBURST":                      {"untyped int", constant.MakeInt64(int64(q.TCP_MAXBURST))},
			"TCP_MAXSEG":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MAXSEG))},
			"TCP_MAXWIN":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MAXWIN))},
			"TCP_MAX_SACK":                      {"untyped int", constant.MakeInt64(int64(q.TCP_MAX_SACK))},
			"TCP_MAX_WINSHIFT":                  {"untyped int", constant.MakeInt64(int64(q.TCP_MAX_WINSHIFT))},
			"TCP_MD5SIG":                        {"untyped int", constant.MakeInt64(int64(q.TCP_MD5SIG))},
			"TCP_MSS":                           {"untyped int", constant.MakeInt64(int64(q.TCP_MSS))},
			"TCP_NODELAY":                       {"untyped int", constant.MakeInt64(int64(q.TCP_NODELAY))},
			"TCP_NOPUSH":                        {"untyped int", constant.MakeInt64(int64(q.TCP_NOPUSH))},
			"TCP_SACK_ENABLE":                   {"untyped int", constant.MakeInt64(int64(q.TCP_SACK_ENABLE))},
			"TCSAFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TCSAFLUSH))},
			"TIOCCBRK":                          {"untyped int", constant.MakeInt64(int64(q.TIOCCBRK))},
			"TIOCCDTR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCCDTR))},
			"TIOCCHKVERAUTH":                    {"untyped int", constant.MakeInt64(int64(q.TIOCCHKVERAUTH))},
			"TIOCCLRVERAUTH":                    {"untyped int", constant.MakeInt64(int64(q.TIOCCLRVERAUTH))},
			"TIOCCONS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCCONS))},
			"TIOCDRAIN":                         {"untyped int", constant.MakeInt64(int64(q.TIOCDRAIN))},
			"TIOCEXCL":                          {"untyped int", constant.MakeInt64(int64(q.TIOCEXCL))},
			"TIOCEXT":                           {"untyped int", constant.MakeInt64(int64(q.TIOCEXT))},
			"TIOCFLAG_CLOCAL":                   {"untyped int", constant.MakeInt64(int64(q.TIOCFLAG_CLOCAL))},
			"TIOCFLAG_CRTSCTS":                  {"untyped int", constant.MakeInt64(int64(q.TIOCFLAG_CRTSCTS))},
			"TIOCFLAG_MDMBUF":                   {"untyped int", constant.MakeInt64(int64(q.TIOCFLAG_MDMBUF))},
			"TIOCFLAG_PPS":                      {"untyped int", constant.MakeInt64(int64(q.TIOCFLAG_PPS))},
			"TIOCFLAG_SOFTCAR":                  {"untyped int", constant.MakeInt64(int64(q.TIOCFLAG_SOFTCAR))},
			"TIOCFLUSH":                         {"untyped int", constant.MakeInt64(int64(q.TIOCFLUSH))},
			"TIOCGETA":                          {"untyped int", constant.MakeInt64(int64(q.TIOCGETA))},
			"TIOCGETD":                          {"untyped int", constant.MakeInt64(int64(q.TIOCGETD))},
			"TIOCGFLAGS":                        {"untyped int", constant.MakeInt64(int64(q.TIOCGFLAGS))},
			"TIOCGPGRP":                         {"untyped int", constant.MakeInt64(int64(q.TIOCGPGRP))},
			"TIOCGSID":                          {"untyped int", constant.MakeInt64(int64(q.TIOCGSID))},
			"TIOCGTSTAMP":                       {"untyped int", constant.MakeInt64(int64(q.TIOCGTSTAMP))},
			"TIOCGWINSZ":                        {"untyped int", constant.MakeInt64(int64(q.TIOCGWINSZ))},
			"TIOCMBIC":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMBIC))},
			"TIOCMBIS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMBIS))},
			"TIOCMGET":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMGET))},
			"TIOCMODG":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMODG))},
			"TIOCMODS":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMODS))},
			"TIOCMSET":                          {"untyped int", constant.MakeInt64(int64(q.TIOCMSET))},
			"TIOCM_CAR":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_CAR))},
			"TIOCM_CD":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_CD))},
			"TIOCM_CTS":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_CTS))},
			"TIOCM_DSR":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_DSR))},
			"TIOCM_DTR":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_DTR))},
			"TIOCM_LE":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_LE))},
			"TIOCM_RI":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_RI))},
			"TIOCM_RNG":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_RNG))},
			"TIOCM_RTS":                         {"untyped int", constant.MakeInt64(int64(q.TIOCM_RTS))},
			"TIOCM_SR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_SR))},
			"TIOCM_ST":                          {"untyped int", constant.MakeInt64(int64(q.TIOCM_ST))},
			"TIOCNOTTY":                         {"untyped int", constant.MakeInt64(int64(q.TIOCNOTTY))},
			"TIOCNXCL":                          {"untyped int", constant.MakeInt64(int64(q.TIOCNXCL))},
			"TIOCOUTQ":                          {"untyped int", constant.MakeInt64(int64(q.TIOCOUTQ))},
			"TIOCPKT":                           {"untyped int", constant.MakeInt64(int64(q.TIOCPKT))},
			"TIOCPKT_DATA":                      {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DATA))},
			"TIOCPKT_DOSTOP":                    {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_DOSTOP))},
			"TIOCPKT_FLUSHREAD":                 {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHREAD))},
			"TIOCPKT_FLUSHWRITE":                {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_FLUSHWRITE))},
			"TIOCPKT_IOCTL":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_IOCTL))},
			"TIOCPKT_NOSTOP":                    {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_NOSTOP))},
			"TIOCPKT_START":                     {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_START))},
			"TIOCPKT_STOP":                      {"untyped int", constant.MakeInt64(int64(q.TIOCPKT_STOP))},
			"TIOCREMOTE":                        {"untyped int", constant.MakeInt64(int64(q.TIOCREMOTE))},
			"TIOCSBRK":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSBRK))},
			"TIOCSCTTY":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSCTTY))},
			"TIOCSDTR":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSDTR))},
			"TIOCSETA":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSETA))},
			"TIOCSETAF":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSETAF))},
			"TIOCSETAW":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSETAW))},
			"TIOCSETD":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSETD))},
			"TIOCSETVERAUTH":                    {"untyped int", constant.MakeInt64(int64(q.TIOCSETVERAUTH))},
			"TIOCSFLAGS":                        {"untyped int", constant.MakeInt64(int64(q.TIOCSFLAGS))},
			"TIOCSIG":                           {"untyped int", constant.MakeInt64(int64(q.TIOCSIG))},
			"TIOCSPGRP":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSPGRP))},
			"TIOCSTART":                         {"untyped int", constant.MakeInt64(int64(q.TIOCSTART))},
			"TIOCSTAT":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSTAT))},
			"TIOCSTOP":                          {"untyped int", constant.MakeInt64(int64(q.TIOCSTOP))},
			"TIOCSTSTAMP":                       {"untyped int", constant.MakeInt64(int64(q.TIOCSTSTAMP))},
			"TIOCSWINSZ":                        {"untyped int", constant.MakeInt64(int64(q.TIOCSWINSZ))},
			"TIOCUCNTL":                         {"untyped int", constant.MakeInt64(int64(q.TIOCUCNTL))},
			"TIOCUCNTL_CBRK":                    {"untyped int", constant.MakeInt64(int64(q.TIOCUCNTL_CBRK))},
			"TIOCUCNTL_SBRK":                    {"untyped int", constant.MakeInt64(int64(q.TIOCUCNTL_SBRK))},
			"TOSTOP":                            {"untyped int", constant.MakeInt64(int64(q.TOSTOP))},
			"VDISCARD":                          {"untyped int", constant.MakeInt64(int64(q.VDISCARD))},
			"VDSUSP":                            {"untyped int", constant.MakeInt64(int64(q.VDSUSP))},
			"VEOF":                              {"untyped int", constant.MakeInt64(int64(q.VEOF))},
			"VEOL":                              {"untyped int", constant.MakeInt64(int64(q.VEOL))},
			"VEOL2":                             {"untyped int", constant.MakeInt64(int64(q.VEOL2))},
			"VERASE":                            {"untyped int", constant.MakeInt64(int64(q.VERASE))},
			"VINTR":                             {"untyped int", constant.MakeInt64(int64(q.VINTR))},
			"VKILL":                             {"untyped int", constant.MakeInt64(int64(q.VKILL))},
			"VLNEXT":                            {"untyped int", constant.MakeInt64(int64(q.VLNEXT))},
			"VMIN":                              {"untyped int", constant.MakeInt64(int64(q.VMIN))},
			"VQUIT":                             {"untyped int", constant.MakeInt64(int64(q.VQUIT))},
			"VREPRINT":                          {"untyped int", constant.MakeInt64(int64(q.VREPRINT))},
			"VSTART":                            {"untyped int", constant.MakeInt64(int64(q.VSTART))},
			"VSTATUS":                           {"untyped int", constant.MakeInt64(int64(q.VSTATUS))},
			"VSTOP":                             {"untyped int", constant.MakeInt64(int64(q.VSTOP))},
			"VSUSP":                             {"untyped int", constant.MakeInt64(int64(q.VSUSP))},
			"VTIME":                             {"untyped int", constant.MakeInt64(int64(q.VTIME))},
			"VWERASE":                           {"untyped int", constant.MakeInt64(int64(q.VWERASE))},
			"WALTSIG":                           {"untyped int", constant.MakeInt64(int64(q.WALTSIG))},
			"WCONTINUED":                        {"untyped int", constant.MakeInt64(int64(q.WCONTINUED))},
			"WCOREFLAG":                         {"untyped int", constant.MakeInt64(int64(q.WCOREFLAG))},
			"WNOHANG":                           {"untyped int", constant.MakeInt64(int64(q.WNOHANG))},
			"WUNTRACED":                         {"untyped int", constant.MakeInt64(int64(q.WUNTRACED))},
		},
	})
}
