# Security Policy

If you believe you've found a security issue in one of the supported versions of *WireGuard Portal*, please report it to us as described below.

## Supported Versions

| Version | Supported          |
|---------|--------------------|
| v2.x    | :white_check_mark: |
| v1.x    | :x:                |

## Reporting a Vulnerability

Please do not report security vulnerabilities through public GitHub issues. 

Instead, we encourage you to submit a report through GitHub [private vulnerability reporting](https://github.com/h44z/wg-portal/security).
If you prefer to submit a report without logging in to GitHub, please email *info (at) wgportal.org*. 
We will respond as soon as possible, but as only two people currently maintain this project, we cannot guarantee specific response times.

We prefer all communications to be in English.
Please include the requested information listed below (as much as you can provide) to help us better understand the nature and scope of the possible issue:

 - Type of issue (e.g. SQL injection, cross-site scripting, ...)
 - Full paths of source file(s) related to the manifestation of the issue
 - The location of the affected source code (tag/branch/commit or direct URL)
 - Any special configuration required to reproduce the issue
 - Step-by-step instructions to reproduce the issue
 - Proof-of-concept or exploit code (if possible)
 - Impact of the issue, including how an attacker might exploit the issue

This information will help us triage your report more quickly.

Thank you for helping keep *WireGuard Portal* and its users safe!
