Major upgrades between different versions may require special procedures, which are described in the following sections.

## Upgrade from v1 to v2

> :warning: Before upgrading from V1, make sure that you have a backup of your currently working configuration files and database!

To start the upgrade process, start the wg-portal binary with the **-migrateFrom** parameter.
The configuration (config.yaml) for WireGuard Portal must be updated and valid before starting the upgrade.

To upgrade from a previous SQLite database, start wg-portal like:

```shell
./wg-portal-amd64 -migrateFrom=old_wg_portal.db
```

You can also specify the database type using the parameter **-migrateFromType**. 
Supported database types: `mysql`, `mssql`, `postgres` or `sqlite`.

For example:

```shell
./wg-portal-amd64 -migrateFromType=mysql -migrateFrom='user:pass@tcp(1.2.3.4:3306)/dbname?charset=utf8mb4&parseTime=True&loc=Local'
```

The upgrade will transform the old, existing database and store the values in the new database specified in the **config.yaml** configuration file.
Ensure that the new database does not contain any data!

If you are using Docker, you can adapt the docker-compose.yml file to start the upgrade process:

```yaml
services:
  wg-portal:
    image: wgportal/wg-portal:v2
    # ... other settings
    restart: no
    command: ["-migrateFrom=/app/data/old_wg_portal.db"]
```
