# AUTOGENERATED FILE - DO NOT EDIT
# This file uses wg-quick format.
# See https://man7.org/linux/man-pages/man8/wg-quick.8.html#CONFIGURATION
# Lines starting with the -WGP- tag are used by
# the WireGuard Portal configuration parser.

# -WGP- WIREGUARD PORTAL CONFIGURATION FILE
# -WGP- version {{ .Portal.Version }}

[Interface]
# -WGP- Interface: {{ .Interface.Identifier }}
# -WGP- Created: {{ .Interface.CreatedAt }}
# -WGP- Updated: {{ .Interface.UpdatedAt }}
# -WGP- Display name: {{ .Interface.DisplayName }}
# -WGP- Interface mode: {{ .Interface.Type }}
# -WGP- PublicKey = {{ .Interface.KeyPair.PublicKey }}

# Core settings
PrivateKey = {{ .Interface.KeyPair.PrivateKey }}
Address = {{ CidrsToString .Interface.Addresses }}

# Misc. settings (optional)
{{- if ne .Interface.ListenPort 0}}
ListenPort = {{ .Interface.ListenPort }}
{{- end}}
{{- if ne .Interface.Mtu 0}}
MTU = {{.Interface.Mtu}}
{{- end}}
{{- if and (ne .Interface.DnsStr "") (eq $.Interface.Type "client")}}
DNS = {{ .Interface.DnsStr }}
{{- end}}
{{- if ne .Interface.FirewallMark 0}}
FwMark = {{.Interface.FirewallMark}}
{{- end}}
{{- if ne .Interface.RoutingTable ""}}
Table = {{.Interface.RoutingTable}}
{{- end}}
{{- if .Interface.SaveConfig}}
SaveConfig = true
{{- end}}

# Interface hooks (optional)
{{- if .Interface.PreUp}}
PreUp = {{ .Interface.PreUp }}
{{- end}}
{{- if .Interface.PostUp}}
PostUp = {{ .Interface.PostUp }}
{{- end}}
{{- if .Interface.PreDown}}
PreDown = {{ .Interface.PreDown }}
{{- end}}
{{- if .Interface.PostDown}}
PostDown = {{ .Interface.PostDown }}
{{- end}}

#
# Peers
#

{{range .Peers}}
{{- if not .IsDisabled}}
[Peer]
{{/* `friendly_name` used by https://github.com/MindFlavor/prometheus_wireguard_exporter */ -}}
# friendly_name = {{ .DisplayName }}
# -WGP- Peer: {{.Identifier}}
# -WGP- Created: {{.CreatedAt}}
# -WGP- Updated: {{.UpdatedAt}}
# -WGP- Display name: {{ .DisplayName }}
{{- if .Interface.KeyPair.PrivateKey}}
# -WGP- PrivateKey: {{.Interface.KeyPair.PrivateKey}}
{{- end}}
PublicKey = {{ .Interface.KeyPair.PublicKey }}
{{- if .PresharedKey}}
PresharedKey = {{ .PresharedKey }}
{{- end}}
{{- if eq $.Interface.Type "server"}}
AllowedIPs = {{ CidrsToString .Interface.Addresses }}{{if ne .ExtraAllowedIPsStr ""}}, {{ .ExtraAllowedIPsStr }}{{end}}
{{- end}}
{{- if eq $.Interface.Type "client"}}
{{- if .AllowedIPsStr.GetValue}}
AllowedIPs = {{ .AllowedIPsStr.GetValue }}
{{- end}}
{{- end}}
{{- if and (ne .Endpoint.GetValue "") (eq $.Interface.Type "client")}}
Endpoint = {{ .Endpoint.GetValue }}
{{- end}}
{{- if and (ne .PersistentKeepalive.GetValue 0)  (eq $.Interface.Type "client")}}
PersistentKeepalive = {{ .PersistentKeepalive.GetValue  }}
{{- end}}
{{- end}}
{{end}}
