# AUTOGENERATED FILE - DO NOT EDIT
# This file uses {{ .Style }} format.
{{- if eq .Style "wgquick"}}
# See https://man7.org/linux/man-pages/man8/wg-quick.8.html#CONFIGURATION
{{- end}}
# Lines starting with the -WGP- tag are used by
# the WireGuard Portal configuration parser.

# -WGP- WIREGUARD PORTAL CONFIGURATION FILE
# -WGP- version {{ .Portal.Version }}

[Interface]
# -WGP- Peer: {{.Peer.Identifier}}
# -WGP- Created: {{.Peer.CreatedAt}}
# -WGP- Updated: {{.Peer.UpdatedAt}}
# -WGP- Display name: {{ .Peer.DisplayName }}
# -WGP- PublicKey: {{ .Peer.Interface.KeyPair.PublicKey }}
{{- if eq .Peer.Interface.Type "server"}}
# -WGP- Peer type: server
{{else}}
# -WGP- Peer type: client
{{- end}}

# Core settings
PrivateKey = {{ .Peer.Interface.KeyPair.PrivateKey }}
{{- if eq .Style "wgquick"}}
Address = {{ CidrsToString .Peer.Interface.Addresses }}
{{- end}}

# Misc. settings (optional)
{{- if eq .Style "wgquick"}}
{{- if .Peer.Interface.DnsStr.GetValue}}
DNS = {{ .Peer.Interface.DnsStr.GetValue }} {{- if .Peer.Interface.DnsSearchStr.GetValue}}, {{ .Peer.Interface.DnsSearchStr.GetValue }} {{- end}}
{{- end}}
{{- if ne .Peer.Interface.Mtu.GetValue 0}}
MTU = {{ .Peer.Interface.Mtu.GetValue }}
{{- end}}
{{- if ne .Peer.Interface.RoutingTable.GetValue ""}}
Table = {{ .Peer.Interface.RoutingTable.GetValue }}
{{- end}}
{{- end}}
{{- if ne .Peer.Interface.FirewallMark.GetValue 0}}
FwMark = {{ .Peer.Interface.FirewallMark.GetValue }}
{{- end}}

{{- if eq .Style "wgquick"}}
# Interface hooks (optional)
{{- if .Peer.Interface.PreUp.GetValue}}
PreUp = {{ .Peer.Interface.PreUp.GetValue }}
{{- end}}
{{- if .Peer.Interface.PostUp.GetValue}}
PostUp = {{ .Peer.Interface.PostUp.GetValue }}
{{- end}}
{{- if .Peer.Interface.PreDown.GetValue}}
PreDown = {{ .Peer.Interface.PreDown.GetValue }}
{{- end}}
{{- if .Peer.Interface.PostDown.GetValue}}
PostDown = {{ .Peer.Interface.PostDown.GetValue }}
{{- end}}
{{- end}}

[Peer]
PublicKey = {{ .Peer.EndpointPublicKey.GetValue }}
Endpoint = {{ .Peer.Endpoint.GetValue }}
{{- if .Peer.AllowedIPsStr.GetValue}}
AllowedIPs = {{ .Peer.AllowedIPsStr.GetValue }}
{{- end}}
{{- if .Peer.PresharedKey}}
PresharedKey = {{ .Peer.PresharedKey }}
{{- end}}
{{- if and (ne .Peer.PersistentKeepalive.GetValue 0) (eq .Peer.Interface.Type "client")}}
PersistentKeepalive = {{ .Peer.PersistentKeepalive.GetValue }}
{{- end}}
