---
icon: clarity:plugin-line
---

# Plugins

> H3 plugins allow you to extend an H3 app instance with reusable logic.

## Register Plugins

Plugins can be registered either when creating a new [H3 instance](/guide/api/h3) or by using [H3.register](/guide/api/h3#h3register).

```js
import { H3 } from "h3";
import { logger } from "./logger.mjs";

// Using instance config
const app = new H3({
  plugins: [logger()],
});

// Or register later
app.register(logger());

// ... rest of the code..
app.get("/**", () => "Hello, World!");
```

> [!NOTE]
> Plugins are always registered immediately. Therefore, the order in which they are used might be important depending on the plugin's functionality.

## Creating Plugins

H3 plugins are simply functions that accept an [H3 instance](/guide/api/h3) as the first argument and immediately apply logic to extend it.

```js
app.register((app) => {
  app.use(...)
})
```

For convenience, H3 provides a built-in `definePlugin` utility, which creates a typed factory function with optional plugin-specific options.

```js
import { definePlugin } from "h3";

const logger = definePlugin((h3, _options) => {
  if (h3.config.debug) {
    h3.use((req) => {
      console.log(`[${req.method}] ${req.url}`);
    });
  }
});
```
