import { describe, expect, it } from "vitest";

describe("h3 package", () => {
  it("package exports (snapshot)", async () => {
    const exportNames = Object.keys(
      await import("../../src/_entries/generic.ts"),
    ).sort();
    expect(exportNames).toMatchInlineSnapshot(`
      [
        "H3",
        "H3Core",
        "H3Error",
        "H3Event",
        "HTTPError",
        "HTTPResponse",
        "appendCorsHeaders",
        "appendCorsPreflightHeaders",
        "appendHeader",
        "appendHeaders",
        "appendResponseHeader",
        "appendResponseHeaders",
        "assertBodySize",
        "assertMethod",
        "basicAuth",
        "bodyLimit",
        "callMiddleware",
        "clearResponseHeaders",
        "clearSession",
        "createApp",
        "createError",
        "createEventStream",
        "createRouter",
        "defaultContentType",
        "defineEventHandler",
        "defineHandler",
        "defineLazyEventHandler",
        "defineMiddleware",
        "defineNodeHandler",
        "defineNodeListener",
        "defineNodeMiddleware",
        "definePlugin",
        "defineRoute",
        "defineValidatedHandler",
        "defineWebSocket",
        "defineWebSocketHandler",
        "deleteChunkedCookie",
        "deleteCookie",
        "dynamicEventHandler",
        "eventHandler",
        "fetchWithEvent",
        "fromNodeHandler",
        "fromNodeMiddleware",
        "fromWebHandler",
        "getBodyStream",
        "getChunkedCookie",
        "getCookie",
        "getEventContext",
        "getHeader",
        "getHeaders",
        "getMethod",
        "getProxyRequestHeaders",
        "getQuery",
        "getRequestFingerprint",
        "getRequestHeader",
        "getRequestHeaders",
        "getRequestHost",
        "getRequestIP",
        "getRequestPath",
        "getRequestProtocol",
        "getRequestURL",
        "getRequestWebStream",
        "getResponseHeader",
        "getResponseHeaders",
        "getResponseStatus",
        "getResponseStatusText",
        "getRouterParam",
        "getRouterParams",
        "getSession",
        "getValidatedQuery",
        "getValidatedRouterParams",
        "handleCacheHeaders",
        "handleCors",
        "html",
        "isCorsOriginAllowed",
        "isError",
        "isEvent",
        "isHTTPEvent",
        "isMethod",
        "isPreflightRequest",
        "iterable",
        "lazyEventHandler",
        "mockEvent",
        "noContent",
        "onError",
        "onRequest",
        "onResponse",
        "parseCookies",
        "proxy",
        "proxyRequest",
        "readBody",
        "readFormData",
        "readFormDataBody",
        "readMultipartFormData",
        "readRawBody",
        "readValidatedBody",
        "redirect",
        "removeResponseHeader",
        "requireBasicAuth",
        "sanitizeStatusCode",
        "sanitizeStatusMessage",
        "sealSession",
        "sendIterable",
        "sendNoContent",
        "sendProxy",
        "sendRedirect",
        "sendStream",
        "sendWebResponse",
        "serve",
        "serveStatic",
        "setChunkedCookie",
        "setCookie",
        "setHeader",
        "setHeaders",
        "setResponseHeader",
        "setResponseHeaders",
        "setResponseStatus",
        "toEventHandler",
        "toMiddleware",
        "toNodeHandler",
        "toNodeListener",
        "toRequest",
        "toResponse",
        "toWebHandler",
        "unsealSession",
        "updateSession",
        "useBase",
        "useSession",
        "withBase",
        "writeEarlyHints",
      ]
    `);
  });
});
