class Generator {

	static function compile() {
		var errored = [];
		Sys.setCwd("build");
		var cwd = Sys.getCwd();
		for( f in sys.FileSystem.readDirectory(".") ) {
			if( !sys.FileSystem.isDirectory(f) )
				continue;
			var dir = cwd+"/"+f;
			Sys.setCwd(dir);
			for( d in sys.FileSystem.readDirectory(dir) ) {
				if( !StringTools.endsWith(d,".hxml") ) continue;
				var name = d.substr(0,-5);
				if( f != name ) name = f+"/"+name;
				var pass = false;
				Sys.println(name);
				if( StringTools.endsWith(name,"_hl") )
					d = "-lib hlsdl "+d;
				try {
					if( Sys.command("haxe "+d) == 0 ) pass = true;
				} catch( e : Dynamic ) {
					Sys.println(e);
				}
				if( !pass ) errored.push(name);
			}
			Sys.setCwd(cwd);
		}
		if( errored.length > 0 ) {
			Sys.println(errored.length+" ERRORED : "+errored);
			Sys.exit(1);
		}
		Sys.println("DONE");
	}

	#if hscript
	static function generateProjects() {

		var templates = [];
		for( f in sys.FileSystem.readDirectory("templates") )
			templates.push({ file : f, data : sys.io.File.getContent("templates/" + f) });

		try sys.FileSystem.createDirectory("build") catch( e : Dynamic ) {};
		sys.io.File.saveContent("build/README.txt","This directory is automatically generated by samples/Script.hx using samples/templates");

		var hasHxBit = Sys.command("haxelib path hxbit") == 0;
			
		for( f in sys.FileSystem.readDirectory(".") ) {

			if( sys.FileSystem.isDirectory(f) || !StringTools.endsWith(f,".hx") )
				continue;

			var title = f.split(".").shift();

			if( title == "Generator" || title == "SampleApp" ) continue;

			var name = title.charAt(0).toLowerCase() + title.substr(1);
			var params = [];
			if( sys.FileSystem.exists(name+"_res") )
				params.push("-D resourcesPath=../../"+name+"_res");
			if( hasHxBit )
				params.push("-lib hxbit");

			var content = sys.io.File.getContent(f);
			~/\/\/PARAM=(.*)/g.map(content,function(r) { params.push(StringTools.trim(r.matched(1))); return ""; });

			var context = {
				main : title,
				name : name,
				params : params.join("\n"),
				StringTools : StringTools,
			};

			try sys.FileSystem.createDirectory("build/"+name) catch( e : Dynamic ) {};
			#if !silent
			Sys.println(name);
			#end

			var interp = new hscript.Interp();
			for( f in Reflect.fields(context) )
				interp.variables.set(f, Reflect.field(context, f));
			for( t in templates ) {
				var data = ~/::([^:]+)::/g.map(t.data, function(r) {
					var script = r.matched(1);
					var expr = new hscript.Parser().parseString(script);
					return "" + interp.execute(expr);
				});
				var file = t.file.split("__name").join(name);
				sys.io.File.saveContent("build/" + name + "/" + file, data);
			}
		}
	}
	#end
}