extra_breadcrumb_title_1: Operator Catalog
extra_breadcrumb_title_2: IBM Maximo Operator Catalog
extra_breadcrumb_url_2: ../../../
nav_title: Operator Catalog

IBM Cert Manager v3.9.0
================================================================================

Install Modes
--------------------------------------------------------------------------------
| Mode                 | Supported |
| :------------------- | :-------- |
| OwnNamespace         | True      |
| SingleNamespace      | True      |
| MultiNamespace       | False     |
| AllNamespaces        | True      |

Service Accounts
--------------------------------------------------------------------------------
No service accounts

Cluster Permissions
--------------------------------------------------------------------------------
| Group                                    | Resource                                 | Verbs                                                                            |
| :--------------------------------------- | :--------------------------------------- | :------------------------------------------------------------------------------- |
| operator.ibm.com                         | certmanagers                             | create, delete, get, list, patch, update, watch                                  |
| operator.ibm.com                         | certmanagers/status                      | create, delete, get, list, patch, update, watch                                  |
| operator.ibm.com                         | certmanagers/finalizers                  | create, delete, get, list, patch, update, watch                                  |
| apiextensions.k8s.io                     | customresourcedefinitions                | *                                                                                |
| rbac.authorization.k8s.io                | clusterroles                             | create, delete, get, list, watch                                                 |
| rbac.authorization.k8s.io                | clusterrolebindings                      | create, delete, get, list, watch                                                 |
| rbac.authorization.k8s.io                | rolebindings                             | create, delete, get, list, watch                                                 |
| apiregistration.k8s.io                   | apiservices                              | *                                                                                |
| admissionregistration.k8s.io             | mutatingwebhookconfigurations            | *                                                                                |
| admissionregistration.k8s.io             | validatingwebhookconfigurations          | *                                                                                |
| certmanager.k8s.io                       | certificates                             | *                                                                                |
| certmanager.k8s.io                       | certificaterequests                      | *                                                                                |
| certmanager.k8s.io                       | orders                                   | *                                                                                |
| certmanager.k8s.io                       | challenges                               | *                                                                                |
| certmanager.k8s.io                       | clusterissuers                           | *                                                                                |
| certmanager.k8s.io                       | issuers                                  | *                                                                                |
| certmanager.k8s.io                       | certificates/status                      | update                                                                           |
| certmanager.k8s.io                       | certificaterequests/status               | update                                                                           |
| certmanager.k8s.io                       | challenges/status                        | update                                                                           |
| certmanager.k8s.io                       | orders/status                            | update                                                                           |
| certmanager.k8s.io                       | issuers/status                           | update                                                                           |
| certmanager.k8s.io                       | clusterissuers/status                    | update                                                                           |
| certmanager.k8s.io                       | certificates/finalizers                  | update                                                                           |
| certmanager.k8s.io                       | challenges/finalizers                    | update                                                                           |
| certmanager.k8s.io                       | ingresses/finalizers                     | update                                                                           |
| certmanager.k8s.io                       | orders/finalizers                        | update                                                                           |
| ""                                       | secrets                                  | create, delete, get, list, update, watch                                         |
| ""                                       | events                                   | create, patch                                                                    |
| ""                                       | serviceaccounts                          | list, watch                                                                      |
| ""                                       | pods                                     | create, delete, get, list, watch                                                 |
| ""                                       | services                                 | create, delete, get, list, watch                                                 |
| ""                                       | configmaps                               | create, delete, get, list, patch, update, watch                                  |
| ""                                       | namespaces                               | get, list, watch                                                                 |
| extensions                               | ingresses                                | create, delete, get, list, update, watch                                         |
| apps                                     | deployments                              | *                                                                                |
| apps                                     | statefulsets                             | *                                                                                |
| apps                                     | daemonsets                               | *                                                                                |
| admission.certmanager.k8s.io             | certificates                             | *                                                                                |
| admission.certmanager.k8s.io             | clusterissuers                           | *                                                                                |
| admission.certmanager.k8s.io             | issuers                                  | *                                                                                |
| admission.certmanager.k8s.io             | certificaterequests                      | *                                                                                |
| security.openshift.io                    | securitycontextconstraints               | use                                                                              |
| authorization.k8s.io                     | subjectaccessreviews                     | *                                                                                |
| operator.open-cluster-management.io      | multiclusterhubs                         | get, list, watch                                                                 |
| ibmcpcs.ibm.com                          | secretshares                             | list, watch                                                                      |

Namespace Permissions
--------------------------------------------------------------------------------
| Group                                    | Resource                                 | Verbs                                                                            |
| :--------------------------------------- | :--------------------------------------- | :------------------------------------------------------------------------------- |
| monitoring.coreos.com                    | servicemonitors                          | create, get                                                                      |
| apps                                     | deployments/finalizers                   | update                                                                           |
| apps                                     | replicasets                              | create, delete, get, list, patch, update, watch                                  |
| rbac.authorization.k8s.io                | roles                                    | create, delete, get, list, patch, update, watch                                  |
| ""                                       | serviceaccounts                          | create, delete, get, patch, update                                               |
| ibmcpcs.ibm.com                          | secretshares                             | create, get                                                                      |
