extra_breadcrumb_title_1: Operator Catalog
extra_breadcrumb_title_2: IBM Maximo Operator Catalog
extra_breadcrumb_url_2: ../
nav_title: Operator Catalog

IBM Maximo Operator Catalog v8 (220927)
===============================================================================

Details
-------------------------------------------------------------------------------

<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v8-220927-amd64</tr></tr>
  <tr><td>Digest</td><td>sha256:37d492a851137567bcfea0b5530fca05374a08a78b41afb712e17c2542016ae7</tr></tr>
</table>

Other IBM content curated from `icr.io/cpopen/ibm-operator-catalog@sha256:9c7552673a8d90bfe1da16dd8c28288b00cf6ffd6bad6edb26042c2991f266e0`

!!! warning
    This catalog is only certified for use on OpenShift Container Platform versions 4.8, 4.9, & 4.10, which have all reached end of support as of **September 10th, 2023**.  For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/)

!!! warning
    This release of the catalog is no longer supported due to the shutdown of IBM User Data Services, the first operator catalog release that supports it's replacement (IBM Data Reporter Operator) is the [February 2024 update](v8-240227-amd64.md)


Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v8-220927-amd64.yaml`


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v8-220927-amd64)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:37d492a851137567bcfea0b5530fca05374a08a78b41afb712e17c2542016ae7
  priority: 90
```


OpenShift Container Platform Support
-------------------------------------------------------------------------------
IBM Maximo Application Suite will run anywhere that you can run a supported OpenShift release on AMD64 architecture, including:

- [AWS](https://aws.amazon.com/rosa/)
- [Azure](https://azure.microsoft.com/en-gb/services/openshift/)
- [Google Cloud Platform](https://cloud.google.com/architecture/partners/openshift-on-gcp)
- [IBM Cloud](https://www.ibm.com/cloud/openshift)

| Package                      | OCP Release |
| ---------------------------- | ------------|
| Maximo Application Suite 8.8 | 4.8-4.10    |
| Maximo Application Suite 8.7 | 4.6-4.8     |
| Maximo Application Suite 8.6 | 4.6         |
| [Cloud Pak Foundational Services 3.20.1](https://www.ibm.com/docs/en/cpfs?topic=operator-supported-openshift-versions-platforms)* | 4.6-4.11 |
| [Cloud Pak For Data 2.0.8](https://www.ibm.com/docs/en/cloud-paks/cp-data/4.0?topic=requirements-software) | 4.6, 4.8 |
| [AppConnect 3.1.0](https://www.ibm.com/support/pages/node/6239294) | 4.6-4.8 |
| [AppConnect 4.2.0](https://www.ibm.com/support/pages/node/6239294) | 4.6-4.8, 4.10 |
| [AppConnect 5.2.0](https://www.ibm.com/support/pages/node/6239294) | 4.10 |

!!! warning
    Note the following [limitations](https://www.ibm.com/docs/en/cpfs?topic=operator-supported-openshift-versions-platforms) with Cloud Pak Foundational Services OCP support:

    - User Data Services (UDS) is supported on Linux® x86_64 and OpenShift Container Platform versions 4.6, 4.7 and 4.8 only.
    - DB2, which is installed with ibm-db2u-operator, is supported on OpenShift Container Platform versions 4.6, 4.7, 4.8, and 4.9 only.


Manifest
-------------------------------------------------------------------------------

### IBM Maximo Application Suite
| Package                  | Default Channel   | Channel   | Latest Version   |
|--------------------------|-------------------|-----------|------------------|
| ibm-mas                  | 8.8.x             | 8.6.x     | 8.6.4            |
|                          |                   | 8.7.x     | 8.7.4            |
|                          |                   | 8.8.x     | 8.8.1            |
| ibm-mas-assist           | 8.5.x             | 8.3.x     | 8.3.0            |
|                          |                   | 8.4.x     | 8.4.0            |
|                          |                   | 8.5.x     | 8.5.0            |
| ibm-mas-hputilities      | 8.4.x             | 8.2.x     | 8.2.2            |
|                          |                   | 8.3.x     | 8.3.1            |
|                          |                   | 8.4.x     | 8.4.0            |
| ibm-mas-iot              | 8.5.x             | 8.4.x     | 8.4.4            |
|                          |                   | 8.5.x     | 8.5.1            |
| ibm-mas-manage           | 8.4.x             | 8.2.x     | 8.2.3            |
|                          |                   | 8.3.x     | 8.3.4            |
|                          |                   | 8.4.x     | 8.4.1            |
| ibm-mas-monitor          | 8.8.x             | 8.6.x     | 8.6.4            |
|                          |                   | 8.7.x     | 8.7.3            |
|                          |                   | 8.8.x     | 8.8.1            |
| ibm-mas-mso              | 8.1.x             | 8.0.x     | 8.0.3            |
|                          |                   | 8.1.x     | 8.1.0            |
| ibm-mas-optimizer        | 8.2.x             | 8.2.x     | 8.2.1            |
| ibm-mas-predict          | 8.6.x             | 8.4.x     | 8.4.1            |
|                          |                   | 8.5.x     | 8.5.1            |
|                          |                   | 8.6.x     | 8.6.1            |
| ibm-mas-safety           | 8.3.x             | 8.2.x     | 8.2.2            |
|                          |                   | 8.3.x     | 8.3.0            |
| ibm-mas-visualinspection | 8.6.x             | 8.4.x     | 8.4.0            |
|                          |                   | 8.5.x     | 8.5.0            |
|                          |                   | 8.6.x     | 8.6.1            |


### IBM Utilities
| Package             | Default Channel   | Channel   | Latest Version   |
|---------------------|-------------------|-----------|------------------|
| ibm-data-dictionary | 1.x               | 1.0.x     | 1.0.0            |
|                     |                   | 1.1.x     | 1.1.0            |
|                     |                   | 1.x       | 1.1.0            |
| ibm-sls             | 3.x               | 3.x       | 3.4.1            |
| ibm-truststore-mgr  | 1.x               | 1.x       | 1.3.0            |


### IBM Cloud Pak Foundational Services
| Package                         | Default Channel   | Channel                  | Latest Version   |
|---------------------------------|-------------------|--------------------------|------------------|
| db2u-operator                   | v2.1              | v1.0                     | 1.0.9            |
|                                 |                   | v1.1                     | 1.1.9            |
|                                 |                   | v2.0                     | 2.0.0            |
|                                 |                   | v2.1                     | 2.1.0            |
| ibm-cert-manager-operator       | v3.20             | beta                     | 3.9.0            |
|                                 |                   | v3                       | 3.9.0            |
|                                 |                   | v3.20                    | 3.22.0           |
| ibm-common-service-operator     | v3.20             | beta                     | 103.103.103      |
|                                 |                   | v3                       | 3.9.0            |
|                                 |                   | v3.20                    | 3.20.1           |
| ibm-events-operator             | v3                | beta                     | 3.7.1            |
|                                 |                   | v3                       | 4.2.1            |
| ibm-licensing-operator-app      | v3.20             | beta                     | 1.4.1            |
|                                 |                   | v3                       | 1.9.0            |
|                                 |                   | v3.20                    | 1.17.0           |
| ibm-namespace-scope-operator    | v3.20             | beta                     | 1.1.1            |
|                                 |                   | v3                       | 1.9.0            |
|                                 |                   | v3.20                    | 1.14.0           |
| ibm-odlm                        | v3.20             | beta                     | 1.5.0            |
|                                 |                   | v3                       | 1.9.0            |
|                                 |                   | v3.20                    | 1.18.0           |
| ibm-user-data-services-operator | alpha             | alpha                    | 2.0.8            |
| ibm-zen-operator                | v3.20             | beta                     | 1.0.1            |
|                                 |                   | v3                       | 1.5.4            |
|                                 |                   | v3-after-breaking-change | 1.6.4            |
|                                 |                   | v3.20                    | 1.7.1            |


### IBM Cloud Pak for Data
| Package                       | Default Channel   | Channel   | Latest Version   |
|-------------------------------|-------------------|-----------|------------------|
| analyticsengine-operator      | v2.2              | beta      | 1.0.1            |
|                               |                   | stable-v1 | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
| cpd-platform-operator         | v3.1              | beta      | 2.0.0            |
|                               |                   | stable-v1 | 2.0.0            |
|                               |                   | v2.0      | 2.0.8            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
| ibm-cpd-ccs                   | v2.2              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
| ibm-cpd-datarefinery          | v2.2              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
| ibm-cpd-wml-operator          | v2.2              | alpha     | 1.1.0            |
|                               |                   | beta      | 1.0.1486         |
|                               |                   | v1.1      | 1.1.8            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
| ibm-cpd-wos                   | v2.2              | alpha     | 1.2.0            |
|                               |                   | v1        | 1.5.0            |
|                               |                   | v1.5      | 1.5.4            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
| ibm-cpd-ws-runtimes           | v5.2              | v1.0      | 1.0.9            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
|                               |                   | v5.2      | 5.2.0            |
| ibm-cpd-wsl                   | v3.2              | v2.0      | 2.0.9            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
| ibm-elasticsearch-operator    | v1.1              | v1.1      | 1.1.969          |
| ibm-etcd-operator             | v1.0              | v1.0      | 1.0.8            |
| ibm-minio-operator            | v1.0              | v1.0      | 1.0.9            |
| ibm-model-train-operator      | v1.1              | v1.1      | 1.1.3            |
| ibm-rabbitmq-operator         | v1.0              | v1.0      | 1.0.9            |
| ibm-watson-discovery-operator | v4.6              | v4.0      | 4.0.9            |
|                               |                   | v4.5      | 4.5.0            |
|                               |                   | v4.6      | 4.6.0            |
| ibm-watson-gateway-operator   | v1.0              | v1.0      | 1.0.9            |


### IBM AppConnect
| Package          | Default Channel   | Channel   | Latest Version   |
|------------------|-------------------|-----------|------------------|
| couchdb-operator | v2.2              | beta      | 1.4.2            |
|                  |                   | stable    | 2.2.1            |
|                  |                   | v1.0      | 1.0.14           |
|                  |                   | v1.1      | 1.1.0            |
|                  |                   | v1.2      | 1.2.1            |
|                  |                   | v1.3      | 1.3.1            |
|                  |                   | v1.4      | 1.4.4            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.0.1            |
|                  |                   | v2.2      | 2.2.1            |
| ibm-appconnect   | v5.2              | cd        | 5.2.0            |
|                  |                   | v1.0      | 1.0.5            |
|                  |                   | v1.1-eus  | 1.1.9            |
|                  |                   | v1.2      | 1.2.0            |
|                  |                   | v1.3      | 1.3.2            |
|                  |                   | v1.4      | 1.4.0            |
|                  |                   | v1.5      | 1.5.2            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.1.0            |
|                  |                   | v3.0      | 3.0.0            |
|                  |                   | v3.1      | 3.1.0            |
|                  |                   | v4.0      | 4.0.0            |
|                  |                   | v4.1      | 4.1.0            |
|                  |                   | v4.2      | 4.2.0            |
|                  |                   | v5.0-lts  | 5.0.0            |
|                  |                   | v5.1      | 5.1.0            |
|                  |                   | v5.2      | 5.2.0            |
