extra_breadcrumb_title_1: Operator Catalog
extra_breadcrumb_title_2: IBM Maximo Operator Catalog
extra_breadcrumb_url_2: ../
nav_title: Operator Catalog

IBM Maximo Operator Catalog v8 (230414)
===============================================================================

Details
-------------------------------------------------------------------------------

<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v8-230414-amd64</tr></tr>
  <tr><td>Digest</td><td>sha256:4e7a81ee11bd0667f1cadc1ea1da44865e412fb0597186cfc8baa9ceb3015592</tr></tr>
</table>

Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v8-230414-amd64.yaml`

!!! warning
    This catalog is only certified for use on OpenShift Container Platform versions 4.8, 4.9, & 4.10, which have all reached end of support as of **September 10th, 2023**.  For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/)

!!! warning
    This release of the catalog is no longer supported due to the shutdown of IBM User Data Services, the first operator catalog release that supports it's replacement (IBM Data Reporter Operator) is the [February 2024 update](v8-240227-amd64.md)


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v8-230414-amd64)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:4e7a81ee11bd0667f1cadc1ea1da44865e412fb0597186cfc8baa9ceb3015592
  priority: 90
```

Red Hat OpenShift Container Platform Support
-------------------------------------------------------------------------------
IBM Maximo Application Suite will run anywhere that you can run a supported OpenShift release on AMD64 architecture, including:

- [AWS](https://aws.amazon.com/rosa/)
- [Azure](https://azure.microsoft.com/en-gb/services/openshift/)
- [Google Cloud Platform](https://cloud.google.com/architecture/partners/openshift-on-gcp)
- [IBM Cloud](https://www.ibm.com/cloud/openshift)

For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/).

<table class="compatabilityMatrix">
  <tr>
    <th>OCP</th><td rowspan="6" class="spacer"></td>
    <th>General Availability</th>
    <th>End of Support</th>
    <th>Supported MAS Releases</th>
  </tr>
  <tr>
    <td class="firstColumn">4.8</td>
    <td>July 27, 2021</td>
    <td>January 27, 2023</td>
    <td>8.7 - 8.9</td>
  </tr>
  <tr>
    <td class="firstColumn">4.9<sup>1</sup></td>
    <td>October 18, 2021</td>
    <td>April 18, 2023</td>
    <td>8.8 - 8.9</td>
  </tr>
  <tr>
    <td class="firstColumn">4.10</td>
    <td>March 10, 2022</td>
    <td>September 10, 2023</td>
    <td>8.8 - 8.10</td>
  </tr>
</table>

1. Note that **IBM App Connect** and **IBM Cloud Pak for Data** do not support odd-numbered OpenShift releases, so if you intend to use Predict, HP Utilities, or Assist you are limited to use of the even numbered OCP releases.


IBM Cloud Pak for Data Compatibility
-------------------------------------------------------------------------------
Maximo application compatibility with Cloud Pak for Data (CP4D) is complicated by limited OpenShift Container Platform support in CP4D (only even numbered OCP releases are supported) and minor updates to CP4D services not always being backwards compatible.  For more information on Cloud Pak for Data's support policy review this [IBM Cloud Pak for Data Software Support Lifecycle Addendum](https://www.ibm.com/support/pages/node/6593147).

Cloud Pak for Data covers the following application's dependencies:

- **Assist**: Watson Discovery, Watson Text to Speak, Watson Speach to Text, Watson Assistant
- **Health & Predict Utilities**: Watson Studio
- **Predict**: Watson Studio, Watson Machine Learning, Watson Analytics Service, Watson Openscale

<table class="compatabilityMatrix">
  <tr>
    <th class="firstColumn" rowspan="2">OCP</th>
    <td rowspan="8" class="spacer"></td>
    <th colspan="3">Cloud Pak for Data</th>
    <td rowspan="9" class="spacer"></td>
    <th rowspan="2">Supported MAS Releases</th>
  </tr>
  <tr>
    <th class="firstColumn">Release</th>
    <th>General Availability</th>
    <th>End of Support</th>
  </tr>
  <tr> <td class="firstColumn" rowspan="3">4.8</td> <td>4.0.3</td>          <td>November 2021</td> <td>June, 2022</td>    <td>8.7<sup>1</sup></td>       </tr>
  <tr>                                              <td>4.0.6 - 4.0.7</td>  <td>February 2022</td> <td>June, 2022</td>    <td>8.7<sup>2</sup></td>       </tr>
  <tr>                                              <td>4.0.7 - 4.0.9</td>  <td>March 2022</td>    <td>June, 2022</td>    <td>8.8<sup>2</sup> - 8.9</td> </tr>
  <tr> <td class="firstColumn" rowspan="1">4.10</td><td>4.5</td>            <td>June, 2022</td>    <td>November 2022</td> <td>8.8<sup>3</sup> - 8.9</td> </tr>
  <tr> <td class="firstColumn" rowspan="1">4.10</td><td>4.6.3</td>            <td>February, 2023</td>    <td>TBD</td> <td>8.10</td> </tr>
</table>


1. Predict v8.4 is only compatible with CP4D v4.0.3 due to breaking changes in v4.0.4 (removes Python 3.7 runtime support)
2. Predict v8.5 is only compatible with CP4D v4.0.6 and v4.0.7 due to breaking changes in v4.0.8 (removes Python 3.8 runtime support)
3. CP4D v4.5 support added to MAS 8.8 in the November 2022 maintenance updates (HP Utilities v8.4.1, Assist v8.5.2, Predict v8.6.2)


IBM App Connect Compatibility
-------------------------------------------------------------------------------
Health and Predict Utilities compatibility with IBM App Connect is complicated by limited OpenShift Container Platform support and need to manage an explicit license inside each operand.  For more information review the material in [IBM App Connect Enterprise certified container versions](https://www.ibm.com/support/pages/ibm-app-connect-enterprise-certified-container-versions) (also available [here](https://www.ibm.com/support/pages/node/6239294)) and [Licensing reference for IBM App Connect Operator](https://www.ibm.com/docs/en/app-connect/containers_cd?topic=resources-licensing-reference-app-connect-operator).

<table class="compatabilityMatrix">
  <tr>
    <th class="firstColumn" rowspan="2">HP Utilities</th>
    <td rowspan="9" class="spacer"></td>
    <th rowspan="2">OCP</th>
    <td rowspan="9" class="spacer"></td>
    <th colspan="3">App Connect</th>
  </tr>
  <tr>
    <th>Operator</th>
    <th>Operand</th>
    <th>License</th>
  </tr>
  <tr>
    <td class="firstColumn" rowspan="2">8.4 - 8.5</td>
    <td>4.8</td>
    <td>4.1 - 4.2</td>
    <td rowspan="2">12.0.4</td>
    <td rowspan="2">L-APEH-C9NCK6</td>
  </tr>
  <tr>
    <td>4.10</td>
    <td>5.0 - 5.2</td>
  </tr>
</table>


Package Manifest
-------------------------------------------------------------------------------



### IBM Maximo Application Suite
| Package                  | Default Channel   | Channel   | Latest Version   |
|--------------------------|-------------------|-----------|------------------|
| ibm-mas                  | 8.10.x            | 8.10.x    | 8.10.0           |
|                          |                   | 8.8.x     | 8.8.8            |
|                          |                   | 8.9.x     | 8.9.4            |
| ibm-mas-assist           | 8.7.x             | 8.5.x     | 8.5.3            |
|                          |                   | 8.6.x     | 8.6.3            |
|                          |                   | 8.7.x     | 8.7.0            |
| ibm-mas-hputilities      | 8.6.x             | 8.4.x     | 8.4.1            |
|                          |                   | 8.5.x     | 8.5.2            |
|                          |                   | 8.6.x     | 8.6.0            |
| ibm-mas-iot              | 8.7.x             | 8.5.x     | 8.5.8            |
|                          |                   | 8.6.x     | 8.6.5            |
|                          |                   | 8.7.x     | 8.7.0            |
| ibm-mas-manage           | 8.6.x             | 8.4.x     | 8.4.8            |
|                          |                   | 8.5.x     | 8.5.4            |
|                          |                   | 8.6.x     | 8.6.0            |
| ibm-mas-monitor          | 8.10.x            | 8.10.x    | 8.10.0           |
|                          |                   | 8.8.x     | 8.8.4            |
|                          |                   | 8.9.x     | 8.9.4            |
| ibm-mas-optimizer        | 8.4.x             | 8.2.x     | 8.2.4            |
|                          |                   | 8.3.x     | 8.3.3            |
|                          |                   | 8.4.x     | 8.4.0            |
| ibm-mas-predict          | 8.8.x             | 8.6.x     | 8.6.2            |
|                          |                   | 8.7.x     | 8.7.2            |
|                          |                   | 8.8.x     | 8.8.0            |
| ibm-mas-visualinspection | 8.8.x             | 8.6.x     | 8.6.1            |
|                          |                   | 8.7.x     | 8.7.0            |
|                          |                   | 8.8.x     | 8.8.0            |


### IBM Utilities
| Package             | Default Channel   | Channel   | Latest Version   |
|---------------------|-------------------|-----------|------------------|
| ibm-data-dictionary | 1.1.x             | 1.1.x     | 1.1.3            |
| ibm-sls             | 3.x               | 3.x       | 3.6.0            |
| ibm-truststore-mgr  | 1.x               | 1.x       | 1.5.0            |


### IBM Cloud Pak Foundational Services
| Package                             | Default Channel   | Channel      | Latest Version   |
|-------------------------------------|-------------------|--------------|------------------|
| cloud-native-postgresql             | stable-v1.18      | fast         | 1.9.2            |
|                                     |                   | stable       | 1.9.2            |
|                                     |                   | stable-v1.15 | 1.9.2            |
|                                     |                   | stable-v1.17 | 1.9.2            |
|                                     |                   | stable-v1.18 | 1.9.2            |
| db2u-operator                       | v110508.0         | v1.0         | 1.0.9            |
|                                     |                   | v1.1         | 1.1.9            |
|                                     |                   | v110508.0    | 110508.0.0       |
|                                     |                   | v2.0         | 2.0.0            |
|                                     |                   | v2.1         | 2.1.0            |
|                                     |                   | v2.2         | 2.2.0            |
|                                     |                   | v3.0         | 3.0.0            |
|                                     |                   | v3.1         | 3.1.0            |
| ibm-cert-manager-operator           | v3.23             | beta         | 3.9.0            |
|                                     |                   | v3           | 3.9.0            |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.0           |
| ibm-common-service-operator         | v3.23             | beta         | 103.103.103      |
|                                     |                   | v3           | 3.9.0            |
|                                     |                   | v3.20        | 3.20.1           |
|                                     |                   | v3.21        | 3.21.0           |
|                                     |                   | v3.22        | 3.22.0           |
|                                     |                   | v3.23        | 3.23.0           |
| ibm-commonui-operator-app           | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.9.0            |
|                                     |                   | v3.20        | 1.18.1           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.0           |
| ibm-events-operator                 | v3                | beta         | 3.7.1            |
|                                     |                   | v3           | 4.4.0            |
| ibm-ingress-nginx-operator-app      | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.9.0            |
|                                     |                   | v3.20        | 1.17.1           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.0           |
| ibm-licensing-operator-app          | v3.23             | beta         | 1.4.1            |
|                                     |                   | v3           | 1.9.0            |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.0           |
| ibm-management-ingress-operator-app | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.9.0            |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.0           |
| ibm-mongodb-operator-app            | v3.23             | beta         | 1.3.1            |
|                                     |                   | v3           | 1.9.0            |
|                                     |                   | v3.20        | 1.15.0           |
|                                     |                   | v3.21        | 1.16.0           |
|                                     |                   | v3.22        | 1.17.0           |
|                                     |                   | v3.23        | 1.18.0           |
| ibm-namespace-scope-operator        | v3.23             | beta         | 1.1.1            |
|                                     |                   | v3           | 1.9.0            |
|                                     |                   | v3.20        | 1.14.0           |
|                                     |                   | v3.21        | 1.15.0           |
|                                     |                   | v3.22        | 1.16.0           |
|                                     |                   | v3.23        | 1.17.0           |
| ibm-odlm                            | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.9.0            |
|                                     |                   | v3.20        | 1.18.0           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.0           |
| ibm-platform-api-operator-app       | v3.23             | beta         | 3.9.1            |
|                                     |                   | v3           | 3.9.1            |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.0           |
| ibm-user-data-services-operator     | alpha             | alpha        | 2.0.9            |
| ibm-zen-operator                    | v3.23             | beta         | 1.0.1            |
|                                     |                   | v3           | 1.6.8            |
|                                     |                   | v3.20        | 1.7.1            |
|                                     |                   | v3.21        | 1.7.2            |
|                                     |                   | v3.22        | 1.8.0            |
|                                     |                   | v3.23        | 1.8.1            |


### IBM Cloud Pak for Data
| Package                       | Default Channel   | Channel   | Latest Version   |
|-------------------------------|-------------------|-----------|------------------|
| analyticsengine-operator      | v3.3              | beta      | 1.0.1            |
|                               |                   | stable-v1 | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
| cpd-platform-operator         | v3.6              | beta      | 2.0.0            |
|                               |                   | stable-v1 | 2.0.0            |
|                               |                   | v2.0      | 2.0.8            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v3.6      | 3.6.0            |
| ibm-ca-operator               | v23.3             | v22.0     | 22.0.0           |
|                               |                   | v22.1     | 22.1.0           |
|                               |                   | v22.2     | 22.2.0           |
|                               |                   | v22.3     | 22.3.0           |
|                               |                   | v23.0     | 23.0.0           |
|                               |                   | v23.1     | 23.1.0           |
|                               |                   | v23.3     | 23.3.0           |
|                               |                   | v4.0      | 4.0.8            |
| ibm-cpd-ccs                   | v6.3              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
| ibm-cpd-datarefinery          | v6.3              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
| ibm-cpd-spss                  | v6.3              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
| ibm-cpd-wml-operator          | v3.3              | alpha     | 1.1.0            |
|                               |                   | beta      | 1.0.1486         |
|                               |                   | v1.1      | 1.1.8            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
| ibm-cpd-wos                   | v3.3              | alpha     | 1.2.0            |
|                               |                   | v1        | 1.5.0            |
|                               |                   | v1.5      | 1.5.4            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
| ibm-cpd-ws-runtimes           | v6.3              | v1.0      | 1.0.9            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
| ibm-cpd-wsl                   | v6.3              | v2.0      | 2.0.9            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
| ibm-elasticsearch-operator    | v1.1              | v1.1      | 1.1.1336         |
| ibm-etcd-operator             | v1.0              | v1.0      | 1.0.8            |
| ibm-iam-operator              | v3.23             | beta      | 3.9.1            |
|                               |                   | v3        | 3.9.1            |
|                               |                   | v3.20     | 3.20.1           |
|                               |                   | v3.21     | 3.21.0           |
|                               |                   | v3.22     | 3.22.0           |
|                               |                   | v3.23     | 3.23.0           |
| ibm-minio-operator            | v1.0              | v1.0      | 1.0.9            |
| ibm-model-train-operator      | v1.1              | v1.1      | 1.1.7            |
| ibm-rabbitmq-operator         | v1.0              | v1.0      | 1.0.9            |
| ibm-watson-discovery-operator | v5.3              | v4.0      | 4.0.9            |
|                               |                   | v4.5      | 4.5.0            |
|                               |                   | v4.6      | 4.6.0            |
|                               |                   | v4.7      | 4.7.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
| ibm-watson-gateway-operator   | v1.0              | v1.0      | 1.0.9            |


### IBM AppConnect
| Package          | Default Channel   | Channel   | Latest Version   |
|------------------|-------------------|-----------|------------------|
| couchdb-operator | v2.2              | beta      | 1.4.2            |
|                  |                   | stable    | 2.2.1            |
|                  |                   | v1.0      | 1.0.14           |
|                  |                   | v1.1      | 1.1.0            |
|                  |                   | v1.2      | 1.2.1            |
|                  |                   | v1.3      | 1.3.1            |
|                  |                   | v1.4      | 1.4.4            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.0.1            |
|                  |                   | v2.2      | 2.2.1            |
| ibm-appconnect   | v7.1              | cd        | 5.2.0            |
|                  |                   | v1.0      | 1.0.5            |
|                  |                   | v1.1-eus  | 1.1.9            |
|                  |                   | v1.2      | 1.2.0            |
|                  |                   | v1.3      | 1.3.2            |
|                  |                   | v1.4      | 1.4.0            |
|                  |                   | v1.5      | 1.5.2            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.1.0            |
|                  |                   | v3.0      | 3.0.0            |
|                  |                   | v3.1      | 3.1.0            |
|                  |                   | v4.0      | 4.0.0            |
|                  |                   | v4.1      | 4.1.0            |
|                  |                   | v4.2      | 4.2.0            |
|                  |                   | v5.0-lts  | 5.0.4            |
|                  |                   | v5.1      | 5.1.0            |
|                  |                   | v5.2      | 5.2.0            |
|                  |                   | v6.0      | 6.0.0            |
|                  |                   | v6.1      | 6.1.1            |
|                  |                   | v6.2      | 6.2.0            |
|                  |                   | v7.0      | 7.0.0            |
|                  |                   | v7.1      | 7.1.0            |


### Eclipse Amlen
| Package                | Default Channel   | Channel   | Latest Version   |
|------------------------|-------------------|-----------|------------------|
| eclipse-amlen-operator | 1.x               | 1.x       | 1.0.0            |

