extra_breadcrumb_title_1: Operator Catalog
extra_breadcrumb_title_2: IBM Maximo Operator Catalog
extra_breadcrumb_url_2: ../
nav_title: Operator Catalog

IBM Maximo Operator Catalog v8 (230721)
===============================================================================

Details
-------------------------------------------------------------------------------

<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v8-230721-amd64</tr></tr>
  <tr><td>Digest</td><td>sha256:200df0fe4723d2ec40433be5793ee3afe341f966f66b7acaa1fb43b412c90848</tr></tr>
</table>

!!! note
    This catalog is a republish of the [v8-230627-amd64](v8-230627-amd64.md) catalog, it introduces only one new package - IBM User Data Services v2.0.11 - to fix a critical defect related to support for a recent update of Crunchy Postgres in the Red Hat Certified Operator Catalog.  For more information refer to [ibm-mas/ansible-devops#916](https://github.com/ibm-mas/ansible-devops/issues/916).

    It is recommended that all customers using earlier catalogs switch to this catalog as soon as possible to prevent potential issues when updating to newer Red Hat Certified Operator Catalog versions.  Customers running in a disconnected environment already using the [v8-230627-amd64](v8-230627-amd64.md) catalog will only need to mirror the new UDS images, because nothing else has changed.

!!! warning
    This release of the catalog is no longer supported due to the shutdown of IBM User Data Services, the first operator catalog release that supports it's replacement (IBM Data Reporter Operator) is the [February 2024 update](v8-240227-amd64.md)


Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v8-230721-amd64.yaml`


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v8-230721-amd64)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:200df0fe4723d2ec40433be5793ee3afe341f966f66b7acaa1fb43b412c90848
  priority: 90
```

Red Hat OpenShift Container Platform Support
-------------------------------------------------------------------------------
IBM Maximo Application Suite will run anywhere that you can run a supported OpenShift release on AMD64 architecture, including:

- [AWS](https://aws.amazon.com/rosa/)
- [Azure](https://azure.microsoft.com/en-gb/services/openshift/)
- [Google Cloud Platform](https://cloud.google.com/architecture/partners/openshift-on-gcp)
- [IBM Cloud](https://www.ibm.com/cloud/openshift)

For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/).

<table class="compatabilityMatrix">
  <tr>
    <th>OCP</th><td rowspan="6" class="spacer"></td>
    <th>General Availability</th>
    <th>End of Support</th>
    <th>Supported MAS Releases</th>
  </tr>
  <tr>
    <td class="firstColumn">4.10</td>
    <td>March 10, 2022</td>
    <td>September 10, 2023</td>
    <td>8.9 - 8.10</td>
  </tr>
  <tr>
    <td class="firstColumn">4.11<sup>1</sup></td>
    <td>August 10, 2022</td>
    <td>February 10, 2024</td>
    <td>8.9 - 8.10</td>
  </tr>
  <tr>
    <td class="firstColumn">4.12</td>
    <td>January 17, 2023</td>
    <td>January 17, 2025</td>
    <td>8.9 - 8.10</td>
  </tr>
</table>

 1. Note that **IBM App Connect** and **IBM Cloud Pak for Data** do not support odd-numbered OpenShift releases, so if you intend to use Predict, HP Utilities, or Assist you are limited to use of the even numbered OCP releases.



### Certified Operators
- `registry.redhat.io/redhat/certified-operator-index:v4.10`
- `registry.redhat.io/redhat/certified-operator-index:v4.11`
- `registry.redhat.io/redhat/certified-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **crunchy-postgres-operator** required by `ibm.mas_devops.uds` role
- **gpu-operator-certified** required by `ibm.mas_devops.nvidia_gpu` role
- **kubeturbo-certified** required by `ibm.mas_devops.kubeturbo` role


### Community Operators
- `registry.redhat.io/redhat/community-operator-index:v4.10`
- `registry.redhat.io/redhat/community-operator-index:v4.11`
- `registry.redhat.io/redhat/community-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **grafana-operator** required by `ibm.mas_devops.grafana` role
- **opentelemetry-operator** required by `ibm.mas_devops.opentelemetry` role


### Red Hat Operators
- `registry.redhat.io/redhat/redhat-operator-index:v4.10`
- `registry.redhat.io/redhat/redhat-operator-index:v4.11`
- `registry.redhat.io/redhat/redhat-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **amq-streams** (required by `ibm.mas_devops.kafka` role)
- **openshift-pipelines-operator-rh** required by the MAS CLI
- **nfd** required by `ibm.mas_devops.nvidia_gpu` role
- **aws-efs-csi-driver-operator**  required by `ibm.mas_devops.ocp_efs` role
- **local-storage-operator**  required by `ibm.mas_devops.ocs` role
- **ocs-operator**  required by `ibm.mas_devops.ocs` role (OCP 4.10)
- **odf-operator**  required by `ibm.mas_devops.ocs` role (OCP 4.11+)


IBM Cloud Pak for Data Compatibility
-------------------------------------------------------------------------------
Maximo application compatibility with Cloud Pak for Data (CP4D) is complicated by limited OpenShift Container Platform support in CP4D (only even numbered OCP releases are supported) and minor updates to CP4D services not always being backwards compatible.  For more information on Cloud Pak for Data's support policy review this [IBM Cloud Pak for Data Software Support Lifecycle Addendum](https://www.ibm.com/support/pages/node/6593147).

Cloud Pak for Data covers the following application's dependencies:

- **Assist**: Watson Discovery, Watson Text to Speak, Watson Speach to Text, Watson Assistant
- **Health & Predict Utilities**: Watson Studio
- **Predict**: Watson Studio, Watson Machine Learning, Watson Analytics Service, Watson Openscale

<table class="compatabilityMatrix">
  <tr>
    <th class="firstColumn" rowspan="2">OCP</th>
    <td rowspan="8" class="spacer"></td>
    <th colspan="3">Cloud Pak for Data</th>
    <td rowspan="9" class="spacer"></td>
    <th rowspan="2">Supported MAS Releases</th>
  </tr>
  <tr>
    <th class="firstColumn">Release</th>
    <th>General Availability</th>
    <th>End of Support</th>
  </tr>
  <tr> <td class="firstColumn" rowspan="1">4.10</td><td>4.6.3</td>            <td>February, 2023</td>    <td>TBD</td> <td>8.9 - 8.10</td> </tr>
</table>


IBM App Connect Compatibility
-------------------------------------------------------------------------------
Health and Predict Utilities compatibility with IBM App Connect is complicated by limited OpenShift Container Platform support and need to manage an explicit license inside each operand.  For more information review the material in [IBM App Connect Enterprise certified container versions](https://www.ibm.com/support/pages/ibm-app-connect-enterprise-certified-container-versions) (also available [here](https://www.ibm.com/support/pages/node/6239294)) and [Licensing reference for IBM App Connect Operator](https://www.ibm.com/docs/en/app-connect/containers_cd?topic=resources-licensing-reference-app-connect-operator).

<table class="compatabilityMatrix">
  <tr>
    <th class="firstColumn" rowspan="2">HP Utilities</th>
    <td rowspan="9" class="spacer"></td>
    <th rowspan="2">OCP</th>
    <td rowspan="9" class="spacer"></td>
    <th colspan="3">App Connect</th>
  </tr>
  <tr>
    <th>Operator</th>
    <th>Operand</th>
    <th>License</th>
  </tr>
  <tr>
    <td class="firstColumn">8.4 - 8.5</td>
    <td>4.10</td>
    <td>5.0 - 5.2</td>
    <td>12.0.4</td>
    <td>L-APEH-C9NCK6</td>
  </tr>
  <tr>
    <td class="firstColumn">8.6</td>
    <td>4.10,4.12 </td>
    <td>7.1</td>
    <td>12.0.7</td>
    <td>L-APEH-CJUCNR</td>
  </tr>
</table>


Package Manifest
-------------------------------------------------------------------------------


### IBM Maximo Application Suite
| Package                  | Default Channel   | Channel   | Latest Version   |
|--------------------------|-------------------|-----------|------------------|
| ibm-mas                  | 8.10.x            | 8.10.x    | 8.10.2           |
|                          |                   | 8.8.x     | 8.8.10           |
|                          |                   | 8.9.x     | 8.9.7            |
| ibm-mas-assist           | 8.7.x             | 8.5.x     | 8.5.3            |
|                          |                   | 8.6.x     | 8.6.4            |
|                          |                   | 8.7.x     | 8.7.1            |
| ibm-mas-hputilities      | 8.6.x             | 8.4.x     | 8.4.1            |
|                          |                   | 8.5.x     | 8.5.2            |
|                          |                   | 8.6.x     | 8.6.1            |
| ibm-mas-iot              | 8.7.x             | 8.5.x     | 8.5.8            |
|                          |                   | 8.6.x     | 8.6.7            |
|                          |                   | 8.7.x     | 8.7.2            |
| ibm-mas-manage           | 8.6.x             | 8.4.x     | 8.4.10           |
|                          |                   | 8.5.x     | 8.5.6            |
|                          |                   | 8.6.x     | 8.6.2            |
| ibm-mas-monitor          | 8.10.x            | 8.10.x    | 8.10.3           |
|                          |                   | 8.8.x     | 8.8.4            |
|                          |                   | 8.9.x     | 8.9.5            |
| ibm-mas-optimizer        | 8.4.x             | 8.2.x     | 8.2.4            |
|                          |                   | 8.3.x     | 8.3.3            |
|                          |                   | 8.4.x     | 8.4.1            |
| ibm-mas-predict          | 8.8.x             | 8.6.x     | 8.6.2            |
|                          |                   | 8.7.x     | 8.7.2            |
|                          |                   | 8.8.x     | 8.8.1            |
| ibm-mas-visualinspection | 8.8.x             | 8.6.x     | 8.6.1            |
|                          |                   | 8.7.x     | 8.7.1            |
|                          |                   | 8.8.x     | 8.8.1            |


### IBM Utilities
| Package             | Default Channel   | Channel   | Latest Version   |
|---------------------|-------------------|-----------|------------------|
| ibm-data-dictionary | 1.1.x             | 1.1.x     | 1.1.4            |
| ibm-sls             | 3.x               | 3.x       | 3.7.0            |
| ibm-truststore-mgr  | 1.x               | 1.x       | 1.5.0            |


### IBM Cloud Pak Foundational Services
| Package                             | Default Channel   | Channel      | Latest Version   |
|-------------------------------------|-------------------|--------------|------------------|
| cloud-native-postgresql             | stable-v1.18      | fast         | 1.18.2           |
|                                     |                   | stable       | 1.18.2           |
|                                     |                   | stable-v1.15 | 1.15.5           |
|                                     |                   | stable-v1.17 | 1.17.3           |
|                                     |                   | stable-v1.18 | 1.18.2           |
| db2u-operator                       | v110508.0         | v1.0         | 1.0.11           |
|                                     |                   | v1.1         | 1.1.13           |
|                                     |                   | v110508.0    | 110508.0.0       |
|                                     |                   | v2.0         | 2.0.0            |
|                                     |                   | v2.1         | 2.1.0            |
|                                     |                   | v2.2         | 2.2.0            |
|                                     |                   | v3.0         | 3.0.0            |
|                                     |                   | v3.1         | 3.1.0            |
|                                     |                   | v3.2         | 3.2.0            |
| ibm-cert-manager-operator           | v3.23             | beta         | 3.9.0            |
|                                     |                   | v3           | 3.25.2           |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.2           |
| ibm-common-service-operator         | v3.23             | beta         | 103.103.103      |
|                                     |                   | v3           | 3.19.10          |
|                                     |                   | v3.20        | 3.20.1           |
|                                     |                   | v3.21        | 3.21.0           |
|                                     |                   | v3.22        | 3.22.0           |
|                                     |                   | v3.23        | 3.23.2           |
| ibm-commonui-operator-app           | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.21.2           |
|                                     |                   | v3.20        | 1.18.1           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.2           |
| ibm-events-operator                 | v3                | beta         | 3.7.1            |
|                                     |                   | v3           | 4.6.0            |
| ibm-ingress-nginx-operator-app      | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.20.2           |
|                                     |                   | v3.20        | 1.17.1           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.2           |
| ibm-licensing-operator-app          | v3.23             | beta         | 1.4.1            |
|                                     |                   | v3           | 1.20.2           |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.2           |
| ibm-management-ingress-operator-app | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.20.2           |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.2           |
| ibm-mongodb-operator-app            | v3.23             | beta         | 1.3.1            |
|                                     |                   | v3           | 1.18.2           |
|                                     |                   | v3.20        | 1.15.0           |
|                                     |                   | v3.21        | 1.16.0           |
|                                     |                   | v3.22        | 1.17.0           |
|                                     |                   | v3.23        | 1.18.2           |
| ibm-namespace-scope-operator        | v3.23             | beta         | 1.1.1            |
|                                     |                   | v3           | 1.17.2           |
|                                     |                   | v3.20        | 1.14.0           |
|                                     |                   | v3.21        | 1.15.0           |
|                                     |                   | v3.22        | 1.16.0           |
|                                     |                   | v3.23        | 1.17.2           |
| ibm-odlm                            | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.21.2           |
|                                     |                   | v3.20        | 1.18.0           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.2           |
| ibm-platform-api-operator-app       | v3.23             | beta         | 3.9.1            |
|                                     |                   | v3           | 3.25.2           |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.2           |
| ibm-user-data-services-operator     | alpha             | alpha        | 2.0.11           |
| ibm-zen-operator                    | v3.23             | beta         | 1.0.1            |
|                                     |                   | v3           | 1.8.3            |
|                                     |                   | v3.20        | 1.7.1            |
|                                     |                   | v3.21        | 1.7.2            |
|                                     |                   | v3.22        | 1.8.0            |
|                                     |                   | v3.23        | 1.8.3            |


### IBM Cloud Pak for Data
| Package                       | Default Channel   | Channel   | Latest Version   |
|-------------------------------|-------------------|-----------|------------------|
| analyticsengine-operator      | v3.4              | beta      | 1.0.1            |
|                               |                   | stable-v1 | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
| cpd-platform-operator         | v3.7              | beta      | 2.0.0            |
|                               |                   | stable-v1 | 2.0.0            |
|                               |                   | v2.0      | 2.0.8            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v3.6      | 3.6.0            |
|                               |                   | v3.7      | 3.7.0            |
| ibm-ca-operator               | v23.4             | v22.0     | 22.0.0           |
|                               |                   | v22.1     | 22.1.0           |
|                               |                   | v22.2     | 22.2.0           |
|                               |                   | v22.3     | 22.3.0           |
|                               |                   | v23.0     | 23.0.0           |
|                               |                   | v23.1     | 23.1.0           |
|                               |                   | v23.3     | 23.3.0           |
|                               |                   | v23.4     | 23.4.0           |
|                               |                   | v4.0      | 4.0.8            |
| ibm-cpd-ccs                   | v6.4              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
| ibm-cpd-datarefinery          | v6.4              | v1.0      | 1.0.10           |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
| ibm-cpd-spss                  | v6.4              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
| ibm-cpd-wml-operator          | v3.4              | alpha     | 1.1.0            |
|                               |                   | beta      | 1.0.1486         |
|                               |                   | v1.1      | 1.1.8            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
| ibm-cpd-wos                   | v3.4              | alpha     | 1.2.0            |
|                               |                   | v1        | 1.5.0            |
|                               |                   | v1.5      | 1.5.4            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
| ibm-cpd-ws-runtimes           | v6.4              | v1.0      | 1.0.9            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
| ibm-cpd-wsl                   | v6.4              | v2.0      | 2.0.9            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
| ibm-elasticsearch-operator    | v1.1              | v1.1      | 1.1.1336         |
| ibm-etcd-operator             | v1.0              | v1.0      | 1.0.15           |
| ibm-iam-operator              | v3.23             | beta      | 3.9.1            |
|                               |                   | v3        | 3.23.2           |
|                               |                   | v3.20     | 3.20.1           |
|                               |                   | v3.21     | 3.21.0           |
|                               |                   | v3.22     | 3.22.0           |
|                               |                   | v3.23     | 3.23.2           |
| ibm-minio-operator            | v1.0              | v1.0      | 1.0.16           |
| ibm-model-train-operator      | v1.1              | v1.1      | 1.1.7            |
| ibm-rabbitmq-operator         | v1.0              | v1.0      | 1.0.17           |
| ibm-watson-discovery-operator | v5.3              | v4.0      | 4.0.9            |
|                               |                   | v4.5      | 4.5.0            |
|                               |                   | v4.6      | 4.6.0            |
|                               |                   | v4.7      | 4.7.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
| ibm-watson-gateway-operator   | v1.0              | v1.0      | 1.0.16           |


### IBM AppConnect
| Package          | Default Channel   | Channel   | Latest Version   |
|------------------|-------------------|-----------|------------------|
| couchdb-operator | v2.2              | beta      | 1.4.2            |
|                  |                   | stable    | 2.2.1            |
|                  |                   | v1.0      | 1.0.14           |
|                  |                   | v1.1      | 1.1.0            |
|                  |                   | v1.2      | 1.2.1            |
|                  |                   | v1.3      | 1.3.1            |
|                  |                   | v1.4      | 1.4.4            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.0.1            |
|                  |                   | v2.2      | 2.2.1            |
| ibm-appconnect   | v8.0              | cd        | 5.2.0            |
|                  |                   | v1.0      | 1.0.5            |
|                  |                   | v1.1-eus  | 1.1.10           |
|                  |                   | v1.2      | 1.2.0            |
|                  |                   | v1.3      | 1.3.2            |
|                  |                   | v1.4      | 1.4.0            |
|                  |                   | v1.5      | 1.5.2            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.1.0            |
|                  |                   | v3.0      | 3.0.0            |
|                  |                   | v3.1      | 3.1.0            |
|                  |                   | v4.0      | 4.0.0            |
|                  |                   | v4.1      | 4.1.0            |
|                  |                   | v4.2      | 4.2.0            |
|                  |                   | v5.0-lts  | 5.0.6            |
|                  |                   | v5.1      | 5.1.0            |
|                  |                   | v5.2      | 5.2.0            |
|                  |                   | v6.0      | 6.0.0            |
|                  |                   | v6.1      | 6.1.1            |
|                  |                   | v6.2      | 6.2.0            |
|                  |                   | v7.0      | 7.0.0            |
|                  |                   | v7.1      | 7.1.0            |
|                  |                   | v7.2      | 7.2.0            |
|                  |                   | v8.0      | 8.0.0            |


### Eclipse Amlen
| Package                | Default Channel   | Channel   | Latest Version   |
|------------------------|-------------------|-----------|------------------|
| eclipse-amlen-operator | 1.x               | 1.x       | 1.0.0            |
