extra_breadcrumb_title_1: Operator Catalog
extra_breadcrumb_title_2: IBM Maximo Operator Catalog
extra_breadcrumb_url_2: ../
nav_title: Operator Catalog

IBM Maximo Operator Catalog v8 (240130)
===============================================================================

Details
-------------------------------------------------------------------------------

<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v8-240130-amd64</tr></tr>
  <tr><td>Digest</td><td>sha256:7944a630ce47776338238717cb04ff98e1faf90087fd339708a0785c683326ca</tr></tr>
</table>

!!! warning
    This release of the catalog is no longer supported due to the shutdown of IBM User Data Services, the first operator catalog release that supports it's replacement (IBM Data Reporter Operator) is the [February 2024 update](v8-240227-amd64.md)


What's New
-------------------------------------------------------------------------------
- **End of support for OCP 4.11** Maintenance support for OCP 4.11 ends on [February 10th 2024](https://access.redhat.com/support/policy/updates/openshift/).  The [December 2023](v8-231228-amd64.md) Maximo Operator Catalog is the last to support the OCP 4.11 release; you must upgrade to OCP 4.12 before applying the January update.
- **Addition of IBM Spectrum Fusion operator to the catalog** The `isf-operator` package has been added to the catalog, this supports use of [IBM Spectrum Fusion storage classes](https://www.ibm.com/products/storage-fusion) with IBM Maximo Application Suite.
- **Migration to Red Hat Certificate-Manager**  Running `mas update` will automatically remove **IBM Certificate-Manager** from the `ibm-common-services` namespace and install **Red Hat Certificate-Manager** in it's place.
- **Security updates and bug fixes**
    - IBM Maximo Application Suite Core Platform v8.10 and v8.11
    - IBM Maximo Health & Predict Utilities v8.6
    - IBM Maximo IoT v8.7 and v8.8
    - IBM Maximo Manage v8.6 and v8.7
    - IBM Maximo Monitor v8.11
    - IBM Maximo Predict v8.9
    - IBM Data Dictionary v1.1
    - MongoDb Community Edition

!!! note
    Cluster adminstrators may notice messages appearing in their Openshift console indicating that an embedded open source component of a MAS dependency named "Crunchy Postgres for Kubernetes" [now requires a registration token in order to receive updates](https://access.crunchydata.com/documentation/postgres-operator/latest/installation/operatorhub#registration).

    Crunchy Postgres is included in MAS as part of the IBM User Data Services (UDS) service. UDS is a backend service that communicates AppPoint usage back to IBM. Crunchy Postgres is not used anywhere else in MAS and will not affect the day-to-day operation of MAS applications. Existing or new Postgres instances will continue to work without any issue, only future updates are gated by the need for a registration token.

    No action is required to register Crunchy Postgres.  In the February 2024 update this dependency will be eliminated entirely by the introduction of **IBM Data Reporter Operator** (DRO) as a replacement for UDS. We recommend customers pick up this update as soon as it becomes available rather than registering for Postgres updates.


Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v8-240130-amd64.yaml`


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v8-240130-amd64)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:7944a630ce47776338238717cb04ff98e1faf90087fd339708a0785c683326ca
  priority: 90
```

Red Hat OpenShift Container Platform Support
-------------------------------------------------------------------------------
IBM Maximo Application Suite will run anywhere that you can run a supported OpenShift release on AMD64 architecture, including:

- [AWS](https://aws.amazon.com/rosa/)
- [Azure](https://azure.microsoft.com/en-gb/services/openshift/)
- [Google Cloud Platform](https://cloud.google.com/architecture/partners/openshift-on-gcp)
- [IBM Cloud](https://www.ibm.com/cloud/openshift)

For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/).

IBM Maximo Application Suite customers receive a standard Red Hat OpenShift Container Platform subscription as part of their purchase. This includes 18 months of maintenance support for each OpenShift minor release.  A further 6 months support is available to purchase as an Extended Update Support (EUS) Add-on to x86-64 versions of Red Hat OpenShift Kubernetes Engine, Red Hat OpenShift Container Platform, and Red Hat OpenShift Platform Plus Standard subscriptions.

!!! note
    Extended Update Support is included with Premium subscriptions of x86-64 versions of Red Hat OpenShift Kubernetes Engine, Red Hat OpenShift Container Platform, and Red Hat OpenShift Platform Plus. Please contact your Red Hat Sales Representative if you are unsure if you have access to EUS and to help decide if it is appropriate for your environment.

<table class="compatabilityMatrix">
  <tr>
    <th>OCP</th><td rowspan="3" class="spacer"></td>
    <th>General Availability</th>
    <th>Standard Support</th>
    <th>Extended Support</th>
    <th>Supported MAS Releases</th>
  </tr>
  <tr>
    <td class="firstColumn">4.12</td>
    <td>January 17, 2023</td>
    <td>July 17, 2024</td>
    <td>January 17, 2025</td>
    <td>8.10 - 8.11</td>
  </tr>
</table>


### Certified Operators
- `registry.redhat.io/redhat/certified-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **crunchy-postgres-operator** required by `ibm.mas_devops.uds` role
- **gpu-operator-certified** required by `ibm.mas_devops.nvidia_gpu` role
- **kubeturbo-certified** required by `ibm.mas_devops.kubeturbo` role


### Community Operators
- `registry.redhat.io/redhat/community-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **grafana-operator** required by `ibm.mas_devops.grafana` role
- **opentelemetry-operator** required by `ibm.mas_devops.opentelemetry` role
- **strimzi-kafka-operator** required by `ibm.mas_devops.kafka` role (if using Strimzi as Kakfa provider)


### Red Hat Operators
- `registry.redhat.io/redhat/redhat-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **amq-streams** required by `ibm.mas_devops.kafka` role (if using AMQ Streams as Kakfa provider)
- **openshift-pipelines-operator-rh** required by the MAS CLI
- **nfd** required by `ibm.mas_devops.nvidia_gpu` role
- **aws-efs-csi-driver-operator**  required by `ibm.mas_devops.ocp_efs` role
- **local-storage-operator**  required by `ibm.mas_devops.ocs` role
- **odf-operator**  required by `ibm.mas_devops.ocs` role


IBM Cloud Pak for Data Compatibility
-------------------------------------------------------------------------------
For more information on Cloud Pak for Data's support policy review this [IBM Cloud Pak for Data Software Support Lifecycle Addendum](https://www.ibm.com/support/pages/node/6593147).

Cloud Pak for Data covers the following application's dependencies:

- **Assist**: Watson Discovery, Watson Text to Speak, Watson Speach to Text, Watson Assistant
- **Predict**: Watson Studio, Watson Machine Learning, Watson Analytics Service, Watson Openscale

<table class="compatabilityMatrix">
  <tr>
    <th class="firstColumn" rowspan="2">OCP</th>
    <td rowspan="8" class="spacer"></td>
    <th colspan="3">Cloud Pak for Data</th>
    <td rowspan="9" class="spacer"></td>
    <th rowspan="2">Supported MAS Releases</th>
  </tr>
  <tr>
    <th class="firstColumn">Release</th>
    <th>General Availability</th>
    <th>End of Support</th>
  </tr>
  <tr> <td class="firstColumn" rowspan="1">4.12</td><td>4.6.6</td>            <td>February, 2023</td>    <td>TBD</td> <td>8.9 - 8.11</td> </tr>
</table>


Package Manifest
-------------------------------------------------------------------------------



### IBM Maximo Application Suite
| Package                  | Default Channel   | Channel   | Latest Version   |
|--------------------------|-------------------|-----------|------------------|
| ibm-mas                  | 8.11.x            | 8.10.x    | 8.10.9           |
|                          |                   | 8.11.x    | 8.11.6           |
|                          |                   | 8.9.x     | 8.9.10           |
| ibm-mas-assist           | 8.8.x             | 8.6.x     | 8.6.5            |
|                          |                   | 8.7.x     | 8.7.2            |
|                          |                   | 8.8.x     | 8.8.1            |
| ibm-mas-hputilities      | 8.6.x             | 8.5.x     | 8.5.3            |
|                          |                   | 8.6.x     | 8.6.3            |
| ibm-mas-iot              | 8.8.x             | 8.6.x     | 8.6.9            |
|                          |                   | 8.7.x     | 8.7.8            |
|                          |                   | 8.8.x     | 8.8.4            |
| ibm-mas-manage           | 8.7.x             | 8.5.x     | 8.5.9            |
|                          |                   | 8.6.x     | 8.6.9            |
|                          |                   | 8.7.x     | 8.7.4            |
| ibm-mas-monitor          | 8.11.x            | 8.10.x    | 8.10.6           |
|                          |                   | 8.11.x    | 8.11.3           |
|                          |                   | 8.9.x     | 8.9.6            |
| ibm-mas-optimizer        | 8.5.x             | 8.3.x     | 8.3.3            |
|                          |                   | 8.4.x     | 8.4.2            |
|                          |                   | 8.5.x     | 8.5.1            |
| ibm-mas-predict          | 8.9.x             | 8.7.x     | 8.7.2            |
|                          |                   | 8.8.x     | 8.8.2            |
|                          |                   | 8.9.x     | 8.9.1            |
| ibm-mas-visualinspection | 8.9.x             | 8.7.x     | 8.7.1            |
|                          |                   | 8.8.x     | 8.8.1            |
|                          |                   | 8.9.x     | 8.9.0            |


### IBM Utilities
| Package             | Default Channel   | Channel   | Latest Version   |
|---------------------|-------------------|-----------|------------------|
| ibm-data-dictionary | 1.1.x             | 1.1.x     | 1.1.6            |
| ibm-sls             | 3.x               | 3.x       | 3.8.1            |
| ibm-truststore-mgr  | 1.x               | 1.x       | 1.5.1            |


### IBM Cloud Pak Foundational Services
| Package                             | Default Channel   | Channel      | Latest Version   |
|-------------------------------------|-------------------|--------------|------------------|
| cloud-native-postgresql             | stable-v1.18      | fast         | 1.18.3           |
|                                     |                   | stable       | 1.18.7           |
|                                     |                   | stable-v1.15 | 1.15.5           |
|                                     |                   | stable-v1.17 | 1.17.3           |
|                                     |                   | stable-v1.18 | 1.18.7           |
| ibm-cert-manager-operator           | v3.23             | beta         | 3.9.0            |
|                                     |                   | v3           | 3.25.10          |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.10          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-common-service-operator         | v3.23             | beta         | 103.103.103      |
|                                     |                   | v3           | 3.19.19          |
|                                     |                   | v3.20        | 3.20.1           |
|                                     |                   | v3.21        | 3.21.0           |
|                                     |                   | v3.22        | 3.22.0           |
|                                     |                   | v3.23        | 3.23.11          |
|                                     |                   | v4.0         | 4.0.1            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.0            |
|                                     |                   | v4.3         | 4.3.1            |
| ibm-commonui-operator-app           | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.21.11          |
|                                     |                   | v3.20        | 1.18.1           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.11          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.0            |
|                                     |                   | v4.3         | 4.3.0            |
| ibm-events-operator                 | v3                | beta         | 3.7.1            |
|                                     |                   | v3           | 4.9.0            |
| ibm-ingress-nginx-operator-app      | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.20.10          |
|                                     |                   | v3.20        | 1.17.1           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.10          |
| ibm-licensing-operator-app          | v3.23             | beta         | 1.4.1            |
|                                     |                   | v3           | 1.20.10          |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.10          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-management-ingress-operator-app | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.20.10          |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.10          |
| ibm-mongodb-operator-app            | v3.23             | beta         | 1.3.1            |
|                                     |                   | v3           | 1.18.10          |
|                                     |                   | v3.20        | 1.15.0           |
|                                     |                   | v3.21        | 1.16.0           |
|                                     |                   | v3.22        | 1.17.0           |
|                                     |                   | v3.23        | 1.18.10          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-namespace-scope-operator        | v3.23             | beta         | 1.1.1            |
|                                     |                   | v3           | 1.17.10          |
|                                     |                   | v3.20        | 1.14.0           |
|                                     |                   | v3.21        | 1.15.0           |
|                                     |                   | v3.22        | 1.16.0           |
|                                     |                   | v3.23        | 1.17.10          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-odlm                            | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.21.10          |
|                                     |                   | v3.20        | 1.18.0           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.10          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.2            |
| ibm-platform-api-operator-app       | v3.23             | beta         | 3.9.1            |
|                                     |                   | v3           | 3.25.10          |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.10          |
| ibm-user-data-services-operator     | alpha             | alpha        | 2.0.12           |
| ibm-zen-operator                    | v3.23             | beta         | 1.0.1            |
|                                     |                   | v3           | 1.8.11           |
|                                     |                   | v3.20        | 1.7.1            |
|                                     |                   | v3.21        | 1.7.2            |
|                                     |                   | v3.22        | 1.8.0            |
|                                     |                   | v3.23        | 1.8.11           |
|                                     |                   | v4.0         | 5.0.0            |
|                                     |                   | v4.1         | 5.0.1            |
|                                     |                   | v4.2         | 5.0.2            |
|                                     |                   | v4.3         | 5.1.0            |
| isf-operator                        | v2.0              | v2.0         | 2.7.1            |


### IBM Cloud Pak for Data
| Package                       | Default Channel   | Channel   | Latest Version   |
|-------------------------------|-------------------|-----------|------------------|
| analyticsengine-operator      | v5.1              | beta      | 1.0.1            |
|                               |                   | stable-v1 | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v4.1      | 4.1.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v4.3      | 4.3.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
| cpd-platform-operator         | v5.1              | beta      | 2.0.0            |
|                               |                   | stable-v1 | 2.0.0            |
|                               |                   | v2.0      | 2.0.8            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v3.6      | 3.6.0            |
|                               |                   | v3.7      | 3.7.0            |
|                               |                   | v3.8      | 3.8.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v4.1      | 4.1.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v4.3      | 4.3.0            |
|                               |                   | v4.4      | 4.4.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
| ibm-ca-operator               | v25.0             | v22.0     | 22.0.0           |
|                               |                   | v22.1     | 22.1.0           |
|                               |                   | v22.2     | 22.2.0           |
|                               |                   | v22.3     | 22.3.0           |
|                               |                   | v23.0     | 23.0.0           |
|                               |                   | v23.1     | 23.1.0           |
|                               |                   | v23.3     | 23.3.0           |
|                               |                   | v23.4     | 23.4.0           |
|                               |                   | v23.5     | 23.5.0           |
|                               |                   | v24.0     | 24.0.0           |
|                               |                   | v24.3     | 24.3.0           |
|                               |                   | v25.0     | 25.0.0           |
|                               |                   | v4.0      | 4.0.8            |
| ibm-cpd-ccs                   | v8.1              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v7.1      | 7.1.0            |
|                               |                   | v7.2      | 7.2.0            |
|                               |                   | v7.3      | 7.3.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-datarefinery          | v8.1              | v1.0      | 1.0.10           |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-spss                  | v8.1              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-wml-operator          | v5.1              | alpha     | 1.1.0            |
|                               |                   | beta      | 1.0.1486         |
|                               |                   | v1.1      | 1.1.8            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
| ibm-cpd-wos                   | v5.0              | alpha     | 1.2.0            |
|                               |                   | v1        | 1.5.0            |
|                               |                   | v1.5      | 1.5.4            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v5.0      | 5.0.0            |
| ibm-cpd-ws-runtimes           | v8.1              | v1.0      | 1.0.9            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-wsl                   | v8.1              | v2.0      | 2.0.9            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-elasticsearch-operator    | v1.1              | v1.1      | 1.1.1845         |
| ibm-etcd-operator             | v1.0              | v1.0      | 1.0.22           |
| ibm-iam-operator              | v3.23             | beta      | 3.9.1            |
|                               |                   | v3        | 3.23.11          |
|                               |                   | v3.20     | 3.20.1           |
|                               |                   | v3.21     | 3.21.0           |
|                               |                   | v3.22     | 3.22.0           |
|                               |                   | v3.23     | 3.23.11          |
|                               |                   | v4.0      | 4.0.1            |
|                               |                   | v4.1      | 4.1.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v4.3      | 4.3.1            |
| ibm-minio-operator            | v1.0              | v1.0      | 1.0.18           |
| ibm-model-train-operator      | v1.1              | v1.1      | 1.1.13           |
| ibm-rabbitmq-operator         | v1.0              | v1.0      | 1.0.22           |
| ibm-watson-discovery-operator | v7.0              | v4.0      | 4.0.9            |
|                               |                   | v4.5      | 4.5.0            |
|                               |                   | v4.6      | 4.6.0            |
|                               |                   | v4.7      | 4.7.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
|                               |                   | v5.5      | 5.5.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v7.0      | 7.0.0            |
| ibm-watson-gateway-operator   | v1.0              | v1.0      | 1.0.22           |


### IBM Db2 Universal Operator
| Package        | Default Channel   | Channel      | Latest Version   |
|----------------|-------------------|--------------|------------------|
| db2u-operator  | v110509.0         | v1.0         | 1.0.11           |
|                |                   | v1.1         | 1.1.13           |
|                |                   | v110508.0    | 110508.0.3       |
|                |                   | v110509.0    | 110509.0.0       |
|                |                   | v2.0         | 2.0.0            |
|                |                   | v2.1         | 2.1.0            |
|                |                   | v2.2         | 2.2.0            |
|                |                   | v3.0         | 3.0.0            |
|                |                   | v3.1         | 3.1.0            |
|                |                   | v3.2         | 3.2.0            |
|                |                   | v4.0         | 4.0.0            |
|                |                   | v4.1         | 4.1.0            |
|                |                   | v4.2         | 4.2.0            |
|                |                   | v5.0         | 5.0.0            |


### IBM AppConnect
| Package          | Default Channel   | Channel   | Latest Version   |
|------------------|-------------------|-----------|------------------|
| couchdb-operator | v2.2              | beta      | 1.4.2            |
|                  |                   | stable    | 2.2.1            |
|                  |                   | v1.0      | 1.0.14           |
|                  |                   | v1.1      | 1.1.0            |
|                  |                   | v1.2      | 1.2.1            |
|                  |                   | v1.3      | 1.3.1            |
|                  |                   | v1.4      | 1.4.4            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.0.1            |
|                  |                   | v2.2      | 2.2.1            |
| ibm-appconnect   | v11.1             | cd        | 5.2.0            |
|                  |                   | v1.0      | 1.0.5            |
|                  |                   | v1.1-eus  | 1.1.10           |
|                  |                   | v1.2      | 1.2.0            |
|                  |                   | v1.3      | 1.3.2            |
|                  |                   | v1.4      | 1.4.0            |
|                  |                   | v1.5      | 1.5.2            |
|                  |                   | v10.0     | 10.0.1           |
|                  |                   | v10.1     | 10.1.1           |
|                  |                   | v11.0     | 11.0.1           |
|                  |                   | v11.1     | 11.1.0           |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.1.0            |
|                  |                   | v3.0      | 3.0.0            |
|                  |                   | v3.1      | 3.1.0            |
|                  |                   | v4.0      | 4.0.0            |
|                  |                   | v4.1      | 4.1.0            |
|                  |                   | v4.2      | 4.2.0            |
|                  |                   | v5.0-lts  | 5.0.13           |
|                  |                   | v5.1      | 5.1.0            |
|                  |                   | v5.2      | 5.2.0            |
|                  |                   | v6.0      | 6.0.0            |
|                  |                   | v6.1      | 6.1.1            |
|                  |                   | v6.2      | 6.2.0            |
|                  |                   | v7.0      | 7.0.0            |
|                  |                   | v7.1      | 7.1.0            |
|                  |                   | v7.2      | 7.2.0            |
|                  |                   | v8.0      | 8.0.0            |
|                  |                   | v8.1      | 8.1.0            |
|                  |                   | v8.2      | 8.2.1            |
|                  |                   | v9.0      | 9.0.0            |
|                  |                   | v9.1      | 9.1.0            |
|                  |                   | v9.2      | 9.2.1            |


### Eclipse Amlen
| Package                | Default Channel   | Channel   | Latest Version   |
|------------------------|-------------------|-----------|------------------|
| eclipse-amlen-operator | 1.x               | 1.x       | 1.0.2            |
