extra_breadcrumb_title_1: Operator Catalog
extra_breadcrumb_title_2: IBM Maximo Operator Catalog
extra_breadcrumb_url_2: ../
nav_title: Operator Catalog

IBM Maximo Operator Catalog v8 (240326)
===============================================================================

Details
-------------------------------------------------------------------------------

<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v8-240326-amd64</tr></tr>
  <tr><td>Digest</td><td>sha256:9c891bb6fa8496e1ef514d29b253bf5b1e817fe95963f6e536170688aa95f1d2</tr></tr>
</table>

!!! important
    ibm-mas 8.11.8 in this catalog has a known issue with high severity [DT378321](https://www.ibm.com/mysupport/aCIKe0000008OiX). We are releasing `v8-240405-amd64` catalog with ibm-mas 8.11.9 to fix this issue. Please use MAS CLI versions v7.19.0 or newer to install the newer MAS 8.11.x. We advice to skip ibm-mas 8.11.8 in this catalog and use ibm-mas 8.11.9.

What's New
-------------------------------------------------------------------------------
- **Support Red Hat® OpenShift® 4.13.x and 4.14.x versions** Added support for Red Hat® OpenShift® 4.13.x and 4.14.x versions.
- **Support for IBM Storage Fusion and IBM Storage Fusion HCI** IBM Maximo Application Suite now supports IBM Storage Fusion and IBM Storage Fusion HCI. IBM Storage Fusion is a container-native hybrid cloud data platform that offers simplified deployment and data management for Kubernetes applications on Red Hat® OpenShift® Container Platform.
- **Security updates and bug fixes**
    - IBM Maximo Application Suite Core Platform v8.10 and v8.11
    - IBM Maximo IoT v8.7 and v8.8
    - IBM Maximo Manage v8.6 and v8.7
    - IBM Maximo Monitor v8.11 and v8.10
    - IBM Maximo Optimizer v8.5 and v8.4
    - Security updates in base image and python modules
    - [DT269166](https://www.ibm.com/mysupport/aCI3p000000LIvt) - Scimsync-agent performance improvements
    - [DT364099](https://www.ibm.com/mysupport/aCIKe0000004CAG) - Change the permission for the API that assigns a user to a workspace


Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v8-240326-amd64.yaml`


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v8-240326-amd64)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:9c891bb6fa8496e1ef514d29b253bf5b1e817fe95963f6e536170688aa95f1d2
  priority: 90
```

Red Hat OpenShift Container Platform Support
-------------------------------------------------------------------------------
IBM Maximo Application Suite will run anywhere that you can run a supported OpenShift release on AMD64 architecture, including:

- [AWS](https://aws.amazon.com/rosa/)
- [Azure](https://azure.microsoft.com/en-gb/services/openshift/)
- [Google Cloud Platform](https://cloud.google.com/architecture/partners/openshift-on-gcp)
- [IBM Cloud](https://www.ibm.com/cloud/openshift)

For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/).

IBM Maximo Application Suite customers receive a standard Red Hat OpenShift Container Platform subscription as part of their purchase. This includes 18 months of maintenance support for each OpenShift minor release.  A further 6 months support is available to purchase as an Extended Update Support (EUS) Add-on to x86-64 versions of Red Hat OpenShift Kubernetes Engine, Red Hat OpenShift Container Platform, and Red Hat OpenShift Platform Plus Standard subscriptions.

!!! note
    Extended Update Support is included with Premium subscriptions of x86-64 versions of Red Hat OpenShift Kubernetes Engine, Red Hat OpenShift Container Platform, and Red Hat OpenShift Platform Plus. Please contact your Red Hat Sales Representative if you are unsure if you have access to EUS and to help decide if it is appropriate for your environment.

<table class="compatabilityMatrix">
  <tr>
    <th>OCP</th><td rowspan="4" class="spacer"></td>
    <th>General Availability</th>
    <th>Standard Support</th>
    <th>Extended Support</th>
    <th>Supported MAS Releases</th>
  </tr>
  <tr>
    <td class="firstColumn">4.14</td>
    <td>October 31, 2023</td>
    <td>May 1, 2025</td>
    <td>October 31, 2026</td>
    <td>8.10 - 8.11</td>
  </tr>
  <tr>
    <td class="firstColumn">4.13</td>
    <td>May 17, 2023</td>
    <td>November 17, 2024</td>
    <td>N/A</td>
    <td>8.10 - 8.11</td>
  </tr>
  <tr>
    <td class="firstColumn">4.12</td>
    <td>January 17, 2023</td>
    <td>July 17, 2024</td>
    <td>January 17, 2025</td>
    <td>8.10 - 8.11</td>
  </tr>
</table>


### Certified Operators
- `registry.redhat.io/redhat/certified-operator-index:v4.14`
- `registry.redhat.io/redhat/certified-operator-index:v4.13`
- `registry.redhat.io/redhat/certified-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **gpu-operator-certified** required by `ibm.mas_devops.nvidia_gpu` role
- **kubeturbo-certified** required by `ibm.mas_devops.kubeturbo` role


### Community Operators
- `registry.redhat.io/redhat/community-operator-index:v4.14`
- `registry.redhat.io/redhat/community-operator-index:v4.13`
- `registry.redhat.io/redhat/community-operator-index:v4.12`

The following packages from this catalog are used in the Maximo Application Suite install:

- **grafana-operator** required by `ibm.mas_devops.grafana` role
- **opentelemetry-operator** required by `ibm.mas_devops.opentelemetry` role
- **strimzi-kafka-operator** required by `ibm.mas_devops.kafka` role (if using Strimzi as Kakfa provider)


### Red Hat Operators
- `registry.redhat.io/redhat/redhat-operator-index:v4.13`
- `registry.redhat.io/redhat/redhat-operator-index:v4.14`

The following packages from these catalogs are used in the Maximo Application Suite install:

- **amq-streams** required by `ibm.mas_devops.kafka` role (if using AMQ Streams as Kakfa provider)
- **openshift-pipelines-operator-rh** required by the MAS CLI
- **nfd** required by `ibm.mas_devops.nvidia_gpu` role
- **aws-efs-csi-driver-operator**  required by `ibm.mas_devops.ocp_efs` role
- **local-storage-operator**  required by `ibm.mas_devops.ocs` role
- **odf-operator**  required by `ibm.mas_devops.ocs` role


IBM Cloud Pak for Data Compatibility
-------------------------------------------------------------------------------
For more information on Cloud Pak for Data's support policy review this [IBM Cloud Pak for Data Software Support Lifecycle Addendum](https://www.ibm.com/support/pages/node/6593147).

Cloud Pak for Data covers the following application's dependencies:

- **Assist**: Watson Discovery, Watson Text to Speak, Watson Speach to Text, Watson Assistant
- **Predict**: Watson Studio, Watson Machine Learning, Watson Analytics Service, Watson Openscale

<table class="compatabilityMatrix">
  <tr>
    <th class="firstColumn" rowspan="2">OCP</th>
    <td rowspan="8" class="spacer"></td>
    <th colspan="3">Cloud Pak for Data</th>
    <td rowspan="9" class="spacer"></td>
    <th rowspan="2">Supported MAS Releases</th>
  </tr>
  <tr>
    <th class="firstColumn">Release</th>
    <th>General Availability</th>
    <th>End of Support</th>
  </tr>
  <tr> <td class="firstColumn" rowspan="1">4.14</td><td>4.6.6</td>            <td>March, 2024</td>    <td>TBD</td> <td>8.10 - 8.11</td></tr>
  <tr> <td class="firstColumn" rowspan="1">4.13</td><td>4.6.6</td>            <td>March, 2024</td>    <td>TBD</td> <td>8.10 - 8.11</td></tr>
  <tr> <td class="firstColumn" rowspan="1">4.12</td><td>4.6.6</td>            <td>February, 2023</td>    <td>February, 2024</td> <td>8.9 - 8.11</td> </tr>
</table>


Package Manifest
-------------------------------------------------------------------------------



### IBM Maximo Application Suite
| Package                  | Default Channel   | Channel   | Latest Version   |
|--------------------------|-------------------|-----------|------------------|
| ibm-mas                  | 8.11.x            | 8.10.x    | 8.10.11          |
|                          |                   | 8.11.x    | 8.11.8           |
|                          |                   | 8.9.x     | 8.9.10           |
| ibm-mas-assist           | 8.8.x             | 8.6.x     | 8.6.5            |
|                          |                   | 8.7.x     | 8.7.3            |
|                          |                   | 8.8.x     | 8.8.2            |
| ibm-mas-hputilities      | 8.6.x             | 8.5.x     | 8.5.3            |
|                          |                   | 8.6.x     | 8.6.4            |
| ibm-mas-iot              | 8.8.x             | 8.6.x     | 8.6.9            |
|                          |                   | 8.7.x     | 8.7.10           |
|                          |                   | 8.8.x     | 8.8.6            |
| ibm-mas-manage           | 8.7.x             | 8.5.x     | 8.5.9            |
|                          |                   | 8.6.x     | 8.6.11           |
|                          |                   | 8.7.x     | 8.7.6            |
| ibm-mas-monitor          | 8.11.x            | 8.10.x    | 8.10.8           |
|                          |                   | 8.11.x    | 8.11.5           |
|                          |                   | 8.9.x     | 8.9.6            |
| ibm-mas-optimizer        | 8.5.x             | 8.3.x     | 8.3.3            |
|                          |                   | 8.4.x     | 8.4.4            |
|                          |                   | 8.5.x     | 8.5.3            |
| ibm-mas-predict          | 8.9.x             | 8.7.x     | 8.7.2            |
|                          |                   | 8.8.x     | 8.8.2            |
|                          |                   | 8.9.x     | 8.9.2            |
| ibm-mas-visualinspection | 8.9.x             | 8.7.x     | 8.7.1            |
|                          |                   | 8.8.x     | 8.8.2            |
|                          |                   | 8.9.x     | 8.9.1            |


### IBM Utilities
| Package             | Default Channel   | Channel   | Latest Version   |
|---------------------|-------------------|-----------|------------------|
| ibm-data-dictionary | 1.1.x             | 1.1.x     | 1.1.7            |
| ibm-sls             | 3.x               | 3.x       | 3.8.1            |
| ibm-truststore-mgr  | 1.x               | 1.x       | 1.5.3            |


### IBM Cloud Pak Foundational Services
| Package                             | Default Channel   | Channel      | Latest Version   |
|-------------------------------------|-------------------|--------------|------------------|
| cloud-native-postgresql             | stable-v1.18      | fast         | 1.18.3           |
|                                     |                   | stable       | 1.18.7           |
|                                     |                   | stable-v1.15 | 1.15.5           |
|                                     |                   | stable-v1.17 | 1.17.3           |
|                                     |                   | stable-v1.18 | 1.18.7           |
| ibm-cert-manager-operator           | v3.23             | beta         | 3.9.0            |
|                                     |                   | v3           | 3.25.11          |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.11          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-common-service-operator         | v3.23             | beta         | 103.103.103      |
|                                     |                   | v3           | 3.19.19          |
|                                     |                   | v3.20        | 3.20.1           |
|                                     |                   | v3.21        | 3.21.0           |
|                                     |                   | v3.22        | 3.22.0           |
|                                     |                   | v3.23        | 3.23.12          |
|                                     |                   | v4.0         | 4.0.1            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.0            |
|                                     |                   | v4.3         | 4.3.1            |
| ibm-commonui-operator-app           | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.21.12          |
|                                     |                   | v3.20        | 1.18.1           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.12          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.0            |
|                                     |                   | v4.3         | 4.3.0            |
| ibm-events-operator                 | v3                | beta         | 3.7.1            |
|                                     |                   | v3           | 4.9.0            |
| ibm-ingress-nginx-operator-app      | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.20.10          |
|                                     |                   | v3.20        | 1.17.1           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.10          |
| ibm-licensing-operator-app          | v3.23             | beta         | 1.4.1            |
|                                     |                   | v3           | 1.20.10          |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.10          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-management-ingress-operator-app | v3.23             | beta         | 1.5.1            |
|                                     |                   | v3           | 1.20.11          |
|                                     |                   | v3.20        | 1.17.0           |
|                                     |                   | v3.21        | 1.18.0           |
|                                     |                   | v3.22        | 1.19.0           |
|                                     |                   | v3.23        | 1.20.11          |
| ibm-mongodb-operator-app            | v3.23             | beta         | 1.3.1            |
|                                     |                   | v3           | 1.18.11          |
|                                     |                   | v3.20        | 1.15.0           |
|                                     |                   | v3.21        | 1.16.0           |
|                                     |                   | v3.22        | 1.17.0           |
|                                     |                   | v3.23        | 1.18.11          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-namespace-scope-operator        | v3.23             | beta         | 1.1.1            |
|                                     |                   | v3           | 1.17.11          |
|                                     |                   | v3.20        | 1.14.0           |
|                                     |                   | v3.21        | 1.15.0           |
|                                     |                   | v3.22        | 1.16.0           |
|                                     |                   | v3.23        | 1.17.11          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.1            |
| ibm-odlm                            | v3.23             | beta         | 1.5.0            |
|                                     |                   | v3           | 1.21.11          |
|                                     |                   | v3.20        | 1.18.0           |
|                                     |                   | v3.21        | 1.19.0           |
|                                     |                   | v3.22        | 1.20.0           |
|                                     |                   | v3.23        | 1.21.11          |
|                                     |                   | v4.0         | 4.0.0            |
|                                     |                   | v4.1         | 4.1.0            |
|                                     |                   | v4.2         | 4.2.2            |
| ibm-platform-api-operator-app       | v3.23             | beta         | 3.9.1            |
|                                     |                   | v3           | 3.25.11          |
|                                     |                   | v3.20        | 3.22.0           |
|                                     |                   | v3.21        | 3.23.0           |
|                                     |                   | v3.22        | 3.24.0           |
|                                     |                   | v3.23        | 3.25.11          |
| ibm-user-data-services-operator     | alpha             | alpha        | 2.0.12           |
| ibm-zen-operator                    | v3.23             | beta         | 1.0.1            |
|                                     |                   | v3           | 1.8.12           |
|                                     |                   | v3.20        | 1.7.1            |
|                                     |                   | v3.21        | 1.7.2            |
|                                     |                   | v3.22        | 1.8.0            |
|                                     |                   | v3.23        | 1.8.12           |
|                                     |                   | v4.0         | 5.0.0            |
|                                     |                   | v4.1         | 5.0.1            |
|                                     |                   | v4.2         | 5.0.2            |
|                                     |                   | v4.3         | 5.1.0            |
| isf-operator                        | v2.0              | v2.0         | 2.7.1            |


### IBM Cloud Pak for Data
| Package                       | Default Channel   | Channel   | Latest Version   |
|-------------------------------|-------------------|-----------|------------------|
| analyticsengine-operator      | v5.1              | beta      | 1.0.1            |
|                               |                   | stable-v1 | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v4.1      | 4.1.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v4.3      | 4.3.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
| cpd-platform-operator         | v5.1              | beta      | 2.0.0            |
|                               |                   | stable-v1 | 2.0.0            |
|                               |                   | v2.0      | 2.0.8            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v3.6      | 3.6.0            |
|                               |                   | v3.7      | 3.7.0            |
|                               |                   | v3.8      | 3.8.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v4.1      | 4.1.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v4.3      | 4.3.0            |
|                               |                   | v4.4      | 4.4.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
| ibm-ca-operator               | v25.0             | v22.0     | 22.0.0           |
|                               |                   | v22.1     | 22.1.0           |
|                               |                   | v22.2     | 22.2.0           |
|                               |                   | v22.3     | 22.3.0           |
|                               |                   | v23.0     | 23.0.0           |
|                               |                   | v23.1     | 23.1.0           |
|                               |                   | v23.3     | 23.3.0           |
|                               |                   | v23.4     | 23.4.0           |
|                               |                   | v23.5     | 23.5.0           |
|                               |                   | v24.0     | 24.0.0           |
|                               |                   | v24.3     | 24.3.0           |
|                               |                   | v25.0     | 25.0.0           |
|                               |                   | v4.0      | 4.0.8            |
| ibm-cpd-ccs                   | v8.1              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v7.1      | 7.1.0            |
|                               |                   | v7.2      | 7.2.0            |
|                               |                   | v7.3      | 7.3.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-datarefinery          | v8.1              | v1.0      | 1.0.10           |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-spss                  | v8.1              | v1.0      | 1.0.9            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-wml-operator          | v5.1              | alpha     | 1.1.0            |
|                               |                   | beta      | 1.0.1486         |
|                               |                   | v1.1      | 1.1.8            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
| ibm-cpd-wos                   | v5.0              | alpha     | 1.2.0            |
|                               |                   | v1        | 1.5.0            |
|                               |                   | v1.5      | 1.5.4            |
|                               |                   | v2.0      | 2.0.0            |
|                               |                   | v2.1      | 2.1.0            |
|                               |                   | v2.2      | 2.2.0            |
|                               |                   | v2.3      | 2.3.0            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v3.4      | 3.4.0            |
|                               |                   | v3.5      | 3.5.0            |
|                               |                   | v4.0      | 4.0.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v5.0      | 5.0.0            |
| ibm-cpd-ws-runtimes           | v8.1              | v1.0      | 1.0.9            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.1      | 5.1.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-cpd-wsl                   | v8.1              | v2.0      | 2.0.9            |
|                               |                   | v3.0      | 3.0.0            |
|                               |                   | v3.1      | 3.1.0            |
|                               |                   | v3.2      | 3.2.0            |
|                               |                   | v3.3      | 3.3.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v6.4      | 6.4.0            |
|                               |                   | v6.5      | 6.5.0            |
|                               |                   | v7.0      | 7.0.0            |
|                               |                   | v8.0      | 8.0.0            |
|                               |                   | v8.1      | 8.1.0            |
| ibm-elasticsearch-operator    | v1.1              | v1.1      | 1.1.1960         |
| ibm-etcd-operator             | v1.0              | v1.0      | 1.0.24           |
| ibm-iam-operator              | v3.23             | beta      | 3.9.1            |
|                               |                   | v3        | 3.23.12          |
|                               |                   | v3.20     | 3.20.1           |
|                               |                   | v3.21     | 3.21.0           |
|                               |                   | v3.22     | 3.22.0           |
|                               |                   | v3.23     | 3.23.12          |
|                               |                   | v4.0      | 4.0.1            |
|                               |                   | v4.1      | 4.1.0            |
|                               |                   | v4.2      | 4.2.0            |
|                               |                   | v4.3      | 4.3.1            |
| ibm-minio-operator            | v1.0              | v1.0      | 1.0.18           |
| ibm-model-train-operator      | v1.1              | v1.1      | 1.1.15           |
| ibm-rabbitmq-operator         | v1.0              | v1.0      | 1.0.24           |
| ibm-watson-discovery-operator | v7.0              | v4.0      | 4.0.9            |
|                               |                   | v4.5      | 4.5.0            |
|                               |                   | v4.6      | 4.6.0            |
|                               |                   | v4.7      | 4.7.0            |
|                               |                   | v5.0      | 5.0.0            |
|                               |                   | v5.2      | 5.2.0            |
|                               |                   | v5.3      | 5.3.0            |
|                               |                   | v5.5      | 5.5.0            |
|                               |                   | v6.0      | 6.0.0            |
|                               |                   | v6.1      | 6.1.0            |
|                               |                   | v6.3      | 6.3.0            |
|                               |                   | v7.0      | 7.0.0            |
| ibm-watson-gateway-operator   | v1.0              | v1.0      | 1.0.22           |


### IBM Db2 Universal Operator
| Package        | Default Channel   | Channel      | Latest Version   |
|----------------|-------------------|--------------|------------------|
| db2u-operator  | v110509.0         | v1.0         | 1.0.11           |
|                |                   | v1.1         | 1.1.13           |
|                |                   | v110508.0    | 110508.0.3       |
|                |                   | v110509.0    | 110509.0.1       |
|                |                   | v2.0         | 2.0.0            |
|                |                   | v2.1         | 2.1.0            |
|                |                   | v2.2         | 2.2.0            |
|                |                   | v3.0         | 3.0.0            |
|                |                   | v3.1         | 3.1.0            |
|                |                   | v3.2         | 3.2.0            |
|                |                   | v4.0         | 4.0.0            |
|                |                   | v4.1         | 4.1.0            |
|                |                   | v4.2         | 4.2.0            |
|                |                   | v5.0         | 5.0.0            |


### IBM AppConnect
| Package          | Default Channel   | Channel   | Latest Version   |
|------------------|-------------------|-----------|------------------|
| couchdb-operator | v2.2              | beta      | 1.4.2            |
|                  |                   | stable    | 2.2.1            |
|                  |                   | v1.0      | 1.0.14           |
|                  |                   | v1.1      | 1.1.0            |
|                  |                   | v1.2      | 1.2.1            |
|                  |                   | v1.3      | 1.3.1            |
|                  |                   | v1.4      | 1.4.4            |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.0.1            |
|                  |                   | v2.2      | 2.2.1            |
| ibm-appconnect   | v11.1             | cd        | 5.2.0            |
|                  |                   | v1.0      | 1.0.5            |
|                  |                   | v1.1-eus  | 1.1.10           |
|                  |                   | v1.2      | 1.2.0            |
|                  |                   | v1.3      | 1.3.2            |
|                  |                   | v1.4      | 1.4.0            |
|                  |                   | v1.5      | 1.5.2            |
|                  |                   | v10.0     | 10.0.1           |
|                  |                   | v10.1     | 10.1.1           |
|                  |                   | v11.0     | 11.0.1           |
|                  |                   | v11.1     | 11.1.0           |
|                  |                   | v2.0      | 2.0.0            |
|                  |                   | v2.1      | 2.1.0            |
|                  |                   | v3.0      | 3.0.0            |
|                  |                   | v3.1      | 3.1.0            |
|                  |                   | v4.0      | 4.0.0            |
|                  |                   | v4.1      | 4.1.0            |
|                  |                   | v4.2      | 4.2.0            |
|                  |                   | v5.0-lts  | 5.0.13           |
|                  |                   | v5.1      | 5.1.0            |
|                  |                   | v5.2      | 5.2.0            |
|                  |                   | v6.0      | 6.0.0            |
|                  |                   | v6.1      | 6.1.1            |
|                  |                   | v6.2      | 6.2.0            |
|                  |                   | v7.0      | 7.0.0            |
|                  |                   | v7.1      | 7.1.0            |
|                  |                   | v7.2      | 7.2.0            |
|                  |                   | v8.0      | 8.0.0            |
|                  |                   | v8.1      | 8.1.0            |
|                  |                   | v8.2      | 8.2.1            |
|                  |                   | v9.0      | 9.0.0            |
|                  |                   | v9.1      | 9.1.0            |
|                  |                   | v9.2      | 9.2.1            |


### Eclipse Amlen
| Package                | Default Channel   | Channel   | Latest Version   |
|------------------------|-------------------|-----------|------------------|
| eclipse-amlen-operator | 1.x               | 1.x       | 1.0.3            |

