extra_breadcrumb_title_1: Operator Catalog
extra_breadcrumb_title_2: IBM Maximo Operator Catalog
extra_breadcrumb_url_2: ../
nav_title: Operator Catalog

IBM Maximo Operator Catalog v9 (250306)
===============================================================================

Details
-------------------------------------------------------------------------------
<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v9-250306-s390x</tr></tr>
  <tr><td>Digest</td><td>sha256:a9f4a2a8aa4ec25b68ff6a1592c0773f730564a833b14eef5585a077e37c203a</tr></tr>
</table>


What's New
-------------------------------------------------------------------------------
- **Security updates and bug fixes**
    - IBM Maximo Application Suite Core Platform v9.0 & v9.1
    - IBM Maximo Manage v9.0 & v9.1
    - IBM SLS v3.0


Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v9-250306-s390x.yaml`


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v9-250306-s390x)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:a9f4a2a8aa4ec25b68ff6a1592c0773f730564a833b14eef5585a077e37c203a
  priority: 90
```


Red Hat OpenShift Container Platform Support
-------------------------------------------------------------------------------
For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/).

IBM Maximo Application Suite customers receive a standard Red Hat OpenShift Container Platform subscription as part of their purchase. This includes 18 months of maintenance support for each OpenShift minor release.  A further 6 months support is available to purchase as an Extended Update Support (EUS) Add-on to x86-64 versions of Red Hat OpenShift Kubernetes Engine, Red Hat OpenShift Container Platform, and Red Hat OpenShift Platform Plus Standard subscriptions.

<table class="compatabilityMatrix">
  <tr>
    <th>OCP</th><td rowspan="4" class="spacer"></td>
    <th>General Availability</th>
    <th>Standard Support</th>
    <th>Extended Support</th>
    <th>Supported MAS Releases</th>
  </tr>
  <tr>
    <td class="firstColumn">4.16</td>
    <td>June 27, 2024</td>
    <td>December 27, 2025</td>
    <td>June 27, 2027</td>
    <td>8.10 - 9.0</td>
  </tr>
  <tr>
    <td class="firstColumn">4.15</td>
    <td>February 27, 2024</td>
    <td>August 27, 2025</td>
    <td>N/A</td>
    <td>8.10 - 9.0</td>
  </tr>
  <tr>
    <td class="firstColumn">4.14</td>
    <td>October 31, 2023</td>
    <td>May 1, 2025</td>
    <td>October 31, 2026</td>
    <td>8.10 - 9.0</td>
  </tr>
</table>


### Certified Operators
The following packages from the `registry.redhat.io/redhat/certified-operator-index` catalog are used in the Maximo Application Suite install:

- **gpu-operator-certified** required by `ibm.mas_devops.nvidia_gpu` role
- **kubeturbo-certified** required by `ibm.mas_devops.kubeturbo` role


### Community Operators
The following packages from the `registry.redhat.io/redhat/community-operator-index` catalog are used in the Maximo Application Suite install:

- **grafana-operator** required by `ibm.mas_devops.grafana` role
- **opentelemetry-operator** required by `ibm.mas_devops.opentelemetry` role
- **strimzi-kafka-operator** required by `ibm.mas_devops.kafka` role (if using Strimzi as Kakfa provider)


### Red Hat Operators
The following packages from the `registry.redhat.io/redhat/redhat-operator-index` catalog are used in the Maximo Application Suite install:

- **amq-streams** required by `ibm.mas_devops.kafka` role (if using AMQ Streams as Kakfa provider)
- **openshift-pipelines-operator-rh** required by the MAS CLI
- **nfd** required by `ibm.mas_devops.nvidia_gpu` role
- **aws-efs-csi-driver-operator**  required by `ibm.mas_devops.ocp_efs` role
- **local-storage-operator**  required by `ibm.mas_devops.ocs` role
- **odf-operator**  required by `ibm.mas_devops.ocs` role

Package Manifest
-------------------------------------------------------------------------------

### IBM Maximo Application Suite
| Package        | Default Channel   | Channel       | Latest Version                                                            |
|----------------|-------------------|---------------|---------------------------------------------------------------------------|
| ibm-mas        | 9.0.x             | 9.1.x-feature | [9.1.0-pre.stable-8193](packages/ibm-mas/9.1.0-pre.stable-8193.md)        |
|                |                   | 9.0.x         | [9.0.9](packages/ibm-mas/9.0.9.md)                                        |
| ibm-mas-manage | 9.0.x             | 9.1.x-feature | [9.1.0-pre.stable-9992](packages/ibm-mas-manage/9.1.0-pre.stable-9992.md) |
|                |                   | 9.0.x         | [9.0.10](packages/ibm-mas-manage/9.0.10.md)                               |

### IBM Utilities
| Package            | Default Channel   | Channel   | Latest Version                                |
|--------------------|-------------------|-----------|-----------------------------------------------|
| ibm-sls            | 3.x               | 3.x       | [3.11.1](packages/ibm-sls/3.11.1.md)          |
| ibm-truststore-mgr | 1.x               | 1.x       | [1.6.1](packages/ibm-truststore-mgr/1.6.1.md) |
