IBM Maximo Operator Catalog v9 (250624)
===============================================================================

Details
-------------------------------------------------------------------------------

<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v9-250624-amd64</tr></tr>
  <tr><td>Digest</td><td>sha256:cf03a9bcfacaf9c354078dfb2f97c166bfb1a6f0776680b52b7325cc469ffb31</tr></tr>
</table>


What's New
-------------------------------------------------------------------------------
- **New feature release**
    - IBM Maximo Application Suite Core Platform v9.1
    - IBM Maximo Manage v9.1
    - IBM Maximo IoT v9.1
    - IBM Maximo Monitor v9.1
    - IBM Maximo Optimizer v9.1
    - IBM Maximo Predict v9.1
    - IBM Maximo Visual Inspection v9.1
    - IBM MAS Assist v9.1
    - IBM Maximo Real Estate and Facilities v9.1
    - IBM Maximo Location Service for Esri v9.1
- **Security updates and bug fixes**
    - IBM Maximo Application Suite Core Platform v8.10, v8.11, v9.0
    - IBM Maximo IoT v8.7, v8.8, v9.0
    - IBM Maximo Manage v8.6, v8.7, v9.0
    - IBM Maximo Monitor v8.10, v8.11, v9.0
    - IBM Maximo Optimizer v8.4, v8.5, v9.0
    - IBM MAS Assist v9.0
    - IBM Data Dictionary v1.1
    - IBM Suite License Service v3
    - IBM Truststore Manager v1.7

- **Openshift 4.18 support** Openshift Container Platform 4.18 support has been added. Refer OCP 4.18 release notes [here](https://docs.redhat.com/en/documentation/openshift_container_platform/4.18/html/release_notes/index)

Reminder
-------------------------------------------------------------------------------
- MAS 8.10 and 8.11 standard support and software updates end in March 2026, to ensure you are able to continue to receive monthly security updates and bug fixes we advise all customers to begin making upgrade plans to get to MAS 9.0 if you have not already done so.


Known Issues
-------------------------------------------------------------------------------
- Customers using Maximo Assist v8.7 or v8.8 should not update and must instead contact IBM Support for guidance regarding the removal of IBM Watson Discovery and upgrading to Maximo Assist v9.0


Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v9-250624-amd64.yaml`


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v9-250624-amd64)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:cf03a9bcfacaf9c354078dfb2f97c166bfb1a6f0776680b52b7325cc469ffb31
  priority: 90
```


Red Hat OpenShift Container Platform Support
-------------------------------------------------------------------------------
For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/).

IBM Maximo Application Suite customers receive a standard Red Hat OpenShift Container Platform subscription as part of their purchase. This includes 18 months of maintenance support for each OpenShift minor release.  A further 6 months support is available to purchase as an Extended Update Support (EUS) Add-on to x86-64 versions of Red Hat OpenShift Kubernetes Engine, Red Hat OpenShift Container Platform, and Red Hat OpenShift Platform Plus Standard subscriptions.

<table class="compatabilityMatrix">
  <tr>
    <th>OCP</th><td rowspan="6" class="spacer"></td>
    <th>General Availability</th>
    <th>Standard Support</th>
    <th>Extended Support</th>
  </tr>
  <tr>
    <td class="firstColumn">4.18</td>
    <td>February 25, 2025</td>
    <td>GA of 4.19 + 3 Months</td>
    <td>August 25, 2026</td>
  </tr>
  <tr>
    <td class="firstColumn">4.17</td>
    <td>October 1, 2024</td>
    <td>May 25, 2025</td>
    <td>April 1, 2026</td>
  </tr>
  <tr>
    <td class="firstColumn">4.16</td>
    <td>June 27, 2024</td>
    <td>December 27, 2025</td>
    <td>June 27, 2027</td>
  </tr>
  <tr>
    <td class="firstColumn">4.15</td>
    <td>February 27, 2024</td>
    <td>August 27, 2025</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td class="firstColumn">4.14</td>
    <td>October 31, 2023</td>
    <td>May 1, 2025</td>
    <td>October 31, 2026</td>
  </tr>
</table>


### Certified Operators
The following packages from the `registry.redhat.io/redhat/certified-operator-index` catalog are used in the Maximo Application Suite install:

- **gpu-operator-certified** required by `ibm.mas_devops.nvidia_gpu` role
- **kubeturbo-certified** required by `ibm.mas_devops.kubeturbo` role


### Community Operators
The following packages from the `registry.redhat.io/redhat/community-operator-index` catalog are used in the Maximo Application Suite install:

- **grafana-operator** required by `ibm.mas_devops.grafana` role
- **opentelemetry-operator** required by `ibm.mas_devops.opentelemetry` role
- **strimzi-kafka-operator** required by `ibm.mas_devops.kafka` role (if using Strimzi as Kakfa provider)


### Red Hat Operators
The following packages from the `registry.redhat.io/redhat/redhat-operator-index` catalog are used in the Maximo Application Suite install:

- **amq-streams** required by `ibm.mas_devops.kafka` role (if using AMQ Streams as Kakfa provider)
- **openshift-pipelines-operator-rh** required by the MAS CLI
- **nfd** required by `ibm.mas_devops.nvidia_gpu` role
- **aws-efs-csi-driver-operator**  required by `ibm.mas_devops.ocp_efs` role
- **local-storage-operator**  required by `ibm.mas_devops.ocs` role
- **odf-operator**  required by `ibm.mas_devops.ocs` role


IBM Cloud Pak for Data Compatibility
-------------------------------------------------------------------------------
This catalog is certified compatible with **IBM Cloud Pak for Data v5.0.0**.

For more information on Cloud Pak for Data's support policy review this [IBM Cloud Pak for Data Software Support Lifecycle Addendum](https://www.ibm.com/support/pages/node/6593147).


MongoDB Compatibility
-------------------------------------------------------------------------------
This catalog is certified compatible with MongoDB **[v6.0](https://www.mongodb.com/docs/v6.0/)** and **[v7.0](https://www.mongodb.com/docs/v7.0/)**, this applies to both MongoDB Community Edition (CE) and MongoDB Enterprise Edition (EE).

By default an in-cluster MongoDb (CE) instance will be created when you install MAS, using the [MongoDB Community Kubernetes Operator](https://github.com/mongodb/mongodb-kubernetes-operator); however MAS supports use with any type of MongoDb instance, including but not limited to the following hosted solutions:

- [IBM Cloud Databases for MongoDB](https://www.ibm.com/products/databases-for-mongodb)
- [MongoDB Atlas](https://www.mongodb.com/products/platform/atlas-database)

[Amazon DocumentDB](https://aws.amazon.com/documentdb/) provides [MongoDb compatability](https://docs.aws.amazon.com/documentdb/latest/developerguide/compatibility.html) and may be used as an alternative to MongoDb.  This catalog is certified compatible with **DocumentDb Engine Version v5.0.0**.


### IBM Maximo Application Suite
| Package                  | Default Channel   | Channel       | Latest Version                                        |
|--------------------------|-------------------|---------------|-------------------------------------------------------|
| ibm-mas                  | 9.1.x             | 9.1.x-feature | [9.1.0](packages/ibm-mas/9.1.0.md)                    |
|                          |                   | 9.1.x         | [9.1.0](packages/ibm-mas/9.1.0.md)                    |
|                          |                   | 9.0.x         | [9.0.12](packages/ibm-mas/9.0.12.md)                  |
|                          |                   | 8.11.x        | [8.11.23](packages/ibm-mas/8.11.23.md)                |
|                          |                   | 8.10.x        | [8.10.26](packages/ibm-mas/8.10.26.md)                |
| ibm-mas-aibroker         | 9.1.x             | 9.1.x         | [9.1.0](packages/ibm-mas-aibroker/9.1.0.md)           |
|                          |                   | 9.0.x         | [9.0.6](packages/ibm-mas-aibroker/9.0.6.md)           |
| ibm-mas-arcgis           | 9.1.x             | 9.1.x         | [9.1.0](packages/ibm-mas-arcgis/9.1.0.md)             |
|                          |                   | 9.0.x         | [9.0.1](packages/ibm-mas-arcgis/9.0.1.md)             |
| ibm-mas-assist           | 9.1.x             | 9.1.x         | [9.1.0](packages/ibm-mas-assist/9.1.0.md)             |
|                          |                   | 9.0.x         | [9.0.6](packages/ibm-mas-assist/9.0.6.md)             |
|                          |                   | 8.8.x         | [8.8.7](packages/ibm-mas-assist/8.8.7.md)             |
|                          |                   | 8.7.x         | [8.7.8](packages/ibm-mas-assist/8.7.8.md)             |
| ibm-mas-facilities       | 9.1.x             | 9.1.x         | [9.1.0](packages/ibm-mas-facilities/9.1.0.md)         |
| ibm-mas-hputilities      | 8.6.x             | 8.6.x         | [8.6.7](packages/ibm-mas-hputilities/8.6.7.md)        |
| ibm-mas-iot              | 9.1.x             | 9.1.x         | [9.1.0](packages/ibm-mas-iot/9.1.0.md)                |
|                          |                   | 9.0.x         | [9.0.9](packages/ibm-mas-iot/9.0.9.md)                |
|                          |                   | 8.8.x         | [8.8.19](packages/ibm-mas-iot/8.8.19.md)              |
|                          |                   | 8.7.x         | [8.7.23](packages/ibm-mas-iot/8.7.23.md)              |
| ibm-mas-manage           | 9.1.x             | 9.1.x-feature | [9.1.0](packages/ibm-mas-manage/9.1.0.md)             |
|                          |                   | 9.1.x         | [9.1.0](packages/ibm-mas-manage/9.1.0.md)             |
|                          |                   | 9.0.x         | [9.0.14](packages/ibm-mas-manage/9.0.14.md)           |
|                          |                   | 8.7.x         | [8.7.21](packages/ibm-mas-manage/8.7.21.md)           |
|                          |                   | 8.6.x         | [8.6.27](packages/ibm-mas-manage/8.6.27.md)           |
| ibm-mas-monitor          | 9.1.x             | 9.1.x         | [9.1.0](packages/ibm-mas-monitor/9.1.0.md)            |
|                          |                   | 9.0.x         | [9.0.10](packages/ibm-mas-monitor/9.0.10.md)          |
|                          |                   | 8.11.x        | [8.11.18](packages/ibm-mas-monitor/8.11.18.md)        |
|                          |                   | 8.10.x        | [8.10.20](packages/ibm-mas-monitor/8.10.20.md)        |
| ibm-mas-optimizer        | 9.1.x             | 9.1.x-feature | [9.1.0](packages/ibm-mas-optimizer/9.1.0.md)          |
|                          |                   | 9.1.x         | [9.1.0](packages/ibm-mas-optimizer/9.1.0.md)          |
|                          |                   | 9.0.x         | [9.0.12](packages/ibm-mas-optimizer/9.0.12.md)        |
|                          |                   | 8.5.x         | [8.5.18](packages/ibm-mas-optimizer/8.5.18.md)        |
|                          |                   | 8.4.x         | [8.4.19](packages/ibm-mas-optimizer/8.4.19.md)        |
| ibm-mas-predict          | 9.1.x             | 9.1.x         | [9.1.0](packages/ibm-mas-predict/9.1.0.md)            |
|                          |                   | 9.0.x         | [9.0.7](packages/ibm-mas-predict/9.0.7.md)            |
|                          |                   | 8.9.x         | [8.9.10](packages/ibm-mas-predict/8.9.10.md)          |
|                          |                   | 8.8.x         | [8.8.8](packages/ibm-mas-predict/8.8.8.md)            |
| ibm-mas-visualinspection | 9.1.x             | 9.1.x-feature | [9.1.0](packages/ibm-mas-visualinspection/9.1.0.md)   |
|                          |                   | 9.1.x         | [9.1.0](packages/ibm-mas-visualinspection/9.1.0.md)   |
|                          |                   | 9.0.x         | [9.0.9](packages/ibm-mas-visualinspection/9.0.9.md)   |
|                          |                   | 8.9.x         | [8.9.12](packages/ibm-mas-visualinspection/8.9.12.md) |
|                          |                   | 8.8.x         | [8.8.4](packages/ibm-mas-visualinspection/8.8.4.md)   |

### IBM Utilities
| Package             | Default Channel   | Channel   | Latest Version                                   |
|---------------------|-------------------|-----------|--------------------------------------------------|
| ibm-data-dictionary | 1.1.x             | 1.1.x     | [1.1.19](packages/ibm-data-dictionary/1.1.19.md) |
| ibm-sls             | 3.x               | 3.x       | [3.12.0](packages/ibm-sls/3.12.0.md)             |
| ibm-truststore-mgr  | 1.x               | 1.x       | [1.7.0](packages/ibm-truststore-mgr/1.7.0.md)    |

### IBM Cloud Pak Foundational Services
| Package                             | Default Channel   | Channel      | Latest Version                                                     |
|-------------------------------------|-------------------|--------------|--------------------------------------------------------------------|
| cloud-native-postgresql             | stable-v1.25      | stable-v1.25 | [1.25.1](packages/cloud-native-postgresql/1.25.1.md)               |
|                                     |                   | stable-v1.22 | [1.22.9](packages/cloud-native-postgresql/1.22.9.md)               |
|                                     |                   | stable-v1.18 | [1.18.13](packages/cloud-native-postgresql/1.18.13.md)             |
|                                     |                   | stable-v1.17 | [1.17.3](packages/cloud-native-postgresql/1.17.3.md)               |
|                                     |                   | stable-v1.15 | [1.15.5](packages/cloud-native-postgresql/1.15.5.md)               |
|                                     |                   | stable       | [1.22.7](packages/cloud-native-postgresql/1.22.7.md)               |
|                                     |                   | fast         | [1.18.3](packages/cloud-native-postgresql/1.18.3.md)               |
| ibm-cert-manager-operator           | v3.23             | v4.2         | [4.2.14](packages/ibm-cert-manager-operator/4.2.14.md)             |
|                                     |                   | v4.1         | [4.1.0](packages/ibm-cert-manager-operator/4.1.0.md)               |
|                                     |                   | v4.0         | [4.0.0](packages/ibm-cert-manager-operator/4.0.0.md)               |
|                                     |                   | v3.23        | [3.25.13](packages/ibm-cert-manager-operator/3.25.13.md)           |
|                                     |                   | v3.22        | [3.24.0](packages/ibm-cert-manager-operator/3.24.0.md)             |
|                                     |                   | v3.21        | [3.23.0](packages/ibm-cert-manager-operator/3.23.0.md)             |
|                                     |                   | v3.20        | [3.22.0](packages/ibm-cert-manager-operator/3.22.0.md)             |
|                                     |                   | v3           | [3.25.13](packages/ibm-cert-manager-operator/3.25.13.md)           |
|                                     |                   | beta         | [3.9.0](packages/ibm-cert-manager-operator/3.9.0.md)               |
| ibm-common-service-operator         | v3.23             | v4.9         | [4.9.0](packages/ibm-common-service-operator/4.9.0.md)             |
|                                     |                   | v4.8         | [4.8.0](packages/ibm-common-service-operator/4.8.0.md)             |
|                                     |                   | v4.7         | [4.7.0](packages/ibm-common-service-operator/4.7.0.md)             |
|                                     |                   | v4.6         | [4.6.13](packages/ibm-common-service-operator/4.6.13.md)           |
|                                     |                   | v4.5         | [4.5.0](packages/ibm-common-service-operator/4.5.0.md)             |
|                                     |                   | v4.4         | [4.4.0](packages/ibm-common-service-operator/4.4.0.md)             |
|                                     |                   | v4.3         | [4.3.1](packages/ibm-common-service-operator/4.3.1.md)             |
|                                     |                   | v4.2         | [4.2.0](packages/ibm-common-service-operator/4.2.0.md)             |
|                                     |                   | v4.12        | [4.12.0](packages/ibm-common-service-operator/4.12.0.md)           |
|                                     |                   | v4.11        | [4.11.0](packages/ibm-common-service-operator/4.11.0.md)           |
|                                     |                   | v4.10        | [4.10.0](packages/ibm-common-service-operator/4.10.0.md)           |
|                                     |                   | v4.1         | [4.1.0](packages/ibm-common-service-operator/4.1.0.md)             |
|                                     |                   | v4.0         | [4.0.1](packages/ibm-common-service-operator/4.0.1.md)             |
|                                     |                   | v3.23        | [3.23.14](packages/ibm-common-service-operator/3.23.14.md)         |
|                                     |                   | v3.22        | [3.22.0](packages/ibm-common-service-operator/3.22.0.md)           |
|                                     |                   | v3.21        | [3.21.0](packages/ibm-common-service-operator/3.21.0.md)           |
|                                     |                   | v3.20        | [3.20.1](packages/ibm-common-service-operator/3.20.1.md)           |
|                                     |                   | v3           | [3.19.22](packages/ibm-common-service-operator/3.19.22.md)         |
|                                     |                   | beta         | [103.103.103](packages/ibm-common-service-operator/103.103.103.md) |
| ibm-commonui-operator-app           | v3.23             | v4.8         | [4.8.0](packages/ibm-commonui-operator-app/4.8.0.md)               |
|                                     |                   | v4.7         | [4.7.0](packages/ibm-commonui-operator-app/4.7.0.md)               |
|                                     |                   | v4.6         | [4.6.0](packages/ibm-commonui-operator-app/4.6.0.md)               |
|                                     |                   | v4.5         | [4.5.2](packages/ibm-commonui-operator-app/4.5.2.md)               |
|                                     |                   | v4.4         | [4.4.11](packages/ibm-commonui-operator-app/4.4.11.md)             |
|                                     |                   | v4.3         | [4.3.1](packages/ibm-commonui-operator-app/4.3.1.md)               |
|                                     |                   | v4.2         | [4.2.0](packages/ibm-commonui-operator-app/4.2.0.md)               |
|                                     |                   | v4.1         | [4.1.0](packages/ibm-commonui-operator-app/4.1.0.md)               |
|                                     |                   | v4.0         | [4.0.0](packages/ibm-commonui-operator-app/4.0.0.md)               |
|                                     |                   | v3.23        | [1.21.14](packages/ibm-commonui-operator-app/1.21.14.md)           |
|                                     |                   | v3.22        | [1.20.0](packages/ibm-commonui-operator-app/1.20.0.md)             |
|                                     |                   | v3.21        | [1.19.0](packages/ibm-commonui-operator-app/1.19.0.md)             |
|                                     |                   | v3.20        | [1.18.1](packages/ibm-commonui-operator-app/1.18.1.md)             |
|                                     |                   | v3           | [1.21.14](packages/ibm-commonui-operator-app/1.21.14.md)           |
|                                     |                   | beta         | [1.5.1](packages/ibm-commonui-operator-app/1.5.1.md)               |
| ibm-events-operator                 | v5.1              | v5.1         | [5.1.2](packages/ibm-events-operator/5.1.2.md)                     |
|                                     |                   | v3           | [5.0.1](packages/ibm-events-operator/5.0.1.md)                     |
|                                     |                   | beta         | [3.7.1](packages/ibm-events-operator/3.7.1.md)                     |
| ibm-ingress-nginx-operator-app      | v3.23             | v3.23        | [1.20.13](packages/ibm-ingress-nginx-operator-app/1.20.13.md)      |
|                                     |                   | v3.22        | [1.19.0](packages/ibm-ingress-nginx-operator-app/1.19.0.md)        |
|                                     |                   | v3.21        | [1.18.0](packages/ibm-ingress-nginx-operator-app/1.18.0.md)        |
|                                     |                   | v3.20        | [1.17.1](packages/ibm-ingress-nginx-operator-app/1.17.1.md)        |
|                                     |                   | v3           | [1.20.13](packages/ibm-ingress-nginx-operator-app/1.20.13.md)      |
|                                     |                   | beta         | [1.5.0](packages/ibm-ingress-nginx-operator-app/1.5.0.md)          |
| ibm-licensing-operator-app          | v3.23             | v4.2         | [4.2.14](packages/ibm-licensing-operator-app/4.2.14.md)            |
|                                     |                   | v4.1         | [4.1.0](packages/ibm-licensing-operator-app/4.1.0.md)              |
|                                     |                   | v4.0         | [4.0.0](packages/ibm-licensing-operator-app/4.0.0.md)              |
|                                     |                   | v3.23        | [1.20.13](packages/ibm-licensing-operator-app/1.20.13.md)          |
|                                     |                   | v3.22        | [1.19.0](packages/ibm-licensing-operator-app/1.19.0.md)            |
|                                     |                   | v3.21        | [1.18.0](packages/ibm-licensing-operator-app/1.18.0.md)            |
|                                     |                   | v3.20        | [1.17.0](packages/ibm-licensing-operator-app/1.17.0.md)            |
|                                     |                   | v3           | [1.20.13](packages/ibm-licensing-operator-app/1.20.13.md)          |
|                                     |                   | beta         | [1.4.1](packages/ibm-licensing-operator-app/1.4.1.md)              |
| ibm-management-ingress-operator-app | v3.23             | v3.23        | [1.20.13](packages/ibm-management-ingress-operator-app/1.20.13.md) |
|                                     |                   | v3.22        | [1.19.0](packages/ibm-management-ingress-operator-app/1.19.0.md)   |
|                                     |                   | v3.21        | [1.18.0](packages/ibm-management-ingress-operator-app/1.18.0.md)   |
|                                     |                   | v3.20        | [1.17.0](packages/ibm-management-ingress-operator-app/1.17.0.md)   |
|                                     |                   | v3           | [1.20.13](packages/ibm-management-ingress-operator-app/1.20.13.md) |
|                                     |                   | beta         | [1.5.1](packages/ibm-management-ingress-operator-app/1.5.1.md)     |
| ibm-mongodb-operator-app            | v3.23             | v4.2         | [4.2.2](packages/ibm-mongodb-operator-app/4.2.2.md)                |
|                                     |                   | v4.1         | [4.1.0](packages/ibm-mongodb-operator-app/4.1.0.md)                |
|                                     |                   | v4.0         | [4.0.0](packages/ibm-mongodb-operator-app/4.0.0.md)                |
|                                     |                   | v3.23        | [1.18.13](packages/ibm-mongodb-operator-app/1.18.13.md)            |
|                                     |                   | v3.22        | [1.17.0](packages/ibm-mongodb-operator-app/1.17.0.md)              |
|                                     |                   | v3.21        | [1.16.0](packages/ibm-mongodb-operator-app/1.16.0.md)              |
|                                     |                   | v3.20        | [1.15.0](packages/ibm-mongodb-operator-app/1.15.0.md)              |
|                                     |                   | v3           | [1.18.13](packages/ibm-mongodb-operator-app/1.18.13.md)            |
|                                     |                   | beta         | [1.3.1](packages/ibm-mongodb-operator-app/1.3.1.md)                |
| ibm-namespace-scope-operator        | v3.23             | v4.2         | [4.2.14](packages/ibm-namespace-scope-operator/4.2.14.md)          |
|                                     |                   | v4.1         | [4.1.0](packages/ibm-namespace-scope-operator/4.1.0.md)            |
|                                     |                   | v4.0         | [4.0.0](packages/ibm-namespace-scope-operator/4.0.0.md)            |
|                                     |                   | v3.23        | [1.17.13](packages/ibm-namespace-scope-operator/1.17.13.md)        |
|                                     |                   | v3.22        | [1.16.0](packages/ibm-namespace-scope-operator/1.16.0.md)          |
|                                     |                   | v3.21        | [1.15.0](packages/ibm-namespace-scope-operator/1.15.0.md)          |
|                                     |                   | v3.20        | [1.14.0](packages/ibm-namespace-scope-operator/1.14.0.md)          |
|                                     |                   | v3           | [1.17.13](packages/ibm-namespace-scope-operator/1.17.13.md)        |
|                                     |                   | beta         | [1.1.1](packages/ibm-namespace-scope-operator/1.1.1.md)            |
| ibm-odlm                            | v3.23             | v4.5         | [4.5.0](packages/ibm-odlm/4.5.0.md)                                |
|                                     |                   | v4.4         | [4.4.0](packages/ibm-odlm/4.4.0.md)                                |
|                                     |                   | v4.3         | [4.3.12](packages/ibm-odlm/4.3.12.md)                              |
|                                     |                   | v4.2         | [4.2.3](packages/ibm-odlm/4.2.3.md)                                |
|                                     |                   | v4.1         | [4.1.0](packages/ibm-odlm/4.1.0.md)                                |
|                                     |                   | v4.0         | [4.0.0](packages/ibm-odlm/4.0.0.md)                                |
|                                     |                   | v3.23        | [1.21.13](packages/ibm-odlm/1.21.13.md)                            |
|                                     |                   | v3.22        | [1.20.0](packages/ibm-odlm/1.20.0.md)                              |
|                                     |                   | v3.21        | [1.19.0](packages/ibm-odlm/1.19.0.md)                              |
|                                     |                   | v3.20        | [1.18.0](packages/ibm-odlm/1.18.0.md)                              |
|                                     |                   | v3           | [1.21.13](packages/ibm-odlm/1.21.13.md)                            |
|                                     |                   | beta         | [1.5.0](packages/ibm-odlm/1.5.0.md)                                |
| ibm-platform-api-operator-app       | v3.23             | v3.23        | [3.25.13](packages/ibm-platform-api-operator-app/3.25.13.md)       |
|                                     |                   | v3.22        | [3.24.0](packages/ibm-platform-api-operator-app/3.24.0.md)         |
|                                     |                   | v3.21        | [3.23.0](packages/ibm-platform-api-operator-app/3.23.0.md)         |
|                                     |                   | v3.20        | [3.22.0](packages/ibm-platform-api-operator-app/3.22.0.md)         |
|                                     |                   | v3           | [3.25.13](packages/ibm-platform-api-operator-app/3.25.13.md)       |
|                                     |                   | beta         | [3.9.1](packages/ibm-platform-api-operator-app/3.9.1.md)           |
| ibm-user-data-services-operator     | alpha             | alpha        | [2.0.12](packages/ibm-user-data-services-operator/2.0.12.md)       |
| ibm-zen-operator                    | v3.23             | v6.1         | [6.1.3](packages/ibm-zen-operator/6.1.3.md)                        |
|                                     |                   | v6.0         | [6.0.4](packages/ibm-zen-operator/6.0.4.md)                        |
|                                     |                   | v4.4         | [5.1.15](packages/ibm-zen-operator/5.1.15.md)                      |
|                                     |                   | v4.3         | [5.1.1](packages/ibm-zen-operator/5.1.1.md)                        |
|                                     |                   | v4.2         | [5.0.2](packages/ibm-zen-operator/5.0.2.md)                        |
|                                     |                   | v4.1         | [5.0.1](packages/ibm-zen-operator/5.0.1.md)                        |
|                                     |                   | v4.0         | [5.0.0](packages/ibm-zen-operator/5.0.0.md)                        |
|                                     |                   | v3.23        | [1.8.13](packages/ibm-zen-operator/1.8.13.md)                      |
|                                     |                   | v3.22        | [1.8.0](packages/ibm-zen-operator/1.8.0.md)                        |
|                                     |                   | v3.21        | [1.7.2](packages/ibm-zen-operator/1.7.2.md)                        |
|                                     |                   | v3.20        | [1.7.1](packages/ibm-zen-operator/1.7.1.md)                        |
|                                     |                   | v3           | [1.8.13](packages/ibm-zen-operator/1.8.13.md)                      |
|                                     |                   | beta         | [1.0.1](packages/ibm-zen-operator/1.0.1.md)                        |
| isf-operator                        | v2.0              | v2.0         | [2.9.1](packages/isf-operator/2.9.1.md)                            |

### IBM Cloud Pak for Data
| Package                       | Default Channel   | Channel   | Latest Version                                              |
|-------------------------------|-------------------|-----------|-------------------------------------------------------------|
| analyticsengine-operator      | v7.2              | v7.2      | [7.2.0](packages/analyticsengine-operator/7.2.0.md)         |
|                               |                   | v7.0      | [7.0.0](packages/analyticsengine-operator/7.0.0.md)         |
|                               |                   | v6.0      | [6.0.0](packages/analyticsengine-operator/6.0.0.md)         |
|                               |                   | v5.4      | [5.4.0](packages/analyticsengine-operator/5.4.0.md)         |
|                               |                   | v5.3      | [5.3.0](packages/analyticsengine-operator/5.3.0.md)         |
|                               |                   | v5.1      | [5.1.0](packages/analyticsengine-operator/5.1.0.md)         |
|                               |                   | v5.0      | [5.0.0](packages/analyticsengine-operator/5.0.0.md)         |
|                               |                   | v4.3      | [4.3.0](packages/analyticsengine-operator/4.3.0.md)         |
|                               |                   | v4.2      | [4.2.0](packages/analyticsengine-operator/4.2.0.md)         |
|                               |                   | v4.1      | [4.1.0](packages/analyticsengine-operator/4.1.0.md)         |
|                               |                   | v4.0      | [4.0.0](packages/analyticsengine-operator/4.0.0.md)         |
|                               |                   | v3.5      | [3.5.0](packages/analyticsengine-operator/3.5.0.md)         |
|                               |                   | v3.4      | [3.4.0](packages/analyticsengine-operator/3.4.0.md)         |
|                               |                   | v3.3      | [3.3.0](packages/analyticsengine-operator/3.3.0.md)         |
|                               |                   | v3.1      | [3.1.0](packages/analyticsengine-operator/3.1.0.md)         |
|                               |                   | v3.0      | [3.0.0](packages/analyticsengine-operator/3.0.0.md)         |
|                               |                   | v2.3      | [2.3.0](packages/analyticsengine-operator/2.3.0.md)         |
|                               |                   | v2.2      | [2.2.0](packages/analyticsengine-operator/2.2.0.md)         |
|                               |                   | v2.1      | [2.1.0](packages/analyticsengine-operator/2.1.0.md)         |
|                               |                   | v2.0      | [2.0.0](packages/analyticsengine-operator/2.0.0.md)         |
|                               |                   | stable-v1 | [1.0.9](packages/analyticsengine-operator/1.0.9.md)         |
|                               |                   | beta      | [1.0.1](packages/analyticsengine-operator/1.0.1.md)         |
| cpd-platform-operator         | v6.1              | v6.1      | [6.1.3](packages/cpd-platform-operator/6.1.3.md)            |
|                               |                   | v6.0      | [6.0.3](packages/cpd-platform-operator/6.0.3.md)            |
|                               |                   | v5.9      | [5.9.0](packages/cpd-platform-operator/5.9.0.md)            |
|                               |                   | v5.8      | [5.8.0](packages/cpd-platform-operator/5.8.0.md)            |
|                               |                   | v5.7      | [5.7.0](packages/cpd-platform-operator/5.7.0.md)            |
|                               |                   | v5.6      | [5.6.0](packages/cpd-platform-operator/5.6.0.md)            |
|                               |                   | v5.5      | [5.5.0](packages/cpd-platform-operator/5.5.0.md)            |
|                               |                   | v5.4      | [5.4.0](packages/cpd-platform-operator/5.4.0.md)            |
|                               |                   | v5.3      | [5.3.0](packages/cpd-platform-operator/5.3.0.md)            |
|                               |                   | v5.2      | [5.2.0](packages/cpd-platform-operator/5.2.0.md)            |
|                               |                   | v5.1      | [5.1.0](packages/cpd-platform-operator/5.1.0.md)            |
|                               |                   | v5.0      | [5.0.0](packages/cpd-platform-operator/5.0.0.md)            |
|                               |                   | v4.4      | [4.4.0](packages/cpd-platform-operator/4.4.0.md)            |
|                               |                   | v4.3      | [4.3.0](packages/cpd-platform-operator/4.3.0.md)            |
|                               |                   | v4.2      | [4.2.0](packages/cpd-platform-operator/4.2.0.md)            |
|                               |                   | v4.1      | [4.1.0](packages/cpd-platform-operator/4.1.0.md)            |
|                               |                   | v4.0      | [4.0.0](packages/cpd-platform-operator/4.0.0.md)            |
|                               |                   | v3.8      | [3.8.0](packages/cpd-platform-operator/3.8.0.md)            |
|                               |                   | v3.7      | [3.7.0](packages/cpd-platform-operator/3.7.0.md)            |
|                               |                   | v3.6      | [3.6.0](packages/cpd-platform-operator/3.6.0.md)            |
|                               |                   | v3.5      | [3.5.0](packages/cpd-platform-operator/3.5.0.md)            |
|                               |                   | v3.4      | [3.4.0](packages/cpd-platform-operator/3.4.0.md)            |
|                               |                   | v3.3      | [3.3.0](packages/cpd-platform-operator/3.3.0.md)            |
|                               |                   | v3.2      | [3.2.0](packages/cpd-platform-operator/3.2.0.md)            |
|                               |                   | v3.1      | [3.1.0](packages/cpd-platform-operator/3.1.0.md)            |
|                               |                   | v3.0      | [3.0.0](packages/cpd-platform-operator/3.0.0.md)            |
|                               |                   | v2.0      | [2.0.8](packages/cpd-platform-operator/2.0.8.md)            |
|                               |                   | stable-v1 | [2.0.0](packages/cpd-platform-operator/2.0.0.md)            |
|                               |                   | beta      | [2.0.0](packages/cpd-platform-operator/2.0.0.md)            |
| ibm-ca-operator               | v27.3             | v4.0      | [4.0.8](packages/ibm-ca-operator/4.0.8.md)                  |
|                               |                   | v27.3     | [27.3.0](packages/ibm-ca-operator/27.3.0.md)                |
|                               |                   | v27.2     | [27.2.0](packages/ibm-ca-operator/27.2.0.md)                |
|                               |                   | v27.1     | [27.1.0](packages/ibm-ca-operator/27.1.0.md)                |
|                               |                   | v27.0     | [27.0.0](packages/ibm-ca-operator/27.0.0.md)                |
|                               |                   | v26.3     | [26.3.1](packages/ibm-ca-operator/26.3.1.md)                |
|                               |                   | v26.2     | [26.2.0](packages/ibm-ca-operator/26.2.0.md)                |
|                               |                   | v26.1     | [26.1.0](packages/ibm-ca-operator/26.1.0.md)                |
|                               |                   | v26.0     | [26.0.0](packages/ibm-ca-operator/26.0.0.md)                |
|                               |                   | v25.9     | [25.9.0](packages/ibm-ca-operator/25.9.0.md)                |
|                               |                   | v25.8     | [25.8.0](packages/ibm-ca-operator/25.8.0.md)                |
|                               |                   | v25.4     | [25.4.0](packages/ibm-ca-operator/25.4.0.md)                |
|                               |                   | v25.3     | [25.3.0](packages/ibm-ca-operator/25.3.0.md)                |
|                               |                   | v25.2     | [25.2.0](packages/ibm-ca-operator/25.2.0.md)                |
|                               |                   | v25.0     | [25.0.0](packages/ibm-ca-operator/25.0.0.md)                |
|                               |                   | v24.3     | [24.3.0](packages/ibm-ca-operator/24.3.0.md)                |
|                               |                   | v24.0     | [24.0.0](packages/ibm-ca-operator/24.0.0.md)                |
|                               |                   | v23.5     | [23.5.0](packages/ibm-ca-operator/23.5.0.md)                |
|                               |                   | v23.4     | [23.4.0](packages/ibm-ca-operator/23.4.0.md)                |
|                               |                   | v23.3     | [23.3.0](packages/ibm-ca-operator/23.3.0.md)                |
|                               |                   | v23.1     | [23.1.0](packages/ibm-ca-operator/23.1.0.md)                |
|                               |                   | v23.0     | [23.0.0](packages/ibm-ca-operator/23.0.0.md)                |
|                               |                   | v22.3     | [22.3.0](packages/ibm-ca-operator/22.3.0.md)                |
|                               |                   | v22.2     | [22.2.0](packages/ibm-ca-operator/22.2.0.md)                |
|                               |                   | v22.1     | [22.1.0](packages/ibm-ca-operator/22.1.0.md)                |
|                               |                   | v22.0     | [22.0.0](packages/ibm-ca-operator/22.0.0.md)                |
| ibm-cpd-canvasbase            | v10.2             | v9.0      | [9.0.0](packages/ibm-cpd-canvasbase/9.0.0.md)               |
|                               |                   | v8.5      | [8.5.0](packages/ibm-cpd-canvasbase/8.5.0.md)               |
|                               |                   | v8.4      | [8.4.0](packages/ibm-cpd-canvasbase/8.4.0.md)               |
|                               |                   | v8.3      | [8.3.0](packages/ibm-cpd-canvasbase/8.3.0.md)               |
|                               |                   | v8.1      | [8.1.0](packages/ibm-cpd-canvasbase/8.1.0.md)               |
|                               |                   | v8.0      | [8.0.0](packages/ibm-cpd-canvasbase/8.0.0.md)               |
|                               |                   | v10.2     | [10.2.0](packages/ibm-cpd-canvasbase/10.2.0.md)             |
|                               |                   | v10.0     | [10.0.0](packages/ibm-cpd-canvasbase/10.0.0.md)             |
| ibm-cpd-ccs                   | v10.3             | v9.3      | [9.3.0](packages/ibm-cpd-ccs/9.3.0.md)                      |
|                               |                   | v9.2      | [9.2.0](packages/ibm-cpd-ccs/9.2.0.md)                      |
|                               |                   | v9.1      | [9.1.0](packages/ibm-cpd-ccs/9.1.0.md)                      |
|                               |                   | v9.0      | [9.0.0](packages/ibm-cpd-ccs/9.0.0.md)                      |
|                               |                   | v8.9      | [8.9.0](packages/ibm-cpd-ccs/8.9.0.md)                      |
|                               |                   | v8.8      | [8.8.0](packages/ibm-cpd-ccs/8.8.0.md)                      |
|                               |                   | v8.7      | [8.7.0](packages/ibm-cpd-ccs/8.7.0.md)                      |
|                               |                   | v8.6      | [8.6.0](packages/ibm-cpd-ccs/8.6.0.md)                      |
|                               |                   | v8.5      | [8.5.0](packages/ibm-cpd-ccs/8.5.0.md)                      |
|                               |                   | v8.4      | [8.4.0](packages/ibm-cpd-ccs/8.4.0.md)                      |
|                               |                   | v8.3      | [8.3.0](packages/ibm-cpd-ccs/8.3.0.md)                      |
|                               |                   | v8.2      | [8.2.0](packages/ibm-cpd-ccs/8.2.0.md)                      |
|                               |                   | v8.1      | [8.1.0](packages/ibm-cpd-ccs/8.1.0.md)                      |
|                               |                   | v8.0      | [8.0.0](packages/ibm-cpd-ccs/8.0.0.md)                      |
|                               |                   | v7.3      | [7.3.0](packages/ibm-cpd-ccs/7.3.0.md)                      |
|                               |                   | v7.2      | [7.2.0](packages/ibm-cpd-ccs/7.2.0.md)                      |
|                               |                   | v7.1      | [7.1.0](packages/ibm-cpd-ccs/7.1.0.md)                      |
|                               |                   | v7.0      | [7.0.0](packages/ibm-cpd-ccs/7.0.0.md)                      |
|                               |                   | v6.5      | [6.5.0](packages/ibm-cpd-ccs/6.5.0.md)                      |
|                               |                   | v6.4      | [6.4.0](packages/ibm-cpd-ccs/6.4.0.md)                      |
|                               |                   | v6.3      | [6.3.0](packages/ibm-cpd-ccs/6.3.0.md)                      |
|                               |                   | v6.1      | [6.1.0](packages/ibm-cpd-ccs/6.1.0.md)                      |
|                               |                   | v6.0      | [6.0.0](packages/ibm-cpd-ccs/6.0.0.md)                      |
|                               |                   | v2.3      | [2.3.0](packages/ibm-cpd-ccs/2.3.0.md)                      |
|                               |                   | v2.2      | [2.2.0](packages/ibm-cpd-ccs/2.2.0.md)                      |
|                               |                   | v2.1      | [2.1.0](packages/ibm-cpd-ccs/2.1.0.md)                      |
|                               |                   | v2.0      | [2.0.0](packages/ibm-cpd-ccs/2.0.0.md)                      |
|                               |                   | v10.3     | [10.3.0](packages/ibm-cpd-ccs/10.3.0.md)                    |
|                               |                   | v10.2     | [10.2.0](packages/ibm-cpd-ccs/10.2.0.md)                    |
|                               |                   | v10.1     | [10.1.0](packages/ibm-cpd-ccs/10.1.0.md)                    |
|                               |                   | v10.0     | [10.0.0](packages/ibm-cpd-ccs/10.0.0.md)                    |
|                               |                   | v1.0      | [1.0.9](packages/ibm-cpd-ccs/1.0.9.md)                      |
| ibm-cpd-datarefinery          | v10.2             | v9.3      | [9.3.0](packages/ibm-cpd-datarefinery/9.3.0.md)             |
|                               |                   | v9.1      | [9.1.0](packages/ibm-cpd-datarefinery/9.1.0.md)             |
|                               |                   | v9.0      | [9.0.0](packages/ibm-cpd-datarefinery/9.0.0.md)             |
|                               |                   | v8.9      | [8.9.0](packages/ibm-cpd-datarefinery/8.9.0.md)             |
|                               |                   | v8.7      | [8.7.0](packages/ibm-cpd-datarefinery/8.7.0.md)             |
|                               |                   | v8.6      | [8.6.0](packages/ibm-cpd-datarefinery/8.6.0.md)             |
|                               |                   | v8.5      | [8.5.0](packages/ibm-cpd-datarefinery/8.5.0.md)             |
|                               |                   | v8.4      | [8.4.0](packages/ibm-cpd-datarefinery/8.4.0.md)             |
|                               |                   | v8.3      | [8.3.0](packages/ibm-cpd-datarefinery/8.3.0.md)             |
|                               |                   | v8.1      | [8.1.0](packages/ibm-cpd-datarefinery/8.1.0.md)             |
|                               |                   | v8.0      | [8.0.0](packages/ibm-cpd-datarefinery/8.0.0.md)             |
|                               |                   | v7.0      | [7.0.0](packages/ibm-cpd-datarefinery/7.0.0.md)             |
|                               |                   | v6.5      | [6.5.0](packages/ibm-cpd-datarefinery/6.5.0.md)             |
|                               |                   | v6.4      | [6.4.0](packages/ibm-cpd-datarefinery/6.4.0.md)             |
|                               |                   | v6.3      | [6.3.0](packages/ibm-cpd-datarefinery/6.3.0.md)             |
|                               |                   | v6.1      | [6.1.0](packages/ibm-cpd-datarefinery/6.1.0.md)             |
|                               |                   | v6.0      | [6.0.0](packages/ibm-cpd-datarefinery/6.0.0.md)             |
|                               |                   | v2.3      | [2.3.0](packages/ibm-cpd-datarefinery/2.3.0.md)             |
|                               |                   | v2.2      | [2.2.0](packages/ibm-cpd-datarefinery/2.2.0.md)             |
|                               |                   | v2.1      | [2.1.0](packages/ibm-cpd-datarefinery/2.1.0.md)             |
|                               |                   | v2.0      | [2.0.0](packages/ibm-cpd-datarefinery/2.0.0.md)             |
|                               |                   | v10.2     | [10.2.0](packages/ibm-cpd-datarefinery/10.2.0.md)           |
|                               |                   | v10.1     | [10.1.0](packages/ibm-cpd-datarefinery/10.1.0.md)           |
|                               |                   | v10.0     | [10.0.0](packages/ibm-cpd-datarefinery/10.0.0.md)           |
|                               |                   | v1.0      | [1.0.10](packages/ibm-cpd-datarefinery/1.0.10.md)           |
| ibm-cpd-spss                  | v10.2             | v9.0      | [9.0.0](packages/ibm-cpd-spss/9.0.0.md)                     |
|                               |                   | v8.5      | [8.5.0](packages/ibm-cpd-spss/8.5.0.md)                     |
|                               |                   | v8.4      | [8.4.0](packages/ibm-cpd-spss/8.4.0.md)                     |
|                               |                   | v8.3      | [8.3.0](packages/ibm-cpd-spss/8.3.0.md)                     |
|                               |                   | v8.1      | [8.1.0](packages/ibm-cpd-spss/8.1.0.md)                     |
|                               |                   | v8.0      | [8.0.0](packages/ibm-cpd-spss/8.0.0.md)                     |
|                               |                   | v7.0      | [7.0.0](packages/ibm-cpd-spss/7.0.0.md)                     |
|                               |                   | v6.5      | [6.5.0](packages/ibm-cpd-spss/6.5.0.md)                     |
|                               |                   | v6.4      | [6.4.0](packages/ibm-cpd-spss/6.4.0.md)                     |
|                               |                   | v6.3      | [6.3.0](packages/ibm-cpd-spss/6.3.0.md)                     |
|                               |                   | v6.1      | [6.1.0](packages/ibm-cpd-spss/6.1.0.md)                     |
|                               |                   | v6.0      | [6.0.0](packages/ibm-cpd-spss/6.0.0.md)                     |
|                               |                   | v2.3      | [2.3.0](packages/ibm-cpd-spss/2.3.0.md)                     |
|                               |                   | v2.2      | [2.2.0](packages/ibm-cpd-spss/2.2.0.md)                     |
|                               |                   | v2.1      | [2.1.0](packages/ibm-cpd-spss/2.1.0.md)                     |
|                               |                   | v2.0      | [2.0.0](packages/ibm-cpd-spss/2.0.0.md)                     |
|                               |                   | v10.2     | [10.2.0](packages/ibm-cpd-spss/10.2.0.md)                   |
|                               |                   | v10.0     | [10.0.0](packages/ibm-cpd-spss/10.0.0.md)                   |
|                               |                   | v1.0      | [1.0.9](packages/ibm-cpd-spss/1.0.9.md)                     |
| ibm-cpd-wml-operator          | v7.2              | v7.2      | [7.2.0](packages/ibm-cpd-wml-operator/7.2.0.md)             |
|                               |                   | v7.1      | [7.1.0](packages/ibm-cpd-wml-operator/7.1.0.md)             |
|                               |                   | v7.0      | [7.0.0](packages/ibm-cpd-wml-operator/7.0.0.md)             |
|                               |                   | v6.3      | [6.3.0](packages/ibm-cpd-wml-operator/6.3.0.md)             |
|                               |                   | v6.1      | [6.1.0](packages/ibm-cpd-wml-operator/6.1.0.md)             |
|                               |                   | v6.0      | [6.0.0](packages/ibm-cpd-wml-operator/6.0.0.md)             |
|                               |                   | v5.9      | [5.9.0](packages/ibm-cpd-wml-operator/5.9.0.md)             |
|                               |                   | v5.7      | [5.7.0](packages/ibm-cpd-wml-operator/5.7.0.md)             |
|                               |                   | v5.6      | [5.6.0](packages/ibm-cpd-wml-operator/5.6.0.md)             |
|                               |                   | v5.5      | [5.5.0](packages/ibm-cpd-wml-operator/5.5.0.md)             |
|                               |                   | v5.4      | [5.4.0](packages/ibm-cpd-wml-operator/5.4.0.md)             |
|                               |                   | v5.3      | [5.3.0](packages/ibm-cpd-wml-operator/5.3.0.md)             |
|                               |                   | v5.1      | [5.1.0](packages/ibm-cpd-wml-operator/5.1.0.md)             |
|                               |                   | v5.0      | [5.0.0](packages/ibm-cpd-wml-operator/5.0.0.md)             |
|                               |                   | v4.0      | [4.0.0](packages/ibm-cpd-wml-operator/4.0.0.md)             |
|                               |                   | v3.5      | [3.5.0](packages/ibm-cpd-wml-operator/3.5.0.md)             |
|                               |                   | v3.4      | [3.4.0](packages/ibm-cpd-wml-operator/3.4.0.md)             |
|                               |                   | v3.3      | [3.3.0](packages/ibm-cpd-wml-operator/3.3.0.md)             |
|                               |                   | v3.1      | [3.1.0](packages/ibm-cpd-wml-operator/3.1.0.md)             |
|                               |                   | v3.0      | [3.0.0](packages/ibm-cpd-wml-operator/3.0.0.md)             |
|                               |                   | v2.3      | [2.3.0](packages/ibm-cpd-wml-operator/2.3.0.md)             |
|                               |                   | v2.2      | [2.2.0](packages/ibm-cpd-wml-operator/2.2.0.md)             |
|                               |                   | v2.1      | [2.1.0](packages/ibm-cpd-wml-operator/2.1.0.md)             |
|                               |                   | v2.0      | [2.0.0](packages/ibm-cpd-wml-operator/2.0.0.md)             |
|                               |                   | v1.1      | [1.1.8](packages/ibm-cpd-wml-operator/1.1.8.md)             |
|                               |                   | beta      | [1.0.1486](packages/ibm-cpd-wml-operator/1.0.1486.md)       |
|                               |                   | alpha     | [1.1.0](packages/ibm-cpd-wml-operator/1.1.0.md)             |
| ibm-cpd-wos                   | v7.2              | v7.2      | [7.2.0](packages/ibm-cpd-wos/7.2.0.md)                      |
|                               |                   | v7.1      | [7.1.0](packages/ibm-cpd-wos/7.1.0.md)                      |
|                               |                   | v7.0      | [7.0.0](packages/ibm-cpd-wos/7.0.0.md)                      |
|                               |                   | v6.3      | [6.3.0](packages/ibm-cpd-wos/6.3.0.md)                      |
|                               |                   | v6.1      | [6.1.0](packages/ibm-cpd-wos/6.1.0.md)                      |
|                               |                   | v6.0      | [6.0.0](packages/ibm-cpd-wos/6.0.0.md)                      |
|                               |                   | v5.9      | [5.9.0](packages/ibm-cpd-wos/5.9.0.md)                      |
|                               |                   | v5.7      | [5.7.0](packages/ibm-cpd-wos/5.7.0.md)                      |
|                               |                   | v5.6      | [5.6.0](packages/ibm-cpd-wos/5.6.0.md)                      |
|                               |                   | v5.5      | [5.5.0](packages/ibm-cpd-wos/5.5.0.md)                      |
|                               |                   | v5.4      | [5.4.0](packages/ibm-cpd-wos/5.4.0.md)                      |
|                               |                   | v5.3      | [5.3.0](packages/ibm-cpd-wos/5.3.0.md)                      |
|                               |                   | v5.0      | [5.0.0](packages/ibm-cpd-wos/5.0.0.md)                      |
|                               |                   | v4.2      | [4.2.0](packages/ibm-cpd-wos/4.2.0.md)                      |
|                               |                   | v4.0      | [4.0.0](packages/ibm-cpd-wos/4.0.0.md)                      |
|                               |                   | v3.5      | [3.5.0](packages/ibm-cpd-wos/3.5.0.md)                      |
|                               |                   | v3.4      | [3.4.0](packages/ibm-cpd-wos/3.4.0.md)                      |
|                               |                   | v3.3      | [3.3.0](packages/ibm-cpd-wos/3.3.0.md)                      |
|                               |                   | v3.1      | [3.1.0](packages/ibm-cpd-wos/3.1.0.md)                      |
|                               |                   | v3.0      | [3.0.0](packages/ibm-cpd-wos/3.0.0.md)                      |
|                               |                   | v2.3      | [2.3.0](packages/ibm-cpd-wos/2.3.0.md)                      |
|                               |                   | v2.2      | [2.2.0](packages/ibm-cpd-wos/2.2.0.md)                      |
|                               |                   | v2.1      | [2.1.0](packages/ibm-cpd-wos/2.1.0.md)                      |
|                               |                   | v2.0      | [2.0.0](packages/ibm-cpd-wos/2.0.0.md)                      |
|                               |                   | v1.5      | [1.5.4](packages/ibm-cpd-wos/1.5.4.md)                      |
|                               |                   | v1        | [1.5.0](packages/ibm-cpd-wos/1.5.0.md)                      |
|                               |                   | alpha     | [1.2.0](packages/ibm-cpd-wos/1.2.0.md)                      |
| ibm-cpd-ws-runtimes           | v10.3             | v9.3      | [9.3.0](packages/ibm-cpd-ws-runtimes/9.3.0.md)              |
|                               |                   | v9.1      | [9.1.0](packages/ibm-cpd-ws-runtimes/9.1.0.md)              |
|                               |                   | v9.0      | [9.0.0](packages/ibm-cpd-ws-runtimes/9.0.0.md)              |
|                               |                   | v8.9      | [8.9.0](packages/ibm-cpd-ws-runtimes/8.9.0.md)              |
|                               |                   | v8.7      | [8.7.0](packages/ibm-cpd-ws-runtimes/8.7.0.md)              |
|                               |                   | v8.6      | [8.6.0](packages/ibm-cpd-ws-runtimes/8.6.0.md)              |
|                               |                   | v8.5      | [8.5.0](packages/ibm-cpd-ws-runtimes/8.5.0.md)              |
|                               |                   | v8.4      | [8.4.0](packages/ibm-cpd-ws-runtimes/8.4.0.md)              |
|                               |                   | v8.3      | [8.3.0](packages/ibm-cpd-ws-runtimes/8.3.0.md)              |
|                               |                   | v8.1      | [8.1.0](packages/ibm-cpd-ws-runtimes/8.1.0.md)              |
|                               |                   | v8.0      | [8.0.0](packages/ibm-cpd-ws-runtimes/8.0.0.md)              |
|                               |                   | v7.0      | [7.0.0](packages/ibm-cpd-ws-runtimes/7.0.0.md)              |
|                               |                   | v6.5      | [6.5.0](packages/ibm-cpd-ws-runtimes/6.5.0.md)              |
|                               |                   | v6.4      | [6.4.0](packages/ibm-cpd-ws-runtimes/6.4.0.md)              |
|                               |                   | v6.3      | [6.3.0](packages/ibm-cpd-ws-runtimes/6.3.0.md)              |
|                               |                   | v6.1      | [6.1.0](packages/ibm-cpd-ws-runtimes/6.1.0.md)              |
|                               |                   | v6.0      | [6.0.0](packages/ibm-cpd-ws-runtimes/6.0.0.md)              |
|                               |                   | v5.3      | [5.3.0](packages/ibm-cpd-ws-runtimes/5.3.0.md)              |
|                               |                   | v5.2      | [5.2.0](packages/ibm-cpd-ws-runtimes/5.2.0.md)              |
|                               |                   | v5.1      | [5.1.0](packages/ibm-cpd-ws-runtimes/5.1.0.md)              |
|                               |                   | v5.0      | [5.0.0](packages/ibm-cpd-ws-runtimes/5.0.0.md)              |
|                               |                   | v10.3     | [10.3.0](packages/ibm-cpd-ws-runtimes/10.3.0.md)            |
|                               |                   | v10.2     | [10.2.0](packages/ibm-cpd-ws-runtimes/10.2.0.md)            |
|                               |                   | v10.1     | [10.1.0](packages/ibm-cpd-ws-runtimes/10.1.0.md)            |
|                               |                   | v10.0     | [10.0.0](packages/ibm-cpd-ws-runtimes/10.0.0.md)            |
|                               |                   | v1.0      | [1.0.9](packages/ibm-cpd-ws-runtimes/1.0.9.md)              |
| ibm-cpd-wsl                   | v10.2             | v9.3      | [9.3.0](packages/ibm-cpd-wsl/9.3.0.md)                      |
|                               |                   | v9.1      | [9.1.0](packages/ibm-cpd-wsl/9.1.0.md)                      |
|                               |                   | v9.0      | [9.0.0](packages/ibm-cpd-wsl/9.0.0.md)                      |
|                               |                   | v8.9      | [8.9.0](packages/ibm-cpd-wsl/8.9.0.md)                      |
|                               |                   | v8.7      | [8.7.0](packages/ibm-cpd-wsl/8.7.0.md)                      |
|                               |                   | v8.6      | [8.6.0](packages/ibm-cpd-wsl/8.6.0.md)                      |
|                               |                   | v8.5      | [8.5.0](packages/ibm-cpd-wsl/8.5.0.md)                      |
|                               |                   | v8.4      | [8.4.0](packages/ibm-cpd-wsl/8.4.0.md)                      |
|                               |                   | v8.3      | [8.3.0](packages/ibm-cpd-wsl/8.3.0.md)                      |
|                               |                   | v8.1      | [8.1.0](packages/ibm-cpd-wsl/8.1.0.md)                      |
|                               |                   | v8.0      | [8.0.0](packages/ibm-cpd-wsl/8.0.0.md)                      |
|                               |                   | v7.0      | [7.0.0](packages/ibm-cpd-wsl/7.0.0.md)                      |
|                               |                   | v6.5      | [6.5.0](packages/ibm-cpd-wsl/6.5.0.md)                      |
|                               |                   | v6.4      | [6.4.0](packages/ibm-cpd-wsl/6.4.0.md)                      |
|                               |                   | v6.3      | [6.3.0](packages/ibm-cpd-wsl/6.3.0.md)                      |
|                               |                   | v6.1      | [6.1.0](packages/ibm-cpd-wsl/6.1.0.md)                      |
|                               |                   | v6.0      | [6.0.0](packages/ibm-cpd-wsl/6.0.0.md)                      |
|                               |                   | v3.3      | [3.3.0](packages/ibm-cpd-wsl/3.3.0.md)                      |
|                               |                   | v3.2      | [3.2.0](packages/ibm-cpd-wsl/3.2.0.md)                      |
|                               |                   | v3.1      | [3.1.0](packages/ibm-cpd-wsl/3.1.0.md)                      |
|                               |                   | v3.0      | [3.0.0](packages/ibm-cpd-wsl/3.0.0.md)                      |
|                               |                   | v2.0      | [2.0.9](packages/ibm-cpd-wsl/2.0.9.md)                      |
|                               |                   | v10.2     | [10.2.0](packages/ibm-cpd-wsl/10.2.0.md)                    |
|                               |                   | v10.1     | [10.1.0](packages/ibm-cpd-wsl/10.1.0.md)                    |
|                               |                   | v10.0     | [10.0.0](packages/ibm-cpd-wsl/10.0.0.md)                    |
| ibm-elasticsearch-operator    | v1.1              | v1.1      | [1.1.2570](packages/ibm-elasticsearch-operator/1.1.2570.md) |
| ibm-etcd-operator             | v1.0              | v1.0      | [1.0.42](packages/ibm-etcd-operator/1.0.42.md)              |
| ibm-iam-operator              | v3.23             | v4.9      | [4.9.0](packages/ibm-iam-operator/4.9.0.md)                 |
|                               |                   | v4.8      | [4.8.0](packages/ibm-iam-operator/4.8.0.md)                 |
|                               |                   | v4.7      | [4.7.0](packages/ibm-iam-operator/4.7.0.md)                 |
|                               |                   | v4.6      | [4.6.0](packages/ibm-iam-operator/4.6.0.md)                 |
|                               |                   | v4.5      | [4.5.11](packages/ibm-iam-operator/4.5.11.md)               |
|                               |                   | v4.4      | [4.4.0](packages/ibm-iam-operator/4.4.0.md)                 |
|                               |                   | v4.3      | [4.3.1](packages/ibm-iam-operator/4.3.1.md)                 |
|                               |                   | v4.2      | [4.2.0](packages/ibm-iam-operator/4.2.0.md)                 |
|                               |                   | v4.11     | [4.11.0](packages/ibm-iam-operator/4.11.0.md)               |
|                               |                   | v4.10     | [4.10.0](packages/ibm-iam-operator/4.10.0.md)               |
|                               |                   | v4.1      | [4.1.0](packages/ibm-iam-operator/4.1.0.md)                 |
|                               |                   | v4.0      | [4.0.1](packages/ibm-iam-operator/4.0.1.md)                 |
|                               |                   | v3.23     | [3.23.14](packages/ibm-iam-operator/3.23.14.md)             |
|                               |                   | v3.22     | [3.22.0](packages/ibm-iam-operator/3.22.0.md)               |
|                               |                   | v3.21     | [3.21.0](packages/ibm-iam-operator/3.21.0.md)               |
|                               |                   | v3.20     | [3.20.1](packages/ibm-iam-operator/3.20.1.md)               |
|                               |                   | v3        | [3.23.14](packages/ibm-iam-operator/3.23.14.md)             |
|                               |                   | beta      | [3.9.1](packages/ibm-iam-operator/3.9.1.md)                 |
| ibm-minio-operator            | v1.0              | v1.0      | [1.0.18](packages/ibm-minio-operator/1.0.18.md)             |
| ibm-model-train-operator      | v2.0              | v2.0      | [2.0.0](packages/ibm-model-train-operator/2.0.0.md)         |
|                               |                   | v1.1      | [1.1.15](packages/ibm-model-train-operator/1.1.15.md)       |
| ibm-rabbitmq-operator         | v1.0              | v1.0      | [1.0.39](packages/ibm-rabbitmq-operator/1.0.39.md)          |
| ibm-watson-discovery-operator | v9.2              | v9.2      | [9.2.0](packages/ibm-watson-discovery-operator/9.2.0.md)    |
|                               |                   | v9.1      | [9.1.0](packages/ibm-watson-discovery-operator/9.1.0.md)    |
|                               |                   | v9.0      | [9.0.0](packages/ibm-watson-discovery-operator/9.0.0.md)    |
|                               |                   | v8.3      | [8.3.0](packages/ibm-watson-discovery-operator/8.3.0.md)    |
|                               |                   | v8.1      | [8.1.0](packages/ibm-watson-discovery-operator/8.1.0.md)    |
|                               |                   | v8.0      | [8.0.0](packages/ibm-watson-discovery-operator/8.0.0.md)    |
|                               |                   | v7.9      | [7.9.0](packages/ibm-watson-discovery-operator/7.9.0.md)    |
|                               |                   | v7.8      | [7.8.0](packages/ibm-watson-discovery-operator/7.8.0.md)    |
|                               |                   | v7.7      | [7.7.0](packages/ibm-watson-discovery-operator/7.7.0.md)    |
|                               |                   | v7.6      | [7.6.0](packages/ibm-watson-discovery-operator/7.6.0.md)    |
|                               |                   | v7.5      | [7.5.0](packages/ibm-watson-discovery-operator/7.5.0.md)    |
|                               |                   | v7.4      | [7.4.0](packages/ibm-watson-discovery-operator/7.4.0.md)    |
|                               |                   | v7.3      | [7.3.0](packages/ibm-watson-discovery-operator/7.3.0.md)    |
|                               |                   | v7.2      | [7.2.0](packages/ibm-watson-discovery-operator/7.2.0.md)    |
|                               |                   | v7.0      | [7.0.0](packages/ibm-watson-discovery-operator/7.0.0.md)    |
|                               |                   | v6.3      | [6.3.0](packages/ibm-watson-discovery-operator/6.3.0.md)    |
|                               |                   | v6.1      | [6.1.0](packages/ibm-watson-discovery-operator/6.1.0.md)    |
|                               |                   | v6.0      | [6.0.0](packages/ibm-watson-discovery-operator/6.0.0.md)    |
|                               |                   | v5.5      | [5.5.0](packages/ibm-watson-discovery-operator/5.5.0.md)    |
|                               |                   | v5.3      | [5.3.0](packages/ibm-watson-discovery-operator/5.3.0.md)    |
|                               |                   | v5.2      | [5.2.0](packages/ibm-watson-discovery-operator/5.2.0.md)    |
|                               |                   | v5.0      | [5.0.0](packages/ibm-watson-discovery-operator/5.0.0.md)    |
|                               |                   | v4.7      | [4.7.0](packages/ibm-watson-discovery-operator/4.7.0.md)    |
|                               |                   | v4.6      | [4.6.0](packages/ibm-watson-discovery-operator/4.6.0.md)    |
|                               |                   | v4.5      | [4.5.0](packages/ibm-watson-discovery-operator/4.5.0.md)    |
|                               |                   | v4.0      | [4.0.9](packages/ibm-watson-discovery-operator/4.0.9.md)    |
| ibm-watson-gateway-operator   | v1.0              | v1.0      | [1.0.42](packages/ibm-watson-gateway-operator/1.0.42.md)    |

### IBM Db2 Universal Operator
| Package       | Default Channel   | Channel   | Latest Version                                     |
|---------------|-------------------|-----------|----------------------------------------------------|
| db2u-operator | v110509.0         | v6.0      | [6.0.0](packages/db2u-operator/6.0.0.md)           |
|               |                   | v5.3      | [5.3.0](packages/db2u-operator/5.3.0.md)           |
|               |                   | v5.2      | [5.2.0](packages/db2u-operator/5.2.0.md)           |
|               |                   | v5.1      | [5.1.0](packages/db2u-operator/5.1.0.md)           |
|               |                   | v5.0      | [5.0.0](packages/db2u-operator/5.0.0.md)           |
|               |                   | v4.2      | [4.2.0](packages/db2u-operator/4.2.0.md)           |
|               |                   | v4.1      | [4.1.0](packages/db2u-operator/4.1.0.md)           |
|               |                   | v4.0      | [4.0.0](packages/db2u-operator/4.0.0.md)           |
|               |                   | v3.2      | [3.2.0](packages/db2u-operator/3.2.0.md)           |
|               |                   | v3.1      | [3.1.0](packages/db2u-operator/3.1.0.md)           |
|               |                   | v3.0      | [3.0.0](packages/db2u-operator/3.0.0.md)           |
|               |                   | v2.2      | [2.2.0](packages/db2u-operator/2.2.0.md)           |
|               |                   | v2.1      | [2.1.0](packages/db2u-operator/2.1.0.md)           |
|               |                   | v2.0      | [2.0.0](packages/db2u-operator/2.0.0.md)           |
|               |                   | v110509.0 | [110509.0.2](packages/db2u-operator/110509.0.2.md) |
|               |                   | v110508.0 | [110508.0.3](packages/db2u-operator/110508.0.3.md) |
|               |                   | v1.1      | [1.1.13](packages/db2u-operator/1.1.13.md)         |
|               |                   | v1.0      | [1.0.11](packages/db2u-operator/1.0.11.md)         |

### IBM AppConnect
| Package          | Default Channel   | Channel   | Latest Version                                |
|------------------|-------------------|-----------|-----------------------------------------------|
| couchdb-operator | v2.2              | v2.2      | [2.2.1](packages/couchdb-operator/2.2.1.md)   |
|                  |                   | v2.1      | [2.0.1](packages/couchdb-operator/2.0.1.md)   |
|                  |                   | v2.0      | [2.0.0](packages/couchdb-operator/2.0.0.md)   |
|                  |                   | v1.4      | [1.4.4](packages/couchdb-operator/1.4.4.md)   |
|                  |                   | v1.3      | [1.3.1](packages/couchdb-operator/1.3.1.md)   |
|                  |                   | v1.2      | [1.2.1](packages/couchdb-operator/1.2.1.md)   |
|                  |                   | v1.1      | [1.1.0](packages/couchdb-operator/1.1.0.md)   |
|                  |                   | v1.0      | [1.0.14](packages/couchdb-operator/1.0.14.md) |
|                  |                   | stable    | [2.2.1](packages/couchdb-operator/2.2.1.md)   |
|                  |                   | beta      | [1.4.2](packages/couchdb-operator/1.4.2.md)   |
| ibm-appconnect   | v12.10            | v9.2      | 9.2.1                                         |
|                  |                   | v9.1      | 9.1.0                                         |
|                  |                   | v9.0      | 9.0.0                                         |
|                  |                   | v8.2      | 8.2.1                                         |
|                  |                   | v8.1      | 8.1.0                                         |
|                  |                   | v8.0      | 8.0.0                                         |
|                  |                   | v7.2      | 7.2.0                                         |
|                  |                   | v7.1      | 7.1.0                                         |
|                  |                   | v7.0      | 7.0.0                                         |
|                  |                   | v6.2      | 6.2.0                                         |
|                  |                   | v6.1      | 6.1.1                                         |
|                  |                   | v6.0      | 6.0.0                                         |
|                  |                   | v5.2      | 5.2.0                                         |
|                  |                   | v5.1      | 5.1.0                                         |
|                  |                   | v5.0-lts  | 5.0.22                                        |
|                  |                   | v4.2      | 4.2.0                                         |
|                  |                   | v4.1      | 4.1.0                                         |
|                  |                   | v4.0      | 4.0.0                                         |
|                  |                   | v3.1      | 3.1.0                                         |
|                  |                   | v3.0      | 3.0.0                                         |
|                  |                   | v2.1      | 2.1.0                                         |
|                  |                   | v2.0      | 2.0.0                                         |
|                  |                   | v12.9     | 12.9.0                                        |
|                  |                   | v12.8     | 12.8.2                                        |
|                  |                   | v12.7     | 12.7.0                                        |
|                  |                   | v12.6     | 12.6.0                                        |
|                  |                   | v12.5     | 12.5.1                                        |
|                  |                   | v12.4     | 12.4.0                                        |
|                  |                   | v12.3     | 12.3.0                                        |
|                  |                   | v12.2     | 12.2.1                                        |
|                  |                   | v12.10    | 12.10.1                                       |
|                  |                   | v12.1     | 12.1.2                                        |
|                  |                   | v12.0-sc2 | 12.0.11                                       |
|                  |                   | v11.6     | 11.6.0                                        |
|                  |                   | v11.5     | 11.5.1                                        |
|                  |                   | v11.4     | 11.4.0                                        |
|                  |                   | v11.3     | 11.3.0                                        |
|                  |                   | v11.2     | 11.2.1                                        |
|                  |                   | v11.1     | 11.1.0                                        |
|                  |                   | v11.0     | 11.0.1                                        |
|                  |                   | v10.1     | 10.1.1                                        |
|                  |                   | v10.0     | 10.0.1                                        |
|                  |                   | v1.5      | [1.5.2](packages/ibm-appconnect/1.5.2.md)     |
|                  |                   | v1.4      | [1.4.0](packages/ibm-appconnect/1.4.0.md)     |
|                  |                   | v1.3      | [1.3.2](packages/ibm-appconnect/1.3.2.md)     |
|                  |                   | v1.2      | [1.2.0](packages/ibm-appconnect/1.2.0.md)     |
|                  |                   | v1.1-eus  | [1.1.10](packages/ibm-appconnect/1.1.10.md)   |
|                  |                   | v1.0      | [1.0.5](packages/ibm-appconnect/1.0.5.md)     |
|                  |                   | cd        | 5.2.0                                         |

### Eclipse Amlen
| Package                | Default Channel   | Channel   | Latest Version                                    |
|------------------------|-------------------|-----------|---------------------------------------------------|
| eclipse-amlen-operator | 1.x               | 1.x       | [1.1.3](packages/eclipse-amlen-operator/1.1.3.md) |