IBM Maximo Operator Catalog v9 (250828)
===============================================================================

Details
-------------------------------------------------------------------------------
<table>
  <tr><td>Image</td><td>icr.io/cpopen/ibm-maximo-operator-catalog</tr></tr>
  <tr><td>Tag</td><td>v9-250828-s390x</tr></tr>
  <tr><td>Digest</td><td>sha256:8d6f205e59ac55155db6cf348029d52c035236bd60c8d212dcf2634e0a716cb1</tr></tr>
</table>


What's New
-------------------------------------------------------------------------------
- **Security updates and bug fixes**
    - IBM Maximo Application Suite Core Platform v9.0 and v9.1
    - IBM Maximo Manage v9.0 and 9.1
    - IBM Suite License Service v3.12

Manual Installation
-------------------------------------------------------------------------------
`oc apply -f https://raw.githubusercontent.com/ibm-mas/cli/master/catalogs/v9-250828-s390x.yaml`


Source
-------------------------------------------------------------------------------
```yaml
apiVersion: operators.coreos.com/v1alpha1
kind: CatalogSource
metadata:
  name: ibm-operator-catalog
  namespace: openshift-marketplace
spec:
  displayName: IBM Maximo Operators (v9-250828-s390x)
  publisher: IBM
  description: Static Catalog Source for IBM Maximo Application Suite
  sourceType: grpc
  image: icr.io/cpopen/ibm-maximo-operator-catalog@sha256:8d6f205e59ac55155db6cf348029d52c035236bd60c8d212dcf2634e0a716cb1
  priority: 90
```


Red Hat OpenShift Container Platform Support
-------------------------------------------------------------------------------
For more information about the OCP lifecycle refer to the [Red Hat OpenShift Container Platform Life Cycle Policy](https://access.redhat.com/support/policy/updates/openshift/).

IBM Maximo Application Suite customers receive a standard Red Hat OpenShift Container Platform subscription as part of their purchase. This includes 18 months of maintenance support for each OpenShift minor release.  A further 6 months support is available to purchase as an Extended Update Support (EUS) Add-on to x86-64 versions of Red Hat OpenShift Kubernetes Engine, Red Hat OpenShift Container Platform, and Red Hat OpenShift Platform Plus Standard subscriptions.

<table class="compatabilityMatrix">
  <tr>
    <th>OCP</th><td rowspan="6" class="spacer"></td>
    <th>General Availability</th>
    <th>Standard Support</th>
    <th>Extended Support</th>
  </tr>
  <tr>
    <td class="firstColumn">4.18</td>
    <td>February 25, 2025</td>
    <td>GA of 4.19 + 3 Months</td>
    <td>August 25, 2026</td>
  </tr>
  <tr>
    <td class="firstColumn">4.17</td>
    <td>October 1, 2024</td>
    <td>May 25, 2025</td>
    <td>April 1, 2026</td>
  </tr>
  <tr>
    <td class="firstColumn">4.16</td>
    <td>June 27, 2024</td>
    <td>December 27, 2025</td>
    <td>June 27, 2027</td>
  </tr>
  <tr>
    <td class="firstColumn">4.15</td>
    <td>February 27, 2024</td>
    <td>August 27, 2025</td>
    <td>N/A</td>
  </tr>
  <tr>
    <td class="firstColumn">4.14</td>
    <td>October 31, 2023</td>
    <td>May 1, 2025</td>
    <td>October 31, 2026</td>
  </tr>
</table>


### Certified Operators
The following packages from the `registry.redhat.io/redhat/certified-operator-index` catalog are used in the Maximo Application Suite install:

- **gpu-operator-certified** required by `ibm.mas_devops.nvidia_gpu` role
- **kubeturbo-certified** required by `ibm.mas_devops.kubeturbo` role


### Community Operators
The following packages from the `registry.redhat.io/redhat/community-operator-index` catalog are used in the Maximo Application Suite install:

- **grafana-operator** required by `ibm.mas_devops.grafana` role
- **opentelemetry-operator** required by `ibm.mas_devops.opentelemetry` role
- **strimzi-kafka-operator** required by `ibm.mas_devops.kafka` role (if using Strimzi as Kakfa provider)


### Red Hat Operators
The following packages from the `registry.redhat.io/redhat/redhat-operator-index` catalog are used in the Maximo Application Suite install:

- **amq-streams** required by `ibm.mas_devops.kafka` role (if using AMQ Streams as Kakfa provider)
- **openshift-pipelines-operator-rh** required by the MAS CLI
- **nfd** required by `ibm.mas_devops.nvidia_gpu` role
- **aws-efs-csi-driver-operator**  required by `ibm.mas_devops.ocp_efs` role
- **local-storage-operator**  required by `ibm.mas_devops.ocs` role
- **odf-operator**  required by `ibm.mas_devops.ocs` role


### IBM Maximo Application Suite
| Package        | Default Channel   | Channel       | Latest Version                              |
|----------------|-------------------|---------------|---------------------------------------------|
| ibm-mas        | 9.1.x             | 9.1.x-feature | [9.1.0](packages/ibm-mas/9.1.0.md)          |
|                |                   | 9.1.x         | [9.1.2](packages/ibm-mas/9.1.2.md)          |
|                |                   | 9.0.x         | [9.0.14](packages/ibm-mas/9.0.14.md)        |
| ibm-mas-manage | 9.1.x             | 9.1.x-feature | [9.1.0](packages/ibm-mas-manage/9.1.0.md)   |
|                |                   | 9.1.x         | [9.1.2](packages/ibm-mas-manage/9.1.2.md)   |
|                |                   | 9.0.x         | [9.0.16](packages/ibm-mas-manage/9.0.16.md) |

### IBM Utilities
| Package            | Default Channel   | Channel   | Latest Version                                |
|--------------------|-------------------|-----------|-----------------------------------------------|
| ibm-sls            | 3.x               | 3.x       | [3.12.2](packages/ibm-sls/3.12.2.md)          |
| ibm-truststore-mgr | 1.x               | 1.x       | [1.7.0](packages/ibm-truststore-mgr/1.7.0.md) |

### IBM Db2 Universal Operator
| Package       | Default Channel   | Channel   | Latest Version                                     |
|---------------|-------------------|-----------|----------------------------------------------------|
| db2u-operator | v110509.0         | v7.3      | [7.3.0](packages/db2u-operator/7.3.0.md)           |
|               |                   | v7.1      | [7.1.0](packages/db2u-operator/7.1.0.md)           |
|               |                   | v6.1      | [6.1.0](packages/db2u-operator/6.1.0.md)           |
|               |                   | v6.0      | [6.0.0](packages/db2u-operator/6.0.0.md)           |
|               |                   | v5.4      | [5.4.0](packages/db2u-operator/5.4.0.md)           |
|               |                   | v5.3      | [5.3.0](packages/db2u-operator/5.3.0.md)           |
|               |                   | v5.2      | [5.2.0](packages/db2u-operator/5.2.0.md)           |
|               |                   | v5.1      | [5.1.0](packages/db2u-operator/5.1.0.md)           |
|               |                   | v5.0      | [5.0.0](packages/db2u-operator/5.0.0.md)           |
|               |                   | v4.2      | [4.2.0](packages/db2u-operator/4.2.0.md)           |
|               |                   | v4.1      | [4.1.0](packages/db2u-operator/4.1.0.md)           |
|               |                   | v4.0      | [4.0.0](packages/db2u-operator/4.0.0.md)           |
|               |                   | v3.2      | [3.2.0](packages/db2u-operator/3.2.0.md)           |
|               |                   | v3.1      | [3.1.0](packages/db2u-operator/3.1.0.md)           |
|               |                   | v3.0      | [3.0.0](packages/db2u-operator/3.0.0.md)           |
|               |                   | v2.2      | [2.2.0](packages/db2u-operator/2.2.0.md)           |
|               |                   | v2.1      | [2.1.0](packages/db2u-operator/2.1.0.md)           |
|               |                   | v2.0      | [2.0.0](packages/db2u-operator/2.0.0.md)           |
|               |                   | v110509.0 | [110509.0.5](packages/db2u-operator/110509.0.5.md) |
|               |                   | v110508.0 | [110508.0.3](packages/db2u-operator/110508.0.3.md) |
|               |                   | v1.1      | [1.1.13](packages/db2u-operator/1.1.13.md)         |
|               |                   | v1.0      | [1.0.11](packages/db2u-operator/1.0.11.md)         |
