# Generated by Django 3.2.13 on 2023-03-15 23:06

import django.db.models.deletion
import wagtail.blocks
import wagtail.contrib.table_block.blocks
import wagtail.contrib.typed_table_block.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtailmarkdown.blocks
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailcore", "0078_referenceindex"),
    ]

    operations = [
        migrations.CreateModel(
            name="IABAnnouncementIndexPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        blank=True,
                        help_text="Enter the title to display on the page, you can use only 255 characters.",
                        max_length=255,
                    ),
                ),
            ],
            options={
                "verbose_name": "IAB Announcement Index Page",
            },
            bases=("wagtailcore.page",),
        ),
        migrations.CreateModel(
            name="IABAnnouncementPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                ("date", models.DateTimeField()),
                (
                    "introduction",
                    models.CharField(
                        blank=True,
                        help_text="Enter the title to display on the page, you can use only 255 characters.",
                        max_length=255,
                    ),
                ),
                (
                    "body",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            (
                                "markdown",
                                wagtailmarkdown.blocks.MarkdownBlock(icon="code"),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"},
                                    template="includes/tableblock.html",
                                ),
                            ),
                            (
                                "typed_table",
                                wagtail.contrib.typed_table_block.blocks.TypedTableBlock(
                                    [
                                        ("text", wagtail.blocks.CharBlock()),
                                        ("numeric", wagtail.blocks.FloatBlock()),
                                        ("rich_text", wagtail.blocks.RichTextBlock()),
                                        (
                                            "image",
                                            wagtail.images.blocks.ImageChooserBlock(),
                                        ),
                                    ]
                                ),
                            ),
                        ],
                        use_json_field=True,
                    ),
                ),
            ],
            options={
                "verbose_name": "IAB Announcement Page",
            },
            bases=("wagtailcore.page",),
        ),
    ]
