# Generated by Django 1.11.29 on 2020-04-10 18:46

import django.db.models.deletion
import modelcluster.fields
import wagtail.blocks
import wagtail.contrib.routable_page.models
import wagtail.contrib.table_block.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailcore", "0040_page_draft_title"),
        ("snippets", "0001_initial"),
        ("images", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="BlogIndexPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blog Index Page",
            },
            bases=(
                wagtail.contrib.routable_page.models.RoutablePageMixin,
                "wagtailcore.page",
            ),
        ),
        migrations.CreateModel(
            name="BlogPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                (
                    "date_published",
                    models.DateTimeField(
                        blank=True,
                        help_text="Use this field to override the date that the blog post appears to have been published.",
                        null=True,
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        help_text="The page introduction text.", max_length=511
                    ),
                ),
                (
                    "body",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ]
                    ),
                ),
                (
                    "prepared_body",
                    models.TextField(
                        blank=True,
                        help_text="The prepared body content after bibliography styling has been applied. Auto-generated on each save.",
                        null=True,
                    ),
                ),
                (
                    "author_group",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.Group",
                    ),
                ),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
            ],
            options={
                "verbose_name": "Blog Page",
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="BlogPageAuthor",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "author",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="snippets.Person",
                    ),
                ),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="authors",
                        to="blog.BlogPage",
                    ),
                ),
                (
                    "role",
                    models.ForeignKey(
                        blank=True,
                        help_text="Override the person's current role for this blog post.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.Role",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="BlogPageTopic",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="topics",
                        to="blog.BlogPage",
                    ),
                ),
                (
                    "topic",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="snippets.Topic",
                    ),
                ),
            ],
        ),
    ]
