# Generated by Django 1.11.29 on 2020-04-10 18:46

import django.db.models.deletion
import modelcluster.fields
import wagtail.blocks
import wagtail.contrib.table_block.blocks
import wagtail.documents.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtail.snippets.blocks
from django.db import migrations, models

import ietf.snippets.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtailcore", "0040_page_draft_title"),
        ("images", "0001_initial"),
        ("snippets", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="EventListingPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                ("introduction", models.CharField(blank=True, max_length=511)),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="EventListingPagePromotedEvent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="promoted_events",
                        to="events.EventListingPage",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="EventPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                (
                    "start_date",
                    models.DateField(
                        blank=True,
                        help_text="The start date date of the event.",
                        null=True,
                    ),
                ),
                (
                    "end_date",
                    models.DateField(
                        blank=True, help_text="The end date of the event.", null=True
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        help_text="The introduction for the event page. Limited to 511 characters.",
                        max_length=200,
                    ),
                ),
                (
                    "body",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ]
                    ),
                ),
                (
                    "venue_section_title",
                    models.CharField(
                        blank=True, default="Meeting venue information", max_length=255
                    ),
                ),
                (
                    "venue",
                    wagtail.fields.StreamField(
                        [
                            (
                                "address_line",
                                wagtail.blocks.CharBlock(classname="full title"),
                            )
                        ],
                        blank=True,
                    ),
                ),
                (
                    "extras",
                    wagtail.fields.StreamField(
                        [("extra", wagtail.blocks.CharBlock(classname="full title"))],
                        blank=True,
                    ),
                ),
                ("reservation_name", models.CharField(blank=True, max_length=255)),
                (
                    "room_rates",
                    wagtail.fields.StreamField(
                        [
                            (
                                "room_rate",
                                wagtail.blocks.CharBlock(classname="full title"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                ("reservations_open", models.DateField(blank=True, null=True)),
                (
                    "contact_details",
                    wagtail.fields.StreamField(
                        [
                            (
                                "contact_detail",
                                wagtail.blocks.CharBlock(classname="full title"),
                            )
                        ],
                        blank=True,
                    ),
                ),
                (
                    "key_details",
                    wagtail.fields.StreamField(
                        [
                            (
                                "item",
                                wagtail.blocks.StructBlock(
                                    [
                                        ("title", wagtail.blocks.CharBlock()),
                                        (
                                            "link_group",
                                            wagtail.blocks.StreamBlock(
                                                [
                                                    (
                                                        "link",
                                                        wagtail.blocks.StructBlock(
                                                            [
                                                                (
                                                                    "title",
                                                                    wagtail.blocks.CharBlock(),
                                                                ),
                                                                (
                                                                    "link_external",
                                                                    wagtail.blocks.URLBlock(
                                                                        required=False
                                                                    ),
                                                                ),
                                                                (
                                                                    "link_page",
                                                                    wagtail.blocks.PageChooserBlock(
                                                                        required=False
                                                                    ),
                                                                ),
                                                                (
                                                                    "link_document",
                                                                    wagtail.documents.blocks.DocumentChooserBlock(
                                                                        required=False
                                                                    ),
                                                                ),
                                                            ]
                                                        ),
                                                    )
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                    ),
                ),
                (
                    "key_details_expanded",
                    models.BooleanField(
                        default=False,
                        help_text="Show the key details items expanded when the page first loads",
                    ),
                ),
                (
                    "sponsors",
                    wagtail.fields.StreamField(
                        [
                            (
                                "sponsor_category",
                                wagtail.blocks.StructBlock(
                                    [
                                        ("category_title", wagtail.blocks.CharBlock()),
                                        (
                                            "sponsor_group",
                                            wagtail.blocks.StreamBlock(
                                                [
                                                    (
                                                        "sponsor",
                                                        wagtail.snippets.blocks.SnippetChooserBlock(
                                                            ietf.snippets.models.Sponsor
                                                        ),
                                                    )
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            )
                        ],
                        blank=True,
                    ),
                ),
                (
                    "listing_location",
                    models.CharField(
                        blank=True,
                        help_text="Add a short location name to appear on the event listing.",
                        max_length=255,
                    ),
                ),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "main_image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="EventPageHost",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "host",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.Sponsor",
                    ),
                ),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="hosts",
                        to="events.EventPage",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="eventlistingpagepromotedevent",
            name="promoted_event",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="events.EventPage",
            ),
        ),
    ]
