from typed_environment_configuration import (
    BoolVariable,
    FillVars,
    StringListVariable,
    StringVariable,
)

from ..base import *  # noqa: F403

_ENVVARS = [
    StringVariable(
        "APPLICATION_VERSION"
    ),  # The Application version used across project
    StringListVariable("ADDRESSES", default=""),  # list of allowed addresses
    StringVariable("APP_SECRET_KEY", prefix="APP_"),
    StringVariable("PROJECT"),  # Project namespace
    StringVariable(
        "ENVIRONMENT"
    ),  # Application environment i.e. development, production, etc.
    StringVariable("AWS_STORAGE_BUCKET_NAME", default=""),  # S3 Bucket Name
    StringVariable("AWS_S3_CUSTOM_DOMAIN", default=""),  # S3 Domain
    StringVariable("DATABASE_URL"),  # e.g. postgres URL
    StringListVariable("WAGTAILADMIN_BASE_URL", default=""),
]

_DJANGO_ENVVARS = [
    BoolVariable("DJANGO_DEBUG", default=False),
    StringVariable("DJANGO_SERVER_ENV", default="Nonprod"),
]


FillVars(_ENVVARS, vars())
FillVars(_DJANGO_ENVVARS, vars(), "DJANGO_")
ALLOWED_HOSTS = ADDRESSES  # noqa: F405
