# Generated by Django 1.11.29 on 2020-04-10 18:46

import django.db.models.deletion
import modelcluster.fields
import wagtail.blocks
import wagtail.contrib.table_block.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("wagtaildocs", "0008_document_file_size"),
        ("wagtailcore", "0040_page_draft_title"),
        ("images", "0001_initial"),
        ("snippets", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="StandardIndexPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        blank=True,
                        help_text="Enter the title to display on the page, you can use only 255 characters.",
                        max_length=255,
                    ),
                ),
                (
                    "key_info",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                (
                    "in_depth",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
            ],
            options={
                "verbose_name": "Index Page",
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="StandardPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        blank=True,
                        help_text="Enter the title to display on the page, you can use only 255 characters.",
                        max_length=255,
                    ),
                ),
                (
                    "key_info",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                (
                    "in_depth",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                (
                    "prepared_key_info",
                    models.TextField(
                        blank=True,
                        help_text="The prepared key info field after bibliography styling has been applied. Auto-generated on each save.",
                        null=True,
                    ),
                ),
                (
                    "prepared_in_depth",
                    models.TextField(
                        blank=True,
                        help_text="The prepared in depth field after bibliography styling has been applied. Auto-generated on each save.",
                        null=True,
                    ),
                ),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        help_text="Specify the page you would like visitors to go to next.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.CallToAction",
                    ),
                ),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "mailing_list_signup",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.MailingListSignup",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="StandardPageFAQItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                ("question", models.TextField()),
                ("answer", models.TextField()),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="faq_items",
                        to="standard.StandardPage",
                    ),
                ),
            ],
            options={
                "ordering": ["sort_order"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="StandardPageFeedRelatedLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "link_external",
                    models.URLField(blank=True, verbose_name="External link"),
                ),
                ("title", models.CharField(help_text="Link title", max_length=255)),
                (
                    "link_document",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtaildocs.Document",
                    ),
                ),
                (
                    "link_page",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="feed_related_links",
                        to="standard.StandardPage",
                    ),
                ),
            ],
            options={
                "ordering": ["sort_order"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="StandardPageRelatedLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "link_external",
                    models.URLField(blank=True, verbose_name="External link"),
                ),
                ("title", models.CharField(help_text="Link title", max_length=255)),
                (
                    "link_document",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtaildocs.Document",
                    ),
                ),
                (
                    "link_page",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "page",
                    modelcluster.fields.ParentalKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="related_links",
                        to="standard.StandardPage",
                    ),
                ),
            ],
            options={
                "ordering": ["sort_order"],
                "abstract": False,
            },
        ),
    ]
