# Generated by Django 3.2.13 on 2023-02-27 20:53

import django.db.models.deletion
import wagtail.blocks
import wagtail.contrib.table_block.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
import wagtailmarkdown.blocks
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("snippets", "0002_auto_20200414_2027"),
        ("wagtailcore", "0078_referenceindex"),
        ("images", "0002_alter_ietfimage_file_hash"),
        ("standard", "0004_auto_20220902_0524"),
    ]

    operations = [
        migrations.CreateModel(
            name="IABStandardPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        blank=True,
                        help_text="Enter the title to display on the page, you can use only 255 characters.",
                        max_length=255,
                    ),
                ),
                (
                    "key_info",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            (
                                "markdown",
                                wagtailmarkdown.blocks.MarkdownBlock(icon="code"),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"},
                                    template="includes/tableblock.html",
                                ),
                            ),
                        ],
                        blank=True,
                        use_json_field=True,
                    ),
                ),
                (
                    "in_depth",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            (
                                "markdown",
                                wagtailmarkdown.blocks.MarkdownBlock(icon="code"),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"},
                                    template="includes/tableblock.html",
                                ),
                            ),
                        ],
                        blank=True,
                        use_json_field=True,
                    ),
                ),
                (
                    "prepared_key_info",
                    models.TextField(
                        blank=True,
                        help_text="The prepared key info field after bibliography styling has been applied. Auto-generated on each save.",
                        null=True,
                    ),
                ),
                (
                    "prepared_in_depth",
                    models.TextField(
                        blank=True,
                        help_text="The prepared in depth field after bibliography styling has been applied. Auto-generated on each save.",
                        null=True,
                    ),
                ),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        help_text="Specify the page you would like visitors to go to next.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.calltoaction",
                    ),
                ),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.ietfimage",
                    ),
                ),
                (
                    "mailing_list_signup",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.mailinglistsignup",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.ietfimage",
                    ),
                ),
            ],
            options={
                "verbose_name": "IAB Standard Page",
            },
            bases=("wagtailcore.page", models.Model),
        ),
    ]
