# Generated by Django 1.11.29 on 2020-04-10 18:46

import django.db.models.deletion
import modelcluster.fields
import wagtail.blocks
import wagtail.contrib.table_block.blocks
import wagtail.embeds.blocks
import wagtail.fields
import wagtail.images.blocks
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("images", "0001_initial"),
        ("snippets", "0001_initial"),
        ("wagtaildocs", "0008_document_file_size"),
        ("wagtailcore", "0040_page_draft_title"),
    ]

    operations = [
        migrations.CreateModel(
            name="PrimaryTopicPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        blank=True,
                        help_text="Enter the title to display on the page, you can use only 255 characters.",
                        max_length=255,
                    ),
                ),
                (
                    "key_info",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                (
                    "in_depth",
                    wagtail.fields.StreamField(
                        [
                            ("heading", wagtail.blocks.CharBlock(icon="title")),
                            ("paragraph", wagtail.blocks.RichTextBlock(icon="pilcrow")),
                            (
                                "image",
                                wagtail.images.blocks.ImageChooserBlock(
                                    icon="image", template="includes/imageblock.html"
                                ),
                            ),
                            ("embed", wagtail.embeds.blocks.EmbedBlock(icon="code")),
                            (
                                "raw_html",
                                wagtail.blocks.RawHTMLBlock(icon="placeholder"),
                            ),
                            (
                                "table",
                                wagtail.contrib.table_block.blocks.TableBlock(
                                    table_options={"renderer": "html"}
                                ),
                            ),
                        ],
                        blank=True,
                    ),
                ),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        help_text="Will only be displayed if no mailing list signup is selected.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.CallToAction",
                    ),
                ),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "mailing_list_signup",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="snippets.MailingListSignup",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
            ],
            options={
                "verbose_name": "Topic Page",
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.CreateModel(
            name="PrimaryTopicPageRelatedLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "sort_order",
                    models.IntegerField(blank=True, editable=False, null=True),
                ),
                (
                    "link_external",
                    models.URLField(blank=True, verbose_name="External link"),
                ),
                ("title", models.CharField(help_text="Link title", max_length=255)),
                (
                    "link_document",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="wagtaildocs.Document",
                    ),
                ),
            ],
            options={
                "ordering": ["sort_order"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="TopicIndexPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.Page",
                    ),
                ),
                (
                    "social_text",
                    models.CharField(
                        blank=True,
                        help_text="Description of this page as it should appear when shared on social networks, or in Google results",
                        max_length=255,
                    ),
                ),
                (
                    "introduction",
                    models.CharField(
                        help_text="Enter the introduction to display on the page, you can use only 255 characters.",
                        max_length=255,
                    ),
                ),
                (
                    "feed_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="This image will be used in listings and indexes across the site, if no feed image is added, the social image will be used.",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
                (
                    "social_image",
                    models.ForeignKey(
                        blank=True,
                        help_text="Image to appear alongside 'social text', particularly for sharing on social networks",
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="images.IETFImage",
                    ),
                ),
            ],
            options={
                "verbose_name": "Topic Page List",
            },
            bases=("wagtailcore.page", models.Model),
        ),
        migrations.AddField(
            model_name="primarytopicpagerelatedlink",
            name="link_page",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="wagtailcore.Page",
            ),
        ),
        migrations.AddField(
            model_name="primarytopicpagerelatedlink",
            name="page",
            field=modelcluster.fields.ParentalKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="related_links",
                to="topics.PrimaryTopicPage",
            ),
        ),
    ]
