// Webpack likes to make relative paths between its
// generated HTML and its bundles(etc), but the paths
// it generates aren't how Wagtail serves files so we
// need to rewrite the paths

const HtmlWebpackPlugin = require('html-webpack-plugin');

const AUTOGENERATED_COMMENT =
  '\n{% comment %}\n\n  DEV WARNING\n\n  THIS FILE IS AUTO-GENERATED FROM "*_src" DIRECTORY. DO NOT EDIT!\n\n{% endcomment %}\n';

class FixPaths {
  apply(compiler) {
    compiler.hooks.compilation.tap('replaceStaticPath', (compilation) => {
      // Static Plugin interface |compilation |HOOK NAME | register listener
      HtmlWebpackPlugin.getHooks(compilation).beforeEmit.tapAsync(
        'replaceStaticPath',
        (data, cb) => {
          // Manipulate the content
          data.html =
            AUTOGENERATED_COMMENT +
            data.html.replace(
              /\.\.\/static\/(.*?)(["'])/gi,
              "{% static '$1' %}$2",
            );
          // Tell webpack to move on
          cb(null, data);
        },
      );
    });
  }
}

module.exports = FixPaths;
