<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
  <meta http-equiv="Content-Script-Type" content="text/javascript">
  <title>Condorcet Internet Voting Service</title>
  <link rel="stylesheet" type="text/css" href="@CIVSURL@/style.css">
  <meta http-equiv="Content-Script-Type" content="text/javascript">
  <script type="text/javascript">
    function trim(str)
    {
        return str.replace(/^\s+|\s+$/g, '')
    };
    function validateEmail(str)   // element to be validated
    {
	var str = trim(str);  // value of field with whitespace trimmed off
	var email = /^[^@]+@[^@.]+\.[^@]*\w\w$/
	return email.test(str);
    };

    function validate() {
	var numerrs = 0;
	var errs = new Array;
	if (!validateEmail(document.forms.CreateElection.email_addr.value)) {
	    errs[numerrs++] = 'L\'adresse de courrier électronique du responsable de la consultation est invalide.';
	}
	if (!(document.forms.CreateElection.num_winners.value >= 1)) {
	    errs[numerrs++] = 'Il doit y avoir au moins un élu ou une proposition retenue.';
	}
	if (document.forms.CreateElection.proportional.checked &&
	    !(document.forms.CreateElection.num_winners.value > 1)) {
	    errs[numerrs++] =
		'La représentation proportionelle implique qu\'il y ait plus d\'un élu ou plus d\'une proposition retenue.';
	}
	if (document.forms.CreateElection.choices.value == '' &&
	    document.forms.CreateElection.choices_file.value == '') {
	    errs[numerrs++] = 'Il doit y avoir au minimum deux candidats ou deux propositions pour pouvoir organiser une consultation.';
	}
	if (document.forms.CreateElection.restrict_results.checked) {
	    var rs = document.forms.CreateElection.result_addrs.value;
	    var ra = rs.split(/[\r\n]+/g);
	    var nr = 0;
	    for (i = 0; i < ra.length; i++) {
		if (ra[i] == '') continue;
		if (!validateEmail(ra[i])) {
		    errs[numerrs++] =
			'L\'adresse de courrier électronique de ce destinataire des résultats est invalide : ' + ra[i];
		} else {
		    nr++;
		}
	    }
	    if (nr == 0) {
		errs[numerrs++] =
		    'Vous n\'avez pas précisé qui pourra consulter les résultats de la consultation.';
	    }
	}
	if (numerrs == 0) return true;
	if (numerrs == 1) {
	    alert(errs[0]);
	} else {
	    var msg = 'Errors:\n';
	    for (i = 0; i < numerrs; i++) {
		msg += (i+1);
		msg += '. ';
		msg += errs[i];
		msg += "\n";
	    }
	    alert(msg);
	}
	return false;
    }

    var prcontrol, prparent;
    var rvcontrol, rvparent;
    var rrcontrol, rrparent;

    function setup() {
	prcontrol = document.getElementById("prcontrol");
	prparent = prcontrol.parentNode;
	prparent.removeChild(prcontrol);

	rvcontrol = document.getElementById("reveal_voters");
	rvparent = rvcontrol.parentNode;
	rvparent.removeChild(rvcontrol);

        rrcontrol = document.getElementById("rrcontrol");
	rrparent = rrcontrol.parentNode;
	rrparent.removeChild(rrcontrol);
    }

    function render_text(prefix, ta_id, span_id) {
	var span = document.getElementById(span_id);
	var ta = document.getElementById(ta_id);
	span.innerHTML =  prefix + ta.value;
	return 1;
    }

    function render_list(ta_id, span_id) {
	var span = document.getElementById(span_id);
	var ta = document.getElementById(ta_id);
	var names = ta.value.split(/[\r\n]+/g);
	var html = "";
	for (i = 0; i < names.length; i++) {
	    html = html + "<li>" + names[i] + "</li>";
	}
	span.innerHTML = "<ul>" + html + "</ul>";
	return 1;
    }
  </script>
</head>
<body>
<table class="banner" border="0" cellpadding="7" cellspacing="0"
 width="100%">
  <tbody>
    <tr>
      <td nowrap="nowrap" valign="top" width="100%">
      <h1>Service de Vote Internet Condorcet (CIVS)</h1>
      </td>
      <td align="right" nowrap="nowrap" valign="top" width="0%"> <a
 href="@CIVSHOME@">Au sujet de CIVS</a><br>
      <a href="civs_create.html">Créer une consultation</a><br>
      <a href="sec_priv.html">Sécurité et Confidentialité</a><br>
      <a href="@CIVSURL@/faq.html">FAQ</a> </td>
    </tr>
    <tr>
      <td colspan="2" nowrap="nowrap" valign="top" width="100%">
      <h2 align="center">Créer une Nouvelle Consultation</h2>
      </td>
    </tr>
  </tbody>
</table>
<div class="contents">
<form method="post" action="@CIVSBINURL@/create_election@PERLEXT@"
 enctype="multipart/form-data" accept-charset="UTF-8"
 name="CreateElection" onsubmit="return validate()">
  <table class="form">
    <tbody>
      <tr>
        <td align="right">Nom de la consultation (par exemple, <b>Palme
d'or du Festival de Cannes</b>) : <br>
        </td>
        <td><input name="title" size="50" type="text"></td>
      </tr>
      <tr>
        <td align="right">Nom du responsable (vous) : <br>
        </td>
        <td><input name="name" size="20" type="text"> </td>
      </tr>
      <tr>
        <td align="right">Adresse de courrier électronique du
responsable : <br>
        </td>
        <td><input name="email_addr" size="20"
 onchange="if (!validateEmail(this.value)) { alert('Adresse de courrier Internet invalide') }"
 type="text"> </td>
      </tr>
      <tr>
        <td align="right" valign="top">Date et heure de fin de la
consultation : <br>
        <small>(<b>Note:</b> La consultation ne se clôturera pas
automatiquement. C'est au responsable de clôturer manuellement la
consultation)</small> </td>
        <td><input name="election_end" id="election_end" size="30"
 onchange="render_text('<br><i>Prévisualiser </i>: La consultation sera clôse le ', 'election_end', 'rendered_end')"
 type="text"> <span class="rendering" id="rendered_end"></span></td>
      </tr>
    </tbody>
  </table>
  <div class="emphasized"><small> Votre nom et votre adresse de
courrier électronique seront insérés dans les courriers électroniques
envoyés aux participants de la consultation. Votre nom doit donc être
connu des participants et votre adresse de courrier électronique
doit permettre la réception de courriers électroniques. CIVS va
utiliser votre adresse de courrier électronique pour vous communiquer
les information nécessaires à la gestion de la consultation. Merci de
vérifier que le filtre anti-spam attaché votre de courrier
électronique ne bloquera pas les courriers provenant de l'expéditeur <kbd>@SUPERVISOR@</kbd>
(il ne sera peut être pas inutile de contrôler le dossier où sont
dirigés les spams si vous ne recevez pas de courrier électronique
provenant de CIVS). </small></div>
  <p>Description de la consultation, des candidats ou des propositions
(Le format est libre et vous pouvez inclure des balises HTML) : <br>
  <table class="form">
    <tbody>
      <tr>
        <td><textarea id="description" valign="top" rows="5"
 name="description" cols="60"></textarea> </td>
        <td><input value="Prévisualiser &gt;&gt;"
 onclick="render_text('<h2>Description de la consultation</h2>',
				 'description',
				 'rendered_description')"
 type="button"></td>
        <td valign="top"><span class="rendering"
 id="rendered_description"></span><br>
        </td>
      </tr>
    </tbody>
  </table>
  </p>
  <p>Saisir le nom des candidats ou le texte des propositions, Un
candidat ou une proposition par ligne. Vous pouvez aussi charger un
fichier contenant ces informations : <br>
  </p>
  <p align="left">
  <table class="form">
    <tbody>
      <tr>
        <td> <textarea rows="5" name="choices" cols="60" id="choices"></textarea></td>
        <td> <br>
        </td>
        <td><input value="Prévisualiser &gt;&gt;"
 onclick="render_list('choices', 'rendered_choices')" type="button"></td>
        <td valign="top"><span class="rendering" id="rendered_choices"></span><br>
        </td>
      </tr>
    </tbody>
  </table>
  </p>
  <p align="left"><input name="choices_file" type="file"></p>
  <p>Combien y aura-t-il de candidats élus ou de propositions retenus
: <input name="num_winners" size="5" value="1" type="text"></p>
  <p>Saisir les adresses de courrier électronique des participants à la
consultation, une adresse par ligne. Il vous est possible de saisir un
maximum de 1000 adresses de courrier électronique. Il vous sera
possible d'ajouter les adresses de courrier électronique de nouveaux
participants pendant la consultation.</p>
  <p><textarea rows="2" name="addresses" cols="50"></textarea></p>
  <p><input name="addresses_file" type="file"></p>
  <h3>Options supplémentaires <small>(placez le curseur de votre
souris
sur la case à cocher pour avoir des informations complémentaires)</small></h3>
  <p><input name="public" value="yes"
 title="Si vous organisez une consultations publique vous recevrez un lien Internet unique que chaque
 participant pourra utiliser pour s'exprimer. Ce lien pourra, par exemple, être communiqué aux
 participants par l'intermédiaire d'une liste de distribution de courrier électronique. La méthode
 utilisée pour éviter qu'un participant puisse s'exprimer plusieurs fois est basée uniquement sur
 l'enregistrement de son adresse Internet (IP). Si vous voulez être absolument assuré que les participants
 ne s'expriment qu'une seule fois nous vous conseillons d'organiser une élection à bulletin secret."
 type="checkbox"> Cette consultation est publique. <br>
  <input name="external_ballots" value="yes"
 title="Cochez cette option si vous voulez charger les bulletins de vote de la consultation.
 Les participants à cette consultation ne pourront pas exprimer leur suffrage. Cette option vous permet d'explorer
 toutes les options et méthodes de vote de CIVS. Vous pouvez aussi utiliser cette option si vous devez dépouiller
 des bulletins de vote qui n'ont pas été enregistrés par CIVS."
 type="checkbox"> Cette consultation est une consultation de test. Tous
les votes proviendront d'un fichier. <br>
  <input name="restrict_results" value="yes"
 onclick="rrparent.appendChild(rrcontrol);"
 title="Par défaut, les résultats de cette consultation peuvent être consultés par tous
 les participants. Cochez cette option si vous voulez restreindre le nombre de personnes
 pouvant consulter les résultats de cette consultation."
 type="checkbox"> Les résultats de cette consultation ne seront
communiqués qu'à un nombre restreint de personnes. <br>
  <span>
  <p class="suboption" id="rrcontrol"> Saisir les adresses de courrier
électronique des personnes qui auront accès aux résultats de cette
consultations. Ces adresses seront communiquées à tous les participants
à cette consultation.<br>
  <textarea rows="2" name="result_addrs" cols="50"></textarea> </p>
  </span> <input name="ballot_reporting" value="yes"
 onclick="rvparent.appendChild(rvcontrol);"
 title="Cette option permet à tous les participants de la consultation de connaitre
 le détail de chaque bulletin de vote exprimé. Néanmoins, les bulletins de vote ne contiennent
 aucune information permettant d'identifier les votants."
 type="checkbox"> Les résultats de la consultation seront détaillés. <span>
  <p class="suboption" id="reveal_voters"> <input name="reveal_voters"
 value="yes" type="checkbox"> Les résultats détaillés de la
consultation contiendront
aussi l'identité des participants et leur vote. <span
 style="font-weight: bold;">ATTENTION</span> : Si vous cochez cette
case les participants ne seront donc plus anonymes, le serveur CIVS ne
détruira pas les adresses de courrier électronique des participants.
Les participants
seront avertis de l'absence d'anonymat de cette consultation. </p>
  </span><br>
  <input name="writeins" value="yes"
 title="Cochez cette option si vous désirez autoriser le panachage. La consultation sera alors
 divisée en deux sessions. Lors de la première session les participants pourront proposer de nouveaux
 candidats ou de nouvelles propositions. Lors de la deuxième session les participants pourront s'exprimer
 sur la totalité des candidats ou des propositions. Le responsable de la consultation gère le déroulement des deux sessions"
 type="checkbox"> Permettre aux participants d'ajouter des candidats ou
des propositions. Le vote est alors dit "panaché".<br>
  <input name="shuffle" value="no"
 title="Par défaut les candidats ou les propositions sont affichées aléatoirement. Dans certains cas il
 peut être plus efficace pour les participants de préserver l'ordre dans lequel les candidats ou les propositions
 ont été saisis. Un bon exemple est le cas d'un consultation concernant les horaires possibles pour une réunion."
 type="checkbox"> Présenter les candidats ou les propositions sur le
bulletin de vote dans l'ordre exact où ils ont été saisis.<br>
  <input name="no_opinion" value="yes"
 title="L'option &quot;abstention&quot; peut avoir des effets inattendus. Avant de l'utiliser soyez sur d'avoir bien
 appréhendés toutes les implications de son usage et n'oubliez pas d'informer les participants de ces implications."
 type="checkbox"> Permettre aux participant d'utiliser l'abstention.<br>
  <input name="proportional" value="yes"
 onclick="prparent.appendChild(prcontrol)"
 title="La représentation proportionnelle n'est utile que pour les consultations où
 plusieurs candidats ou propositions devront être retenues et si vous voulez être sur que
 les volontés des participants soient exprimées proportionnellement. Sinon c'est la majorité
 des participants qui décident des candidats élus ou des propositions retenues.
 La représentation proportionnelle est plus lente à dépouiller et ne doit pas être utilisée
 dans les cas où les consultations proposent beaucoup de candidats ou de propositions et qu'il
 est aussi nécessaire de retenir beaucoup de candidats ou de propositions. Dans la plus part des cas,
 mais pas tous, les résultats des consultations proportionnelles et des consultations majoritaires
 sont identiques. Cliquez sur le lien 'Pour en savoir plus' pour connaitre le fonctionnement de la
 représentation proportionnelle."
 type="checkbox"> Imposer la représentation proportionnelle [<a
 href="proportional.html">Pour en savoir plus</a>].<br>
  <span>
  <p class="suboption" id="prcontrol"> Dans le cadre de la
représentation proportionnelle, les participants sont supposés vouloir
maximiser :<br>
  <input name="rating_interpretation" value="best_choice"
 checked="checked" type="radio"> Soit le classement de leur candidat ou
de leur proposition favori;<br>
  <input name="rating_interpretation" value="combined_ratings"
 type="radio"> Soit le poids combiné des différents candidats ou
des différentes propositions qu'ils ont choisis.<br>
  </p>
  </span></p>
  <div class="emphasized">Vérifier que l'adresse de votre courrier
électronique est correcte car les informations relatives à cette
consultation vont être envoyée à cette adresse. Les participants à
cette
consultation ne seront informés de son existence que lorsque vous aurez
répondu au courrier électronique qui va vous parvenir. </div>
  <p style="margin-left: 5ex;"> <input name="submit"
 value="Créer la consultation" type="submit"> </p>
</form>
</div>
<script type="text/javascript">
  setup();
</script>
</body>
</html>
