BlazeLayout.setRoot('body');

const i18nTagToT9n = (i18nTag) => {
  // t9n/i18n tags are same now, see: https://github.com/softwarerero/meteor-accounts-t9n/pull/129
  // but we keep this conversion function here, to be aware that that they are different system.
  return i18nTag;
};

const validator = {
  set(obj, prop, value) {
    if (prop === 'state' && value !== 'signIn') {
      $('.at-form-authentication').hide();
    } else if (prop === 'state' && value === 'signIn') {
      $('.at-form-authentication').show();
    }
    // The default behavior to store the value
    obj[prop] = value;
    // Indicate success
    return true;
  },
};

Template.userFormsLayout.onCreated(function() {
  const instance = this;
  instance.currentSetting = new ReactiveVar();

  Meteor.subscribe('setting', {
    onReady() {
      instance.currentSetting.set(Settings.findOne());
      return this.stop();
    },
  });
});

Template.userFormsLayout.onRendered(() => {
  AccountsTemplates.state.form.keys = new Proxy(AccountsTemplates.state.form.keys, validator);

  const i18nTag = navigator.language;
  if (i18nTag) {
    T9n.setLanguage(i18nTagToT9n(i18nTag));
  }
  EscapeActions.executeAll();
});

Template.userFormsLayout.helpers({
  currentSetting() {
    return Template.instance().currentSetting.get();
  },

  afterBodyStart() {
    return currentSetting.customHTMLafterBodyStart;
  },

  beforeBodyEnd() {
    return currentSetting.customHTMLbeforeBodyEnd;
  },

  languages() {
    return _.map(TAPi18n.getLanguages(), (lang, code) => {
      const tag = code;
      let name = lang.name;
      if (lang.name === 'br') {
        name = 'Brezhoneg';
      } else if (lang.name === 'ig') {
        name = 'Igbo';
      }
      return { tag, name };
    }).sort(function(a, b) {
      if (a.name === b.name) {
        return 0;
      } else {
        return a.name > b.name ? 1 : -1;
      }
    });
  },

  isCurrentLanguage() {
    const t9nTag = i18nTagToT9n(this.tag);
    const curLang = T9n.getLanguage() || 'en';
    return t9nTag === curLang;
  },
});

Template.userFormsLayout.events({
  'change .js-userform-set-language'(evt) {
    const i18nTag = $(evt.currentTarget).val();
    T9n.setLanguage(i18nTagToT9n(i18nTag));
    evt.preventDefault();
  },
  'click #at-btn'(event, instance) {
    if (FlowRouter.getRouteName() === 'atSignIn') {
      authentication(event, instance);
    }
  },
});

Template.defaultLayout.events({
  'click .js-close-modal': () => {
    Modal.close();
  },
});

async function authentication(event, instance) {

  // If header login id is set, use it for login.
  // Header username = Email address
  // Header password = Login ID
  // Not user currently: req.headers[process.env.HEADER_LOGIN_FIRSTNAME]
  //                and  req.headers[process.env.HEADER_LOGIN_LASTNAME]
  const match = req.headers[process.env.HEADER_LOGIN_EMAIL] || $('#at-field-username_and_email').val();
  const password = req.headers[process.env.HEADER_LOGIN_ID] || $('#at-field-password').val();

  if (!match || !password) return;

  const result = await getAuthenticationMethod(instance.currentSetting.get(), match);

  if (result === 'password') return;

  // If header login id is not set, don't try to login automatically.
  if (!process.env.HEADER_LOGIN_ID) {
    // Stop submit #at-pwd-form
    event.preventDefault();
    event.stopImmediatePropagation();
  }

  switch (result) {
  case 'ldap':
    Meteor.loginWithLDAP(match, password, function() {
      FlowRouter.go('/');
    });
    break;

  case 'cas':
    Meteor.loginWithCas(function() {
      FlowRouter.go('/');
    });
    break;

  default:
    break;
  }
}

function getAuthenticationMethod({displayAuthenticationMethod, defaultAuthenticationMethod}, match) {
  if (displayAuthenticationMethod) {
    return $('.select-authentication').val();
  }
  return getUserAuthenticationMethod(defaultAuthenticationMethod, match);
}

function getUserAuthenticationMethod(defaultAuthenticationMethod, match) {
  return new Promise((resolve) => {
    try {
      Meteor.subscribe('user-authenticationMethod', match, {
        onReady() {
          const user = Users.findOne();

          const authenticationMethod = user
            ? user.authenticationMethod
            : defaultAuthenticationMethod;

          resolve(authenticationMethod);
        },
      });
    } catch(error) {
      resolve(defaultAuthenticationMethod);
    }
  });
}
