/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHArguments;
import bsh.BSHArrayDimensions;
import bsh.BSHBlock;
import bsh.BSHPrimitiveType;
import bsh.CallStack;
import bsh.ClassGenerator;
import bsh.ClassIdentifier;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.Name;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import bsh.Types;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

class BSHAllocationExpression
extends SimpleNode {
    private static int innerClassCount = 0;

    BSHAllocationExpression(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        if (this.jjtGetNumChildren() == 1 && this.jjtGetChild(0) instanceof BSHArrayDimensions) {
            return this.arrayAllocation((BSHArrayDimensions)this.jjtGetChild(0), Void.TYPE, callstack, interpreter);
        }
        Node type = this.jjtGetChild(0);
        Node args = this.jjtGetChild(1);
        if (type instanceof BSHAmbiguousName) {
            BSHAmbiguousName name = (BSHAmbiguousName)type;
            if (args instanceof BSHArguments) {
                return this.objectAllocation(name, (BSHArguments)args, callstack, interpreter);
            }
            return this.objectArrayAllocation(name, (BSHArrayDimensions)args, callstack, interpreter);
        }
        return this.primitiveArrayAllocation((BSHPrimitiveType)type, (BSHArrayDimensions)args, callstack, interpreter);
    }

    private Object objectAllocation(BSHAmbiguousName nameNode, BSHArguments argumentsNode, CallStack callstack, Interpreter interpreter) throws EvalError {
        boolean hasBody;
        Object[] args = argumentsNode.getArguments(callstack, interpreter);
        if (args == null) {
            throw new EvalError("Null args in new.", this, callstack);
        }
        Object obj = nameNode.toObject(callstack, interpreter, false);
        obj = nameNode.toObject(callstack, interpreter, true);
        Class type = null;
        if (!(obj instanceof ClassIdentifier)) {
            throw new EvalError("Unknown class: " + nameNode.text, this, callstack);
        }
        type = ((ClassIdentifier)obj).getTargetClass();
        boolean bl = hasBody = this.jjtGetNumChildren() > 2;
        if (hasBody) {
            BSHBlock body = (BSHBlock)this.jjtGetChild(2);
            if (type.isInterface()) {
                return this.constructWithInterfaceBody(type, args, body, callstack, interpreter);
            }
            return this.constructWithClassBody(type, args, body, callstack, interpreter);
        }
        return this.constructObject(type, args, callstack, interpreter);
    }

    Object constructFromEnclosingInstance(Object obj, CallStack callstack, Interpreter interpreter) throws EvalError {
        String typeString = "";
        if (this.jjtGetChild(0) instanceof BSHAmbiguousName) {
            typeString = ((BSHAmbiguousName)this.jjtGetChild((int)0)).text;
        }
        Object[] args = null;
        if (this.jjtGetChild(1) instanceof BSHArguments) {
            args = ((BSHArguments)this.jjtGetChild(1)).getArguments(callstack, interpreter);
        }
        Class<?> type = null;
        for (Class<?> t : obj.getClass().getDeclaredClasses()) {
            if (!Types.getBaseName(t.getName()).equals(typeString)) continue;
            type = t;
            break;
        }
        try {
            return Reflect.constructObject(type, obj, args);
        }
        catch (InvocationTargetException e) {
            throw new TargetError("Object constructor", e.getCause(), this, callstack, true);
        }
    }

    private Object constructObject(Class<?> type, Object[] args, CallStack callstack, Interpreter interpreter) throws EvalError {
        Object obj;
        boolean isGeneratedClass = Reflect.isGeneratedClass(type);
        if (isGeneratedClass) {
            This.registerConstructorContext(callstack, interpreter);
        }
        try {
            obj = Reflect.constructObject(type, args);
        }
        catch (ReflectError e) {
            throw new EvalError("Constructor error: " + e.getMessage(), this, callstack, e);
        }
        catch (InvocationTargetException e) {
            Interpreter.debug("The constructor threw an exception:\n\t" + e.getCause());
            throw new TargetError("Object constructor", e.getCause(), this, callstack, true);
        }
        finally {
            if (isGeneratedClass) {
                This.registerConstructorContext(null, null);
            }
        }
        String className = type.getName();
        if (className.indexOf("$") == -1) {
            return obj;
        }
        This ths = callstack.top().getThis(null);
        NameSpace instanceNameSpace = ths.getNameSpace();
        if (null != Name.getClassNameSpace(instanceNameSpace) && !Reflect.getClassModifiers(obj.getClass()).hasModifier("static")) {
            Reflect.getThisNS(obj).setParent(instanceNameSpace);
        } else if (Reflect.getClassModifiers(obj.getClass()).hasModifier("static")) {
            Reflect.getThisNS(obj).setParent(Reflect.getThisNS(obj.getClass()).getParent());
        }
        return obj;
    }

    private Object constructWithClassBody(Class<?> type, Object[] args, BSHBlock block, CallStack callstack, Interpreter interpreter) throws EvalError {
        String anon = "anon" + ++innerClassCount;
        String name = callstack.top().getName() + "$" + anon;
        This.CONTEXT_ARGS.get().put(anon, args);
        Modifiers modifiers = new Modifiers(0);
        Class<?> clas = ClassGenerator.getClassGenerator().generateClass(name, modifiers, null, type, block, ClassGenerator.Type.CLASS, callstack, interpreter);
        try {
            return Reflect.constructObject(clas, args);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof InvocationTargetException) {
                cause = e.getCause();
            }
            throw new EvalError("Error constructing inner class instance: " + e, this, callstack, cause);
        }
    }

    private Object constructWithInterfaceBody(Class<?> type, Object[] args, BSHBlock body, CallStack callstack, Interpreter interpreter) throws EvalError {
        NameSpace namespace = callstack.top();
        NameSpace local = new NameSpace(namespace, "AnonymousBlock");
        callstack.push(local);
        body.eval(callstack, interpreter, true);
        callstack.pop();
        local.importStatic(type);
        return local.getThis(interpreter).getInterface(type);
    }

    private Object objectArrayAllocation(BSHAmbiguousName nameNode, BSHArrayDimensions dimensionsNode, CallStack callstack, Interpreter interpreter) throws EvalError {
        Class type = nameNode.toClass(callstack, interpreter);
        return this.arrayAllocation(dimensionsNode, type, callstack, interpreter);
    }

    private Object primitiveArrayAllocation(BSHPrimitiveType typeNode, BSHArrayDimensions dimensionsNode, CallStack callstack, Interpreter interpreter) throws EvalError {
        Class type = typeNode.getType();
        return this.arrayAllocation(dimensionsNode, type, callstack, interpreter);
    }

    private Object arrayAllocation(BSHArrayDimensions dimensionsNode, Class<?> type, CallStack callstack, Interpreter interpreter) throws EvalError {
        Object result = dimensionsNode.eval(type, callstack, interpreter);
        if (result != Primitive.VOID) {
            return result;
        }
        return this.arrayNewInstance(type, dimensionsNode, callstack, interpreter);
    }

    private Object arrayNewInstance(Class<?> type, BSHArrayDimensions dimensionsNode, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (dimensionsNode.numUndefinedDims > 0) {
            Object proto = Array.newInstance(type, new int[dimensionsNode.numUndefinedDims]);
            type = proto.getClass();
        }
        try {
            Object arr = Array.newInstance(type, dimensionsNode.definedDimensions);
            if (!interpreter.getStrictJava()) {
                this.arrayFillDefaultValue(arr);
            }
            return arr;
        }
        catch (NegativeArraySizeException e1) {
            throw new TargetError(e1, (Node)this, callstack);
        }
        catch (Exception e) {
            throw new EvalError("Can't construct primitive array: " + e.getMessage(), this, callstack, e);
        }
    }

    private void arrayFillDefaultValue(Object arr) {
        if (null == arr) {
            return;
        }
        Class<?> clas = arr.getClass();
        Class<?> comp = Types.arrayElementType(clas);
        if (!comp.isPrimitive()) {
            if (Types.arrayDimensions(clas) > 1) {
                for (int i = 0; i < Array.getLength(arr); ++i) {
                    this.arrayFillDefaultValue(Array.get(arr, i));
                }
            } else {
                Arrays.fill((Object[])arr, Primitive.unwrap(Primitive.getDefaultValue(comp)));
            }
        }
    }
}

