/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArrayInitializer;
import bsh.BshArray;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Node;
import bsh.Primitive;
import bsh.SimpleNode;

class BSHArrayDimensions
extends SimpleNode {
    private static final long serialVersionUID = 1L;
    public Class<?> baseType;
    public int numDefinedDims;
    public int numUndefinedDims;
    public int[] definedDimensions;

    BSHArrayDimensions(int id) {
        super(id);
    }

    public void addDefinedDimension() {
        ++this.numDefinedDims;
    }

    public void addUndefinedDimension() {
        ++this.numUndefinedDims;
    }

    public Object eval(Class<?> type, CallStack callstack, Interpreter interpreter) throws EvalError {
        Interpreter.debug("array base type = ", type);
        this.baseType = type;
        return this.eval(callstack, interpreter);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Node child = this.jjtGetChild(0);
        if (child instanceof BSHArrayInitializer) {
            Object initValue = ((BSHArrayInitializer)child).eval(this.baseType, this.numUndefinedDims, callstack, interpreter);
            if (!initValue.getClass().isArray()) {
                return initValue;
            }
            this.definedDimensions = BshArray.dimensions(initValue);
            if (-1 == this.numUndefinedDims) {
                this.numUndefinedDims = this.definedDimensions.length;
            }
            if (this.definedDimensions.length != this.numUndefinedDims) {
                throw new EvalError("Incompatible initializer. Allocation calls for a " + this.numUndefinedDims + " dimensional array, but initializer is a " + this.definedDimensions.length + " dimensional array", this, callstack);
            }
            return initValue;
        }
        this.definedDimensions = new int[this.numDefinedDims];
        for (int i = 0; i < this.numDefinedDims; ++i) {
            try {
                Object length = this.jjtGetChild(i).eval(callstack, interpreter);
                this.definedDimensions[i] = ((Primitive)length).intValue();
                continue;
            }
            catch (Exception e) {
                throw new EvalError("Array index: " + i + " does not evaluate to an integer", this, callstack);
            }
        }
        return Primitive.VOID;
    }
}

