/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAssignment;
import bsh.BSHPrimaryExpression;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Node;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.Types;
import bsh.UtilEvalError;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;

class BSHArrayInitializer
extends SimpleNode {
    private static final long serialVersionUID = 1L;
    boolean isMapInArray = false;
    Deque<BSHPrimaryExpression> expressionQueue = new ArrayDeque<BSHPrimaryExpression>();

    BSHArrayInitializer(int id) {
        super(id);
    }

    @Override
    public void jjtSetParent(Node n) {
        this.parent = n;
        if (null != this.children) {
            for (Node c : this.children) {
                if (c.jjtGetNumChildren() <= 0 || !(c.jjtGetChild(0) instanceof BSHPrimaryExpression)) continue;
                this.expressionQueue.push((BSHPrimaryExpression)c.jjtGetChild(0));
                this.expressionQueue.peek().setArrayExpression(this);
            }
        }
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        throw new EvalError("Array initializer has no base type.", this, callstack);
    }

    public Object eval(Class<?> baseType, int dimensions, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (0 == this.jjtGetNumChildren()) {
            dimensions = 0;
        }
        Class<Object> inferType = baseType;
        if (0 == dimensions) {
            if (baseType == Void.TYPE || Types.isCollectionType(baseType)) {
                inferType = Object.class;
            }
            Object emptyArray = Array.newInstance(inferType, 0);
            return this.toCollection(emptyArray, baseType, callstack);
        }
        if (-1 == dimensions) {
            if (interpreter.getStrictJava()) {
                throw new EvalError("No declared array type or dimensions.", this, callstack);
            }
            dimensions = this.inferDimensions(1, 0, this, callstack, interpreter);
            if (Types.isCollectionType(inferType)) {
                inferType = Void.TYPE;
            }
        }
        if (inferType == Void.TYPE) {
            inferType = this.inferCommonType(null, this, callstack, interpreter);
        }
        if (Types.MapEntry.class == inferType && Void.TYPE == baseType || Types.MapEntry.class == baseType) {
            baseType = Map.class;
        }
        if (null == inferType) {
            inferType = Object.class;
            ++dimensions;
        }
        Object array = this.buildArray(dimensions, inferType, callstack, interpreter);
        this.clearEvalCache();
        return this.toCollection(array, baseType, callstack);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object buildArray(int dimensions, Class<?> baseType, CallStack callstack, Interpreter interpreter) throws EvalError {
        int[] dims = new int[dimensions];
        dims[0] = this.jjtGetNumChildren();
        Object array = Array.newInstance(baseType, dims);
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            Object entry;
            Node node = this.jjtGetChild(i);
            if (node instanceof BSHArrayInitializer) {
                if (dimensions < 2) {
                    if (!this.isMapInArray((BSHArrayInitializer)node)) throw new EvalError("Invalid Intializer for " + baseType + ", at position: " + i, this, callstack);
                    entry = ((BSHArrayInitializer)node).eval(Types.MapEntry.class, 1, callstack, interpreter);
                } else {
                    entry = ((BSHArrayInitializer)node).eval(baseType, dimensions - 1, callstack, interpreter);
                }
            } else {
                entry = node.eval(callstack, interpreter);
            }
            if (entry == Primitive.VOID) {
                throw new EvalError("Void in array initializer, position " + i, this, callstack);
            }
            try {
                Array.set(array, i, this.normalizeEntry(entry, baseType, dimensions, callstack));
                continue;
            }
            catch (IllegalArgumentException e) {
                Interpreter.debug("illegal arg", e);
                this.throwTypeError(baseType, entry, i, callstack);
            }
        }
        return array;
    }

    private Object normalizeEntry(Object value, Class<?> baseType, int dimensions, CallStack callstack) throws EvalError {
        if (dimensions == 1 || value != Primitive.NULL) {
            try {
                return Primitive.unwrap(Types.castObject(value, baseType, 0));
            }
            catch (UtilEvalError e) {
                throw e.toEvalError("Error in array initializer", this, callstack);
            }
        }
        return Primitive.unwrap(value);
    }

    private Object toCollection(Object value, Class<?> type, CallStack callstack) throws EvalError {
        if (Types.isCollectionType(type)) {
            try {
                return Types.castObject(value, type, 0);
            }
            catch (UtilEvalError e) {
                e.toEvalError(this, callstack);
            }
        }
        return value;
    }

    void setMapInArray(boolean is) {
        this.isMapInArray = is;
    }

    boolean isMapInArray(BSHArrayInitializer init) {
        return init.isMapInArray;
    }

    private void clearEvalCache() {
        for (BSHPrimaryExpression expression : this.expressionQueue) {
            expression.clearCache();
        }
    }

    private int inferDimensions(int dimensions, int idx, Node node, CallStack callstack, Interpreter interpreter) throws EvalError {
        while (node.jjtGetNumChildren() > idx && (node = node.jjtGetChild(idx)) instanceof BSHArrayInitializer && !this.isMapInArray((BSHArrayInitializer)node) && node.jjtGetNumChildren() > 0) {
            ++dimensions;
            idx = 0;
        }
        if (!(node instanceof BSHArrayInitializer)) {
            Object ot = node.eval(callstack, interpreter);
            if (ot == Primitive.NULL) {
                return this.inferDimensions(dimensions, ++idx, node.jjtGetParent(), callstack, interpreter);
            }
            dimensions += Types.arrayDimensions(Types.getType(ot));
        } else if (node.jjtGetNumChildren() == 0) {
            return this.inferDimensions(dimensions, ++idx, node.jjtGetParent(), callstack, interpreter);
        }
        return dimensions;
    }

    private Class<?> inferCommonType(Class<?> common, Node node, CallStack callstack, Interpreter interpreter) throws EvalError {
        if (Object.class == common || Types.MapEntry.class == common) {
            return common;
        }
        if (node instanceof BSHAssignment) {
            Object value = node.eval(callstack, interpreter);
            Class<?> type = Types.getType(value, Primitive.isWrapperType(common));
            return Types.getCommonType(common, Types.arrayElementType(type));
        }
        if (node instanceof BSHArrayInitializer && this.isMapInArray((BSHArrayInitializer)node)) {
            return Types.getCommonType(common, Map.class);
        }
        for (Node child : node.jjtGetChildren()) {
            common = this.inferCommonType(common, child, callstack, interpreter);
        }
        return common;
    }

    private void throwTypeError(Class<?> baseType, Object initializer, int argNum, CallStack callstack) throws EvalError {
        String rhsType = StringUtil.typeString(initializer);
        throw new EvalError("Incompatible type: " + rhsType + " in initializer of array type: " + baseType.getSimpleName() + " at position: " + argNum, this, callstack);
    }
}

