/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHType;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Node;
import bsh.Operators;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.Variable;

class BSHBinaryExpression
extends SimpleNode
implements ParserConstants {
    public int kind;

    BSHBinaryExpression(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Object lhs = this.jjtGetChild(0).eval(callstack, interpreter);
        if (this.kind == 36) {
            if (lhs == Primitive.NULL) {
                return Primitive.FALSE;
            }
            Class rhs = ((BSHType)this.jjtGetChild(1)).getType(callstack, interpreter);
            if (lhs instanceof Primitive) {
                if (rhs == Primitive.class) {
                    return Primitive.TRUE;
                }
                lhs = Primitive.unwrap(lhs);
            }
            return Types.isJavaBaseAssignable(rhs, lhs.getClass()) ? Primitive.TRUE : Primitive.FALSE;
        }
        if (lhs == Primitive.FALSE && (this.kind == 100 || this.kind == 101)) {
            return Primitive.FALSE;
        }
        if (lhs == Primitive.TRUE && (this.kind == 98 || this.kind == 99)) {
            return Primitive.TRUE;
        }
        Object rhs = this.jjtGetChild(1).eval(callstack, interpreter);
        lhs = this.checkNullValues(lhs, rhs, 0, callstack);
        rhs = this.checkNullValues(rhs, lhs, 1, callstack);
        if ((this.kind != 92 && this.kind != 97 || !this.isWrapper(lhs) || !this.isWrapper(rhs)) && (this.isWrapper(lhs) || this.isPrimitiveValue(lhs)) && (this.isWrapper(rhs) || this.isPrimitiveValue(rhs))) {
            try {
                return Operators.binaryOperation(lhs, rhs, this.kind);
            }
            catch (UtilEvalError e) {
                throw e.toEvalError("Failed operation: " + lhs + " " + tokenImage[this.kind] + " " + rhs, this, callstack);
            }
        }
        if (!(!interpreter.getStrictJava() || this.kind != 104 && this.kind != 106 || lhs instanceof String || rhs instanceof String)) {
            throw new EvalError("Bad operand types for binary operator " + tokenImage[this.kind] + " first type: " + StringUtil.typeString(lhs) + " second type: " + StringUtil.typeString(rhs), this, callstack);
        }
        try {
            return Operators.arbitraryObjectsBinaryOperation(lhs, rhs, this.kind);
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(this, callstack);
        }
    }

    private Variable getVariableAtNode(int index, CallStack callstack) throws UtilEvalError {
        Node nameNode = null;
        if (this.jjtGetChild(index).jjtGetNumChildren() > 0 && (nameNode = this.jjtGetChild(index).jjtGetChild(0)) instanceof BSHAmbiguousName) {
            return callstack.top().getVariableImpl(((BSHAmbiguousName)nameNode).text, true);
        }
        return null;
    }

    private Object checkNullValues(Object val1, Object val2, int index, CallStack callstack) throws EvalError {
        if (Primitive.NULL != val1) {
            return val1;
        }
        if (Primitive.VOID == val2) {
            return val1;
        }
        try {
            Variable var = null;
            boolean val2IsString = val2 instanceof String;
            Class<?> val2Class = null;
            if (Primitive.NULL == val2) {
                var = this.getVariableAtNode(index ^ 1, callstack);
                if (null != var) {
                    val2IsString = var.getType() == String.class;
                    val2Class = var.getType();
                }
            } else {
                val2Class = Primitive.unwrap(val2).getClass();
            }
            if (null == (var = this.getVariableAtNode(index, callstack))) {
                return val1;
            }
            if ((this.kind == 92 || this.kind == 97) && this.isComparableTypes(var.getType(), val2Class, callstack)) {
                return val1;
            }
            if (this.kind == 104 && (val2IsString || var.getType() == String.class)) {
                return "null";
            }
            if (this.isWrapper(var.getType())) {
                throw new NullPointerException("null value with binary operator " + tokenImage[this.kind]);
            }
            throw new EvalError("bad operand types for binary operator " + tokenImage[this.kind], this, callstack);
        }
        catch (NullPointerException e) {
            throw new TargetError(e, (Node)this, callstack);
        }
        catch (UtilEvalError e) {
            e.toEvalError(this, callstack);
            return val1;
        }
    }

    private boolean isComparableTypes(Class<?> val1Class, Class<?> val2Class, CallStack callstack) throws EvalError {
        if (val2Class == val1Class || this.isSimilarTypes(val1Class, val2Class)) {
            return true;
        }
        throw new EvalError("incomparable types: " + StringUtil.typeString(val1Class) + " and " + StringUtil.typeString(val2Class), this, callstack);
    }

    private boolean isSimilarTypes(Class<?> type1, Class<?> type2) {
        return null == type2 || type1.isAssignableFrom(type2) || type2.isAssignableFrom(type1);
    }

    private boolean isPrimitiveValue(Object obj) {
        return obj instanceof Primitive && obj != Primitive.NULL && obj != Primitive.VOID;
    }

    private boolean isWrapper(Object obj) {
        return obj instanceof Number || obj instanceof Boolean || obj instanceof Character;
    }

    private boolean isWrapper(Class<?> cls) {
        if (null == cls) {
            return false;
        }
        if (Number.class.isAssignableFrom(cls) || Character.class.isAssignableFrom(cls)) {
            switch (this.kind) {
                case 98: 
                case 99: 
                case 100: 
                case 101: {
                    return false;
                }
            }
            return true;
        }
        if (Boolean.class.isAssignableFrom(cls)) {
            switch (this.kind) {
                case 92: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + tokenImage[this.kind];
    }
}

