/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHClassDeclaration;
import bsh.BSHEnumConstant;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.NameSpace;
import bsh.Node;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.util.ReferenceCache;
import java.util.ArrayList;
import java.util.List;

class BSHBlock
extends SimpleNode {
    public boolean isSynchronized = false;
    public boolean isStatic = false;
    private boolean hasClassDeclaration = false;
    private boolean isFirst = true;
    private static final List<Node> enumBlocks = new ArrayList<Node>();
    private static final ReferenceCache<NameSpace, NameSpace> blockspaces = new ReferenceCache<NameSpace, NameSpace>(ReferenceCache.Type.Weak, ReferenceCache.Type.Weak, 4000){

        @Override
        protected NameSpace create(NameSpace key) {
            return new BlockNameSpace(key);
        }
    };

    BSHBlock(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        return this.eval(callstack, interpreter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(CallStack callstack, Interpreter interpreter, boolean overrideNamespace) throws EvalError {
        Object ret;
        Object syncValue = null;
        if (this.isSynchronized) {
            Node exp = this.jjtGetChild(0);
            syncValue = exp.eval(callstack, interpreter);
        }
        if (this.isSynchronized) {
            Object object = syncValue;
            synchronized (object) {
                ret = this.evalBlock(callstack, interpreter, overrideNamespace, null);
            }
        } else {
            ret = this.evalBlock(callstack, interpreter, overrideNamespace, null);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object evalBlock(CallStack callstack, Interpreter interpreter, boolean overrideNamespace, NodeFilter nodeFilter) throws EvalError {
        Object ret = Primitive.VOID;
        NameSpace enclosingNameSpace = null;
        if (!overrideNamespace) {
            enclosingNameSpace = callstack.swap(blockspaces.get(callstack.top()));
        }
        int startChild = this.isSynchronized ? 1 : 0;
        int numChildren = this.jjtGetNumChildren();
        try {
            Node node;
            int i;
            if (this.isFirst || this.hasClassDeclaration) {
                for (i = startChild; i < numChildren; ++i) {
                    node = this.jjtGetChild(i);
                    if (nodeFilter != null && !nodeFilter.isVisible(node) || !(node instanceof BSHClassDeclaration)) continue;
                    this.hasClassDeclaration = true;
                    node.eval(callstack, interpreter);
                }
            }
            for (i = startChild; i < numChildren; ++i) {
                node = this.jjtGetChild(i);
                if (node instanceof BSHClassDeclaration || nodeFilter != null && !nodeFilter.isVisible(node)) continue;
                if (node instanceof BSHEnumConstant) {
                    enumBlocks.add(node);
                    continue;
                }
                ret = node.eval(callstack, interpreter);
                if (ret instanceof ReturnControl) break;
            }
            while (!enumBlocks.isEmpty()) {
                enumBlocks.remove(0).eval(callstack, interpreter);
            }
        }
        finally {
            if (!overrideNamespace) {
                callstack.top().clear();
                callstack.swap(enclosingNameSpace);
            }
        }
        this.isFirst = false;
        return ret;
    }

    public static interface NodeFilter {
        public boolean isVisible(Node var1);
    }
}

