/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHAmbiguousName;
import bsh.BSHBlock;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.ClassGenerator;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.Reflect;
import bsh.SimpleNode;
import bsh.StringUtil;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class BSHClassDeclaration
extends SimpleNode {
    static final String CLASSINITNAME = "_bshClassInit";
    String name;
    Modifiers modifiers = new Modifiers(0);
    int numInterfaces;
    boolean extend;
    ClassGenerator.Type type;
    private Class<?> generatedClass;

    BSHClassDeclaration(int id) {
        super(id);
    }

    @Override
    public synchronized Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        if (this.generatedClass == null) {
            this.generatedClass = this.generateClass(callstack, interpreter);
        }
        return this.generatedClass;
    }

    private Class<?> generateClass(CallStack callstack, Interpreter interpreter) throws EvalError {
        BSHAmbiguousName superNode;
        int child = 0;
        Class superClass = null;
        ArrayList meths = new ArrayList(0);
        if (this.extend && Reflect.isGeneratedClass(superClass = (superNode = (BSHAmbiguousName)this.jjtGetChild(child++)).toClass(callstack, interpreter))) {
            if (Reflect.getClassModifiers(superClass).hasModifier("final")) {
                throw new EvalError("Cannot inherit from final class " + superClass.getName(), null, null);
            }
            meths.addAll(Stream.of(Reflect.getDeclaredMethods(superClass)).filter(m -> m.hasModifier("final") && !m.hasModifier("private")).collect(Collectors.toList()));
        }
        Class[] interfaces = new Class[this.numInterfaces];
        for (int i = 0; i < this.numInterfaces; ++i) {
            BSHAmbiguousName node = (BSHAmbiguousName)this.jjtGetChild(child++);
            interfaces[i] = node.toClass(callstack, interpreter);
            if (interfaces[i].isInterface()) continue;
            throw new EvalError("Type: " + node.text + " is not an interface!", this, callstack);
        }
        BSHBlock block = (BSHBlock)this.jjtGetChild(child);
        Class<?> clas = ClassGenerator.getClassGenerator().generateClass(this.name, this.modifiers, interfaces, superClass, block, this.type, callstack, interpreter);
        for (BshMethod m2 : meths) {
            if (null == Reflect.getDeclaredMethod(clas, m2.getName(), m2.getParameterTypes())) continue;
            throw new EvalError("Cannot override " + m2.getName() + "() in " + StringUtil.typeString(superClass) + " overridden method is final", null, null);
        }
        return clas;
    }

    @Override
    public String toString() {
        return "ClassDeclaration: " + this.name;
    }
}

