/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHType;
import bsh.BlockNameSpace;
import bsh.CallStack;
import bsh.CollectionManager;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.ParserConstants;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.UtilEvalError;
import java.util.Iterator;

class BSHEnhancedForStatement
extends SimpleNode
implements ParserConstants {
    String varName;
    boolean isFinal = false;

    BSHEnhancedForStatement(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        Node expression;
        Modifiers modifiers = new Modifiers(2);
        if (this.isFinal) {
            modifiers.addModifier("final");
        }
        Class<Object> elementType = null;
        Node statement = null;
        NameSpace enclosingNameSpace = callstack.top();
        Node firstNode = this.jjtGetChild(0);
        int nodeCount = this.jjtGetNumChildren();
        if (firstNode instanceof BSHType) {
            elementType = ((BSHType)firstNode).getType(callstack, interpreter);
            if (elementType == null) {
                elementType = Object.class;
            }
            expression = this.jjtGetChild(1);
            if (nodeCount > 2) {
                statement = this.jjtGetChild(2);
            }
        } else {
            expression = firstNode;
            if (nodeCount > 1) {
                statement = this.jjtGetChild(1);
            }
        }
        Object iteratee = expression.eval(callstack, interpreter);
        CollectionManager cm = CollectionManager.getCollectionManager();
        Iterator<?> iterator = cm.getBshIterator(iteratee);
        Object returnControl = Primitive.VOID;
        while (!Thread.interrupted() && iterator.hasNext()) {
            Object ret;
            try {
                BlockNameSpace eachNameSpace = new BlockNameSpace(enclosingNameSpace);
                callstack.swap(eachNameSpace);
                Object value = iterator.next();
                if (value == null) {
                    value = Primitive.NULL;
                }
                eachNameSpace.setTypedVariable(this.varName, elementType, value, modifiers);
            }
            catch (UtilEvalError e) {
                throw e.toEvalError("for loop iterator variable:" + this.varName, this, callstack);
            }
            boolean breakout = false;
            if (statement != null && (ret = statement.eval(callstack, interpreter)) instanceof ReturnControl) {
                switch (((ReturnControl)ret).kind) {
                    case 47: {
                        returnControl = ret;
                        breakout = true;
                        break;
                    }
                    case 20: {
                        break;
                    }
                    case 13: {
                        breakout = true;
                    }
                }
            }
            if (!breakout) continue;
            break;
        }
        callstack.swap(enclosingNameSpace);
        return returnControl;
    }
}

