/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArguments;
import bsh.BSHBlock;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.SimpleNode;
import bsh.This;

public class BSHEnumConstant
extends SimpleNode {
    private static final long serialVersionUID = 1L;
    Modifiers mods = new Modifiers(2);
    String name;
    Object[] args;

    public BSHEnumConstant(int id) {
        super(id);
        this.mods.setConstant();
        this.mods.addModifier("enum");
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        NameSpace namespace = callstack.top();
        if (!this.getName().equals("" + namespace.classInstance)) {
            return Primitive.VOID;
        }
        if (this.hasArguments(callstack, interpreter)) {
            This.CONTEXT_ARGS.get().put(namespace.classInstance.toString(), this.getArguments(callstack, interpreter));
        }
        for (int i = 0; i < this.jjtGetNumChildren(); ++i) {
            if (!(this.jjtGetChild(i) instanceof BSHBlock)) continue;
            ((BSHBlock)this.jjtGetChild(i)).eval(callstack, interpreter, true);
        }
        return Primitive.VOID;
    }

    public boolean hasArguments(CallStack callstack, Interpreter interpreter) throws EvalError {
        return null != this.getArguments(callstack, interpreter);
    }

    public Object[] getArguments(CallStack callstack, Interpreter interpreter) throws EvalError {
        if (this.args == null && this.jjtGetNumChildren() > 0 && this.jjtGetChild(0) instanceof BSHArguments) {
            BSHArguments arg = (BSHArguments)this.jjtGetChild(0);
            this.args = arg.getArguments(callstack, interpreter);
        }
        return this.args;
    }

    public Class<?> getType() {
        return Enum.class;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return "EnumConstant: " + this.mods + " " + this.getType() + " " + this.name;
    }
}

