/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.Primitive;
import bsh.SimpleNode;

public final class BSHLiteral
extends SimpleNode {
    public static volatile boolean internStrings = true;
    public Object value;

    BSHLiteral(int id) {
        super(id);
    }

    @Override
    public Object eval(CallStack callstack, Interpreter interpreter) throws EvalError {
        return this.value;
    }

    private char getEscapeChar(char ch) {
        switch (ch) {
            case 'b': {
                ch = (char)8;
                break;
            }
            case 't': {
                ch = (char)9;
                break;
            }
            case 'n': {
                ch = (char)10;
                break;
            }
            case 'f': {
                ch = (char)12;
                break;
            }
            case 'r': {
                ch = (char)13;
                break;
            }
        }
        return ch;
    }

    public void charSetup(String str) {
        int len = str.toCharArray().length;
        if (len == 0 || len > 4 || len > 1 && str.charAt(0) != '\\') {
            this.stringSetup(str);
            return;
        }
        try {
            char ch = str.charAt(0);
            if (ch == '\\') {
                ch = str.charAt(1);
                if (Character.isDigit(ch)) {
                    ch = (char)Integer.parseInt(str.substring(1), 8);
                    if ('\u00ff' < ch) {
                        this.stringSetup(str);
                        return;
                    }
                } else {
                    ch = this.getEscapeChar(ch);
                }
            }
            this.value = new Primitive(Character.valueOf(ch).charValue());
        }
        catch (Exception e) {
            this.stringSetup(str);
        }
    }

    void stringSetup(String str) {
        StringBuilder buffer = new StringBuilder();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                if (Character.isDigit(ch = str.charAt(++i)) && Integer.parseInt(String.valueOf(ch)) < 8) {
                    char t;
                    int endPos;
                    int max = Math.min(i + 2, len - 1);
                    for (endPos = i; endPos < max && Character.isDigit(t = str.charAt(endPos + 1)) && Integer.parseInt(String.valueOf(t)) < 8; ++endPos) {
                    }
                    String num = str.substring(i, endPos + 1);
                    ch = num.length() == 3 && Integer.parseInt(String.valueOf(ch)) > 3 ? (char)Integer.parseInt(str.substring(i, endPos--), 8) : (char)Integer.parseInt(num, 8);
                    i = endPos;
                } else {
                    ch = this.getEscapeChar(ch);
                }
            }
            buffer.append(ch);
        }
        String s = buffer.toString();
        if (internStrings) {
            s = s.intern();
        }
        this.value = s;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.value;
    }
}

