/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Interpreter;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.StringUtil;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.UtilTargetError;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.RandomAccess;
import java.util.function.IntSupplier;

public class BshArray {
    private BshArray() {
    }

    public static Object getIndex(Object array, int index) throws UtilTargetError {
        Interpreter.debug("getIndex: ", array, ", index=", index);
        try {
            if (array instanceof List) {
                return ((List)array).get(index);
            }
            Object val = Array.get(array, index);
            return Primitive.wrap(val, Types.arrayElementType(array.getClass()));
        }
        catch (IndexOutOfBoundsException e1) {
            int len = array instanceof List ? ((List)array).size() : Array.getLength(array);
            throw new UtilTargetError("Index " + index + " out-of-bounds for length " + len, e1);
        }
    }

    public static void setIndex(Object array, int index, Object val) throws ReflectError, UtilTargetError {
        try {
            val = Primitive.unwrap(val);
            if (array instanceof List) {
                ((List)array).set(index, val);
            } else {
                Array.set(array, index, val);
            }
        }
        catch (IllegalArgumentException e1) {
            throw new UtilTargetError(new ArrayStoreException(e1.getMessage()));
        }
        catch (IndexOutOfBoundsException e1) {
            int len = array instanceof List ? ((List)array).size() : Array.getLength(array);
            throw new UtilTargetError("Index " + index + " out-of-bounds for length " + len, e1);
        }
    }

    public static Object slice(List<Object> list, int from, int to, int step) {
        int length = list.size();
        if (to > length) {
            to = length;
        }
        if (0 > from) {
            from = 0;
        }
        if (0 >= (length = to - from)) {
            return list.subList(0, 0);
        }
        if (step == 0 || step == 1) {
            return list.subList(from, to);
        }
        ArrayList<Integer> slices = new ArrayList<Integer>();
        for (int i = 0; i < length; ++i) {
            if (i % step != 0) continue;
            slices.add(step < 0 ? length - 1 - i : i + from);
        }
        return new SteppedSubList(list, slices);
    }

    public static Object slice(Object arr, int from, int to, int step) {
        Class<?> toType = Types.arrayElementType(arr.getClass());
        int length = Array.getLength(arr);
        if (to > length) {
            to = length;
        }
        if (0 > from) {
            from = 0;
        }
        if (0 >= (length = to - from)) {
            return Array.newInstance(toType, 0);
        }
        if (step == 0 || step == 1) {
            Object toArray = Array.newInstance(toType, length);
            System.arraycopy(arr, from, toArray, 0, length);
            return toArray;
        }
        Object[] tmp = new Object[(int)Math.ceil((0.0 + (double)length) / (double)Math.abs(step))];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (i % step != 0) continue;
            tmp[j++] = Array.get(arr, step < 0 ? length - 1 - i : i + from);
        }
        Object toArray = Array.newInstance(toType, tmp.length);
        BshArray.copy(toType, toArray, new Object[]{tmp});
        return toArray;
    }

    public static Object repeat(List<Object> list, int times) {
        AbstractList lst;
        if (times < 1) {
            if (list instanceof Queue) {
                return new LinkedList();
            }
            return new ArrayList(0);
        }
        AbstractList abstractList = lst = list instanceof Queue ? new LinkedList<Object>(list) : new ArrayList<Object>(list);
        if (times == 1) {
            return lst;
        }
        while (times-- > 1) {
            lst.addAll(list);
        }
        return lst;
    }

    public static Object repeat(Object arr, int times) {
        Class<?> toType = Types.arrayElementType(arr.getClass());
        if (times < 1) {
            return Array.newInstance(toType, 0);
        }
        int[] dims = BshArray.dimensions(arr);
        int length = dims[0];
        dims[0] = dims[0] * times;
        int total = dims[0];
        Object toArray = Array.newInstance(toType, dims);
        for (int i = 0; i < total; i += length) {
            System.arraycopy(arr, 0, toArray, i, length);
        }
        return toArray;
    }

    public static Object concat(List<?> lhs, List<?> rhs) {
        AbstractList list = lhs instanceof Queue ? new LinkedList(lhs) : new ArrayList(lhs);
        list.addAll(rhs);
        return list;
    }

    public static Object concat(Object lhs, Object rhs) throws UtilEvalError {
        Class<?> lhsType = lhs.getClass();
        Class<?> rhsType = rhs.getClass();
        if (Types.arrayDimensions(lhsType) != Types.arrayDimensions(rhsType)) {
            throw new UtilEvalError("Cannot concat arrays with inconsistent dimensions. Attempting to concat array of type " + StringUtil.typeString(lhs) + " with array of type " + StringUtil.typeString(rhs) + ".");
        }
        Class<?> toType = Types.getCommonType(Types.arrayElementType(lhsType), Types.arrayElementType(rhsType));
        int[] dims = BshArray.dimensions(lhs);
        dims[0] = Array.getLength(lhs) + Array.getLength(rhs);
        Object toArray = Array.newInstance(toType, dims);
        BshArray.copy(toType, toArray, lhs, rhs);
        return toArray;
    }

    public static int[] dimensions(Object arr) {
        int[] dims = new int[Types.arrayDimensions(arr.getClass())];
        if (0 == dims.length || 0 == (dims[0] = Array.getLength(arr))) {
            return dims;
        }
        for (int i = 1; i < dims.length && null != (arr = Array.get(arr, 0)); ++i) {
            dims[i] = Array.getLength(arr);
        }
        return dims;
    }

    private static void copy(Class<?> toType, Object to, Object ... from) {
        int total;
        int f = 0;
        int fi = 0;
        int length = Array.getLength(from[0]);
        int n = total = from.length > 1 ? Array.getLength(to) : length;
        if (Types.arrayDimensions(to.getClass()) == 1) {
            for (int i = 0; i < total; ++i) {
                Object value = Array.get(from[f], fi++);
                try {
                    value = Primitive.unwrap(Types.castObject(value, toType, 0));
                }
                catch (UtilEvalError utilEvalError) {
                    // empty catch block
                }
                if (Byte.TYPE == toType) {
                    Array.setByte(to, i, (Byte)value);
                } else if (Short.TYPE == toType) {
                    Array.setShort(to, i, (Short)value);
                } else if (Integer.TYPE == toType) {
                    Array.setInt(to, i, (Integer)value);
                } else if (Long.TYPE == toType) {
                    Array.setLong(to, i, (Long)value);
                } else if (Float.TYPE == toType) {
                    Array.setFloat(to, i, ((Float)value).floatValue());
                } else if (Double.TYPE == toType) {
                    Array.setDouble(to, i, (Double)value);
                } else if (Character.TYPE == toType) {
                    Array.setChar(to, i, ((Character)value).charValue());
                } else if (Boolean.TYPE == toType) {
                    Array.setBoolean(to, i, (Boolean)value);
                } else {
                    Array.set(to, i, value);
                }
                if (length >= total || fi != length || f + 1 >= from.length) continue;
                length = Array.getLength(from[++f]);
                fi = 0;
            }
        } else {
            for (int i = 0; i < total; ++i) {
                Object frm;
                if (length < total && fi == length && f + 1 < from.length) {
                    length = Array.getLength(from[++f]);
                    fi = 0;
                }
                if (null == (frm = Array.get(from[f], fi++))) {
                    Array.set(to, i, null);
                    continue;
                }
                Object tto = Array.get(to, i);
                if (Array.getLength(frm) != Array.getLength(tto)) {
                    tto = Array.newInstance(toType, BshArray.dimensions(frm));
                    Array.set(to, i, tto);
                }
                BshArray.copy(toType, tto, frm);
            }
        }
    }

    private static Map<?, ?> mapOfEntries(Map.Entry<?, ?> ... entries) {
        LinkedHashMap looseTypedMap = new LinkedHashMap(entries.length);
        for (Map.Entry<?, ?> entry : entries) {
            looseTypedMap.put(entry.getKey(), entry.getValue());
        }
        return looseTypedMap;
    }

    static Object castArray(Class<?> toType, Class<?> fromType, Object fromValue) throws UtilEvalError {
        int[] dims;
        int length;
        if (Collection.class.isAssignableFrom(toType)) {
            if (List.class.isAssignableFrom(toType) || Queue.class == toType) {
                if (toType.isAssignableFrom(ArrayList.class)) {
                    return new ArrayList<Object>(Arrays.asList((Object[])Types.castObject(fromValue, Object.class, 0)));
                }
                if (toType.isAssignableFrom(LinkedList.class)) {
                    return new LinkedList<Object>(Arrays.asList((Object[])Types.castObject(fromValue, Object.class, 0)));
                }
            } else {
                if (toType.isAssignableFrom(ArrayDeque.class)) {
                    return new ArrayDeque<Object>(Arrays.asList((Object[])Types.castObject(fromValue, Object.class, 0)));
                }
                if (toType.isAssignableFrom(LinkedHashSet.class)) {
                    return new LinkedHashSet<Object>(Arrays.asList((Object[])Types.castObject(fromValue, Object.class, 0)));
                }
            }
        }
        Class<?> baseType = Types.arrayElementType(fromType);
        if (Map.class.isAssignableFrom(toType)) {
            if (Map.Entry.class.isAssignableFrom(baseType)) {
                return BshArray.mapOfEntries((Map.Entry[])fromValue);
            }
            if (toType.isAssignableFrom(LinkedHashMap.class)) {
                int length2 = Array.getLength(fromValue);
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>((int)Math.ceil((0.0 + (double)length2) / 2.0));
                for (int i = 0; i < length2; ++i) {
                    map.put(Array.get(fromValue, i), ++i < length2 ? Array.get(fromValue, i) : null);
                }
                return map;
            }
        }
        if ((length = (dims = BshArray.dimensions(fromValue))[0]) == 0) {
            return Array.newInstance(toType, dims);
        }
        baseType = BshArray.commonType(baseType, fromValue, () -> length);
        if (Map.Entry.class.isAssignableFrom(toType)) {
            if (Map.Entry.class.isAssignableFrom(baseType)) {
                if (Types.MapEntry.class != baseType) {
                    return fromValue;
                }
                Map.Entry[] toArray = new Map.Entry[Array.getLength(fromValue)];
                BshArray.copy(Map.Entry.class, toArray, fromValue);
                return toArray;
            }
            if (length == 1) {
                return new Types.MapEntry(Array.get(fromValue, 0), (Object)null);
            }
            if (length == 2) {
                return new Types.MapEntry(Array.get(fromValue, 0), Array.get(fromValue, 1));
            }
            int size = (int)Math.ceil((0.0 + (double)length) / 2.0);
            Map.Entry[] toArray = new Map.Entry[size];
            int j = 0;
            for (int i = 0; i < length; ++i) {
                toArray[j++] = new Types.MapEntry(Array.get(fromValue, i), ++i < length ? Array.get(fromValue, i) : null);
            }
            return toArray;
        }
        toType = Types.arrayElementType(toType);
        Object toArray = Array.newInstance(toType, dims);
        BshArray.copy(toType, toArray, fromValue);
        return toArray;
    }

    public static Class<?> commonType(Class<?> baseType, Object fromValue, IntSupplier length) {
        if (Object.class != baseType) {
            return baseType;
        }
        Class<?> common = null;
        int len = length.getAsInt();
        for (int i = 0; i < len && Object.class != (common = Types.getCommonType(common, Types.getType(Array.get(fromValue, 0)))); ++i) {
        }
        if (null != common && common != baseType) {
            return common;
        }
        return baseType;
    }

    private static class SteppedSubList
    extends AbstractList<Object>
    implements RandomAccess {
        private final List<Object> parent;
        private final List<Integer> steps;

        SteppedSubList(List<Object> parent, List<Integer> steps) {
            this.parent = parent;
            this.steps = steps;
        }

        @Override
        public Object set(int index, Object e) {
            return this.parent.set(this.steps.get(index), e);
        }

        @Override
        public Object get(int index) {
            return this.parent.get(this.steps.get(index));
        }

        @Override
        public int size() {
            return this.steps.size();
        }

        @Override
        public void add(int index, Object e) {
            int idx = index == this.size() ? this.steps.get(index - 1) + 1 : this.steps.get(index);
            this.parent.add(idx, e);
            for (int i = index; i < this.size(); ++i) {
                this.steps.set(i, this.steps.get(i) + 1);
            }
            this.steps.add(index, idx);
        }

        @Override
        public Object remove(int index) {
            int idx = this.steps.get(index);
            for (int i = index + 1; i < this.size(); ++i) {
                this.steps.set(i, this.steps.get(i) - 1);
            }
            this.steps.remove(index);
            return this.parent.remove(idx);
        }

        @Override
        public boolean addAll(Collection<? extends Object> c) {
            return this.addAll(this.steps.size(), c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Object> c) {
            int cnt = 0;
            for (Object object : c) {
                this.add(index + cnt++, object);
            }
            return cnt > 0;
        }

        @Override
        public List<Object> subList(int fromIndex, int toIndex) {
            return new SteppedSubList(this.parent, this.steps.subList(fromIndex, toIndex));
        }

        @Override
        public Iterator<Object> iterator() {
            return this.listIterator();
        }

        @Override
        public ListIterator<Object> listIterator(int index) {
            final ListIterator<Integer> sliceIter = new ArrayList<Integer>(this.steps).listIterator(index);
            return new ListIterator<Object>(){
                int lastIndex = 0;

                @Override
                public boolean hasNext() {
                    return sliceIter.hasNext();
                }

                @Override
                public Object next() {
                    sliceIter.next();
                    this.lastIndex = this.previousIndex();
                    return this.get(this.lastIndex);
                }

                @Override
                public boolean hasPrevious() {
                    return sliceIter.hasPrevious();
                }

                @Override
                public Object previous() {
                    sliceIter.previous();
                    this.lastIndex = this.nextIndex();
                    return this.get(this.lastIndex);
                }

                @Override
                public int nextIndex() {
                    return sliceIter.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return sliceIter.previousIndex();
                }

                @Override
                public void remove() {
                    this.remove(this.lastIndex);
                    sliceIter.remove();
                    this.lastIndex = -1;
                }

                @Override
                public void set(Object e) {
                    this.set(this.lastIndex, e);
                }

                @Override
                public void add(Object e) {
                    this.add(this.lastIndex, e);
                    sliceIter.add(steps.get(this.lastIndex));
                    this.lastIndex = -1;
                }
            };
        }
    }
}

