/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHBlock;
import bsh.BSHType;
import bsh.BshClassManager;
import bsh.ClassGenerator;
import bsh.DelayedEvalBshMethod;
import bsh.EvalError;
import bsh.FileReader;
import bsh.GeneratedClass;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.Modifiers;
import bsh.Name;
import bsh.NameSpace;
import bsh.Reflect;
import bsh.TargetError;
import bsh.This;
import bsh.Types;
import bsh.UtilEvalError;
import bsh.Variable;
import bsh.org.objectweb.asm.ClassWriter;
import bsh.org.objectweb.asm.Label;
import bsh.org.objectweb.asm.MethodVisitor;
import bsh.org.objectweb.asm.Opcodes;
import bsh.org.objectweb.asm.Type;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class ClassGeneratorUtil
implements Opcodes {
    static final int DEFAULTCONSTRUCTOR = -1;
    static final int ACCESS_MODIFIERS = 7;
    private static final String OBJECT = "Ljava/lang/Object;";
    private final String className;
    private final String canonClassName;
    private final String classDescript;
    private final String fqClassName;
    private final String uuid;
    private final Class superClass;
    private final String superClassName;
    private final Class[] interfaces;
    private final Variable[] vars;
    private final DelayedEvalBshMethod[] constructors;
    private final DelayedEvalBshMethod[] methods;
    private final Modifiers classModifiers;
    private final ClassGenerator.Type type;

    public ClassGeneratorUtil(Modifiers classModifiers, String className, String packageName, Class superClass, Class[] interfaces, Variable[] vars, DelayedEvalBshMethod[] bshmethods, NameSpace classStaticNameSpace, ClassGenerator.Type type) {
        this.classModifiers = classModifiers;
        this.className = className;
        this.type = type;
        if (packageName != null) {
            this.fqClassName = packageName.replace('.', '/') + "/" + className;
            this.canonClassName = packageName + "." + className;
        } else {
            this.fqClassName = className;
            this.canonClassName = className;
        }
        this.classDescript = "L" + this.fqClassName.replace('.', '/') + ";";
        if (superClass == null) {
            superClass = type == ClassGenerator.Type.ENUM ? Enum.class : Object.class;
        }
        this.superClass = superClass;
        this.superClassName = Type.getInternalName(superClass);
        if (interfaces == null) {
            interfaces = Reflect.ZERO_TYPES;
        }
        this.interfaces = interfaces;
        this.vars = vars;
        classStaticNameSpace.isInterface = type == ClassGenerator.Type.INTERFACE;
        classStaticNameSpace.isEnum = type == ClassGenerator.Type.ENUM;
        this.uuid = UUID.randomUUID().toString();
        This.contextStore.put(this.uuid, classStaticNameSpace);
        ArrayList<DelayedEvalBshMethod> consl = new ArrayList<DelayedEvalBshMethod>();
        ArrayList<DelayedEvalBshMethod> methodsl = new ArrayList<DelayedEvalBshMethod>();
        String classBaseName = Types.getBaseName(className);
        for (DelayedEvalBshMethod bshmethod : bshmethods) {
            if (bshmethod.getName().equals(classBaseName)) {
                consl.add(bshmethod);
                continue;
            }
            methodsl.add(bshmethod);
        }
        this.constructors = consl.toArray(new DelayedEvalBshMethod[consl.size()]);
        this.methods = methodsl.toArray(new DelayedEvalBshMethod[methodsl.size()]);
        Interpreter.debug(new Object[]{"Generate class ", type, " ", this.fqClassName, " cons:", consl.size(), " meths:", methodsl.size(), " vars:", vars.length});
        if (type == ClassGenerator.Type.INTERFACE && !classModifiers.hasModifier("abstract")) {
            classModifiers.addModifier("abstract");
        }
        if (type == ClassGenerator.Type.ENUM && !classModifiers.hasModifier("static")) {
            classModifiers.addModifier("static");
        }
    }

    public void initStaticNameSpace(NameSpace classStaticNameSpace, BSHBlock instanceInitBlock) {
        try {
            classStaticNameSpace.setLocalVariable("" + (Object)((Object)This.Keys.BSHCLASSMODIFIERS), this.classModifiers, false);
            classStaticNameSpace.setLocalVariable("" + (Object)((Object)This.Keys.BSHCONSTRUCTORS), this.constructors, false);
            classStaticNameSpace.setLocalVariable("" + (Object)((Object)This.Keys.BSHINIT), instanceInitBlock, false);
        }
        catch (UtilEvalError e) {
            throw new InterpreterError("Unable to init class static block: " + e, e);
        }
    }

    public byte[] generateClass() {
        int modifiers;
        NameSpace classStaticNameSpace = This.contextStore.get(this.uuid);
        int classMods = ClassGeneratorUtil.getASMModifiers(this.classModifiers) | 1;
        if (this.type == ClassGenerator.Type.INTERFACE) {
            classMods |= 0x600;
        } else if (this.type == ClassGenerator.Type.ENUM) {
            classMods |= 0x4030;
        } else if (((classMods |= 0x20) & 0x400) > 0) {
            classMods -= 1024;
        }
        String[] interfaceNames = new String[this.interfaces.length + 1];
        for (int i = 0; i < this.interfaces.length; ++i) {
            interfaceNames[i] = Type.getInternalName(this.interfaces[i]);
            if (!Reflect.isGeneratedClass(this.interfaces[i])) continue;
            for (Variable v : Reflect.getVariables(this.interfaces[i])) {
                classStaticNameSpace.setVariableImpl(v);
            }
        }
        interfaceNames[this.interfaces.length] = Type.getInternalName(GeneratedClass.class);
        ClassWriter cw = new ClassWriter(2);
        String signature = this.type == ClassGenerator.Type.ENUM ? "Ljava/lang/Enum<" + this.classDescript + ">;" : null;
        cw.visit(52, classMods, this.fqClassName, signature, this.superClassName, interfaceNames);
        if (this.type != ClassGenerator.Type.INTERFACE) {
            ClassGeneratorUtil.generateField((Object)((Object)This.Keys.BSHTHIS) + this.className, "Lbsh/This;", 1, cw);
        }
        ClassGeneratorUtil.generateField((Object)((Object)This.Keys.BSHSTATIC) + this.className, "Lbsh/This;", 25, cw);
        ClassGeneratorUtil.generateField("UUID", "Ljava/lang/String;", 25, this.uuid, cw);
        for (Variable var : this.vars) {
            if (var.hasModifier("private")) continue;
            String fType = var.getTypeDescriptor();
            modifiers = ClassGeneratorUtil.getASMModifiers(var.getModifiers());
            if (this.type == ClassGenerator.Type.INTERFACE) {
                var.setConstant();
                classStaticNameSpace.setVariableImpl(var);
                continue;
            }
            if (this.type == ClassGenerator.Type.ENUM && var.hasModifier("enum")) {
                modifiers |= 0x4010;
                fType = this.classDescript;
            }
            ClassGeneratorUtil.generateField(var.getName(), fType, modifiers, cw);
        }
        if (this.type == ClassGenerator.Type.ENUM) {
            this.generateEnumSupport(this.fqClassName, this.className, this.classDescript, cw);
        }
        this.generateStaticInitializer(cw);
        boolean hasConstructor = false;
        for (int i = 0; i < this.constructors.length; ++i) {
            if (this.constructors[i].hasModifier("private")) continue;
            int modifiers2 = ClassGeneratorUtil.getASMModifiers(this.constructors[i].getModifiers());
            if (this.constructors[i].isVarArgs()) {
                modifiers2 |= 0x80;
            }
            this.generateConstructor(i, this.constructors[i].getParamTypeDescriptors(), modifiers2, cw);
            hasConstructor = true;
        }
        if (this.type == ClassGenerator.Type.CLASS && !hasConstructor) {
            this.generateConstructor(-1, new String[0], 1, cw);
        }
        for (DelayedEvalBshMethod method : this.methods) {
            if (method.hasModifier("private")) continue;
            if (!(this.type != ClassGenerator.Type.INTERFACE || method.hasModifier("static") || method.hasModifier("default") || method.hasModifier("abstract"))) {
                method.getModifiers().addModifier("abstract");
            }
            modifiers = ClassGeneratorUtil.getASMModifiers(method.getModifiers());
            if (method.isVarArgs()) {
                modifiers |= 0x80;
            }
            boolean isStatic = (modifiers & 8) > 0;
            this.generateMethod(this.className, this.fqClassName, method.getName(), method.getReturnTypeDescriptor(), method.getParamTypeDescriptors(), modifiers, cw);
            if (null == ClassGeneratorUtil.classContainsMethod(this.superClass, method.getName(), method.getParamTypeDescriptors()) || isStatic) continue;
            this.generateSuperDelegateMethod(this.superClassName, method.getName(), method.getReturnTypeDescriptor(), method.getParamTypeDescriptors(), 1, cw);
        }
        return cw.toByteArray();
    }

    private static int getASMModifiers(Modifiers modifiers) {
        int mods = 0;
        if (modifiers == null) {
            return mods;
        }
        if (modifiers.hasModifier("public")) {
            ++mods;
        }
        if (modifiers.hasModifier("private")) {
            mods += 2;
        }
        if (modifiers.hasModifier("protected")) {
            mods += 4;
        }
        if (modifiers.hasModifier("static")) {
            mods += 8;
        }
        if (modifiers.hasModifier("synchronized")) {
            mods += 32;
        }
        if (modifiers.hasModifier("abstract")) {
            mods += 1024;
        }
        if ((mods & 7) == 0) {
            mods |= 1;
            modifiers.addModifier("public");
        }
        return mods;
    }

    private static void generateField(String fieldName, String type, int modifiers, ClassWriter cw) {
        ClassGeneratorUtil.generateField(fieldName, type, modifiers, null, cw);
    }

    private static void generateField(String fieldName, String type, int modifiers, Object value, ClassWriter cw) {
        cw.visitField(modifiers, fieldName, type, null, value);
    }

    private static String getTypeParameterSignature(String[] paramTypes) {
        StringBuilder sb = new StringBuilder("<");
        for (String pt : paramTypes) {
            sb.append(pt).append(":");
        }
        return sb.toString();
    }

    private void generateEnumSupport(String fqClassName, String className, String classDescript, ClassWriter cw) {
        MethodVisitor cv = cw.visitMethod(9, "values", "()[" + classDescript, null, null);
        ClassGeneratorUtil.pushBshStatic(fqClassName, className, cv);
        cv.visitMethodInsn(182, "bsh/This", "enumValues", "()[Ljava/lang/Object;", false);
        ClassGeneratorUtil.generatePlainReturnCode("[" + classDescript, cv);
        cv.visitMaxs(0, 0);
        cv = cw.visitMethod(9, "valueOf", "(Ljava/lang/String;)" + classDescript, null, null);
        cv.visitLdcInsn(Type.getType(classDescript));
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(184, "java/lang/Enum", "valueOf", "(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;", false);
        ClassGeneratorUtil.generatePlainReturnCode(fqClassName, cv);
        cv.visitMaxs(0, 0);
        cv = cw.visitMethod(2, "<init>", "(Ljava/lang/String;I)V", null, null);
        cv.visitVarInsn(25, 0);
        cv.visitVarInsn(25, 1);
        cv.visitVarInsn(21, 2);
        cv.visitMethodInsn(183, "java/lang/Enum", "<init>", "(Ljava/lang/String;I)V", false);
        cv.visitVarInsn(25, 0);
        cv.visitLdcInsn(className);
        this.generateParameterReifierCode(new String[0], false, cv);
        cv.visitMethodInsn(184, "bsh/This", "initInstance", "(Lbsh/GeneratedClass;Ljava/lang/String;[Ljava/lang/Object;)V", false);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    private void generateEnumStaticInit(String fqClassName, String classDescript, MethodVisitor cv) {
        int ordinal = 3;
        for (Variable var : this.vars) {
            if (!var.hasModifier("enum")) continue;
            cv.visitTypeInsn(187, fqClassName);
            cv.visitInsn(89);
            cv.visitLdcInsn(var.getName());
            if (8 >= ordinal) {
                cv.visitInsn(ordinal++);
            } else {
                cv.visitIntInsn(16, ordinal++ - 3);
            }
            cv.visitMethodInsn(183, fqClassName, "<init>", "(Ljava/lang/String;I)V", false);
            cv.visitFieldInsn(179, fqClassName, var.getName(), classDescript);
        }
    }

    private void generateMethod(String className, String fqClassName, String methodName, String returnType, String[] paramTypes, int modifiers, ClassWriter cw) {
        boolean isStatic;
        String[] exceptions = null;
        boolean bl = isStatic = (modifiers & 8) != 0;
        if (returnType == null) {
            returnType = OBJECT;
        }
        String methodDescriptor = ClassGeneratorUtil.getMethodDescriptor(returnType, paramTypes);
        String paramTypesSig = ClassGeneratorUtil.getTypeParameterSignature(paramTypes);
        MethodVisitor cv = cw.visitMethod(modifiers, methodName, methodDescriptor, paramTypesSig, exceptions);
        if ((modifiers & 0x400) != 0) {
            return;
        }
        if (isStatic || this.type == ClassGenerator.Type.INTERFACE) {
            ClassGeneratorUtil.pushBshStatic(fqClassName, className, cv);
        } else {
            ClassGeneratorUtil.pushBshThis(fqClassName, className, cv);
        }
        cv.visitLdcInsn(methodName);
        this.generateParameterReifierCode(paramTypes, isStatic, cv);
        cv.visitInsn(4);
        cv.visitMethodInsn(182, "bsh/This", "invokeMethod", "(Ljava/lang/String;[Ljava/lang/Object;Z)Ljava/lang/Object;", false);
        this.generateReturnCode(returnType, cv);
        cv.visitMaxs(0, 0);
    }

    void generateConstructor(int index, String[] paramTypes, int modifiers, ClassWriter cw) {
        int argsVar = paramTypes.length + 1;
        int consArgsVar = paramTypes.length + 2;
        String[] exceptions = null;
        String methodDescriptor = ClassGeneratorUtil.getMethodDescriptor("V", paramTypes);
        String paramTypesSig = ClassGeneratorUtil.getTypeParameterSignature(paramTypes);
        MethodVisitor cv = cw.visitMethod(modifiers, "<init>", methodDescriptor, paramTypesSig, exceptions);
        this.generateParameterReifierCode(paramTypes, false, cv);
        cv.visitVarInsn(58, argsVar);
        this.generateConstructorSwitch(index, argsVar, consArgsVar, cv);
        cv.visitVarInsn(25, 0);
        cv.visitLdcInsn(this.className);
        cv.visitVarInsn(25, argsVar);
        cv.visitMethodInsn(184, "bsh/This", "initInstance", "(Lbsh/GeneratedClass;Ljava/lang/String;[Ljava/lang/Object;)V", false);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    void generateStaticInitializer(ClassWriter cw) {
        MethodVisitor cv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        cv.visitFieldInsn(178, this.fqClassName, "UUID", "Ljava/lang/String;");
        cv.visitMethodInsn(184, "bsh/This", "pullBshStatic", "(Ljava/lang/String;)Lbsh/This;", false);
        cv.visitFieldInsn(179, this.fqClassName, (Object)((Object)This.Keys.BSHSTATIC) + this.className, "Lbsh/This;");
        if (this.type == ClassGenerator.Type.ENUM) {
            this.generateEnumStaticInit(this.fqClassName, this.classDescript, cv);
        }
        cv.visitLdcInsn(Type.getType(this.classDescript));
        cv.visitMethodInsn(184, "bsh/This", "initStatic", "(Ljava/lang/Class;)V", false);
        cv.visitInsn(177);
        cv.visitMaxs(0, 0);
    }

    void generateConstructorSwitch(int consIndex, int argsVar, int consArgsVar, MethodVisitor cv) {
        Label defaultLabel = new Label();
        Label endLabel = new Label();
        List<Invocable> superConstructors = BshClassManager.memberCache.get(this.superClass).members(this.superClass.getName());
        int cases = superConstructors.size() + this.constructors.length;
        Label[] labels = new Label[cases];
        for (int i = 0; i < cases; ++i) {
            labels[i] = new Label();
        }
        cv.visitLdcInsn(Type.getType(BSHType.getTypeDescriptor(this.superClass)));
        ClassGeneratorUtil.pushBshStatic(this.fqClassName, this.className, cv);
        cv.visitVarInsn(25, argsVar);
        cv.visitIntInsn(16, consIndex);
        cv.visitMethodInsn(184, "bsh/This", "getConstructorArgs", "(Ljava/lang/Class;Lbsh/This;[Ljava/lang/Object;I)Lbsh/This$ConstructorArgs;", false);
        cv.visitVarInsn(58, consArgsVar);
        cv.visitVarInsn(25, consArgsVar);
        cv.visitFieldInsn(180, "bsh/This$ConstructorArgs", "selector", "I");
        cv.visitTableSwitchInsn(0, cases - 1, defaultLabel, labels);
        int index = 0;
        int i = 0;
        while (i < superConstructors.size()) {
            this.doSwitchBranch(index, this.superClassName, superConstructors.get(i).getParamTypeDescriptors(), endLabel, labels, consArgsVar, cv);
            ++i;
            ++index;
        }
        i = 0;
        while (i < this.constructors.length) {
            this.doSwitchBranch(index, this.fqClassName, this.constructors[i].getParamTypeDescriptors(), endLabel, labels, consArgsVar, cv);
            ++i;
            ++index;
        }
        cv.visitLabel(defaultLabel);
        cv.visitVarInsn(25, 0);
        cv.visitMethodInsn(183, this.superClassName, "<init>", "()V", false);
        cv.visitLabel(endLabel);
    }

    private static void pushBshStatic(String fqClassName, String className, MethodVisitor cv) {
        cv.visitFieldInsn(178, fqClassName, (Object)((Object)This.Keys.BSHSTATIC) + className, "Lbsh/This;");
    }

    private static void pushBshThis(String fqClassName, String className, MethodVisitor cv) {
        cv.visitVarInsn(25, 0);
        cv.visitFieldInsn(180, fqClassName, (Object)((Object)This.Keys.BSHTHIS) + className, "Lbsh/This;");
    }

    private void doSwitchBranch(int index, String targetClassName, String[] paramTypes, Label endLabel, Label[] labels, int consArgsVar, MethodVisitor cv) {
        cv.visitLabel(labels[index]);
        cv.visitVarInsn(25, 0);
        for (String type : paramTypes) {
            String method = type.equals("Z") ? "getBoolean" : (type.equals("B") ? "getByte" : (type.equals("C") ? "getChar" : (type.equals("S") ? "getShort" : (type.equals("I") ? "getInt" : (type.equals("J") ? "getLong" : (type.equals("D") ? "getDouble" : (type.equals("F") ? "getFloat" : "getObject")))))));
            cv.visitVarInsn(25, consArgsVar);
            String className = "bsh/This$ConstructorArgs";
            String retType = method.equals("getObject") ? OBJECT : type;
            cv.visitMethodInsn(182, className, method, "()" + retType, false);
            if (!method.equals("getObject")) continue;
            cv.visitTypeInsn(192, ClassGeneratorUtil.descriptorToClassName(type));
        }
        String descriptor = ClassGeneratorUtil.getMethodDescriptor("V", paramTypes);
        cv.visitMethodInsn(183, targetClassName, "<init>", descriptor, false);
        cv.visitJumpInsn(167, endLabel);
    }

    private static String getMethodDescriptor(String returnType, String[] paramTypes) {
        StringBuilder sb = new StringBuilder("(");
        for (String paramType : paramTypes) {
            sb.append(paramType);
        }
        sb.append(')').append(returnType);
        return sb.toString();
    }

    private void generateSuperDelegateMethod(String superClassName, String methodName, String returnType, String[] paramTypes, int modifiers, ClassWriter cw) {
        String[] exceptions = null;
        if (returnType == null) {
            returnType = OBJECT;
        }
        String methodDescriptor = ClassGeneratorUtil.getMethodDescriptor(returnType, paramTypes);
        String paramTypesSig = ClassGeneratorUtil.getTypeParameterSignature(paramTypes);
        MethodVisitor cv = cw.visitMethod(modifiers, "_bshSuper" + methodName, methodDescriptor, paramTypesSig, exceptions);
        cv.visitVarInsn(25, 0);
        int localVarIndex = 1;
        for (String paramType : paramTypes) {
            if (ClassGeneratorUtil.isPrimitive(paramType)) {
                cv.visitVarInsn(21, localVarIndex);
            } else {
                cv.visitVarInsn(25, localVarIndex);
            }
            localVarIndex += paramType.equals("D") || paramType.equals("J") ? 2 : 1;
        }
        cv.visitMethodInsn(183, superClassName, methodName, methodDescriptor, false);
        ClassGeneratorUtil.generatePlainReturnCode(returnType, cv);
        cv.visitMaxs(0, 0);
    }

    static void checkAbstractMethodImplementation(Class<?> type) {
        ArrayList meths = new ArrayList();
        class Reflector {
            final /* synthetic */ List val$meths;

            Reflector(List list) {
                this.val$meths = list;
            }

            void gatherMethods(Class<?> type) {
                if (null != type.getSuperclass()) {
                    this.gatherMethods(type.getSuperclass());
                }
                this.val$meths.addAll(Arrays.asList(type.getDeclaredMethods()));
                for (Class<?> i : type.getInterfaces()) {
                    this.gatherMethods(i);
                }
            }
        }
        new Reflector(meths).gatherMethods(type);
        meths.stream().filter(m -> (m.getModifiers() & 0x400) > 0).forEach(method -> {
            Method[] meth = (Method[])meths.stream().filter(m -> method.getName().equals(m.getName()) && (m.getModifiers() & 0x402) == 0 && Types.areSignaturesEqual(method.getParameterTypes(), m.getParameterTypes())).sorted((a, b) -> (a.getModifiers() & 1) > 0 || (b.getModifiers() & 5) == 0 ? -1 : ((a.getModifiers() & 7) == (b.getModifiers() & 7) ? 0 : 1)).toArray(Method[]::new);
            if (meth.length == 0 && !Reflect.getClassModifiers(type).hasModifier("abstract")) {
                throw new RuntimeException(type.getSimpleName() + " is not abstract and does not override abstract method " + method.getName() + "() in " + method.getDeclaringClass().getSimpleName());
            }
            if (meth.length > 0) {
                ClassGeneratorUtil.checkInheritanceRules(method.getModifiers(), meth[0].getModifiers(), method.getDeclaringClass());
            }
        });
    }

    static boolean checkInheritanceRules(int parentModifiers, int overriddenModifiers, Class<?> parentClass) {
        int chld = overriddenModifiers & 7;
        int prnt = parentModifiers & 7;
        if (chld == prnt || prnt == 2 || chld == 1 || prnt == 0 && chld != 2) {
            return true;
        }
        throw new RuntimeException("Cannot reduce the visibility of the inherited method from " + parentClass.getName());
    }

    static Method classContainsMethod(Class<?> clas, String methodName, String[] paramTypes) {
        while (clas != null) {
            for (Method method : clas.getDeclaredMethods()) {
                if (!method.getName().equals(methodName) || paramTypes.length != method.getParameterCount()) continue;
                String[] methodParamTypes = ClassGeneratorUtil.getTypeDescriptors(method.getParameterTypes());
                boolean found = true;
                for (int j = 0; j < paramTypes.length && (found = paramTypes[j].equals(methodParamTypes[j])); ++j) {
                }
                if (!found) continue;
                return method;
            }
            clas = clas.getSuperclass();
        }
        return null;
    }

    private static void generatePlainReturnCode(String returnType, MethodVisitor cv) {
        if (returnType.equals("V")) {
            cv.visitInsn(177);
        } else if (ClassGeneratorUtil.isPrimitive(returnType)) {
            int opcode = 172;
            if (returnType.equals("D")) {
                opcode = 175;
            } else if (returnType.equals("F")) {
                opcode = 174;
            } else if (returnType.equals("J")) {
                opcode = 173;
            }
            cv.visitInsn(opcode);
        } else {
            cv.visitTypeInsn(192, ClassGeneratorUtil.descriptorToClassName(returnType));
            cv.visitInsn(176);
        }
    }

    private void generateParameterReifierCode(String[] paramTypes, boolean isStatic, MethodVisitor cv) {
        cv.visitIntInsn(17, paramTypes.length);
        cv.visitTypeInsn(189, "java/lang/Object");
        int localVarIndex = isStatic ? 0 : 1;
        for (int i = 0; i < paramTypes.length; ++i) {
            String param = paramTypes[i];
            cv.visitInsn(89);
            cv.visitIntInsn(17, i);
            if (ClassGeneratorUtil.isPrimitive(param)) {
                int opcode = param.equals("F") ? 23 : (param.equals("D") ? 24 : (param.equals("J") ? 22 : 21));
                String type = "bsh/Primitive";
                cv.visitTypeInsn(187, type);
                cv.visitInsn(89);
                cv.visitVarInsn(opcode, localVarIndex);
                cv.visitMethodInsn(183, type, "<init>", "(" + param + ")V", false);
                cv.visitInsn(83);
            } else {
                cv.visitVarInsn(25, localVarIndex);
                Label isnull = new Label();
                cv.visitJumpInsn(199, isnull);
                cv.visitFieldInsn(178, "bsh/Primitive", "NULL", "Lbsh/Primitive;");
                cv.visitInsn(83);
                Label notnull = new Label();
                cv.visitJumpInsn(167, notnull);
                cv.visitLabel(isnull);
                cv.visitVarInsn(25, localVarIndex);
                cv.visitInsn(83);
                cv.visitLabel(notnull);
            }
            localVarIndex += param.equals("D") || param.equals("J") ? 2 : 1;
        }
    }

    private void generateReturnCode(String returnType, MethodVisitor cv) {
        if (returnType.equals("V")) {
            cv.visitInsn(87);
            cv.visitInsn(177);
        } else if (ClassGeneratorUtil.isPrimitive(returnType)) {
            String meth;
            String type;
            int opcode = 172;
            if (returnType.equals("Z")) {
                type = "java/lang/Boolean";
                meth = "booleanValue";
            } else if (returnType.equals("C")) {
                type = "java/lang/Character";
                meth = "charValue";
            } else if (returnType.equals("B")) {
                type = "java/lang/Byte";
                meth = "byteValue";
            } else if (returnType.equals("S")) {
                type = "java/lang/Short";
                meth = "shortValue";
            } else if (returnType.equals("F")) {
                opcode = 174;
                type = "java/lang/Float";
                meth = "floatValue";
            } else if (returnType.equals("J")) {
                opcode = 173;
                type = "java/lang/Long";
                meth = "longValue";
            } else if (returnType.equals("D")) {
                opcode = 175;
                type = "java/lang/Double";
                meth = "doubleValue";
            } else {
                type = "java/lang/Integer";
                meth = "intValue";
            }
            String desc = returnType;
            cv.visitTypeInsn(192, type);
            cv.visitMethodInsn(182, type, meth, "()" + desc, false);
            cv.visitInsn(opcode);
        } else {
            cv.visitTypeInsn(192, ClassGeneratorUtil.descriptorToClassName(returnType));
            cv.visitInsn(176);
        }
    }

    private static boolean isPrimitive(String typeDescriptor) {
        return typeDescriptor.length() == 1;
    }

    static String[] getTypeDescriptors(Class<?>[] cparams) {
        String[] sa = new String[cparams.length];
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = BSHType.getTypeDescriptor(cparams[i]);
        }
        return sa;
    }

    private static String descriptorToClassName(String s) {
        if (s.startsWith("[") || !s.startsWith("L")) {
            return s;
        }
        return s.substring(1, s.length() - 1);
    }

    public static void startInterpreterForClass(Class<?> genClass) {
        String fqClassName = genClass.getName();
        String baseName = Name.suffix(fqClassName, 1);
        String resName = baseName + ".bsh";
        URL url = genClass.getResource(resName);
        if (null == url) {
            throw new InterpreterError("Script (" + resName + ") for BeanShell generated class: " + genClass + " not found.");
        }
        try (FileReader reader = new FileReader(genClass.getResourceAsStream(resName));){
            Interpreter bsh = new Interpreter();
            NameSpace globalNS = bsh.getNameSpace();
            globalNS.setName("class_" + baseName + "_global");
            globalNS.getClassManager().associateClass(genClass);
            bsh.eval(reader, globalNS, resName);
        }
        catch (TargetError e) {
            System.out.println("Script threw exception: " + e);
            if (e.inNativeCode()) {
                e.printStackTrace(System.err);
            }
        }
        catch (EvalError | IOException e) {
            System.out.println("Evaluation Error: " + e);
        }
    }
}

