/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ExecutingInvocable;
import bsh.Invocable;
import bsh.Reflect;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.util.stream.Stream;

class ConstructorInvocable
extends ExecutingInvocable {
    private Constructor<?> constructor;
    private final boolean isStatic;

    ConstructorInvocable(Constructor<?> cons) {
        super(cons);
        this.constructor = cons;
        this.isStatic = Reflect.isStatic(this.getDeclaringClass());
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public Class<?> getReturnType() {
        return this.getDeclaringClass();
    }

    @Override
    public boolean isInnerClass() {
        return this.getDeclaringClass().isMemberClass();
    }

    @Override
    protected MethodHandle lookup(MethodHandle m) {
        try {
            MethodHandle methodHandle = super.lookup(MethodHandles.lookup().unreflectConstructor(this.constructor));
            return methodHandle;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.constructor = null;
        }
    }

    @Override
    public Invocable.ParameterType collectParamaters(Object base, Object[] params) throws Throwable {
        if (this.isInnerClass() && !this.isStatic()) {
            params = Stream.concat(Stream.of(base), Stream.of(params)).toArray();
        }
        return super.collectParamaters(base, params);
    }
}

