/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHArguments;
import bsh.BSHBlock;
import bsh.BSHFormalParameters;
import bsh.BSHMethodInvocation;
import bsh.BSHReturnType;
import bsh.BshMethod;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Node;
import bsh.This;

public class DelayedEvalBshMethod
extends BshMethod {
    private static final long serialVersionUID = 1L;
    String returnTypeDescriptor;
    BSHReturnType returnTypeNode;
    String[] paramTypeDescriptors;
    BSHFormalParameters paramTypesNode;
    transient CallStack callstack;
    transient Interpreter interpreter;
    private BSHArguments argsNode = null;
    private Invocable constructor = null;
    private Object[] constructorArgs = null;

    DelayedEvalBshMethod(String name, String returnTypeDescriptor, BSHReturnType returnTypeNode, String[] paramNames, String[] paramTypeDescriptors, BSHFormalParameters paramTypesNode, BSHBlock methodBody, NameSpace declaringNameSpace, Modifiers modifiers, boolean isVarArgs, CallStack callstack, Interpreter interpreter) {
        super(name, null, paramNames, null, null, methodBody, declaringNameSpace, modifiers, isVarArgs);
        this.returnTypeDescriptor = returnTypeDescriptor;
        this.returnTypeNode = returnTypeNode;
        this.paramTypeDescriptors = paramTypeDescriptors;
        this.paramTypesNode = paramTypesNode;
        this.callstack = callstack;
        this.interpreter = interpreter;
    }

    DelayedEvalBshMethod(String name, Invocable con, NameSpace declaringNameSpace) {
        this(name, con.getReturnTypeDescriptor(), null, new String[con.getParameterCount()], con.getParamTypeDescriptors(), null, new BSHBlock(0), declaringNameSpace, null, con.isVarArgs(), null, null);
        this.constructor = con;
        this.getModifiers().addModifier("public");
        this.getParameterModifiers();
        declaringNameSpace.setMethod(this);
        this.constructorArgs = This.CONTEXT_ARGS.get().remove(name);
    }

    public String getReturnTypeDescriptor() {
        return this.returnTypeDescriptor;
    }

    @Override
    public Class<?> getReturnType() {
        if (this.returnTypeNode == null) {
            return null;
        }
        try {
            return this.returnTypeNode.evalReturnType(this.callstack, this.interpreter);
        }
        catch (EvalError e) {
            throw new InterpreterError("can't eval return type: " + e, e);
        }
    }

    public String[] getParamTypeDescriptors() {
        return this.paramTypeDescriptors;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        if (null != this.constructor) {
            return this.constructor.getParameterTypes();
        }
        try {
            return (Class[])this.paramTypesNode.eval(this.callstack, this.interpreter);
        }
        catch (EvalError e) {
            throw new InterpreterError("can't eval param types: " + e, e);
        }
    }

    public String getAltConstructor() {
        if (null != this.constructor) {
            return "super";
        }
        if (this.methodBody.jjtGetNumChildren() == 0) {
            return null;
        }
        Node firstStatement = this.methodBody.jjtGetChild(0);
        while (!(firstStatement instanceof BSHMethodInvocation) && firstStatement.jjtGetNumChildren() > 0) {
            firstStatement = firstStatement.jjtGetChild(0);
        }
        if (firstStatement instanceof BSHMethodInvocation) {
            BSHMethodInvocation methodNode = (BSHMethodInvocation)firstStatement;
            String methodName = methodNode.getNameNode().text;
            if (methodName.equals("super") || methodName.equals("this")) {
                this.argsNode = methodNode.getArgsNode();
                return methodName;
            }
        }
        return null;
    }

    public BSHArguments getArgsNode() {
        return this.argsNode;
    }

    public Object[] getConstructorArgs() {
        return this.constructorArgs;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        DelayedEvalBshMethod m = (DelayedEvalBshMethod)o;
        if (!this.getName().equals(m.getName()) || this.getParameterCount() != m.getParameterCount()) {
            return false;
        }
        for (int i = 0; i < this.getParamTypeDescriptors().length; ++i) {
            if (DelayedEvalBshMethod.equal(this.getParamTypeDescriptors()[i], m.getParamTypeDescriptors()[i])) continue;
            return false;
        }
        return this.isVarArgs == m.isVarArgs;
    }

    @Override
    public int hashCode() {
        int h = this.getName().hashCode() + this.getClass().hashCode();
        for (String cparamType : this.getParamTypeDescriptors()) {
            h += 3 + (cparamType == null ? 0 : cparamType.hashCode());
        }
        return h + this.getParameterCount();
    }
}

