/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.InterpreterError;
import bsh.LHS;
import bsh.Modifiers;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.UtilEvalError;
import bsh.Variable;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class ExternalNameSpace
extends NameSpace {
    private Map<String, Object> externalMap;

    public ExternalNameSpace() {
        this(null, "External Map Namespace", null);
    }

    public ExternalNameSpace(NameSpace parent, String name, Map<String, Object> externalMap) {
        super(parent, name);
        if (externalMap == null) {
            externalMap = new HashMap<String, Object>();
        }
        this.externalMap = externalMap;
    }

    public Map<String, Object> getMap() {
        return this.externalMap;
    }

    public void setMap(Map<String, Object> map) {
        this.clear();
        this.externalMap = map;
    }

    @Override
    public void unsetVariable(String name) {
        super.unsetVariable(name);
        this.externalMap.remove(name);
    }

    @Override
    public String[] getVariableNames() {
        return (String[])Stream.concat(Stream.of(super.getVariableNames()), this.externalMap.keySet().stream()).toArray(String[]::new);
    }

    @Override
    protected Variable getVariableImpl(String name, boolean recurse) throws UtilEvalError {
        Variable var;
        Object value = this.externalMap.get(name);
        if (value == null && this.externalMap.containsKey(name)) {
            value = Primitive.NULL;
        }
        if (value == null) {
            super.unsetVariable(name);
            var = super.getVariableImpl(name, recurse);
        } else {
            Variable localVar = super.getVariableImpl(name, false);
            var = localVar == null ? this.createVariable(name, (Class)null, value, (Modifiers)null) : localVar;
        }
        return var;
    }

    public Variable createVariable(String name, Class type, Object value, Modifiers mods) {
        LHS lhs = new LHS(this.externalMap, (Object)name);
        try {
            lhs.assign(value, false);
        }
        catch (UtilEvalError e) {
            throw new InterpreterError(e.toString());
        }
        return new Variable(name, type, lhs);
    }

    @Override
    public void clear() {
        super.clear();
        this.externalMap.clear();
    }
}

