/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.Invocable;
import bsh.Primitive;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;

class FieldAccess
extends Invocable {
    private Field field;
    private final Class<?> type;
    private MethodHandle setter;
    private boolean getter = false;

    FieldAccess(Field field) {
        super(field);
        this.type = field.getType();
        this.field = field;
    }

    @Override
    protected MethodHandle lookup(MethodHandle m) {
        try {
            MethodHandle methodHandle = MethodHandles.lookup().unreflectGetter(this.field);
            return methodHandle;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.getter = true;
            if (null != this.setter) {
                this.field = null;
            }
        }
    }

    protected MethodHandle lookup() {
        try {
            MethodHandle methodHandle = MethodHandles.lookup().unreflectSetter(this.field);
            return methodHandle;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.getter) {
                this.field = null;
            }
        }
    }

    public MethodHandle getSetterHandle() {
        if (null == this.setter) {
            this.setter = this.lookup();
        }
        return this.setter;
    }

    @Override
    public synchronized Object invoke(Object base, Object ... pars) throws InvocationTargetException {
        try {
            if (0 == pars.length) {
                if (this.isStatic()) {
                    return Primitive.wrap(this.getMethodHandle().invoke(), this.getReturnType());
                }
                return Primitive.wrap(this.getMethodHandle().invoke(base), this.getReturnType());
            }
            if (this.isStatic()) {
                return this.getSetterHandle().invoke(super.coerceToType(pars[0], this.getParameterTypes()[0]));
            }
            return this.getSetterHandle().invoke(base, super.coerceToType(pars[0], this.getParameterTypes()[0]));
        }
        catch (Throwable ite) {
            throw new InvocationTargetException(ite.getCause());
        }
    }

    @Override
    public Class<?> getReturnType() {
        return this.type;
    }

    @Override
    public int getParameterCount() {
        return 1;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return new Class[]{this.type};
    }
}

