/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.CommandLineReader;
import bsh.ConsoleAssignable;
import bsh.ConsoleInterface;
import bsh.EvalError;
import bsh.FileReader;
import bsh.InterpreterError;
import bsh.Invocable;
import bsh.JJTParserState;
import bsh.LHS;
import bsh.Name;
import bsh.NameSpace;
import bsh.Node;
import bsh.ParseException;
import bsh.Parser;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReturnControl;
import bsh.StringUtil;
import bsh.TargetError;
import bsh.This;
import bsh.UtilEvalError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ResourceBundle;

public class Interpreter
implements Runnable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final ThreadLocal<Boolean> DEBUG = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private boolean EOF;
    public static boolean TRACE;
    public static boolean COMPATIBIILTY;
    public static final String VERSION;
    private static final This SYSTEM_OBJECT;
    private boolean strictJava = false;
    transient Parser parser;
    NameSpace globalNameSpace;
    ConsoleAssignable console;
    Interpreter parent;
    String sourceFileInfo;
    private int yield_for = -1;
    private boolean exitOnEOF = true;
    protected boolean evalOnly;
    protected boolean interactive;
    private boolean showResults = true;
    private boolean compatibility = COMPATIBIILTY;
    private String prompt = null;

    public static void setShutdownOnExit(boolean value) {
        try {
            SYSTEM_OBJECT.getNameSpace().setVariable("shutdownOnExit", value, false);
        }
        catch (UtilEvalError utilEvalError) {
            throw new IllegalStateException(utilEvalError);
        }
    }

    public Interpreter(ConsoleAssignable console, boolean interactive, NameSpace namespace, Interpreter parent, String sourceFileInfo) {
        long t1 = 0L;
        if (DEBUG.get().booleanValue()) {
            t1 = System.nanoTime();
        }
        this.interactive = interactive;
        this.parent = parent;
        if (parent != null) {
            this.setStrictJava(parent.strictJava);
            this.parser = parent.parser;
            this.evalOnly = parent.evalOnly;
        }
        this.sourceFileInfo = sourceFileInfo;
        if (namespace == null) {
            BshClassManager bcm = BshClassManager.createClassManager(this);
            namespace = new NameSpace(namespace, bcm, "global");
        }
        this.setNameSpace(namespace);
        this.setConsole(console);
        if (DEBUG.get().booleanValue()) {
            Interpreter.debug("Time to initialize interpreter: interactive=", interactive, " ", System.nanoTime() - t1, " nanoseconds.");
        }
    }

    public Interpreter(Reader in, PrintStream out, PrintStream err, boolean interactive, NameSpace namespace, Interpreter parent, String sourceFileInfo) {
        this(new Console(in, out, err), interactive, namespace, parent, sourceFileInfo);
    }

    public Interpreter(Reader in, PrintStream out, PrintStream err, boolean interactive, NameSpace namespace) {
        this(in, out, err, interactive, namespace, null, null);
    }

    public Interpreter(Reader in, PrintStream out, PrintStream err, boolean interactive) {
        this(in, out, err, interactive, null);
    }

    public Interpreter(ConsoleInterface console, NameSpace namespace, Interpreter parent) {
        this(new Console(console), true, namespace, parent, null == parent ? null : parent.sourceFileInfo);
    }

    public Interpreter(ConsoleInterface console, Interpreter parent) {
        this(console, parent.globalNameSpace, parent);
    }

    public Interpreter(ConsoleInterface console, NameSpace globalNameSpace) {
        this(console, globalNameSpace, null);
    }

    public Interpreter(ConsoleInterface console) {
        this(console, null, null);
    }

    public Interpreter() {
        this(null, null, "");
        this.sourceFileInfo = null;
    }

    public Interpreter(NameSpace namespace) {
        this(namespace, null, null);
    }

    public Interpreter(NameSpace namespace, String sourceFileInfo) {
        this(namespace, null, sourceFileInfo);
    }

    public Interpreter(NameSpace namespace, Interpreter parent) {
        this(namespace, parent, null);
    }

    public Interpreter(NameSpace namespace, Interpreter parent, String sourceFileInfo) {
        this(null, System.out, System.err, false, namespace, parent, sourceFileInfo);
        this.evalOnly = true;
        this.setu("bsh.evalOnly", Primitive.TRUE);
    }

    public Interpreter(Interpreter parent) {
        this(parent.console, parent.interactive, parent.globalNameSpace, parent, parent.sourceFileInfo);
    }

    public void setConsole(ConsoleAssignable console) {
        this.console = console;
        if (null == this.parser || this.get_jjtree().nodeArity() != 0 || null != this.parent && this.parent.interactive) {
            this.parser = new Parser(this.getIn());
        } else {
            this.parser.ReInit(this.getIn());
        }
    }

    public void setConsole(ConsoleInterface console) {
        this.setConsole(new Console(console));
    }

    private void initRootSystemObject() {
        BshClassManager bcm = this.getClassManager();
        this.setu("bsh", new NameSpace(null, bcm, "Bsh Object").getThis(this));
        this.setu("bsh.system", SYSTEM_OBJECT);
        this.setu("bsh.shared", SYSTEM_OBJECT);
        This helpText = new NameSpace(null, bcm, "Bsh Command Help Text").getThis(this);
        this.setu("bsh.help", helpText);
        this.setu("bsh.cwd", System.getProperty("user.dir"));
        this.setu("bsh.interactive", this.interactive ? Primitive.TRUE : Primitive.FALSE);
        this.setu("bsh.evalOnly", Primitive.FALSE);
    }

    public void setNameSpace(NameSpace namespace) {
        this.globalNameSpace = namespace;
        if (null != namespace) {
            try {
                if (!(namespace.getVariable("bsh") instanceof This)) {
                    this.initRootSystemObject();
                    if (this.interactive) {
                        this.loadRCFiles();
                    }
                }
            }
            catch (UtilEvalError e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public NameSpace getNameSpace() {
        return this.globalNameSpace;
    }

    public static void main(String[] args) {
        block13: {
            if (args.length > 0) {
                String[] bshArgs;
                String filename = args[0];
                if (args.length > 1) {
                    bshArgs = new String[args.length - 1];
                    System.arraycopy(args, 1, bshArgs, 0, args.length - 1);
                } else {
                    bshArgs = new String[]{};
                }
                try {
                    Interpreter interpreter = new Interpreter();
                    interpreter.setu("bsh.args", bshArgs);
                    Object result = interpreter.source(filename, interpreter.globalNameSpace);
                    if (!(result instanceof Class)) break block13;
                    try {
                        Interpreter.invokeMain((Class)result, bshArgs);
                    }
                    catch (Exception e) {
                        Throwable o = e;
                        if (e instanceof InvocationTargetException) {
                            o = e.getCause();
                        }
                        System.err.println("Class: " + result + " main method threw exception:" + o);
                    }
                }
                catch (FileNotFoundException e) {
                    System.err.println("File not found: " + e);
                }
                catch (TargetError e) {
                    System.err.println("Script threw exception: " + e);
                    if (e.inNativeCode()) {
                        e.printStackTrace(DEBUG.get(), System.err);
                    }
                }
                catch (EvalError e) {
                    System.err.println("Evaluation Error: " + e);
                }
                catch (IOException e) {
                    System.err.println("I/O Error: " + e);
                }
            } else {
                Interpreter interpreter = new Interpreter(new CommandLineReader(new FileReader(System.in)), System.out, System.err, true);
                interpreter.run();
            }
        }
    }

    public static void invokeMain(Class<?> clas, String[] args) throws Exception {
        Invocable main = Reflect.resolveJavaMethod(clas, "main", new Class[]{String[].class}, true);
        if (null != main) {
            main.invoke(null, new Object[]{args});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.evalOnly) {
            throw new RuntimeException("bsh Interpreter: No stream");
        }
        if (this.interactive && null == this.getParent()) {
            try {
                this.eval("printBanner();");
            }
            catch (EvalError e) {
                this.println("BeanShell " + VERSION);
            }
        }
        CallStack callstack = new CallStack(this.globalNameSpace);
        Node node = null;
        this.EOF = false;
        int idx = -1;
        while (!Thread.interrupted() && !this.EOF) {
            try {
                if (this.interactive) {
                    this.console.prompt(this.getBshPrompt());
                }
                this.EOF = this.readLine();
                if (this.get_jjtree().nodeArity() <= 0) continue;
                node = this.get_jjtree().rootNode();
                node.setSourceFile(this.sourceFileInfo);
                if (DEBUG.get().booleanValue()) {
                    node.dump(">");
                }
                if (TRACE) {
                    this.println("// " + node.getText());
                }
                Object ret = node.eval(callstack, this);
                if (callstack.depth() > 1) {
                    throw new InterpreterError("Callstack growing: " + callstack);
                }
                if (ret instanceof ReturnControl) {
                    ret = ((ReturnControl)ret).value;
                }
                if (!this.interactive) continue;
                if (ret != Primitive.VOID) {
                    this.setu("$_", ret);
                    this.setu("$" + ++idx % 10, ret);
                    if (!this.showResults) continue;
                    this.println("--> $" + idx % 10 + " = " + StringUtil.typeValueString(ret));
                    continue;
                }
                if (!this.showResults) continue;
                this.println("--> void");
            }
            catch (ParseException e) {
                this.error("Parser Error: " + e.getMessage(DEBUG.get()));
                if (DEBUG.get().booleanValue()) {
                    e.printStackTrace();
                }
                if (!this.interactive) {
                    this.EOF = true;
                }
                this.parser.reInitInput(this.getIn());
            }
            catch (InterpreterError e) {
                this.error("Internal Error: " + e.getMessage());
                if (this.interactive) continue;
                this.EOF = true;
            }
            catch (TargetError e) {
                this.error("Target Exception: " + e.getMessage());
                if (e.inNativeCode()) {
                    e.printStackTrace(DEBUG.get(), this.getErr());
                }
                if (!this.interactive) {
                    this.EOF = true;
                }
                this.setu("$_e", e.getTarget());
            }
            catch (EvalError e) {
                if (this.interactive) {
                    this.error("Evaluation Error: " + e.getMessage());
                } else {
                    this.error("Evaluation Error: " + e.getRawMessage());
                }
                if (DEBUG.get().booleanValue()) {
                    e.printStackTrace();
                }
                if (this.interactive) continue;
                this.EOF = true;
            }
            catch (Exception e) {
                this.error("Unknown error: " + e);
                if (DEBUG.get().booleanValue()) {
                    e.printStackTrace();
                }
                if (this.interactive) continue;
                this.EOF = true;
            }
            finally {
                this.get_jjtree().reset();
                if (callstack.depth() <= 1) continue;
                callstack.clear();
                callstack.push(this.globalNameSpace);
            }
        }
        if (this.interactive && this.exitOnEOF) {
            System.exit(0);
        }
    }

    /*
     * Exception decompiling
     */
    public Object source(URL url, NameSpace namespace) throws EvalError, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object source(File file, NameSpace namespace) throws EvalError, IOException {
        Interpreter.debug("Sourcing file: ", file);
        try (BufferedReader sourceIn = new BufferedReader(new FileReader(file));){
            Object object = this.eval(sourceIn, namespace, file.getPath());
            return object;
        }
    }

    public Object source(String filename, NameSpace namespace) throws EvalError, IOException {
        return this.source(this.pathToFile(filename), namespace);
    }

    public Object source(URL url) throws EvalError, IOException {
        return this.source(url, this.globalNameSpace);
    }

    public Object source(File file) throws EvalError, IOException {
        return this.source(file, this.globalNameSpace);
    }

    public Object source(String filename) throws EvalError, IOException {
        return this.source(filename, this.globalNameSpace);
    }

    public Object eval(Reader in, NameSpace nameSpace, String sourceFileInfo) throws EvalError {
        Object retVal = null;
        Interpreter.debug("eval: nameSpace = ", nameSpace);
        Interpreter localInterpreter = new Interpreter(in, this.getOut(), this.getErr(), false, nameSpace, this, sourceFileInfo);
        CallStack callstack = new CallStack(nameSpace);
        Node node = null;
        boolean eof = false;
        while (!eof) {
            try {
                eof = localInterpreter.readLine();
                if (localInterpreter.get_jjtree().nodeArity() <= 0) continue;
                node = localInterpreter.get_jjtree().rootNode();
                node.setSourceFile(sourceFileInfo);
                if (TRACE) {
                    this.println("// " + node.getText());
                }
                retVal = node.eval(callstack, localInterpreter);
                if (callstack.depth() > 1) {
                    throw new InterpreterError("Callstack growing: " + callstack);
                }
                if (!(retVal instanceof ReturnControl)) continue;
                retVal = ((ReturnControl)retVal).value;
                break;
            }
            catch (ParseException e) {
                if (DEBUG.get().booleanValue()) {
                    this.error(e.getMessage(DEBUG.get()));
                }
                e.setErrorSourceFile(sourceFileInfo);
                throw e;
            }
            catch (InterpreterError e) {
                throw new EvalError("Sourced file: " + sourceFileInfo + " internal Error: " + e.getMessage(), node, callstack, e);
            }
            catch (TargetError e) {
                if (e.getNode() == null) {
                    e.setNode(node);
                }
                e.reThrow("Sourced file: " + sourceFileInfo);
            }
            catch (EvalError e) {
                if (DEBUG.get().booleanValue()) {
                    e.printStackTrace();
                }
                if (e.getNode() == null) {
                    e.setNode(node);
                }
                e.reThrow("Sourced file: " + sourceFileInfo);
            }
            catch (Exception e) {
                if (DEBUG.get().booleanValue()) {
                    e.printStackTrace();
                }
                throw new EvalError("Sourced file: " + sourceFileInfo + " unknown error: " + e.getMessage(), node, callstack, e);
            }
            finally {
                localInterpreter.get_jjtree().reset();
                if (callstack.depth() <= 1) continue;
                callstack.clear();
                callstack.push(nameSpace);
            }
        }
        return Primitive.unwrap(retVal);
    }

    public Object eval(Reader in) throws EvalError {
        return this.eval(in, this.globalNameSpace, null == this.sourceFileInfo ? "eval stream" : this.sourceFileInfo);
    }

    public Object eval(String statements) throws EvalError {
        Interpreter.debug("eval(String): ", statements);
        return this.eval(statements, this.globalNameSpace);
    }

    public Object eval(String statements, NameSpace nameSpace) throws EvalError {
        return this.eval(new StringReader(this.terminatedScript(statements)), nameSpace, this.showEvalString("inline evaluation", statements));
    }

    String showEvalString(String type, String statement) {
        if (statement.length() > 80) {
            statement = statement.substring(0, 80) + " . . . ";
        }
        return type.concat(" of: ``").concat(statement.replace('\n', ' ').replace('\r', ' ')).concat("''");
    }

    String terminatedScript(String statements) {
        if (statements.endsWith(";")) {
            return statements;
        }
        return statements + ";";
    }

    public Reader getIn() {
        return this.console.getIn();
    }

    public PrintStream getOut() {
        return this.console.getOut();
    }

    public PrintStream getErr() {
        return this.console.getErr();
    }

    public final void println(Object o) {
        this.console.println(o);
    }

    public final void print(Object o) {
        this.console.print(o);
    }

    public final void error(Object o) {
        this.console.error(o);
    }

    public void setOut(PrintStream out) {
        this.console.setOut(out);
    }

    public void setErr(PrintStream err) {
        this.console.setErr(err);
    }

    public static final void debug(Object ... msg) {
        if (DEBUG.get().booleanValue()) {
            StringBuilder sb = new StringBuilder();
            for (Object m : msg) {
                sb.append(m);
            }
            Console.debug.println("// Debug: " + sb.toString());
        }
    }

    public Object get(String name) throws EvalError {
        try {
            Object ret = this.globalNameSpace.get(name, this);
            return Primitive.unwrap(ret);
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(Node.JAVACODE, new CallStack());
        }
    }

    Object getu(String name) {
        try {
            return this.get(name);
        }
        catch (EvalError e) {
            throw new InterpreterError("set: " + e, e);
        }
    }

    public void set(String name, Object value) throws EvalError {
        CallStack callstack = new CallStack(this.globalNameSpace);
        try {
            if (Name.isCompound(name)) {
                this.globalNameSpace.getNameResolver(name).toLHS(callstack, this).assign(value, false);
            } else {
                this.globalNameSpace.setVariable(name, value, false);
            }
        }
        catch (UtilEvalError e) {
            throw e.toEvalError(Node.JAVACODE, callstack);
        }
    }

    void setu(String name, Object value) {
        try {
            this.set(name, value);
        }
        catch (EvalError e) {
            throw new InterpreterError("set: " + e, e);
        }
    }

    public void set(String name, long value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, int value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, double value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, float value) throws EvalError {
        this.set(name, new Primitive(value));
    }

    public void set(String name, boolean value) throws EvalError {
        this.set(name, value ? Primitive.TRUE : Primitive.FALSE);
    }

    public void unset(String name) throws EvalError {
        CallStack callstack = new CallStack();
        try {
            LHS lhs = this.globalNameSpace.getNameResolver(name).toLHS(callstack, this);
            if (lhs.type != 0) {
                throw new EvalError("Can't unset, not a variable: " + name, Node.JAVACODE, new CallStack());
            }
            lhs.nameSpace.unsetVariable(name);
        }
        catch (UtilEvalError e) {
            throw new EvalError(e.getMessage(), Node.JAVACODE, new CallStack(), e);
        }
    }

    public Object getInterface(Class<?> interf) throws EvalError {
        return this.globalNameSpace.getThis(this).getInterface(interf);
    }

    private JJTParserState get_jjtree() {
        return this.parser.jjtree;
    }

    private boolean readLine() throws ParseException {
        try {
            return this.parser.Line();
        }
        catch (ParseException e) {
            this.yield();
            if (this.EOF) {
                return true;
            }
            throw e;
        }
    }

    public void setYieldDelay(int delay) {
        this.yield_for = delay;
    }

    private void yield() {
        if (0 > this.yield_for) {
            return;
        }
        try {
            Thread.sleep(this.yield_for);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void loadRCFiles() {
        try {
            String rcfile = System.getProperty("user.home") + File.separator + ".bshrc";
            this.source(rcfile, this.globalNameSpace);
        }
        catch (Exception e) {
            Interpreter.debug("Could not find rc file: ", e);
        }
    }

    public File pathToFile(String fileName) throws IOException {
        String cwd = (String)this.getu("bsh.cwd");
        File file = new File(fileName);
        if (!file.isAbsolute()) {
            file = new File(cwd + File.separator + fileName);
        }
        return new File(file.getCanonicalPath());
    }

    public static void redirectOutputToFile(String filename) {
        try {
            PrintStream pout = new PrintStream((OutputStream)new FileOutputStream(filename), true, "UTF-8");
            System.setOut(pout);
            System.setErr(pout);
        }
        catch (IOException e) {
            System.err.println("Can't redirect output to file: " + filename);
        }
    }

    public void setClassLoader(ClassLoader externalCL) {
        this.getClassManager().setClassLoader(externalCL);
    }

    public BshClassManager getClassManager() {
        return this.getNameSpace().getClassManager();
    }

    public void setStrictJava(boolean b) {
        this.strictJava = b;
    }

    public boolean getStrictJava() {
        return this.strictJava;
    }

    static void staticInit() {
        try {
            Console.systemLineSeparator = System.getProperty("line.separator");
            Console.debug = System.err;
            DEBUG.set(Boolean.getBoolean("debug"));
            TRACE = Boolean.getBoolean("trace");
            COMPATIBIILTY = Boolean.getBoolean("bsh.compatibility");
            String outfilename = System.getProperty("outfile");
            if (outfilename != null) {
                Interpreter.redirectOutputToFile(outfilename);
            }
        }
        catch (SecurityException e) {
            System.err.println("Could not init static:" + e);
        }
        catch (Exception e) {
            System.err.println("Could not init static(2):" + e);
        }
        catch (Throwable e) {
            System.err.println("Could not init static(3):" + e);
        }
    }

    public String getSourceFileInfo() {
        if (this.sourceFileInfo != null) {
            return this.sourceFileInfo;
        }
        return "<unknown source>";
    }

    public Interpreter getParent() {
        return this.parent;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.setOut(System.out);
        this.setErr(System.err);
    }

    private String getBshPrompt() {
        if (null != this.prompt) {
            return this.prompt;
        }
        try {
            this.prompt = (String)this.eval("getBshPrompt()");
        }
        catch (Exception e) {
            this.prompt = "bsh % ";
        }
        return this.prompt;
    }

    public void setExitOnEOF(boolean value) {
        this.exitOnEOF = value;
    }

    public void setShowResults(boolean showResults) {
        this.showResults = showResults;
    }

    public boolean getShowResults() {
        return this.showResults;
    }

    public boolean getCompatibility() {
        return this.compatibility;
    }

    public void setCompatibility(boolean value) {
        this.compatibility = value;
    }

    public static String getSaveClassesDir() {
        return System.getProperty("bsh.debugClasses");
    }

    public static boolean getSaveClasses() {
        return Interpreter.getSaveClassesDir() != null && !Interpreter.getSaveClassesDir().isEmpty();
    }

    static {
        ResourceBundle b = ResourceBundle.getBundle("version");
        VERSION = b.getString("release") + "." + b.getString("build");
        Interpreter.staticInit();
        SYSTEM_OBJECT = This.getThis(new NameSpace(null, null, "bsh.system"), null);
    }

    public static class Console
    implements ConsoleAssignable,
    Serializable {
        private static final long serialVersionUID = 1L;
        public static String systemLineSeparator = "\n";
        public static transient PrintStream debug;
        private transient Reader in;
        private transient PrintStream out;
        private transient PrintStream err;
        private ConsoleInterface console;

        public Console(ConsoleInterface console) {
            this.console = console;
            this.in = console.getIn();
            this.out = console.getOut();
            debug = this.err = console.getErr();
        }

        public Console(Reader in, PrintStream out, PrintStream err) {
            this.console = null;
            this.in = in;
            this.out = out;
            debug = this.err = err;
        }

        @Override
        public Reader getIn() {
            return this.in;
        }

        @Override
        public PrintStream getOut() {
            if (null == this.out) {
                this.out = System.out;
            }
            return this.out;
        }

        @Override
        public PrintStream getErr() {
            if (null == this.err) {
                this.err = System.err;
            }
            return this.err;
        }

        @Override
        public void println(Object o) {
            if (null != this.console) {
                this.console.println(o);
            } else {
                this.print(o + systemLineSeparator);
            }
        }

        @Override
        public void print(Object o) {
            if (null != this.console) {
                this.console.print(o);
            } else if (null != this.out) {
                this.out.print(o);
                this.out.flush();
            }
        }

        @Override
        public void error(Object o) {
            if (null != this.console) {
                this.console.error("// Error: " + o + systemLineSeparator);
            } else if (null != this.out) {
                this.println("// Error: " + o);
            }
        }

        @Override
        public void prompt(String p) {
            if (null != this.console) {
                this.console.prompt(p);
            } else {
                this.print(p);
            }
        }

        @Override
        public void setIn(Reader in) {
            this.in = in;
        }

        @Override
        public void setOut(PrintStream out) {
            this.out = out;
        }

        @Override
        public void setErr(PrintStream err) {
            this.err = err;
        }
    }
}

